/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2022-01-14 16:28:02 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `abchrgrp_bpspro_db_backup` (
  `bps_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `bps_table_name` text NOT NULL,
  `bps_desc` text NOT NULL,
  `bps_job_type` varchar(9) NOT NULL DEFAULT '',
  `bps_frequency` varchar(7) NOT NULL DEFAULT '',
  `bps_last_job` varchar(30) NOT NULL DEFAULT '',
  `bps_next_job` varchar(30) NOT NULL DEFAULT '',
  `bps_next_job_unix` varchar(10) NOT NULL DEFAULT '',
  `bps_email_zip` varchar(10) NOT NULL DEFAULT '',
  `bps_job_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  UNIQUE KEY `bps_id` (`bps_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `abchrgrp_bpspro_login_security` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `status` varchar(60) NOT NULL DEFAULT '',
  `user_id` varchar(60) NOT NULL DEFAULT '',
  `username` varchar(60) NOT NULL DEFAULT '',
  `public_name` varchar(250) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `role` varchar(15) NOT NULL DEFAULT '',
  `human_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `login_time` varchar(10) NOT NULL DEFAULT '',
  `lockout_time` varchar(10) NOT NULL DEFAULT '',
  `failed_logins` varchar(2) NOT NULL DEFAULT '',
  `ip_address` varchar(45) NOT NULL DEFAULT '',
  `hostname` varchar(60) NOT NULL DEFAULT '',
  `request_uri` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `abchrgrp_bpspro_mscan` (
  `mscan_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `mscan_status` varchar(8) NOT NULL DEFAULT '',
  `mscan_type` varchar(16) NOT NULL DEFAULT '',
  `mscan_path` text NOT NULL,
  `mscan_pattern` text NOT NULL,
  `mscan_skipped` varchar(7) NOT NULL DEFAULT '',
  `mscan_ignored` varchar(6) NOT NULL DEFAULT '',
  `mscan_db_table` varchar(64) NOT NULL DEFAULT '',
  `mscan_db_column` varchar(64) NOT NULL DEFAULT '',
  `mscan_db_pkid` text NOT NULL,
  `mscan_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`mscan_id`),
  UNIQUE KEY `id` (`mscan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `abchrgrp_bpspro_seclog_ignore` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_agent_bot` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `abchrgrp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=73 DEFAULT CHARSET=utf8;

CREATE TABLE `abchrgrp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8;

CREATE TABLE `abchrgrp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

CREATE TABLE `abchrgrp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `abchrgrp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=23397 DEFAULT CHARSET=utf8;

CREATE TABLE `abchrgrp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=764 DEFAULT CHARSET=utf8;

CREATE TABLE `abchrgrp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=1465 DEFAULT CHARSET=utf8;

CREATE TABLE `abchrgrp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `abchrgrp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

CREATE TABLE `abchrgrp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `abchrgrp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

CREATE TABLE `abchrgrp_tm_taskmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `abchrgrp_tm_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `type` varchar(300) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_identifier` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT '0',
  `attempts` int(11) DEFAULT '0',
  `description` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_locked_at` bigint(20) DEFAULT '0',
  `status` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `abchrgrp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;

CREATE TABLE `abchrgrp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=48698 DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1902 DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(20) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `post_name` (`post_name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2786 DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` text,
  `hover` text,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_revslider_settings` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `general` text NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` text NOT NULL,
  `layers` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` text NOT NULL,
  `layers` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=86 DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=261 DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=40 DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(64) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(60) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_woocommerce_api_keys` (
  `key_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `description` longtext,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` longtext,
  `attribute_type` varchar(200) NOT NULL,
  `attribute_orderby` varchar(200) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `download_id` varchar(32) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `order_id` bigint(20) NOT NULL DEFAULT '0',
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`,`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_woocommerce_order_items` (
  `order_item_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `order_item_name` longtext NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `location_code` varchar(255) NOT NULL,
  `tax_rate_id` bigint(20) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type` (`location_type`),
  KEY `location_type_code` (`location_type`,`location_code`(90))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`),
  KEY `tax_rate_class` (`tax_rate_class`),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `apprenz_woocommerce_termmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `woocommerce_term_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `woocommerce_term_id` (`woocommerce_term_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `heratnwp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `heratnwp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

CREATE TABLE `heratnwp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `heratnwp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=4797 DEFAULT CHARSET=utf8;

CREATE TABLE `heratnwp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `heratnwp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `heratnwp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `heratnwp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `heratnwp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `heratnwp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `heratnwp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

CREATE TABLE `heratnwp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `holicolors_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `holicolors_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

CREATE TABLE `holicolors_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `holicolors_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=63276 DEFAULT CHARSET=utf8;

CREATE TABLE `holicolors_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2313 DEFAULT CHARSET=utf8;

CREATE TABLE `holicolors_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(20) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=550 DEFAULT CHARSET=utf8;

CREATE TABLE `holicolors_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `holicolors_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=utf8;

CREATE TABLE `holicolors_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=utf8;

CREATE TABLE `holicolors_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=40 DEFAULT CHARSET=utf8;

CREATE TABLE `holicolors_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(64) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(60) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_bpspro_db_backup` (
  `bps_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `bps_table_name` text NOT NULL,
  `bps_desc` text NOT NULL,
  `bps_job_type` varchar(9) NOT NULL DEFAULT '',
  `bps_frequency` varchar(7) NOT NULL DEFAULT '',
  `bps_last_job` varchar(30) NOT NULL DEFAULT '',
  `bps_next_job` varchar(30) NOT NULL DEFAULT '',
  `bps_next_job_unix` varchar(10) NOT NULL DEFAULT '',
  `bps_email_zip` varchar(10) NOT NULL DEFAULT '',
  `bps_job_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  UNIQUE KEY `bps_id` (`bps_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_bpspro_login_security` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `status` varchar(60) NOT NULL DEFAULT '',
  `user_id` varchar(60) NOT NULL DEFAULT '',
  `username` varchar(60) NOT NULL DEFAULT '',
  `public_name` varchar(250) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `role` varchar(15) NOT NULL DEFAULT '',
  `human_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `login_time` varchar(10) NOT NULL DEFAULT '',
  `lockout_time` varchar(10) NOT NULL DEFAULT '',
  `failed_logins` varchar(2) NOT NULL DEFAULT '',
  `ip_address` varchar(45) NOT NULL DEFAULT '',
  `hostname` varchar(60) NOT NULL DEFAULT '',
  `request_uri` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_bpspro_seclog_ignore` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_agent_bot` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_cb_contact_form` (
  `form_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_name` varchar(200) NOT NULL,
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_cb_create_control_form` (
  `control_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `field_id` int(50) NOT NULL,
  `form_id` int(10) NOT NULL,
  `column_dynamicId` int(10) NOT NULL,
  `sorting_order` int(10) NOT NULL,
  PRIMARY KEY (`control_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_cb_dynamic_settings` (
  `dynamic_settings_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dynamicId` int(10) NOT NULL,
  `dynamic_settings_key` varchar(100) NOT NULL,
  `dynamic_settings_value` text NOT NULL,
  PRIMARY KEY (`dynamic_settings_id`)
) ENGINE=MyISAM AUTO_INCREMENT=87 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_cb_email_template_admin` (
  `email_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email_to` varchar(100) NOT NULL,
  `email_from` varchar(100) NOT NULL,
  `body_content` text NOT NULL,
  `subject` varchar(400) NOT NULL,
  `send_to` int(1) NOT NULL,
  `form_id` int(10) NOT NULL,
  `from_name` varchar(200) NOT NULL,
  `reply_to` varchar(200) NOT NULL,
  `cc` varchar(200) NOT NULL,
  `bcc` varchar(200) NOT NULL,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`email_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_cb_form_settings_table` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) NOT NULL,
  `form_message_key` varchar(200) NOT NULL,
  `form_message_value` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_cb_frontend_data_table` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) NOT NULL,
  `field_Id` int(10) NOT NULL,
  `dynamic_control_id` int(10) NOT NULL,
  `dynamic_frontend_value` text NOT NULL,
  `form_submit_id` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=373 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_cb_frontend_forms_table` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) NOT NULL,
  `submit_id` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=94 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_cb_layout_settings_table` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) NOT NULL,
  `form_settings_key` varchar(200) NOT NULL,
  `form_settings_value` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=101 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_cb_licensing` (
  `licensing_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(10) NOT NULL,
  `type` varchar(100) NOT NULL,
  `url` text NOT NULL,
  `api_key` text NOT NULL,
  `order_id` varchar(100) NOT NULL,
  PRIMARY KEY (`licensing_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_cb_roles_capability` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `roles_capability_key` varchar(200) NOT NULL,
  `roles_capability_value` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=21464 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=7140 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

CREATE TABLE `imenejallouli_gmp_htmltype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(32) NOT NULL,
  `description` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `label` (`label`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_gmp_icons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `description` text,
  `path` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=129 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_gmp_maps` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(125) NOT NULL,
  `description` text,
  `params` text,
  `html_options` text NOT NULL,
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_gmp_marker_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) DEFAULT NULL,
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_gmp_markers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(125) NOT NULL,
  `description` text,
  `coord_x` varchar(30) NOT NULL,
  `coord_y` varchar(30) NOT NULL,
  `icon` int(11) DEFAULT NULL,
  `map_id` int(11) DEFAULT NULL,
  `marker_group_id` int(11) DEFAULT NULL,
  `address` text,
  `animation` int(1) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_gmp_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(64) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `type_id` smallint(3) NOT NULL DEFAULT '0',
  `params` text,
  `has_tab` tinyint(1) NOT NULL DEFAULT '0',
  `label` varchar(128) DEFAULT NULL,
  `description` text,
  `ex_plug_dir` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_gmp_modules_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(64) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_gmp_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(64) CHARACTER SET latin1 NOT NULL,
  `value` text,
  `label` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `description` text CHARACTER SET latin1,
  `htmltype_id` smallint(2) NOT NULL DEFAULT '1',
  `params` text,
  `cat_id` mediumint(3) DEFAULT '0',
  `sort_order` mediumint(3) DEFAULT '0',
  `value_type` varchar(16) CHARACTER SET latin1 DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_gmp_options_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(128) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_gmp_usage_stat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(64) NOT NULL,
  `visits` int(11) NOT NULL DEFAULT '0',
  `spent_time` int(11) NOT NULL DEFAULT '0',
  `modify_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=87532 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=290 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(20) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `post_name` (`post_name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=197 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8;

CREATE TABLE `imenejallouli_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(64) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(60) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `malekoptique_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=139 DEFAULT CHARSET=utf8;

CREATE TABLE `malekoptique_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8;

CREATE TABLE `malekoptique_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `malekoptique_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=26705 DEFAULT CHARSET=utf8;

CREATE TABLE `malekoptique_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=354 DEFAULT CHARSET=utf8;

CREATE TABLE `malekoptique_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(20) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=123 DEFAULT CHARSET=utf8;

CREATE TABLE `malekoptique_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `malekoptique_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `malekoptique_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `malekoptique_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;

CREATE TABLE `malekoptique_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(64) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(60) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `sts_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `sts_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `sts_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `sts_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=11764 DEFAULT CHARSET=utf8;

CREATE TABLE `sts_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8;

CREATE TABLE `sts_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(20) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

CREATE TABLE `sts_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `sts_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `sts_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `sts_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;

CREATE TABLE `sts_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(64) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(60) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_holi_bpspro_db_backup` (
  `bps_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `bps_table_name` text NOT NULL,
  `bps_desc` text NOT NULL,
  `bps_job_type` varchar(9) NOT NULL DEFAULT '',
  `bps_frequency` varchar(7) NOT NULL DEFAULT '',
  `bps_last_job` varchar(30) NOT NULL DEFAULT '',
  `bps_next_job` varchar(30) NOT NULL DEFAULT '',
  `bps_next_job_unix` varchar(10) NOT NULL DEFAULT '',
  `bps_email_zip` varchar(10) NOT NULL DEFAULT '',
  `bps_job_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  UNIQUE KEY `bps_id` (`bps_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_holi_bpspro_login_security` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `status` varchar(60) NOT NULL DEFAULT '',
  `user_id` varchar(60) NOT NULL DEFAULT '',
  `username` varchar(60) NOT NULL DEFAULT '',
  `public_name` varchar(250) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `role` varchar(15) NOT NULL DEFAULT '',
  `human_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `login_time` varchar(10) NOT NULL DEFAULT '',
  `lockout_time` varchar(10) NOT NULL DEFAULT '',
  `failed_logins` varchar(2) NOT NULL DEFAULT '',
  `ip_address` varchar(45) NOT NULL DEFAULT '',
  `hostname` varchar(60) NOT NULL DEFAULT '',
  `request_uri` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_holi_bpspro_mscan` (
  `mscan_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `mscan_status` varchar(8) NOT NULL DEFAULT '',
  `mscan_type` varchar(16) NOT NULL DEFAULT '',
  `mscan_path` text NOT NULL,
  `mscan_pattern` text NOT NULL,
  `mscan_skipped` varchar(7) NOT NULL DEFAULT '',
  `mscan_ignored` varchar(6) NOT NULL DEFAULT '',
  `mscan_db_table` varchar(64) NOT NULL DEFAULT '',
  `mscan_db_column` varchar(64) NOT NULL DEFAULT '',
  `mscan_db_pkid` text NOT NULL,
  `mscan_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`mscan_id`),
  UNIQUE KEY `id` (`mscan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_holi_bpspro_seclog_ignore` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_agent_bot` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_holi_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_holi_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=34633 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1272 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1829 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_holi_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_holi_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_holi_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_holi_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_holi_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_holi_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  `term_order` int(4) DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `fk_wc_download_log_permission_id` FOREIGN KEY (`permission_id`) REFERENCES `wp_holi_woocommerce_downloadable_product_permissions` (`permission_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_key`),
  UNIQUE KEY `session_id` (`session_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_xcloner_scheduler` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `recurrence` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_at` datetime DEFAULT NULL,
  `remote_storage` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(1) NOT NULL,
  `last_backup` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=111 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_holi_yoast_seo_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT NULL,
  `incoming_link_count` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: abchrgrp_duplicator_packages */
INSERT INTO `abchrgrp_duplicator_packages` VALUES("2", "20201203_abchirgroupimportexportwhol", "9179193c3e47c22a8518_20201203165311", "100", "2020-12-03 16:53:26", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-12-03 16:53:11\";s:7:\"Version\";s:6:\"1.3.40\";s:9:\"VersionWP\";s:6:\"4.7.19\";s:9:\"VersionDB\";s:6:\"5.6.50\";s:10:\"VersionPHP\";s:6:\"5.6.40\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:2;s:4:\"Name\";s:36:\"20201203_abchirgroupimportexportwhol\";s:4:\"Hash\";s:35:\"9179193c3e47c22a8518_20201203165311\";s:8:\"NameHash\";s:72:\"20201203_abchirgroupimportexportwhol_9179193c3e47c22a8518_20201203165311\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:82:\"20201203_abchirgroupimportexportwhol_9179193c3e47c22a8518_20201203165311_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"10.83 sec.\";s:7:\"ExeSize\";s:7:\"61.33KB\";s:7:\"ZipSize\";s:7:\"46.16MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:84:\"20201203_abchirgroupimportexportwhol_9179193c3e47c22a8518_20201203165311_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:28:\"/home/maento/www/abchirgroup\";s:4:\"Size\";i:48407041;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:2871;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:37:\"/home/maento/www/abchirgroup/wp-admin\";i:1;s:47:\"/home/maento/www/abchirgroup/wp-content/uploads\";i:2;s:49:\"/home/maento/www/abchirgroup/wp-content/languages\";i:3;s:46:\"/home/maento/www/abchirgroup/wp-content/themes\";i:4;s:40:\"/home/maento/www/abchirgroup/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:28:\"/home/maento/www/abchirgroup\";i:1;s:39:\"/home/maento/www/abchirgroup/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:40:\"/home/maento/www/abchirgroup/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:86:\"20201203_abchirgroupimportexportwhol_9179193c3e47c22a8518_20201203165311_installer.php\";s:4:\"Size\";i:62805;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:8988127;s:4:\"File\";s:85:\"20201203_abchirgroupimportexportwhol_9179193c3e47c22a8518_20201203165311_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:3:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:15:\"utf8_general_ci\";i:2;s:18:\"utf8mb4_unicode_ci\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:10:\"maentorenz\";s:15:\"tablesBaseCount\";i:163;s:16:\"tablesFinalCount\";i:163;s:14:\"tablesRowCount\";s:6:\"11,403\";s:16:\"tablesSizeOnDisk\";s:7:\"14.15MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.6.50\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:163:{s:25:\"abchrgrp_bpspro_db_backup\";s:1:\"0\";s:30:\"abchrgrp_bpspro_login_security\";s:1:\"0\";s:21:\"abchrgrp_bpspro_mscan\";s:1:\"0\";s:29:\"abchrgrp_bpspro_seclog_ignore\";s:1:\"0\";s:20:\"abchrgrp_commentmeta\";s:1:\"0\";s:17:\"abchrgrp_comments\";s:1:\"0\";s:28:\"abchrgrp_duplicator_packages\";s:1:\"2\";s:14:\"abchrgrp_links\";s:1:\"0\";s:16:\"abchrgrp_options\";s:3:\"164\";s:17:\"abchrgrp_postmeta\";s:3:\"303\";s:14:\"abchrgrp_posts\";s:3:\"130\";s:27:\"abchrgrp_term_relationships\";s:2:\"25\";s:22:\"abchrgrp_term_taxonomy\";s:2:\"16\";s:17:\"abchrgrp_termmeta\";s:1:\"0\";s:14:\"abchrgrp_terms\";s:2:\"16\";s:17:\"abchrgrp_usermeta\";s:2:\"21\";s:14:\"abchrgrp_users\";s:1:\"1\";s:19:\"apprenz_commentmeta\";s:1:\"0\";s:16:\"apprenz_comments\";s:1:\"5\";s:13:\"apprenz_links\";s:1:\"0\";s:15:\"apprenz_options\";s:4:\"2506\";s:16:\"apprenz_postmeta\";s:4:\"1328\";s:13:\"apprenz_posts\";s:3:\"264\";s:21:\"apprenz_revslider_css\";s:2:\"51\";s:34:\"apprenz_revslider_layer_animations\";s:1:\"4\";s:26:\"apprenz_revslider_settings\";s:1:\"1\";s:25:\"apprenz_revslider_sliders\";s:1:\"5\";s:24:\"apprenz_revslider_slides\";s:1:\"7\";s:31:\"apprenz_revslider_static_slides\";s:1:\"0\";s:26:\"apprenz_term_relationships\";s:3:\"241\";s:21:\"apprenz_term_taxonomy\";s:2:\"85\";s:13:\"apprenz_terms\";s:2:\"85\";s:16:\"apprenz_usermeta\";s:2:\"39\";s:13:\"apprenz_users\";s:1:\"2\";s:28:\"apprenz_woocommerce_api_keys\";s:1:\"0\";s:40:\"apprenz_woocommerce_attribute_taxonomies\";s:1:\"0\";s:52:\"apprenz_woocommerce_downloadable_product_permissions\";s:1:\"0\";s:34:\"apprenz_woocommerce_order_itemmeta\";s:1:\"0\";s:31:\"apprenz_woocommerce_order_items\";s:1:\"0\";s:38:\"apprenz_woocommerce_tax_rate_locations\";s:1:\"0\";s:29:\"apprenz_woocommerce_tax_rates\";s:1:\"0\";s:28:\"apprenz_woocommerce_termmeta\";s:1:\"0\";s:20:\"heratnwp_commentmeta\";s:1:\"0\";s:17:\"heratnwp_comments\";s:2:\"19\";s:14:\"heratnwp_links\";s:1:\"0\";s:16:\"heratnwp_options\";s:3:\"132\";s:17:\"heratnwp_postmeta\";s:1:\"1\";s:14:\"heratnwp_posts\";s:1:\"3\";s:27:\"heratnwp_term_relationships\";s:1:\"1\";s:22:\"heratnwp_term_taxonomy\";s:1:\"1\";s:17:\"heratnwp_termmeta\";s:1:\"0\";s:14:\"heratnwp_terms\";s:1:\"1\";s:17:\"heratnwp_usermeta\";s:2:\"16\";s:14:\"heratnwp_users\";s:1:\"1\";s:22:\"holicolors_commentmeta\";s:1:\"0\";s:19:\"holicolors_comments\";s:1:\"6\";s:16:\"holicolors_links\";s:1:\"0\";s:18:\"holicolors_options\";s:3:\"353\";s:19:\"holicolors_postmeta\";s:4:\"1170\";s:16:\"holicolors_posts\";s:3:\"157\";s:29:\"holicolors_term_relationships\";s:2:\"38\";s:24:\"holicolors_term_taxonomy\";s:2:\"42\";s:16:\"holicolors_terms\";s:2:\"42\";s:19:\"holicolors_usermeta\";s:2:\"38\";s:16:\"holicolors_users\";s:1:\"2\";s:30:\"imenejallouli_bpspro_db_backup\";s:1:\"0\";s:35:\"imenejallouli_bpspro_login_security\";s:1:\"0\";s:34:\"imenejallouli_bpspro_seclog_ignore\";s:1:\"0\";s:29:\"imenejallouli_cb_contact_form\";s:1:\"2\";s:36:\"imenejallouli_cb_create_control_form\";s:1:\"8\";s:33:\"imenejallouli_cb_dynamic_settings\";s:2:\"86\";s:37:\"imenejallouli_cb_email_template_admin\";s:1:\"4\";s:36:\"imenejallouli_cb_form_settings_table\";s:2:\"12\";s:36:\"imenejallouli_cb_frontend_data_table\";s:3:\"372\";s:37:\"imenejallouli_cb_frontend_forms_table\";s:2:\"93\";s:38:\"imenejallouli_cb_layout_settings_table\";s:3:\"100\";s:26:\"imenejallouli_cb_licensing\";s:1:\"1\";s:33:\"imenejallouli_cb_roles_capability\";s:2:\"15\";s:25:\"imenejallouli_commentmeta\";s:3:\"189\";s:22:\"imenejallouli_comments\";s:2:\"64\";s:33:\"imenejallouli_duplicator_packages\";s:1:\"2\";s:26:\"imenejallouli_gmp_htmltype\";s:2:\"18\";s:23:\"imenejallouli_gmp_icons\";s:3:\"128\";s:22:\"imenejallouli_gmp_maps\";s:1:\"1\";s:31:\"imenejallouli_gmp_marker_groups\";s:1:\"1\";s:25:\"imenejallouli_gmp_markers\";s:1:\"1\";s:25:\"imenejallouli_gmp_modules\";s:2:\"12\";s:30:\"imenejallouli_gmp_modules_type\";s:1:\"7\";s:25:\"imenejallouli_gmp_options\";s:1:\"2\";s:36:\"imenejallouli_gmp_options_categories\";s:1:\"4\";s:28:\"imenejallouli_gmp_usage_stat\";s:2:\"10\";s:19:\"imenejallouli_links\";s:1:\"0\";s:21:\"imenejallouli_options\";s:3:\"486\";s:22:\"imenejallouli_postmeta\";s:3:\"219\";s:19:\"imenejallouli_posts\";s:2:\"23\";s:32:\"imenejallouli_term_relationships\";s:2:\"11\";s:27:\"imenejallouli_term_taxonomy\";s:1:\"3\";s:19:\"imenejallouli_terms\";s:1:\"3\";s:22:\"imenejallouli_usermeta\";s:2:\"33\";s:19:\"imenejallouli_users\";s:1:\"1\";s:24:\"malekoptique_commentmeta\";s:1:\"9\";s:21:\"malekoptique_comments\";s:1:\"3\";s:18:\"malekoptique_links\";s:1:\"0\";s:20:\"malekoptique_options\";s:3:\"298\";s:21:\"malekoptique_postmeta\";s:3:\"220\";s:18:\"malekoptique_posts\";s:2:\"83\";s:31:\"malekoptique_term_relationships\";s:1:\"5\";s:26:\"malekoptique_term_taxonomy\";s:1:\"3\";s:18:\"malekoptique_terms\";s:1:\"3\";s:21:\"malekoptique_usermeta\";s:2:\"22\";s:18:\"malekoptique_users\";s:1:\"1\";s:15:\"sts_commentmeta\";s:1:\"0\";s:12:\"sts_comments\";s:1:\"0\";s:9:\"sts_links\";s:1:\"0\";s:11:\"sts_options\";s:3:\"127\";s:12:\"sts_postmeta\";s:2:\"26\";s:9:\"sts_posts\";s:2:\"15\";s:22:\"sts_term_relationships\";s:1:\"3\";s:17:\"sts_term_taxonomy\";s:1:\"2\";s:9:\"sts_terms\";s:1:\"2\";s:12:\"sts_usermeta\";s:2:\"23\";s:9:\"sts_users\";s:1:\"1\";s:24:\"wp_holi_bpspro_db_backup\";s:1:\"1\";s:29:\"wp_holi_bpspro_login_security\";s:1:\"3\";s:20:\"wp_holi_bpspro_mscan\";s:1:\"0\";s:28:\"wp_holi_bpspro_seclog_ignore\";s:1:\"0\";s:19:\"wp_holi_commentmeta\";s:1:\"0\";s:16:\"wp_holi_comments\";s:1:\"0\";s:13:\"wp_holi_links\";s:1:\"0\";s:15:\"wp_holi_options\";s:3:\"423\";s:16:\"wp_holi_postmeta\";s:3:\"518\";s:13:\"wp_holi_posts\";s:3:\"133\";s:21:\"wp_holi_revslider_css\";s:3:\"109\";s:34:\"wp_holi_revslider_layer_animations\";s:1:\"0\";s:29:\"wp_holi_revslider_navigations\";s:1:\"0\";s:25:\"wp_holi_revslider_sliders\";s:1:\"0\";s:24:\"wp_holi_revslider_slides\";s:1:\"0\";s:31:\"wp_holi_revslider_static_slides\";s:1:\"0\";s:26:\"wp_holi_term_relationships\";s:2:\"16\";s:21:\"wp_holi_term_taxonomy\";s:2:\"22\";s:16:\"wp_holi_termmeta\";s:1:\"0\";s:13:\"wp_holi_terms\";s:2:\"22\";s:16:\"wp_holi_usermeta\";s:2:\"48\";s:13:\"wp_holi_users\";s:1:\"2\";s:23:\"wp_holi_wc_download_log\";s:1:\"0\";s:19:\"wp_holi_wc_webhooks\";s:1:\"0\";s:28:\"wp_holi_woocommerce_api_keys\";s:1:\"0\";s:40:\"wp_holi_woocommerce_attribute_taxonomies\";s:1:\"0\";s:52:\"wp_holi_woocommerce_downloadable_product_permissions\";s:1:\"0\";s:23:\"wp_holi_woocommerce_log\";s:1:\"0\";s:34:\"wp_holi_woocommerce_order_itemmeta\";s:1:\"0\";s:31:\"wp_holi_woocommerce_order_items\";s:1:\"0\";s:37:\"wp_holi_woocommerce_payment_tokenmeta\";s:1:\"0\";s:34:\"wp_holi_woocommerce_payment_tokens\";s:1:\"0\";s:28:\"wp_holi_woocommerce_sessions\";s:1:\"0\";s:43:\"wp_holi_woocommerce_shipping_zone_locations\";s:1:\"0\";s:41:\"wp_holi_woocommerce_shipping_zone_methods\";s:1:\"0\";s:34:\"wp_holi_woocommerce_shipping_zones\";s:1:\"0\";s:38:\"wp_holi_woocommerce_tax_rate_locations\";s:1:\"0\";s:29:\"wp_holi_woocommerce_tax_rates\";s:1:\"0\";s:25:\"wp_holi_xcloner_scheduler\";s:1:\"0\";s:23:\"wp_holi_yoast_seo_links\";s:2:\"22\";s:22:\"wp_holi_yoast_seo_meta\";s:2:\"34\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:146:\"/home/maento/www/abchirgroup/wp-content/backups-dup-lite/tmp/20201203_abchirgroupimportexportwhol_9179193c3e47c22a8518_20201203165311_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-12-03 16:53:11\";s:7:\"Version\";s:6:\"1.3.40\";s:9:\"VersionWP\";s:6:\"4.7.19\";s:9:\"VersionDB\";s:6:\"5.6.50\";s:10:\"VersionPHP\";s:6:\"5.6.40\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:36:\"20201203_abchirgroupimportexportwhol\";s:4:\"Hash\";s:35:\"9179193c3e47c22a8518_20201203165311\";s:8:\"NameHash\";s:72:\"20201203_abchirgroupimportexportwhol_9179193c3e47c22a8518_20201203165311\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:74;s:8:\"Database\";r:88;s:13:\"BuildProgress\";r:285;}}}");
INSERT INTO `abchrgrp_duplicator_packages` VALUES("3", "20201203_abchirgroupimportexportwhol", "1ad52f01835d41883353_20201229090225", "100", "2020-12-29 09:02:34", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-12-29 09:02:25\";s:7:\"Version\";s:6:\"1.3.40\";s:9:\"VersionWP\";s:5:\"5.5.3\";s:9:\"VersionDB\";s:6:\"5.6.50\";s:10:\"VersionPHP\";s:6:\"7.3.20\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:3;s:4:\"Name\";s:36:\"20201203_abchirgroupimportexportwhol\";s:4:\"Hash\";s:35:\"1ad52f01835d41883353_20201229090225\";s:8:\"NameHash\";s:72:\"20201203_abchirgroupimportexportwhol_1ad52f01835d41883353_20201229090225\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:82:\"20201203_abchirgroupimportexportwhol_1ad52f01835d41883353_20201229090225_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"12.95 sec.\";s:7:\"ExeSize\";s:7:\"61.33KB\";s:7:\"ZipSize\";s:7:\"52.55MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:84:\"20201203_abchirgroupimportexportwhol_1ad52f01835d41883353_20201229090225_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:28:\"/home/maento/www/abchirgroup\";s:4:\"Size\";i:55099727;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:4275;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:37:\"/home/maento/www/abchirgroup/wp-admin\";i:1;s:47:\"/home/maento/www/abchirgroup/wp-content/uploads\";i:2;s:49:\"/home/maento/www/abchirgroup/wp-content/languages\";i:3;s:46:\"/home/maento/www/abchirgroup/wp-content/themes\";i:4;s:40:\"/home/maento/www/abchirgroup/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:28:\"/home/maento/www/abchirgroup\";i:1;s:39:\"/home/maento/www/abchirgroup/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:40:\"/home/maento/www/abchirgroup/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:86:\"20201203_abchirgroupimportexportwhol_1ad52f01835d41883353_20201229090225_installer.php\";s:4:\"Size\";i:62805;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:8847867;s:4:\"File\";s:85:\"20201203_abchirgroupimportexportwhol_1ad52f01835d41883353_20201229090225_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:3:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:15:\"utf8_general_ci\";i:2;s:18:\"utf8mb4_unicode_ci\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:10:\"maentorenz\";s:15:\"tablesBaseCount\";i:165;s:16:\"tablesFinalCount\";i:165;s:14:\"tablesRowCount\";s:6:\"11,519\";s:16:\"tablesSizeOnDisk\";s:7:\"14.41MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.6.50\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:165:{s:25:\"abchrgrp_bpspro_db_backup\";s:1:\"0\";s:30:\"abchrgrp_bpspro_login_security\";s:1:\"0\";s:21:\"abchrgrp_bpspro_mscan\";s:1:\"0\";s:29:\"abchrgrp_bpspro_seclog_ignore\";s:1:\"0\";s:20:\"abchrgrp_commentmeta\";s:1:\"0\";s:17:\"abchrgrp_comments\";s:1:\"0\";s:28:\"abchrgrp_duplicator_packages\";s:1:\"2\";s:14:\"abchrgrp_links\";s:1:\"0\";s:16:\"abchrgrp_options\";s:3:\"220\";s:17:\"abchrgrp_postmeta\";s:3:\"303\";s:14:\"abchrgrp_posts\";s:2:\"96\";s:27:\"abchrgrp_term_relationships\";s:2:\"25\";s:22:\"abchrgrp_term_taxonomy\";s:2:\"16\";s:17:\"abchrgrp_termmeta\";s:1:\"0\";s:14:\"abchrgrp_terms\";s:2:\"16\";s:20:\"abchrgrp_tm_taskmeta\";s:1:\"0\";s:17:\"abchrgrp_tm_tasks\";s:1:\"0\";s:17:\"abchrgrp_usermeta\";s:2:\"23\";s:14:\"abchrgrp_users\";s:1:\"1\";s:19:\"apprenz_commentmeta\";s:1:\"0\";s:16:\"apprenz_comments\";s:1:\"5\";s:13:\"apprenz_links\";s:1:\"0\";s:15:\"apprenz_options\";s:4:\"2506\";s:16:\"apprenz_postmeta\";s:4:\"1328\";s:13:\"apprenz_posts\";s:3:\"264\";s:21:\"apprenz_revslider_css\";s:2:\"51\";s:34:\"apprenz_revslider_layer_animations\";s:1:\"4\";s:26:\"apprenz_revslider_settings\";s:1:\"1\";s:25:\"apprenz_revslider_sliders\";s:1:\"5\";s:24:\"apprenz_revslider_slides\";s:1:\"7\";s:31:\"apprenz_revslider_static_slides\";s:1:\"0\";s:26:\"apprenz_term_relationships\";s:3:\"241\";s:21:\"apprenz_term_taxonomy\";s:2:\"85\";s:13:\"apprenz_terms\";s:2:\"85\";s:16:\"apprenz_usermeta\";s:2:\"39\";s:13:\"apprenz_users\";s:1:\"2\";s:28:\"apprenz_woocommerce_api_keys\";s:1:\"0\";s:40:\"apprenz_woocommerce_attribute_taxonomies\";s:1:\"0\";s:52:\"apprenz_woocommerce_downloadable_product_permissions\";s:1:\"0\";s:34:\"apprenz_woocommerce_order_itemmeta\";s:1:\"0\";s:31:\"apprenz_woocommerce_order_items\";s:1:\"0\";s:38:\"apprenz_woocommerce_tax_rate_locations\";s:1:\"0\";s:29:\"apprenz_woocommerce_tax_rates\";s:1:\"0\";s:28:\"apprenz_woocommerce_termmeta\";s:1:\"0\";s:20:\"heratnwp_commentmeta\";s:1:\"0\";s:17:\"heratnwp_comments\";s:2:\"19\";s:14:\"heratnwp_links\";s:1:\"0\";s:16:\"heratnwp_options\";s:3:\"132\";s:17:\"heratnwp_postmeta\";s:1:\"1\";s:14:\"heratnwp_posts\";s:1:\"3\";s:27:\"heratnwp_term_relationships\";s:1:\"1\";s:22:\"heratnwp_term_taxonomy\";s:1:\"1\";s:17:\"heratnwp_termmeta\";s:1:\"0\";s:14:\"heratnwp_terms\";s:1:\"1\";s:17:\"heratnwp_usermeta\";s:2:\"16\";s:14:\"heratnwp_users\";s:1:\"1\";s:22:\"holicolors_commentmeta\";s:1:\"0\";s:19:\"holicolors_comments\";s:1:\"6\";s:16:\"holicolors_links\";s:1:\"0\";s:18:\"holicolors_options\";s:3:\"353\";s:19:\"holicolors_postmeta\";s:4:\"1170\";s:16:\"holicolors_posts\";s:3:\"157\";s:29:\"holicolors_term_relationships\";s:2:\"38\";s:24:\"holicolors_term_taxonomy\";s:2:\"42\";s:16:\"holicolors_terms\";s:2:\"42\";s:19:\"holicolors_usermeta\";s:2:\"38\";s:16:\"holicolors_users\";s:1:\"2\";s:30:\"imenejallouli_bpspro_db_backup\";s:1:\"0\";s:35:\"imenejallouli_bpspro_login_security\";s:1:\"0\";s:34:\"imenejallouli_bpspro_seclog_ignore\";s:1:\"0\";s:29:\"imenejallouli_cb_contact_form\";s:1:\"2\";s:36:\"imenejallouli_cb_create_control_form\";s:1:\"8\";s:33:\"imenejallouli_cb_dynamic_settings\";s:2:\"86\";s:37:\"imenejallouli_cb_email_template_admin\";s:1:\"4\";s:36:\"imenejallouli_cb_form_settings_table\";s:2:\"12\";s:36:\"imenejallouli_cb_frontend_data_table\";s:3:\"372\";s:37:\"imenejallouli_cb_frontend_forms_table\";s:2:\"93\";s:38:\"imenejallouli_cb_layout_settings_table\";s:3:\"100\";s:26:\"imenejallouli_cb_licensing\";s:1:\"1\";s:33:\"imenejallouli_cb_roles_capability\";s:2:\"15\";s:25:\"imenejallouli_commentmeta\";s:3:\"252\";s:22:\"imenejallouli_comments\";s:2:\"85\";s:33:\"imenejallouli_duplicator_packages\";s:1:\"2\";s:26:\"imenejallouli_gmp_htmltype\";s:2:\"18\";s:23:\"imenejallouli_gmp_icons\";s:3:\"128\";s:22:\"imenejallouli_gmp_maps\";s:1:\"1\";s:31:\"imenejallouli_gmp_marker_groups\";s:1:\"1\";s:25:\"imenejallouli_gmp_markers\";s:1:\"1\";s:25:\"imenejallouli_gmp_modules\";s:2:\"12\";s:30:\"imenejallouli_gmp_modules_type\";s:1:\"7\";s:25:\"imenejallouli_gmp_options\";s:1:\"2\";s:36:\"imenejallouli_gmp_options_categories\";s:1:\"4\";s:28:\"imenejallouli_gmp_usage_stat\";s:2:\"10\";s:19:\"imenejallouli_links\";s:1:\"0\";s:21:\"imenejallouli_options\";s:3:\"485\";s:22:\"imenejallouli_postmeta\";s:3:\"219\";s:19:\"imenejallouli_posts\";s:2:\"23\";s:32:\"imenejallouli_term_relationships\";s:2:\"11\";s:27:\"imenejallouli_term_taxonomy\";s:1:\"3\";s:19:\"imenejallouli_terms\";s:1:\"3\";s:22:\"imenejallouli_usermeta\";s:2:\"33\";s:19:\"imenejallouli_users\";s:1:\"1\";s:24:\"malekoptique_commentmeta\";s:1:\"9\";s:21:\"malekoptique_comments\";s:1:\"3\";s:18:\"malekoptique_links\";s:1:\"0\";s:20:\"malekoptique_options\";s:3:\"298\";s:21:\"malekoptique_postmeta\";s:3:\"220\";s:18:\"malekoptique_posts\";s:2:\"83\";s:31:\"malekoptique_term_relationships\";s:1:\"5\";s:26:\"malekoptique_term_taxonomy\";s:1:\"3\";s:18:\"malekoptique_terms\";s:1:\"3\";s:21:\"malekoptique_usermeta\";s:2:\"22\";s:18:\"malekoptique_users\";s:1:\"1\";s:15:\"sts_commentmeta\";s:1:\"0\";s:12:\"sts_comments\";s:1:\"0\";s:9:\"sts_links\";s:1:\"0\";s:11:\"sts_options\";s:3:\"127\";s:12:\"sts_postmeta\";s:2:\"26\";s:9:\"sts_posts\";s:2:\"15\";s:22:\"sts_term_relationships\";s:1:\"3\";s:17:\"sts_term_taxonomy\";s:1:\"2\";s:9:\"sts_terms\";s:1:\"2\";s:12:\"sts_usermeta\";s:2:\"23\";s:9:\"sts_users\";s:1:\"1\";s:24:\"wp_holi_bpspro_db_backup\";s:1:\"1\";s:29:\"wp_holi_bpspro_login_security\";s:1:\"3\";s:20:\"wp_holi_bpspro_mscan\";s:1:\"0\";s:28:\"wp_holi_bpspro_seclog_ignore\";s:1:\"0\";s:19:\"wp_holi_commentmeta\";s:1:\"0\";s:16:\"wp_holi_comments\";s:1:\"0\";s:13:\"wp_holi_links\";s:1:\"0\";s:15:\"wp_holi_options\";s:3:\"431\";s:16:\"wp_holi_postmeta\";s:3:\"518\";s:13:\"wp_holi_posts\";s:3:\"133\";s:21:\"wp_holi_revslider_css\";s:3:\"109\";s:34:\"wp_holi_revslider_layer_animations\";s:1:\"0\";s:29:\"wp_holi_revslider_navigations\";s:1:\"0\";s:25:\"wp_holi_revslider_sliders\";s:1:\"0\";s:24:\"wp_holi_revslider_slides\";s:1:\"0\";s:31:\"wp_holi_revslider_static_slides\";s:1:\"0\";s:26:\"wp_holi_term_relationships\";s:2:\"16\";s:21:\"wp_holi_term_taxonomy\";s:2:\"22\";s:16:\"wp_holi_termmeta\";s:1:\"0\";s:13:\"wp_holi_terms\";s:2:\"22\";s:16:\"wp_holi_usermeta\";s:2:\"48\";s:13:\"wp_holi_users\";s:1:\"2\";s:23:\"wp_holi_wc_download_log\";s:1:\"0\";s:19:\"wp_holi_wc_webhooks\";s:1:\"0\";s:28:\"wp_holi_woocommerce_api_keys\";s:1:\"0\";s:40:\"wp_holi_woocommerce_attribute_taxonomies\";s:1:\"0\";s:52:\"wp_holi_woocommerce_downloadable_product_permissions\";s:1:\"0\";s:23:\"wp_holi_woocommerce_log\";s:1:\"0\";s:34:\"wp_holi_woocommerce_order_itemmeta\";s:1:\"0\";s:31:\"wp_holi_woocommerce_order_items\";s:1:\"0\";s:37:\"wp_holi_woocommerce_payment_tokenmeta\";s:1:\"0\";s:34:\"wp_holi_woocommerce_payment_tokens\";s:1:\"0\";s:28:\"wp_holi_woocommerce_sessions\";s:1:\"0\";s:43:\"wp_holi_woocommerce_shipping_zone_locations\";s:1:\"0\";s:41:\"wp_holi_woocommerce_shipping_zone_methods\";s:1:\"0\";s:34:\"wp_holi_woocommerce_shipping_zones\";s:1:\"0\";s:38:\"wp_holi_woocommerce_tax_rate_locations\";s:1:\"0\";s:29:\"wp_holi_woocommerce_tax_rates\";s:1:\"0\";s:25:\"wp_holi_xcloner_scheduler\";s:1:\"0\";s:23:\"wp_holi_yoast_seo_links\";s:2:\"22\";s:22:\"wp_holi_yoast_seo_meta\";s:2:\"34\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:146:\"/home/maento/www/abchirgroup/wp-content/backups-dup-lite/tmp/20201203_abchirgroupimportexportwhol_1ad52f01835d41883353_20201229090225_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-12-29 09:02:25\";s:7:\"Version\";s:6:\"1.3.40\";s:9:\"VersionWP\";s:5:\"5.5.3\";s:9:\"VersionDB\";s:6:\"5.6.50\";s:10:\"VersionPHP\";s:6:\"7.3.20\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:36:\"20201203_abchirgroupimportexportwhol\";s:4:\"Hash\";s:35:\"1ad52f01835d41883353_20201229090225\";s:8:\"NameHash\";s:72:\"20201203_abchirgroupimportexportwhol_1ad52f01835d41883353_20201229090225\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:74;s:8:\"Database\";r:88;s:13:\"BuildProgress\";r:287;}}}");

/* INSERT TABLE DATA: abchrgrp_options */
INSERT INTO `abchrgrp_options` VALUES("1", "siteurl", "https://www.abchirgroup.com", "yes");
INSERT INTO `abchrgrp_options` VALUES("2", "home", "https://www.abchirgroup.com", "yes");
INSERT INTO `abchrgrp_options` VALUES("3", "blogname", "Abchir Group | Import - Export - Wholesale | Tunisia", "yes");
INSERT INTO `abchrgrp_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `abchrgrp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `abchrgrp_options` VALUES("6", "admin_email", "omar.jallouli@gmail.com", "yes");
INSERT INTO `abchrgrp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `abchrgrp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `abchrgrp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `abchrgrp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `abchrgrp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `abchrgrp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `abchrgrp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `abchrgrp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `abchrgrp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `abchrgrp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `abchrgrp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `abchrgrp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `abchrgrp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `abchrgrp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `abchrgrp_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `abchrgrp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `abchrgrp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `abchrgrp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `abchrgrp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `abchrgrp_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `abchrgrp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `abchrgrp_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `abchrgrp_options` VALUES("29", "rewrite_rules", "a:97:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=35&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `abchrgrp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `abchrgrp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `abchrgrp_options` VALUES("33", "active_plugins", "a:5:{i:0;s:45:\"bulletproof-security/bulletproof-security.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:16:\"gotmls/index.php\";i:4;s:27:\"wp-optimize/wp-optimize.php\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `abchrgrp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `abchrgrp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `abchrgrp_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `abchrgrp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `abchrgrp_options` VALUES("39", "recently_edited", "a:3:{i:0;s:65:\"/home/maento/www/abchirgroup/wp-content/themes/onepress/style.css\";i:1;s:66:\"/home/maento/www/abchirgroup/wp-content/themes/onepress/footer.php\";i:3;s:0:\"\";}", "no");
INSERT INTO `abchrgrp_options` VALUES("40", "template", "onepress", "yes");
INSERT INTO `abchrgrp_options` VALUES("41", "stylesheet", "onepress", "yes");
INSERT INTO `abchrgrp_options` VALUES("17852", "finished_updating_comment_type", "1", "yes");
INSERT INTO `abchrgrp_options` VALUES("44", "comment_registration", "1", "yes");
INSERT INTO `abchrgrp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `abchrgrp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `abchrgrp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `abchrgrp_options` VALUES("48", "db_version", "49752", "yes");
INSERT INTO `abchrgrp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `abchrgrp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `abchrgrp_options` VALUES("51", "blog_public", "0", "yes");
INSERT INTO `abchrgrp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `abchrgrp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `abchrgrp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `abchrgrp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `abchrgrp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `abchrgrp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `abchrgrp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `abchrgrp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `abchrgrp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `abchrgrp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `abchrgrp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `abchrgrp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `abchrgrp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `abchrgrp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `abchrgrp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `abchrgrp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `abchrgrp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `abchrgrp_options` VALUES("69", "close_comments_for_old_posts", "1", "yes");
INSERT INTO `abchrgrp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `abchrgrp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `abchrgrp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `abchrgrp_options` VALUES("73", "page_comments", "", "yes");
INSERT INTO `abchrgrp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `abchrgrp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `abchrgrp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `abchrgrp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `abchrgrp_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("79", "widget_text", "a:5:{i:2;a:2:{s:5:\"title\";s:7:\"Find Us\";s:4:\"text\";s:200:\"<p><strong>Address</strong><br />123 Main Street<br />New York, NY 10001</p><p><strong>Hours</strong><br />Monday&mdash;Friday: 9:00AM&ndash;5:00PM<br />Saturday &amp; Sunday: 11:00AM&ndash;3:00PM</p>\";}i:3;a:2:{s:5:\"title\";s:15:\"About This Site\";s:4:\"text\";s:85:\"This may be a good place to introduce yourself and your site or include some credits.\";}i:4;a:2:{s:5:\"title\";s:7:\"Find Us\";s:4:\"text\";s:200:\"<p><strong>Address</strong><br />123 Main Street<br />New York, NY 10001</p><p><strong>Hours</strong><br />Monday&mdash;Friday: 9:00AM&ndash;5:00PM<br />Saturday &amp; Sunday: 11:00AM&ndash;3:00PM</p>\";}i:5;a:2:{s:5:\"title\";s:15:\"About This Site\";s:4:\"text\";s:85:\"This may be a good place to introduce yourself and your site or include some credits.\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("81", "uninstall_plugins", "a:2:{s:45:\"bulletproof-security/bulletproof-security.php\";s:30:\"bulletproof_security_uninstall\";s:27:\"wp-optimize/wp-optimize.php\";s:21:\"wpo_uninstall_actions\";}", "no");
INSERT INTO `abchrgrp_options` VALUES("82", "timezone_string", "", "yes");
INSERT INTO `abchrgrp_options` VALUES("83", "page_for_posts", "36", "yes");
INSERT INTO `abchrgrp_options` VALUES("84", "page_on_front", "35", "yes");
INSERT INTO `abchrgrp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `abchrgrp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `abchrgrp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `abchrgrp_options` VALUES("88", "site_icon", "1375", "yes");
INSERT INTO `abchrgrp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `abchrgrp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `abchrgrp_options` VALUES("91", "initial_db_version", "38590", "yes");
INSERT INTO `abchrgrp_options` VALUES("92", "abchrgrp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `abchrgrp_options` VALUES("93", "fresh_site", "0", "yes");
INSERT INTO `abchrgrp_options` VALUES("94", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("95", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("96", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("97", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("98", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("99", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:4:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";i:2;s:6:\"text-4\";i:3;s:6:\"text-5\";}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("100", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("101", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("102", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("103", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("104", "cron", "a:14:{i:1638651051;a:1:{s:16:\"bpsPro_HPF_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"minutes_15\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1638651084;a:1:{s:22:\"bpsPro_email_log_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1638651600;a:1:{s:16:\"bpsPro_DBB_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1638652499;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1638664942;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1638708007;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638708592;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638726174;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638726187;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638726708;a:2:{s:26:\"wpo_minify_purge_old_cache\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:29:\"wpo_smush_clear_backup_images\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1639072308;a:1:{s:21:\"wpo_weekly_cron_tasks\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1639158174;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1643306130;a:1:{s:31:\"wpo_page_cache_schedule_preload\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"wpo_use_cache_lifespan\";s:4:\"args\";a:0:{}s:8:\"interval\";i:5184000;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("105", "theme_mods_twentyseventeen", "a:3:{s:18:\"custom_css_post_id\";i:-1;s:7:\"panel_1\";i:2;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1485089943;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17875", "_transient_health-check-site-status-result", "{\"good\":14,\"recommended\":5,\"critical\":1}", "yes");
INSERT INTO `abchrgrp_options` VALUES("164", "ft_demo_customizer_keys", "a:1:{s:8:\"onepress\";a:7:{s:24:\"onepress_social_profiles\";a:0:{}s:20:\"onepress_about_boxes\";a:1:{i:0;a:2:{s:3:\"key\";s:12:\"content_page\";s:4:\"type\";s:4:\"page\";}}s:23:\"onepress_features_boxes\";a:1:{i:0;a:2:{s:3:\"key\";s:5:\"image\";s:4:\"type\";s:5:\"media\";}}s:17:\"onepress_services\";a:2:{i:0;a:2:{s:3:\"key\";s:5:\"image\";s:4:\"type\";s:5:\"media\";}i:1;a:2:{s:3:\"key\";s:12:\"content_page\";s:4:\"type\";s:4:\"page\";}}s:22:\"onepress_counter_boxes\";a:0:{}s:21:\"onepress_team_members\";a:1:{i:0;a:2:{s:3:\"key\";s:7:\"user_id\";s:4:\"type\";s:5:\"media\";}}s:20:\"onepress_hero_images\";a:1:{i:0;a:2:{s:3:\"key\";s:5:\"image\";s:4:\"type\";s:5:\"media\";}}}}", "yes");
INSERT INTO `abchrgrp_options` VALUES("148", "current_theme", "OnePress", "yes");
INSERT INTO `abchrgrp_options` VALUES("149", "theme_mods_onepress", "a:64:{i:0;b:0;s:18:\"custom_css_post_id\";i:-1;s:20:\"onepress_contact_cf7\";s:42:\"[contact-form-7 title=\"Frontpage contact\"]\";s:21:\"onepress_contact_text\";s:133:\"<h4>WE CAN ANSWER YOUR QUESTIONS</h4>\nYou can contact us either via the contact form or using our email address or phone number below\";s:30:\"onepress_contact_address_title\";s:15:\"Contact Details\";s:24:\"onepress_contact_address\";s:77:\"App A7  <br> Immeuble Enneifar <br> Avenue 5 Aout <br>3000, Sfax  <br>Tunisia\";s:22:\"onepress_contact_phone\";s:15:\"+216 52 007 007\";s:22:\"onepress_contact_email\";s:23:\"contact@abchirgroup.com\";s:20:\"onepress_contact_fax\";s:0:\"\";s:23:\"onepress_social_disable\";i:1;s:23:\"onepress_social_twitter\";s:1:\"#\";s:24:\"onepress_social_facebook\";s:1:\"#\";s:22:\"onepress_social_google\";s:1:\"#\";s:25:\"onepress_social_instagram\";s:1:\"#\";s:27:\"onepress_newsletter_disable\";i:0;s:29:\"onepress_newsletter_mailchimp\";s:94:\"//famethemes.us8.list-manage.com/subscribe/post?u=521c400d049a59a4b9c0550c2&#038;id=83187e0006\";s:21:\"onepress_team_members\";a:4:{i:0;a:2:{s:7:\"user_id\";a:2:{s:3:\"url\";s:100:\"http://www.abchirgroup.com/wp-content/uploads/2017/01/Textile_Fabrics_Sfax_Tunisia_Import_Export.png\";s:2:\"id\";i:1356;}s:4:\"link\";s:43:\"http://www.abchirgroup.com/textile-fabrics/\";}i:1;a:2:{s:7:\"user_id\";a:2:{s:3:\"url\";s:96:\"http://www.abchirgroup.com/wp-content/uploads/2017/01/Agriculture_Sfax_Tunisia_Import_Export.png\";s:2:\"id\";i:1358;}s:4:\"link\";s:49:\"http://www.abchirgroup.com/agricultural-products/\";}i:2;a:2:{s:7:\"user_id\";a:2:{s:3:\"url\";s:90:\"http://www.abchirgroup.com/wp-content/uploads/2017/01/Foods_Sfax_Tunisia_Import_Export.png\";s:2:\"id\";i:1380;}s:4:\"link\";s:33:\"http://www.abchirgroup.com/foods/\";}i:3;a:2:{s:7:\"user_id\";a:2:{s:3:\"url\";s:95:\"http://www.abchirgroup.com/wp-content/uploads/2017/01/Handcrafts_Sfax_Tunisia_Import_Export.png\";s:2:\"id\";i:1382;}s:4:\"link\";s:38:\"http://www.abchirgroup.com/handcrafts/\";}}s:20:\"onepress_hero_images\";a:2:{i:0;a:1:{s:5:\"image\";a:2:{s:3:\"url\";s:91:\"http://www.abchirgroup.com/wp-content/uploads/2017/01/AbchirGroup_Business_Sfax_Tunisia.png\";s:2:\"id\";i:1283;}}i:1;a:1:{s:5:\"image\";a:2:{s:3:\"url\";s:102:\"http://www.abchirgroup.com/wp-content/uploads/2017/01/AbchirGroup_Purchasing_Sourcing_Sfax_Tunisia.png\";s:2:\"id\";i:1294;}}}s:27:\"onepress_hero_overlay_color\";s:15:\"rgba(0,0,0,0.3)\";s:24:\"onepress_site_image_logo\";s:81:\"http://demos.famethemes.com/onepress/wp-content/uploads/sites/17/2016/02/logo.png\";s:20:\"onepress_about_boxes\";a:2:{i:0;a:3:{s:12:\"content_page\";i:37;s:10:\"hide_title\";s:0:\"\";s:11:\"enable_link\";s:0:\"\";}i:1;a:3:{s:12:\"content_page\";i:39;s:10:\"hide_title\";s:0:\"\";s:11:\"enable_link\";s:0:\"\";}}s:17:\"onepress_services\";a:4:{i:0;a:5:{s:9:\"icon_type\";s:4:\"icon\";s:4:\"icon\";s:12:\"fa fa-search\";s:5:\"image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:12:\"content_page\";s:4:\"1313\";s:11:\"enable_link\";s:0:\"\";}i:1;a:5:{s:9:\"icon_type\";s:4:\"icon\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:5:\"image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:12:\"content_page\";s:4:\"1319\";s:11:\"enable_link\";s:0:\"\";}i:2;a:5:{s:9:\"icon_type\";s:4:\"icon\";s:4:\"icon\";s:11:\"fa fa-cubes\";s:5:\"image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:12:\"content_page\";s:4:\"1323\";s:11:\"enable_link\";s:0:\"\";}i:3;a:5:{s:9:\"icon_type\";s:4:\"icon\";s:4:\"icon\";s:10:\"fa fa-ship\";s:5:\"image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:12:\"content_page\";s:4:\"1329\";s:11:\"enable_link\";s:0:\"\";}}s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:16;}s:23:\"onepress_news_more_link\";s:41:\"http://demos.famethemes.com/onepress/news\";s:28:\"onepress_videolightbox_title\";s:44:\"Parallax Effect - <strong>Perfected</strong>\";s:26:\"onepress_videolightbox_url\";s:43:\"https://www.youtube.com/watch?v=yUCFRL43Zm4\";s:28:\"onepress_videolightbox_image\";s:82:\"http://demos.famethemes.com/onepress/wp-content/uploads/sites/17/2016/02/blog1.jpg\";s:22:\"onepress_counter_title\";s:0:\"\";s:25:\"onepress_counter_subtitle\";s:32:\"Some Fun Facts about our agency?\";s:22:\"onepress_counter_boxes\";a:4:{i:0;a:4:{s:5:\"title\";s:18:\"Projects completed\";s:6:\"number\";s:3:\"368\";s:11:\"unit_before\";s:0:\"\";s:10:\"unit_after\";s:0:\"\";}i:1;a:4:{s:5:\"title\";s:17:\"Positive feedback\";s:6:\"number\";s:2:\"99\";s:11:\"unit_before\";s:0:\"\";s:10:\"unit_after\";s:1:\"%\";}i:2;a:4:{s:5:\"title\";s:14:\"Pizzas ordered\";s:6:\"number\";s:3:\"254\";s:11:\"unit_before\";s:0:\"\";s:10:\"unit_after\";s:0:\"\";}i:3;a:4:{s:5:\"title\";s:21:\"Average cost per hour\";s:6:\"number\";s:2:\"32\";s:11:\"unit_before\";s:1:\"$\";s:10:\"unit_after\";s:0:\"\";}}s:24:\"onepress_hero_fullscreen\";i:0;s:29:\"onepress_hero_overlay_opacity\";s:3:\"0.6\";s:19:\"onepress_about_desc\";s:742:\"<div class=\"mceTemp\">\n<dl id=\"attachment_1379\" class=\"wp-caption aligncenter\" style=\"width: 285px\">\n 	<dt class=\"wp-caption-dt\"><img src=\"http://www.abchirgroup.com/wp-content/uploads/2017/01/Abchir_Group_Sfax_Tunisia_Logo-285x300.png\" alt=\"Abchir_Group_Sfax_Tunisia_Logo\" width=\"285\" height=\"300\" class=\"wp-image-1379 size-medium\"></dt>\n</dl>\n</div>\nWe provide quality <i>Business Consultancy Services</i> to clients around the world,\ndealing with all the aspects of trade operations from sourcing to distribution.\nWe bring you the best opportunities in wholesale, regular sales, closeout, and clearance sales.\nThrough our network of trusted business partners, we help companies that want to do import &amp; export deals from and to Tunisia.\";s:23:\"onepress_features_boxes\";a:4:{i:0;a:6:{s:5:\"title\";s:9:\"Expertise\";s:9:\"icon_type\";s:4:\"icon\";s:4:\"icon\";s:11:\"fa fa-check\";s:5:\"image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:4:\"desc\";s:60:\"Unparalleled Knowledge and Expertise in&nbsp;Tunisian Market\";s:4:\"link\";s:0:\"\";}i:1;a:6:{s:5:\"title\";s:24:\"Growing Business Network\";s:9:\"icon_type\";s:4:\"icon\";s:4:\"icon\";s:16:\"fa fa-line-chart\";s:5:\"image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:4:\"desc\";s:51:\"A Growing Network of Partners in Tunisia and abroad\";s:4:\"link\";s:0:\"\";}i:2;a:6:{s:5:\"title\";s:8:\"Sourcing\";s:9:\"icon_type\";s:4:\"icon\";s:4:\"icon\";s:18:\"fa-cart-arrow-down\";s:5:\"image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:4:\"desc\";s:69:\"Sourcing Directly From Major Global Suppliers For Competitive Pricing\";s:4:\"link\";s:0:\"\";}i:3;a:6:{s:5:\"title\";s:19:\"Win-Win Partnership\";s:9:\"icon_type\";s:4:\"icon\";s:4:\"icon\";s:17:\"fa fa-handshake-o\";s:5:\"image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:4:\"desc\";s:50:\"Long-term Commitment&nbsp;To Customer Satisfaction\";s:4:\"link\";s:0:\"\";}}s:23:\"onepress_hide_sitetitle\";i:1;s:21:\"onepress_hide_tagline\";i:1;s:24:\"onepress_gallery_disable\";i:1;s:21:\"onepress_gallery_desc\";s:90:\"NEW: Gallery section support advanced layouts: Grid, Slider, Carousel, Masonry, Justified.\";s:28:\"onepress_gallery_source_page\";s:4:\"1245\";s:23:\"onepress_gallery_layout\";s:10:\"full-width\";s:24:\"onepress_gallery_display\";s:7:\"masonry\";s:18:\"onepress_g_spacing\";s:1:\"2\";s:14:\"onepress_g_col\";s:1:\"5\";s:25:\"onepress_contact_subtitle\";s:10:\"Contact Us\";s:24:\"onepress_counter_disable\";i:1;s:21:\"onepress_team_disable\";i:0;s:21:\"onepress_news_disable\";i:1;s:23:\"onepress_hcl1_largetext\";s:106:\"Your One-Stop Shop for <span class=\"js-rotating\">Sourcing | Purchasing | Distributorship | Business</span>\";s:23:\"onepress_hcl1_smalltext\";s:134:\"Business consultants at <strong>Abchir Group</strong> are here to help you with all your needs in the <strong>Tunisian market</strong>\";s:23:\"onepress_features_title\";s:13:\"Why Choose Us\";s:26:\"onepress_features_subtitle\";s:0:\"\";s:23:\"onepress_hcl1_btn1_text\";s:8:\"Services\";s:23:\"onepress_hcl1_btn2_text\";s:10:\"Contact Us\";s:23:\"onepress_about_subtitle\";s:22:\"Abchir Group - Tunisia\";s:30:\"onepress_videolightbox_disable\";i:1;s:26:\"onepress_services_subtitle\";s:0:\"\";s:23:\"onepress_gallery_source\";s:4:\"page\";s:24:\"onepress_g_readmore_link\";s:13:\"www.yahoo.com\";s:19:\"onepress_team_title\";s:16:\"Business Sectors\";s:22:\"onepress_team_subtitle\";s:0:\"\";s:16:\"onepress_team_id\";s:7:\"sectors\";s:16:\"onepress_hero_id\";s:21:\"import-export-tunisia\";s:11:\"custom_logo\";i:1368;s:22:\"onepress_primary_color\";s:6:\"9e9c4b\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("150", "theme_switched", "", "yes");
INSERT INTO `abchrgrp_options` VALUES("154", "wpcf7", "a:4:{s:7:\"version\";s:5:\"5.3.2\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1609232892;s:7:\"version\";s:5:\"5.3.2\";s:11:\"count_valid\";i:2;s:13:\"count_invalid\";i:0;}s:9:\"recaptcha\";a:1:{s:40:\"6Lej7RgaAAAAAFMELnKPkXumLCE2gZkGVYwCXVh5\";s:40:\"6Lej7RgaAAAAAJ6J_Ycn405eL4aKqRZvgzoE0r-m\";}s:23:\"recaptcha_v2_v3_warning\";b:0;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("155", "recently_activated", "a:0:{}", "yes");
INSERT INTO `abchrgrp_options` VALUES("287", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:23:\"omar.jallouli@gmail.com\";s:7:\"version\";s:5:\"5.6.6\";s:9:\"timestamp\";i:1636597045;}", "no");
INSERT INTO `abchrgrp_options` VALUES("174", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `abchrgrp_options` VALUES("177", "category_children", "a:0:{}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17321", "bulletproof_security_options_db_backup", "a:12:{s:13:\"bps_db_backup\";s:2:\"On\";s:25:\"bps_db_backup_description\";s:0:\"\";s:20:\"bps_db_backup_folder\";s:74:\"/home/maento/www/abchirgroup/wp-content/bps-backup/backups_OzwuGm8b6DZ5akH\";s:27:\"bps_db_backup_download_link\";s:73:\"http://www.abchirgroup.com/wp-content/bps-backup/backups_OzwuGm8b6DZ5akH/\";s:22:\"bps_db_backup_job_type\";s:0:\"\";s:23:\"bps_db_backup_frequency\";s:0:\"\";s:29:\"bps_db_backup_start_time_hour\";s:0:\"\";s:32:\"bps_db_backup_start_time_weekday\";s:0:\"\";s:35:\"bps_db_backup_start_time_month_date\";s:0:\"\";s:23:\"bps_db_backup_email_zip\";s:0:\"\";s:20:\"bps_db_backup_delete\";s:0:\"\";s:28:\"bps_db_backup_status_display\";s:13:\"No DB Backups\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17322", "bulletproof_security_options_wizard_autofix", "a:1:{s:18:\"bps_wizard_autofix\";s:2:\"On\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17323", "bulletproof_security_options_apache_modules", "a:2:{s:23:\"bps_apache_mod_ifmodule\";s:3:\"Yes\";s:19:\"bps_apache_mod_time\";s:10:\"1609233599\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17324", "bulletproof_security_options_mod_security", "a:1:{s:22:\"bps_mod_security_check\";s:1:\"1\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17327", "bulletproof_security_options_wizard_free", "a:1:{s:15:\"bps_wizard_free\";s:6:\"wizard\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17328", "bulletproof_security_options_login_security_jtc", "a:22:{s:23:\"bps_tooltip_captcha_key\";s:3:\"jtc\";s:30:\"bps_tooltip_captcha_hover_text\";s:13:\"Type/Enter:  \";s:25:\"bps_tooltip_captcha_title\";s:33:\"Hover or click the text box below\";s:27:\"bps_tooltip_captcha_logging\";s:3:\"Off\";s:18:\"bps_jtc_login_form\";s:1:\"1\";s:21:\"bps_jtc_register_form\";s:0:\"\";s:25:\"bps_jtc_lostpassword_form\";s:0:\"\";s:20:\"bps_jtc_comment_form\";s:0:\"\";s:24:\"bps_jtc_mu_register_form\";s:0:\"\";s:32:\"bps_jtc_buddypress_register_form\";s:0:\"\";s:31:\"bps_jtc_buddypress_sidebar_form\";s:0:\"\";s:21:\"bps_jtc_administrator\";s:0:\"\";s:14:\"bps_jtc_editor\";s:0:\"\";s:14:\"bps_jtc_author\";s:0:\"\";s:19:\"bps_jtc_contributor\";s:0:\"\";s:18:\"bps_jtc_subscriber\";s:0:\"\";s:26:\"bps_jtc_comment_form_error\";s:115:\"<strong>ERROR</strong>: Incorrect JTC CAPTCHA Entered. Click your Browser back button and re-enter the JTC CAPTCHA.\";s:26:\"bps_jtc_comment_form_label\";s:82:\"position:relative;top:0px;left:0px;padding:0px 0px 0px 0px;margin:0px 0px 0px 0px;\";s:26:\"bps_jtc_comment_form_input\";s:82:\"position:relative;top:0px;left:0px;padding:0px 0px 0px 0px;margin:0px 0px 0px 0px;\";s:20:\"bps_jtc_custom_roles\";a:2:{i:0;s:3:\"bps\";i:1;s:0:\"\";}s:26:\"bps_enable_jtc_woocommerce\";s:0:\"\";s:25:\"bps_jtc_custom_form_error\";s:50:\"<strong>ERROR</strong>: Incorrect CAPTCHA Entered.\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("23394", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1638626573;s:7:\"checked\";a:2:{s:8:\"onepress\";s:5:\"2.2.6\";s:15:\"twentytwentyone\";s:3:\"1.1\";}s:8:\"response\";a:2:{s:8:\"onepress\";a:6:{s:5:\"theme\";s:8:\"onepress\";s:11:\"new_version\";s:5:\"2.2.8\";s:3:\"url\";s:38:\"https://wordpress.org/themes/onepress/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/theme/onepress.2.2.8.zip\";s:8:\"requires\";b:0;s:12:\"requires_php\";s:3:\"5.6\";}s:15:\"twentytwentyone\";a:6:{s:5:\"theme\";s:15:\"twentytwentyone\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentyone/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentyone.1.4.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.6\";}}s:9:\"no_update\";a:0:{}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `abchrgrp_options` VALUES("23395", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1638626574;s:7:\"checked\";a:7:{s:19:\"akismet/akismet.php\";s:5:\"4.1.7\";s:16:\"gotmls/index.php\";s:7:\"4.19.69\";s:45:\"bulletproof-security/bulletproof-security.php\";s:3:\"4.4\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"5.3.2\";s:25:\"duplicator/duplicator.php\";s:8:\"1.3.40.1\";s:53:\"famethemes-demo-importer/famethemes-demo-importer.php\";s:5:\"1.1.2\";s:27:\"wp-optimize/wp-optimize.php\";s:5:\"3.1.6\";}s:8:\"response\";a:5:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"4.2.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.4.2.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"5.8.2\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:16:\"gotmls/index.php\";O:8:\"stdClass\":14:{s:2:\"id\";s:20:\"w.org/plugins/gotmls\";s:4:\"slug\";s:6:\"gotmls\";s:6:\"plugin\";s:16:\"gotmls/index.php\";s:11:\"new_version\";s:7:\"4.20.92\";s:3:\"url\";s:37:\"https://wordpress.org/plugins/gotmls/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/gotmls.4.20.92.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/gotmls/assets/icon-256x256.png?rev=1001824\";s:2:\"1x\";s:59:\"https://ps.w.org/gotmls/assets/icon-128x128.png?rev=1001824\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/gotmls/assets/banner-772x250.jpg?rev=1043954\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.3\";s:6:\"tested\";s:5:\"5.8.2\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}s:14:\"upgrade_notice\";s:216:\"<p>Added German translation, improved firewall compatibility with Apache, fixed session check in Site Health for REST API compatibility, and checked code compatibility with WordPress 5.8.1 and ClassicPress 1.3.1.</p>\";}s:45:\"bulletproof-security/bulletproof-security.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:34:\"w.org/plugins/bulletproof-security\";s:4:\"slug\";s:20:\"bulletproof-security\";s:6:\"plugin\";s:45:\"bulletproof-security/bulletproof-security.php\";s:11:\"new_version\";s:3:\"5.5\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/bulletproof-security/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/bulletproof-security.5.5.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:73:\"https://ps.w.org/bulletproof-security/assets/icon-128x128.png?rev=1731938\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:75:\"https://ps.w.org/bulletproof-security/assets/banner-772x250.png?rev=2252426\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.8\";s:6:\"tested\";s:5:\"5.8.2\";s:12:\"requires_php\";s:3:\"5.6\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:5:\"1.4.3\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/duplicator.1.4.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2605836\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2605835\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2085472\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";s:6:\"tested\";s:5:\"5.8.2\";s:12:\"requires_php\";s:5:\"5.3.8\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:27:\"wp-optimize/wp-optimize.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:25:\"w.org/plugins/wp-optimize\";s:4:\"slug\";s:11:\"wp-optimize\";s:6:\"plugin\";s:27:\"wp-optimize/wp-optimize.php\";s:11:\"new_version\";s:5:\"3.2.1\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/wp-optimize/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/wp-optimize.3.2.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/wp-optimize/assets/icon-256x256.png?rev=1552899\";s:2:\"1x\";s:64:\"https://ps.w.org/wp-optimize/assets/icon-128x128.png?rev=1552899\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/wp-optimize/assets/banner-1544x500.png?rev=2125385\";s:2:\"1x\";s:66:\"https://ps.w.org/wp-optimize/assets/banner-772x250.png?rev=2125385\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.5\";s:6:\"tested\";s:5:\"5.8.2\";s:12:\"requires_php\";s:3:\"5.6\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"5.5.3\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.3.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:67:\"https://ps.w.org/contact-form-7/assets/icon-256x256.png?rev=2279696\";s:2:\"1x\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";s:3:\"svg\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.7\";s:6:\"tested\";s:5:\"5.8.2\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";a:0:{}}s:53:\"famethemes-demo-importer/famethemes-demo-importer.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"w.org/plugins/famethemes-demo-importer\";s:4:\"slug\";s:24:\"famethemes-demo-importer\";s:6:\"plugin\";s:53:\"famethemes-demo-importer/famethemes-demo-importer.php\";s:11:\"new_version\";s:5:\"1.1.2\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/famethemes-demo-importer/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/famethemes-demo-importer.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:68:\"https://s.w.org/plugins/geopattern-icon/famethemes-demo-importer.svg\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.5\";}}}", "no");
INSERT INTO `abchrgrp_options` VALUES("22999", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:3:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.8.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.8.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.8.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.8.2-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"5.8.2\";s:7:\"version\";s:5:\"5.8.2\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.6\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.8.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.8.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.8.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.8.2-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"5.8.2\";s:7:\"version\";s:5:\"5.8.2\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.6\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:2;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.7.4.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.7.4.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.7.4-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.7.4-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"5.7.4\";s:7:\"version\";s:5:\"5.7.4\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.6\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}}s:12:\"last_checked\";i:1638626572;s:15:\"version_checked\";s:5:\"5.6.6\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `abchrgrp_options` VALUES("23396", "_transient_doing_cron", "1638650299.8493609428405761718750", "yes");
INSERT INTO `abchrgrp_options` VALUES("18287", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1609275594", "no");
INSERT INTO `abchrgrp_options` VALUES("18292", "_transient_is_multi_author", "0", "yes");
INSERT INTO `abchrgrp_options` VALUES("18293", "_transient_onepress_categories", "2", "yes");
INSERT INTO `abchrgrp_options` VALUES("17824", "GOTMLS_settings_array", "a:11:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:27:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"svg\";i:9;s:3:\"doc\";i:10;s:4:\"docx\";i:11;s:3:\"ttf\";i:12;s:3:\"fla\";i:13;s:3:\"flv\";i:14;s:3:\"mov\";i:15;s:3:\"mp3\";i:16;s:3:\"pdf\";i:17;s:3:\"css\";i:18;s:3:\"pot\";i:19;s:2:\"po\";i:20;s:2:\"mo\";i:21;s:2:\"so\";i:22;s:3:\"exe\";i:23;s:3:\"zip\";i:24;s:2:\"7z\";i:25;s:2:\"gz\";i:26;s:3:\"rar\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:10:\"scan_level\";i:3;s:5:\"check\";a:4:{i:0;s:7:\"db_scan\";i:1;s:8:\"htaccess\";i:2;s:8:\"timthumb\";i:3;s:5:\"known\";}s:10:\"dont_check\";a:0:{}s:15:\"skip_quarantine\";i:0;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17817", "duplicator_settings", "a:17:{s:7:\"version\";s:8:\"1.3.40.1\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";s:1:\"0\";s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";s:1:\"0\";s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";s:1:\"2\";s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:-1;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17818", "duplicator_lite_inst_hash_notice", "1", "yes");
INSERT INTO `abchrgrp_options` VALUES("17819", "duplicator_version_plugin", "1.3.40.1", "yes");
INSERT INTO `abchrgrp_options` VALUES("17828", "GOTMLS_scan_log/51.68.120.109/1607015131.6699", "a:2:{s:8:\"settings\";a:11:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:27:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"svg\";i:9;s:3:\"doc\";i:10;s:4:\"docx\";i:11;s:3:\"ttf\";i:12;s:3:\"fla\";i:13;s:3:\"flv\";i:14;s:3:\"mov\";i:15;s:3:\"mp3\";i:16;s:3:\"pdf\";i:17;s:3:\"css\";i:18;s:3:\"pot\";i:19;s:2:\"po\";i:20;s:2:\"mo\";i:21;s:2:\"so\";i:22;s:3:\"exe\";i:23;s:3:\"zip\";i:24;s:2:\"7z\";i:25;s:2:\"gz\";i:26;s:3:\"rar\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:10:\"scan_level\";i:3;s:5:\"check\";a:4:{i:0;s:7:\"db_scan\";i:1;s:8:\"htaccess\";i:2;s:8:\"timthumb\";i:3;s:5:\"known\";}s:10:\"dont_check\";a:0:{}s:15:\"skip_quarantine\";i:0;}s:4:\"scan\";a:7:{s:3:\"dir\";s:28:\"/home/maento/www/abchirgroup\";s:5:\"start\";i:1607015131;s:4:\"type\";s:13:\"Complete Scan\";s:9:\"microtime\";d:556;s:7:\"percent\";i:-1;s:11:\"last_threat\";d:1607015687.8857319;s:6:\"finish\";i:1607015687;}}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17825", "GOTMLS_nonce_blob", "YToxOntzOjMyOiJhNWM2NDg4YmVjZjlhYjgyYWFiNjA=MjM1ZTA1ZjM3ZiI7ZDo=NDYzOTM7fQ3", "yes");
INSERT INTO `abchrgrp_options` VALUES("17826", "GOTMLS_Installation_Keys", "s:80:\"a:1:{s:32:\"99dbd212738a3fd46a42efe7343cfa96\";s:26:\"http://www.abchirgroup.com\";}\";", "yes");
INSERT INTO `abchrgrp_options` VALUES("17827", "GOTMLS_definitions_blob", "YTo5OntzOjk6InBvdGVudGlhbCI7YToxNTp7czo=OiJldmFsIjthOjI6e2k6MDtzOjU6IkVBUExxIjtpOjE7czozNToiL1teYS16XC8nIl1ldmFsXChbXlwpXStbJyJcc1wpO1=rL2kiO31zOjk6ImF1dGhfcGFzcyI7YToyOntpOjA7czo1OiJIMU45WSI7aToxO3M6MjE6Ii9cJGF1dGhfcGFzc1xzKj=uKzsvaSI7fXM6MjE6ImRvY3VtZW5=LndyaXRlIGlmcmFtZSI7YToyOntpOjA7czo1OiJIMVBBTyI7aToxO3M6NTI6Ii9kb2N1bWVudFwud3JpdGVcKChbJyJdKTxpZnJhbWUgLis8XC9pZnJhbWU-XDFcKTsqL2kiO31zOjE1OiJwcmVnX3JlcGxhY2UgL2UiO2E6Mjp7aTowO3M6NToiRzg1RjIiO2k6MTtzOjQ3OiIvcHJlZ19yZXBsYWNlXHMqXCguK1tcL1wjXHxdW2ldKmVbaV=qWyciXS4rXCkvaSI7fXM6MjA6ImV4ZWMgc3lzdGVtIHBhc3N=aHJ1IjthOjI6e2k6MDtzOjU6IkVBUExnIjtpOjE7czo1MToiLzxcPy4rP2V4ZWNcKC4rP3N5c3RlbVwoLis_cGFzc3RocnVcKC4rZndyaXRlXCguKy9zIjt9czoyOToiRXh=ZXJuYWwgUmVkaXJlY3QgUmV3cml=ZVJ1bGUiO2E6Mjp7aTowO3M6NToiRjFVSVoiO2k6MTtzOjQyOiIvUmV3cml=ZVJ1bGUgW14gXSsgaHR=cFw6XC9cLyg_ITEyN1wuKS4qL2kiO31zOjM1OiJubyBlcnJvcl9yZXBvcnRpbmcgbG9uZyBsaW5lcyBhbG9uZSI7YToyOntpOjA7czo1OiJIMlM4aiI7aToxO3M6NzQ6Ii88XD9bXHNocF=qXEA_ZXJyb3JfcmVwb3J=aW5nXCgwXCk7Lis_W2EtejAtOVwvXC1cPSciXC5dezIwMDB9Lio_KCR8XD8-KS9pIjt9czoyMjoicHJvdGVjdGVkIGJ5IGNvcHlyaWdodCI7YToyOntpOjA7czo1OiJEOE1DdyI7aToxO3M6MTM2OiIvXC9cKiBUaGlzIGZpbGUgaXMgcHJvdGVjdGVkIGJ5IGNvcHlyaWdodCBsYXcgYW5kIHByb3ZpZGVkIHVuZGVyIGxpY2Vuc2UuIFJldmVyc2UgZW5naW5lZXJpbmcgb2YgdGhpcyBmaWxlIGlzIHN=cmljdGx5IHByb2hpYml=ZWQuIFwqXC8vIjt9czoxOToiYSBzcGFuIGNvbG9yIEYxRUZFNCI7YToyOntpOjA7czo1OiJEOFJBUCI7aToxO3M6MTE4OiIvXDxhIFteXD5dK1w-XDxzcGFuIHN=eWxlPSJjb2xvclw6XCNGMUVGRTQ7Ilw-KC4rPylcPFwvc3Bhblw-XDxcL2FcPlw8c3BhbiBzdHlsZT=iY29sb3JcOlwjRjFFRkU=OyJcPiguKz8pXDxcL3NwYW5cPi9pIjt9czoxNzoiVmFyaWFibGUgRnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRTg1NkwiO2k6MTtzOjY3OiIvKDwhXGQpXCRbXCRce1=qW2EtelwtXF8wLTldK1tcfSBcdF=qKFxbW15cXV=rXF1bIFx=XSopKlwoLio_XClcOy9pIjt9czoxMToiVGFnZ2VkIENvZGUiO2E6Mjp7aTowO3M6NToiRTRMTUciO2k6MTtzOjI=OiIvXCMoXHcrKVwjLis_XCNcL1wxXCMvaXMiO31zOjE1OiJjcmVhdGVfZnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRzFNRmUiO2k6MTtzOjc4OiIvKFwkW2Etel8wLTldK1s9XHNcQF=rKT9jcmVhdGVfZnVuY3Rpb25cKFteLF=rLFtcc1wkXC5cW1xdYS16XzAtOV=rW1xzXCldKzsqL2kiO31zOjQzOiJmdW5jdGlvbiBhZGRfYWN=aW9uIHdwX2VucXVldWVfc2NyaXB=IGpzb24yIjthOjI6e2k6MDtzOjU6IkYxMTR2IjtpOjE7czoxNzoiL2pzb24yXC5taW5cLmpzL2kiO31zOjQ3OiJSZXdyaXRlQ29uZCBIVFRQX1VTRVJfQUdFTlQgUmV3cml=ZVJ1bGUgaHR=cCBJUCI7YToyOntpOjA7czo1OiJGMjc3aCI7aToxO3M6ODQ6Ii8oUmV3cml=ZUNvbmQgXCVce=hUVFBfVVNFUl9BR=VOVFx9IC4rXHMrKStSZXdyaXRlUnVsZSBcXi4qXCQgaHR=cDpcL1wvKD8hMTI3XC4pLiovaSI7fXM6MTI6InRpdGxlIGhhY2tlZCI7YToyOntpOjA7czo1OiJIMlM4bSI7aToxO3M6Mjc6Ii88dGl=bGU-W148XSpoYWNrWzNlXVtyZF=vaSI7fX1zOjg6ImZpcmV3YWxsIjthOjY6e3M6OToiUmV2U2xpZGVyIjthOjc6e2k6MDtzOjU6IkdCS=ZyIjtpOjE7czozNjoiUmV2b2x1dGlvbiBTbGlkZXIgRXhwbG9pdCBQcm9=ZWN=aW9uIjtpOjI7czo=MTQ6IlRoaXMgcHJvdGVjdGlvbiBpcyBhdXRvbWF=aWNhbGx5IGFjdGl2YXRlZCBiZWNhdXNlIG9mIHRoZSB3aWRlc3ByZWFkIGF=dGFja3Mgb24gV29yZFByZXNzIHRoYXQgaGF2ZSBhZmZlY3RlZCBzbyBtYW55IHNpdGVzLiBJdCBpcyBzdGlsbCByZWNvbW1lbmRlZCB=aGF=IHlvdSBtYWtlIHN1cmUgdG8gdXBncmFkZSBhbnkgb2xkZXIgdmVyc2lvbnMgb2YgdGhlIFJldm9sdXRpb24gU2xpZGVyIHBsdWdpbiwgZXNwZWNpYWxseSB=aG9zZSBpbmNsdWRlZCBpbiB=aGVtZXMgdGhhdCB3aWxsIG5vdCB1cGRhdGUgYXV=b21hdGljYWxseS4gRXZlbiBpZiB5b3UgZG9uJ3QgdGhpbmsgeW91IGhhdmUgUmV2b2x1dGlvbiBTbGlkZXIgb24geW91ciBzaXRlIGl=IGRvZXNuJ3QgaHVydCB=byBoYXZlIHRoaXMgcHJvdGVjdGlvbiBlbmFibGVkLiI7aTozO3M6NjoiU=VSVkVSIjtpOjQ7czoyMDoiL1wvYWRtaW4tYWpheFwucGhwL2kiO2k6NTtzOjc6IlJFUVVFU1QiO2k6NjtzOjExOToiL1wmaW1nPVteXCZdKig_PCFcLnBuZykoPzwhXC5qcGcpKD88IVwuanBlZykoPzwhXC5naWYpKD88IVwuYm1wKSg_PCFcLnRpZikoPzwhXC5=aWZmKSg_PCFcLnBzZCkoPzwhXC5zdmcpKD88IVwuaWNvKVwmL2kiO31zOjk6IlRyYXZlcnNhbCI7YTo1OntpOjA7czo1OiJIQzNBUSI7aToxO3M6MzA6IkRpcmVjdG9yeSBUcmF2ZXJzYWwgUHJvdGVjdGlvbiI7aToyO3M6MjE2OiJUaGlzIHByb3RlY3Rpb24gaXMgYXV=b21hdGljYWxseSBhY3RpdmF=ZWQgYmVjYXVzZSB=aGlzIHR5cGUgb2YgYXR=YWNrIGlzIHF1aXRlIGNvbW1vbi4gVGhpcyBwcm9=ZWN=aW9uIGNhbiBwcmV2ZW5=IGhhY2tlcnMgZnJvbSBhY2Nlc3Npbmcgc2VjdXJlIGZpbGVzIGluIHBhcmVudCBkaXJlY3RvcmllcyAob3IgdXNlcidzIGZvbGRlcnMgb3V=c2lkZSB=aGUgc2l=ZV9yb29=KS4iO2k6MztzOjc6IlJFUVVFU1QiO2k6NDtzOjI=OiIvPVtcc1wvXC5dKihcLlwufGV=YylcLy8iO31zOjk6IlVwbG9hZFBIUCI7YTo1OntpOjA7czo1OiJHQ=9BVCI7aToxO3M6MjY6IlVwbG9hZCBQSFAgRmlsZSBQcm9=ZWN=aW9uIjtpOjI7czoxNzc6IlRoaXMgcHJvdGVjdGlvbiBpcyBhdXRvbWF=aWNhbGx5IGFjdGl2YXRlZCBiZWNhdXNlIHRoaXMgdHlwZSBvZiBhdHRhY2sgaXMgZXh=cmVtZWx5IGRhbmdlcm91cy4gVGhpcyBwcm9=ZWN=aW9uIGNhbiBwcmV2ZW5=IGhhY2tlcnMgZnJvbSB1cGxvYWRpbmcgbWFsaWNpb3VzIGNvZGUgdmlhIHdlYiBzY3JpcHRzLiI7aTozO3M6NToiRklMRVMiO2k6NDtzOjIwOiIvbmFtZT1bXlwmXSpcLnBocFwmLyI7fXM6ODoidXNlcnNBUEkiO2E6NTp7aTowO3M6NToiSjdBR3IiO2k6MTtzOjE=OiJSRVNUIHVzZXJzIEFQSSI7aToyO3M6MjA3OiJUaGlzIHByb3RlY3Rpb24gaXMgYXV=b21hdGljYWxseSBhY3RpdmF=ZWQgYmVjYXVzZSB=aGlzIHR5cGUgb2YgYXR=YWNrIGNvdWxkIHJldmVhbCB5b3VyIGFkbWluIHVzZXJuYW1lIG9yIG9=aGVyIHVzZXIgaW5mby4gVGhpcyBwcm9=ZWN=aW9uIGNhbiBwcmV2ZW5=IGhhY2tlcnMgZnJvbSBkaXNjb3ZlcmluZyB1c2VyIGRhdGEgd2l=aG91dCBjcmVkZW5=aWFscy4iO2k6MztzOjY6IlNFUlZFUiI7aTo=O3M6MzI6Ii93cC1qc29uXC93cFwvdjJcL3VzZXJzXC9bMC=5XS9pIjt9czo4OiJVc2VyRW51bSI7YTo3OntpOjA7czo1OiJJMU5HOCI7aToxO3M6MTY6IlVzZXIgRW51bWVyYXRpb24iO2k6MjtzOjIwNzoiVGhpcyBwcm9=ZWN=aW9uIGlzIGF1dG9tYXRpY2FsbHkgYWN=aXZhdGVkIGJlY2F1c2UgdGhpcyB=eXBlIG9mIGF=dGFjayBjb3VsZCByZXZlYWwgeW91ciBhZG1pbiB1c2VybmFtZSBvciBvdGhlciB1c2VyIGluZm8uIFRoaXMgcHJvdGVjdGlvbiBjYW4gcHJldmVudCBoYWNrZXJzIGZyb2=gZGlzY292ZXJpbmcgdXNlciBkYXRhIHdpdGhvdXQgY3JlZGVudGlhbHMuIjtpOjM7czo3OiJSRVFVRVNUIjtpOjQ7czoxOToiL1wmYXV=aG9yPVswLTldK1wmLyI7aTo1O3M6NjoiU=VSVkVSIjtpOjY7czozMzoiL1wmUkVRVUVTVF9VUkk9KD8hXC93cC1hZG1pblwvKS9pIjt9czoxNDoiX2ZzX2Jsb2dfYWRtaW4iO2E6OTp7aTowO3M6NToiSjQ=Q2EiO2k6MTtzOjE2OiJGYWxzZSBibG9nX2FkbWluIjtpOjI7czoyMDA6IlRoaXMgcHJvdGVjdGlvbiBpcyBhdXRvbWF=aWNhbGx5IGFjdGl2YXRlZCBiZWNhdXNlIHRoaXMgdHlwZSBvZiBhdHRhY2sgY291bGQgYWxsb3cgYSBub24tYWRtaW4gdXNlciB=byBleHBsb2l=IHRoZSBHcmlkIEdhbGxlcnkgcGx1Z2luIGlmIHlvdSBoYXZlIGl=IGFuZCBwZXJmb3JtIGFkbWluIHRhc2tzIHdpdGhvdXQgYWRtaW4gY3JlZGVudGlhbHMuIjtpOjM7czo2OiJTRVJWRVIiO2k6NDtzOjIwOiIvXC9hZG1pbi1hamF4XC5waHAvaSI7aTo1O3M6NzoiUkVRVUVTVCI7aTo2O3M6MTk6Ii9cJl9mc19ibG9nX2FkbWluPS8iO2k6NztzOjc6IlJFUVVFU1QiO2k6ODtzOjE3OiIvXCZvcHRpb25fbmFtZT=vaSI7fX1zOjc6ImRiX3NjYW4iO2E6MzE6e3M6MTI6IiU8YSAldmlhZ3JhJSI7YToyOntpOjA7czo1OiJJQ1RIYyI7aToxO3M6MTMyOiIvPGFbXj5dKj5bXjxdKihwdXJjaGFzZXxvcmRlcnxidXl8Y2hlYXB8dmlhZ3JhfGxpc2lub3ByaWx8amFudXZpYXxmbHVveGV=aW5lfHBpbGxzfGNhc2htZXJlW1xzX1wtXSpzY2FyZnxvbmxpbmV8b3V=bGV=KVtePF=qPFwvYT4vaXMiO31zOjEyOiIlPHNjcmlwdCVceCUiO2E6Mjp7aTowO3M6NToiSjE4OFkiO2k6MTtzOjg=OiIvPHNjcmlwdFtePl=qPltePF=qKChbJyJdKShcXHhbYS1mMC=5XXsyfSkrXDJcXXxbJyJcXCwwLTlBLUZ4XXsyMDB9KS4rPzxcL3NjcmlwdD4vaXMiO31zOjEyOiIlPGEgJWNpYWxpcyUiO2E6Mjp7aTowO3M6NToiSjExN24iO2k6MTtzOjYxOiIvPGFbXj5dKig-fD5bXjxdKltcc19cLVwuXSspY2lhbGlzKFtcc19cLVwuXStbXjxdKjx8PClcL2E-L2lzIjt9czoxNToiJTxzY3JpcHQlZXZhbCglIjthOjI6e2k6MDtzOjU6IkoxODhCIjtpOjE7czo4NToiLzxzY3JpcHRbXj5dKj5bXjxdKigoWyciXSkoXFx4W2EtZjAtOV17Mn=pK1wyXF18ZXZhbHxzZXR=aW1lb3V=KVxzKlwoLis_PFwvc2NyaXB=Pi9pcyI7fXM6MTU6IiU8YSAlbGV=cm96b2xlJSI7YToyOntpOjA7czo1OiJJQ1RJNSI7aToxO3M6MTczOiIvPGFbXj5dKig-W148XSpbXHNfXC1cLl=rfD4pKHB1cmNoYXNlfG9yZGVyfGJ1eXxjaGVhcHxzeW5=aHJvaWR8bGV=cm96b2xlfGxpc2lub3ByaWx8amFudXZpYXxmbHVveGV=aW5lfHBpbGxzfGNhc2htZXJlW1xzX1wtXSpzY2FyZnxvbmxpbmV8b3V=bGV=KShbXHNfXC1cLl=rW148XSo8fDwpXC9hPi9pcyI7fXM6Mjc6IiU8c2NyaXB=JTovL2JpdC4lPC9zY3JpcHQ-JSI7YToyOntpOjA7czo1OiJKQU5FQiI7aToxO3M6NTg6Ii88c2NyaXB=W14-XSpzcmM9KFsnIl=pW2ZodHBzXDpdKlwvXC9iaXRcLi4rPzxcL3NjcmlwdD4vaXMiO31zOjMwOiIlPHNjcmlwdCUvL2RvbG9oZW4uJTwvc2NyaXB=PiUiO2E6Mjp7aTowO3M6NToiSjUyOFUiO2k6MTtzOjYyOiIvPHNjcmlwdFtePl=qc3JjPShbJyJdKVtmaHRwc1w6XSpcL1wvZG9sb2hlblwuLis_PFwvc2NyaXB=Pi9pcyI7fXM6Mjc6IiVldmFsKFN=cmluZy5mcm9tQ2hhckNvZGUoJSI7YToyOntpOjA7czo1OiJKNVFDTyI7aToxO3M6NTk6Ii9ldmFsXChbXHNhLXpfMC=5XC5cKF=qZnJvbUNoYXJDb2RlXChbMC=5LFxzXStbXClcc1=rO1xzKi9pIjt9czozNDoiJTxzY3JpcHQlLy9zYXNrbWFkZS5uZXQlPC9zY3JpcHQ-JSI7YToyOntpOjA7czo1OiJKODFJRCI7aToxO3M6NjM6Ii88c2NyaXB=W14-XSpzcmM9KFsnIl=pW2ZodHBzXDpdKlwvXC9zYXNrbWFkZVwuLis_PFwvc2NyaXB=Pi9pcyI7fXM6MTk6IiU8c2NyaXB=JS5jbGtzaXRlLiUiO2E6Mjp7aTowO3M6NToiSkE2RU8iO2k6MTtzOjcxOiIvPHNjcmlwdFtePl=qc3JjPShbJyJdKVtmaHRwc1w6XSpcL1wvcFswLTldK1wuY2xrc2l=ZVwuLis_PFwvc2NyaXB=Pi9pcyI7fXM6MjA6IiU8c2NyaXB=JS5wdmNsb3Vkcy4lIjthOjI6e2k6MDtzOjU6IkpBNkY4IjtpOjE7czo3MzoiLzxzY3JpcHRbXj5dKnNyYz=oWyciXSlbZmh=cHNcOl=qXC9cL3BsWzAtOV=rXC5wdmNsb3Vkc1wuLis_PFwvc2NyaXB=Pi9pcyI7fXM6MTU6IiUvL2xpbmthbmdvb2QuJSI7YToyOntpOjA7czo1OiJLMVNEZCI7aToxO3M6Njg6Ii88KGF8c2NyaXB=KVtePl=qKGhyZWZ8c3JjKT1bJyJmaHRwc1w6XStcL1wvbGlua2FuZ29vZFwuLis_PFwvXDE-L2lzIjt9czozMToiJTxzY3JpcHQlOi8vbWFkc2Fucy4lPC9zY3JpcHQ-JSI7YToyOntpOjA7czo1OiJKQjNCaSI7aToxO3M6NTg6Ii88c2NyaXB=W14-XSpzcmM9WyciZmh=cHNcOl=rXC9cL21hZHNhbnNcLi4rPzxcL3NjcmlwdD4vaXMiO31zOjQzOiIlPHNjcmlwdCU6Ly9zaW1wbGVvbmVsaW5lLm9ubGluZSU8L3NjcmlwdD4lIjthOjI6e2k6MDtzOjU6IkpCNUROIjtpOjE7czo3MDoiLzxzY3JpcHRbXj5dKnNyYz1bJyJmaHRwc1w6XStcL1wvc2ltcGxlb25lbGluZVwub25saW5lLis_PFwvc2NyaXB=Pi9pcyI7fXM6Mjk6IiU8c2NyaXB=JS5waHA_em9uZSU8L3NjcmlwdD4lIjthOjI6e2k6MDtzOjU6IkpCRUJQIjtpOjE7czo5MDoiLzxzY3JpcHRbXj5dKnNyYz=oWyciXSlbZmh=cHNcOl=qXC9cL1teXD9dK1w_KHpvbmV8aWR8cHx6fHQpKz1bXGRfXStbJyJcJl=uKz88XC9zY3JpcHQ-L2lzIjt9czo=OToiJTxzY3JpcHQlOi8vc2NyaXB=cy5=cmFzbmFsdGVteXJlY29yZHMlPC9zY3JpcHQ-JSI7YToyOntpOjA7czo1OiJKQktJViI7aToxO3M6NzY6Ii88c2NyaXB=W14-XSpzcmM9WyciZmh=cHNcOl=rXC9cL3NjcmlwdHNcLnRyYXNuYWx=ZW15cmVjb3Jkcy4rPzxcL3NjcmlwdD4vaXMiO31zOjQ=OiIlPGEgaHJlZj=iI2Z1bGwiJTxwIGlkPSJmdWxsIiBjbGFzcz=iaGlkZSI-JSI7YToyOntpOjA7czo1OiJKQkxHViI7aToxO3M6MTE1OiIvPGFbXj5dKmhyZWY9KFsnIl=pXCMoW2Etel8wLTldKylcMVtePl=qPnJlYWQgbW9yZTxcL2E-KFxzKjwocHxkaXYpIGlkPShbJyJdKVwyXDUgY2xhc3M9KFsnIl=paGlkZVw2Pi4qPzxcL1w=PikrL2lzIjt9czozNzoiJWRvY3VtZW5=LmNyZWF=ZUVsZW1lbnQlLmFwcGVuZENoaWxkJSI7YToyOntpOjA7czo1OiJLNjRCciI7aToxO3M6NTIyOiIvKDwoc2NyaXB=KVtePl=qPnxcL1wqXHMqWzAtOWEtel=rXHMqXCpcL3x2YXJ8Y29uc3QpK1xzKi4qPyhbYS16XzAtOV=rKVtccz1dK2RvY3VtZW5=XC5jcmVhdGVFbGVtZW5=W1woXHNdKyhTdHJpbmdcLmZyb21DaGFyQ29kZVwofFsnIlxcXSpzY3JpcHQpLis_XDNcLnNyY1tccz1dKyhTdHJpbmdcLmZyb21DaGFyQ29kZVwoW15cKV=rXCkrO1xzKnxbJyJodHBzOl=rXC9cL1teXD9dK1w_KHpvbmV8aWR8cHx6fHN8dCkrPVtcZF9dKykuKz8obG9jYXRpb25cLnJlcGxhY2VbXHNcKF=rKFN=cmluZ1wuZnJvbUNoYXJDb2RlXChbXlwpXStcKSs7XHMqfFsnImh=cHM6XStcL1wvW15cP1=rXD8oem9uZXxpZHxwfHp8c3x=KSs9W1xkX1=rKXxcM1wuYXBwZW5kQWZ=ZXJcKFteO1=rO1xzKikrLis_XC5hcHBlbmRDaGlsZFwoXDNcKS4rP1xzKihcfVtcKFwpO1xzXSp8PFwvXDI-XHMqfFwvXCpccypbXC8wLTlhLXpdK1xzKlwqXC9ccyp8JHw8XDJbXj5dK1wvXC9=cmFja1wuZGV2ZWxvcGZpcnN=bGluZVwuY29tW14-XSo-KSsvaXMiO31zOjQwOiIlPHNjcmlwdCVTdHJpbmcuZnJvbUNoYXJDb2RlKCU8L3NjcmlwdD4lIjthOjI6e2k6MDtzOjU6IkpDTExsIjtpOjE7czoxOTc6Ii88c2NyaXB=W14-XSo-XHMqKHZhcltcc2Etel8wLTldKz1ccypTdHJpbmdcLmZyb21DaGFyQ29kZVtcc1woXStbMC=5LFxzXStbXClcc1=rO1xzKikrKHZhclxzKihbYS16XzAtOV=rKVxzKj1ccypkb2N1bWVudFwuKGNyZWF=ZUVsZW1lbnR8Z2V=RWxlbWVudFthLXpdKylbXHNcKF=rW147XSs7XHMqXDNcLlteO1=rO1xzKikrPFwvc2NyaXB=Pi9pIjt9czoyNzoiJTxzY3JpcHQldmFyIF8weCU8L3NjcmlwdD4lIjthOjI6e2k6MDtzOjU6Iks=UUtzIjtpOjE7czozMDI6Ii88KHNjcmlwdClbXj5dKj4oXC9cKlxzKlswLTlhLXpdK1xzKlwqXC98dmFyfGNvbnN=fFwoZnVuY3Rpb24uKz9mdW5jdGlvbltcKFwpXHtcc1=rKStccyooKF8weFthLXpfMC=5XSspW1xzPV=rKFxbW15cXV=rW1xdLFxzXSspKztbXH1cc1=qKSsoKChfMHhbYS16XzAtOV=rKT9cKFxzKnwodmFyXHMqKT9ccyooXzB4W2Etel8wLTldKylbXHM9XSpmdW5jdGlvblteXHtdK1x7K1xzKikrW147XSpbO1xzXH1dKykrKHZhclxzKik_XHMqKF8weFthLXpfMC=5XSspW1xzPV=rXDQuK1wxMFteO1=rWztcc1x9XCh=aGlzXCldKzxcL1wxPi9pIjt9czo=NToiJTxzY3JpcHQlLy9jbG9uLmNvbGxlY3RmYXN=dHJhY2tzLiU8L3NjcmlwdD4lIjthOjI6e2k6MDtzOjU6IkszTUFiIjtpOjE7czo3ODoiLzxzY3JpcHRbXj5dKnNyYz=oWyciXSlbZmh=cHNcOl=qXC9cL2Nsb25cLmNvbGxlY3RmYXN=dHJhY2tzXC4uKz88XC9zY3JpcHQ-L2lzIjt9czozNDoiJTxzY3JpcHQlLy9taWtreW1heC5jb2=lPC9zY3JpcHQ-JSI7YToyOntpOjA7czo1OiJLM1BBZyI7aToxO3M6NjY6Ii88c2NyaXB=W14-XSpzcmM9KFsnIl=pW2ZodHBzXDpdKlwvXC9taWtreW1heFwuY29tLis_PFwvc2NyaXB=Pi9pcyI7fXM6NDE6IiU8c2NyaXB=JXNob3J=ZXN=TW9uZXRpemF=aW9uKCU8L3NjcmlwdD4lIjthOjI6e2k6MDtzOjU6Iks=NkFZIjtpOjE7czozMjQ6Ii88KHNjcmlwdClbXj5dKj5ccyooXC9cKlxzKlswLTlhLXpdK1xzKlwqXC9ccyp8XC9cL1teXG5dKlxzK3xbXChdKmZ1bmN=aW9uW15ce1=qXHtccyp8dmFyXHMqfGNvbnN=XHMqKSsoKFthLXpfMC=5XSspW1xzPV=rKFxbW15cXV=rW1xdLFxzXSt8KChbJyJdKVteXDpdK1w6XHMqKT9ce1teXH1dK1tcfSxcc1=rKSs7W1x9XHNdKikrKCh2YXJ8Y29uc3QpXHMqKFthLXpfMC=5XSspW1xzPV=rZG9jdW1lbnRcLlteXChdK1woKFN=cmluZ1wuZnJvbUNoYXJDb2RlXCh8WyciXXNjcmlwdFsnIl=pLitccyooXDEwXC4uK1xzKikrKStbXH1cKFwpO1xzXC9cXVw-XDxdKlwxXD4vaSI7fXM6MjM6IiU8c2NyaXB=PiUweCU8L3NjcmlwdD4lIjthOjI6e2k6MDtzOjU6Iks=ODBEIjtpOjE7czoxNjU6Ii88KHNjcmlwdClbXj5dKj5ccyooXC9cKlxzKlswLTlhLXpdK1xzKlwqXC9ccyp8dmFyfGNvbnN=KStccyooKFthLXpfMC=5XSspW1xzPV=rKFxbW15cXV=rW1xdLFxzXSspKztbXH1cc1=qKSsoLioweC4qXHMqKSt3aW5kb3dbXjtdK1s7XHNcfV=rXCh=aGlzXCkrWztcc1x9XSs8XC9cMT4vaSI7fXM6NDg6IiU8c2NyaXB=JS8vY2hlY2sucmVzb2x1dGlvbmRlc3Rpbi5jb2=lPC9zY3JpcHQ-JSI7YToyOntpOjA7czo1OiJLNDlCRCI7aToxO3M6ODM6Ii88c2NyaXB=W14-XSpzcmM9KFsnIl=pW2ZodHBzXDpdKlwvXC9jaGVja1wucmVzb2x1dGlvbmRlc3RpblwuY29tXC8uKz88XC9zY3JpcHQ-L2lzIjt9czozMzoiJTxzY3JpcHQlLy9nYWRzb2tzLmNvbSU8L3NjcmlwdD4lIjthOjI6e2k6MDtzOjU6Iks=UUw2IjtpOjE7czo2NToiLzxzY3JpcHRbXj5dKnNyYz=oWyciXSlbZmh=cHNcOl=qXC9cL2dhZHNva3NcLmNvbS4rPzxcL3NjcmlwdD4vaXMiO31zOjM1OiIlPHNjcmlwdCVkb2N1bWVudC53cml=ZSglPC9zY3JpcHQ-JSI7YToyOntpOjA7czo1OiJLNUVLMyI7aToxO3M6MjM3OiIvPChzY3JpcHQpW14-XSo-XHMqKFwvXCpccypbMC=5YS16XStccypcKlwvXHMqfFwvXC9bXlxuXSpccyt8W1woXSpmdW5jdGlvblteXHtdKlx7XHMqKSsodmFyXHMqKFthLXpfMC=5XSspXHMqPSguK3JldHVybiBcNFteXH1dK1tcfTtcc1=rfChbJyJdKWRhdGFcOnRleHRcL2phdmFzY3JpcHRcO2Jhc2U2NFwsW147XSs7XHMqKSkrLis_ZG9jdW1lbnRcLndyaXRlXCguKz9bJyJcK1=rXDRbJyJcK1=rLis_PFwvXDE-L2kiO31zOjMzOiIlPHNjcmlwdCUvL2pzLmRldmVsb3BlcnN=YXRzcy5nYSUiO2E6Mjp7aTowO3M6NToiSzgzRUkiO2k6MTtzOjcwOiIvPHNjcmlwdFtePl=qc3JjPVsnImZodHBzXDpdK1wvXC9qc1wuZGV2ZWxvcGVyc3RhdHNzXC4uKz88XC9zY3JpcHQ-L2lzIjt9czo=NzoiJTxzY3JpcHQlLy9zY3JpcHRzLmxvd2VyYmVmb3J3YXJkZW4uJTwvc2NyaXB=PiUiO2E6Mjp7aTowO3M6NToiSzk4QVEiO2k6MTtzOjgwOiIvPHNjcmlwdFtePl=qc3JjPShbJyJdKVtmaHRwc1w6XSpcL1wvc2NyaXB=c1wubG93ZXJiZWZvcndhcmRlblwuLis_PFwvc2NyaXB=Pi9pcyI7fXM6MzY6IiU8c2NyaXB=JS8vZnJpbWVkdWJsZS5jb2=lPC9zY3JpcHQ-JSI7YToyOntpOjA7czo1OiJLOVQ3UiI7aToxO3M6MTAwOiIvPHNjcmlwdFtePl=qc3JjPShbJyJdKVtmaHRwc1w6XSpcL1wvZnJpbWVkdWJsZVwuY29tLis_KDxcL3NjcmlwdD5ccyo8c2NyaXB=W14-XSo-XHMqKSo8XC9zY3JpcHQ-L2lzIjt9czozNjoiJTxzY3JpcHQlLy9maW5nZXJsaW5nLm9yZyU8L3NjcmlwdD4lIjthOjI6e2k6MDtzOjU6IktBNzdNIjtpOjE7czo2NjoiLzxzY3JpcHRbXj5dKnNyYz1bJyJmaHRwc1w6XSpcL1wvZmluZ2VybGluZ1wub3JnXC8uKz88XC9zY3JpcHQ-L2lzIjt9fXM6ODoiaHRhY2Nlc3MiO2E6MTY6e3M6Mjg6ImV4Y2VzaXZlIHNwYWNlcyBpbiAuaHRhY2Nlc3MiO2E6Mjp7aTowO3M6NToiSTVTOHEiO2k6MTtzOjMwOiIvW1xyXG5dKyhbXHNdezUwfXxbXHRdezEwfSkuKi8iO31zOjI2OiJleGNlc2l2ZSB=YWJzIGluIC5odGFjY2VzcyI7YToyOntpOjA7czo1OiJFQTg4UyI7aToxO3M6MzI6Ii9eKFtcdCBdezMwfXxbXHRdezEwfSkuKltcclxuXSsvIjt9czoyMjoiUmV3cml=ZVJ1bGUgbW9iaWxlIDMwMiI7YToyOntpOjA7czo1OiJENDVFOSI7aToxO3M6MTM4OiIvUmV3cml=ZUVuZ2luZSBvbi4rP1Jld3JpdGVSdWxlIFxeW1woXT9cLlwqW1wpXT9cJCBodHRwOlwvXC8obW9iaWxlLS4rP3wuKz9jb3VudChlcik_XC5waHB8Lis_XD9oPVswLTldKykgXFsoTFwsKT9SKD1bMC=5XXszfSk_KFwsTCk_XF=vc2kiO31zOjI2OiJwaHBfdmFsdWUgYXV=b19hcHBlbmRfZmlsZSI7YToyOntpOjA7czo1OiJEM=M2RiI7aToxO3M6MzE6Ii9waHBfdmFsdWUgYXV=b19hcHBlbmRfZmlsZSAuKy8iO31zOjQ3OiJUYWdlZCBSZXdyaXRlQ29uZCBIVFRQX1JFRkVSRVIgUmV3cml=ZVJ1bGUgSFRUUCI7YToyOntpOjA7czo1OiJJQUlHVCI7aToxO3M6MTU=OiIvXCNbYS16MC=5XStcIy4rP1Jld3JpdGVFbmdpbmUgb25ccytSZXdyaXRlQ29uZCBcJVx7SFRUUF9SRUZFUkVSXH=uKz9SZXdyaXRlUnVsZSBcXlwoXC5cKlwpXCQgaHR=cDpcL1wvLis_IFxbKExcLCk_Uj1bMC=5XXszfShcLEwpP1xdLis_XCNcL1thLXowLTldK1wjL2lzIjt9czoyNzoiRXJyb3JEb2N1bWVudCA=MDQgd3BwcG=ucGhwIjthOjI6e2k6MDtzOjU6IkRCSTYwIjtpOjE7czozMjoiL=Vycm9yRG9jdW1lbnQgNDA=IC4rd3BwcG1cLnBocC8iO31zOjU1OiJSZXdyaXRlQ29uZCBVU=VSX=FHRU5UIFJFRkVSRVIgUmV3cml=ZVJ1bGUgc3RhcnRpbmcucGhwIjthOjI6e2k6MDtzOjU6IktCNkp3IjtpOjE7czo5NDoiLyhSZXdyaXRlQ29uZCBcJVx7SFRUUF8oVVNFUl9BR=VOVHxSRUZFUkVSKVx9LitbXHJcbl=rXHMqKStSZXdyaXRlUnVsZS4rP1wvc3RhcnRpbmdcLnBocFw_LisvaSI7fXM6NDg6IlJld3JpdGVDb25kIEhUVFBfVVNFUl9BR=VOVCBSZXdyaXRlUnVsZSBodHRwIC5ydSI7YToyOntpOjA7czo1OiJGM1JCVyI7aToxO3M6MTA3OiIvKFJld3JpdGVFbmdpbmUgb25ccyspPyhSZXdyaXRlQ29uZCAuKj9IVFRQKFw6fF9BQ=NFUFR8X1VTRVJfQUdFTlQpLipccyspK1Jld3JpdGVSdWxlLio_IGh=dHAuKz9cLnJ1LipccyovaSI7fXM6NDk6IlJld3JpdGVDb25kIEhUVFBfVVNFUl9BR=VOVCBSZXdyaXRlUnVsZSBodHRwIC5waHAiO2E6Mjp7aTowO3M6NToiSTgxTDIiO2k6MTtzOjEwNToiLyhSZXdyaXRlRW5naW5lIG9uXHMrKT8oUmV3cml=ZUNvbmQgLio_SFRUUChcOnxfQUNDRVBUfF9VU=VSX=FHRU5UKS4rP2JvdC4rXHMrKStSZXdyaXRlUnVsZVxzKmh=dHAuK1xzKi9pIjt9czo3OToiUmV3cml=ZUVuZ2luZSBPbiBSZXdyaXRlQmFzZSBSZXdyaXRlQ29uZCBSZXdyaXRlUnVsZSBpbmRleC5waHAgcGFzc2luZyB2YXJpYWJsZSI7YToyOntpOjA7czo1OiJFQ=U4UyI7aToxO3M6MTc3OiIvUmV3cml=ZUVuZ2luZSBPblxzK1Jld3JpdGVCYXNlIFwvKFthLXowLTlcX1wtXSspXC9ccytSZXdyaXRlUnVsZSBcXmluZGV4W15cXV=rXF1ccysoUmV3cml=ZUNvbmQgLitccyspK1Jld3JpdGVSdWxlIFxeXChcLlwqXClcJCBcL1wxXC9pbmRleFwucGhwXD9bYS16MC=5XF9cLV=rPVwkMSBcW1teXF1dK1xdL2kiO31zOjY=OiJSZXdyaXRlRW5naW5lIG9uIFJld3JpdGVDb25kIEhUVFBfVVNFUl9BR=VOVCBSZXdyaXRlUnVsZSBodHRwIElQIjthOjI6e2k6MDtzOjU6IksxQ=JWIjtpOjE7czoyMDg6Ii8oUmV3cml=ZUVuZ2luZSBvblxzKyk_KFJld3JpdGVDb25kIFwlXHsoUkVRVUVTVF9VUkl8SFRUUF9SRUZFUkVSfEhUVFBfVVNFUl9BR=VOVClcfSg_ISBmYXZpY29uXC5pY28gXFspXHMrW15cIV=uK1xzKykrUmV3cml=ZVJ1bGUgLiogaHR=cDpcL1wvKD8hMTI3XC4pKFswLTldfFwlXHsoSFRUUF9IT1NUfFJFTU9URV9BRERSKVx9fHdpa2lwZWRpYVwub3JnKS4qL2kiO31zOjQyOiJSZXdyaXRlRW5naW5lIG9uIFVOQ=9ORElUSU9OQUwgUmV3cml=ZVJ1bGUiO2E6Mjp7aTowO3M6NToiSjlJSzQiO2k6MTtzOjE5NDoiLyhSZXdyaXRlQ29uZFxzXCVce=hUVFBfKFJFRkVSRVJ8VVNFUl9BR=VOVClcfVxzK1woZ29vZ2xlLitiaW5nLitccyopKlJld3JpdGVSdWxlIFxeW15cc1=rXHMrLis_KD88IShpbmRleFxcfC1maWxlc3wgaW5kZXh8bWluaWZ5fHJvdGVjdHxfYWxidW18X3Bob3RvfG5zbGF=ZXxhdGNoZXIpKVwucGhwXD9bXj1dKz1bXCRcJVx7XFxdKy4rL2kiO31zOjEwOToiUmV3cml=ZUNvbmQgRU5WOlJFRElSRUNUX1NUQVRVUyBSZXdyaXRlUnVsZSBSZXdyaXRlQ29uZCBSRUZFUkVSL1VTRVJfQUdFTlQgZ29vZ2xlL3lhaG9vL2JpbmcgUmV3cml=ZVJ1bGUgLnBocCI7YToyOntpOjA7czo1OiJHMTRCTSI7aToxO3M6MjYzOiIvUmV3cml=ZUNvbmRccytcJVx7RU5WXDpSRURJUkVDVF9TVEFUVVNcfVxzKzIwMFxzK1Jld3JpdGVSdWxlW1xeXC1cc1=rXFtbXlxdXStcXVxzKyhSZXdyaXRlQ29uZFxzK1wlXHtIVFRQXyhSRUZFUkVSfFVTRVJfQUdFTlQpXH1ccytcKCgoZ29vZ2xlfHlhaG9vfG1zbnxhb2x8YmluZykoXHx8XCkpKSsoXHMrXFtbXlxdXStcXSkqXHMrKStSZXdyaXRlUnVsZVxzK1xeXChbXlwpXStcKVwkXHMrW2Etel9cLTAtOV=rXC5waHBcP1wkMVxzK1teXF1dK1tcXVxzXSsvaSI7fXM6MjE6IkRpcmVjdG9yeUluZGV4ICFpbmRleCI7YToyOntpOjA7czo1OiJHNTRENyI7aToxO3M6NzM6Ii8oPzw9RGlyZWN=b3J5SW5kZXggKSg_IWluZGV4Lmh=bWwgfGluZGV4Lmh=bSApKC4rPykoPz1bXlwvXWluZGV4XC5waHApL2kiO31zOjM=OiJGaWxlc=1hdGNoIHBocCBBbGxvdyBEZW55IGZyb2=gYWxsIjthOjI6e2k6MDtzOjU6IksyVEU3IjtpOjE7czoxMjE6Ii8oPChGaWxlc=1hdGNoKVxzKiIoXChpbmRleFwpXC58XC5cKlxcXC5cKHBodG1sXHwpcGhwXCkqXCQiPlxzK=9yZGVyKFssXHNdKyhBbGxvd3xEZW55KSkrXHMrZnJvbVxzK2FsbFxzKzxcL1wyPlxzKil7Mix9L2kiO31zOjI5OiJSZXdyaXRlUnVsZSAucGhwIFFVRVJZX1NUUklORyI7YToyOntpOjA7czo1OiJLNDhOcyI7aToxO3M6OTU6Ii9SZXdyaXRlUnVsZVxzK1xeXC5cKi4rP1wvXChcLlwqXClcL1wkLis_XC5waHBcP1thLXpfMC=5XSs9XCQxXCZcJVx7UVVFUllfU1RSSU5HXH1ccytcW=xcXVxzKy9pIjt9fXM6NToia25vd24iO2E6MjU3OntzOjMzOiJDT=9LSUUgcHJlZ19tYXRjaCBmdW5jdGlvbl9leGlzdHMiO2E6Mjp7aTowO3M6NToiSDlCQW8iO2k6MTtzOjQ1MToiLzxcP1twaFxzXSsoZnVuY3Rpb25ccysoW2Etel8wLTldKylbXHNcKF=rKFwkW2Etel8wLTldKykqW1xzXClce1=rKChcJFthLXpfMC=5XSspXHMqPVxzKmltcGxvZGVcKFteO1=rfChhcnJheV9bXjtdKztccyopKnNyYW5kXCgoW2Etel8wLTldKylcKFwpXCkpOy4rPyhpZltcc1woXStpc3NldFtcc1woXStcJF9DT=9LSUVcWy4rP3xyZXR1cm4gKGltcGxvZGVcKFteO1=rfFw1KTtbXH1cc1=rKSkqKGlmW1xzXChcQF=rcHJlZ19tYXRjaFwoLis_aWZcW1xzXChcQF=rcHJlZ19tYXRjaFwoLis_aWZbXHNcKFxAXStmdW5jdGlvbl9leGlzdHNcKC4rPyhccytcfSl7M318KGVjaG98cHJpbnR8ZGllKVtcc1woXStcMltcc1woXSthcnJheVtcc1woMC=5LFwpXSs7XHMqfGZ1bmN=aW9uXHMrXDdcKC4rP3JldHVyblteO1=qO1tcc1x9XSsoKGhlYWRlcnxlY2hvKVwoW147XSo7XHMqKSspKCR8XD8-KS9pcyI7fXM6MzE6InNjcmlwdCBnb29nbGVibG9nY29udGFpbmVyIGV2YWwiO2E6Mjp7aTowO3M6NToiSzc=SGwiO2k6MTtzOjE5MToiLzxzY3JpcHRbXj5dKyhzcmM9WyciaHRwczpdK1wvXC8ocHJvcHV8Z298Ym9kZWxlbnxkb2xvaGVuKVwuW15cP1=rXD8oem9uZXxpZHxwfHopKz1cZCtbJyJcJl1bXj5dKj58KD5cKGZ1bmN=aW9uXChcKVx7dmFyIG4seCxlPVxbfGlkPSJnb29nbGVibG9nY29udGFpbmVyIikuK2V2YWxbXClcc1=qXCguKylccyo8XC9zY3JpcHQ-XHMqL2kiO31zOjIyOiJpbmNsdWRlIHBocDUucGhwIGFsb25lIjthOjI6e2k6MDtzOjU6IklCSkhaIjtpOjE7czoxNjU6Ii88XD9bcGhcc1=rKGlmXHMqXChpc1teXCldK1tcKVxzXHtdK3xccypcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcLykqW1xAXHNdKmluY2x1ZGVbXHNcKCciXSsoLis_XC5pKGN8XFwxNDMpb3wncGhwNVwucGhwKVsiJ1wpXSs7XHMqKGRpZVteO1=qO3xcMSkqW1xzXH1dKigkfFw_PikvaSI7fXM6Mjc6ImRvY3VtZW5=LndyaXRlIGlmcmFtZSBzbWFsbCI7YToyOntpOjA7czo1OiJFMkdDSCI7aToxO3M6MTYzOiIvKGRvY3VtZW5=XC53cml=ZVwoWyciXSk_PGlmcmFtZSBzcmM9WyciXWh=dHA6XC9cLyguKz8pKCAoaGVpZ2h=fHdpZHRoKT1bJyJdP1swLTVdWyciXT8pKyggc3R5bGU9WyciXXZpc2liaWxpdHk6W1x=IF=qaGlkZGVuW14-XSo-PFwvaWZyYW1lPnw-PFwvaWZyYW1lPlsnIl1cKSk7Ki9pIjt9czoyNzoiZG9jdW1lbnQud3JpdGUgaWZyYW1lIC5waHA1IjthOjI6e2k6MDtzOjU6IkozQkMwIjtpOjE7czoxMDg6Ii88c2NyaXB=W14-XSo-W1xzXDxcIVwtXSpkb2N1bWVudFwud3JpdGVbXChcc1=rdW5lc2NhcGVbXChccyciXStbXCUwLTlhLWZdK1snIlwpXHM7XStbXHNcLVwvXD5dKjxcL3NjcmlwdD4vaSI7fXM6MTA6ImFycmF5IGV2YWwiO2E6Mjp7aTowO3M6NToiSENHQVIiO2k6MTtzOjE3NzoiLygoXCRbXHtcJF=qW1wtXD5cLmEtel8wLTldKylbXH1cc1wuXSo9XHMqKChhcnJheShfbWFwKT98XCRbYS16XzAtOV=rKSpccypcKFteXCldKlwpW1wpXHNdKigsW15cKV=qXClbXClcc1=qKSopO1xzKikrXEA_ZXZhbFxzKihcL1wqW15cKl=qKFwqW15cKlwvXSopK1wvXHMqKSpcKC4qP1wyLipbXClcc1=rOy9pIjt9czoyNToiZG9jdW1lbnQud3JpdGUgaWZyYW1lIC5ydSI7YToyOntpOjA7czo1OiJKM=NHbyI7aToxO3M6ODg6Ii8oZG9jdW1lbnRcLndyaXRlfGVjaG8pW1woXHNdK1snIl=8aWZyYW1lIC4rKGxlZnRcOlxzKi18LnJ1XC8pLis8XC9pZnJhbWU-WyciXVtcc1wpO1=rL2kiO31zOjg6ImV2YWwgaGV4IjthOjI6e2k6MDtzOjU6Ikg3TDhGIjtpOjE7czo4MjoiL1xAP2V2YWxccypcKFthLXpfMC=5XHNcKF=qKFsiJ1=pW147XSooXFwoeFswLTlhLWZdezJ9fFxkezIsM3=pKStbXjtdKlwxW1wpXHNdKjsvaSI7fXM6MTk6ImZ1bmN=aW9uX2V4aXN=cyBlbW8iO2E6Mjp7aTowO3M6NToiRzJTOTEiO2k6MTtzOjc1OiIvPFw_W3BoXHNdKihpZiBcKFwhZnVuY3Rpb25fZXhpc3RzXCgnZW1vJ1wpLitleGl=O1x9fHdwX2Zvb3RzXChcKTspXHMqXD8-L2kiO31zOjM=OiJmdW5jdGlvbl9leGlzdHMgYmFzZTY=X2RlY29kZSBldmFsIjthOjI6e2k6MDtzOjU6Iko3MkFJIjtpOjE7czozMDM6Ii88XD9bcGhcc1=qKFwvXCooW14qXSpcKig_IVwvKSkqW14qXSpcKlwvXHMqfFwvXC9bXlxuXSpccyopKihcJFthLXpfMC=5XStccyo9W147XStbO1xzXSt8KFwkW1wkXHtdKlthLXpfMC=5XStcfSooXHMqXFtbXlxdXStcXSkqKVxzKj1ccyphcnJheSkqLio_KGlmXHMqXChccypcIWZ1bmN=aW9uX2V4aXN=c1xzKlwoLitbXClcc1=rW1x7XHNdKik_ZnVuY3Rpb25ccypbYS16XzAtOV=rXCguK1tcKVxzXStbXHtcc1wkYS16XzAtOVx9XHNcPVxAXSpiYXNlNjRfZGVjb2RlXHMqXCguK2V2YWxccypcKC4rW1wpO1xzXH1dKygkfFw_PikvaSI7fXM6Mjg6ImVjaG8gZ3ppbmZsYXRlIGJhc2U2NF9kZWNvZGUiO2E6Mjp7aTowO3M6NToiSjdFOWciO2k6MTtzOjE4NDoiLyg8XD8uKnxccypcI1thLXpfXC=9MC=5XStcI3xccypcJFthLXpfMC=5XStccyo9W147XSs7fFxzKlxAP2V2YWxccypcKC4qKXsyLH1bXHNcQF=qKGVjaG9bXChcc1xAXSspP2d6aW5mbGF=ZVtcKFxzXEBdK2Jhc2U2NF9kZWNvZGVbXChcc1=rLitbXClcc1=rO1xzKihcI1wvW2Etel9cLT=wLTldK1wjXHMqfFw_PnwkKSsvaSI7fXM6MjE6InByZWdfcmVwbGFjZSAvZSBhbG9uZSI7YToyOntpOjA7czo1OiJGNk85TSI7aToxO3M6MjA1OiIvPFw_W3BoXHNdKigoXEA_ZXJyb3JfcmVwb3J=aW5nXCh8XChcJFthLXpcXzAtOV=rXHMqPVxzKlwkXyhSRVFVRVN8R=V8UE9TKVRcWylbXlwpXSpbXClcJjtcc1=rKT9cQD9wcmVnX3JlcGxhY2VbXCggXHRdKyhbJyJdKShbXCFcL1wjXHxcQFwlXF5cKlx-XSkuKz9cNVtpbXN4XSplW2ltc3hdKlw=WyBcdF=qLFteLF=rLFteXCldK1tcKTtcc1=qKFw_PnwkKS9pIjt9czoxOToicHJlZ19yZXBsYWNlIC9lIGhleCI7YToyOntpOjA7czo1OiJJMkNFcCI7aToxO3M6NDk=OiIvKChcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcL1xzKnxcL1wvLipccyp8KFwkW2Etel8wLTldKylccyo9Lis7XHMqfGVycm9yX3JlcG9ydGluZ1woLio_XCkrO1xzKikqKFwkW2Etel8wLTldKylccyo9XHMqYXJyYXlcKChbXlwpXSpcKSg_ITspKSpbXlwpXSpcKTtccypmb3IuKz9cNS4rW1xzXHtdKlw=LitbXHNcfV=qKT8oKFwvezJ9W15cbl=qXG58XCRbYS16XzAtOV=rXHMqPVteO1=rO3xlY2hvW1xzXCgnIl=rW147XSs7KVxzKikqKFwkW2Etel8wLTldK1xzKj1ccyopP1xAPyhcJFthLXpfMC=5XSt8cHJlZ19yZXBsYWNlKVxzKlwoXHMqKFsnIl=pKFtcIVwvXCNcfFxAXCVcXlwqXH5dfFxcW3gwLTldezEsM3=pLis_KFwxMltpbXN4XSplW2ltc3hdKnxcXHg2NXxcXDE=NSlcMTFccyosXHMqKFsnIl1cXHhbMC=5QS1GXXsyfXxbJyJdP1wkKD8hY2IsIFwkZW5jb2RlZF92YWx1ZVxbXCRrZXlcXVwpOykoPyFyZXBsXC4nOykpW14sXSssW15cKV=rW1wpO1xzXSovaSI7fXM6MzE6InByZWdfcmVwbGFjZSAvZSBzdHJfcmVwbGFjZSBoZXgiO2E6Mjp7aTowO3M6NToiRjZGSW4iO2k6MTtzOjE=NjoiL1xAP3ByZWdfcmVwbGFjZVxzKlwoXHMqWyciXS4rW1wvXCNcfF1baXNdKmVbaXNdKlsnIl1ccyosXHMqXEA_KFwkXyhSRVFVRVN8R=V8UE9TKVRcW3xzdHJfcmVwbGFjZVwoKFsnIlxzLFwuXCRdKlxceFswLTlBLUZdWzAtOUEtRl=pKykuKlwpW1xzO1=qL2kiO31zOjE3OiJldmFsIGZyb21DaGFyQ29kZSI7YToyOntpOjA7czo1OiJKMjdFeCI7aToxO3M6MzAyOiIvKDxzY3JpcHRbXj5dKj5ccyooKCh2YXJccyopP1thLXpfMC=5XStccyooO1xzKlthLXpfMC=5XStccyo9XHMqW2Etel8wLTldW1xzXC5dKmxlbmd=aHxbXC49XStccyooWyInXSkuKj9cNlxzKnxbLD1dK1xzKlxbW15cXV=qXF=rXHMqKSs7XHMqKStmb3JbXlx7XStce1xzKlteXH1dK2Zyb21DaGFyQ29kZVwoW15cfV=rW1x9XHNdKyhbYS16XzAtOV=rXHMqPVteO1=rO1xzKikqZG9jdW1lbnRcLndyaXRlXCh8KGRvY3VtZW5=XC53cml=ZXxldmFsKVwoW147XSpmcm9tQ2hhckNvZGVcKClbXjtdKztccyo8XC9zY3JpcHQ-XHMqKSsvaSI7fXM6MjU6ImluaV9yZXN=b3JlIGJhc2U2NF9kZWNvZGUiO2E6Mjp7aTowO3M6NToiSDFPTmciO2k6MTtzOjk3OiIvPFw_W3BoXHNdK2luaV9yZXN=b3JlXHMqXCguK1xzKy4rYmFzZTY=X2RlY29kZVxzKlwoLitccysuK3BocFwuaW5pLitccysuK2Z3cml=ZVxzKlwoW1xTXHNdK1w_Pi9pIjt9czozMzoiZXJyb3JfcmVwb3J=aW5nIHZhcmlhYmxlLWZ1bmN=aW9uIjthOjI6e2k6MDtzOjU6Ikg2N=JSIjtpOjE7czozNDY6Ii88XD9bcGhcc1=rKFwvXCooW14qXSpcKig_IVwvKSkqW14qXSpcKlwvXHMqfChpbmlfc2V=fGVycm9yX3JlcG9ydGluZ3xzZXRfdGltZV9saW1pdClcKFteXCldKlwpO1xzKikraWZbXChcc1=rXCFkZWZpbmVkXChbXlwpXStbXClcc1=rXHtccypkZWZpbmVcKFteXCldK1tcKVxzXSs7XHMqaWZbXHNcKF=rXCFmdW5jdGlvbl9leGlzdHNcKChbIiddKS4rP1w=XClbXClcc1x7XSpmdW5jdGlvblxzKiguKz8pXChbXlwpXStcKVtcKVxzXHtdKy4rP1w1XChbXlwpXStcKTtccyooXCRbXj1cKDtdKylcKFteXCldKlwpKztccyouK1w2XChbXlwpXSpcKSs7XHMqcmV=dXJuW147XSs7KC4qJHxccypcPz4oLiokKT8pL2kiO31zOjE5OiJlY2hvIHNjcmlwdCBpZnJhbWUgIjthOjI6e2k6MDtzOjU6IkgxTjlkIjtpOjE7czoxMzk6Ii9cI1thLXpfXC=9MC=5XStcI1tcc1xAXStlY2hvLis8c2NyaXB=LitcLmNyZWF=ZUVsZW1lbnRbXChccyInXStpZnJhbWUuK1wuc3R5bGVcLihsZWZ=fHRvcCk9WyciXFxdKy=uKzxcL3NjcmlwdD4uKztccytcI1wvW2Etel9cLT=wLTldK1wjL2kiO31zOjEzOiJldmFsIF9SRVFVRVNUIjthOjI6e2k6MDtzOjU6Ikk=RURUIjtpOjE7czoxNDg6Ii9cQCooZXJyb3JfcmVwb3J=aW5nXCguK2Jhc2U2NF9kZWNvZGVcKC4rKSooPzwhbClldmFsKFxzKlwvXCouKlwqXC8pKlxzKlwoKFxzKlwvXCouKlwqXC8pKlxzKlwkXyhSRVFVRVN8R=V8UE9TKVRcWy4rP1xdLio_XCkoXHMqXC9cKi4qXCpcLykqW1xzO1=rL2kiO31zOjE4OiJmb3JlYWNoIGV2YWwgYXJyYXkiO2E6Mjp7aTowO3M6NToiSDE=TDciO2k6MTtzOjIyOToiLyhcL1wqXHMrKFthLXpfXC=wLTldKylccypcKlwvXHMqfDxcP1twaFxzXSspKFwkW2Etel8wLTldKylccyo9XHMqYXJyYXlbXjtdKztccyouKz9mdW5jdGlvbiAoW2Etel8wLTldKylcKC4rP3JldHVyblteO1=qO1s7XH1cc1=rKFwkW2Etel8wLTldKylccyo9XHMqXDRccypcKFxzKlwzW147XSs7XHMqZXZhbFwoXDVbXjtdK1snIlwpXH=7XHNdKyhcL1wqXHMrXC9cMlxzKlwqXC98Lis_KCR8XD8-KSkvaSI7fXM6MzE6ImV4Y2VzaXZlIHNwYWNlcyBpbiBoYXNoZWQgYmxvY2siO2E6Mjp7aTowO3M6NToiSTdVOWMiO2k6MTtzOjUxOiIvXCNccyooW2EtejAtOV=rKVxzKlwjW1xzXXs1MH=uK1xzK1wjXC9ccypcMVxzKlwjL2kiO31zOjI5OiJKYXZhc2NyaXB=IG9ic2N1cmUgZXZhbCBhcnJheSI7YToyOntpOjA7czo1OiJIM=E5ZCI7aToxO3M6MjQ2OiIvKFwvXCpccyooWzAtOWEtZl17MzJ9KVxzKlwqXC9ccyp8PChzY3JpcHQpW14-XSo-XHMqKSp2YXJccytbYS16XzAtOV=rXHMqPShccypbXFssXVxzKihbJyJdKShcXD94WzAtOWEtZl17Mn=pKlw1KStbXHNcXV=rO1xzKmRvY3VtZW5=XHMqKChcW1teXF1dK1tcXVxzXSspKyhcKChbYS16XzAtOV=rKFxbW15cXV=rW1xdXHNdKykqKSopK1wpK1s7XHNdKikrKFwvXCpbXHNcL1=qXDJccypcKlwvXHMqfDxcL1wzW14-XSo-XHMqKSovaXMiO31zOjMwOiJKYXZhU2NyaXB=IGZ1bmN=aW9uIHhWaWV3U3RhdGUiO2E6Mjp7aTowO3M6NToiRDc4TGoiO2k6MTtzOjEwNzoiLzxzY3JpcHQgbGFuZ3VhZ2U9WyciXUphdmFTY3JpcHRbJyJdPltcclxuIFx=XSpmdW5jdGlvbiBbYS16MC=5XStWaWV3U3RhdGVcKFwpKC4rP1tcclxuIFx=XSopKz88XC9zY3JpcHQ-L2kiO31zOjI5OiJhZGQtZGl2LWNvbnRlbnQgVmlhZ3JhIENpYWxpcyI7YToyOntpOjA7czo1OiJENDZIYiI7aToxO3M6ODk6Ii88XCEtLXN=YXJ=LWFkZC1kaXYtY29udGVudFswLTldKi=tPi4rVmlhZ3JhLitDaWFsaXMuKzxcIS=tZW5kLWFkZC1kaXYtY29udGVudFswLTldKi=tPi9pIjt9czoyMToiamF2YXNjcmlwdCBhcnJheSBldmFsIjthOjI6e2k6MDtzOjU6IkoxOEllIjtpOjE7czoyMDk6Ii88c2NyaXB=W14-XSo-W148XSooKChbJyJdKShcXHhbYS1mMC=5XXsyfSkrXDNcXXxbJyJcXCwwLTlBLUZ4XXsyMDB9fCh2YXJccysoW2Etel8wLTldKylccyo9XHMqKT8oWydcXSxcWyJcXHhdK1swLTlBLUZdKyl7MjAwfS4rPyhTdHJpbmdbXFtcc1=rXDRbXFtcc1xdMC=5XSt8ZXZhbClccypcKCl8KGV2YWwuKz9bMC=5XHNcLF17MzAwfSkpLis_PFwvc2NyaXB=Pi9pIjt9czoyNDoiaXNzZXQgUkVRVUVTVCBldmFsIGFsb25lIjthOjI6e2k6MDtzOjU6IkY4R=JPIjtpOjE7czoxNTQ6Ii88XD9bcGhcc1=rKFwkW19cLVw-XC5hLXowLTldK1xzKj1ccyooWyciXSkuKz9cMjtccyopKmlmW1xzXChdKyhbYS16XzAtOV=rXHMqXChccyopKlwkXyhSRVFVRVN8R=V8UE9TKVRcWy4rKHN5c3RlbXxldmFsKVwoLitccypleGl=W147XSpbO1xzKlx9XSsoJHxcPz4pL2kiO31zOjM=OiJpc3NldCBIVFRQX1VTRVJfQUdFTlQgaGVhZGVyIGFsb25lIjthOjI6e2k6MDtzOjU6Ikk3R=lVIjtpOjE7czoxMjA6Ii9pZlxzKlwoLipcJF9TRVJWRVJcW1snIl1IVFRQX1VTRVJfQUdFTlRbJyJdXF=oW15cKV=rW1wpXHNdK1x7W15cfV=rXH1ccyplbHNlW1x7XHNdKikqaGVhZGVyXChbJyJdTG9jYXRpb246IC4rO1tcfVxzXSsvaSI7fXM6MjU6InN=cnJldiBBc3NlcnQgZXZhbCBiYXNlNjQiO2E6Mjp7aTowO3M6NToiSzlOTG8iO2k6MTtzOjIxNjoiL1xzKy4rP1woWyJcJ1=oXFwxNDV8ZSkoXFwxNjZ8dikoXFwxNDF8YSkoXFwxNTR8bCkoXFwwNTB8XCgpKFxcMTQyfGIpKFxcMTQxfGEpKFxcMTYzfHMpKFxcMTQ1fGUpKFxcMDY2fDYpKFxcMDY=fDQpKFxcMTM3fF8pKFxcMTQ=fGQpKFxcMTQ1fGUpKFxcMTQzfGMpKFxcMTU3fG8pKFxcMTQ=fGQpKFxcMTQ1fGUpKFxcMDUwfFwoKS4rP1xcMDUxXFwwNTFcXDA3M1siXFwnXVwpOy9pIjt9czoyNDoiUmV=cnkgYmFzZTY=X2RlY29kZSBDdXJsIjthOjI6e2k6MDtzOjU6IkgyUkpNIjtpOjE7czoyNzU6Ii88XD9bXHNocF=qXEA_ZXJyb3JfcmVwb3J=aW5nXChbXHMwXStcKTtccyooKFwkW2Etel8wLTldK1xzKj1ccyopPyh1cmxkZWNvZGVbXHNcKF=rKT9cJF9DT=9LSUVcW1teXF1dK1xdK1tcKTtcc1=rKSsuK21haWxcKFteXCldK1wpK1tcc1x7XStwb3N=X3N=YXRzXCgoLis_ZnVuY3Rpb25ccysocG9zdF9zdGF=c3xfaG9zdDJpbnR8bWNofHNtdHBfbG9va3VwfHBvc3RfbWNoKSl7NX=uK3NvY2tldF9jbG9zZVwoW15cKV=rXCkrWztcc1x9XStkaWVcKFwpO1tcc1x9XSooJHxcPz4pL2lzIjt9czoyMDoicHJlZ19yZXBsYWNlIGFsbCBoZXgiO2E6Mjp7aTowO3M6NToiSjRRRGMiO2k6MTtzOjk=OiIvKFwkW2Etel8wLTldK1xzKj=pP1tcc1xAXSpwcmVnX3JlcGxhY2VccypcKFxzKlsnIl=oLikuKj9cMihbXlwpXSo_XHhbMC=5QS1GXXsyfSl7MTMsfS4rP1wpOy9pIjt9czoxNDoiaWZyYW1lIGluIGhlYWQiO2E6Mjp7aTowO3M6NToiSzExTkgiO2k6MTtzOjQ5OiIvXDxpZnJhbWUgLitcPFwvaWZyYW1lXD5ccyooPz1cPFwvaCgzbWx8ZWFkKVw-KS9pIjt9czozNjoiVGFnZ2VkIHNjcmlwdCB=cnkgZG9jdW1lbnQuYm9keSBldmFsIjthOjI6e2k6MDtzOjU6IkcyR=RHIjtpOjE7czoxODc6Ii88XCEtLVthLXpfMC=5XHNdKy=tPlxzKjxzY3JpcHQgLis_KGJkdl9yZWZfcGlkPShbMC=5XSspOy4rPzxcL3NjcmlwdD5ccyo8c2NyaXB=IC4rP3BpZD1cMnx=cnlce2RvY3VtZW5=XC5ib2R5Lis_ZXZhbCkuKz88XC9zY3JpcHQ-XHMqKDxub3NjcmlwdC4rPFwvbm9zY3JpcHQ-XHMqKT88XCEtLVtcL2Etel8wLTlcc1=rLS=-L2kiO31zOjI5OiJUYWdnZWQgdHJ5IGRvY3VtZW5=LmJvZHkgZXZhbCI7YToyOntpOjA7czo1OiJJQjNKOCI7aToxO3M6ODY6Ii9cL1wqXHMqKFswLTlhLWZdKylccypcKlwvXHMqLio_dHJ5XHtkb2N1bWVudFwuYm9keS4rP2V2YWwuKz9ccytcL1wqW1xzXC9dK1wxXHMqXCpcLy9pIjt9czozNzoiZXZhbCB2YXJpYWJsZS1mdW5jdGlvbiBsb25nLW5iLXN=cmluZyI7YToyOntpOjA7czo1OiJJMVJESiI7aToxO3M6MTcyOiIvKChcL1wvLit8XC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC98XCRbYS16XzAtOVxbXF1ce1x9JyJdK1xzKj1bXlw7XSs7KVxzKikqXEA_KGV2YWx8YXNzZXJ=KVwoXHMqKFwkW2Etel8wLTlcW1xdXHtcfSciXStcKFxzKikrWyciXVthLXpfMC=5XC9cLVwrXD1cc117MjAwLH1bJyJdXCkrO1xzKi9pIjt9czo=MToiZnVuY3Rpb24gb2JfZ2V=X2xldmVsIG9iX3N=YXJ=IGFkZF9hY3Rpb24iO2E6Mjp7aTowO3M6NToiSjRVQmEiO2k6MTtzOjI3OToiLzxcP1twaFxzXSsoXC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC9ccyp8XC9cL1teXG5dKlxuXHMqfFwkW2Etel8wLTldK1xzKj1bXjtdKztccyp8ZXJyb3JfcmVwb3J=aW5nXChbXjtdKztccyp8ZGVmaW5lXChbXjtdKztccyopKigoKGFkZF9hY3Rpb258YWRkX3N1Ym1lbnVfcGFnZSlccypcKFtccyciYS16XzAtOV=rXFx4WzAtOWEtZl17Mn1bXjtdK1tcKTtcc1x9XSopKyhlY2hvW1woXHMnXFwiYS16XzAtOV=rXFx4WzAtOWEtZl17Mn1bXjtdK1tcKTtcc1x9XSopKikrKCR8XD8-KS9pIjt9czoyNjoiaGVhZCBzY3JpcHQgZG9jdW1lbnQud3JpdGUiO2E6Mjp7aTowO3M6NToiSkNVTXQiO2k6MTtzOjYyOiIvKD88PVw8XC9oZWFkXD4pXDxzY3JpcHQuKz9kb2N1bWVudFwud3JpdGVcKC4rP1w8XC9zY3JpcHRcPi9pcyI7fXM6MTQ6InNjcmlwdCBodHRwIElQIjthOjI6e2k6MDtzOjU6Iks4RDhTIjtpOjE7czo3NTI6Ii8oPzwhWyciXSk8c2NyaXB=W14-XSooc3JjPVsnImZodHBzXDpdK1wvKChbXC98XC5dWzAtOV=rKXs=fXxcLyhbYS16X1wtMC=5XStcLik_KGpzXC5kb25hdGVsbG9mbG93Zmlyc3RseVwuZ2F8b2Znb2dvYXRhblwuY29tfGpzXC5kaWdlc3Rjb2xlY3RcLmNvbXwzdndwXC5vcmd8aG9=b3Bwb25lbnRzXC5zaXRlfG9uY2xhc3ZyXC5jb218cHVzaHNhclwuY29tfHNjcmlwdHNcLnRyYXNuYWx=ZW15cmVjb3Jkc1wuY29tfGV4YW1ob21lXC5uZXR8dXVzdG91Z2h=b25tYVwub3JnfHZvaXBuZXdzd2lyZVwubmV=fGFsbHlvdXdhbnRcLm9ubGluZXxlZWR1ZWxlbWVudHNcLmNvbXxjZG5zXC53c3xhZHNwdHBcLmNvbXxqc29uXC5nZG58Y2xvdWRmbGFyZVwuc29sdXRpb25zfGNvaW5bXC1dP2hpdmVcLmNvbXxmcmVlaHRtbDV=ZW1wbGF=ZXNcLmNvbXxpN3dwXC5vcmd8bG9jYXRpb25mb3JleHBlcnRcLmNvbXxzdHJpbmdlbmdpbmVzXC5jb2=pKVwvfGNvbGxlY3RcLmpzfFwvd3AtaW5jbHVkZXNcL2pzXC9qY3JvcFwvanF1ZXJ5XC5qc3w-LipodHRwOlwvXC9tYnMtc3VwcG9ydFwuY29tXC9qc1wvanF1ZXJ5XC5taW5cLnBocC4qZG9jdW1lbnRcLndyaXRlXChbIiddPHNjcmlwdC4qXC9zY3JpcHQpW14-XSo-XHMqKDxcL3NjcmlwdD5ccyo8c2NyaXB=W14-XSo-XHMqdmFyXHMrKFxTKylccyo9XHMqbmV3XHMrQ29pbkhpdmVcLkFub255bW91c1tcKCciXHNdKyk_Lio_KFxzKlw3XC5zdGFydFwoXCk7W1xzXH1dKik_PFwvc2NyaXB=Pi9pIjt9czoxODoic2NyaXB=IGVuY29kZSBldmFsIjthOjI6e2k6MDtzOjU6IkoxRUdFIjtpOjE7czoxOTA6Ii8odmFyXHMqKFthLXpfMC=5XSspXHMqPVxzKmZ1bmN=aW9uW15ce1=rXHtccyopP3ZhclxzKltfXC1cPlwuYS16MC=5XStccyo9XHMqKFN=cmluZyk_XFtccypbJyJdKFxceFswLTlBLUZdezJ9fFteXF1dKj9mcm9tQ2hhckNvZGUpK1siJ11bXlxdXSpcXS4rPyhce2FbMC=5XSp8XDJ8ZXZhbClccypcKFteXCldKltcKVxzXH1dKzsqL2kiO31zOjU=OiJUYWdnZWQgYmFzZTY=X2RlY29kZSBmaWxlX2dldF9jb25=ZW5=cyBwb3NpdGlvbiBpZnJhbWUiO2E6Mjp7aTowO3M6NToiRzRGSVYiO2k6MTtzOjM5MzoiLygoXC9cKnxcIylccyooW2Etel8wLTldK1xzKihcMnxcKlwvKSlccyouKz9iYXNlNjRfZGVjb2RlLis_XHMqLis_ZmlsZV9nZXRfY29udGVudHMuKz9ccyouKz9wb3NpdGlvbi4rP1xzKi4rPzxcL2lmcmFtZT4uK1xzKihcL1wqfFwjKVtcL1xzXSpcM3xpZlxzKlwoW15ce1=qKChnb29nbGV8Ym9=fHlhaG9vfGJpbmd8SFRUUF9VU=VSX=FHRU5UKVteXHtdKyl7NSx9XHsoKFwkW2Etel8wLTldK1tcc1wuXCtdKj1ccyopPyhzaHVmZmxlfGFycmF5KVwoW147XSs7XHMqKSpmb3JlYWNoXChbXlx7XStce1xzKmlmXHMqXChwcmVnX21hdGNoXHMqXChbXlx7XStce1xzKi4rPyhbXEBcflxzXSooYmFzZTY=X2RlY29kZXxmaWxlX2dldF9jb25=ZW5=cylccypcKCl7M3=uKz9ccyooXH1ccyopezN9KS9pIjt9czoxNToic2NyaXB=IGFqYXggUE9DIjthOjI6e2k6MDtzOjU6IkkyN=F2IjtpOjE7czoyNTk6Ii88c2NyaXB=W14-XSsoVkJTY3JpcHQuKz9DcmVhdGVPYmplY3RcKFsnIl1TY3JpcHRpbmdcLkZpbGVTeXN=ZW1PYmplY3RbJyJdXCkuKz9cLkNyZWF=ZVRleHRGaWxlXCguKz9cLldyaXRlLis_Q3JlYXRlT2JqZWN=XChbJyJdV1NjcmlwdFwuU2hlbGxbJyJdXCkuKz98YWpheC5waHBbJyJdPlsnIl1QT=NbJyJdfD5ccyooXCRbXD1cflxbXF1ce1x9XChcKV9cOjtcKyciXCFcP1wuLFx8XC9cXF=qKXsyMCx9KD88PVwpXChcKTspKVxzKjxcL3NjcmlwdD4vaXMiO31zOjI2OiJ=YXJnZXRzIGFycmF5IEpBUGx1Z2luRG9uZSI7YToyOntpOjA7czo1OiJKQzhHVSI7aToxO3M6NzY6Ii8oXC9cL2ZpbGVzXHMrKT9cJHRhcmdldHNccyo9XHMqYXJyYXlcKC4rP2VjaG9bXHMiJ1=rSkFQbHVnaW5Eb25lW1xzIic7XSsvaXMiO31zOjE1OiJpbmNsdWRlIGZhdmljb24iO2E6Mjp7aTowO3M6NToiSjI1Q1AiO2k6MTtzOjQ3OiIvW1xyXG5dK1tccztcQF=qaW5jbHVkZS4rZmF2aWNvblwuaWNvWyciXCk7XSsvaSI7fXM6MTU6ImFkZF9maWx=ZXIgY3JlZCI7YToyOntpOjA7czo1OiJKM=pBcyI7aToxO3M6ODY6Ii9hZGRfZmlsdGVyXCgndGVtcGxhdGVfaW5jbHVkZScsJ2dldF9jcmVkJywxXCk7XHMrYWRkX2ZpbHRlclwoJ3NodXRkb3duJywnY3JlZCcsMFwpOy9pIjt9czoyMToicHJlZ19yZXBsYWNlIHN=cnJldiBlIjthOjI6e2k6MDtzOjU6Iko1OThQIjtpOjE7czoxOTQ6Ii8oXCR8dmFyXHMrKVthLXpfMC=5XHNcLl=rPVxzKihbJyJdZVwvXCpcLlwvWyciXTtccypwcmVnX3JlcGxhY2VcKFxzKnN=cnJldlwoLipcKTt8W1xbYXJ5XSsoWyJccydcLF=qXFwoeFswLTlhLWZdezJ9fFswLTldezIsM3=pKStbIlxzJ1xdO1=qKChcWypbYS16XzAtOV=rXFspK1swLTldK1xdK1xzKlwoW15cKV=qXCkrWztcc1=qKSskKS9pIjt9czo3NzoiZnVuY3Rpb25fZXhpc3RzIGdldCBmaWxlIGZ1bmN=aW9uIGN1cmxfaW5pdCBmaWxlX2dldF9jb25=ZW5=cyBmb3BlbiBjdXJsX2V4ZWMiO2E6Mjp7aTowO3M6NToiRzJQQUkiO2k6MTtzOjM3NDoiLzxcP1twaFxzXSsoKGluaV9zZXR8XCRbYS16XzAtOV=rXHMqPSlbXjtdKztccyopKmZ1bmN=aW9uXHMrKFthLXpfMC=5XSspW15ce1=rW1xzXHtdKyhcJFthLXpfMC=5XStccyo9W147XSs7XHMqKSooZm9yZWFjaFteXHtdK1tcc1x7XSsoXCRbYS16XzAtOV=rXHMqKFxbW15cXV=rXF=rXHMqKSo9XHMqKT9jdXJsX2luaXQuKz9yZXR1cm5bXjtdKjt8KHJldHVyblxzKyk_Y3VybF9bXjtdKztccyopK1tcfVxzXSsoKFwkW2Etel8wLTldK1xzKj1ccyopPyhcJF9TRVJWRVJcW3xcM1wofGZvcGVuXCh8ZndyaXRlXCh8ZmNsb3NlXCgpW147XSs7XHMqKSooaWZbXHNcKF=rKGZpbGVfZXhpc3RzXCh8XCRfKFJFUVVFU3xHRXxQT1MpVFxbKS4rP1wzXCguKyl7Mn=vaXMiO31zOjMxOiJlcnJvcl9yZXBvcnRpbmcgaW5jbHVkZSB3cC1hcHBzIjthOjI6e2k6MDtzOjU6Iko3RUNMIjtpOjE7czoxNzc6Ii8oKFwkW2Etel8wLTldK1tccz1dKyk_KGVycm9yX3JlcG9ydGluZ3xpbmlfc2V=fGdldGVudnxzdWJzdHIpXChbXlwpXSpcKSs7XHMqKSpcQCoocmVxdWlyZXxpbmNsdWRlKShfb25jZSk_W1woIidcc1=rW147XSt3cC=oaW5jbHVkZXNbXC9pbnRdKnxoZWFkfGFwcHN8dGV4dCkrXC5waHBbIiddW1wpO1xzXSsvaSI7fXM6MzU6InJlcXVpcmUgY2dpLWxvY2FsIHBocCBjb21tZW5=IGFsb25lIjthOjI6e2k6MDtzOjU6Ikk4N=JQIjtpOjE7czo1OTE6Ii88XD9bcGhcc1=rKFwvXCooW14qXSpcKig_IVwvKSkqW14qXSpcKlwvXHMqfFxAKSoocmVxdWlyZXxpbmNsdWRlKShfb25jZSkqW1woXHNdKyhbXjtdKztbXHJcbl=rKFxzKihhZGRfYWN=aW9ufGRlZmluZSlcKFteO1=rO1tcclxuXSt8ZnVuY3Rpb25ccytbYS16XzAtOV=rXChbXlx7XStceyhccysuKltcclxuXSspK1x9XHMrKSsoXC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC9ccyp8aWZccypcKFxzKihcJFthLXpfMC=5XSspW15ce1=rXHtccyopK2FkZF9maWx=ZXJbXHNcKF=rWyciXWFsbF9wbHVnaW5zWyciLFxzXSsoW2Etel8wLTldKylbXjtdKztccypmdW5jdGlvblxzK1wxMltcc1woXSsoXCRbYS16XzAtOV=rKVteXHtdK1x7XHMqKCg7XHMqXH1ccyp8KGlmW1xzXChdK2lzX3BsdWdpbl9hY3RpdmV8dW5zZXQpW1xzXChdK1teXCldK1tcc1wpXHtdK3wuKlwxMS4qXHMqKStyZXR1cm5ccytcMTMpK3xcJF9TRVJWRVJbXFtce11bIiddRE9DVU1FTlRfUk9PVFsnIl1bXF1cfV1bXHNcLl=rWyInXVtcLlwvXSp3cC1bXjtdK3xbJyJdY2dpLWxvY2FsXC8uKz9cLnBocFsnIl1bXHNcKV=qKTtbXH1cc1=rKFwjLipccyopKigkfFw_PikvaSI7fXM6NTI6Im9iX3N=YXJ=IGd6aW5mbGF=ZSBvYl9nZXRfY29udGVudHMgb2JfZW5kX2NsZWFuIGV2YWwiO2E6Mjp7aTowO3M6NToiRzM2RDgiO2k6MTtzOjMyMToiLzxcP1twaFxzXSooW2lmXChcc1whXSpkZWZpbmUoZFxzKlwoW15cKV=rfFxzKlwoW14sXSssXHMqKFthLXpfMC=5XChdKykpW15cKV=qW1wpO1xzXHtcfV=rKSooXEB8XCRbYS16XzAtOV=rW1xzXC5dKj1ccyopKm9iX3N=YXJ=XHMqXCgoWyciXHNdKyguKj8pWyciXHNdK1wpO1xzKmZ1bmN=aW9uXHMrXDZcKC4rP2Z1bmN=aW9uXHMrXDMuK3JldHVyblxzKihbJyJdKVteXDddKlw3fGd6aW5mbGF=ZVtcKFxzXStvYl9nZXRfY29udGVudHNbXChcKTtcc1=rb2JfZW5kX2NsZWFuW1woXCk7XHNdK2V2YWxcKFteXCldK1tcKVxzXSopO1tcc1x9XSooJHxcPz5ccyopL2lzIjt9czoxNzoidGFnZ2VkIGlmcmFtZSAxcHgiO2E6Mjp7aTowO3M6NToiSjNJSWEiO2k6MTtzOjEwMToiLzxcIS=tIC4rPyAtLT5ccyo8aWZyYW1lIHdpZHRoPSIxcHgiIGhlaWdodD=iMXB4IiBzcmM9Imh=dHA6XC9cL1tePl=rPlxzKjxcL2lmcmFtZT5ccyo8XCEtLSAuKz8gLS=-L2kiO31zOjI5OiJzY3JpcHQgYWZ=ZXIgY2xvc2luZyBib2R5IHRhZyI7YToyOntpOjA7czo1OiJKMUFIViI7aToxO3M6MTE2OiIvKD88PSg_PCFcPFwvdGl=bGVcPilcPFwvKGJvZHl8aGVhZClcPikoXHMqPCgoc2NyaXB=fGEpW1xzPl=uKj88XC8oXDR8Ym9keSl8bWV=YVtePl=qKT5ccyopKyg_PVw8KGJvZHl8XC9odG1sKVw-KS9pcyI7fXM6Mjc6InZhciBSIGZ1bmN=aW9uIHBZTXVTIHdpbmRvdyI7YToyOntpOjA7czo1OiJINkpMTSI7aToxO3M6MjIxOiIvPHNjcmlwdFtePl=qPlxzKih2YXJccyspPyhbYS16XzAtOV=rKVxzKj1ccypcWy4rPygoW2Etel8wLTldKylccyooXFtbXlxdXStbXF1cc1=qKSs9XHMqXDJcW1teXF1dK1tcXVxzXStcKy4rd2luZG93W1xbXHNdK1wyW1xbXHNdK1teXF1dK1tcXVxzXSooPVw=fCxcMlteXF1dK1tcXVxzXCldKylbXH=7XHNdK3xmdW5jdGlvbiBwWU11U1woLis_XClcKHdpbmRvd1wpKTxcL3NjcmlwdD4vaSI7fXM6MzE6IlRhZ2dlZCBlY2hvIHNjcmlwdCBldmFsIEhleEhleF8iO2E6Mjp7aTowO3M6NToiS=FGRjEiO2k6MTtzOjE5NToiL1wjKFthLXowLTldKylcI1xzK2VjaG9ccyciXSs8c2NyaXB=Ki4rP2V2YWwuKz8oW2EtejAtOV1bYS16MC=5XVxfKXsxMDB9Lis_PFwvc2NyaXB=PltccyciO1=rXCNcL1wxXCN8PFw_W3BoXHNdKyg_PS4qZXhlY1woKFwkW2Etel8wLTldKykpXDNccyo9XHMqXCRfKFJFUVVFU3xHRXxQT1MpVC4rZXhlY1woXDNbXjtdKztccyooJHxcPz4pL2lzIjt9czozMToidmFyaWFibGUgY3JlYXRlX2Z1bmN=aW9uIHN=cnJldiI7YToyOntpOjA7czo1OiJHMklJMSI7aToxO3M6MjQ2OiIvPFw_W3BoXHNdKihcL1wqW15cKl=qKFwqW15cKlwvXSopK1wvXHMqfFwvXC9bXlxuXSpccyspKigoXCRbYS16XzAtOV=rKVxzKj=pPy4rZnVuY3Rpb25ccyooW2Etel8wLTldKilcKC4rPyhldmFsXChcNVwofGJhc2U2NF9kZWNvZGVcKHxccypcNFxzKlwoXHMqc3RycmV2XCgpLis_KFwpXHMqKXsyLH=7XHMqKGV2YWxcKC4rPyhcKVxzKil7Mix9O1xzKnxcJFthLXpfMC=5XStccyo9W147XSs7XHMqfFwxXHMqKSooJHxcPz5ccyopL2kiO31zOjIyOiJodG1sIGVtYmVkIG9iamVjdCBodG1sIjthOjI6e2k6MDtzOjU6IktCREJTIjtpOjE7czoxNDE6Ii8oPChodG1sfGhlYWR8dGl=bGUpPlxzKikrKGhhY2tlZC5ieVteXG5dKlxzKig8XC9bYS16XSs-XHMqKSsuKykrPChzY3JpcHR8b2JqZWN=fGVtYmVkKS4rPFwvKHNjcmlwdHxvYmplY3R8ZW1iZWQpPlxzKig8XC8oaHRtbHxib2R5KT5ccyopKy9pcyI7fXM6MzY6InJlcXVpcmUgbmV3IFNBUEVfY2xpZW5=IHJldHVybl9saW5rcyI7YToyOntpOjA7czo1OiJHMUNOaiI7aToxO3M6Njc6Ii8oXCRbYS16XzAtOV=rKVxzKj1ccypuZXdccypTQVBFX2NsaWVudFwoLis_XDEtPnJldHVybl9saW5rc1woXCk7L3MiO31zOjkzOiJpZiBmdW5jdGlvbl9leGlzdHMgX3BocF9jYWNoZV9zcGVlZHVwX2Z1bmNfb3B=aW1pemVyXyByZWdpc3Rlcl9zaHV=ZG93bl9mdW5jdGlvbiBvYl9lbmRfZmx1c2giO2E6Mjp7aTowO3M6NToiRjZHN2oiO2k6MTtzOjE1MDoiL1s7XHNdKmlmXHMqXChcIWZ1bmN=aW9uX2V4aXN=c1woWycgIl=rX3BocF9jYWNoZV9zcGVlZHVwX2Z1bmNfb3B=aW1pemVyX1snICJdK1wpXCkuKz9yZWdpc3Rlcl9zaHV=ZG93bl9mdW5jdGlvblwoWycgIl=rb2JfZW5kX2ZsdXNoWycgIl=rXClbO1xzXSpcfS9zIjt9czo=NDoiZXJyb3JfcmVwb3J=aW5nIGluaV9zZXQgaWYgY291bnQgUE9TVCByZXR1cm4iO2E6Mjp7aTowO3M6NToiSzFWTUkiO2k6MTtzOjQ2NDoiL2lmW1xzXChcIV=rKFxAKihERUZJTkVbZF=qXCgoWyciXSkuKj9cM3woXCRbYS16XzAtOV=rKVxzKihcW1teXF1dKlxdXHMqKSo9XHMqKFsnIl=pLio_XDZ8ZXJyb3JfcmVwb3J=aW5nXCgpKFtcKVxzXHtdK3xbXjtdKjtbXHNcfV=qKSl7Myx9Lis_KChcJFthLXpfXSspWzAtOV=qXHMqKFxbW15cXV=qXF1ccyopKj1ccypbJyJodHBzXDpdK1wvXC9bXjtdKjtbXHNcfV=qKSsoLis_KGZpbGVfZ2V=X2NvbnRlbnRzfGN1cmxfZXhlY3xzZXRjb29raWUpXChcOVteO1=qWztcc1=rKXszLH=oKGVjaG9bXHNcKCJdK1w5fGV4aXQpW147XSo7W1x9XHNdKikrKC4rXH1bXHNcfV=qXC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC9ccyopKnwoXEAqKGVycm9yX3JlcG9ydGluZ3xpbmlfc2V=KVwoW147XStbO1xzXSspezJ9aWZbXHNcKF=rW2Etel=rW1xzXChdK1wkX1BPU1QuK3JldHVybiBcJFthLXowLTldK1s7XHNcfV=rL2kiO31zOjM4OiJkaXYgVmlhZ3JhIENpYWxpcyBzY3JpcHQgc3R5bGUuZGlzcGxheSI7YToyOntpOjA7czo1OiJEOUhDZiI7aToxO3M6MTQzOiIvPGRpdiBpZD1bJyJdKFtePl=qKVsnIl=-LipWaWFncmEuK=NpYWxpcy4qPFwvZGl2PltcclxuIFx=XSo8c2NyaXB=W14-XSo-Lipkb2N1bWVudFwuZ2V=RWxlbWVudEJ5SWRcKFsiJ11cMVsiJ11cKVwuc3R5bGVcLmRpc3BsYXkuKjxcL3NjcmlwdD4vaSI7fXM6NzE6InBocCB2YXJpYWJsZSBhcnJheSBiYXNlNjRfZGVjb2RlIGZ1bmN=aW9uX2V4aXN=cyBudW1lcmljLW5hbWVkIGZ1bmN=aW9uIjthOjI6e2k6MDtzOjU6Iko2OEdiIjtpOjE7czo=MzE6Ii8oXC9cKihbXlwqXSpcKlteXC9dKSpbXlwqXSpcKlwvXHMqfFwvXC9bXlxuXSpccyspKlwkW2Etel8wLTknIlxbXF1cc1=rPVxzKmFycmF5XCguKj9iYXNlNjRfZGVjb2RlXCguKz9cKSs7XHMqKChpZlxzKlwoXCFmdW5jdGlvbl9leGlzdHNcKFsiJ11fWzAtOV=rWyInXVtcKVxzXStce1xzKnxcPz5ccyo8XD9bcGhcc1=qKSpmdW5jdGlvbiAoW2Etel8wLTldKylcKC4rP1x9W1x9XHNdKygoXD8-XHMqPFw_W3BoXHNdKikqXEA_XCRHTE9CQUxTXHMqKFxbW15cXV=qXF=rXHMqfFx7W15cfV=qXH=rXHMqKStcKFteO1=rO1xzKikrLis_KChcJFthLXpfMC=5XStccyo9XHMqKT8oZXZhbHxcJEdMT=JBTFMoXHMqXFtbXlxdXSpcXStccyp8XHtbXlx9XSpcfSspKylccypcKChbXjtdKylbXCk7XH1cc1=rKSspKy4rKFwxfFw1XHMqXChbXjtdKztbXCk7XH1cc1=qKS9pIjt9czozMjoiVGFnZ2VkIGlmIGVtcHR5IHNjcmlwdCBldmFsIGVjaG8iO2E6Mjp7aTowO3M6NToiSTU1NkwiO2k6MTtzOjI1NjoiLyhcIyhbYS16MC=5XSspXCNccyppZltcc1woXStlbXB=eVwoKFwkW2Etel8wLTldKylcKVwpW1xzXHtdK1wzW1xzJyI9XSt8Xik8c2NyaXB=W14-XSooPlxzKlx7XzB4W2Etel8wLTldKlxzKj1ccypmdW5jdGlvblwoXzB4W2Etel8wLTldKltcKVxzXHtdK3JldHVyblxzK18weFthLXpfMC=5XSpcLnRvU3RyaW5nXCh8PlxzKmV2YWxcKFxzKmZ1bmN=aW9uXCgpLitccyo8XC9zY3JpcHQ-W1xzJyI7XSooZWNobyBcM1tccztcfV=rXCNcL1wyXCN8JCkvaSI7fXM6NDQ6InZhciBIVFRQX1VTRVJfQUdFTlQgaWYgbWF=Y2ggc3RyaW5nIHZhciBlbHNlIjthOjI6e2k6MDtzOjU6IkhBTDhxIjtpOjE7czoxNzM6Ii8oXCRbYS16XzAtOV=rKVxzKj1ccypcJF9TRVJWRVJcW1siJ11IVFRQX1VTRVJfQUdFTlRbJyJdXF=7XHMqKC4rXHMqKSo_aWZccypcKFtcJGEtel8wLTlcc1=rXChbXixdKyxccypcMVtcKVxzXStce1xzKigoaGVhZGVyfGV4aXR8ZGllKVteO1=qO1xzKikrKFx9XHMqZWxzZVxzKlx7W15cfV=rKT9cfS9pIjt9czozNDoiZGl2IHBocCBlcnJvcl9yZXBvcnRpbmcgZm9wZW4gaHR=cCI7YToyOntpOjA7czo1OiJHOFE3WCI7aToxO3M6ODQ6Ii88ZGl2IFtePl=qPlxzKjxcP1twaFxzXStlcnJvcl9yZXBvcnRpbmdcKC4rP2ZvcGVuXChbIiddaHR=cDpcL1wvLis_XD8-XHMqPFwvZGl2Pi9pcyI7fXM6Njk6IkRPQ1VNRU5UX1JPT1QgaWYgZmlsZV9leGlzdHMgZmlsZV9nZXRfY29udGVudHMgZ3ppbmZsYXRlIHByZWdfcmVwbGFjZSI7YToyOntpOjA7czo1OiJKM=NCbSI7aToxO3M6NTI=OiIvKFwkKFthLXpfMC=5XSspXHMqPVteO1=qO1xzKnxlY2hvW147XSo7XHMqfFxAKihbYS16XzAtOV=rKVxzKlwoXHMqKStcJF9TRVJWRVJbXHNcW1x7XSsoWyInXSkoRE9DVU1FTlRfUk9PVHxTQ1JJUFRfTkFNRSlcNFtcc1xdXH1dKy4rPyhmdW5jdGlvblxzK1wzXHMqXChbXlx7XStce1xzKnxpZltcc1woXStmaWxlX2V4aXN=c1xzKlwoLis_KVwkKFthLXpfMC=5XSspXHMqPVtcc1xAXSooZmlsZV9nZXRfY29udGVudHNccypcKFxzKlwkXDIuKz9cJChbYS16XzAtOV=rKVxzKj1bXHNcQF=qZ3ppbmZsYXRlXHMqXChccypcJFw3Lis_cHJlZ19yZXBsYWNlLis_XCk7W1x9XHNdK3xzY2FuZGlyXHMqXChbXjtdKztccypmb3JlYWNoXHMqXChcJFw3LisoZndyaXRlXHMqXChbXjtdKztccypmY2xvc2V8ZmlsZV9wdXRfY29udGVudHMpXHMqXChbXjtdKyg7W1x9XHNdKyh1bmxpbmtccypcKFxzKlwkXDJcKXwoXCRbYS16XzAtOV=rXHMqPVteO1=qO1xzKikqKGlmW1xzXChdK1teXHtdK1x7XHMqKSplY2hvW147XSopKSs7XHMqKS9pcyI7fXM6NTQ6ImZ1bmN=aW9uIGZvdXJvZm91ciBhZGRfZmlsdGVyIGFsbF9wbHVnaW5zIGZvdXJvZm91cl9wcCI7YToyOntpOjA7czo1OiJJMkg5bSI7aToxO3M6NDY4OiIvPFw_W3BoXHNdKygoXC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC9ccyp8XC9cL1teXG5dKlxuXHMqfFwkW2Etel8wLTldK1xzKj1bXjtdKztccyp8ZXJyb3JfcmVwb3J=aW5nXChbXjtdKztccyp8ZGVmaW5lXChbXjtdKztccyopKmZ1bmN=aW9uXHMrKChbYS16XzAtOV=rKVtcc1woXSsoXCRbYS16XzAtOV=rKS4rP3Vuc2V=W1xzXChdK1w2LityZXR1cm5ccytcNnwoW2Etel8wLTldKylbXlx7XStce1xzKmlmW1xzXChdK1tpc19dKmZpbGVbX2V4aXN=XHNdKlwoXHMqKFteXCldKylbXlxuXStcbltce1xzXSpyZWFkZmlsZVtcc1woXStcOCkuKz8pK2FkZF9maWx=ZXJbXHNcKF=rWyInXWFsbF9wbHVnaW5zWyxccyInXStcNVsiJ1wpO1xzXSsoW1wvXEBdKmFkZF8oYWN=aW9ufGZpbHRlcilbXHNcKF=rW14sXSssWyciXHNdKihcN3xmdW5jdGlvblxzKlwoLityZXR1cm4pW147XSpbXHNcfVwvXCk7XSspKigkfFw_PikvaXMiO31zOjE=OiJwIHBheWRheSBsb2FucyI7YToyOntpOjA7czo1OiJHNUJDSyI7aToxO3M6NDY6Ii88cFtePl=qPlxzKi4rP3BheWRheSBsb2FuLis_W1xyXG5dK1xzKjxcL3A-L2kiO31zOjI2OiJzY3JpcHQgc3JjIGVhcm5tb25leWRvLmNvbSI7YToyOntpOjA7czo1OiJKMVM5ayI7aToxO3M6MjIxOiIvKDwoc2NyaXB=fGEpW14-XSsoaHJlZj1bJyJdW2ZodHBzbDpdKlwvXC8oc2VjdXJlXC5wYXl6YSlbXj5dKz5ccyo8aW1nW14-XSspP3NyYz1bJyJdW2ZodHBzbDpdKlwvXC8oXDR8c3RhdFwudXVzdG91Z2h=b25tYXxjZG5cLmFsbHlvdXdhbnR8Y2RuXC5lZWR1ZWxlbWVudHN8b25saW5lLXNhbGUyNHxlYXJubW9uZXlkb3xnY2NhbmFkYXxnMDApXC5bY29dLis_XHMqPFwvXDI-XHMqKSsvaSI7fXM6OTI6InBocCB2YXIgYXJyYXkgdmFyIHRleHQgaWYgZnVuY3Rpb25fZXhpc3RzIGZ1bmN=aW9uIGZvcmVhY2ggY2hyIHJldHVybiB2YXJpYWJsZSBmdW5jdGlvbiB=ZXh=IjthOjI6e2k6MDtzOjU6Ikk=RUwxIjtpOjE7czozOTE6Ii88XD9bcGhcc1=rKFwkW2Etel8wLTldKyhccypcW1teXF1dK1xdKykqW1xzXC5cK1wtXSo9XHMqKChhcnJheVwofFwkXHspPygoWyciXSkuKj9cNnxbMC=5XCxdK3xcJFthLXpfMC=5XSsoXHMqXFtbXlxdXStcXSspKilbXC5cLFxzXClcfV=qKSs7XHMqKSsoKGlmXHMqXChbXlx7XStce1xzKik_ZnVuY3Rpb25bXlx7XStcey4qcmV=dXJuW147XSo7W1xzXH1dKykqKGlmXHMqXChbXlx7XStce1xzKik_KGVjaG98cHJpbnR8ZGllfGZvcihlYWNoKT9ccypcKFteXHtdKylbXHNcKFx7XSsoXCRbYS16XzAtOV=rKFxzKlxbW15cXV=rXF=rKSpbXHNcLlwrXC1dKj1ccypbXjtdKztbXH1cc1=qKSpcJFthLXpfMC=5XSsoXHMqXFtbXlxdXStcXSspKlxzKlwoW147XSo7W1xzXH1dKigkfFw_PikvaXMiO31zOjM2OiJUYWdnZWQgZXJyb3JfcmVwb3J=aW5nIGJhc2U2NF9kZWNvZGUiO2E6Mjp7aTowO3M6NToiSTRSSkkiO2k6MTtzOjE4NToiLyhcL1wqLis_XCpcL3w8XCEtLS4rPy=tPilccyooaWZbXCggXCFdK2RlZmluZWRcKFteXCldK1tcKSBce1=rLio_ZGVmaW5lXChbXlwpXStcKSs7W1xzXH1dKikqKChcQHxcJFthLXpfMC=5XStccypbXC49XSspKihlcnJvcl9yZXBvcnRpbmd8aW5pX3NldHxvYl9zdGFydClcKC4rPykrYmFzZTY=X2RlY29kZVwoLis_XDEvaXMiO31zOjQzOiJUYWdnZWQgY3JlYXRlRWxlbWVudCBzY3JpcHQgc3JjIGFwcGVuZENoaWxkIjthOjI6e2k6MDtzOjU6Iks4REFUIjtpOjE7czo2NDY6Ii8oPChzY3JpcHQpW14-XSo-fFwvXCpccypbMC=5YS16XStccypcKlwvfEVsZW1lbnRcLnByb3RvdHlwZVwuYXBwZW5kQWZ=ZXJccyo9XHMqZnVuY3Rpb24uKmZ1bmN=aW9uW1woXClcc1=qXHtccyp8dmFyKStccyouKj8oW2Etel8wLTldKylbXHM9XStkb2N1bWVudFwuY3JlYXRlRWxlbWVudFtcKFxzXSsoU3RyaW5nXC5mcm9tQ2hhckNvZGVcKC4rP1wzXC5zcmNbXHM9XSt8WyciXXNjcmlwdFsnIl=uKz9cM1wuc3JjW1xzPV=rU3RyaW5nXC5mcm9tQ2hhckNvZGVcKFteXCldK1wpKztccyp8dmFyXHMqKFthLXpfMC=5XSspW1xzPV=rZG9jdW1lbnRcLmdldEVsZW1lbnRzQnlUYWdOYW1lXChbJyJdc2NyaXB=WyciXVwpO1xzKnZhclxzKihbYS16XzAtOV=rKVtccz1dK3RydWU7XHMqKChmb3JbXChcc1=rKHZhclxzKik_KFthLXpfMC=5XSspW1xzPV=rXDVbXlx7XStce1xzKnxpZltcKFxzXSt8W1x9XHNdKmVsc2VccyooXHtbXlx9XSpbXH1cc1=rKT8pKihcNVxbXDEwXF1cLnNyY3xcM1wuc3JjfFw2KVtccz1dKyhcNVxbXDEwXF1cLnNyY3xcM1wuc3JjfHRydWV8ZmFsc2UpW1wpXHNceztdKykrKSsuKz9cLmFwcGVuZENoaWxkXChcM1wpLio_XHMqKFtcfVwoXCk7XHNdK3xcL1wqXHMqWzAtOWEtel=rXHMqXCpcL1xzKnwkfDxcL1wyPikrL2kiO31zOjM3OiJQSFAgVmFycyBDb25jYXQgVmFyaWFibGUgRnVuY3Rpb24gRU5EIjthOjI6e2k6MDtzOjU6Iks1VkVYIjtpOjE7czo=OTc6Ii88XD9bcGhcc1=rKChcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcL1xzKikqfFxAP2Vycm9yX3JlcG9ydGluZ1tcKDBcKVxzXSs7XHMqfGZ1bmN=aW9uXHMrW2Etel8wLTldK1woW15ce1=rW1x7XHNdKykqKFwkW2Etel8wLTldKyhccypcW1teXF1dK1xdKykqW1xzXC5dKj1ccyooKFsnIl=pLio_XDd8XCRbYS16XzAtOV=rKFxzKlxbW15cXV=rXF=rKSopW147XSo7XHMqKSs_KFwkW2Etel8wLTldKyhccypcW1teXF1dK1xdKykqXHMqPVxzKik_XEA_KFwkW2Etel8wLTldKyhccypcW1teXF1dK1xdKykqfHN=cl9yZXBsYWNlfGNyZWF=ZV9mdW5jdGlvbilccypcKFteXCldKi4qPygoXCRbYS16XzAtOV=rKFxzKlxbW15cXV=rXF=rKSpccyo9KT9bXEBcc1=qXCRbYS16XzAtOV=rKFxzKlxbW15cXV=rXF=rKSpccypcKCguKzt8W147XSo7KVxzKikrKFwvXCooW14qXSpcKig_IVwvKSkqW14qXSpcKlwvXHMqfFx9XHMqKSooJHxcPz4oXHMqPGZvcm=uKz88XC9mb3JtPik_KS9pIjt9czo2NToiZGl2IHNjcmlwdCBkb2N1bWVudCBnZXRFbGVtZW5=QnlJZCB2aXNpYmlsaXR5IGhpZGRlbiBkaXNwbGF5IG5vbmUiO2E6Mjp7aTowO3M6NToiRjVKN2MiO2k6MTtzOjI=ODoiLzxkaXYgaWQ9WyciXShbYS16XF8wLTldKylbJyJdLis_PFwvZGl2PlxzKjxzY3JpcHRbXj5dKj5ccyooKGZ1bmN=aW9uXHMoPyFoaWRlbWVzc2FnZSkoW2EtelxfMC=5XSspfGlmKVtcc1woXStbXlwpXSpbXClcc1x7XSopPyhkb2N1bWVudFwuZ2V=RWxlbWVudEJ5SWRcKFsiJ11cMVsiJ11cKVwuc3R5bGVcLih2aXNpYmlsaXR5fGRpc3BsYXkpXHMqPVxzKlsiJ1=oaGlkZGVufG5vbmUpWyInXTtccyopK1tcc1x9XSo8XC9zY3JpcHQ-L2kiO31zOjQ3OiJhZGRfYWN=aW9uIHdwX2Zvb3RlciBzZXJ2ZSBleGFtcGxlX2FkbWluX25vdGljZSI7YToyOntpOjA7czo1OiJHQjNDTCI7aToxO3M6MTYzOiIvKGFkZF9hY3Rpb25cKFxzKlsnIl=od3BfZm9vdGVyfGluaXR8YWRtaW5fbm9=aWNlcylbJyJdWyxcc1=rKFxAP2NyZWF=ZV9mdW5jdGlvbltcc1woXSspP1snIl=oLis_YmFzZTY=X2RlY29kZS4rP3xleGFtcGxlX2FkbWluX25vdGljZXxzZXJ2ZSlbJyJdW1xzXCldKztccyopezIsfS9pIjt9czo1MToiUEhQIGVycm9yX3JlcG9ydGluZyBpZiAhaXNzZXQgdmFyaWFibGUgZnVuY3Rpb24gRU5EIjthOjI6e2k6MDtzOjU6IkkzMktBIjtpOjE7czoyMzY6Ii8oKGVycm9yX3JlcG9ydGluZ1xzKlwofFwkW2Etel8wLTldK1xzKj=pW147XSs7XHMqKSppZlxzKlwoLis_XCkrXHMqXHtccyooKFwkW2Etel8wLTldKylccyo9W147XSs7XHMqKSooKFwkW2Etel8wLTldKylccyo9W147XSs7XHMqKSooKFwkW2Etel8wLTldKylccyo9K1xzKik_KFw=fFw2KVxzKlwoLis_KFwkW2Etel8wLTldK1xzKj1ccyopP1w4XHMqXChbXlwpXSpcKStbXHMnIlwpO1=qXH=rXHMqKFxufCQpL2lzIjt9czo2Njoic2NyaXB=IGlmIG5hdmlnYXRvciB1c2VyQWdlbnQgbWF=Y2ggZG9jdW1lbnQgd3JpdGUgc2NyaXB=IHNyYyBodHRwIjthOjI6e2k6MDtzOjU6IksySERGIjtpOjE7czozNjE6Ii88c2NyaXB=W14-XSo-KChcL1wqXHMqWzAtOWEtel=rXHMqXCpcL3x2YXJ8Y29uc3R8XHMpKigoXzB4W2Etel8wLTldKylbXHM9XSsoXFtbXlxdXStbXF=sXHNdKykrO1tcfVxzXSopKygoKF8weFthLXpfMC=5XSspP1woXHMqfCh2YXJccyopP1xzKihfMHhbYS16XzAtOV=rKVtccz1dKmZ1bmN=aW9uW15ce1=rXHsrXHMqKStbXjtdKls7XHNcfV=rKSsodmFyXHMqKT9ccypcOFtccz1dK1w=LitcMTBbXjtdK1s7XHNcfVwodGhpc1wpXSt8aWZbXHNcKF=rbmF2aWdhdG9yXC51c2VyQWdlbnRcLm1hdGNoXCguKz9ce1xzKmRvY3VtZW5=XC53cml=ZVwoWyInXTxzY3IuKz8gc3JjPVsnIl1odHRwLis_XClbO1x9XHNdKyk8XC9zY3JpcHQ-L2kiO31zOjYxOiJwaHAgZnVuY3Rpb24gQXJyYXkgcmV=dXJuIGJhc2U2NF9kZWNvZGUgcGhwIFZhcmlhYmxlIGZ1bmN=aW9uIjthOjI6e2k6MDtzOjU6IkkzNUU3IjtpOjE7czoxOTI6Ii9ePFw_W3BoXHNdK2Z1bmN=aW9uIGJhc2U2NFteXHtdK1x7XHMqcmV=dXJuIGJhc2U2NFteXH1dK1x9XHMqaWZbXHNcKF=raXNzZXRbXHNcKF=rXCRfKFJFUVVFU3xHRXxQT1MpVC4rPGJvZHkgb25sb2FkPVtccyciXFxdK2xvY2F=aW9uW14-XStbXjxdKzxcL2JvZHk-XHMqPFwvaHRtbD5ccyo8XD9bcGhcc1=qXH=rXHMqKCR8XD8-KS9pcyI7fXM6MjU6ImluY2x1ZGVfb25jZSByc3MtaW5mby5waHAiO2E6Mjp7aTowO3M6NToiS=JORWUiO2k6MTtzOjM4ODoiLygoKChcJFthLXpfMC=5XSsoXHMqXFtbXlxdXStcXSkqW1xzXC5dKj18aWZbXHNcKF18ZnVuY3Rpb25bXHNcKF1bXlx7XStbXHtcc1=rcmV=dXJ8Zm9yW1xzXChdW15cKV=rXCkrKVteO1=rO1tcfVxzXSopKihcJCg_IWtfb3BhZClbYS16XzAtOV=rKVtcc1wuXSo9KFteO1=qXFwoeFswLTlhLWZdezJ9fFswLTldezIsM3=pKStbXjtdKjtccyopKykrKGlmXHMqXChbXlx7XStce1xzKik_KChcJFthLXpfMC=5XStccyo9XHMqKT9cQD9cJFthLXpfMC=5XSsoXHMqXFtbXlxdXStcXSkqXCgoW147XSs7KD89XCkpKSpbXjtdKztccyopK1tcfVxzXSooKGlmfGZvcnxcNnxcL1wvKS4rXHMqfChlY2hvfGRpZSlbXHNcKF=qKFsnIl=pKFteXCJdKig_PD1cXCkiKSouKlwxN1tcKTtcc1=qKSovaSI7fXM6MjE6ImlzX2JvdCBfX3ZpYV9jb25=ZW5=KSI7YToyOntpOjA7czo1OiJHOU1CViI7aToxO3M6Mjg3OiIvKHZhclxzKyhbYS16XzAtOV=rKVxzKj1bXjtdKztccyopKihmdW5jdGlvblxzKyhbXlwoXSpjb29raWVbXlwoXSp8W2EtejAtOV17NDF9KVwoW15ce1=qXHsuKj8oKGRvY3VtZW5=LmNvb2tpZVteO1=rKDtccypbJyJdKT98cmV=dXJufGlmXHMqXChkb2N1bWVudFwucmVmZXJyZXJbXlx7XStce1xzKlwyXHMqPSlbXjtdKjtccyooXH1ccyopKykrKXs1LH=oXCgqZnVuY3Rpb25ccyooW1woXCldK3xbYS16MC=5XXs=MX1cKFteXHtdKilccypcey4qP1wpO1xzKlx9W1wpXHNdKlwxMFxzKjtccyopezIsfS9pcyI7fXM6NDE6InNldCB2YXIgc3RyX3JlcGxhY2UgdmFyIHZhcmlhYmxlIGZ1bmN=aW9uIjthOjI6e2k6MDtzOjU6IkY3TUM3IjtpOjE7czozMTc6Ii8oKFwkW2EtelxfMC=5XSsoXHMqXFtbXlxdXStcXSkqKVxzKj1ccypcQD9cJFthLXpcXzAtOV=rKFxzKlxbW15cXV=rXF=rKSpccypcKFxAP1wkXyhSRVFVRVNUfEdFVHxQT1NUfENPT=tJRSkoXHMqXFtbXlxdXStcXSspKlwpO1xzKikrKFwkW2EtelxfMC=5XSt8cHJlZ19yZXBsYWNlKVxzKlwoXHMqKFsnIl=pKFtcIVwvXCNcfFxAXCVcXlwqXH5dKS4rP1w5W2ltc3hdKmVbaW1zeF=qXDhccyosXHMqXDJccyosKChbXCRhLXpcXzAtOV=rKFxzKlxbW15cXV=rXF=pKnwnW14nXSonfCJbXiJdKiIpW1wuXHNdKikrXCkrO1xzKihkaWVcKFteXCldKlwpKzspPy9pIjt9czo2NDoiVGFnZ2VkIGVycm9yX3JlcG9ydGluZyBjdXJsX2luaXQgZmlsZV9nZXRfY29udGVudHMgZndyaXRlIHNjcmlwdCI7YToyOntpOjA7czo1OiJJQTlJTiI7aToxO3M6NTQ4OiIvPFw_W3BoXHNdKyhbXEBcL1wjXHNdKihlcnJvcl9yZXBvcnRpbmd8aW5pX3NldHxzZXRfdGltZV9saW1pdHxoZWFkZXIpXHMqXChbXlwpXSpbXCk7XHNdKykqKCgoWztcc1=qKFwkW2Etel8wLTldK1xzKj1bXjtdKztccyp8ZWxzZVtcc1x7XSopKSppZlxzKlwoW147XSspKygoZmlsZV9nZXRfY29udGVudHNccypcKHxta2RpclxzKlwofGN1cmxfW2Etel=rXHMqXCh8ZGllXHMqXCh8KGVjaG98cHJpbnQpW147XSs7XHMqKHJldHVybnxleGl=KSlbXlx9XStbXH1cc1=qKSspKyhlbHNlW1xzXHtdKik_KGlmW1xzXChdK1teXCldK1tcKVxzXHtdKik_KFwkW2Etel8wLTldK1xzKj1ccypmaWxlX2dldF9jb25=ZW5=c1woW147XSs7W1x9XHNdKikqKChpZlwoW15cKV=rfGVjaG9bXjtdKylbXClce1xzO1=rKSooXC8qKFwkW2Etel8wLTldK1xzKj=pP1tcQFxzXSooZm9wZW58ZndyaXRlfGZjbG9zZSlccypcKFteO1=rO1tcfVxzXSopezMsfSgoaGVhZGVyfGVjaG98cHJpbnR8aWZccypcKFteXHtdK1tce1xzXSpjaG1vZFxzKlwoKVteO1=qO1tcfVxzXSspKygkfFw_PikvaSI7fXM6NzA6ImZpbGVfZXhpc3RzIGN1cmxfaW5pdCBmaWxlX2dldF9jb25=ZW5=cyBmaWxlX3B1dF9jb25=ZW5=cyBpbmNsdWRlX29uY2UiO2E6Mjp7aTowO3M6NToiSEE=SjYiO2k6MTtzOjI=OToiLzxcP1twaFxzXSsoXCRbYS16XzAtOV=rKVxzKj1ccyouKz8oY3VybF9pbml=fGZpbGVfZ2V=X2NvbnRlbnRzXChbXHMnIl=raHR=cFtzXDpcL1=rKS4rP2ZpbGVfcHV=X2NvbnRlbnRzXChcMS4rPyhpbmNsdWRlX29uY2V8KFwkW2Etel8wLTldKylccyo9XHMqbmV3XHMrW2Etel8wLTldKylcKFwxLio_XCk7XHMqKC4qXDRbXjtdKjtccyp8XH1ccyp8ZWxzZVxzKnxce1xzKnxkaWVbXHNcKCciXStbXlwpXSpcKSs7XHMqKSooJHxcPz4pL2lzIjt9czozODoibG9uZyBzdHJpbmcgdmFyIGV2YWwgdmFyaWFibGUgZnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiS=MxS1YiO2k6MTtzOjU1NjoiLzwoXD98c2NyaXB=IGxhbmd1YWdlPSlbcGhccyciPl=rKFwkW2Etel8wLTldKyhccypcW1teXF1dK1xdKykqW1xzXC5dKj1ccyooIihbXiJdKig_PD1cXCkiKSpbXiJdKiJ8JyhbXiddKig_PD1cXCknKSpbXiddKid8XGQrfChcJFthLXpfMC=5XStbXFtcXVxkXC5dKikrKTtccyp8XC9cLy4qXHMqfFwvXCooW14qXSpcKig_IVwvKSkqW14qXSpcKlwvXHMqXHMqfFxAP2Vycm9yX3JlcG9ydGluZ1tcKDBcKVxzXSs7XHMqfGZvcihlYWNoKT9ccypcKChbXlx7XStce1teXH1dK1x9K1tcfVxzXSt8KFteO1=qO1xzKil7M3=pfFw_PlxzKjxcP1twaFxzXSspK2V2YWxccypcKCgoXCRbXCRce1=qW2Etel8wLTldKylbXH1cc1wpXSooXFtbXlxdXStcXStbXC5cc1x9XSp8PStccyooXCRbYS16XzAtOV=rfGNyZWF=ZV9mdW5jdGlvbikpKltcKVxzXHs7XH1dKikrKFwoLio_XClbXClcc1x9O1=rKSsoKFtcJFx7XSooXDE1fFwxM3xcNClbXHNcfV=qXCh8ZWNobylbXjtdKztbXH1cc1=qfFwvXCooW14qXSpcKig_IVwvKSkqW14qXSpcKlwvXHMqKSooXD8-KC4rJCk_fCR8PFwvc2NyaXB=PikvaSI7fXM6NDE6InBocCB2YXIgZXhwbG9kZSBudW1iZXJzIFZhcmlhYmxlIGZ1bmN=aW9uIjthOjI6e2k6MDtzOjU6IkgyNEZsIjtpOjE7czoyMTg6Ii88XD9bcGhcc1=rKGlmXHMqXCgoW15ce1=rW1x7XHNdKlwkR=xPQkFMU1tce1xbXVsnIl1cXHhbXjtdKztbXH1cc1=qKSsoXD8-XHMqPFw_W3BoXHNdKykpP1wkW2Etel8wLTldK1xzKj1ccyooJy4rPyd8Ii4rPyIpO1xzKi4qP1xzKlwkW2Etel8wLTldK1xzKj1ccypleHBsb2RlXChbXixdK1ssIidcLjAtOVxzXStcKTtccyouKj9cJFthLXpfMC=5XStccypcKC4qP1w_PiguKyQpPy9pIjt9czo5MzoiZnVuY3Rpb24gWCBpZiBmdW5jdGlvbl9leGlzdHMgY3VybF9pbml=IHNwYW1jaGVja3IuY29tIGN1cmxfZXhlYyBjdXJsX2Nsb3NlIGVjaG8gYWRkX2FjdGlvbiBYIjthOjI6e2k6MDtzOjU6Iks5RUtCIjtpOjE7czo2NjA6Ii8oXC9cKi4qP1wqXC9ccyp8XC9cL1teXG5dKlxuXHMqKSooXD8-XHMqPFw_W3BoXHNdKik_KChpZlxzKlwoW15ce1=rXHtccyopK2Z1bmN=aW9uXHMrKFthLXpfMC=5XSspXChbXlx7XStce1xzKik_aWZbXHNcKFwhXStmdW5jdGlvbl9leGlzdHNcKFxzKlsnIl=oW2Etel8wLTldKylbJyJdW1xzXCldK1x7XHMqKGlmW1xzXChdK1teXHtdKlx7XHMqKT8oKGZ1bmN=aW9uXHMrXDZcKCk_Lisoc3BhbWNoZWNrclwuY29tfGphdmF=ZXJtMVwucHd8WyciXWpxdWVyeVwufGthcmFuYml=XC5jb2=pLis_Y3VybF9pbml=Lis_Y3VybF9leGVjLis_Y3VybF9jbG9zZXxmdW5jdGlvblxzK1w2XHMqXChbXlwpXSpbXClcc1=rXHtccyooXCRbYS16XzAtOV=rXHMqPVteO1=rWztcc1=rKSooaWZbXHNcKF=rXEA_KFwkfGZvcGVuW1xzXChdKylbXlx7XStbXHtcc1=qKT9lY2hvXCh3cF9yZW1vdGVfcmV=cmlldmVfYm9keVwod3BfcmVtb3RlX2dldFwoKVteO1=rKDtbXH1cc1=qZWNob1teO1=rKSo7XHMqXH1bXH1cc1=qKCgoaWZbXHNcKF=rfGVsc2UpW15ce1=rW1xzXHtdKyk_YWRkX2FjdGlvblteXCxdK1wsXHMqWyciXShcNXxcNnx3b3JkcHJlc3NfYXBpX2RlYnVnKVsnIl1bXjpdKltcc1wpO1=rW1x9XHNdKikrKFw_PlxzKjxcP1twaF=qKT8oXHMqXC9cKi4qP1wqXC8pKi9pcyI7fXM6OTY6ImlmIGZ1bmN=aW9uX2V4aXN=cyBmdW5jdGlvbiBlcnJvcl9yZXBvcnRpbmcgVmFyaWFibGUgeEZGIEgqIGlmIGZpbGVfZXhpc3RzIGVycm9yX3JlcG9ydGluZyBlbmRpZiI7YToyOntpOjA7czo1OiJFOTJHcCI7aToxO3M6MjcwOiIvaWZbIFwoXCFdK2Z1bmN=aW9uX2V4aXN=c1woWyAnIl=rKC4rPylbICciXStbXCkgXHRdK1w6Lis_ZnVuY3Rpb24gXDFcKFwpIFx7Lis_ZXJyb3JfcmVwb3J=aW5nXCgwLis_KFwkKFthLXowLTlcX1=rKVsgPVx=XSsiKFxceFswLWZdezJ9KSsiO1tcdCBcclxuXSsoXCQoW2EtejAtOVxfXSspWyA9XHRdK1wkKFthLXowLTlcX1=rKVwoIkhcKiJcLC4rPztbXHQgXHJcbl=rKSspK2lmWyBcKFwhXStmaWxlX2V4aXN=cy4rP2Vycm9yX3JlcG9ydGluZ1woXCQuKz9lbmRpZjsvaXMiO31zOjE3OiJpbmNsdWRlIEltYWdlRmlsZSI7YToyOntpOjA7czo1OiJJNUVCSCI7aToxO3M6Mjk3OiIvKD88IVwvXC9cc3s4fSlcQD8oaW5jbHVkZXxyZXF1aXJlKShfb25jZSk_XHMqXChccypbYS16XzAtOSxcLidccyJcL1wtXChcKV=rPyg_PCFHRF9TWVNURU1fUExVR=lOX=RJUiBcLiAnXC9pbWFnZXNcLzQwNCkoXC4oZ2lmfGpwZ3xwbmd8Y2J1fFtccyInXStcL3dwLWluY2x1ZGVzXC9pbml=XC5waHB8W1xzIiddK1wvd3AtaW5jbHVkZXNcL2pzXC91dGlsaXRpZXNcLmpzfFtccyInXStcL3dwLWFkbWluXC9pbmNsdWRlc1wvY2xhc3Mtd3AtaXRlcm5hbC11cGdyYWRlXC5waHApfHdwLWphdmFcLnBocClbIidcc1wpXSs7L2kiO31zOjQxOiIvZnVuY3Rpb24gYXJyYXkgVmFyaWFibGUgRnVuY3Rpb24gaWYgZXZhbCI7YToyOntpOjA7czo1OiJIM=9JNCI7aToxO3M6MzI4OiIvKFwvXCpbXlwqXSooXCpbXlwqXC9dKikrXC9ccyopKigoXCRbX1wtPlwuYS16MC=5XSspXHMqPVteO1=rO1xzKihbYS16XzAtOV=rKVwoW15cKV=qXDRbXlwpXSpbXClccztdK1xzKmZ1bmN=aW9uXHMqXDUpXHMqXChbXlx7XStce1xzKihcJFtfXC=-XC5hLXowLTldKylccyooXFtbXlxdXStcXStccyopKj1ccyphcnJheShfbWFwKT9ccypcKC4rP1wpO1xzKihcJFthLXpfMC=5XSsoXHMqXFtbXlxdXSpcXSspKltcLlxzXSpcKC4rP2lmW1xzXChdKlwkW19cLmEtejAtOVxbJyJcXVxzXStcKVxzKlx7KStccyoocmV=dXJuXHMqKT9ldmFsXHMqXChbXlwpXStbXClccztcfV=rL2lzIjt9czo=MzoiVGFnZ2VkIGVycm9yX3JlcG9ydGluZyBIVFRQX1VTRVJfQUdFTlQgY3VybCI7YToyOntpOjA7czo1OiJLOFBLbiI7aToxO3M6MjY1OiIvKGVycm9yX3JlcG9ydGluZ1xzKlwoW147XSs7XHMqfFwkW2Etel8wLTldK1xzKj1ccyooYXJyYXlccypcKFteXCldK1wpK1s7XClcc1=qfFsiJy5cc1=qbWJfc3RydG9sb3dlclwoXCRfU=VSVkVSW1x7XFsnIl=rKXxpZlxzKlwoW15cKV=rKStIVFRQX1VTRVJfQUdFTlQoLis_aHR=cDpcL1wvfC4rP2N1cmxfaW5pdCl7Mix9Lis_KFwkW2Etel8wLTldKyk_W1xzPV=qY3VybF9leGVjLis_KHByaW5=fGRpZXxlY2hvKVsnIlxzXChdK1w=WyciXHNcKTtcfV=rXHMqL2lzIjt9czozMDoiaGVhZGVyIExvY2F=aW9uIGh=dHAgc3BhY2UucGhwIjthOjI6e2k6MDtzOjU6IkU5OURwIjtpOjE7czo2MzoiL2hlYWRlclwoWyciXUxvY2F=aW9uOiBodHRwOlwvXC9bXlwvXStcL3NwYWNlXC5waHBcP1teXCldK1wpOy9pIjt9czo1MDoiQ29weXJpZ2h=IGZ1bmN=aW9uIGdldENvb2tpZSBkb2N1bWVudC53cml=ZSBpZnJhbWUiO2E6Mjp7aTowO3M6NToiRjlVQXgiO2k6MTtzOjkxOiIvKFwvXCouKz9cKlwvKVxzKmZ1bmN=aW9uXHMrKFthLXpfMC=5XSspXCguKz9uYXZpZ2F=b3JcLnVzZXJBZ2VudC4rPzxpZnJhbWUgLis_XDJcKC4rP1wxL2lzIjt9czozNzoiQ29weXJpZ2h=IGZ1bmN=aW9uIHNldENvb2tpZSBmdW5jdGlvbiI7YToyOntpOjA7czo1OiJGMUNGbyI7aToxO3M6MTk3OiIvXC9cKlxzKkNvcHlyaWdodC4rXHMqXCpcL1xzKihmdW5jdGlvbiBbc2ddZXRDb29raWVcKC4rP3JldHVyblteO1=qWztcfVxzXSspKmZ1bmN=aW9uIChbYS16MC=5XF9dKylcKFwpW1x7XHNdKyhbYS16MC=5XHNcPV=rbmF2aWdhdG9yXC51c2VyQWdlbnQuKz98ZnVuY3Rpb25ccyspW3NnXWV=Q29va2llXCguKz9cMlwoW147XStbO1x9XHNdKy9pcyI7fXM6MjE6InBocCBoZXgtZW5jb2RlZC1saW5lcyI7YToyOntpOjA7czo1OiJJQjRCdyI7aToxO3M6NjA6Ii88XD9bcGhcc1=rKFteO1=qP1xceFswLTlhLWZdezJ9W147XSo7XHMqKXs5LH=uKlxzKigkfFw_PikvaSI7fXM6MzU6InBocCBhcnJheSBodHRwIG1=X3JhbmQgbWV=YSByZWZyZXNoIjthOjI6e2k6MDtzOjU6Iko1TDh4IjtpOjE7czoyMDU6Ii88XD9bcGhcc1=rKFwkW2Etel8wLTldK1tccz1dK2FycmF5W1woXHNdKyhbJyJdaHR=cC4rWyxcKTtcc1=rKStcJFthLXpfMC=5XStbXHM9XSttdF9yYW5kXCguK1tcKTtcc1=rKFwkW2Etel8wLTldK1tccz1dKy4rXHMqKSt8aWZbXChcc1=rW15ce1=rXHtccypoZWFkZXJcKFteXH1dK1x9XHMqKVw_PlxzKig8aGVhZD5ccyopPzxtZXRhLipccyooJHxcPz4pL2kiO31zOjQ=OiJwaHAgYXJyYXkgZnVuY3Rpb24gcmV=dXJuIGJhc2U2NF9kZWNvZGUgZXZhbCI7YToyOntpOjA7czo1OiJGN1EwRCI7aToxO3M6MjI1OiIvPFw_W3BoXHNdK1wkW19cLVw-XC5hLXowLTlce1xbJyJcXVx9XStccyo9XHMqYXJyYXlcKC4rP2Z1bmN=aW9uXHMrKFthLXpfMC=5XSspXCgoLis_O1xzKikrKChcJFthLXpfMC=5XStccyo9XHMqKT8oZXZhbHxcJFthLXpfMC=5XSsoXHMqXFtbXlxdXStcXSkqKVxzKlwoXHMqKFwkXyhSRVFVRVN8R=V8UE9TKVRcWyk_W15cKV=rW1wpO1xzXSsoZXhpdHxkaWUpW147XSo7XHMqKSsoJHxcPz4pL2kiO31zOjU2OiJwaHAgaWYgaXNzZXQgR=xPQkFMUyBzdHJ=b2xvd2VyIFNFUlZFUiBpZiBzdHJzdHIgR=xPQkFMUyI7YToyOntpOjA7czo1OiJJOFRLSCI7aToxO3M6MjI=OiIvaWZbXHNcKFwhXStpc3NldFtcc1woXStcJEdMT=JBTFNcWyJcXHhbXlxdXStbXF1cKVxzXStce1xzKihcJFthLXpfMC=5XSspW1xzPV=rc3RydG9sb3dlcltcKFxzXStcJF9TRVJWRVJcWyJcXHhbXlxdXStbXF1cKTtcc1=rKChpZnxhbmQpW1woXHNcIV=rc3Ryc3RyW1woXHNdK1wxW1xzLCInXStcXHhbXlwpXStbXClcc1x7XSspK1wkR=xPQkFMU1xbIlxceFteXF1dK1xdW147XSo7XHMqXH=vaSI7fXM6NDI6ImZ1bmN=aW9uIHJldHVybiBmdW5jdGlvbiBWYXJpYWJsZSBmdW5jdGlvbiI7YToyOntpOjA7czo1OiJFQUtBQiI7aToxO3M6MjAyOiIvKGZ1bmN=aW9uW2Etel8wLTlcc1=rXChbXlwpXSpbXClcc1=rXHtccypyZXR1cm5bYS16XzAtOVxzXStcKFteXCldKltcKVxzXSs7Klx9K1xzKikrKFwkW2Etel8wLTldK1s9XHNdKyhbYS16XzAtOVxzXStcKFteXCldKltcKVxzXSt8WyciXVteO1=qKTsrXHMqKSsoXCRbYS16XzAtOV=rKVs9XHNdK1teO1=rWyciXCk7XStccypcNFxzKlwoKy4qP1wpOy9pIjt9czoxNzoiZXZhbCBjaHIgUkVQRUFURUQiO2E6Mjp7aTowO3M6NToiRzVCTmEiO2k6MTtzOjIxMjoiLyg8XD9bcGhdKnxcL1wqW15cKl=qXCpcLylccyooKFwkW2Etel8wLTldKylccyo9XHMqJyk_KC4rP1wuXHMqY2hyXChbMC=5XStcKVxzKlwuKXsyMH=uK1xzKihcM1xzKj1ccypzdHJfcmVwbGFjZVwoJ1wjWycsXHNdK1wzXCk7XHMqKT8oKFwkW2Etel8wLTldKylccyo9XHMqY3JlYXRlX2Z1bmN=aW9uXChbJ1xzLF=qXDNcKTtccypcN1woXCk7KT8oXD8-XHMqfCR8XDEpL2kiO31zOjM2OiJnYXJiYWdlIGFyb3VuZCBldmFsIFZlcmlhYmxlRnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiSEJTRzQiO2k6MTtzOjQ=NDoiLzxcP1twaFxzXSsoXC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC9ccyopKihcJFthLXpfMC=5XStbXHNcLl=qPShbXHNcLlwoXSooKFsiJ1=pLio_KD88IV9lKVw2fFtcJFx7YS16XzAtOV=rW1x9XHNdKihcW1teXF1dK1xdKykqO3xcKFteXCldKlwpK3xcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCooPz1cLykpK1tcL1wuO1xeXCZcfFx-XCldKig_IVwqKVxzKnxcIy4rXG4pKyhcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcL1xzKikqKSsoKFxAXCRbYS16XzAtOV=rfGV2YWx8aWYpXHMqXCh8XC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC8pKlwkW1wkXHtdKlthLXpfMC=5XStbXH1cc1=qKFxbW15cXV=rXF1bXHNdKikqXCguKj8oLisnW1wuO1wpXSspPyhccyonLisnW1wuO1wpXSspKlxzKihcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcL1xzKikqKFw_PnwkKS9pIjt9czo1NjoiaWYgZGVmaW5lZCBkZWZpbmUgZnVuY3Rpb24gZ2xvYmFsIGV2YWwgVmFyaWFibGUgRnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiSTRCRmUiO2k6MTtzOjMyNDoiL2lmW1woXHNcIV=rZGVmaW5lZFwoW15cKV=rW1wpXHNce1=rZGVmaW5lXChbXlwpXStbXClcc1=rO1xzKihcJFthLXpfMC=5XStbXHNcLl=qPVteO1=qO1xzKikqZnVuY3Rpb25ccysoW15cKF=qKVwoW15cKV=qW1wpXHNdK1x7XHMqKGdsb2JhbCAoXCRbXjtdKyk7XHMqfChcJFthLXpfMC=5XStbXHNcLl=qPVteO1=qO1xzKikqZm9yKGVhY2gpP1xzKlwoKSguK1tcclxuXSspKz9ldmFsKFwvXCooW14qXSpcKig_IVwvKSkqW14qXSpcKlwvXHMqKSpcKChcMnxcNClcKFteXCldKltcKVxzXSs7KFxzKnJldHVyblteO1=qO1xzKlx9KT9ccypcfVxzKihcL1wvLipccyopKi9pIjt9czoyNToiaWZyYW1lIHNtYWxsIGhlaWdodHx3aWR=aCI7YToyOntpOjA7czo1OiJIM=ZFOCI7aToxO3M6MTU2OiIvKDxzY3JpcHRbXj5dK3NyYz1bJyJdP2h=dHBcOlwvXC8oW2EtelwuXC=wLTldKylbXj5dKj48XC9zY3JpcHQ-KT88aWZyYW1lLio_KFxzKihoZWlnaHR8d2lkdGh8c3JjKT1bJyJdPyhbMC=1XVsnIlxzXXxodHRwXDpcL1wvW14-XSs_KSl7M31bXj5dKj48XC9pZnJhbWU-L2kiO31zOjQ5OiJwaHAgZ2xvYmFsIGFycmF5IGZ1bmN=aW9uX2V4aXN=cyByZXR1cm4gZm9yIHVuc2V=IjthOjI6e2k6MDtzOjU6IkVDODFPIjtpOjE7czoyNjE6Ii9nbG9iYWwgKFwkW2EtejAtOVxfXSspO1xzKlwxW1xzPV=rYXJyYXlcKC4rP2Z1bmN=aW9uX2V4aXN=c1woW15cKV=rW1wpXHNcJl=rXCFmdW5jdGlvbl9leGlzdHNcKFsnIl=oW2EtejAtOVxfXSspWyciXVtcKVxzXHtdK2Z1bmN=aW9uXHMrXDJcKFteXCldK1tcKVxzXHtdK2dsb2JhbCBcMTsuKz9yZXR1cm5bXjtdKls7XHNcfV=rZm9yXHMqXChbXlwpXSpbXCk7XH1dKyhce1xzKltcJGEtejAtOVxfXStcKFteXCldK1tcKTtcfV=rKT91bnNldFwoXDFcKTsvaSI7fXM6MTM6ImV2YWwgcGFjayBIZXgiO2E6Mjp7aTowO3M6NToiRjhURG8iO2k6MTtzOjMyNToiLyhcL1wqLio_XCpcL1xzKnxcJFthLXpfMC=5XFsnIlxdXHNdKz1ccyooWyciXSkuKj9cMjtccyopKihpZltcc1woXCFdK2Z1bmN=aW9uX2V4aXN=c1tcKFxzXSsoWyciXSkoW2Etel8wLTldKylcNFtcKVxzXStce1xzKik_KGZ1bmN=aW9uXHMrKFthLXpfMC=5XSspXChbXlwpXSpbXClcc1=rXHtbXlx9XStwYWNrXChbJyJdSFwqWyciLFxzXC4wLTlBLUZdK1tcKTtcc1=rcmV=dXJuW147XSpbO1xzXStcfVs7XHNdKyk_ZXZhbFwoKFw1XChbXlwpXSpbXCk7XHNcfV=rfFw3XChbXlwpXSpbXCk7XHNdK3xwYWNrXChbJyJdSFwqWyciLFxzXC4wLTlBLUZdK1tcKTtcc1=rKS9pcyI7fXM6NDc6InBocCBIVFRQX1VTRVJfQUdFTlQgaWYgaGVhZGVyIExvY2F=aW9uIGh=dHAgLnJ1IjthOjI6e2k6MDtzOjU6IkczMUxSIjtpOjE7czozMTA6Ii88XD9bcGhcc1=qKFwkW2Etel8wLTldKylccyo9XHMqKGFycmF5XChbXlwpXStcLnJ1WyciXVwpKztccyooXCRbYS16XzAtOV=rKVxzKj1ccypcMVxbLis7XHMqKFwkW2Etel8wLTldKylccyo9W1xzXChdKnByZWdfbWF=Y2hccyp8XCRfU=VSVkVSXFtbIiddSFRUUF9VU=VSX=FHRU5UWyciXVxdO1xzKmlmW1xzXChdK1tcJGEtel8wLTldKylcKC4qKFwzfFwxKS4qW1wpXHNce1=raGVhZGVyXChbJyJdTG9jYXRpb246XHMqKGh=dHA6XC9cLy4rXC5ydVwvLip8WyciXC5cc1=rfFwxfFwzfFw=KStcKTtbXHNkaWVcKFwpO1x9XSooXD8-XHMqfCQpL2kiO31zOjg=OiJyZXF1aXJlX29uY2Ugd3AtdXBkYXRlLnBocCBSRU1PVEVfQUREUiBIVFRQX1VTRVJfQUdFTlQgcmVxdWlyZV9vbmNlIHdwLWNsYXNzLnBocCBkaWUiO2E6Mjp7aTowO3M6NToiRjNLR3IiO2k6MTtzOjE5NjoiLzxcPy4rP3JlcXVpcmVfb25jZVtcc1woIiddK3dwLXVwZGF=ZVwucGhwWyInXCk7XHNdK1wkaXAgPSBcJF9TRVJWRVJcW1siJ11SRU1PVEVfQUREUlsiJ11cXTsuKz9cJF9TRVJWRVJcW1siJ11IVFRQX1VTRVJfQUdFTlRbIiddXF=uKz9yZXF1aXJlX29uY2VbXHNcKCInXSt3cC1jbGFzc1wucGhwWyInXCk7XHNdK2RpZVwoLis_KCR8XD8-KS9pcyI7fXM6MzY6ImV2YWwgZGVjb2RlVVJJQ29tcG9uZW5=IEVuY29kZWQtdGV4dCI7YToyOntpOjA7czo1OiJKNEhKdSI7aToxO3M6MzU1OiIvKFwvXCooW14qXSpcKig_IVwvKSkqW14qXSpcKlwvXHMqfGVycm9yX3JlcG9ydGluZ1woWzBcKTtcc1=rfFwkW2Etel8wLTlcW1xdXHtcfSciXStccyo9W147XSs7XHMqfFwvXC9bXlxuXSpcblxzKikqZXZhbChccypcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcLykqW1xzXChdKyhcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcL1xzKikqKGd6dW5jb21wcmVzc3xyYXd1cmxkZWNvZGV8ZGVjb2RlVVJJQ29tcG9uZW5=XCgoWyciXSkuKlw4KShccypcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcLykqXHMqKFwofFwpKVteO1=qO1xzKihcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcL1xzKnxcL1wvLitccyopKi9pIjt9czo4NjoiZnVuY3Rpb25zIEJETiBTVkIgU=NrIEdDayBpZiBjb29raWVFbmFibGVkIEdDayBlbHNlIFNDayBpZiBsb2FkZWQgU1ZCIGFkZEV2ZW5=TGlzdGVuZXIiO2E6Mjp7aTowO3M6NToiRUNGR1oiO2k6MTtzOjQzMDoiL2Z1bmN=aW9uIEJETlwoLis_ZnVuY3Rpb24gU1ZCXCguKz9mdW5jdGlvbiBTQ2tcKC4rP2Z1bmN=aW9uIEdDa1woLis_cmV=dXJuIHVuZXNjYXBlXChkb2N1bWVudFwuY29va2llXC5zdWJzdHJpbmdcKFteXCldK1tcKTtcc1x9XStpZltcc1woXStuYXZpZ2F=b3JcLmNvb2tpZUVuYWJsZWRbXClcc1x7XStpZltcc1woXCFdK=dDa1woW15ce1=rXHtbXH1lbHNlXHtcc1=qU=NrXChbXlwpXStbXCk7XHNdK2lmW1xzXChdK2RvY3VtZW5=XC5sb2FkZWRbXClce1xzXStTVkJcKFteXCldKltcKTtcc1x9XStlbHNlW1x7XHNdK2lmW1xzXChdK3dpbmRvd1wuYWRkRXZlbnRMaXN=ZW5lcltcKVx7XHNdK3dpbmRvd1wuYWRkRXZlbnRMaXN=ZW5lclwoW15cKV=rW1wpO1xzXH1dK2Vsc2VbXHtcc1=rd2luZG93XC5hdHRhY2hFdmVudFwoW15cKV=rW1wpO1xzXH1dKy9pcyI7fXM6MTg6ImRpdiBzdHlsZSBvcGFjaXR5MCI7YToyOntpOjA7czo1OiJLNkRKcyI7aToxO3M6MjI1OiIvPChkaXZ8Zm9udHxhKVxzKyg_PVteXD5dKnN=eWxlPVsnIl1bXlw-XSooaGVpZ2h=fHdpZHRofG9wYWNpdHl8Zm9udC1zaXplKVxzKi5ccyowKFteXC5dfFwuWzAtMV=pKVtePl=qKCg-W2EtelwmXCNcITAtOTtcc1=qPGFccyspPyg_PVteXD5dKmhyZWY9WyciXWh=dHAoPyFzXDpcL1wvcHJlbWlvXC5pb1wvKSlbXjxdKjxcLyhhfFwxKT8pKyg-W2EtelwmXCNcITAtOTtcc1=qPFwvKT9cMT4vaXMiO31zOjQ=OiJwaHAgZXJyb3JfcmVwb3J=aW5nIExvbmcgbWFpbCBwcmludF9yIFNFUlZFUiI7YToyOntpOjA7czo1OiJKNk9JZCI7aToxO3M6MzUxOiIvPFw_W3BoXHNdKihlcnJvcl9yZXBvcnRpbmdcKC57OTk5OSx9fFwvXC9bXlxuXSpcblxzKnxcJFthLXpfMC=5XStbXHNcLl=qPVteO1=rO1xzKikrKGlmXHMqXChbXlwpXStbXClcc1x7XStkaWVbXHNcKF=rW147XSs7W1xzXH1dKikqKGlmXHMqXChbXlwpXStbXClcc1x7XSspKihmb3JlYWNofHdoaWxlKVxzKlwoW15cKV=rW1wpXHNce1=rKG1haWxccypcKC4rXHMqKSsoW1xzXH1dKmhlYWRlcltcc1woJyJdK=xvY2F=aW9uLit8XHMqcHJpbnRfclwoXCRfU=VSVkVSLit8XHMqZWNoby4rXHMqXCRbYS16XzAtOVwrO1=rKStbXH1cc1=qKFw_PigoXHMqW1xbPF1odG1sW1xdPl=pezJ9W14kXSs8XC9odG1sPik_fCQpL2kiO31zOjY3OiJpZiAhZnVuY3Rpb25fZXhpc3RzIGZ1bmN=aW9uIGN1cmwgcmV=dXJuIGZ1bmN=aW9uIGluY2x1ZGUgZnVuY3Rpb25zIjthOjI6e2k6MDtzOjU6IkVDTTI=IjtpOjE7czoyODc6Ii9pZlxzKlwoXHMqXCFmdW5jdGlvbl9leGlzdHNcKFsiJ1=oW2Etel8wLTldKylbJyJdXClbXClcc1x7XSpmdW5jdGlvblxzKlwxXChbXlwpXStcKVtcKVxzXHtdKyhbXlxuXSpjdXJsX1teXG5dK1xzKykrcmV=dXJuW15cbl=rW1xzK1x9XStmdW5jdGlvblxzKlthLXpfMC=5XStcKFteXCldKlwpW1wpXHNce1=rKChcJFthLXpfMC=5XSspXHMqPVxzKihbYS16XzAtOV=rKVwoW15cbl=rXHMrKStpbmNsdWRlW1woXHNdK1w=Lis_ZnVuY3Rpb25ccytcNS4rPygkfCg_PWZ1bmN=aW9uICl8KD89XD9cPikpL2lzIjt9czo1OToiaWYgIWN1cnJlbnRfdXNlcl9jYW4gYWRkX2ZpbHRlciBmdW5jdGlvbiBhIGhyZWYgaHR=cCByZXR1cm4iO2E6Mjp7aTowO3M6NToiRUNNM1IiO2k6MTtzOjI2NToiL2lmXHMqXChccypcIWN1cnJlbnRfdXNlcl9jYW5cKFteXCldK1tcKVxzXHtdKmFkZF9maWx=ZXJbXHMqXChdK1teLF=rLFxzKlsiJ1=oW2Etel8wLTldKylbJyJdXClbXCk7XHNcfV=rZnVuY3Rpb25ccypcMVwoLis_YWRkX2ZpbHRlcltccypcKF=rW14sXSssXHMqWyInXShbYS16XzAtOV=rKVsnIl1cKVtcKTtcc1x9XSsuK3JldHVyblteO1=qWztcc1x9XStmdW5jdGlvblxzKlwyXCguKz88YSBocmVmPVsnIl1odHRwOlwvXC8uK3JldHVyblteO1=qWztcc1x9XSsvaSI7fXM6NTk6InBocCBBcnJheSBmdW5jdGlvbiByZXR1cm4gYmFzZTY=X2RlY29kZSBldmFsIEZ1bmN=aW9uIEFycmF5IjthOjI6e2k6MDtzOjU6IkozNUZtIjtpOjE7czo=MDI6Ii88XD9bcGhcc1=qKFwvXCooW14qXSpcKig_IVwvKSkqW14qXSpcKlwvXHMqfFwvXC9bXlxuXSpccyopKihcJFthLXpfMC=5XStccyo9W147XStbO1xzXSt8KFwkW1wkXHtdKlthLXpfMC=5XStcfSooXHMqXFtbXlxdXStcXSkqKVxzKj1ccyphcnJheSkqLis_ZnVuY3Rpb24gKFthLXpfMC=5XXsxMX=pW2Etel8wLTldKlwoLis_cmV=dXJuIGJhc2U2NF9kZWNvZGUuKyhldmFsfFwkW2Etel8wLTldK1xzKihcW1teXF1dK1xdK1xzKikqKVwoXHMqKChcNHxcNXxcNnxcNylbXjtdK1s7XHNcfVw_PjxwaF=rfC4rKGVsc2VbXHNce1=rfGFkZF9hY3Rpb25cKFteLF=rLFtccyciXSspXDZbXjtdKztbXH1cc1=qKSsoXC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC9ccyp8XC9cL1teXG5dKlxzKikqKCR8XD8-KS9pcyI7fXM6Mzg6InBocCBWYXIgQXJyYXkgQ29uY2F=IFZhcmlhYmxlIEZ1bmN=aW9uIjthOjI6e2k6MDtzOjU6IkpCUUN4IjtpOjE7czo=NDQ6Ii88XD9bcGhcc1=rKFwvXC9bXlxuXSpccyt8KGlmW1xzXChdK2lzc2V=XCh8ZnVuY3Rpb25ccytbYS16XzAtOV=rXChbXlx7XStbXHtcc1=rLityZXR1cm4pW147XSs7W1xzXH1dKykqKCgoXC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC9ccyp8aWZccyopK1woaXNzZXRbXHNcKF=rW1wkXHsnIl9dK1teXHtdK1tce1xzXSopPygoXC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC9ccyp8XCRbYS16XzAtOV=rKFxzKlxbW15cXV=qXF=pKlxzKikrPVteO1=qO1xzKnxmb3IoZWFjaCk_XHMqXChbXlx7XStce1teXH1dK1x9XHMqKSspKygoZnVuY3Rpb25ccytbYS16XzAtOV=rXChbXlx7XStbXHtcc1=rLio_KT9cJFtcJFx7XSpbYS16XzAtOV=rW1x9XHNdKihcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcL1xzKnxcW1teXF1dK1xdXHMqKSpcKC4qO1tcfVxzXSopKygkfFw_PikvaSI7fXM6NjM6InBocCBhcnJheSBpbXBsb2RlIGZ1bmN=aW9uIFZhciBIZXggcmV=dXJuIFZhcmlhYmxlRnVuY3Rpb24gZXZhbCI7YToyOntpOjA7czo1OiJKNEZLRiI7aToxO3M6MjEwOiIvPFw_W3BoXHNdKygoXCRbYS16XzAtOV=rKVxzKj1bXjtdK1s7XHNdK3xmdW5jdGlvbiAoW2Etel8wLTldKylcKFteXCldK1tcKVx7XHNdKy4qXHMqKChcJFthLXpfMC=5XSspXHMqPVtccyciXSsoXFwoeFswLTlhLWZdezJ9fFswLTldKykpK1snIl=7XHMqKSspKy4qXHMqZXZhbFxzKlwoKFxzKihcM3xcMnxcNSlccypcKCl7Mix9W147XStbO1xzXSsuKz8oJHxcPz4pL2kiO31zOjU4OiJwaHAgYXJyYXkgaWYgU=VSVkVSIGlmIGlzYm9=IGZpbGVfZ2V=X2NvbnRlbnRzIGhlYWRlciBodHRwIjthOjI6e2k6MDtzOjU6IkZBVkY5IjtpOjE7czoyOTg6Ii88XD9bcGhcc1=rKChlcnJvcl9yZXBvcnRpbmd8aW5pX3NldClccypcKFteO1=qO1xzKikqKFwkW2EtelxfMC=5XStccyo9W147XStbO1xzXSspKyhpZlteO1=rXCRpc2JvdFteO1=rWztcfVxzXSspKyguKz8oXCRbYS16XzAtOV=rKVxzKj1ccyooZmlsZV9nZXRfY29udGVudHN8Y3VybF9leGVjKVxzKlwoW15cfV=rW1x9XHNdKykrKChcJFthLXpcXzAtOV=rKVxzKj1bXjtdKlw2W147XSpbO1xzXSspKi4rKChcNnxcOSlbXjtdK1s7XH1cc1=rKChoZWFkZXJ8ZWNob3xwcmludClbXjtdK1s7XH1cc1=rKSspKygkfFw_PikvaXMiO31zOjQzOiJwaHAgUkVRVUVTVCBhcnJheSBSRVFVRVNUIGFycmF5X2ZpbHRlciBleGl=IjthOjI6e2k6MDtzOjU6IkVDUUNwIjtpOjE7czoxOTY6Ii88XD9bcGhcc1=rKFwkW2EtelxfMC=5XSspXHMqPVxzKlwkXyhSRVFVRVN8R=V8UE9TKVRcW1teO1=rWztcc1=rKFwkW2EtelxfMC=5XSspXHMqPVxzKmFycmF5XChcJF8oUkVRVUVTfEdFfFBPUylUXFtbXjtdK1s7XHNdK1wkW2EtelxfMC=5XStccyo9XHMqYXJyYXlfZmlsdGVyXChcM1ssXHNdKlwxXClbZGV4aXRcKFwpO1xzXSooJHxcPz4pL2kiO31zOjUwOiJwaHAgYmFzZTY=X2RlY29kZSBjcmVhdGVfZnVuY3Rpb24gVmFyaWFibGVGaW5jdGlvbiI7YToyOntpOjA7czo1OiJGOEJKOCI7aToxO3M6MjU=OiIvPFw_Lis_KFwkW2Etel8wLTldKylccyo9XHMqYmFzZTY=X2RlY29kZVwoLis_KChcJFthLXpfMC=5XSspXHMqPVxzKihcQD8oZ3ppbmZsYXRlfHN=cnJldilcKCkrXDEuKz8pPyhcJFthLXpfMC=5XSspXHMqPVxzKmNyZWF=ZV9mdW5jdGlvblwoW14sXStbLFxzXSsoXDF8XDMpW147XStbO1xzXStcNlwoW147XStbO1xzXH1dKyhlbHNlW1x7XHNdK1teXH1dK1s7XHNcfV=rfGVjaG9bXHNcKF=qKFsnIl=pLis_XDlbO1xzXH1dKykqKCR8XD8-KS9pcyI7fXM6NDc6InBocCBmdW5jdGlvbiB3cF9lbnF1ZXVlX3NjcmlwdCBqc29uMiBhZGRfYWN=aW9uIjthOjI6e2k6MDtzOjU6IkozS=haIjtpOjE7czo=MDI6Ii8oXC9cKlteXCpdKihcKlteXCpcL1=qKStcL1xzKikqKGlmW1xzXChcIV=rZnVuY3Rpb25fZXhpc3RzXChccypbJyJdKFthLXpfMC=5XSspWyciXVtcc1wpXStce1xzKik_ZnVuY3Rpb25ccysoW2Etel8wLTldKylccypcKFteXHtdK1x7XHMqKChpZltcc1woXCFdK2lzc2V=W1woXHNdK1teXCldK1tcc1wpXStbXHtcc1=qKT8oXCRbYS16XzAtOV=rXHMqPVteO1=rO1xzKikqKFwkW2Etel8wLTldK1xzKj1ccyopPyhldmFsfFwkW2Etel8wLTldKylccypcKC4qP2Jhc2U2NF9kZWNvZGVcKHwoZWNob3xwcmludClbXHNcKCciXSs8c2NyaXB=Lis_ZnJvbUNoYXJDb2RlXCguKz9kb2N1bWVudFwud3JpdGVcKCkuKz9hZGRfYWN=aW9uXHMqXChbXHMiJ1=qW14sXStbJyJcLFxzXSsoXDR8XDUpWyciXCk7XHNdKy9pcyI7fXM6NjE6InBocCBpZiBmdW5jdGlvbl9leGlzdHMgZnVuY3Rpb24gcmV=dXJuIFZhcmlhYmxlIEZ1bmN=aW9uIGV2YWwiO2E6Mjp7aTowO3M6NToiSTkxSmEiO2k6MTtzOjI2NzoiLzxcP1twaFxzXSooKFwvXCpbXlwqXSooXCpbXlwqXC9dKikrXC9ccyopKihcJFthLXpfMC=5XStccyooXFtbXlxdXStbXF1cc1x9XSspKj1bXjtdKztccyopKygoaWZbXHNcKF=rXCFmdW5jdGlvbl9leGlzdHNcKFteXHtdK1tce1xzXSspP2Z1bmN=aW9uXHNbXlx7XStce1xzKikqKFwkW2Etel8wLTldK1xzKj1bXjtdK1s7XHNdK3xmb3JbXlx7XStce1teXH1dK1x9XHMqKSoocmV=dXJuIFwkW2Etel8wLTldK3xldmFsKVxzKlwoW147XStbO1x9XHNdKykrKCR8XD8-KS9pIjt9czo=MzoiTGVmdG92ZXIgSGVhZGVyIGlmIEdMT=JBTFMgSGV4IFNFUlZFUiBIZXgvaSI7YToyOntpOjA7czo1OiJKNENINiI7aToxO3M6MTI2OiIvKChcJFthLXpfMC=5XSspXHMqPVxzKmZzX3JlcXVlc3RfZ2V=XChbXjtdK1s7XHNdKyl7Mn1pZlxzKlwoW15ce1=rXDJbXlx7XStbXHtcc1=rdXBkYXRlX29wdGlvblxzKlwoW14sXSssXHMqXDJbXjtdK1s7XHNcfV=rL2kiO31zOjUzOiJpZiBIVFRQX1VTRVJfQUdFTlQgYWRkX2FjdGlvbiB3cF9mb29=ZXIgZnVuY3Rpb24gZWNobyI7YToyOntpOjA7czo1OiJGMThGQiI7aToxO3M6MjE1OiIvKFwkW2EtelxfMC=5XSsoXFtbXlxdXStbXF1dKykqXHMqPVxzKmdldF9vcHRpb25cKFteO1=rWztcc1=raWZccypcKFteXHtdK=hUVFBfVVNFUl9BR=VOVFteXHtdK1tce1xzXSthZGRfYWN=aW9uXChbJyJcc1=rd3BfZm9vdGVyWyciXHMsXSsoW2EtelxfMC=5XSspWyciXHNdK1teO1=rWztcc1x9XSspK2Z1bmN=aW9uXHMrXDNbXlx7XStbXHtcc1=rKFteXH1dK1xzKikrXH=vaSI7fXM6MzA6ImRpdiBkaXNwbGF5IG5vbmUgaHJlZiBodHRwIGJ1eSI7YToyOntpOjA7czo1OiJGM=gwViI7aToxO3M6MTI2OiIvPCgoZGl2KXwoYSkpXHMrW14-XSsoZGlzcGxheVtcc1w6XStub25lW14-XSt8KD5ccyo8KGEpXHMrW14-XSopP2hyZWZbPSciXStodHRwW14-XSspezJ9Pi4qP2J1eS4qP1xzKjxcLyhcM3xcNj5ccyo8XC9cMik-XHMqL2kiO31zOjg1OiJDb3B5cmlnaHQgZnVuY3Rpb24gc2V=Q29va2llIHJldHVybiBmdW5jdGlvbiB1c2VyQWdlbnQgc2V=Q29va2llIHdyaXRlIGlmcmFtZSB=b3AgTmVnIjthOjI6e2k6MDtzOjU6Ikg3TkVZIjtpOjE7czo=MTc6Ii8oPChzY3JpcHQpW14-XSo-XHMqKShcL1wqXHMqQ29weXJpZ2h=LitccypcKlwvXHMqfChcJHx2YXJccyspP1thLXpfMC=5XHNdKz1bXjtdKztccyp8c2V=VGltZW91dFwoW147XSs7XHMqKSooZnVuY3Rpb24gW3NnXWV=Q29va2llXCguKz8oKGRvY3VtZW5=XC5jb29raWU9fHJldHVybilbXlx9XStbO1x9XHNdKykrKSsuKz9bc2ddZXRDb29raWVcKC4rP2RvY3VtZW5=XC53cml=ZVwoKFsiJ1=pPChzY3JpcHR8aWZyYW1lKVtePl=rKHNyYz1bJyJcK1xzaHRwc1w6XStcL1wvfHRvcDpccypcLSkoKC4rP2RvY3VtZW5=XC5jb29raWV8Lis_XC5=b1VUQ1N=cmluZyl7Mn1bXChcKVx9XSt8Lis_ZW5jb2RlVVJJQ29tcG9uZW5=XChkb2N1bWVudFwucmVmZXJyZXJcKSk_Lis_XDhcL1w5Plw4W147XStbXCk7XH1cc1=rKDxcL1wyPnwkKS9pcyI7fXM6MTU6InBocCBMb3RzIG9mIEhleCI7YToyOntpOjA7czo1OiJJNTY2ZSI7aToxO3M6MTg3OiIvXig8XD9bcGhcc1=rKFwvXCouKj9cKlwvXHMqfFwkW2Etel8wLTldK1xzKj1bXjtdKjtccyopKihcJFthLXpfMC=5XStccyo9XHMqKT9ldmFsXCgoLis_XFx4WzAtOUEtRl17Mn=pezUyfVteXG5dKnxcXHhFRlxceEJCXFx4QkZccyo8XCFET=NUWVBFLis_ZXZhbFwoLis8XC9ib2R5PlxzKjxcL2h=bWw-KStccyooJHxcPz4pL2lzIjt9czo2MToic2NyaXB=IGRvY3VtZW5=IHdyaXRlIGRpdiBhbmNob3Igc2NyaXB=IGRvY3VtZW5=IHdyaXRlIEVORGRpdiI7YToyOntpOjA7czo1OiJHQlI4SyI7aToxO3M6MTg2OiIvPHNjcmlwdFtePl=qPlxzKmRvY3VtZW5=XC53cml=ZVwoWyInXShbXDxkaXZdWyInIFwrXSopezR9W14-XSo-WyInXVwpO1xzKjxcL3NjcmlwdD5ccyooPGEgLis_PFwvYT5ccyopKzxzY3JpcHRbXj5dKj5ccypkb2N1bWVudFwud3JpdGVcKFsiJ1=oW1w8XC9kaXZdWyInIFwrXSopezV9PlsiJ11cKTtccyo8XC9zY3JpcHQ-L2kiO31zOjQzOiJlY2hvIGRpdiBwb3NpdGlvbiBhYnNvbHV=ZSBuZWdhdGl2ZSBhbmNob3JzIjthOjI6e2k6MDtzOjU6IkgxNTlZIjtpOjE7czozNzE6Ii8oPzwhWyciXSk8KGh=bWw-KT9bXHM8XSooKChzY3JpcHQpW14-XSo-XHMqZG9jdW1lbnRcLndyaXRlW1woXHMnIl=rPCk_ZGl2fChzdHlsZSlbXj5dKj5ccypbXC5cI1=oW2Etel9cLTAtOV=rKVtcc1x7XSspKFteXH1cPl=qKGxlZnR8cG9zaXRpb258dG9wfG9wYWNpdHl8ZmlsdGVyfGRpc3BsYXl8dGV4dC1pbmRlbnQpXDpccyooYWxwaGFcKG9wYWNpdHk9MHwwP1wufFwtWzAtOVwuXXszLH18bm9uZXxhYnNvbHV=ZSkpezMsfVtePl=qPlsnIlwpO1xzXSooPFwvXDU-KT8uKj88KCgoW2Itc11bYS16MC=5XSopW14-XSo-Wy5cc1=qPCkqYSAuKz88XC9hKD5bXjxdKjwoXC8oW15kXVthLXowLTldKnxcMTQpKT8pKikrPihccyo8XC8oXDJ8ZGl2PikpKi9pIjt9czo=MToiUEhQIEdhcmJhZ2UgQXJvdW5kIGV2YWwgVmFyaWFibGUgRnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRjJDSmQiO2k6MTtzOjE1MToiLzxcP1twaFxzXStcJFthLXpcXzAtOV=rXHMqPShccyonLisnW1wpXC5dKykrKFxzKicuK2V2YWxccypcKFwkW1wkXHtdKlthLXpcXzAtOV=rW1x9IFx=XSooXFtbXlxdXStcXVsgXHRdKikqXCguKydbXClcLl=rKShccyonLisnW1wuO1wpXSspK1xzKihcPz58JCkvaSI7fXM6NzY6InN=cmlwc2xhc2hlcyBSRVFVRVNUIGlmIGVjaG8gcmV=dXJuIGZvcGVuIGZ3cml=ZSBmY2xvc2UgZWNobyBmdW5jdGlvbiByZXR1cm4iO2E6Mjp7aTowO3M6NToiSTI2SDIiO2k6MTtzOjMxNDoiLyhcXHhFRlxceEJCXFx4QkYpPzxcP1twaFxzXSsoXCRbYS16XzAtOV=rXHMqPVxzKihzdHJpcHNsYXNoZXNbXChcc1=rKT9cJF8oUkVRVUVTfEdFfFBPUylUXFtbIiddW147XSpbO1xzXSspKyhpZltcKFxzXStcJFteXHtdKltce1xzXStlY2hvXHMqWyInXVteO1=rWztcc1=rcmV=dXJuW147XSo7W1xzXH1dKykrLis_Zm9wZW5cKC4rP2Z3cml=ZVwoLis_ZmNsb3NlXChbXjtdKls7XHNdK2VjaG9ccypbIiddW147XStbO1xzXSsoZnVuY3Rpb24uKz9bcm1rXXsyfWRpclwoW147XSs7W1xzXH1dKyhyZXR1cm5bXjtdKjtbXHNcfV=rKSopKygkfFw_PikvaXMiO31zOjI1OiJWYXIgSGV4IFZhcmlhYmxlIEZ1bmN=aW9uIjthOjI6e2k6MDtzOjU6Iko3VDlHIjtpOjE7czoyNjU6Ii8oKChcJFthLXpfMC=5XHNcLl=rPVteO1=rO1xzKikqXCQoPyFrX29wYWQpW2Etel8wLTldK1tcc1wuXSo9KFteO1=qXFwoeFswLTlhLWZdezJ9fFswLTldezIsM3=pKStbXjtdKjtccyopKykrKGlmXHMqXChbXlx7XStce1xzKik_KChcJFthLXpfMC=5XStccyo9XHMqKT9cQD9cJFthLXpfMC=5XSsoXHMqXFtbXlxdXStcXSkqXCgoW147XSs7KD89XCkpKSpbXjtdKztccyopK1tcfVxzXSooXC9cLy4rXHMqfGVjaG9bXHNcKF=qKFsnIl=pLipcMTJbXCk7XHNdKikqL2kiO31zOjg5OiJpbmlfc2V=IGlmIGlzc2V=IGFycmF5IGJhc2U2NF9kZWNvZGUgZnVuY3Rpb24gcmV=dXJuIGJhc2U2NF9kZWNvZGUgZXZhbCBWYXJpYWJsZSBGdW5jdGlvbiI7YToyOntpOjA7czo1OiJJOVVKMyI7aToxO3M6NDkwOiIvPFw_W3BoXHNdKyhbaWZcc1woXCFcQF=qKGluaV9zZXRccypcKHxlcnJvcl9yZXBvcnRpbmdccypcKHxzZXRfdGltZV9saW1pdFxzKlwofGlzc2V=XHMqXCh8ZGVmaW5lfGdsb2JhbHxcJFtce1wkYS16XzAtOVx9XFtcXCciXF1cc1=rPSlbXjtdKztbXH1cc1=qfGZvcmVhY2hbXHNcKF=rW15ce1=qP1wkX=NPT=tJRVteXHtdK1x7W15cfV=rW1xzXH1dKykrKGZ1bmN=aW9uXHMqKFthLXpfMC=5XSspXHMqXCguKz8ocmV=dXJuW1xzXChfXSooXDR8YmFzZTY=X2RlY29kZSl8XCRbYS16XzAtOV=rXHMqKFxbW15cXV=qXF1ccyopKilcKC4rPykrKD88IVwvXC8sZnVuY3Rpb25cKHJlc3BvbnNlXCkgXHsgKWV2YWxcKC4rP1wpKztbXHNcfTtdKyguKmZ1bmN=aW9uW1xzXChfXStcNlteXHtdK1tce1xzXSsoXCRbYS16XzAtOV=rKVxzKj=uKz9yZXR1cm5bXjtdKlw5W147XSpbO1xzXH1dKyk_KFw_PlxzKihcI1whW1wvYS16X1wtMC=5XCs9XHNdezIwMCx9JCk_fCQpL2lzIjt9czo=NjoiY2xhc3MgY29uc3QgcGFjayBIKiBmdW5jdGlvbiBpbmNsdWRlIG5ldyBDbGFzcyI7YToyOntpOjA7czo1OiJLOTVDSCI7aToxO3M6MjgwOiIvY2xhc3NccysoW2Etel8wLTldKylccypceygoPz=uK1wkcVN=cmluZ1tccz1dK1wkdGhpcy1cPihbYS16XzAtOV=rKVwoKXwuKz9jb25zdFxzKyhbYS16XzAtOV=rKVxzKj=uKz9zZWxmXDpcOihbYS16XzAtOV=rKVwocGFja1woJ=hcKidbLFxzXStzZWxmXDpcOlw=KS4rP2Z1bmN=aW9uXHMrKFwzfFw1KVwoKFwkW2Etel8wLTldKykuKz8oXCRbYS16XzAtOV=rfFxAPyhiYXNlNjRfZGVjb2RlfGluY2x1ZGV8cmVxdWlyZSkoX29uY2UpPylccypcKFteO1=qXDcuK25ld1xzK1wxW147XSo7L2lzIjt9czoxNDoiZXZhbCBzdHJfcm9=MTMiO2E6Mjp7aTowO3M6NToiRjlQQ2wiO2k6MTtzOjE1OToiLyhcL1wvLispP1xzKigoaW5pX3NldFwofGVycm9yX3JlcG9ydGluZ1wofFwkW2Etel8wLTldK1tcc1wuXSo9KVteO1=qO1xzKikqXEA_KGV2YWx8YXNzZXJ=fFwkW2EtelxfMC=5XSsoXHMqXFtbXlxdXStcXSkqKVxzKlwoXHMqc3RyX3JvdDEzXCgnLionXClcKTsoXHMqXDEpPy9pIjt9czozMjoicGhwIEdMT=JBTFMgSGV4IGZ1bmN=aW9uIGlmIGV2YWwiO2E6Mjp7aTowO3M6NToiSzg=S3EiO2k6MTtzOjgxNDoiLzxcP1twaFxzXSooXCRbYS16XzAtOV=rXHMqPVteO1=rO1xzKikqKFxzKlwkKEdMT=JBTFN8W1x7XCQnIl=rWzAtOV9cLWEtelxcJyJcLl=rW1x9XHNdKylbXHNcW1x7JyJdKyhbYS16XzAtOV=rKVsiJ1x9XF1cc1=rKFteO1=qO1xzKmdsb2JhbFxzKlwkXDRbXjtdKjtccypcJFw=XHMqPVxzKlwkR=xPQkFMU1teO1=qO1xzKlwkKFw=fFx7W15cfV=qXH=rKVxzKihcW1teXF1dK1tcXVxzXSt8XHtbXlx9XStbXH1cc1=rKSspPz1ccypbJyJdKFxceFswLTlhLWZdezEsMn=pK1siJ1=7XHMqKChlY2hvfHByaW5=KT9bXHNcQF=qXCQoR=xPQkFMfFw=KVteO1=rO1xzKnxcJFthLXpfMC=5XStccyooW1wuPV=rXHMqXEA_KE5VTEx8KGFycmF5W1woXHNdKyk_XCQoR=xPQkFMfFw=KVteO1=qfFwkW2Etel8wLTldKyhcW1teXF1dK1tcXVxzXSt8XHtbXlx9XStbXH1cc1=rKSp8WyInXSspKSs7XHMqfGdsb2JhbFxzKlwkW147XSs7XHMqfGZ1bmN=aW9uXHMrWzAtOV9hLXpdK1xzKlwoW15ce1=rfFx7XHMqfFx9XHMqfChmb3IoZWFjaCk_fChlbHNlXHMqKT9pZilccypcKC4rP1wpK1xzKnxyZXR1cm5bXjtdKjtbXHNcfV=rKXszMCx9KSpldmFsKFwvXCooW14qXSpcKig_IVwvKSkqW14qXSpcKlwvXHMqKSpcKCg_ISIgXD8-Ii5cJEdMT=JBTFNcWydPeHlnZW5fVlNCX=N1cnJlbnRfQ29tbWVudHNfQ2xhc3MpLis_XCkrKFwvXCooW14qXSpcKig_IVwvKSkqW14qXSpcKlwvXHMqKSo7W1xzXH1dKyhleGl=W147XSo7W1xzXH1dK3xcPz5ccyo8XD9bcGhcc1=rXCRbYS16XzAtOV=rXHMqPVxzKmFycmF5XChbXlwpXSpcKSsuKztccyopKigkfFw_PikvaSI7fXM6MzY6InBocCBpZiBpc3NldCBQT1NUIGJhc2U2NF9kZWNvZGUgbWFpbCI7YToyOntpOjA7czo1OiJLOFZFcCI7aToxO3M6NTc5OiIvPFw_W3BoXHNdKigoXCQoWzAtOV9hLXpdKylccyo9XHMqZXhwbG9kZVteLF=rLFxzKmJhc2U2NF9kZWNvZGVcKFteO1=rO1xzKnwoaW5pX3NldHxzZXNzaW9uX3N=YXJ=KVwoW147XSs7XHMqfCgoaWZ8aXNzZXR8Zm9yZWFjaClbXHNcKF=rKStcJF8oUkVRVUVTVHxHRVR8UE9TVHxTRVJWRVIpLlteXHtdK1x7XHMqKT8oKFwkW2Etel8wLTldKylbXHNcLl=qPVthLXpfMC=5XHNcKF=qW1wkImYnXShcM3xfUkVRVUVTVHxfR=VUfF9QT1NUfF9TRVJWRVJ8UkVNT1RFX=FERFJ8aHR=cFtzXT9cOlwvXC98aWxlX2dldF9jb25=ZW5=c1tcc1woXSspKFteO1=qW1wpO1x9XHNdK2Vsc2VbXHtcc1=rfGVjaG98cHJpbnQpKlteO1=qWztcc1=rKFxzKmV4aXQ7KT98XC9cLy4rXG4rKSpbXH1cc1=qKSsoKFwkWzAtOV9hLXpdKylbXHNcLl=qPVteO1=rO1xzKikqKChcJFthLXpfMC=5XStccyo9XHMqfGlmW1xzXChdK3xlbHNlW15ce1=qW1x7XHNdKykqbWFpbFxzKlwoW147XStbXCk7XHNcfV=qKSsoKChpZltcKFxzXSt8ZWxzZSlbXlx7XSpbXHtcc1=rKT8oKGhlYWRlcnxlY2hvfGV4aXQpW147XSpbO1xzXH1dKykrKSooJHxcPz4pL2kiO31zOjMwOiJ3cF9lbnF1ZXVlX3NjcmlwdCBTV=VFVENBUFRDSEEiO2E6Mjp7aTowO3M6NToiRjZVR2wiO2k6MTtzOjYwOiIvd3BfZW5xdWV1ZV9zY3JpcHRcKFteLF=rLFxzKlsnIl1odHRwLis_U1dFRVRDQVBUQ=hBW147XSs7L2kiO31zOjM4OiJwaHAgY2xhc3MgVmFyaWFibGUgRnVuY3Rpb25zIG5ldyBDTEFTUyI7YToyOntpOjA7czo1OiJKMlNBQSI7aToxO3M6NjQwOiIvPFw_W3BoXHNdKyhcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcL1xzKnwoaW5pX3NldHxlcnJvcl9yZXBvcnRpbmd8c2V=X3RpbWVfbGltaXQpXChbXlwpXSpcKTtccyopKihjbGFzc1xzKy4rPyhcJFthLXpfMC=5XSspXHMqPVtcc1xAXSpmaWxlX2dldF9jb25=ZW5=c1woLis_cmV=dXJuXHMrXDVbO1x9XHNdKnxjbGFzcyBCXHMqXHsuKj9yZXR1cm4gJ1VOJ1teO1=qWztcfVxzXSt8ZnVuY3Rpb25bXlwoXStkb2xseVteXHtdK1x7Lio_KHJldHVybnxkYkRlbHRhKVteO1=qWztcfVxzXSp8aWZbXHNcKFwhXStjbGFzc19leGlzdHNbXHNcKCciXSsoW2Etel8wLTldK=NhY2hlSGVscGVyKVsnIlwpXHNce1=rfCg_PS4qcmV=dXJuIG15ZnVuY2dvb2RcKCkpK2NsYXNzXHMrKFthLXpfMC=5XSspXHMqXHsuKygoPzwhIilcJFthLXpfMC=5XHtcfV=rKFxzKlxbW15cXV=rXF=pKnxmaWxlX3B1dF9jb25=ZW5=cylccypcKC4rKFwkW2Etel8wLTldK3xuZXcpW1w9XHNdKyhcNXxcOCkoXDpcOmdldEluc3RhbmNlKT9cKFteXCldKlwpK1s7XHNdKygoZWNob3xlbHNlKSpbXHNce1=qW1wkYS16XzAtOVx7XH1dKyhcOlw6fC=-KVthLXpfMC=5XHtcfV=rXHMqXChbXjtdKjtbXHNcfV=qKSooLio_ZXhpdFwoXCk7XHMqKT8oJHxcPz4pL2lzIjt9czoxNDoidmlzaXRvclRyYWNrZXIiO2E6Mjp7aTowO3M6NToiSkJCOFciO2k6MTtzOjI=NDoiLygoPFwhLS18XC9cKil2aXNpdG9yVHJhY2tlcihcKlwvfC=tPil8aWZbXHNcKFwhXSsobG9hZFN=YXRzKVtcKVxzXHtdK2Z1bmN=aW9uIFw=W1woXClcc1x7XSspXHMqKDxcP1twaFxzXSsuKz9iYXNlNjRfZGVjb2RlXHMqXCguKz9cPz58Lis_ZG9jdW1lbnRcLmNyZWF=ZUVsZW1lbnRcKFsnIl1zY3JpcHRbIiddXCk7XHMqLis_XC5zcmNccyo9W1xzJyJdK1todHBzXDpdKlwvXC8uKz8pXHMqKFwxfFw=W1woXClcfTtcc1=rKS9pcyI7fXM6NTg6ImZzb2Nrb3BlbiBmd3JpdGUgd2hpbGUgZmVvZiBmY2xvc2UgcHJlZ19tYXRjaCBnenVuY29tcHJlc3MiO2E6Mjp7aTowO3M6NToiRkE1TE8iO2k6MTtzOjIzMjoiLyhcJFthLXpfMC=5XSspXHMqPVxzKlxAP2Zzb2Nrb3BlblwoW147XSs7XHMqaWZbXChcc1=rXDFbXClcc1=qXHsuKz9md3JpdGVcKFwxW147XSs7XHMqd2hpbGVbXHNcKFwhXStmZW9mXChcMS4rP2ZjbG9zZVwoXDFcKTtccypwcmVnX21hdGNoXChbXixdKyxbXixdKyxccyooXCRbYS16XzAtOV=rKVwpO1xzKmlmW1woXHNdK1wyXFsxXF1bXHNcIV=qPS4rP2d6dW5jb21wcmVzc1woW147XSs7W1x9XHNdKy9pcyI7fXM6MjA6IlRhZ2dlZCBldmFsIGZ1bmN=aW9uIjthOjI6e2k6MDtzOjU6IkozRUNDIjtpOjE7czoxMjM6Ii8oXC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC8pXHMqKFtcc2Etel8wLTlcPV=rWztcc1woXSspKndpbmRvd1tcLlxbIiddK1xceFteO1=rO1xzKmV2YWxbXChcc1=rW15cKV=rWyciXHNcKFwpO1x9XStcMS9pcyI7fXM6NDQ6InNjcmlwdCB2YXIgaHR=cCBpZiBkb2N1bWVudCB3cml=ZSBzY3JpcHQgc3JjIjthOjI6e2k6MDtzOjU6IkcyQ=l3IjtpOjE7czozNTI6Ii8oPHNjcmlwdFtePl=qPlxzKigodmFyXHMqKT9bYS16XzAtOV=rXHMqPVsnIjtcc1=qKHNldFRpbWVvdXR8ZW5jb2RlVVJJQ29tcG9uZW5=KVwoW15cKV=qWyciXCk7XHNdezIsfSkrKFt2YXJcc1=qKFthLXpfMC=5XSspXHMqPVxzKlsnIl1baGZ=XSt=cFtzXSo6XC9cL1teO1=rO1xzKigodmFyXHMqKT8oW2Etel8wLTldKylccyo9XHMqXDZbXjtdKztccyopKyk_aWZbXlx7XStce1xzKmRvY3VtZW5=XC53cml=ZVwoWyInXTxbc2NyaXB=XHMnIlwrXXs3LH1bXlx9XSpzcmM9WyciXHNcK1=rKFw5fFtmaHRdK3RwW3NdKjpcL1wvLitqcXVlcnlcLihtaW5cLikqcGhwKShbXjtdK1tcfTtcc1=rKSs_PFwvc2NyaXB=PikrL2kiO31zOjQ1OiJmdW5jdGlvbiB1bnNldCB3cF9saXN=X3RhYmxlIGl=ZW1zIGFkZF9hY3Rpb24iO2E6Mjp7aTowO3M6NToiSzVMQUgiO2k6MTtzOjUwNzoiLyhcL1wqW15cKl=qKFwqW15cKlwvXSopK1wvXHMqKSooXCRbXjtdKz1bXjtdKztccyopKihpZltcKFxzXCFdK2Z1bmN=aW9uX2V4aXN=c1tcKFxzJyJdK2luaV9zZXRbJyJcKVx7XHNdKyhcQD9pbmlfc2V=XChbXjtdK1s7XHNdKykrW1xzXH=7XSspKmZ1bmN=aW9uXHMrKFthLXpfMC=5XSspXHMqXChbXlx9XSsoKHVwZGF=ZV9vcHRpb25bXCgnIlxzXSthY3RpdmVfcGx1Z2luc3xwYWNrXChbJyJdSFwqWyciLFxzXC4wLTlBLUZcKV=rO1xzKmlmW1xzXChcQGlzX1=rZmlsZVtfYS16XSpbXChcc1=rKFwkW2Etel8wLTldKykpLis_ZmlsZV9nZXRfY29udGVudHNbXHNcKF=rKFwkW2Etel8wLTldKykuKz9maWxlX3B1dF9jb25=ZW5=c1tcc1woXSsoXDl8XDEwKXx1bnNldFwoXCR3cF9saXN=X3RhYmxlLT5pdGVtc1xbfGZpbGVfZ2V=X2NvbnRlbnRzXChfX=ZJTEVfXy4rP2ZwdXRzXCguKz9zY2FuZGlyXCgpLis_YWRkX2FjdGlvblwoW14sXStbLFxzMC=5XCknIl=rXDZbXjtdKztbXHNcfV=qL2lzIjt9czozOToicGhwIGVycm9yX3JlcG9ydGluZyBmdW5jdGlvbiBkZXRlY3RfY21zIjthOjI6e2k6MDtzOjU6IkZCQkcwIjtpOjE7czoxNjA6Ii88XD9bcGhcc1=rKFxAPyhlcnJvcl9yZXBvcnRpbmd8c2V=X3RpbWVfbGltaXR8aW5pX3NldClcKC4qPzBcKTtccyopKy4qP2Z1bmN=aW9uIChkZXRlY3RfY21zXCgpLitcM1teO1=rO1xzKigoaWZccypcKFteXCldK3xlbHNlKVteXHtdKlteXH1dK1tcfVxzXSspKygkfFw_PikvaXMiO31zOjUxOiJmdW5jdGlvbiBnbHVlc19pdCBzYW5pdGl6ZV9rZXkgY2FsbF91c2VyX2Z1bmNfYXJyYXkiO2E6Mjp7aTowO3M6NToiRkJJOUsiO2k6MTtzOjI5MjoiLyhpZltcc1woXCFdK2Z1bmN=aW9uX2V4aXN=c1woXHMqWyciXVthLXpfMC=5XStbJyJdW1xzXCldK1x7XHMqKT9mdW5jdGlvblxzKyhbYS16XzAtOV=rKVxzKlwoW15cKV=rW1wpXHNdK1x7XHMqKFwkW2Etel8wLTldKylccyo9XHMqc2FuaXRpemVfa2V5XChbXjtdKztccyooXCRbYS16XzAtOV=rKVxzKj1ccypjYWxsX3VzZXJfZnVuY19hcnJheVwoXHMqXDNbXjtdKztccypyZXR1cm5ccypcNC4rXDJccypcKFteO1=rO1xzKi4rY2FsbF91c2VyX2Z1bmNfYXJyYXlcKFteO1=rO1tcfVxzXSsoJHwoPz1cPz4pKS9pcyI7fXM6MTY6InBocCBldmFsIFZhciBIZXgiO2E6Mjp7aTowO3M6NToiRkJLS1IiO2k6MTtzOjExNToiLzxcP1twaFxzXSsoQD9ldmFsXHMqXChccyopKyhbJyJdKVtcc1xcXSpcJFthLXpcXzAtOVxbXF1ce1x9XHMnIl=rPVtcc1xcJyJdKihcXHhbMC=5XXsyfSkrLitcMihccypcKSkrO1xzKigkfFw_PikvaSI7fXM6Mjk6ImlmIHN=cnBvcyBSRVFVRVNUX1VSSSBpbmNsdWRlIjthOjI6e2k6MDtzOjU6IkZDUUZTIjtpOjE7czoxNDk6Ii9pZihbXHNcKF=rc3RyW2Etel8wLTldKyl7Mix9W1xzXChdK1wkX1NFUlZFUlxbWyInXVJFUVVFU1RfVVJJWyciXVxdXHMqXCkrW15cKV=rW1wpXHNdK1x7W1xzXEBdKihpbmNsdWRlfHJlcXVpcmUpKF9vbmNlKT9bXjtdK1s7XHNdKyhleGl=W1xzO1=rKT9cfS9pIjt9czo3NjoiZXJyb3JfcmVwb3J=aW5nIGluaV9zZXQgc2V=X3RpbWVfbGltaXQgaWdub3JlX3VzZXJfYWJvcnQgZWxzZWlmIHJlcXVpcmVfb25jZSI7YToyOntpOjA7czo1OiJKNUtMZCI7aToxO3M6Mjk3OiIvPFw_W3BoXHNdKyhcL1wqW15cKl=qKFwqW15cKlwvXSopK1wvXHMqfFwvXC9bXlxuXSpccyspKihcQD8oZXJyb3JfcmVwb3J=aW5nfGluaV9zZXR8c2V=X3RpbWVfbGltaXR8aWdub3JlX3VzZXJfYWJvcnQpXHMqXChbXjtdK1s7XHNdKyl7Myx9KChlbHNlXHMqfGlmXHMqXCgrW15cKV=rW1xzXCldKykrKC4qPyhhc3NlcnR8ZXZhbHxmaWxlX3B1dF9jb25=ZW5=c3xmd3JpdGVcKC4qP2ZjbG9zZSlcKFteXCldK1tcKTtcfVxzXSopKlxAPyhyZXF1aXJlfGluY2x1ZGUpKF9vbmNlKT9bXjtdK1s7XH1cc1=rKSsoJHxcPz4pL2kiO31zOjgzOiJwaHAgaWYgZnVuY3Rpb25fZXhpc3RzIGZ1bmN=aW9uIGN1cmxfaW5pdCByZXR1cm4gZnVuY3Rpb24gdHJpbSByZXR1cm4gYmFzZTY=X2RlY29kZSI7YToyOntpOjA7czo1OiJHMThGbiI7aToxO3M6NDA1OiIvPFw_W3BoXHNdKyhcJFthLXpfMC=5XSspXHMqPVteO1=rO1xzKmlmXHMqXChccypcIWZ1bmN=aW9uX2V4aXN=c1woWyInXShbYS16XzAtOV=rKVsnIl1cKVtcKVxzXHtdKmZ1bmN=aW9uXHMqXDJcKFteXCldK1wpW1wpXHNce1=rW15cbl=qY3VybF9pbml=XChcKTsuKz9yZXR1cm5bXjtdKztbXHMrXH1dK2lmXHMqXChccypcIWZ1bmN=aW9uX2V4aXN=c1woWyInXShbYS16XzAtOV=rKVsnIl1cKVtcKVxzXHtdKmZ1bmN=aW9uXHMqXDNcKFteXCldK1wpW1wpXHNce1=rW15cbl=qdHJpbVteO1=rOy4qP3JldHVyblteO1=rO1tccytcfV=rKC4qPyhiYXNlNjRfZGVjb2RlW1woXHNdK1wxfFwyXCh8XDNcKClbXlwpXSpbXClcc1=rW147XSpbO1xzXSspezMsfSgoZWNob3xwcmludClbXjtdKztccyopKygkfFw_PikvaXMiO31zOjEyOiJQSFAgcmV2ZXJzZWQiO2E6Mjp7aTowO3M6NToiSTU2N2QiO2k6MTtzOjQ4OiIvXihccypcPlw_XHMqKT87Lisob2hjZXxcJCkoW3BoXHNdKlw_XDwpP1xzKiQvaXMiO31zOjM=OiJpZiBpc3NldCBSRVFVRVNUIFZhcmlhYmxlIEZ1bmN=aW9uIjthOjI6e2k6MDtzOjU6Iko5NTB2IjtpOjE7czozNzY6Ii8oPFw_W3BoXHNdKlxAXHMqJ1teJ1=qPyc7XHMqLispKGlmW1xzXChcIV=rKGlzc2V=fGVtcHR5KVtcc1woXStcJF8oUkVRVUVTVHxHRVR8UE9TVHxDT=9LSUV8U=VTU=lPTilbXlx7XStce1xzKikrKFwkW2Etel8wLTlce1x9XStccyo9XHMqKCdbXiddKid8IlteIl=qInxcJClbXjtdKlsnIjtcKVxzXSp8ZXh=cmFjdFtcc1woXStcJF9cM1tcc1wpXSs7XHMqKSouKihcJFthLXpfMC=5XStccyo9XHMqfGVjaG9bXHNcKF=rKT9cQD8oXCQoPyFkZWxldGVfc2VydmljZSlbYS16XzAtOV=rKShccypcW1teXF1dKlxdKSpzKlwoLio_XCkrXHMqO1teXH1dKlx9K1s7XHNdKigoaWZbXHNcKF=rW15ce1=rfGVsc2VccyopXHtbXlx9XStcfSspKi4qXHMqKFw_PlxzKik_L2kiO31zOjE4OiJldmFsIGJhc2U2NF9kZWNvZGUiO2E6Mjp7aTowO3M6NToiSjRPRWsiO2k6MTtzOjQwODoiLyhcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcL1xzKnxcQD8oKGVycm9yX3JlcG9ydGluZ3xldmFsfHNldF9=aW1lX2xpbWl=fGluaV8oc2V=fHJlc3RvcmUpKVxzKlwoW15cKV=qXCkrfChcJFthLXpfMC=5XSspXHMqPSlbXjtdKjtbXHM7IidcKV=qfFw_PlxzKjxcP1twaFxzXSopKihpZltcKFxzXSsoW2lzc2V=bWQ1XStcKCkqXCRfKFBPU3xHRXxSRVFVRVMpVFxbLitbXClcc1x7XSt8ZWNob1xzKikqKChcJFthLXpfMC=5XSspXHMqPVxzKlxAP2Jhc2U2NF9kZWNvZGVbXHNcKF=rW147XSs7XHMqXEA_KGV2YWxbXHNcKF=rLipcMTF8XDExXHMqXChccypcJF8oUE9TfEdFfFJFUVVFUylUKXxcQD9ldmFsW1xzXChdK1teO1=qP2Jhc2U2NF9kZWNvZGVcKClbXlwpXSpcKSs7LipccyoocmV=dXJuW147XSo7LiopKi9pIjt9czozMToicGhwIGlmIG1kNSBSRVFVRVNUIGV2YWwgUkVRVUVTVCI7YToyOntpOjA7czo1OiJIODhOWCI7aToxO3M6Njc5OiIvPFw_W3BoXHNdKygoXC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC98W1x7XHNdKykqKFwkW2Etel8wLTldKykoXHMqXC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC8pKlxzKj1bXjtdKztccyp8aWYoXHMqXC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC8pKltcc1woXSsoaXNzZXR8bWQ1KVwoXCQoX1JFUVVFU1R8X1BPU1R8X=dFVHxfQ=9PS=lFfFx7WyInXVteXH1dK1x9KylccypcW1teXCldK1wpKyhcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcL3xbXHtcc1=rKSp8XC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC9ccyopKj8oXCRbYS16MC=5XSsoXHMqXC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC8pKlxzKj1ccyopPyhhc3NlcnR8ZXZhbHxcNHxcJFwxMChccypcW1teXF1dK1xdKykrKShccypcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcLykqXHMqXCgoXHMqXC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC8pKlwkKF9SRVFVRVNUfF9QT1NUfF9HRVR8X=NPT=tJRXxce1siJ11bXlx9XStcfSspKFxzKlxbW15cXV=rXF=rKStccypbXjtdKzsoKGRpZXxleGl=fGVjaG98cHJpbnQpW147XSo7XHMqfChcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcL1xzKikqfFx9XHMqKSooJHxcPz4oPGZvcm1bXj5dKig-XHMqPGlucHV=W14-XSopKz5ccyo8XC9mb3JtPik_KS9pIjt9czozMToiaWYgaXNzZXQgZXZhbCBWYXJpYWJsZSBmdW5jdGlvbiI7YToyOntpOjA7czo1OiJKMk9CZiI7aToxO3M6MzE2OiIvPFw_W3BoXHNdKihcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcL1xzKnxcL1wvLipccyp8XEA_dG91Y2hcKC4qXCkrO1xzKnxcJFthLXpfMC=5XHtcJFx9XSsoXHMqXFtbXlxdXStcXSkqXHMqPVteO1=rO1xzKikqaWZbXHNcKFwhXStpc3NldFtcc1woXStcJFthLXpfMC=5XCRce1x9XSsoXHMqXFtbXlxdXStcXSkqW1wpXHNce1=rLio_XHMqKFwkW2Etel8wLTlce1wkXH1dKyhccypcW1teXF1dK1xdKSpccyo9XHMqKT9cQD9ldmFsXCguKj9cJFthLXpfMC=5XHtcJFx9XSsoXHMqXFtbXlxdXStcXSkqXHMqXCguKj9cKSs7WztcfVxzXSooXCR8XD8-KS9pIjt9czo1NzoiZXJyb3JfcmVwb3J=aW5nIGV4ZWMgc3lzdGVtIHBhc3N=aHJ1IGZvcGVuIFJFUVVFU1QgZndyaXRlIjthOjI6e2k6MDtzOjU6IkoyQkpCIjtpOjE7czoyOTE6Ii88XD8uKz8oc2V=X3RpbWVfbGltaXRcKDB8ZXJyb3JfcmVwb3J=aW5nXCgwfGV4cGxvZGVcKFsnIl13cC1jb25=ZW5=KSg_PS4rP3Bhc3N=aHJ1XHMqXCgpKD89Lis_c3lzdGVtXHMqXCgpKD89Lis_ZXhlY1xzKlwoKSgoPz=uKz9jdXJsX2luaXRccypcKCkoPz=uKz9maWxlX2dldF9jb25=ZW5=c1xzKlwoKXwoPz=uKz9yZWFkZGlyXHMqXCgpKD89Lis_dW5saW5rXHMqXCgpfCg_PS4rP2ZvcGVuXHMqXCgoXCRbYS16XzAtOV=rKSkoPz=uKz9cM1xzKj1ccypcJF9QT1NUKSkoPz=uKz9md3JpdGVccypcKCkuKy9pcyI7fXM6MTg6Ii9mdW5jdGlvbiB4IGV2YWwgeCI7YToyOntpOjA7czo1OiJIOEFJVCI7aToxO3M6MTUxOiIvKGlmXHMqXChbXlx7XStce1xzKik_ZnVuY3Rpb25ccysoW2Etel8wLTldKylccypcKFteXHtdK1x7XHMqKFwkW2Etel8wLTldK1xzKj1bXjtdKztccyopKlxAPyhhc3NlcnR8ZXZhbClcKC4rP1wyXChcJF8oUkVRVUVTfEdFfFBPUylUXFsuKz9cKTtbXHNcfV=qL2lzIjt9czoyMDoiR=VUX2RsIHNhZmVfbW9kZSBlbmQiO2E6Mjp7aTowO3M6NToiSDhGRmUiO2k6MTtzOjE4NToiLzxcP1twaFxzXStpZltcc1woXSsoaXNzZXRcKFwkX=dFVFxbWyciXWRsWyInXVxdXCl8XEBzdHJpcG9zW1woXHNdK1wkX1NFUlZFUlxbWyInXUhUVFBfVVNFUl9BR=VOVCkuKz9zYWZlX21vZGUuKz8oXD8-KFxzKjxcL2Rpdj5ccyo8XC9ib2R5PlxzKjxcL2h=bWw-KT98PFwvYm9keT5ccyo8XC9odG1sPlsnIjtcc1=qJCkvaXMiO31zOjE=OiJHTE9CQUxTIDAgZXZhbCI7YToyOntpOjA7czo1OiJLOEtHUCI7aToxO3M6MTY3OiIvPFw_W3BoXHNdKihcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcL1xzKnxcL1wvW15cbl=qXG5ccyopKihcJChHTE9CQUxTKT9bXFtceyciXSpbMF9vT1=rWyciXF1cfVxzXSpbXD1cLlxzXStbXjtdKztccyopKy4qP2V2YWxcKC4rXClbXCk7XHNdKihyZXR1cm5bXjtdKjspKigkfFw_PikvaSI7fXM6MjE6ImtleXNwYXQgdmlhZ3JhIGNpYWxpcyI7YToyOntpOjA7czo1OiJIOEZGZyI7aToxO3M6MTAzOiIvZXJyb3JfcmVwb3J=aW5nXCgwXCk7XHMqXCRrZXlzcGF=Wz1cc1=rYXJyYXlbXChcc1=rKChbJyJdKSh2aWFncmF8YW1veGljaWxsaW58Y2lhbGlzKVwyW1xzLF=rKXsyfS4rL2lzIjt9czo1MToic2Vzc2lvbl9zdGFydCBlcnJvcl9yZXBvcnRpbmcgc2V=X3RpbWVfbGltaXQgZm9vdGVyIjthOjI6e2k6MDtzOjU6Iks3UkdmIjtpOjE7czoyNzE6Ii88XD9bcGhcc1=rKFxAKihzZXNzaW9uX3N=YXJ=fGVycm9yX3JlcG9ydGluZ3xzZXRfdGltZV9saW1pdClcKFteO1=rO1xzKil7Mix9KGVjaG9bXChccyciXSs8KFwhRE9DVFlQRSApP=hUTUw-Lis8XC9IVE1MPlsnIjtcc1=rZnVuY3Rpb24gcGVybXNcKChcJFthLXpfMC=5XSspW1wpXHNce1=rXCRbYS16XzAtOV=rXHMqPVxzKmZpbGVwZXJtc1woXDVcKTsuK3JldHVyblteO1=rO1tcfVxzXSt8Lis_PFw_XHMqZWNob1tcKFxzXSpcJGZvb3RlcltcKTtcc1=rKSgkfFw_PikvaXMiO31zOjMzOiJtZDV=YWdnZWQgZXZhbCB2YXJpYWJsZSBmdW5jdGlvbnMiO2E6Mjp7aTowO3M6NToiSzRHOU8iO2k6MTtzOjUzNzoiLygoPzwhdmFyICkoXC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC9ccyp8XEA_ZXJyb3JfcmVwb3J=aW5nW1woMFwpXHNdKztccyopKlxAPyhcJFthLXpfMC=5XSspW1xzXC5dKj1ccyooKCdbXiddKig_PCFfZSknfCJbXiJdKiJ8XCRbYS16XzAtOV=rfHN=cnJldlwoKVtcc1wuXSopK1teO1=qO1xzKikrPygoXC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC9ccyopKlxAPyhcJFthLXpfMC=5XSspW1xzXC5dKj1ccyooKCdbXiddKig_PCFfZSknfCJbXiJdKiJ8XCRbYS16XzAtOV=rfGFycmF5XCh8KHN=cnJldilcKClbXHNcLl=qKStbXjtdKjtccyp8Zm9yZWFjaFtccyhdK1teXHtdK1x7W15cfV=rXH1ccyopKz8oKFwvXCooW14qXSpcKig_IVwvKSkqW14qXSpcKlwvXHMqfChcJFthLXpfMC=5XSspW1xzXC5dKj1ccyopKlxAPyhldmFsfFwkW2Etel8wLTldKylcKFteXCldKj9bXCk7XHNdKigoXDR8XDEwXHxcMTN8XDE2KVxzKihcW3xcKClbXlwpXSpbXClcc1=rO1xzKikrKSsoXC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC9ccyopKi9pIjt9czo1NjoiaWYgaXNzZXQgUE9TVCBmaWxlX2dldF9jb25=ZW5=cyBmb3BlbiBmd3JpdGUgZmNsb3NlIGV4aXQiO2E6Mjp7aTowO3M6NToiSjFHQWkiO2k6MTtzOjU1NjoiLyg_PD1cPFw_cGhwKShccypcJFthLXpfMC=5XStccyo9W147XSs7fFxzKlxAPyhpZ25vcmVfdXNlcl9hYm9ydHxpbmlfc2V=fHNldF9=aW1lX2xpbWl=fGVycm9yX3JlcG9ydGluZylcKC4qP1wpO3xccypcL1wvW15cbl=qXG58XHMqXC9cKlteXCpdKihcKlteXCpcL1=qKStcLykqXHMqaWZbXChcc1whXSsoZnVuY3Rpb25fZXhpc3RzW1woXHNdKyhbIiddKShbYS16XzAtOV=rKVw1W15ce1=rW1x7XHNdK3xpc3NldFtcKFxzXStcJF8oUkVRVUVTVHxHRVR8UE9TVHxTRVJWRVIpXFspLis_KFwkW2Etel8wLTldKylccyo9XHMqXEA_ZihpbGVfZ2V=X2NvbnRlbnRzfG9wZW5cKC4rP2ZnZXRzKVwoXHMqKFw4W1xzXCldK3xbJyJdW2h=cHM6XStcL1wvfF9fRklMRV9fKSguKz8oZmlsZV9wdXRfY29udGVudHNcKHxmb3BlblwoLis_ZndyaXRlXCguKz9mY2xvc2VcKClbXlwpXSpcKVtcKTtcfVxzXSspKCg_PVw_XD4pfC4qPygocmV=dXJufChlbHNlKT9pZlxzKlwoW15ce1=rXHtccypleHRyYWN=XCh8ZGllfGV4aXQpW147XSo7W1xzXH1dKikrKFwvXC9bXlxuXSpcblxzKil7Myx9KS9pcyI7fXM6MjU6ImZ1bmN=aW9uIEFycmF5IHByaW5=IGV4aXQiO2E6Mjp7aTowO3M6NToiSjJROVYiO2k6MTtzOjcxNDoiLzxcP1twaFxzXSsoXCRbX1wtXD5cLmEtejAtOVx7XFsnIlxdXH1dK1xzKj1bXjtdKztccyopKigoZnVuY3Rpb25ccytbYS16XzAtOV=rXCguKj9cKVxzKlx7KD8hIFx9OykoXCRbXj1dKz1ccypbJyJdezJ9KT98Zm9yW1xzKF=rW15ce1=rXHtbXlx9XStcfS4qP3wocmV=dXJufGdsb2JhbClccysoXCRce1teXH1dK1x9Kyk_W147XSo7fFwkXHsuKz9cfVxzKlwoLio_XCkrO3xcJFx7Lis_XH1ccyo9XHMqYXJyYXlcKCgoW2Etel8wLTldK1woLio_XCkrLFxzKikrW2Etel8wLTldK1woLio_KT9cKSs7fGlmXHMqXCguKj9cKStccypce3xlbHNlW1xzXHtdKnxcJFtfXC1cPlwuYS16MC=5XHtcWyciXF1cfV=rW1xzXC5dKj=oXHMqY2hyXCguKj9cKSt8KC4rP1xeKXs1LH18W147XStcXlxzKlxkKylbXjtdKjt8ZXhpdFwoLio_XCkrO3woXCQoXHtbYS16XzAtOV=rXCguKz9cKVx9KFxzKlxbW15cXV=qXF=rKSp8Y29udGVudHx1cmwpW1xzXCtcLjtcfTw-XC5dKikrPVxzKihbXEBcJFx7XSpbYS16XzAtOVx9XSsoXCguKz9cKXxcWy4rP1xdKSlcfSo7fGZvcmVhY2guKz9ccythc1xzK1teXCldK1teXHtdK1x7KVs7XHNcfV=qKXs1MCx9KFwkKFx7W2Etel8wLTldK1woLis_XClcfShccypcW1teXF1dKlxdKykqfGNvbnRlbnR8dXJsKVtcc1wrXC47XH=8PlwuXSopKz1ccyooW1xAXCRce1=qW2Etel8wLTlcfV=rKFwoLis_XCl8XFsuKz9cXSkpWztcfV=qKCR8XD8-KS9pIjt9czo=MDoicGhwIGlmIGlzc2V=IEdFVCBlY2hvIGlmIFBPU1QgY29weSBGSUxFUyI7YToyOntpOjA7czo1OiJLOUxKQyI7aToxO3M6NTQ=OiIvKD88PVw8XD9waHApXHMqKGVjaG9bXjtdKjtccyp8ZXJyb3JfcmVwb3J=aW5nXCgwXCk7XHMqfFwvXCouKj9cKlwvXHMqfFwkW2Etel8wLTldK1xzKj1bXjtdKztccyp8KFwvXC98XCMpW15cbl=qXG5ccyopKmlmW1xzXChdK2lzc2V=XChcJF8oUkVRVUVTfEdFfFBPUylUW15cKV=rW1wpXHNce1=rKChlY2hvfHByaW5=fFwkW2Etel8wLTldK1xzKj=pW147XSs7XHMqKStpZltcc1woXStcJF8oUkVRVUVTfEdFfFBPUylUW15cKV=rW1wpXHNce1=raWZbXHNcKF=rXEA_Y29weVwoKFtcc1wsXSpcJF9GSUxFUyhcW1teXF1dK1xdKSspK1tcKVxzXStce1teXH1dKygoXHMqXH=pKyhccyplbHNlW1xzXHtdK1teXH1dKyk_KSsoXHMqKFwvXC98XCMpW15cbl=qfFxzKlwvXCouKj9cKlwvKSooXHMqZXJyb3JfcmVwb3J=aW5nXCgwXCk7XHMqZnVuY3Rpb25ccysoW2Etel8wLTldKylccypcKC4rXDE1W1woXHNdK1wkXyhSRVFVRVN8R=V8UE9TKVQuK2VjaG9bXHNcKF=qKFsnIl=pPHNjcmlwdC4rPzxcL3NjcmlwdD5cMTc7W1xzKlx9XSsoPz1cL1wqfCR8XD8-KSk_L2lzIjt9czoxODoiYXV=aF9wYXNzIEZpbGVzTWFuIjthOjI6e2k6MDtzOjU6Iko4R=xKIjtpOjE7czoyNTc6Ii88XD9bcGhcc1=rKGlmW1xzXChdK2lzc2V=XHMqXChccypcJF8oUkVRVUVTfEdFfFBPUylUXFsoWyciXSkoW2Etel8wLTldKylcM1teXHtdK1x7XHMqc3dpdGNoIFwoXCRfXDJUXFtcM1w=XDNcXS4rP2RlZmF1bHQ6W15cfV=rW1x9XHNdK2RpZVwoW15cfV=rW1x9XHNdK2lmW1xzXChdK1wkd3BkYlwtPmdldF92YXJcKC4rP2V4aXQ7W1x9XHNdK3woPz=uKlwkYXV=aF9wYXNzKSg_PS4qRmlsZXNNYW4pKD89Lio9W147XXsyMDAwfSkuKykoJHxcPz4pL2lzIjt9czo4ODoicGhwIHNldF9=aW1lX2xpbWl=IGZpbGVfZ2V=X2NvbnRlbnRzIFJFUVVFU1QgZmlsZV9nZXRfY29udGVudHMgRklMRVMgZm9wZW4gUkVRVUVTVGZ3cml=ZSI7YToyOntpOjA7czo1OiJIOEtMTyI7aToxO3M6MTU=OiIvPFw_W3BoXHNdKy4rP3NldF9=aW1lX2xpbWl=XCguKz9maWxlX2dldF9jb25=ZW5=c1woXCRfKFJFUVVFU3xHRXxQT1MpVC4rP2ZpbGVfZ2V=X2NvbnRlbnRzXChcJF9GSUxFU1xbLis_Zm9wZW5cKFwkXyhSRVFVRVN8R=V8UE9TKVQuKz9md3JpdGVcKC4rPyhcPz4pL2lzIjt9czoyMzoiY2xlYXJzdGF=Y2FjaGUgaGVyZSBkaWUiO2E6Mjp7aTowO3M6NToiSEE3QUoiO2k6MTtzOjQ2ODoiLzxcP1twaFxzXSooZXJyb3JfcmVwb3J=aW5nXCgwXCk7XHMqKSooaWZbXHNcKFwhXStpc3NldFtcc1woXStcJF8oUkVRVUVTfFBPU3xHRSlUXFtbJyJdWzAtOV9hLXpdK1snIl1cXVtcKVxzXHtdKygoZWNob3xyZXF1aXJlfFwkWzAtOV9hLXpdK1xzKj1ccyooXCR8KFsnIl=pLio_XDcpKVteO1=rO1tcc1x9XSspKikrKFwkWzAtOV9hLXpdK1xzKj1ccyopPyhcJHdwZGJcLT5xdWVyeVwoXHMqfG15c3FsX2Nvbm5lY3RbXHNcKF=rXCRfKFJFUVVFU3xQT1N8R=UpVFxbWyciXVswLTlfYS16XStbJyJdXF=uKz8pIklOU=VSVFxzK=lOVE9bXHNcYCJcLlwkMC=5X2EtelwtXD5dK3VzZXJzW1xzXGBdK1woLisoKG15c3FsX2Nsb3NlXChbXlwpXSpcKXxjbGVhcnN=YXRjYWNoZS4raGVyZTtccytkaWV8KFwkWzAtOV9hLXpdKylccyo9XHMqXEBmaWxlX2dldF9jb25=ZW5=c1woLitcMTNbXClcc1=qKTtbXH1cc1=rKSsoJHxcPz4pL2lzIjt9czoxMDoidW5zZXQgc2VsZiI7YToyOntpOjA7czo1OiJJN=RCViI7aToxO3M6Mjg3OiIvPFw_W3BoXHNdKihcQD9jaG1vZFwoW15cKV=rXCk7XHMqKSppZltcc1woXCFdKyhpc3NldHxlbXB=eSlbXHNcKF=rXCRfKFJFUVVFU1R8R=VUfFBPU1R8Q=9PS=lFKVteXHtdK1tce1xzXSooXCRbYS16XzAtOVx7XH1dKylccyo9Lis_bWtkaXJbXHNcKCInXC5cL1=rXDRbXCk7XHNdK2ZvcmVhY2guKz9ce1teXH1dK1x9XHMqKGlmW1xzXChcIV=raXNfZGlyW15cKV=rXCkrW1x7XHNcQF=qbWtkaXJbXHNcKF=rW15cKV=rXCkrO1tcc1x9XSopKy4qPyh1bmxpbmtcKFteXCldK1wpO1xzKikrKCR8XD8-KS9pcyI7fXM6NDE6ImlmIGlzc2V=IFJFUVVFU1QgdG91Y2ggbW92ZV91cGxvYWRlZF9maWxlIjthOjI6e2k6MDtzOjU6Ikg4TUUyIjtpOjE7czozNDY6Ii8oKGlmW1woXHNcIV=rKChwcmVnX21hdGNoW1xzXChdK1teLF=rLFxzKik_XDh8KGlzc2V=fGVtcHR5KVtcc1woXStcJF8oUkVRVUVTVHxHRVR8UE9TVHxGSUxFUykpXHMqXFtbXlx7XStce1xzKigoXCRbYS16XzAtOV=rKVxzKj1bXjtdKztccyopKikrKGZvcmVhY2hccypcKFteXCldK1wpK1tcc1x7XSppZltcc1woXStbXlwpXStcKStccypjb25=aW51ZTtccyopPygoXCRbYS16XzAtOV=rKVxzKj18aWZccypcKCkqW1xzXEBdKihtb3ZlX3VwbG9hZGVkX2ZpbGV8dG91Y2h8XCRbYS16XzAtOV=rKVxzKlwoW15cO1=rOyhbXH1cc1=qKChcJFthLXpfMC=5XStccyo9fGVjaG8pW147XSs7XHMqKSopKyl7Mix9L2kiO31zOjU4OiJwaHAgaWYgaXNzZXQgUkVRVUVTVCBldmFsIGZpbGVfcHV=X2NvbnRlbnRzIGluY2x1ZGUgdW5saW5rIjthOjI6e2k6MDtzOjU6IktBT=s2IjtpOjE7czo3MTU6Ii88XD9bcGhcc1=rKFxAPyhpZ25vcmVfdXNlcl9hYm9ydHxzZXRfdGltZV9saW1pdHxpbmlfc2V=fGVycm9yX3JlcG9ydGluZ3xERUZJTkUpXChbXlwpXSpcKVtcc1wpXSo7XHMqfFwvXC9bXlxuXSpcblxzKikqKFwkW2Etel8wLTlcWyciXF1dK1xzKj1bXjtdKztccyopKigodHJ5XHMqfGZ1bmN=aW9uXHNbXlx7XSopXHtccyopP2lmW1xzXChcIV=rKChlbXB=eXxzdHJsZW58aXNzZXQpXChcJF8oUkVRVUVTfEdFfFBPUylUfFtcJGEtel8wLTldKltcc1w9XSpbc2Nhbm9wZXJkXStkaXJbXChcc1=rKFwkW2Etel8wLTldKykpW15ce1=rXHsuKj8oXCRbYS16XzAtOV=rKVxzKj=uKj8oY3VybF9bXlwoXSt8ZXZhbHxmaWxlX2dldF9jb25=ZW5=cylcKChcOXxcMTApLis_ZmlsZV8uLnRfY29udGVudHNbXCggXSsoW1wkYS16XzAtOVxbJyJcXVwuXSspLis_KGVjaG9bXHNcKF=rXDEwfGluY2x1ZGUoX29uY2UpP1tcKFxzXStcMTMuKz91bmxpbmtbXChcc1=rXDEzfGN1cmxfaW5pdFwoLis_Y3VybF9zZXRvcHRcKFteLF=rLFxzKkNVUkxPUFRfVVJMWyxcc1=rXDEzfFx9XHMqY2F=Y2hccypcKFxzKkV4Y2VwdGlvblxzKlwkW2Etel8wLTldK1tcKVxzXSpce1teXH1dKlx9XHMqfGZpbGVfZ2V=X2NvbnRlbnRzW1xzXCgiJ1=raHR=cFteO1=rO1tcc1wvXEBdKmZpbGVfcHV=X2NvbnRlbnRzXCguKz9lcnJvcl9yZXBvcnRpbmdbXChcczBcKV=rO1xzKikuKigkfFw_PikvaXMiO31zOjQzOiJwaHAgY2hkaXIgUkVRVUVTVCBnZXRjd2QgbW92ZV91cGxvYWRlZF9maWxlIjthOjI6e2k6MDtzOjU6Iks5QUZHIjtpOjE7czozNTU6Ii88XD8uKz8oY2hkaXJbXChcc1=rXCRfKFJFUVVFU3xQT1N8R=UpVFxbfGVycm9yX3JlcG9ydGluZ1tcKFxzXSswKS4rPyhcJFthLXpfMC=5XSspWz1cc1xAXStnZXRjd2RbXHNcKF=rLis_KChcJFthLXpfMC=5XSspWz1cc1xAXStcJF8oUkVRVUVTfFBPU3xHRSlUXFtbXjtdKztccyppZltcc1woXSspPyhjb3B5fG1vdmVfdXBsb2FkZWRfZmlsZSlbXHNcKF=rKC4rP3VubGlua1tcc1woXSsuKz9zY2FuZGlyW1xzXChdKyhcM3xcNSl8XCRfRklMRVNcW1teLF=rWyxcc1=rKFwkX1wyfFwzfFw1KSkoLitjaGFuZ2VwYXNzXCgpPyguKz9cPz5ccyo8XD9bcGhcc1=qXH=pKi4rPygkfFw_Pihccyo8XC8oYm9keXxodG1sKT4pKikvaXMiO31zOjM1OiJlcnJvcl9yZXBvcnRpbmcgaW5pX3NldCB1bmxpbmsgRklMRSI7YToyOntpOjA7czo1OiJIOTVGNSI7aToxO3M6MzAwOiIvXEA_ZXJyb3JfcmVwb3J=aW5nXCgwXCk7XHMqKGluaV9zZXRcKC4rXEA_dW5saW5rXChfX=ZJTEVfX1wpO3woaWZbXHNcKFwhXSsoaXNzZXRcKHxmaWxlX2V4aXN=c1woKT9ccypcJF8oU=VSVkVSfFJFUVVFU1R8R=VUfFBPU1R8RklMRVMpXFtbXlxdXStcXStbXlwpXSpcKVtcKVxzXHtdKihlY2hvW147XSs7XHMqKSopK1xAP2NvcHlcKChbXHNcLF=qXCRfRklMRVMoXFtbXlxdXStcXSspKykrW1wpXHNdKztbXHNcfV=rXD8-XHMqKDwoZm9ybXxpbnB1dClbXj5dKz5ccyopKzxcL2Zvcm=-XHMqKDxcP1twaFxzXStcfSspPykvaXMiO31zOjExOiJpbmNsdWRlIEdFVCI7YToyOntpOjA7czo1OiJJOTZEQyI7aToxO3M6MzUyOiIvKFxzKihcJFswLTlfYS16XSspXHMqPVxzKihbIiddKShbYS16XC9fXC=wLTlcLl=qXFx4W2EtZjAtOV17Mn=pK1teXDNdKj9cMzt8XHMqKFwvXCooW14qXSpcKig_IVwvKSkqW14qXSpcKlwvKSkqW1xAXHNdKihpbmNsdWRlfHJlcXVpcmUpKF9vbmNlKT9bXHNcKF=qKFwvXCpbXlwqXSooXCpbXlwqXC9dKikrXC9ccyopKltcKFxzXSooKFsiJ1=pKFthLXpcL19cLTAtOVwuXSpcXCh4W2EtZjAtOV17Mn18WzAtOV17MiwzfSkpK1teXDEyXSo_XDEyfFwyfFwkXyg_IVJFUVVFU1RcWyd=YXJnZXQnXF=7KShQT1N8UkVRVUVTfEdFKVRccyooXFtbXlxdXStcXVxzKnxce1teXH1dK1x9XHMqKSspW1xzXCldKjsoXHMqXDUpKi9pIjt9czo1MzoicGhwIGZ1bmN=aW9uIGZpbGVfZ2V=X2NvbnRlbnRzIGZ3cml=ZSB1bmxpbmsgX19GSUxFX18iO2E6Mjp7aTowO3M6NToiSjZRTVAiO2k6MTtzOjQ2MDoiLzxcP1twaFxzXSsoKFwvXCooW14qXSpcKig_IVwvKSkqW14qXSpcKlwvXHMqKSp8ZXJyb3JfcmVwb3J=aW5nXChbXjtdKztccyp8W2Etel8wLTldK1woW147XSs7XHMqfFwkW2Etel8wLTldK1xzKj1bXjtdKztccyp8XC9cL1teXG5dKlxuXHMqKSpmdW5jdGlvblxzKyhbYS16XzAtOV=rKVwoLisoKFwkW2Etel8wLTldKylccyo9W1xAXHNdKmZpbGVfZ2V=X2NvbnRlbnRzXCgoLisoXCRbYS16XzAtOV=rKVxzKj1bXEBcc1=qKGJhc2U2NF9kZWNvZGV8ZmlsZV9nZXRfY29udGVudHMpXChcNikqLitmaWxlX3B1dF9jb25=ZW5=c1woW14sXSssXHMqKFw2fFw4KVteO1=rO1tcfVxzXSp8ZmlsZV8uLnRfY29udGVudHNcKC4rZm9wZW5cKC4rZndyaXRlXCguK2ZjbG9zZVwoKS4rKFw=XChbXjtdKztccyp8dW5saW5rXChfX=ZJTEVfX1wpO1xzKnxlY2hvW147XSo7XHMqZXhpdFtcKFwpO1xzXH1dKikrKCR8XD8-KS9pcyI7fXM6MzM6ImF1dGhfcGFzcyBGaWxlc=1hbiBzYWZlX21vZGUgZXZhbCI7YToyOntpOjA7czo1OiJIOVM2ayI7aToxO3M6NzY6Ii88XD8oPz=uKlwkYXV=aF9wYXNzKSg_PS4qRmlsZXNNYW4pKD89LipzYWZlX21vZGUpKD89LiooZXZhbHxuZXRzdGF=KVwoKS4rL3MiO31zOjEwNToicGhwIGVycm9yX3JlcG9ydGluZyBpbmlfc2V=IHNldF9=aW1lX2xpbWl=IGlmIGlzc2V=IFJFUVVFU1QgZmlsZV9nZXRfY29udGVudHMgZmlsZV9wdXRfY29udGVudHMgdW5saW5rIGllIjthOjI6e2k6MDtzOjU6Ikg5Uzc2IjtpOjE7czo=OTg6Ii88XD9bcGhcc1=rKFwvXCpbXlwqXSooXCpbXlwqXC9dKikrXC9ccyp8XC9cL1teXG5dKlxzKykqKGlnbm9yZV91c2VyX2Fib3J=XHMqXChbXjtdKjtccyp8XCRbYS16XzAtOV=rXHMqPVteO1=qWztcc1=rKSsoKGVsc2VbXHNce1=qfGlmW1xzXChdK1teO1=rfFwkW2Etel8wLTldK1xzKj1ccyopKihlcnJvcl9yZXBvcnRpbmd8aW5pX3NldHx8c2V=X3RpbWVfbGltaXR8d2hpbGUoPz1cKDFcKSkpXHMqXChbXjtdKztbXH1cc1=rKSsoKGlmW1xzXChdKyhpc193cml=YWJsZXxpc3NldHxmaWxlX2V4aXN=cylbXHNcKF=rXCQoX1JFUVVFU1R8X=dFVHxfUE9TVHxwYXRoKVteO1=rKT8oXEA_KGZpbGVfZ2V=X2NvbnRlbnRzfGZpbGVfcHV=X2NvbnRlbnRzfHVubGlua3xjaG1vZClccypcKFteO1=rOyhbXH1cc1=qKGlmW1xzXChdK1teXCldK1wpK3xlbHNlKT9bXHtcc1=qKGRpZXxwcmludHxzbGVlcHxlY2hvKVteO1=qOykqW1x9XHNdKikrW1x9XHNdKyl7Myx9Lio_KCR8XD8-KS9pcyI7fXM6Mzc6InBocCBjcmVhdGVfZnVuY3Rpb24gVmFyaWFibGUgZnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiSDlTN=ciO2k6MTtzOjIzNjoiLzxcP1twaFxzXSooXC9cKihbXlwqXSpcKlteXC9dKSpbXlwqXSpcKlwvXHMqfFwvXC8uKlxzKikqKChcJFthLXpfXC=wLTldKylccyo9Lis7XHMqfGlmXHMqXChbXlx7XStce1xzKikrKChcJFthLXpfXC=wLTldKylccyo9XHMqKT9jcmVhdGVfZnVuY3Rpb25cKFteLF=rLFxzKihcNFteO1=rO1tcc1xAXSpcNlwofCIoXFwoWzAtOV17MiwzfXx4WzAtOWEtZl17Mn=pKSsiKVteXCldKltcKTtcc1x9XSsoJHxcPz4pL2kiO31zOjQyOiJpZiBpc3NldCBSRVFVRVNUIGV2YWwgb3IgZmlsZV9wdXRfY29udGVudHMiO2E6Mjp7aTowO3M6NToiSDlTN=giO2k6MTtzOjM3MToiLzxcP1twaFxzXSsoZnVuY3Rpb24gKFthLXpfMC=5XSspXChbXlx7XStbXHtcc1=rLityZXR1cm5bXjtdKjtbfVxzXSspP2lmW1xzXChdK2lzc2V=W1xzXChdK1wkXyhSRVFVRVN8R=V8UE9TKVQoXHMqXFtbXlxdXStcXSkrW1wpXHNce1=rKFwkW2Etel9cLTAtOV=rXHMqPVxzKi4rPztccyopKigoKGhlYWRlcnx1bmxpbmspXChbXjtdK1s7XHNdKyl7Mix9W1x9XHNdKmVsc2VbXHtcc1=rKFwkW2Etel9cLTAtOV=rXHMqPVxzKi4rPztccyopKigoXCRbYS16X1wtMC=5XStccyo9XHMqKT9cQD8oZXZhbHxcMilcKC4rP1wpO1xzKil7Mix9fGZpbGVfcHV=X2NvbnRlbnRzXChbXixdKyxccypiYXNlNjRfZGVjb2RlXCguKz9cKTspW1x9XHNdKihcPz58JCkvaXMiO31zOjI2OiJwaHAgZWNobyBwYXNzdGhydSBfUkVRVUVTVCI7YToyOntpOjA7czo1OiJIQUtGRCI7aToxO3M6MTU2OiIvPFw_W3BoXHNdKygoZWNob3xwcmludClbXHNcKF=rKFsnIl=pLio_XDNbXClcc1=qO1xzKikqKChcJFthLXpfMC=5XSspXHMqPVxzKik_XEA_KHBhc3N=aHJ1fGV4ZWN8c3lzdGVtfFwkW2Etel8wLTldKylccypcKFwkXyhSRVFVRVN8R=V8UE9TKVQuKztccyooJHxcPz4pL2kiO31zOjU3OiJwaHAgaWYgaXNfZGlyIGZpbGVfZ2V=X2NvbnRlbnRzIGlmIGZpbGVfcHV=X2NvbnRlbnRzIGVjaG8iO2E6Mjp7aTowO3M6NToiSEFLRkwiO2k6MTtzOjM=NToiLzxcP1twaFxzXSsoXC9cL1teXG5dKltcclxuXSt8XCRbYS16XzAtOV=rXHMqPVteO1=qO1xzKnxlcnJvcl9yZXBvcnRpbmdcKFteO1=rO1xzKikrLis_KGluY2x1ZGVbXjtdKndwLWNsYXNzLWhlYWRlcnMucGhwLis_fGlmW1woXHNdK2lzX2RpclteXHtdK1x7KFxzKlwkW2Etel8wLTldK1xzKj1maWxlX3xbXlx9XStcfVxzKilnZXRfKGFsbF9kaXJzXCguKz98Y29udGVudHNcKFteO1=qO1xzKlwkW2Etel8wLTldK1xzKj1bXjtdKjtccyooaWZbXChcc1=rKT8pKWZpbGVfcHV=X2NvbnRlbnRzXCguKz8oKHRvdWNoXCguK3xlY2hvW147XSo7XHMqfFx9KFxzKmVsc2VbXHNce1=rKT8pXHMqKSsoJHxcPz4pL2lzIjt9czozNDoibW92ZV91cGxvYWRlZF9maWxlIF9GSUxFUyBfX=ZJTEVfXyI7YToyOntpOjA7czo1OiJIQUtGTiI7aToxO3M6MjYwOiIvPFw_W3BoXHNdKygoXCRbYS16XzAtOV=rKVxzKj1ccypcJF9GSUxFU1xbW147XSs7XHMqKFwkW2Etel8wLTldKylccyo9W147XSs7XHMqaWZbXHNcKF=rZmlsZV9leGlzdHNbXHNcKCciXC5cL1=rXDNbXHNcKCciXClcc1=rdW5saW5rW1xzXCgnIlwuXC8pXStcMyk_Lio_KG1vdmVfdXBsb2FkZWRfZmlsZVtcc1woXSsoXCRfRklMRVNcW1teLF=rWyxcc1=rX19GSUxFX198XDIpfHN5c3RlbVwoWyciXW12IFsnIl1cLlwkX=ZJTEVTXFspLio_KCR8XD8-KS9pcyI7fXM6Njg6InBocCBmdW5jdGlvbiBkaWUgc2V=Y29va2llIGlmIGVtcHR5IGlmIGlzc2V=IGZvcm=gbW92ZV91cGxvYWRlZF9maWxlIjthOjI6e2k6MDtzOjU6IkhBS=ZQIjtpOjE7czo2MDE6Ii88XD9bcGhcc1=rKChcJFthLXpfMC=5XSspXHMqPVteO1=rO1xzKikqKGlmW1woXHNdKyhcMnxcIWVtcHR5W1woXHNdKylbXlx7XStce1xzKigoKChcJFthLXpfMC=5XSspXHMqPVxzKik_KFwyXCguKj9cKSt8XCRfKFJFUVVFU3xHRXxQT1MpVFteO1=rKTtccyp8aWZbXChcc1whXSsoaXNzZXRbXChcc1=rLis_XCkrXHMrW2Etel8wLTldK3xcOFteXH1dKikpKStbXH1cc1=qfGZ1bmN=aW9uIFthLXpfMC=5XStcKFteXHtdK1x7XHMqKGRpZVwoLis_XCk7XHMqfChcJF9DT=9LSUUuKz87XHMqfHNldGNvb2tpZVwoLis_XCk7XHMqKXsyfSlcfVxzKikrKFtcc1x7XSooXCRbYS16XzAtOV=rKVxzKj1ccypcJF8oUkVRVUVTVHxHRVR8UE9TVHxGSUxFKVteO1=rO1tcc1x9XSopKihcPz5ccyp8ZWNob1tcc1woXSooWyciXSkpKDwoZm9ybXxpbnB1dClbXj5dKj5bYS16XDowLTlcc1=qKSs8XC9mb3JtPihccyo8XD9bcGhcc1=rfFsnIl=7XHMqKShcJFthLXpfMC=5XStccyo9W147XSs7XHMqfGlmW1xzXChdKykqKG1vdmVfdXBsb2FkZWRfZmlsZVwoW15cO1=rfChcJFthLXpfMC=5XSspXHMqPVxzKlwkW2Etel8wLTldK1xzKlwoLio_XCkpO1tcc1x9XSooJHxcPz4pL2kiO31zOjExMDoicGhwIGlmIFJFUVVFU1QgYWRkX2FjdGlvbiBmdW5jdGlvbiBnbG9iYWwgaWYgZ2V=X29wdGlvbiByZXR1cm4gb2Jfc3RhcnQgd3BfcmV3cml=ZS=-Zmx1c2hfcnVsZXMgd3BfY2FjaGVfZmx1c2giO2E6Mjp7aTowO3M6NToiSzc4SDYiO2k6MTtzOjQ2NDoiLzxcP1twaFxzXSsoaWZccypcKFteXCldKlwkXyhQT1N8UkVRVUVTfEdFKVRbXlx7XStbXHtcc1=rfGFkZF9hY3Rpb25ccypcKFteLF=rLFxzKihbJyJdKShbYS16XzAtOV=rKVsnIlwpO1xzXH1dK3xmdW5jdGlvblxzK1w=W15ce1=rW1x7XHNdKykqKCgoaW5jbHVkZXxyZXF1aXJlKShfb25jZSk_XChbXjtdKztccyp8aWZbXHNcKFwhXSt1c2VybmFtZV9leGlzdHNcKFteXHtdK1tce1xzXSspKihcJFthLXpfMC=5XSspXHMqPVxzKndwX2NyZWF=ZV91c2VyXCguK3NldF9yb2xlW1woXHMnIl=rYWRtaW5pc3RyYXRvcnwoZ2xvYmFsW147XSo7XHMqKT9pZltcc1woXCFdK2dldF9vcHRpb25cKFteXCldK1tcKVxzXHtdK3JldHVyblteO1=qO1tcc1x9XStvYl9zdGFydFwoXCk7XHMqXD8-LitcJHdwX3Jld3JpdGUtPmZsdXNoX3J1bGVzXChcKTtccyp3cF9jYWNoZV9mbHVzaFwoKStbIidcc1wpO1xzXH1dKygkfFw_PikvaXMiO31zOjQyOiJpZiBpc3NldCBSRVFVRVNUIEZJTEUgc3RyaXBzbGFzaGVzIFJFUVVFU1QiO2E6Mjp7aTowO3M6NToiSEFLRlMiO2k6MTtzOjI4MjoiL2lmW1xzXChdK2lzc2V=W1xzXChdK1wkXyhHRXxQT1N8UkVRVUVTKVQoXHMqXFtbXlxdXSpcXSt8XHMqXHtbXlx9XSpcfSspK1tcc1wpXHtdKygoXCRbYS16XzAtOV=rKVxzKj1ccypcJF8oR=V8UE9TfFJFUVVFUylUKFxzKlxbW15cXV=qXF=rfFxzKlx7W15cfV=qXH=rKStbXjtdKls7XHNdKikqKGFzc2VydHxldmFsfFwkW2Etel8wLTldKylccypcKCtzdHJpcHNsYXNoZXNcKFwkXyhHRXxQT1N8UkVRVUVTKVQoXHMqXFtbXlxdXSpcXSt8XHMqXHtbXlx9XSpcfSspK1tcc1wpXSs7W1x9XHNdKi9pIjt9czoxNDA6ImVycm9yX3JlcG9ydGluZyBmdW5jdGlvbiBlcnJvcl8=MDQgdHRwX3JlcXVlc3RfY3VzdG9tIGdldElwIGdldFVzZXJhZ2VudCBjb252ZXJ=SXBUb1N=cmluZyBodHRwX2J1aWxkX3F1ZXJ5IGZpbGVfZ2V=X2NvbnRlbnRzIGZ3cml=ZSBsb25nMmlwIjthOjI6e2k6MDtzOjU6IkhBS=ZVIjtpOjE7czoyMTI6Ii88XD8uKz9lcnJvcl9yZXBvcnRpbmdcKCg_PS4rP2dldFtfXSpJcFwoKSg_PS4rP2Z1bmN=aW9uIGVycm9yXzQwNFwoKSgoPz=uKz9zdHJlYW1fY29udGV4dF9jcmVhdGVcKCl8KD89Lis_cmVxdWVzdF9jdXN=b21cKCkpKD89Lis_aHR=cF9idWlsZF9xdWVyeVwoKSg_PS4rP2ZpbGVfZ2V=X2NvbnRlbnRzXCgpKD89Lis_aGVhZGVyXCgpKD89Lis_bG9uZzJpcFwoKS4rL2lzIjt9czozNToiaWYgaXNzZXQgUkVRVUVTVCBmb3JlYWNoIGFycmF5IGV2YWwiO2E6Mjp7aTowO3M6NToiSEFLRlYiO2k6MTtzOjE1OToiL2lmW1xzXChdKyhbYS16XzAtOV=rXHMqXChccyopKlwkXyhSRVFVRVN8R=V8UE9TKVRcW1teXHtdK1x7XHMqKFwkW2Etel8wLTldK1xzKj1bXjtdKztccyp8Lio_Zm9yZWFjaFwoYXJyYXkuKj8pKltcc1xAXSooc3lzdGVtfGV2YWwpXCguK1xzKihleGl=W147XSo7XHMqKSpcfS9pIjt9czo3MjoiaWYgZW1wdHkgU=VSVkVSIEhUVFBfVVNFUl9BR=VOVCBzZXRfdGltZV9saW1pdCBtb3ZlX3VwbG9hZGVkX2ZpbGUgcmV=dXJuIjthOjI6e2k6MDtzOjU6IklCQ=lhIjtpOjE7czo=MzI6Ii8oPFw_W3BoXHNdKyhpZltcc1woXCFdKyhmaWxlX2V4aXN=c1xzKlwofGlzc2V=W1xzXChdK1wkXyhSRVFVRVN8R=V8UE9TKVRcW1teXF1dK1xdKVteXHtdK1x7W15cfV=rW1xzXH1dKykrXD8-XHMqfDxbXlw_XVtePl=qPlxzKikqPFw_W3BoXSpccyooKHByaW5=fGVjaG8pW147XSo7XHMqfFwvXCpbXlwqXSooXCpbXlwqXC9dKikrXC9ccyopKmlmW1xzXChcIV=rKFxAP2lzX3VwbG9hZGVkX2ZpbGV8ZW1wdHlcKFwkX1NFUlZFUlxbWyInXUhUVFBfVVNFUl9BR=VOVFsiJ11cXVtcKVxzXSsoLis_KXNldF9=aW1lX2xpbWl=KS4rP21vdmVfdXBsb2FkZWRfZmlsZS4rKHJldHVybiBcJFthLXpfMC=5XSt8ZWNob1tcKFxzJyJdK1teO1=rfHRvdWNoXHMqKFwvXCouKj9cKlwvXHMqKSpcKFteO1=rKTtbXHNcfV=rKCR8XD8-KFxzKjxcLyhib2R5fGh=bWwpPikqKS9pcyI7fXM6Nzc6ImZ3cml=ZSB1bmxpbmsgZXZhbCBjaG1vZCBQT1NUIHBocGluZm8gbW92ZV91cGxvYWRlZF9maWxlIGV4ZWMgc3lzdGVtIHBhc3N=aHJ1IjthOjI6e2k6MDtzOjU6IkhBVjhxIjtpOjE7czoxNTM6Ii88XD8uKz9lcnJvcl9yZXBvcnRpbmdcKDBcKS4rP2Z3cml=ZVwoLis_dW5saW5rXCguKz9ldmFsXCguKz9jaG1vZFwoXCRfUE9TVFxbLis_cGhwaW5mb1woLis_bW92ZV91cGxvYWRlZF9maWxlXCgoLis_KGV4ZWNcKHxzeXN=ZW1cKHxwYXNzdGhydVwoKSl7M3=uKy9pcyI7fXM6NDU6ImlmIGZ1bmN=aW9uX2V4aXN=cyBmdW5jdGlvbiB2YXJpYWJsZSBmdW5jdGlvbiI7YToyOntpOjA7czo1OiJLQjM5ayI7aToxO3M6NDYzOiIvKFwvXCpbXlwqXSooXCpbXlwqXC9dKikrXC9ccyopKihcJFthLXpfMC=5XSsoXHMqXFtbXlxdXStcXSspKltcLlxzXSo9XHMqKChbJyJdKS4qP1w2KT9bXjtdKjtccyopKygoaWZbXChcc1whXStmdW5jdGlvbl9leGlzdHNbXChcc1=rWyciXVteXHtdK1x7XHMqKT9mdW5jdGlvblxzKihbXCRhLXpfMC=5XSspXHMqXCguKz9yZXR1cm4uKj87W1xzXH1dKykoKFwkW2Etel8wLTldKylccyo9XHMqKGNyZWF=ZV9mdW5jdGlvblxzKlwoW14sXSssXHMqfFw5XChccyopKFtcJGEtel8wLTldK3woWyciXSkpW147XSpbOyciXClcfVxzXSspKyhccyooXCRbYS16XzAtOV=rXHMqPVxzKik_XCRbYS16XzAtOV=rXChbXjtdK1siJ1wpO1x9XHNdKykrKChpZltcKFxzXCFdK2Z1bmN=aW9uX2V4aXN=c1tcKFxzXStbJyJdW15ce1=rXHtccyopP2Z1bmN=aW9uXHMqKFwxMXxcMTMpXHMqXCguKj9yZXR1cm4uKj87W1xzXH1dKyk_L2lzIjt9czo2OToicmVxdWlyZV9vbmNlIHdwLWNvbmZpZyBpbmlfc2V=IG15c3FsX3F1ZXJ5IFVQREFURSB1c2VycyBTRVQgdXNlcl9wYXNzIjthOjI6e2k6MDtzOjU6IkhBVjh1IjtpOjE7czoxOTE6Ii9eLio8XD9bcGhcc1=qKGluY2x1ZGV8cmVxdWlyZSkoX29uY2UpP1woLit3cC1jb25maWdcLnBocFsiJ1xzXCk7XSsoXEA_aW5pX3NldFwoW15cKV=rW1wpO1xzXSspKy4rPyhteXNxbF9xdWVyeVwoWyciXVVQREFURVtcc1x7JyIuXStcJHRhYmxlX3ByZWZpeFtcc1x9JyIuXSt1c2Vyc1xzK1NFVFxzK3VzZXJfcGFzcy4rKXsyLH=kL2lzIjt9czozNjoiaWYgcmVuYW1lIG9yIGZpbGVfcHV=X2NvbnRlbnRzIHRvdWNoIjthOjI6e2k6MDtzOjU6Iko1UzhKIjtpOjE7czoyMDQ6Ii88XD9bcGhcc1=raWZbXHNcKF=raXNzZXRbXHNcKF=rXCRfKFJFUVVFU3xHRXxQT1MpVChccypcW1teXF1dK1xdKStbXClcc1x7XStbXjtdKztccypbXlx9XSpcfVtcfVxzXSooXCRbYS16XzAtOV=rKVtccypcLj1dK2Jhc2U2NF9kZWNvZGVcKC4rP2ZpbGVfcHV=X2NvbnRlbnRzXCgoW14sXSspLFxzKlwzLis_dW5saW5rXCguKz9cKFw=W1wpO1xzXSsuKy9pcyI7fXM6MTg6ImV2YWwgUkVRVUVTVCBhbG9uZSI7YToyOntpOjA7czo1OiJKQVFMTyI7aToxO3M6MTczOiIvPFw_W3BoXHNdKygoXCRbYS16XzAtOV=rKVxzKj1bXjtdKztccyopP1xAPyhldmFsfHN5c3RlbXxlY2hvXHMrYmFzZTY=X2RlY29kZSkoW1woXHMqXEBdK3N=cmlwc2xhc2hlcyk_W1woXHMqXEBdKyhcMnxcJF8oUkVRVUVTfEdFfFBPUylUXHMqKFxbW15cXV=rXF1ccyopKylbXCk7XHNdKygkfFw_PikvaSI7fXM6MjM6IkZpbGVzTWFuIHByZWdfcmVwbGFjZSAuIjthOjI6e2k6MDtzOjU6IkhCNjdZIjtpOjE7czoyNDI6Ii88XD9bcGhcc1=qKFwvXCouKz9cKlwvXHMqKSooXCRbYS16XzAtOV=rXHMqPVteO1=rO1xzKikqXCRbYS16XzAtOV=rXHMqPVtccyInXSpGWyInXC5cc1=qaVsiJ1wuXHNdKmxbIidcLlxzXSplWyInXC5cc1=qc1siJ1wuXHNdKk1bIidcLlxzXSphWyInXC5cc1=qblsiJ1xzXSo7KFxzKlwkW2Etel8wLTldK1xzKj1bXjtdKzspKlxzKihcJFthLXpfMC=5XSt8cHJlZ19yZXBsYWNlKVwoW15cKV=qW1wpO1xzXSsoJHxcPz4pL2lzIjt9czozMzoiaHRtbCBoZWFkIHVuemlwIEZJTEVTIHVubGluayBmb3JtIjthOjI6e2k6MDtzOjU6IkhCVUZDIjtpOjE7czoyMzA6Ii9ePGh=bWw-XHMqPGhlYWQ-Lis_KGZpbGVwZXJtc1xzKlwoLis_KHBvc2l4X2dldFtwd3Vncl=raWRccypcKC4rPyl7Mix9bW92ZV91cGxvYWRlZF9maWxlXHMqXCguKz9mcHV=c1xzKlwoLis_dW5saW5rXHMqXCguKz9leGVjXHMqXCguKz9ccypyZWFkZGlyXCguKz9cP3x1bnppcFwoXCRfRklMRVNcWy4rP3VubGlua1woXCQuK1w_PlxzKjxcL2Zvcm=pPlxzKjxcL2JvZHk-XHMqPFwvaHRtbD5ccyokL2lzIjt9czo2NToiaWYgYXJyYXlfa2V5cyBHRVQgZmlsZV9nZXRfY29udGVudHMgaWYgdW5saW5rIGZvcGVuIGZ3cml=ZSBmY2xvc2UiO2E6Mjp7aTowO3M6NToiSTFIR3QiO2k6MTtzOjM4NzoiLzxcP1twaFxzXSsoXC9cL1teXG5dKlxuXHMqfFwvXCpbXlwqXSooXCpbXlwqXC9dKikrXC9ccyp8XEA_KGlnbm9yZV91c2VyX2Fib3J=fGluaV9zZXR8c2V=X3RpbWVfbGltaXR8ZXJyb3JfcmVwb3J=aW5nKVwoLio_XCk7XHMqfFwkW2Etel8wLTldK1xzKj1bXjtdKztccyopKigoKGlmXHMqXCh8ZWxzZSlbXlx7XSpce1xzKik_ZnVuY3Rpb25ccysuKz9yZXR1cm5bXjtdKjtbXHNcfV=rKSsoKFwkW2Etel8wLTldK1xzKj1ccyopP1wkW2Etel8wLTldK1woW147XStbIidcKTtcfVxzXSopKy4rPyhmKG9wZW58d3JpdGV8Y2xvc2UpXCguKz8pezMsfWluY2x1ZGVcKC4qP1wpO1xzKnVubGlua1woLio_XCk7XHMqKFwkW2Etel8wLTldK1xzKj1bXjtdKztbXH1cc1=qKSooJHxcPz4pL2lzIjt9czo3NjoiZGlzcGxheV9lcnJvcnMgZmlsZV9nZXRfY29udGVudHMgX1JFUVVFU1QgZmlsZW5hbWUgdXBkYXRlX2NvZGUgZndyaXRlIHVubGluayI7YToyOntpOjA7czo1OiJIQlVGRyI7aToxO3M6MTU3OiIvXi4rPyhlcnJvcl9yZXBvcnRpbmdcKDBcKXxkaXNwbGF5X2Vycm9ycykuKz8oZmlsZV9nZXRfY29udGVudHNcKFteO1=qfHVybGRlY29kZVwoKVwkXyhQT1N8R=V8UkVRVUVTKVRcW1siJ11mW2lsZV=qbmFtZVtzXT9bIiddXF=uKz9md3JpdGVcKC4rP3VubGlua1woLiskL2lzIjt9czo1NToicGhwIFZhcnMgQXJyYXkgYmFzZTY=X2RlY29kZSBmdW5jdGlvbiBWYXJpYWJsZSBGdW5jdGlvbiI7YToyOntpOjA7czo1OiJIQlVGSSI7aToxO3M6Mjc1OiIvKFwkW2Etel8wLTldK1xzKj1bXjtdK1s7XHNdKykqKFwkW1wkXHtdKlthLXpfMC=5XStcfSooXHMqXFtbXlxdXStcXXxccypce1teXH1dK1x9KSopXHMqPVxzKmFycmF5W1woXHNdK2Jhc2U2NF9kZWNvZGVcKC4rP2Z1bmN=aW9uIChbYS16XzAtOV=rKVxzKlwoLis_XDJccyooXFtbXlxdXStcXVxzKikqXCguKyhcJFtcJFx7XSpbYS16XzAtOV=rXH=qKFxzKlxbW15cXV=rXF18XHMqXHtbXlx9XStcfSkqKVxzKj1cNFwoLis_KGVjaG98ZGllfHByaW5=KVtcc1woXSpcNlteO1=qOy9pcyI7fXM6NTM6ImV4ZWMgc3lzdGVtIHBhc3N=aHJ1IGZ3cml=ZSBWYXJpYWJsZSBGdW5jdGlvbiBSRVFVRVNUIjthOjI6e2k6MDtzOjU6Ikk1VEJaIjtpOjE7czoyNjM6Ii88XD8oPz=uKnBhc3N=aHJ1XCh8LipleGVjXCh8LipzeXN=ZW1cKCkuKj8oKChcJFthLXpfMC=5XSspXHMqPVxzKihbYS16XzAtOV=rXChccyopKlwkXyhSRVFVRVNUfEdFVHxQT1NUfFNFUlZFUnxDT=9LSUUpXFtbXjtdKztbXHNcfV=qKGVsc2Vccypce1teXH1dK1x9W1xzXH1dKik_KSsuKig_PCFuZXcgKVwkW2Etel8wLTldKyg_IVwoIFwka2V5IFwpIFwpOylcKFtccyJdKlwzfFwkW2Etel8wLTldK1woXCRfKFJFUVVFU3xHRXxQT1MpVCkuKz8oJHxcPz4pL2lzIjt9czo2NjoicGhwIGlmIGZ1bmN=aW9uX2V4aXN=cyBmaWxlX3B1dF9jb25=ZW5=cyBmb3BlbiBjaG1vZCBzeXN=ZW=gdW5saW5rIjthOjI6e2k6MDtzOjU6Ikk=RUt2IjtpOjE7czoxNjY6Ii88XD8oLis_KHRvdWNofGhlYWRlcilcKCkuKz9pZltcc1woXCFdK2Z1bmN=aW9uX2V4aXN=c1woW1xzJyJdKyhmaWxlX3B1dF9jb25=ZW5=cylbIidcc1wpXHtdK2Z1bmN=aW9uXHMrXDNcKC4rP2ZvcGVuXCguKz9cM1woLis_Y2htb2RcKC4rP3N5c3RlbVwoLisodW5saW5rfGV4aXQpLisvaXMiO31zOjcyOiJiYXNlNjRfZGVjb2RlIGZpbGVfcHV=X2NvbnRlbnRzIGNobW9kIHRvdWNoIGZzb2Nrb3BlbiBjdXJsX2V4ZWMgb2Jfc3RhcnQiO2E6Mjp7aTowO3M6NToiSEMzOGwiO2k6MTtzOjE5NToiL1wvXC9ccyppc3RhcnQuKz8oXCRbYS16XzAtOV=rKVtccypcLj1dK2Jhc2U2NF9kZWNvZGVcKC4rP2ZpbGVfcHV=X2NvbnRlbnRzXChbXixdKyxccypcMS4rP2NobW9kXCguKz9=b3VjaFwoLis_KGZzb2Nrb3BlblwoLis_ZmdldHNcKHxjdXJsX2luaXRcKC4rP2N1cmxfZXhlY1woKS4rP29iX3N=YXJ=XCguKz9cL1wvaWVuZFteXG5cP1=qL2lzIjt9czoyMToiaWYgaXNzZXQgUkVRVUVTVCBldmFsIjthOjI6e2k6MDtzOjU6Ikk4SUdSIjtpOjE7czo=MDI6Ii88XD9bcGhcc1=rKChcJFthLXpfMC=5XStccyo9W147XSs7XHMqKSooaWZbXHNcKF=raXNzZXR8Zm9yKGVhY2gpPylbXChcc1=rXCRfKFJFUVVFU3xHRXxQT1MpVFteXCldK1wpW1wpXHNce1=rKFwkW2Etel8wLTldK1tcLj1cc1=rXCRfKFJFUVVFU3xHRXxQT1MpVFxbW15cXV=rXF1bO1xzXSt8aWZccypcKFteO1=rO1tcc1x9XSpmdW5jdGlvblxzK1thLXpfMC=5XStcKC4rcmV=dXJuW147XSo7W1x9XHNdKihcJFthLXpfMC=5XStccyo9W147XSs7XHMqKSopKygoXCRbYS16XzAtOV=rWz1cc1=rKT9cQD8oZXZhbHxmaWxlX3B1dF9jb25=ZW5=c3xmb3Blbnxmd3JpdGV8ZmNsb3NlKVwoW15cKV=rXCk7XHMqKSsoKGVjaG98ZXhpdClbXlw7XSo7XHMqKSpbXH1cc1=qKGVsc2VbXHNce1=qKT8pKygkfFw_PikvaSI7fXM6ODE6ImVycm9yX3JlcG9ydGluZyBldmFsIGN1cmxfaW5pdCBmaWxlX2dldF9jb25=ZW5=cyBmaWxlX3B1dF9jb25=ZW5=cyBpbmNsdWRlIHVubGluayI7YToyOntpOjA7czo1OiJIQ=M5eCI7aToxO3M6MTk4OiIvXCRbYS16XzAtOV=rWz1cc1=rX19GSUxFX187XHMqXCRbYS16XzAtOV=rXHMqPVteO117MjAwMH=uKj9lcnJvcl9yZXBvcnRpbmdcKC4rP2V2YWxcKC4rPyhjdXJsX2luaXR8ZmlsZV9nZXRfY29udGVudHMpLis_ZmlsZV9wdXRfY29udGVudHNcKC4rP2luY2x1ZGUuKj91bmxpbmtcKC4qP1wpO1xzKlx9XHMqZWxzZVxzKlx7W15cfV=rW1x9XSsvaXMiO31zOjQwOiJzZXRfZXJyb3JfaGFuZGxlciBldmFsIGZpbGVfZ2V=X2NvbnRlbnRzIjthOjI6e2k6MDtzOjU6Ikk4Tkl1IjtpOjE7czoyMDU6Ii8oKGVycm9yX3JlcG9ydGluZ3xzZXRfZXJyb3JfaGFuZGxlcnxpbmlfc2V=KVxzKlwoW147XSo7XHMqKSooZWNob1tcc1woXStcQD9maWxlX2dldF9jb25=ZW5=c1tcKFxzXSsoY2hyXChbMC=5XStbXHNcKVwuXSspK3xldmFsXChbXlwpXSo_KFwkcmVxdWVzdHxzdHJyZXZcKClbXlwpXSo_XEA_ZmlsZV9nZXRfY29udGVudHNcKCdbXiddKydbXHNcKV=rKTsvaXMiO31zOjIzOiJpZiBmb3IgdW5zZXQgd3Bfd3AgZm9ybSI7YToyOntpOjA7czo1OiJIQ=VEWCI7aToxO3M6MjA2OiIvPFw_W3BoXHNdKihcJChbYS16XzAtOV=rKVxzKj1bXjtdKztccyopKihcJCgoKGx8d3ApW19dKil7Mn=pXHMqPVteO1=rO1xzKikrKGlmfGZvcnx1bnNldHwoXCRbYS16XzAtOV=rXHMqPVxzKik_XCQoXDJ8XDQpKVxzKlwoXCQoXDJ8XDQpW147XSs7XHMqLio_XD8-XHMqPGZvcm=uKz9uYW1lPVsnIl=oKChsfHdwKVtfXSopezJ9KVsnIl=uKz88XC9mb3JtPi9pcyI7fXM6MTc6InBocCBjbGFzcyB2aWFXb3JtIjthOjI6e2k6MDtzOjU6IkhDRURaIjtpOjE7czoyNTI6Ii88XD9bcGhcc1=rKFwvXCouKj9cKlwvXHMqKSooY2xhc3MgdmlhV29ybVxzKlx7Lis_ZndyaXRlXCguKz9maWxlX2dldF9jb25=ZW5=c1woLis_dW5saW5rXCguKz9iYXNlNjRfZW5jb2RlXCguKz8pP2ZpbGVfcHV=X2NvbnRlbnRzXChbXixdKyxccypiYXNlNjRfZGVjb2RlXCgoXEA_ZmlsZV9nZXRfY29udGVudHNcKC4rfFteXCldK1tcKTtcc1=rZWNob1tcc1woXStmaWxlX2dldF9jb25=ZW5=c1woW15cKV=rW1wpO1xzXSsoJHxcPz4pKS9pcyI7fXM6Mjg6ImFzc2VydCBIZXggNjRlbmNvZGVkVGV4dCBIZXgiO2E6Mjp7aTowO3M6NToiSENFRGIiO2k6MTtzOjI5NDoiLyhhc3NlcnRfb3B=aW9uc1woLis_XCk7XHMqfGZ1bmN=aW9uIFthLXpfMC=5XStcKFteXCldKltcKVxzXHtdKy4rP3JldHVyblteO1=qWztcfVxzXSt8XCQoY29sb3J8YXV=aHxwYXNzfGRlZmF1bHR8X18pW19cLVw-XC5hLXowLTldKlxzKj=uKz87XHMqKSooKChcJFthLXpfMC=5XSspXHMqPS4qP1wkXDJ8KFwkW2Etel8wLTldKylccyo9Lio_XDUpLipccyopKmFzc2VydFwoXHMqKCIoXFx4WzAtOUEtRl1bMC=5QS1GXSkrJ1tcL2EtelxfMC=5XD1dKycoXFx4WzAtOUEtRl1bMC=5QS1GXSkrInxcNilbXClcc1=rOy9pIjt9czoyOToicG9zdCBzdHJ=b3VwcGVyIGlmIGlzc2V=IGV2YWwiO2E6Mjp7aTowO3M6NToiSENUOUYiO2k6MTtzOjE4NzoiLygoXCRbYS16XzAtOV=rKVxzKj1bXjtdKztccyopKyhcJFthLXpfMC=5XStccyo9XHMqKFwkW2Etel8wLTldK3xzdHJ=by4uLmVyKVxzKlwoKFtcc1wuXSpcJFthLXpfMC=5XStccypcW1xkK1xdKStbXCk7XHNdKykraWZbXChcc1=raXNzZXRccypcKFteXCldK1tcKVxzXStce1xzKmV2YWxccypcKFteXCldK1tcKTtcc1=rXH=vaSI7fXM6NDk6ImZ1bmN=aW9uIGd6aW5mbGF=ZSBiYXNlNjRfZGVjb2RlIGZvciBjaHIgb3JkIGV2YWwiO2E6Mjp7aTowO3M6NToiSTM1RUsiO2k6MTtzOjI=OToiLyhmdW5jdGlvblxzKyhbYS16XzAtOV=rKVxzKlwoXHMqKFwkW2Etel8wLTldKylbXClcc1x7XStcM1s9XHNdK2d6aW5mbGF=ZVwoYmFzZTY=X2RlY29kZVwoLitbXCk7XHNdKyk_Zm9yXHMqXCgoW15ce1=rfC4rPylce1xzKihcJFthLXpfMC=5XSspKFxzKlxbW15cXV=rXF=rKSpbXC5cc1=qPVtcQFxzXSpjaHJcKFteO1=rWztcc1x9XSsocmV=dXJuW147XSpbO1x9XHNdKyk_ZXZhbFwoKFwyXCh8XDN8XDUpW15cKV=qXClbXCk7XHNdKy9pIjt9czo4NzoiaW5pX3NldCBvYl9zdGFydCByZWdpc3Rlcl9zaHV=ZG93bl9mdW5jdGlvbiBpZiBIVFRQX1VTRVJfQUdFTlQgZmlsZV9nZXRfY29udGVudHMgcmV=dXJuIjthOjI6e2k6MDtzOjU6IkkxNDl2IjtpOjE7czoyNzY6Ii9cQD9pbmlfc2V=XCguK1xzKyhcQD9vYl9zdGFydFwoWyInXSguKz8pWyciXVwpO1xzK1xAP3JlZ2lzdGVyX3NodXRkb3duX2Z1bmN=aW9uXCguK1xzKyhmdW5jdGlvblxzK1wyXChcJFthLXpfMC=5XStbXClcc1x7XStpZi4rP=hUVFBfVVNFUl9BR=VOVC4rW1wpXHNce1=rLis_ZmlsZV9nZXRfY29udGVudHMuK1xzKnJldHVyblteO1=qO1tcc1x9XSspP3woXCRbYS16XzAtOV=rKVxzKj1ccypiYXNlNjRfZGVjb2RlXCguK1xzKmVjaG8uKz9maWxlX2dldF9jb25=ZW5=c1woXDQuKykvaSI7fXM6Mjk6ImlmIGlzc2V=IFJFUVVFU1QgZXZhbCBSRVFVRVNUIjthOjI6e2k6MDtzOjU6IkkxNDl3IjtpOjE7czoxNTI6Ii9pZltcc1woXSsoaXNzZXR8ZW1wdHkpW1xzXChdK1wkXyhSRVFVRVN8R=V8UE9TKVRbXlx7XStbXHtcc1=rLipldmFsW1xzXChdK1tcJGEtel8wLTldK1teXCldKlwpKyguKyhkaWV8ZXhpdHxlY2hvfHByaW5=fHJldHVybilbXjtdKjspKltcc1x9O1=qKCR8XD8-KS9pIjt9czozODoiaWYgQ=9PS=lFIGd6aW5mbGF=ZSBiYXNlNjRfZGVjb2RlIGV2YWwiO2E6Mjp7aTowO3M6NToiSTE=OXgiO2k6MTtzOjI=NzoiL2lmXHMqXCguKz9cKFwkX=NPT=tJRS4rP1tce1xzXSooXCRbYS16XzAtOV=rKVxzKj=uKj9iYXNlNjRfZGVjb2RlXCgoLis_ZXZhbFwoXDFcKS4rfFteO1=rWztcc1=rKFwkW2Etel8wLTldKylccyo9W147XStbO1xzXSsoZmlsZV9wdXRfY29udGVudHNcKFwzLis_XDFbXjtdK1s7XHNdK3xlY2hvW1woXHNdK1snIl1cXHguKz9bJyJdW1wpO1xzXSsoaW5jbHVkZXx1bmxpbmspW1woXHNdK1wzW1wpO1xzXSspezMsfS4rKVtcc1x9XSovaSI7fXM6NTI6ImF1dGhfcGFzcyBjb3B5IEZJTEVTIGV4ZWMgcGFzc3RocnUgc3lzdGVtIHNoZWxsX2V4ZWMiO2E6Mjp7aTowO3M6NToiSTE=QTAiO2k6MTtzOjEyMToiLzxcPyg_PS4qXCQobWQ1fGF1dGgpX3Bhc3Nccyo9KSg_PS4qY29weVwoXCRfKFBPU1R8RklMRVMpXFspKD89LipleGVjXCgpKD89LipwYXNzdGhydSkoPz=uKnN5c3RlbSkoPz=uKnNoZWxsX2V4ZWNcKCkuKy9pcyI7fXM6MTMxOiJpbmlfc2V=IGVycm9yX3JlcG9ydGluZyBpZiBmdW5jdGlvbl9leGlzdHMgZnVuY3Rpb24gZWNobyByZXR1cm4gZmlsZV9nZXRfY29udGVudHMgZmlsZV9wdXRfY29udGVudHMgc2V=Y29va2llIGFkZF9hY3Rpb24gYWRkX2ZpbHRlciI7YToyOntpOjA7czo1OiJJNEVMdiI7aToxO3M6MzgzOiIvKFwvXCooW14qXSpcKig_IVwvKSkqW14qXSpcKlwvXHMqfFwkW2Etel8wLTldK1xzKj1bXjtdKztccyp8KGluaV9zZXR8ZXJyb3JfcmVwb3J=aW5nfHNldF9=aW1lX2xpbWl=KVwoW15cKV=qXCk7XHMqKSsoKGlmW1xzXChcIV=rZnVuY3Rpb25fZXhpc3RzW1woXHNdKyhbIiddKSguKz8pXDZbXClcc1=rXHtccyopP2Z1bmN=aW9uXHMrKFthLXpfMC=5XSspXHMqXChbXlwpXSpcKVtcKVxzXHtdKy4rPyhlY2hvfHJldHVybilbXjtdKjtbXH1cc1=rKSsoLis_KGZpbGVfLi5=X2NvbnRlbnRzfGV=Y29va2llKVwoKS4rP2ZpbGVfLi5=X2NvbnRlbnRzXCguKyhhZGRfKGFjdGlvbnxmaWx=ZXIpXChbXixdKyxccypbJyJdKFw3fFw4KVsnIl1bXHNcKV=rO1tcfVxzXSopezIsfS9pcyI7fXM6MzU6ImlmIGlzc2V=IGJhc2U2NF9kZWNvZGUgUkVRVUVTVCBldmFsIjthOjI6e2k6MDtzOjU6IkkxOEhSIjtpOjE7czozMDg6Ii88XD9bcGhcc1=rKChcQD8oaWdub3JlX3VzZXJfYWJvcnR8c2V=X3RpbWVfbGltaXQpXCh8XCRbYS16XzAtOVwuXStccyo9KVteO1=rWztcc1=rKSppZltcKFxzXCFdKyhpc3NldHxlbXB=eSlbXChcc1=rXCRfKFJFUVVFU3xHRXxQT1MpVFxbLitbXHNce1=rKFwkW2Etel8wLTlcLl=rKVxzKj1ccyooYmFzZTY=X2RlY29kZXxcJFthLXpfMC=5XSspXHMqXCgrXHMqXCRfKFJFUVVFU3xHRXxQT1MpVFxbW15cXV=rXF1bXCk7XHNdK1xAP2V2YWxcKFw2XCk7XHMqXH=oXHMqZWxzZVtcc1x7XStlY2hvICJbXiJdKlsiO1xzXH1dKyk_KCR8XD8-KS9pIjt9czozOToiYmFzZTY=X2RlY29kZSBmdW5jdGlvbiBjdXJsIHJldHVybiBleGl=IjthOjI6e2k6MDtzOjU6IkkxOThaIjtpOjE7czoxOTU6Ii88XD9bcGhcc1=qKFwvXCouKz9cKlwvXHMqKSooXCRbYS16XzAtOV=rXHMqPVxzKmJhc2U2NF9kZWNvZGVcKFteO1=rW1wpO1xzXSopK2Z1bmN=aW9uXHMrKFthLXpfMC=5XSspXHMqXChbXlx7XStbXHtcc1=rKChcJFthLXpfMC=5XStbXHMqPV=rKT9jdXJsX1teO1=rO1xzKikrcmV=dXJuIC4rXDNcKC4rZXhpdDtbXH1cc1=rKCR8XD8-KS9pcyI7fXM6ODE6InBocCBiYXNlNjRfZGVjb2RlIGZpbGVfcHV=X2NvbnRlbnRzIHVubGluayBmdW5jdGlvbl9leGlzdHMgSGV4IGNhbGxfdXNlcl9mdW5jIEhleCI7YToyOntpOjA7czo1OiJJMTk5NiI7aToxO3M6MzU2OiIvPFw_W3BoXHNdKyhcJFx7W15cfV=rW1x9XHNdKyhcW1teXF1dK1tcXVxzXH1dKykqPVteO1=rWztcc1=rKFxAPyhcJFthLXpfMC=5XStccyo9fGRlZmluZVwofHNlc3Npb25fc3RhcnRcKHxlcnJvcl9yZXBvcnRpbmdcKHxpbmlfc2V=XCh8c2V=X3RpbWVfbGltaXRcKHxzZXRfbWFnaWNfcXVvdGVzX3J1bnRpbWVcKClbXjtdK1s7XHNdK3xpZlwoW15ce1=rW1x7XHNdK1teXH1dK1tcfVxzXSspKikrKFteO1=rWztcc1=rKT8uK2ZpbGVfcHV=X2NvbnRlbnRzXCguKz9iYXNlNjRfZGVjb2RlXCguKz91bmxpbmtcKC4rP2Z1bmN=aW9uX2V4aXN=c1woWyciXVxceC4rP2NhbGxfdXNlcl9mdW5jXChbJyJdXFx4Lis_KCR8XD8-KS9pcyI7fXM6ODk6ImN1cmxfaW5pdCBoZWFkZXIgTG9jYXRpb24gcmV=dXJuIHByZWdfcmVwbGFjZV9jYWxsYmFjayBjcmVhdGVfZnVuY3Rpb24gcmV=dXJuIFJFTU9URV9BRERSIjthOjI6e2k6MDtzOjU6IkkxOTlFIjtpOjE7czoxNDY6Ii88XD8uKz9jdXJsX2luaXRcKC4rP2hlYWRlcltcKCInXHNdK=xvY2F=aW9uOi4rP3JldHVybiBwcmVnX3JlcGxhY2VfY2FsbGJhY2tcKC4rP2NyZWF=ZV9mdW5jdGlvblwoLis_cmV=dXJuIFwkX1NFUlZFUlxbWyInXVJFTU9URV9BRERSLisoXD8-fCQpL2lzIjt9czoxMjk6InBocCBzZXRfdGltZV9saW1pdCBpbmlfc2V=IGVycm9yX3JlcG9ydGluZyBpZiBhcnJheV9rZXlfZXhpc3RzIEhUVFBfVVNFUl9BR=VOVCBzZWFyY2gtdHJhY2tlci5jb2=gcHJlZ19tYXRjaCBnb29nbGUgYmluZyBvYl9zdGFydCI7YToyOntpOjA7czo1OiJJMTk5RiI7aToxO3M6MjMwOiIvPFw_W3BoXHNdKy4qP3NldF9=aW1lX2xpbWl=XCguKz9pbmlfc2V=XCguKz9lcnJvcl9yZXBvcnRpbmdcKC4rP2lmW1woXCFcc1=rYXJyYXlfa2V5X2V4aXN=c1woWyInXUhUVFBfVVNFUl9BR=VOVC4rP2h=dHA6XC9cL3NlYXJjaC1=cmFja2VyXC5jb21cL2luXC5jZ2lcPy4rPyhwcmVnX21hdGNoXChbIiddXC8oW15cL1=qZ29vZ2xlfFteXC9dKmJpbmcpezJ9Lis_KXsyfS4rP29iX3N=YXJ=XCguKy9pcyI7fXM6NTE6ImlmIGlzc2V=IEZJTEVTfFJFUVVFU1QgbW92ZV91cGxvYWRlZF9maWxlIGVsc2UgZWNobyI7YToyOntpOjA7czo1OiJJNENDViI7aToxO3M6NTQ4OiIvPFw_W3BoXHNdKygoXCRbYS16XzAtOV=rXHMqPXxzZXRfdGltZV9saW1pdFwofGluaV9zZXRcKClbXjtdK1s7XHNdKykqKChbYS16XzAtOV=rKVwoW147XStbO1xzXH1dKyk_KGlmW1woXHNdK3N1YnN=cltcKFxzXStbXlx7XStbXHNce1=rKFwkW2Etel8wLTldK1xzKj1bXjtdK1s7XHNcfV=rKSspPygoaWZbXChcc1=rKGlzc2V=W1woXHNdKyk_XCRfKEZJTEVTfFJFUVVFU1R8UE9TVHxHRVQpW15cKV=qW1wpXHNce1=rKFwkW2Etel8wLTldK1xzKj1bXjtdKztccyopKikrKFxAfGlmW1woXHNdKykqKG1vdmVfdXBsb2FkZWRfZmlsZVwoW147XSt8KGZ3cml=ZVwoW147XSs7XHMqKStmY2xvc2VcKFteO1=rKVs7XHNcfV=rKGVsc2VbXHtcc1=rfChlY2hvfGV4aXR8aGVhZGVyKVteO1=qWztcc1x9XSspKikrKGZ1bmN=aW9uXHMrXDRcKFteO1=rWztcc1x9XSsoXCRbYS16XzAtOV=rXHMqPVteO1=rWztcc1x9XSspKmlmW1woXHNdK1teXHtdK1tcc1x7XSsoXEB8aWZbXChcc1=rKSpta2RpclwoW147XStbO1xzXH1dK3JldHVyblteO1=rWztcc1x9XSspPygkfFw_PikvaSI7fXM6NTU6Imh=bWwgYm9keSBwaHAgb3BlbmRpciByZWFkZGlyICFmaWxlX2V4aXN=cyBmb3BlbiBmd3JpdGUiO2E6Mjp7aTowO3M6NToiSTFNRmUiO2k6MTtzOjIyMDoiLyg8KFwhfFwvKT8oZG9jdHlwZXxodG1sfGhlYWR8bWV=YXx=aXRsZXxib2R5KVtePl=qPlthLXpfMC=5XHNdKil7Mix9PFw_W3BoXHNdK1wkW2Etel8wLTldK1xzKj1ccyonPFw_W3BoXHNdKy4rP29wZW5kaXJcKC4rP3JlYWRkaXJcKC4rPyhcIWZpbGVfZXhpc3RzXCguKz9mb3BlblwoLis_ZndyaXRlXCguKz8pezMsfVw_PlxzKig8XC8oaHRtbHxib2R5KVtePl=qPlxzKil7Mix9JC9pcyI7fXM6NjE6ImZ1bmN=aW9uIFhfaXAgWF9tYWNyb3MgZXJyb3JfNDA=IGh=dHBfcmVxdWVzdCBmd3JpdGUgRlVOQ1RJT=4iO2E6Mjp7aTowO3M6NToiSTFNRmwiO2k6MTtzOjExNjoiL1w8XD8uKz9faXBcKCguKz9mdW5jdGlvbiBbYS16MC=5XStfbWFjcm9zXCgpezR9Lis_ZnVuY3Rpb24gZXJyb3JfNDA=XCguKz9odHRwX3JlcXVlc3QuKz9md3JpdGVcKC4rP19fRlVOQ1RJT=5fXy4rL3MiO31zOjQ2OiJwZXJsIHVzZSBJTzo6U29ja2V=IHNjYW5fZGlyIHVuYW1lIHN5c3RlbSBleGVjIjthOjI6e2k6MDtzOjU6IkkxUENpIjtpOjE7czoxOTg6Ii9cI1whKFwvdXNyKT9cL2JpblwvKHBlcmwuKz9zY2FuX2RpclwoLis_dW5hbWVcKC4rP3N5c3RlbVwoLis_ZmlsZW1hbmFnZXIuK3xbYmFdKnNoXHMrd2dldFxzK1wtb1xzKyhcUyspXHMrKFxTKylbXjtdKjtccyooKGNobW9kfGNob3dufGN1cmwpXHMrKFxTK1xzK1wzKFxzK1w=KT9bO1xzXSopKykrcm1ccytcLVtyZl=rXHMrXDNbO1xzXSokKS9pcyI7fXM6NjA6InBhdGggaWYgZmlsZV9leGlzdHMgaXNfd3JpdGFibGUgaWYgZnVuY3Rpb25fZXhpc3RzIFdyaXRlRGF=YSI7YToyOntpOjA7czo1OiJJMVBDaiI7aToxO3M6MTM5OiIvXCRwYXRoWz1cc1=rLitbXHNdKmlmW1xzXSpcKFwhZmlsZV9leGlzdHNcKC4rP2lzX3dyaXRhYmxlXChbXlwpXSpbXClcc1x7XStpZltcc1=qXChmdW5jdGlvbl9leGlzdHNcKC4rP1dyaXRlRGF=YS4rP1dyaXRlRGF=YVwoXCk7W1xzXH1dKy9pIjt9czo1MToiZGlzcGxheV9lcnJvcnMgY3JlYXRlX3dwX3VzZXIgUkVRVUVTVCBmd3JpdGUgdW5saW5rIjthOjI6e2k6MDtzOjU6Iko=RkpXIjtpOjE7czoxNTc6Ii9eLis_ZGlzcGxheV9lcnJvcnMuKz9jcmVhdGUoX3xccytUQUJMRVxzK1xgKXdwX3VzZXIoXGAuKz8oXCRbYS16XzAtOV=rXHMqPShccypcJFthLXpfMC=5XStccypcKCl7Mn1bXjtdKztccyopezJ9fFwoXCRfUkVRVUVTVFxbLis_ZndyaXRlXCguKz91bmxpbmtcKCkuKyQvaXMiO31zOjQ4OiJwaHAgYXJyYXkgZm9yZWFjaCBhcnJheSBldmFsIEFycmF5IEZ1bmN=aW9uIFBPU1QiO2E6Mjp7aTowO3M6NToiSTIxRGEiO2k6MTtzOjEyNDoiLzxcP1twaF=qXHMrKFwkW2Etel8wLTlcLV=rKVs9XHNdK2FycmF5XChbXjtdKztccypmb3JlYWNoW1xzXChdK1wxLis_ZXZhbFtcc1woXStcMVxbW15cXV=rXF=rW1woXHNdK1wkX1BPU1RcW1wxLis_KCR8XD8-KS9pcyI7fXM6MjQ6IndlYiBzaGVsbCBmb3BlbiBwYXNzdGhydSI7YToyOntpOjA7czo1OiJJMjFEYyI7aToxO3M6Njk6Ii9eLis_ZXJyb3JfcmVwb3J=aW5nXCguKz93ZWJbIFx=XSpzaGVsbC4rP2ZvcGVuXCguKz9wYXNzdGhydVwoLis_JC9pcyI7fXM6MjI6ImV2YWwgYXJyYXlfcG9wIFJFUVVFU1QiO2E6Mjp7aTowO3M6NToiSTlFSDIiO2k6MTtzOjkyOiIvZXZhbFwoW1xzYS16XzAtOVwuXChdKihmcm9tQ2hhckNvZGVcKFswLTksXHNdK3xhcnJheV9wb3BcKFwkXyhHRXxQT1N8UkVRVUVTKVQpW1wpXHNdKztccyovaSI7fXM6MzM6Ii9hdXRoX3Bhc3MgbG92ZSBzZXRfZXJyb3JfaGFuZGxlciI7YToyOntpOjA7czo1OiJJMjU5OSI7aToxO3M6MTU2OiIvPFw_KD89Lip1bmxpbmtcKFBBU1NXT1JEX=ZJTEV8LipcJGF1dGhfcGFzcykoPz=uKmxvdmVMb2dpbnwuKnNldF9=aW1lX2xpbWl=KSg_PS4qc2V=Y29va2llKSg_PS4qc2V=X2Vycm9yX2hhbmRsZXJcKHwuKmZ1bmN=aW9uIGFycmF5X3RvX2pzb25cKCkuKygkfFw_PikvaXMiO31zOjI2OiJHRVRkb19yZW1vdmUgc2FmZV9tb2RlIGVuZCI7YToyOntpOjA7czo1OiJJMjU5QSI7aToxO3M6MTE=OiIvaWZcKFwkX=dFVFxbJ2RvJ1xdPT=icmVtb3ZlIlwpXHtcbnVubGlua1woZ2V=Y3dkXChcKVwuXCRfU=VSVkVSXFsiU=NSSVBUX=5BTUUiXF1cKTsuK3NhZmVfbW9kZS4rZWxzZS4rJ1wuXCRlbmQ7L3MiO31zOjU2OiJzZXRfdGltZV9saW1pdCB1bmxpbmsgYmFzZTY=X2RlY29kZSBmd3JpdGUgZXhlYyBwYXNzdGhydSI7YToyOntpOjA7czo1OiJJMjU5QyI7aToxO3M6OTk6Ii88XD8ocGhwKT8uKz9zZXRfdGltZV9saW1pdFwoMFwpLis_dW5saW5rXCguKz9iYXNlNjRfZGVjb2RlXCguKz9md3JpdGVcKC4rP2V4ZWNcKC4rP3Bhc3N=aHJ1XCguKy9pcyI7fXM6MzI6ImZ1bmN=aW9uIGNsYXNzIHZhcmlhYmxlIGZ1bmN=aW9uIjthOjI6e2k6MDtzOjU6IkkzUUg2IjtpOjE7czoyMjc6Ii88XD9bcGhcc1=qZnVuY3Rpb25ccysoW2Etel8wLTldKylcKC4rP3JldHVyblteO1=qO1xzKlx9XHMqY2xhc3NbXlx7XStcey4qP2Z1bmN=aW9uW15ce1=rXHtccyooXCRbXCRce1=qW2Etel8wLTldK1x9KihccypcW1teXF1dK1xdKSpccyo9XHMqKSpcMVwoKC4qP1wkW1wkXHtdKlthLXpfMC=5XStbXH1cc1=qKFxbW15cXV=rXF1ccyopKlwoW147XSs7XHMqKXs1MCx9W1x9XHNdKigkfFw_PikqL2lzIjt9czoyODoicGhwIFN=YXJ=aW5nIGNhbGxzIGM5OXNoZXhpdCI7YToyOntpOjA7czo1OiJJNUFCUSI7aToxO3M6ODg6Ii88XD9bcGhcc1=rXC9cL1N=YXJ=aW5nIGNhbGxzLitjaGRpclwoXCRsYXN=ZGlyXClbO1xzXStbYS16MC=5XStleGl=XChcKVs7XHNdKigkfFw_PikvaXMiO31zOjIwOiJwaHAgcGFzc3dvcmQgaGdfZXhpdCI7YToyOntpOjA7czo1OiJKOTgxMCI7aToxO3M6MjAzOiIvPFw_W3BoXHNdKihcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcLylccypcJHBhc3N3b3JkLisobGVhZk1haWxDaGVja1tcKFxzXSsuK3ByaW5=W1xzXChdKihbJyJdKS4rP1w=O1xzKigkfFw_Pil8b2Jfc3RhcnRbXChcc1=rYXJyYXlbXChcc1=rXCRbXjtdKztbXHNcfV=qbXRfc3JhbmRcKFwpO1tcc1x9XSooJHxcPz4pfGhnX2V4aXRcKFwpOy4rKS9pcyI7fXM6MjE6InNoZWxsIHN5c3RlbSBwYXNzdGhydSI7YToyOntpOjA7czo1OiJJNktEMiI7aToxO3M6OTI6Ii9cPFw_Lis_KHNoZWxsfGF1dGhwKS4rP2Vycm9yX3JlcG9ydGluZ1woMFwpLis_c2V=X3RpbWVfbGltaXRcKDBcKS4rP2luaV9zZXRcKC4rZm9wZW5cKC4rL2lzIjt9czoxODoiZnVuY3Rpb24gQlNTViBldmFsIjthOjI6e2k6MDtzOjU6Ikk3MUVnIjtpOjE7czo=NToiL2Z1bmN=aW9uIEJTU1ZcKC4rZXZhbFwoQlNTVlwoLis_XCkrWztcc1=qL2lzIjt9czozMjoiZXJyb3JfcmVwb3J=aW5nIHBhc3N3b3JkIGV4aXQgbWUiO2E6Mjp7aTowO3M6NToiSTc3R=siO2k6MTtzOjEzMjoiLzxcP1twaFxzXSplcnJvcl9yZXBvcnRpbmdcKDBcKTtccypcL1wvSWYgdGhlcmUgaXMgYW4gZXJyb3IsIHdlJ2xsIHNob3cgaXQsIGtcP1xzKlwkcGFzc3dvcmRccyo9LisgOi1cKVxzKmV4aXRcKFwpO1xzKlw_PlwuXCRtZVwuL2lzIjt9czo1MzoidmFyIGZ1bmN=aW9ucyByZXR1cm4gbmV3IFJlY3Vyc2l2ZUFycmF5SXRlcmF=b3IgYXJyYXkiO2E6Mjp7aTowO3M6NToiSTc5TW4iO2k6MTtzOjE2MDoiLyhcJFthLXpfMC=5XStbXHM9XSsiW2Etel9cLVwwLTldKiI7XHMqKSsoKFwkW2Etel8wLTldK1tccz1dKyk_XCRbYS16XzAtOV=rXCgrLis_W1wpXSs7XHMqKSsuK3JldHVyblxzK25ld1xzK1JlY3Vyc2l2ZUFycmF5SXRlcmF=b3JbXChcc1=rYXJyYXkuKz9bXClcc1=rO1x9Ky9pcyI7fXM6NTQ6IlBIUCBERUZJTkUgZmlsZV9nZXRfY29udGVudHMgYmFzZTY=X2RlY29kZSBqc29uX2VuY29kZSI7YToyOntpOjA7czo1OiJKOEJNbiI7aToxO3M6MzUzOiIvPFw_W3BoXHNdKyhcQCooKFwkW2Etel8wLTldKylccyooXFtbXlxdXSpcXVxzKikqPVxzKihbJyJdKSguKj8pXDV8KFwkLi4uKVthLXpfMC=5XStccyooXFtbXlxdXSpcXVxzKikqPVxzKihBcnJheXxleHBsb2RlKVwofFtpZlxzXChcIV=qREVGSU5FW2RdKlwoKFsnIl=pKC4qPylcMTB8ZXJyb3JfcmVwb3J=aW5nXCgpW147XSo7W1xzXH1dKikrLitmaWxlX2dldF9jb25=ZW5=c1woW147XSooXDExfDtccypcJFtzdG9yZWRdKmNyYykuK2Jhc2U2NF9kZWNvZGVbXChcc1=rKFwzfFw3KS4rKChcJFthLXpfMC=5XSspXC=-cnVuXChcKTtccyp1bnNldFwoXDE1XCk7XHMqJHxqc29uX2VuY29kZVwoW147XSs7XHMqXD8-KS9pcyI7fXM6NDE6ImlmIGFycmF5X2tleXMgR=VUIGV2YWwgYmFzZTY=X2RlY29kZSBleGl=IjthOjI6e2k6MDtzOjU6IkoxVTdrIjtpOjE7czoyMTY6Ii88XD9bcGhcc1=qKFxAP2Vycm9yX3JlcG9ydGluZ1woMFwpO1xzKik_aWZbXChcc1=rYXJyYXlfa2V5c1woXCRfR=VULitccysoKDxcP1twaFxzXSopP1wkW2Etel8wLTldK1tcc1x7XCRdK1xAKmV2YWxcKGJhc2U2NF9kZWNvZGVcKFsnIl1bYS16X1wvXCtcPTAtOV=rWyciXVtcKVx9XHtcJFxzXStleGl=XChbXClcfVxzXStcJlxzKlwkW2Etel8wLTldK1s7XHNcfV=rXD8-KSsvaSI7fXM6ODU6InBocCBlcnJvcl9yZXBvcnRpbmcgc2V=X3RpbWVfbGltaXQgaW5pX3NldCBfeGNvb2tpZSBiYXNlNjRfZGVjb2RlIHN=cl9yb3QxMyBnemluZmxhdGUiO2E6Mjp7aTowO3M6NToiSjJLS2YiO2k6MTtzOjIyNToiLzxcP1twaFxzXSsoXEA_KGVycm9yX3JlcG9ydGluZ3xzZXRfdGltZV9saW1pdHxpbmlfc2V=KVwoLio_MFwpO1xzKil7Myx9KC4rP194Y29va2llKXs5fSguKz8oXCRbYS16XzAtOV=rXHMqPXxyZXR1cm4pKFtcc1xAXSooYmFzZTY=X1tkZW5dK2NvZGV8c3RyX3JvdDEzfGd6W2RlaW5dK2ZsYXRlfHN=cnJldilcKCl7Myx9W147XSs7KXsyfS4rcmV=dXJuIGZhbHNlWztcc1x9XSsoJHxcPz4pL2lzIjt9czo=NDoiZXhjZXNzaXZlIHNwYWNlcyBzY3JpcHQgZXZhbCBmdW5jdGlvbiBwYWNrZWQiO2E6Mjp7aTowO3M6NToiSjM2SDMiO2k6MTtzOjI=MDoiLzxzY3JpcHRbXj5dKj5bXjxdKmV2YWxcKGZ1bmN=aW9uXChwLGEsYyxrLGUsZFwpXHsuKz9ccyo8XC9zY3JpcHQ-XHMqPHNjcmlwdFtePl=qPltePF=qXFtbJyJdSGlzdGF=c1wuc3RhcnRbJyJccyxdKzFbXHMsXSs=MjE=MzkzW1xzLF=rW148XSo8XC9zY3JpcHQ-XHMqKDxub3NjcmlwdD5ccyooPGFbXj5dKj5ccyopKjxpbWdbXj5dKltcP3xcJl==MjE=MzkzW14-XSo-XHMqKDxcL2E-XHMqKSo8XC9ub3NjcmlwdD4pKi9pIjt9czo1MDoicGhwIGVycm9yX3JlcG9ydGluZyB1bmxpbmsgX19GSUxFX18gY2FsbF91c2VyX2Z1bmMiO2E6Mjp7aTowO3M6NToiSzkzSEgiO2k6MTtzOjI2NjoiLzxcP1twaFxzXSooXCRbYS16XzAtOV=rXHMqPVteO1=rO1xzKnxcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcL1xzKnxcL1wvW15cbl=qXHMqKSooXEA_KGVycm9yX3JlcG9ydGluZ3xpbmlfc2V=fHNldF9=aW1lX2xpbWl=KVxzKlwoW147XSs7XHMqKXszfS4rXEA_dW5saW5rXChfX=ZJTEVfX1teO1=rO1xzKi4rKG15c3FsaV9jbG9zZXxjYWxsX3VzZXJfZnVuYylbXHNcKF=rXCRbXjtdKztccyooKHJldHVybnxlY2hvKVteO1=rO1tcc1x9XSopKigkfFw_PikvaXMiO31zOjg4OiJwaHAgZXJyb3JfcmVwb3J=aW5nIHN5c3RlbSByZWFkZGlyIGZpbGVfcHV=X2NvbnRlbnRzIG1vdmVfdXBsb2FkZWRfZmlsZSB1bmxpbmsgZm9ybSBodG1sIjthOjI6e2k6MDtzOjU6Iko5OTRlIjtpOjE7czo1OTA6Ii88XD9bcGhcc1=rKFwvXCooW14qXSpcKig_IVwvKSkqW14qXSpcKlwvXHMqfFwvXC9bXlxuXSpccyp8W1xAaWZcc1woXSooXCRbYS16XzAtOV=rXHMqPVteO1=rO1xzKikpKigoZGVmaW5lXCh8c2Vzc2lvbl9zdGFydFwofGVycm9yX3JlcG9ydGluZ1wofGluaV9zZXRcKHxzZXRfdGltZV9saW1pdFwofFtzZ11ldF9tYWdpY19xdW9=ZXNfW2EtdV=rXCgpW147XStbO1x9XHNdKykrKChlY2hvW1xzXChdKihbJyJdKS4rP1w2O1xzKnxcPz5ccyo8XD9bcGhcc1=qfChcJFthLXpfMC=5XStccyo9XHMqKT9APyhpZnxmd3JpdGV8ZmNsb3NlfGZvcGVufGZpbGUpW1xzXChdK1teO1=rO1xzKnxbXH1cc1=qZWxzZVtcc1x7XSp8XCRbaTFsXSpbPVxzXStbXjtdKztccyopK1tcfTtcc1=qXD8-KFxzKjxcL1thLXpdKz4pK3xzeXN=ZW1ccypcKC4rP3NldGNvb2tpZVxzKlwoLis_cmVhZGRpclxzKlwoLis_ZmlsZV9wdXRfY29udGVudHNcKC4rP21vdmVfdXBsb2FkZWRfZmlsZVxzKlwoLis_KHBvc2l4X2dldFtwd3Vncl=raWRccypcKC4rPyl7Mix9dW5saW5rXHMqXCguKz88Zm9ybS4rPzxcL2Zvcm=-KVxzKjxcL2JvZHk-XHMqPFwvaHRtbD5ccyokL2lzIjt9czozMjoicGhwIGRpciByZWN1cnNpdmUgZnVuY3Rpb24gIGxvb3AiO2E6Mjp7aTowO3M6NToiSjVSQkMiO2k6MTtzOjM5NDoiLzxcP1twaFxzXSsoLiooZGlyfHJhbmR8bWQ1fGluY2x1ZGV8cmVxdWlyZXxfb25jZXxnZXRjd2QpXHMqXChbXjtdKztccyp8XH1bXH1cc1=qfGVsc2VbXHtcc1=qfCh3aGlsZXxpZnxmb3IoZWFjaCk_KVxzKlwoLitbXHtcc1=qfFwvXC8uKlxzKykrP2Z1bmN=aW9uIChbYS16XzAtOV=rKVwoW15ce1=rXHtccyooLitkaXJccypcKFteO1=rO1xzKnxbXH1cc1=qZWxzZVtce1xzXSp8KHdoaWxlfGlmfGZvcihlYWNoKT8pXHMqXCguK1tce1xzXSopKy4qXDVccypcKChcJFthLXpfMC=5XSspW147XSs7XHMqKChcfVtcfVxzXSp8ZWxzZVtce1xzXSopKi4qKGNvcHl8ZGlyfHVubGlua3xlY2hvfGhlYWRlcnxwcmludHxcJFthLXpfMC=5XStccyo9KVxzKltcKCciXStbXjtdKztccyopKygkfFw_PikvaSI7fXM6NDE6InBocCBlcnJvcl9yZXBvcnRpbmcgaWYgaXNzZXQgUkVRVUVTVCBtYWlsIjthOjI6e2k6MDtzOjU6IkpCSElkIjtpOjE7czo=MjU6Ii88XD9bcGhcc1=qKGlmW1xzXChcIV=rKGVtcHR5fHN=cmxlbnxpc3NldClbXHNcKF=rXCRfKFJFUVVFU3xHRXxQT1MpVFteXCldK1tcKVxzXHtdK1teO1=rO1tcc1x9XSp8ZXJyb3JfcmVwb3J=aW5nXChbXjtdKztccyopKy4qPyhpZltcc1woXCFdKyhlbXB=eXxzdHJsZW58aXNzZXQpW1xzXChdK1wkXyhSRVFVRVN8R=V8UE9TKVRbXlwpXStbXClcc1x7XSsoXCRbMC=5X2Etel=rKVxzKj1ccyoocmFuZFwofFwkXyhSRVFVRVN8R=V8UE9TKVQpKS4rKChcJFthLXpfMC=5XStccyo9XHMqfGlmW1xzXChdK3xlbHNlW15ce1=qW1x7XHNdKykqbWFpbFtcc1woXStbXjtdKlw3W147XStbXCk7XHNcfV=qKSsoKChpZltcKFxzXSt8ZWxzZSlbXlx7XSpbXHtcc1=rKT8oKGhlYWRlcnxlY2hvfHByaW5=fGV4aXQpW147XSpbO1xzXH1dKykrKSooJHxcPz4pL2lzIjt9czozMDoicGhwIG9fMCB2YXJpYWJsZSBmdW5jdGlvbnMgZW5kIjthOjI6e2k6MDtzOjU6IktCMjkwIjtpOjE7czo=MDk6Ii88XD9bcGhcc1=qKChcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcL1xzKnxcL1wvW15cbl=qXHMqfGVycm9yX3JlcG9ydGluZ1woW147XSs7XHMqKSooKChbXjtdKlwkW29fMF=rfC4qZnVuY3Rpb25ccysoW29fMF=rKSl8KGV4aXR8YnJlYWt8dW5zZXR8aGVhZGVyfHJldHVybilbXlwpXSopW147XStbJyJcKTtcfVxzXSspKz8oKFtcJFx7IiddKyhcXHhbYS1mMC=5XXsyfXxbbGkxX1=rW1xzPV=rXDcpK1tcfSciXHNdKikoXFtbXlxdXStcXVxzKikqXChbXjtdK1s7XH1cc1=rKSspKz8uKihbXCRceyInXSsoXFx4W2EtZjAtOV17Mn18W2xpMV9dKStbXH=nIlxzXSooXFtbXlxdXStcXVxzKikqXChbXjtdKztccyopKyhcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcL1xzKnxcL1wvW15cbl=qXHMqKSooJHxcPz4pL2kiO31zOjQwOiJwaHAgZnVuY3Rpb24gY3VybCBmaWxlX3B1dF9jb25=ZW5=cyBjYWxsIjthOjI6e2k6MDtzOjU6IktBSkpYIjtpOjE7czo=MzY6Ii88XD9bcGhcc1=rKChpbmlfc2V=fGVjaG98XCRbYS16XzAtOV=rXHMqPSlbXjtdKztccyopKmZ1bmN=aW9uXHMrKFthLXpfMC=5XSspW15ce1=rW1xzXHtdKyhcJFthLXpfMC=5XStccyo9W147XSs7W1x9XHNdKikqKChcJFthLXpfMC=5XStccyooXFtbXlxdXStcXStccyopKj1ccyopP2N1cmxfLis7W1x9XHNdKikrKCgoaWZbXHNcKF=rW147XSt8ZWxzZVtcc1x7XStbXjtdK3xcJFthLXpfMC=5XStccyo9XHMqKT8ocmV=dXJufGZpbGVfcHV=X2NvbnRlbnRzXCh8XCRfKFNFUlZFUnxHRVR8UE9TVHxSRVFVRVNUKXxjdXJsX3xleGVjXCh8ZWNob3xwcmludClbXjtdKztbXH1cc1=qKSsoXCRbYS16XzAtOV=rXHMqKFxbW15cXV=rXF=rXHMqKSo9XHMqKT9cM1woW147XSs7W1x9XHNdKigoLipmb3Blbnxmd3JpdGV8ZmNsb3NlfGV2YWwpXCguK1xzKikqKSsoJHxcPz4pL2kiO31zOjU3OiJwaHAgX=NPT=tJRSBmaWxlX2dldF9jb25=ZW5=c19YIGZ1bmN=aW9uIGN1cmwgcmV=dXJuIEZPUk=iO2E6Mjp7aTowO3M6NToiSzNJRUciO2k6MTtzOjQ4NjoiLzxcP1twaFxzXSsoKFwvXCooW14qXSpcKig_IVwvKSkqW14qXSpcKlwvfFtce1xzXSspKigoaXNzZXR8bWQ1fGlmfFtcfVxzXSplbHNlXHMqXHtbXlx9XStcfStccyp8ZmlsZV9leGlzdHNbXHNcKCciXStcLmh=YWNjZXNzWyciXVteXH1dK1x9K1xzKnxcJFthLXpfMC=5XSspW1xzXCg9XCFdKykrXCQoX1JFUVVFU1R8X1BPU1R8X=dFVHxfQ=9PS=lFfFx7W15cfV=rXH=rfHxcW1teXF1dK1xdKykrLiooO3xccypceykoXHMqKGVjaG98ZXhpdClbXjtdKjspKltcfVxzXSopKyhcJFthLXowLTldKylbPVxzXSooZmlsZV9nZXRfY29udGVudHNfW2Etel8wLTldKylbXlx9XStcfVxzKmZ1bmN=aW9uIFwxMVteXHtdK1x7XHMqKFteO1=qY3VybF9bXjtdKjtccyp8cmV=dXJuW147XSo7XHMqfChcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcL1xzKikqfFx9XHMqKSsoJHxcPz4oXHMqPGZvcm1bXj5dKig-XHMqPGlucHV=W14-XSopKz5ccyo8XC9mb3JtPik_KS9pIjt9czo1NzoicGhwIGVycm9yX3JlcG9ydGluZyBkZWZpbmUgZnVuY3Rpb24gZ2V=X3JlYWxfaXAgcmV=dXJuIGlwIjthOjI6e2k6MDtzOjU6Iks=QTBoIjtpOjE7czoyOTc6Ii88XD9bcGhcc1=rKFwvXC9bXlxuXSpcblxzKnxcL1wqW15cKl=qKFwqW15cKlwvXSopK1wvXHMqfFxAPyhpZ25vcmVfdXNlcl9hYm9ydHxpbmlfc2V=fHNldF9=aW1lX2xpbWl=fGVycm9yX3JlcG9ydGluZylcKC4qP1wpO1xzKnxkZWZpbmVcKFteXCldK1tcKTtcc1=rfFwkK1thLXpfMC=5XSsoXHMqXFtbXlxdXSpcXSkqXHMqPVteO1=rO1xzKikrLitmdW5jdGlvbiBnZXRfcmVhbF9pcFwoLityZXR1cm4gXCRpcFs7XHNcfV=rKFwvXC9bXlxuXSpccyp8XC9cKlteXCpdKihcKlteXCpcL1=qKStcL1xzKikrKCR8XD8-KS9pcyI7fXM6MTAxOiJwaHAgZXJyb3JfcmVwb3J=aW5nIGFkZF9maWx=ZXIgZnVuY3Rpb24gc2NyaXB=IHpvbmVpZCBmaWxlX2dldF9jb25=ZW5=c19jdXJsIGZ1bmN=aW9uIGhpZGUgYWRkX2FjdGlvbiI7YToyOntpOjA7czo1OiJLN1RFVCI7aToxO3M6NTkxOiIvPFw_W3BoXHNdKyhcL1wqKFteKl=qXCooPyFcLykpKlteKl=qXCpcL1xzKikrKChcJFthLXpfMC=5XSspXHMqPVteO1=rO1xzKnwofGluaV9zZXR8ZXJyb3JfcmVwb3J=aW5nfHNldF9=aW1lX2xpbWl=KVwoW15cKV=qXCk7XHMqKSsoYWRkXyhmaWx=ZXJ8YWN=aW9uKVtcc1woXStbJyJdW14sXStbLFxzXSsoKFsnIl=pKC4rPylcOVtcKTtcc1=rZnVuY3Rpb25ccytcMTBccypcKFteXHtdK1x7fGZ1bmN=aW9uXHMqXChbXlx7XStceylbXlx9XStbXH1cKTtcc1=rKSsoXC8qXCRbYS16XzAtOV=rXHMqPVtccyciO1=rKSs8c2NyaXB=LitmdW5jdGlvblxzK2ZpbGVfZ2V=X2NvbnRlbnRzX1thLXpfMC=5XStbXlx7XStce1xzKihbXjtdKmN1cmxfW147XSo7XHMqfHJldHVyblteO1=qO1xzKnwoXC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC9ccyopKnxcfVxzKikrKGZ1bmN=aW9uXHMrKGhpZGVbYS16XzAtOV=rKVwoW15ce1=rXHsuK2FkZF9hY3Rpb25bXHNcKF=rWyciXVteLF=rWyxcc1=rKFsnIl=pXDE2XDE3W1wpO1xzXSspPyhmdW5jdGlvblteXHtdK1x7LityZXR1cm5ccytcJF9TRVJWRVJcW1teO1=rW1x9O1xzXSspKigkfFw_PikvaXMiO31zOjQ2OiJwaHAgaWYgY2xhc3NfZXhpc3RzIGNsYXNzIG5ldyBjYWxzcyBlbHNlIGNhdGNoIjthOjI6e2k6MDtzOjU6Iks1SUdaIjtpOjE7czoyNDU6Ii88XD9bcGhcc1=qKFwvXCooW14qXSpcKig_IVwvKSkqW14qXSpcKlwvXHMqfFwvXC9bXlxuXSpccyp8aWZbXHNcKFwhXStjbGFzc19leGlzdHNbXlx7XStce1xzKikqY2xhc3NccysoW2Etel8wLTldKylccypcey4rKFwkW2Etel8wLTldKylbXD1cc1=rbmV3XHMrXDNbXjtdKjtccyooXCRbYS16XzAtOV=rKVtcPVxzXStcNFteO1=qO1xzKihbXlxuXSooXDN8XDR8XDV8ZWxzZXxjYXRjaClbXlxuXSpbXHNcfV=rKSsoJHxcPz4pL2lzIjt9czo2MDoibWV=YSBwcm9wZWxsZXIgc2NyaXB=IGZ1bmN=aW9uIGRvY3VtZW5=LmNyZWF=ZUVsZW1lbnQgc2NyaXB=IjthOjI6e2k6MDtzOjU6Iks1Uk1KIjtpOjE7czoyNDU6Ii8oPG1ldGEoXHMrKG5hbWV8Y29udGVudCk9WyciXShwcm9wZWxsZXJ8WzAtOWEtZl17MzJ9KVsnIl=pezJ9W14-XSo-XHMqKT88KHNjcmlwdClbXj5dKj5bXHNcKF=qZnVuY3Rpb25ccypcKFteXH1dK1x9W1wpO1xzXSpcKGRvY3VtZW5=XC5jcmVhdGVFbGVtZW5=W1woXHNdKyhTdHJpbmdcLmZyb21DaGFyQ29kZVwofFsnIl1zY3JpcHRbJyJdKS4rXClbO1xzXSooXC9cKlxzKlswLTlhLXpdK1xzKlwqXC9ccyp8JHw8XC9cNT4pKy9pIjt9czo4NjoidmFyIGRvY3VtZW5=IGNyZWF=ZUVsZW1lbnQgc2NyaXB=IFN=cmluZy5mcm9tQ2hhckNvZGUgZ2V=RWxlbWVudHNCeVRhZ=5hbWUgYXBwZW5kQ2hpbGQiO2E6Mjp7aTowO3M6NToiSzYyRGYiO2k6MTtzOjMxNjoiLyh2YXJccysoW2Etel8wLTldKylccyo9XHMqKGRvY3VtZW5=fFxkKylbO1xzXSspKyh2YXJccysoW2Etel8wLTldKylccyo9XHMqXDJcLmNyZWF=ZUVsZW1lbnRbXChccyciXSt8c2NyaXB=W147XSs7XHMqfCh2YXJccytbYS16XzAtOV=rXHMqPVxzKik_U3RyaW5nXC5mcm9tQ2hhckNvZGVbXjtdKztccyp8XDVcLlthLXpfMC=5XStccyo9W147XSs7XHMqKStpZltcKFxzXStkb2N1bWVudFwuW15cfV=rW1x9XHNdK2Vsc2Vccypce1xzKlwyXC5nZXRFbGVtZW5=c=J5VGFnTmFtZVteXC5dK1wuYXBwZW5kQ2hpbGRbXHNcKF=rXDVbXlx9XStcfVtcfVxzXSovaSI7fXM6NTE6InBocCBpZiBmdW5jdGlvbl9leGlzdHMgZGVmaW5lIEVPRiBmaWxlX3B1dF9jb25=ZW5=cyI7YToyOntpOjA7czo1OiJLNlIwSiI7aToxO3M6MjczOiIvPFw_W3BoXHNdK1wkW2Etel8wLTldK1xzKj1ccypfX=ZJTEVfXztccyooKFwkW2Etel8wLTldKylccyo9XHMqZnVuY3Rpb25fZXhpc3RzXChbXjtdKztccyopK2lmW1xzXChdK1teXHtdK1wyW15ce1=rXHtccyooZGVmaW5lW1woJyJcc1=rKFthLXpfMC=5XSspWyInXVteO1=rO1xzKnxcL1wvW15cbl=qXG5ccyopK1wkW2Etel8wLTldK1xzKj1ccyo8PDxbJyJdKihbYS16XzAtOV=rKVsnIlxzXSsuK1w1LitmaWxlX3B1dF9jb25=ZW5=c1woW147XSs7W1xzXH1dKygkfFw_PikvaXMiO31zOjM3OiJwaHAgY3VybF9pbml=IF9SRVFVRVNUIGN1cmxfZXhlYyBldmFsIjthOjI6e2k6MDtzOjU6Iks3QUkwIjtpOjE7czoyMTk6Ii88XD9bcGhcc1=rKFwvXCooW14qXSpcKig_IVwvKSkqW14qXSpcKlwvfFwvXC9bXlxuXSpcblxzKikqKFwkW2Etel8wLTldKyk_W1xzPV=qY3VybF9pbml=XChcJF8oUkVRVUVTfFBPU3xHRSlUW147XSs7XHMqKChcJFthLXpfMC=5XSspP1tccz1dKmN1cmxfW147XSs7XHMqKSsocHJpbnR8ZGllfGVjaG98ZXZhbClbJyJcc1woXD9cPlwuXStcNlsnIlxzXCk7XH1dK1xzKigkfFw_PikvaSI7fXM6MzY6InBocCBkZWZpbmUgY3JlYXRlX2Z1bmN=aW9uIGVjaG8gZm9ybSI7YToyOntpOjA7czo1OiJLN=NFayI7aToxO3M6NDUzOiIvPFw_W3BoXHNdKygoXC9cKihbXipdKlwqKD8hXC8pKSpbXipdKlwqXC9ccyp8XC9cL1teXG5dKlxzKnxpZlxzKlwoXCRbYS16XzAtOV=rW15cfV=rXH1ccyopKihkZWZpbmVbZFwoJyJcc1=rKFthLXpfMC=5XSspWyInXVteO1=rWztcfVxzXSt8ZnVuY3Rpb25ccysoW2Etel8wLTldKylcKC4rP3JldHVyblteO1=rO1tcfVxzXSspKykrKFwkW2Etel8wLTldKylccyo9XHMqW147XSpcJChfUkVRVUVTVHxfUE9TVHxfR=VUfF9DT=9LSUUpW147XSo7XHMqKFwkW2Etel8wLTldKylccyo9XHMqXDZcKFteO1=qXDVbXixdKyxccypcNyouKz8oXCRbYS16XzAtOV=rKVxzKj1ccypjcmVhdGVfZnVuY3Rpb25cKFteLF=rLFxzKlw5Lis_XDEwXChbXjtdKjtbXH1cc1=qKGVjaG98ZXhpdClbXHNcKCciXSs8Zm9ybVtePl=qKD5ccyo8aW5wdXRbXj5dKikrPlxzKjxcL2Zvcm=-WyciO1x9XHNdKygkfFw_PikvaXMiO31zOjczOiJwaHAgbmV3IHdwX2h=dHBfY3VybCBmdW5jdGlvbiBybXMgYWRkX2FjdGlvbiBhZG1pbl9mb29=ZXIgZnVuY3Rpb24gc2NyaXB=IjthOjI6e2k6MDtzOjU6Iks4T=psIjtpOjE7czoyMTM6Ii88XD8uKz9uZXcgV3BfSHR=cF9DdXJsXChcKTsoLis_XC9cKi4qP1wqXC9ccypmdW5jdGlvblxzK1thLXpfMC=5XSpybXNfW2Etel8wLTldKyl7NSx9Lis_XC9cKi4qP1wqXC9ccyphZGRfYWN=aW9uXChbIiddYWRtaW5fZm9vdGVyWyciXSxccypmdW5jdGlvblwoXClccypce1xzKlw_PlxzKjxzY3JpcHQuKz88XC9zY3JpcHQ-XHMqPFw_W3BoXHNcfVwpO1=qKCR8XD8-KS9pcyI7fXM6NDY6InRyeSBwYXNzd29yZCBmaWxlX2dldF9jb25=ZW5=cyBjYXRjaCBFeGNlcHRpb24iO2E6Mjp7aTowO3M6NToiS=EzRTkiO2k6MTtzOjE2MDoiLyh=cnlccypce1xzKiguK3Bhc3N3b3JkLitbXHJcbl=rXHMqKSooZmlsZV9nZXRfY29udGVudHNccypcKFteO1=qO1tcc1x9XSopK2NhdGNoW1woXHNdKkV4Y2VwdGlvblxzKlwkW2Etel8wLTldK1tcKVxzXSpce1xzKihpZltcc1woXStbXlx7XStce1xzKnxcfSkpK1tcc1x9XSovaSI7fXM6ODU6ImVycm9yX3JlcG9ydGluZyBnbG9iYWwgemVldGEgaWYgaXNzZXQgZnVuY3Rpb24gY3VybF8gcHJlZ19tYXRjaCBmd3JpdGUgaW5jbHVkZSB1bmxpbmsiO2E6Mjp7aTowO3M6NToiS=FCSEoiO2k6MTtzOjU=OToiLyhcQD8oaWdub3JlX3VzZXJfYWJvcnR8c2V=X3RpbWVfbGltaXR8aW5pX3NldHxlcnJvcl9yZXBvcnRpbmcpXChbXlwpXSpcKVtcc1wpXSo7XHMqfFwvXC9bXlxuXSpcblxzKikqZ2xvYmFsIChcJFthLXpfMC=5XSspW147XSo7XHMqaWZbXHNcKFwhXSsoKGVtcHR5XCh8c3RybGVuXCh8aXNzZXRcKCkqKFwkW2Etel8wLTldKylbXClcc1wmXD1cIV=qaXNzZXRbXChcc1=rXDMpW15ce1=rXHsoPz=uKz9mdW5jdGlvblxzKyhbYS16XzAtOV=rKVwoW15ce1=rXHtccypbXlxuXSooY3VybF98ZmlsZV9nZXRfY29udGVudHMpKSg_PS4qPyhcJFthLXpfMC=5XSspXHMqPVxzKihbJyJdKVw3KS4rPyhcJFthLXpfMC=5XSspXHMqPVxzKlw5XChbXjtdKztccypwcmVnX21hdGNoXChbXlxuXStcMTFbLFxzXSsoXCRbYS16XzAtOV=rKS4rP2Z3cml=ZVwoW15cbl=rXDEyW15cbl=rO1xzKmZjbG9zZVwoW15cbl=rO1xzKmluY2x1ZGUoX29uY2UpP1tcKFxzXSsoW15cKV=rKVtcKTtcc1=rKCh1bmxpbmtbXChcc1=rXDE=fFwzXHMqPXxcNlxzKj=pW147XSo7W1x9XHNdKyl7Myx9L2lzIjt9czo1OToicGhwIHNlc3Npb25fc3RhcnQgaGVhZGVyIF9SRVFVRVNUIGZ1bmN=aW9uIG1haWwgY3VybCByZXR1cm4iO2E6Mjp7aTowO3M6NToiS=FUR=siO2k6MTtzOjUxMjoiLzxcP1twaFxzXSooPz=oLipccyopKz9mdW5jdGlvbiAoW2Etel8wLTldKylcKCkoKChpbmlfc2V=fHNlc3Npb25fc3RhcnR8aGVhZGVyfFwyKVwoW147XSs7XHMqfCgoW2Vsc1xzXSppZnxpc3NldHxmb3JlYWNoKVtcc1woXSspK1wkXyhSRVFVRVNUfEdFVHxQT1NUfFNFUlZFUikuW15ce1=rXHtccyopPygoXCRbYS16XzAtOV=rKVtcc1wuXSo9W147XSpbO1xzXSsoXHMqZXhpdDspP3xcL1wvLitcbispKltcfVxzXSopKyhmdW5jdGlvbiBbYS16XzAtOV=rXChbXlx7XStce1xzKigoXCRbMC=5X2Etel=rKVtcc1wuXSo9W147XSs7XHMqfChpZltcc1woXSt8ZWxzZSkrW15ce1=qW1x7XHNdK3xcfVxzKikqKCgoXCRbYS16XzAtOV=rKVxzKj1ccyopKihtYWlsfGN1cmxfW2Etel=rKVxzKlwoW147XStbXCk7XHNcfV=qKChcJFthLXpfMC=5XSspW1xzXC5dKj=uKztccyp8cmV=dXJuW147XSo7XHMqfChpZltcc1woXSt8ZWxzZSkrW15ce1=qW1x7XHNdK3xcfVxzKnxcL1wvLipccyopKikrKSsoJHxcPz4pL2kiO31zOjM1OiJwaHAgZ29=byBWYXJpYWJsZSBGdW5jdGlvbiBfUkVRVUVTVCI7YToyOntpOjA7czo1OiJLQjZLSiI7aToxO3M6MTk=OiIvPFw_W3BoXHNdKihnb3RvIFthLXpfMC=5XSs7XHMqfFthLXpfMC=5XSs6W147XSs7W1xzXH1dKikrW2Etel8wLTldKzpccypyZWdpc3Rlcl9zaHV=ZG93bl9mdW5jdGlvblwoKFwkW2Etel8wLTldK1xzKlwoWydccywiXSp8XCRfKFJFUVVFU3xHRXxQT1MpVCl7Mix9XFsoWyciXSkoXFxbeDAtOV=rKStcNFxdW1wpXHM7XH1dKygkfFw_PikvaSI7fX1zOjg6InRpbXRodW1iIjthOjE6e3M6Mjk6Im91dGRhdGVkIHZlcnNpb25zIG9mIFRpbVRodW1iIjthOjI6e2k6MDtzOjU6IkgxUUpFIjtpOjE7czo2MDoiLy4rVGltVGh1bWIuK2RlZmluZVxzKlwoW1xzJyJdK1ZFUlNJT=5bXHMnIl=rLFtccyciXSsxXC4uKy9zIjt9fXM6OToid2hpdGVsaXN=IjthOjI6e3M6MzoicGhwIjthOjI4OntpOjA7czo1OiJGQThIZCI7czozODoiNTg3M2NkMWNlYTYxMDgyMDJkMjEzNDdmMDFmMDRkY2ZPODE3MjgiO3M6NToiRDc1OXAiO3M6Mzk6IjAxMzYzNzI4Yzg=M2ZmOTNlOTZiNjk4M2NlMzhlYmE2TzE5NTYxOCI7czo1OiJENUE4MyI7czozODoiZDVmM2M5Y2FmZjE=ZDU3Yzg2MDhkNzhkYjAwOTRiZTBPNzM2NDMiO3M6NToiRDc1RDkiO3M6Mzg6IjU3YWY=OTgxOGJiYjk=OWRjMGFjNjM4NjczODY1NWJiTzI1ODUyIjtzOjU6IkQ3SkQ5IjtzOjM4OiJkNDk=MDQyNjBkNzlhNGNjMzc1NWMwMGY1NWRlMjA4OU8yNTY2MiI7czo1OiJEOFY4QSI7czozNzoiODY2MWZlMmJmYTU5OTVmNTQ2YTMzMDQ3ZTkwMzg1NmNPMTEzNiI7czo1OiJESUNGQyI7czozODoiODEyNWQ=MmM=YmU1NDNmODc=ZWE1ZjZhMWI1YmRlNTVPMjU4OTQiO3M6NToiRElDRkQiO3M6Mzk6ImVkZGI1ZmRhNzRkNDFkYmRhYzAxODE2NzUzNmQ4ZDUzTzIzMTMzOCI7czo1OiJESUNGRSI7czozODoiYzE1YTRkNWMzODM=NDRiOTVkMjg1NTlmODM=ODExMWRPMjI1ODgiO3M6NToiRTFSMnYiO3M6Mzg6ImUyMDgzOWM1NTlhNjZjN2NmNjI4NjUzYmEyNDg=ZWFlTzI2Mzk1IjtzOjU6IkUxUjJ4IjtzOjM4OiJmMzM4MmVjMTVjMDMwYmQzMmUyOTNmYWYzNDk3ZTI1M=8xMTIyNiI7czo1OiJFMjMwQyI7czozNzoiMjhhOTJmNDY=OThkMzJiOWE3NGM1ODQ3Zjc1YzkxMmVPNzM5OSI7czo1OiJFMjMwQyI7czozNzoiZjAwYWFmMDFmZjAyZDU3NTZjMjY3YmNmOTIwZTRjMjhPMTU=MCI7czo1OiJFMkFNZiI7czozODoiNTdjNjQ3ZDkzZmJkNDc4NjhiODdiOTIxYmVlNjNhZjhPMjYzNzYiO3M6NToiRTVFRG8iO3M6Mzk6IjhlMmFmNDg4NmRjODFhNWQ5Mjg5ODY1YmJiODEzZWQxTzE5NTYxNyI7czo1OiJFNUlOUCI7czozNzoiZjgwZDllZjRiN2JmZDllZjU=MmQ5MDg3YTFkYjJhZTlPMjAxMCI7czo1OiJFN=VNdiI7czozODoiNWY5MjdmM2E5NzMyMThkMDdlNDNlYTFjNjlmYzAzMzFPMjY3NzYiO3M6NToiRUE2NmwiO3M6Mzg6ImE1YjFhNzNlMGM=Mjk4OTUwNzUwYThiY2Q5NjI3ZWFmTzI2ODExIjtzOjU6IkVDQ=UwIjtzOjM3OiI2NDk=NGUyMjUxMTNiZTE4Mzk=ZDViYzAxZmIzYjUzN=83NTMwIjtzOjU6IkVDQ=UzIjtzOjM4OiI5N2U=MzhkNmM5YzY=YTIwMmI5MzA3ODZkMjc2MjA1Yk82MjQ1OCI7czo1OiJFQ=NFMyI7czozODoiNjdlYzFiMTUzY2MzZjNlMzZmYmVlNTkwMjlhOTNkNGFPMjU5MTQiO3M6NToiRUNKS=YiO3M6Mzc6IjgzNjY1N2RiYTVjYjIyOTAwMDAyNDQ3NzY2MGU5ZGRmTzgzNjkiO3M6NToiRjQzNzMiO3M6Mzg6ImY2MDA3OWZlYzBlNWQ=ZDY3ZTQ5YWRhMzM2ZGFhZjkyTzI2ODEwIjtzOjU6IkY=Mzc=IjtzOjM5OiIwM2IyMWZmYzljNzljZmI2MjQ3OTBiMGJhNDg=NjkxY=8zMjAzMzIiO3M6NToiRjVMTWIiO3M6Mzg6IjVlNjg1NWNmMDJjNGFhMGFjYzg3MDBmN2Y2MTNkZjAwTzYwMTYzIjtzOjU6IkY2RkplIjtzOjM3OiI3MWNkMTY=ODBhZGQyMGY1MTZmNDFjZjA=NTc1ZmIxOE8xODg=IjtzOjU6IkY5QTl=IjtzOjM5OiI4MzRkMjJmOGI2OGEyYzVjMDE4NjZhNDNlYjI=ZWZjNE8xOTU3MDIiO3M6NToiRkE4SGQiO31zOjI6ImpzIjthOjM=OntpOjA7czo1OiJGOUFBQiI7czozNzoiNTU=YmM3NmM3MDM1MTE4N2Y=Y2UwNWRkYzAxMmFhZWRPNDc3NiI7czo1OiJENjY3WCI7czozNzoiOWE5YzEyNTgxNGI5NzE1OTgyZDI=NmExZWU3ODA4NGZPNTM=NSI7czo1OiJENjY3WCI7czozODoiZTM2YTA4NjEyMzc1NjQxMjI5MzIzMWFlYWQxN2YyNGZPMzc2MjkiO3M6NToiRDc1QUgiO3M6Mzc6ImEzOGFjNTI2NjkyNDkzOGE=ZmY1NTE=MzY5YzZiNDBkTzQ2NzQiO3M6NToiRDc1QUoiO3M6Mzc6IjEwNDNhMWQ3ZDg=ZWU1NmY4ODMxYTYwY2RmYzVkYzI4TzcwNzciO3M6NToiRDc1RFMiO3M6Mzg6IjZlYzE1MGI3OTg3Y2FhZWY5OGI1OWM4N2I5ZjQ3MWJlTzExODQyIjtzOjU6IkUxUjJuIjtzOjM4OiI2MTQ3Y2NlZTdhZWY5ZGMwYzZlYjEwZDhkN2IzMTFmOU83MDg4MyI7czo1OiJFMVIydyI7czozNzoiYmEzMjkzOTcwZTEzYjAzYTJlYTkyZjViNmI1YmY1NDRPMzM3NyI7czo1OiJFMjJOcSI7czozNzoiNjNiMGFlZDliMDJmODc5YTZlMDI5NWZiZWE3ZGI4NTRPNDcwMiI7czo1OiJFMjMwRCI7czozNzoiZWY=MTg4Y2IwYjYwYTcyMDE3ZjRjOGExZTg=MGFiMWVPMjk1MCI7czo1OiJFMjQ5TCI7czozNzoiZmI4YmY2Nzg1ZTU1ZTllMzliZWE1NTI2MzVjNDJhNjRPMzI3MCI7czo1OiJFMjYwQyI7czozOToiYWNiMzMzMjliOWVmOGFhYmQ4YmQ3MzE=MjY4MDNlNGVPMjMyNDgyIjtzOjU6IkUyNjBFIjtzOjM4OiI2Y2ViNjQ3NTkyNTg4YmNmNDYzYmVmZDk=MDhlMjdhZE8xMjAyNSI7czo1OiJFMjYwSCI7czozNzoiNWEzMTgyNzdmZWRmNDkxYTAzMDFlMTc3YTllZjEwYjNPNDkwOCI7czo1OiJFMjYwSiI7czozODoiZGJjMzgwODQ3M2RlZjAwZmNlNDVmZTU2NGRjNzJkY2JPMTQ3MjAiO3M6NToiRTI2MEsiO3M6Mzc6ImI5ODlhNWJkODRmNmViY2JjMTM5M2VjMDAzZTZlOTkxTzQ5NjkiO3M6NToiRTI3RUciO3M6Mzg6IjAzMGI4Mzg5Mzc2YTQyZmYzZGExODZiZjY1ODA2MjE3TzE2NTMxIjtzOjU6IkUyOUQyIjtzOjM3OiJkZWYyNTdkYmIwYWI4MDVjNDk5NmZkOGFiYjFhNmI=OU82NzE3IjtzOjU6IkUySDVuIjtzOjM4OiI3NGQ5MDMwNDk2ODNlNWJiZWE5Y2NiNzU=NGE=MmJjYU8xNzQxMyI7czo1OiJFNUVEcSI7czozODoiNjAzYmQxNDI5OWY2MWE3MzI5YjJkMzUzYjJiNTZjMmZPMzc2ODkiO3M6NToiRTVFRHAiO3M6Mzc6IjA=MjZiMzk3NTRhYTZiYzc2NmQ4OWVhNGM=MWJiZDA2TzM=NTciO3M6NToiRTVFRHgiO3M6Mzg6ImVhZGM1ODMyNTEzZDU2NzA4ODRhOTc1YzZkZTEwZjAxTzE5NjE1IjtzOjU6IkU3VU1BIjtzOjM4OiIzOGRiY2M5MjU1MjkzNjg4MTJmNWMyZmJjYjM4OTYxNk8xNDk2NSI7czo1OiJFN1VNQiI7czozNzoiYTFjMTgyMjdlNmU5Mzc5OGM=OTNhZWQ5NmVlNmNjODRPMzI2NyI7czo1OiJFN1VNQiI7czozNzoiMDc4Mzg4YTY=MzFhYTViMDgzOGE4NzMyZDE4N2ZlMjlPODkxMyI7czo1OiJFOEFBcCI7czozNzoiZjNiMWIyODQyNDM2ZjdhMzExYjM5ZTRlZjRiNDdmNTlPNDM1MiI7czo1OiJFOEJCVSI7czozNzoiZDcwOTQwNjE5YTk5ZDU1NTExNjE2N2Q=ZmIzOWNhMTVPNDM5NyI7czo1OiJFOUNMeCI7czozODoiY2JkYmZjOTE4NGQyOGFjNTVmODNjMGIwZGY=MGZkNDNPNzk=MTQiO3M6NToiRTlHOGoiO3M6Mzg6ImVmM2FlOTAxNDUyNWNmODExODdhZmFhNjFiY2E3MzdlTzM3NjkxIjtzOjU6IkVDQ=UxIjtzOjM4OiJmNDQ4YzU5M2MyNDJkMTM=ZTk3MzNhODRjN2E=ZDI2Y=8xNTI=OCI7czo1OiJFQ=g5WCI7czozOToiNTFiYmEwZDUzMzNkZTRmZGEwOTU=ZjUxZWEzNTVhNTBPMTA2Nzk3IjtzOjU6IkYyQThVIjtzOjM4OiI2OTJmOGU4NjFiYWZhMzFmYmYxYjM4MDViNGIwZDdkM=8xNTAxNiI7czo1OiJGNDZJaCI7czozODoiZDg=MjMzZGQyOTM3MTdmMGEwN2I1NThiMmZlMzhmNTZPMTUwNTMiO3M6NToiRjlBQUIiO319czo4OiJ3cF9sb2dpbiI7YToxOntzOjM2OiJicnV=ZSBmb3JjZSBwb3NzaWJsZSBvbiB3cC1sb2dpbi5waHAiO2E6Mjp7aTowO3M6NToiRDRPQUIiO2k6MTtzOjE3NToiLy4qP3JlcXVpcmVcKFsgXHRdKmRpcm5hbWVcKF9fRklMRV9fXClbIFx=XSpcLlsgXHRdKlsiJ11cL3dwXC1sb2FkXC5waHBbIiddWyBcdF=qXCk7KD8hXC9cLzIwMTMtMDQtMjQgRE8gTk9UIFJFTU9WRSBUSElTIFJFUVVJUkVEIExJTkUpW15cbl=qKFtcclxuIFx=XSpcJF9TRVNTSU9OXFtbXjtdKzspKi9pcyI7fX1zOjM6InlvdSI7YTo=OntzOjE=OiJ1c2VyX2RvbmF=aW9ucyI7aTowO3M6MTk6InVzZXJfZG9uYXRpb25fdG9=YWwiO2k6MDtzOjIzOiJ1c2VyX2RvbmF=aW9uX2ZyZXNobmVzcyI7aTowO3M6MTA6InVzZXJfZW1haWwiO3M6MzI6IjZkYWM4ZTgwMTIxZDRmMDhiY2RmNjIyNjQ=NWQ4MWU4Ijt9fQ3", "yes");
INSERT INTO `abchrgrp_options` VALUES("17820", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-12-29 09:02:25\";s:7:\"Version\";s:6:\"1.3.40\";s:9:\"VersionWP\";s:5:\"5.5.3\";s:9:\"VersionDB\";s:6:\"5.6.50\";s:10:\"VersionPHP\";s:6:\"7.3.20\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:36:\"20201203_abchirgroupimportexportwhol\";s:4:\"Hash\";s:35:\"1ad52f01835d41883353_20201229090225\";s:8:\"NameHash\";s:72:\"20201203_abchirgroupimportexportwhol_1ad52f01835d41883353_20201229090225\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:82:\"20201203_abchirgroupimportexportwhol_1ad52f01835d41883353_20201229090225_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:28:\"/home/maento/www/abchirgroup\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-12-29 09:02:25\";s:7:\"Version\";s:6:\"1.3.40\";s:9:\"VersionWP\";s:5:\"5.5.3\";s:9:\"VersionDB\";s:6:\"5.6.50\";s:10:\"VersionPHP\";s:6:\"7.3.20\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:36:\"20201203_abchirgroupimportexportwhol\";s:4:\"Hash\";s:35:\"1ad52f01835d41883353_20201229090225\";s:8:\"NameHash\";s:72:\"20201203_abchirgroupimportexportwhol_1ad52f01835d41883353_20201229090225\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:61;}s:8:\"Database\";O:12:\"DUP_Database\":14:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:61;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:61;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:37:\"/home/maento/www/abchirgroup/wp-admin\";i:1;s:47:\"/home/maento/www/abchirgroup/wp-content/uploads\";i:2;s:49:\"/home/maento/www/abchirgroup/wp-content/languages\";i:3;s:46:\"/home/maento/www/abchirgroup/wp-content/themes\";i:4;s:40:\"/home/maento/www/abchirgroup/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:28:\"/home/maento/www/abchirgroup\";i:1;s:39:\"/home/maento/www/abchirgroup/wp-content\";}}s:9:\"Installer\";r:82;s:8:\"Database\";r:96;s:13:\"BuildProgress\";r:126;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17853", "db_upgraded", "", "yes");
INSERT INTO `abchrgrp_options` VALUES("17891", "wp-optimize-retention-enabled", "false", "yes");
INSERT INTO `abchrgrp_options` VALUES("17892", "wp-optimize-retention-period", "2", "yes");
INSERT INTO `abchrgrp_options` VALUES("17893", "wp-optimize-enable-admin-menu", "false", "yes");
INSERT INTO `abchrgrp_options` VALUES("18125", "wp-optimize-install-or-update-notice-version", "1.1", "yes");
INSERT INTO `abchrgrp_options` VALUES("17888", "wp-optimize-schedule", "false", "yes");
INSERT INTO `abchrgrp_options` VALUES("17889", "wp-optimize-last-optimized", "Never", "yes");
INSERT INTO `abchrgrp_options` VALUES("17890", "wp-optimize-schedule-type", "wpo_weekly", "yes");
INSERT INTO `abchrgrp_options` VALUES("17894", "wp-optimize-total-cleaned", "0", "yes");
INSERT INTO `abchrgrp_options` VALUES("17895", "wp-optimize-auto", "a:7:{s:5:\"spams\";s:4:\"true\";s:8:\"optimize\";s:5:\"false\";s:9:\"transient\";s:5:\"false\";s:10:\"unapproved\";s:5:\"false\";s:6:\"drafts\";s:4:\"true\";s:9:\"revisions\";s:4:\"true\";s:5:\"trash\";s:4:\"true\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17896", "wp-optimize-settings", "a:16:{s:16:\"user-commentmeta\";s:5:\"false\";s:10:\"user-spams\";s:4:\"true\";s:16:\"user-attachments\";s:5:\"false\";s:13:\"user-optimize\";s:4:\"true\";s:14:\"user-transient\";s:5:\"false\";s:15:\"user-unapproved\";s:4:\"true\";s:17:\"user-repairtables\";s:4:\"true\";s:11:\"user-drafts\";s:4:\"true\";s:15:\"user-orphandata\";s:5:\"false\";s:13:\"user-postmeta\";s:5:\"false\";s:19:\"user-orphanedtables\";s:4:\"true\";s:14:\"user-revisions\";s:4:\"true\";s:14:\"user-pingbacks\";s:5:\"false\";s:15:\"user-trackbacks\";s:5:\"false\";s:10:\"user-trash\";s:4:\"true\";s:13:\"last_saved_in\";s:5:\"3.1.4\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17897", "wpo_minify_config", "a:48:{s:5:\"debug\";b:0;s:19:\"enabled_css_preload\";b:0;s:18:\"enabled_js_preload\";b:0;s:11:\"hpreconnect\";s:0:\"\";s:8:\"hpreload\";s:0:\"\";s:7:\"loadcss\";b:0;s:10:\"remove_css\";b:0;s:17:\"critical_path_css\";s:0:\"\";s:31:\"critical_path_css_is_front_page\";s:0:\"\";s:30:\"preserve_settings_on_uninstall\";b:1;s:22:\"disable_when_logged_in\";b:0;s:16:\"default_protocol\";s:7:\"dynamic\";s:17:\"html_minification\";b:1;s:16:\"clean_header_one\";b:0;s:13:\"emoji_removal\";b:1;s:18:\"merge_google_fonts\";b:1;s:19:\"enable_display_swap\";b:1;s:18:\"remove_googlefonts\";b:0;s:13:\"gfonts_method\";s:6:\"inline\";s:15:\"fawesome_method\";s:6:\"inline\";s:10:\"enable_css\";b:1;s:23:\"enable_css_minification\";b:1;s:21:\"enable_merging_of_css\";b:1;s:23:\"remove_print_mediatypes\";b:0;s:10:\"inline_css\";b:0;s:9:\"enable_js\";b:1;s:22:\"enable_js_minification\";b:1;s:20:\"enable_merging_of_js\";b:1;s:15:\"enable_defer_js\";s:10:\"individual\";s:13:\"defer_js_type\";s:5:\"defer\";s:12:\"defer_jquery\";b:1;s:18:\"enable_js_trycatch\";b:0;s:19:\"exclude_defer_login\";b:1;s:7:\"cdn_url\";s:0:\"\";s:9:\"cdn_force\";b:0;s:9:\"async_css\";s:0:\"\";s:8:\"async_js\";s:0:\"\";s:24:\"disable_css_inline_merge\";b:1;s:6:\"ualist\";a:8:{i:0;s:12:\"x11.*fox\\/54\";i:1;s:20:\"oid\\s4.*xus.*ome\\/62\";i:2;s:12:\"x11.*ome\\/62\";i:3;s:5:\"oobot\";i:4;s:5:\"ighth\";i:5;s:5:\"tmetr\";i:6;s:6:\"eadles\";i:7;s:5:\"ingdo\";}s:9:\"blacklist\";a:0:{}s:11:\"ignore_list\";a:0:{}s:10:\"exclude_js\";s:0:\"\";s:11:\"exclude_css\";s:0:\"\";s:23:\"edit_default_exclutions\";b:0;s:18:\"merge_allowed_urls\";s:0:\"\";s:7:\"enabled\";b:0;s:17:\"last-cache-update\";i:1609263969;s:14:\"plugin_version\";s:5:\"0.0.0\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("18308", "bulletproof_security_options_php_memory_limit", "a:1:{s:20:\"bps_php_memory_limit\";s:4:\"512M\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17899", "wpo_update_version", "3.1.6", "yes");
INSERT INTO `abchrgrp_options` VALUES("17917", "wp-optimize-completed_task_count", "103", "yes");
INSERT INTO `abchrgrp_options` VALUES("17903", "updraft_unlocked_wpo_cache_preloader_creating_tasks", "1", "no");
INSERT INTO `abchrgrp_options` VALUES("17904", "updraft_last_lock_time_wpo_cache_preloader_creating_tasks", "2021-11-28 18:53:57", "no");
INSERT INTO `abchrgrp_options` VALUES("17905", "updraft_semaphore_wpo_cache_preloader_creating_tasks", "0", "no");
INSERT INTO `abchrgrp_options` VALUES("17906", "wp-optimize-is_gzip_compression_enabled", "gzip", "yes");
INSERT INTO `abchrgrp_options` VALUES("17909", "wp-optimize-corrupted-tables-count", "0", "yes");
INSERT INTO `abchrgrp_options` VALUES("17829", "bulletproof_security_options_MScan", "a:10:{s:14:\"bps_mscan_dirs\";a:3:{s:8:\"wp-admin\";s:1:\"1\";s:10:\"wp-content\";s:1:\"1\";s:11:\"wp-includes\";s:1:\"1\";}s:19:\"mscan_max_file_size\";s:3:\"400\";s:20:\"mscan_max_time_limit\";s:3:\"300\";s:19:\"mscan_scan_database\";s:2:\"On\";s:17:\"mscan_scan_images\";s:3:\"Off\";s:24:\"mscan_scan_skipped_files\";s:3:\"Off\";s:27:\"mscan_scan_delete_tmp_files\";s:3:\"Off\";s:20:\"mscan_scan_frequency\";s:3:\"Off\";s:18:\"mscan_exclude_dirs\";s:0:\"\";s:23:\"mscan_exclude_tmp_files\";s:0:\"\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17830", "bulletproof_security_options_MScan_status", "a:17:{s:20:\"bps_mscan_time_start\";s:10:\"1607017305\";s:19:\"bps_mscan_time_stop\";s:0:\"\";s:18:\"bps_mscan_time_end\";s:10:\"1607017314\";s:24:\"bps_mscan_time_remaining\";s:10:\"1607017342\";s:16:\"bps_mscan_status\";s:1:\"4\";s:29:\"bps_mscan_last_scan_timestamp\";s:24:\"December 3, 2020 5:41 pm\";s:20:\"bps_mscan_total_time\";s:1:\"9\";s:29:\"bps_mscan_total_website_files\";s:4:\"2649\";s:29:\"bps_mscan_total_wp_core_files\";s:4:\"1313\";s:31:\"bps_mscan_total_non_image_files\";s:1:\"1\";s:27:\"bps_mscan_total_image_files\";s:1:\"0\";s:35:\"bps_mscan_total_all_scannable_files\";s:4:\"1314\";s:29:\"bps_mscan_total_skipped_files\";s:3:\"593\";s:29:\"bps_mscan_total_suspect_files\";s:1:\"0\";s:31:\"bps_mscan_suspect_skipped_files\";s:1:\"0\";s:26:\"bps_mscan_total_suspect_db\";s:1:\"0\";s:29:\"bps_mscan_total_ignored_files\";s:1:\"0\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17834", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17835", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17836", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17837", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17838", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17840", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17846", "wp_page_for_privacy_policy", "0", "yes");
INSERT INTO `abchrgrp_options` VALUES("17847", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `abchrgrp_options` VALUES("17848", "admin_email_lifespan", "1622569385", "yes");
INSERT INTO `abchrgrp_options` VALUES("17849", "disallowed_keys", "", "no");
INSERT INTO `abchrgrp_options` VALUES("17850", "comment_previously_approved", "1", "yes");
INSERT INTO `abchrgrp_options` VALUES("17851", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `abchrgrp_options` VALUES("18305", "can_compress_scripts", "0", "no");
INSERT INTO `abchrgrp_options` VALUES("17881", "WPLANG", "", "yes");
INSERT INTO `abchrgrp_options` VALUES("17882", "new_admin_email", "omar.jallouli@gmail.com", "yes");
INSERT INTO `abchrgrp_options` VALUES("17898", "updraft_task_manager_dbversion", "1.1", "yes");
INSERT INTO `abchrgrp_options` VALUES("17912", "wpo_cache_config", "a:16:{s:19:\"enable_page_caching\";b:1;s:23:\"page_cache_length_value\";i:60;s:22:\"page_cache_length_unit\";s:4:\"days\";s:17:\"page_cache_length\";i:5184000;s:20:\"cache_exception_urls\";a:1:{i:0;s:0:\"\";}s:23:\"cache_exception_cookies\";a:1:{i:0;s:0:\"\";}s:30:\"cache_exception_browser_agents\";a:1:{i:0;s:0:\"\";}s:22:\"enable_sitemap_preload\";b:0;s:23:\"enable_schedule_preload\";s:1:\"1\";s:21:\"preload_schedule_type\";s:22:\"wpo_use_cache_lifespan\";s:21:\"enable_mobile_caching\";s:1:\"0\";s:19:\"enable_user_caching\";s:1:\"0\";s:8:\"site_url\";s:28:\"https://www.abchirgroup.com/\";s:24:\"enable_cache_per_country\";b:0;s:17:\"wpo_cache_cookies\";a:0:{}s:25:\"wpo_cache_query_variables\";a:0:{}}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17913", "wp-optimize-wpo_last_page_cache_preload_type", "posts", "yes");
INSERT INTO `abchrgrp_options` VALUES("17926", "wp-optimize-wpo_last_page_cache_preload", "1638125649", "yes");
INSERT INTO `abchrgrp_options` VALUES("17928", "wp-optimize-browser_cache_expire_days", "30", "yes");
INSERT INTO `abchrgrp_options` VALUES("17929", "wp-optimize-browser_cache_expire_hours", "0", "yes");
INSERT INTO `abchrgrp_options` VALUES("17930", "bulletproof_security_options_theme_skin", "a:1:{s:17:\"bps_ui_theme_skin\";s:4:\"blue\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17918", "wp-optimize-total_bytes_saved", "0", "yes");
INSERT INTO `abchrgrp_options` VALUES("17919", "wp-optimize-total_percent_saved", "0", "yes");
INSERT INTO `abchrgrp_options` VALUES("17931", "bulletproof_security_options_status_display", "a:1:{s:18:\"bps_status_display\";s:2:\"On\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17932", "bulletproof_security_options_spinner", "a:1:{s:11:\"bps_spinner\";s:2:\"On\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17933", "bulletproof_security_options_scrolltop", "a:1:{s:13:\"bps_scrolltop\";s:2:\"On\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17934", "bulletproof_security_options_wpt_nodes", "a:1:{s:13:\"bps_wpt_nodes\";s:8:\"allnodes\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17935", "bulletproof_security_options_SLF", "a:2:{s:14:\"bps_slf_filter\";s:2:\"On\";s:18:\"bps_slf_filter_new\";s:2:\"14\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17936", "bulletproof_security_options_debug", "a:1:{s:9:\"bps_debug\";s:3:\"Off\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17937", "bulletproof_security_options_gdpr", "a:1:{s:15:\"bps_gdpr_on_off\";s:3:\"Off\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17938", "bulletproof_security_options_GDMW", "a:1:{s:16:\"bps_gdmw_hosting\";s:2:\"no\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17939", "bulletproof_security_options_htaccess_files", "a:1:{s:18:\"bps_htaccess_files\";s:7:\"enabled\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17940", "bulletproof_security_options_htaccess_res", "a:1:{s:23:\"bps_wpadmin_restriction\";s:7:\"enabled\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17941", "bulletproof_security_options_zip_fix", "a:1:{s:20:\"bps_zip_download_fix\";s:3:\"Off\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17942", "bulletproof_security_options_mu_sysinfo", "a:1:{s:24:\"bps_sysinfo_hide_display\";s:7:\"display\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17943", "bulletproof_security_options_rate_free", "a:1:{s:20:\"bps_free_rate_review\";s:10:\"1609718400\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17944", "bulletproof_security_options_customcode", "a:14:{s:18:\"bps_customcode_one\";s:0:\"\";s:31:\"bps_customcode_server_signature\";s:0:\"\";s:30:\"bps_customcode_directory_index\";s:0:\"\";s:30:\"bps_customcode_server_protocol\";s:0:\"\";s:28:\"bps_customcode_error_logging\";s:0:\"\";s:31:\"bps_customcode_deny_dot_folders\";s:0:\"\";s:29:\"bps_customcode_admin_includes\";s:0:\"\";s:31:\"bps_customcode_wp_rewrite_start\";s:0:\"\";s:30:\"bps_customcode_request_methods\";s:0:\"\";s:18:\"bps_customcode_two\";s:0:\"\";s:28:\"bps_customcode_timthumb_misc\";s:1187:\"# TIMTHUMB FORBID RFI and MISC FILE SKIP/BYPASS RULE\n# Use BPS Custom Code to modify/edit/change this code and to save it permanently.\n# Remote File Inclusion (RFI) security rules\n# Note: Only whitelist your additional domains or files if needed - do not whitelist hacker domains or files\nRewriteCond %{QUERY_STRING} ^.*(http|https|ftp)(%3A|:)(%2F|/)(%2F|/)(w){0,3}.?(blogger|picasa|blogspot|tsunami|petapolitik|photobucket|imgur|imageshack|wordpress\\.com|img\\.youtube|tinypic\\.com|upload\\.wikimedia|kkc|start-thegame).*$ [NC,OR]\nRewriteCond %{THE_REQUEST} ^.*(http|https|ftp)(%3A|:)(%2F|/)(%2F|/)(w){0,3}.?(blogger|picasa|blogspot|tsunami|petapolitik|photobucket|imgur|imageshack|wordpress\\.com|img\\.youtube|tinypic\\.com|upload\\.wikimedia|kkc|start-thegame).*$ [NC]\nRewriteRule .* index.php [F]\n# \n# Example: Whitelist additional misc files: (example\\.php|another-file\\.php|phpthumb\\.php|thumb\\.php|thumbs\\.php)\nRewriteCond %{REQUEST_URI} (timthumb\\.php|phpthumb\\.php|thumb\\.php|thumbs\\.php) [NC]\n# Example: Whitelist additional website domains: RewriteCond %{HTTP_REFERER} ^.*(YourWebsite.com|AnotherWebsite.com).*\nRewriteCond %{HTTP_REFERER} ^.*abchirgroup.com.*\nRewriteRule . - [S=1]\";s:21:\"bps_customcode_bpsqse\";s:3814:\"# BEGIN BPSQSE BPS QUERY STRING EXPLOITS\n# The libwww-perl User Agent is forbidden - Many bad bots use libwww-perl modules, but some good bots use it too.\n# Good sites such as W3C use it for their W3C-LinkChecker. \n# Use BPS Custom Code to add or remove user agents temporarily or permanently from the \n# User Agent filters directly below or to modify/edit/change any of the other security code rules below.\nRewriteCond %{HTTP_USER_AGENT} (havij|libwww-perl|wget|python|nikto|curl|scan|java|winhttp|clshttp|loader) [NC,OR]\nRewriteCond %{HTTP_USER_AGENT} (%0A|%0D|%27|%3C|%3E|%00) [NC,OR]\nRewriteCond %{HTTP_USER_AGENT} (;|&lt;|&gt;|&#039;|&quot;|\\)|\\(|%0A|%0D|%22|%27|%28|%3C|%3E|%00).*(libwww-perl|wget|python|nikto|curl|scan|java|winhttp|HTTrack|clshttp|archiver|loader|email|harvest|extract|grab|miner) [NC,OR]\nRewriteCond %{THE_REQUEST} (\\?|\\*|%2a)+(%20+|\\\\s+|%20+\\\\s+|\\\\s+%20+|\\\\s+%20+\\\\s+)(http|https)(:/|/) [NC,OR]\nRewriteCond %{THE_REQUEST} etc/passwd [NC,OR]\nRewriteCond %{THE_REQUEST} cgi-bin [NC,OR]\nRewriteCond %{THE_REQUEST} (%0A|%0D|\\\\r|\\\\n) [NC,OR]\nRewriteCond %{REQUEST_URI} owssvr\\.dll [NC,OR]\nRewriteCond %{HTTP_REFERER} (%0A|%0D|%27|%3C|%3E|%00) [NC,OR]\nRewriteCond %{HTTP_REFERER} \\.opendirviewer\\. [NC,OR]\nRewriteCond %{HTTP_REFERER} users\\.skynet\\.be.* [NC,OR]\nRewriteCond %{QUERY_STRING} [a-zA-Z0-9_]=(http|https):// [NC,OR]\nRewriteCond %{QUERY_STRING} [a-zA-Z0-9_]=(\\.\\.//?)+ [NC,OR]\nRewriteCond %{QUERY_STRING} [a-zA-Z0-9_]=/([a-z0-9_.]//?)+ [NC,OR]\nRewriteCond %{QUERY_STRING} \\=PHP[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12} [NC,OR]\nRewriteCond %{QUERY_STRING} (\\.\\./|%2e%2e%2f|%2e%2e/|\\.\\.%2f|%2e\\.%2f|%2e\\./|\\.%2e%2f|\\.%2e/) [NC,OR]\nRewriteCond %{QUERY_STRING} ftp\\: [NC,OR]\nRewriteCond %{QUERY_STRING} (http|https)\\: [NC,OR] \nRewriteCond %{QUERY_STRING} \\=\\|w\\| [NC,OR]\nRewriteCond %{QUERY_STRING} ^(.*)/self/(.*)$ [NC,OR]\nRewriteCond %{QUERY_STRING} ^(.*)cPath=(http|https)://(.*)$ [NC,OR]\nRewriteCond %{QUERY_STRING} (\\&lt;|%3C).*script.*(\\&gt;|%3E) [NC,OR]\nRewriteCond %{QUERY_STRING} (&lt;|%3C)([^s]*s)+cript.*(&gt;|%3E) [NC,OR]\nRewriteCond %{QUERY_STRING} (\\&lt;|%3C).*embed.*(\\&gt;|%3E) [NC,OR]\nRewriteCond %{QUERY_STRING} (&lt;|%3C)([^e]*e)+mbed.*(&gt;|%3E) [NC,OR]\nRewriteCond %{QUERY_STRING} (\\&lt;|%3C).*object.*(\\&gt;|%3E) [NC,OR]\nRewriteCond %{QUERY_STRING} (&lt;|%3C)([^o]*o)+bject.*(&gt;|%3E) [NC,OR]\nRewriteCond %{QUERY_STRING} (\\&lt;|%3C).*iframe.*(\\&gt;|%3E) [NC,OR]\nRewriteCond %{QUERY_STRING} (&lt;|%3C)([^i]*i)+frame.*(&gt;|%3E) [NC,OR] \nRewriteCond %{QUERY_STRING} base64_encode.*\\(.*\\) [NC,OR]\nRewriteCond %{QUERY_STRING} base64_(en|de)code[^(]*\\([^)]*\\) [NC,OR]\nRewriteCond %{QUERY_STRING} GLOBALS(=|\\[|\\%[0-9A-Z]{0,2}) [OR]\nRewriteCond %{QUERY_STRING} _REQUEST(=|\\[|\\%[0-9A-Z]{0,2}) [OR]\nRewriteCond %{QUERY_STRING} ^.*(\\(|\\)|&lt;|&gt;|%3c|%3e).* [NC,OR]\nRewriteCond %{QUERY_STRING} ^.*(\\x00|\\x04|\\x08|\\x0d|\\x1b|\\x20|\\x3c|\\x3e|\\x7f).* [NC,OR]\nRewriteCond %{QUERY_STRING} (NULL|OUTFILE|LOAD_FILE) [OR]\nRewriteCond %{QUERY_STRING} (\\.{1,}/)+(motd|etc|bin) [NC,OR]\nRewriteCond %{QUERY_STRING} (localhost|loopback|127\\.0\\.0\\.1) [NC,OR]\nRewriteCond %{QUERY_STRING} (&lt;|&gt;|&#039;|%0A|%0D|%27|%3C|%3E|%00) [NC,OR]\nRewriteCond %{QUERY_STRING} concat[^\\(]*\\( [NC,OR]\nRewriteCond %{QUERY_STRING} union([^s]*s)+elect [NC,OR]\nRewriteCond %{QUERY_STRING} union([^a]*a)+ll([^s]*s)+elect [NC,OR]\nRewriteCond %{QUERY_STRING} \\-[sdcr].*(allow_url_include|allow_url_fopen|safe_mode|disable_functions|auto_prepend_file) [NC,OR]\nRewriteCond %{QUERY_STRING} (;|&lt;|&gt;|&#039;|&quot;|\\)|%0A|%0D|%22|%27|%3C|%3E|%00).*(/\\*|union|select|insert|drop|delete|update|cast|create|char|convert|alter|declare|order|script|set|md5|benchmark|encode) [NC,OR]\nRewriteCond %{QUERY_STRING} (sp_executesql) [NC]\nRewriteRule ^(.*)$ - [F]\n# END BPSQSE BPS QUERY STRING EXPLOITS\";s:25:\"bps_customcode_deny_files\";s:0:\"\";s:20:\"bps_customcode_three\";s:0:\"\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17945", "bulletproof_security_options_customcode_WPA", "a:4:{s:29:\"bps_customcode_deny_files_wpa\";s:0:\"\";s:22:\"bps_customcode_one_wpa\";s:0:\"\";s:22:\"bps_customcode_two_wpa\";s:0:\"\";s:25:\"bps_customcode_bpsqse_wpa\";s:3007:\"# BEGIN BPSQSE-check BPS QUERY STRING EXPLOITS AND FILTERS\n# WORDPRESS WILL BREAK IF ALL THE BPSQSE FILTERS ARE DELETED\n# Use BPS wp-admin Custom Code to modify/edit/change this code and to save it permanently.\nRewriteCond %{HTTP_USER_AGENT} (%0A|%0D|%27|%3C|%3E|%00) [NC,OR]\nRewriteCond %{HTTP_USER_AGENT} (;|&lt;|&gt;|&#039;|&quot;|\\)|\\(|%0A|%0D|%22|%27|%28|%3C|%3E|%00).*(libwww-perl|wget|python|nikto|curl|scan|java|winhttp|HTTrack|clshttp|archiver|loader|email|harvest|extract|grab|miner) [NC,OR]\nRewriteCond %{THE_REQUEST} (\\?|\\*|%2a)+(%20+|\\\\s+|%20+\\\\s+|\\\\s+%20+|\\\\s+%20+\\\\s+)(http|https)(:/|/) [NC,OR]\nRewriteCond %{THE_REQUEST} etc/passwd [NC,OR]\nRewriteCond %{THE_REQUEST} cgi-bin [NC,OR]\nRewriteCond %{THE_REQUEST} (%0A|%0D) [NC,OR]\nRewriteCond %{REQUEST_URI} owssvr\\.dll [NC,OR]\nRewriteCond %{HTTP_REFERER} (%0A|%0D|%27|%3C|%3E|%00) [NC,OR]\nRewriteCond %{HTTP_REFERER} \\.opendirviewer\\. [NC,OR]\nRewriteCond %{HTTP_REFERER} users\\.skynet\\.be.* [NC,OR]\nRewriteCond %{QUERY_STRING} [a-zA-Z0-9_]=(http|https):// [NC,OR]\nRewriteCond %{QUERY_STRING} [a-zA-Z0-9_]=(\\.\\.//?)+ [NC,OR]\nRewriteCond %{QUERY_STRING} [a-zA-Z0-9_]=/([a-z0-9_.]//?)+ [NC,OR]\nRewriteCond %{QUERY_STRING} \\=PHP[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12} [NC,OR]\nRewriteCond %{QUERY_STRING} (\\.\\./|%2e%2e%2f|%2e%2e/|\\.\\.%2f|%2e\\.%2f|%2e\\./|\\.%2e%2f|\\.%2e/) [NC,OR]\nRewriteCond %{QUERY_STRING} ftp\\: [NC,OR]\nRewriteCond %{QUERY_STRING} (http|https)\\: [NC,OR] \nRewriteCond %{QUERY_STRING} \\=\\|w\\| [NC,OR]\nRewriteCond %{QUERY_STRING} ^(.*)/self/(.*)$ [NC,OR]\nRewriteCond %{QUERY_STRING} ^(.*)cPath=(http|https)://(.*)$ [NC,OR]\nRewriteCond %{QUERY_STRING} (\\&lt;|%3C).*script.*(\\&gt;|%3E) [NC,OR]\nRewriteCond %{QUERY_STRING} (&lt;|%3C)([^s]*s)+cript.*(&gt;|%3E) [NC,OR]\nRewriteCond %{QUERY_STRING} (\\&lt;|%3C).*iframe.*(\\&gt;|%3E) [NC,OR]\nRewriteCond %{QUERY_STRING} (&lt;|%3C)([^i]*i)+frame.*(&gt;|%3E) [NC,OR] \nRewriteCond %{QUERY_STRING} base64_encode.*\\(.*\\) [NC,OR]\nRewriteCond %{QUERY_STRING} base64_(en|de)code[^(]*\\([^)]*\\) [NC,OR]\nRewriteCond %{QUERY_STRING} GLOBALS(=|\\[|\\%[0-9A-Z]{0,2}) [OR]\nRewriteCond %{QUERY_STRING} _REQUEST(=|\\[|\\%[0-9A-Z]{0,2}) [OR]\nRewriteCond %{QUERY_STRING} ^.*(\\(|\\)|&lt;|&gt;).* [NC,OR]\nRewriteCond %{QUERY_STRING} (NULL|OUTFILE|LOAD_FILE) [OR]\nRewriteCond %{QUERY_STRING} (\\.{1,}/)+(motd|etc|bin) [NC,OR]\nRewriteCond %{QUERY_STRING} (localhost|loopback|127\\.0\\.0\\.1) [NC,OR]\nRewriteCond %{QUERY_STRING} (&lt;|&gt;|&#039;|%0A|%0D|%27|%3C|%3E|%00) [NC,OR]\nRewriteCond %{QUERY_STRING} concat[^\\(]*\\( [NC,OR]\nRewriteCond %{QUERY_STRING} union([^s]*s)+elect [NC,OR]\nRewriteCond %{QUERY_STRING} union([^a]*a)+ll([^s]*s)+elect [NC,OR]\nRewriteCond %{QUERY_STRING} (;|&lt;|&gt;|&#039;|&quot;|\\)|%0A|%0D|%22|%27|%3C|%3E|%00).*(/\\*|union|select|insert|drop|delete|update|cast|create|char|convert|alter|declare|order|script|set|md5|benchmark|encode) [NC,OR]\nRewriteCond %{QUERY_STRING} (sp_executesql) [NC]\nRewriteRule ^(.*)$ - [F]\n# END BPSQSE-check BPS QUERY STRING EXPLOITS AND FILTERS\n\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17946", "bulletproof_security_options_autolock", "a:1:{s:26:\"bps_root_htaccess_autolock\";s:3:\"Off\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17947", "bulletproof_security_options_MScan_log", "a:1:{s:22:\"bps_mscan_log_date_mod\";s:25:\"December 03 2020 17:41:54\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17948", "bulletproof_security_options_DBB_log", "a:1:{s:20:\"bps_dbb_log_date_mod\";s:25:\"November 16 2020 13:47:03\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17949", "bulletproof_security_options_hpf_cron", "a:4:{s:23:\"bps_hidden_plugins_cron\";s:2:\"On\";s:33:\"bps_hidden_plugins_cron_frequency\";s:2:\"15\";s:29:\"bps_hidden_plugins_cron_email\";s:0:\"\";s:29:\"bps_hidden_plugins_cron_alert\";s:0:\"\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17950", "bulletproof_security_options_hidden_plugins", "a:1:{s:24:\"bps_hidden_plugins_check\";s:0:\"\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17951", "bulletproof_security_options_sec_log_post_limit", "a:3:{s:27:\"bps_security_log_post_limit\";s:0:\"\";s:26:\"bps_security_log_post_none\";s:1:\"1\";s:25:\"bps_security_log_post_max\";s:0:\"\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17952", "bulletproof_security_options_email", "a:11:{s:17:\"bps_send_email_to\";s:23:\"omar.jallouli@gmail.com\";s:19:\"bps_send_email_from\";s:23:\"omar.jallouli@gmail.com\";s:17:\"bps_send_email_cc\";s:0:\"\";s:18:\"bps_send_email_bcc\";s:0:\"\";s:24:\"bps_login_security_email\";s:11:\"lockoutOnly\";s:21:\"bps_security_log_size\";s:5:\"500KB\";s:23:\"bps_security_log_emailL\";s:5:\"email\";s:17:\"bps_dbb_log_email\";s:5:\"email\";s:16:\"bps_dbb_log_size\";s:5:\"500KB\";s:18:\"bps_mscan_log_size\";s:5:\"500KB\";s:19:\"bps_mscan_log_email\";s:5:\"email\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("17953", "bulletproof_security_options_login_security", "a:11:{s:14:\"bps_max_logins\";s:1:\"3\";s:20:\"bps_lockout_duration\";s:2:\"15\";s:27:\"bps_manual_lockout_duration\";s:2:\"60\";s:23:\"bps_max_db_rows_display\";s:0:\"\";s:24:\"bps_login_security_OnOff\";s:2:\"On\";s:26:\"bps_login_security_logging\";s:11:\"logLockouts\";s:25:\"bps_login_security_errors\";s:8:\"wpErrors\";s:28:\"bps_login_security_remaining\";s:2:\"On\";s:27:\"bps_login_security_pw_reset\";s:6:\"enable\";s:23:\"bps_login_security_sort\";s:9:\"ascending\";s:26:\"bps_enable_lsm_woocommerce\";s:0:\"\";}", "yes");
INSERT INTO `abchrgrp_options` VALUES("18300", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `abchrgrp_options` VALUES("18301", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `abchrgrp_options` VALUES("18302", "auto_update_core_major", "unset", "yes");
INSERT INTO `abchrgrp_options` VALUES("17960", "secret_key", "+(>gBDU.,/X^.^Mf%4(8^+C@d`FcfNy#j.K*!{0izSmeSFt1AI6{O]Z<W&L-stM;", "no");

/* INSERT TABLE DATA: abchrgrp_postmeta */
INSERT INTO `abchrgrp_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("597", "1361", "_wp_attached_file", "2017/01/cropped-logo-final.png");
INSERT INTO `abchrgrp_postmeta` VALUES("598", "1361", "_wp_attachment_context", "custom-logo");
INSERT INTO `abchrgrp_postmeta` VALUES("599", "1361", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:826;s:6:\"height\";i:859;s:4:\"file\";s:30:\"2017/01/cropped-logo-final.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"cropped-logo-final-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"cropped-logo-final-288x300.png\";s:5:\"width\";i:288;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"cropped-logo-final-768x799.png\";s:5:\"width\";i:768;s:6:\"height\";i:799;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:30:\"cropped-logo-final-300x150.png\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:30:\"cropped-logo-final-480x300.png\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:30:\"cropped-logo-final-640x400.png\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("610", "1368", "_wp_attached_file", "2017/01/logo-2.png");
INSERT INTO `abchrgrp_postmeta` VALUES("611", "1368", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:50;s:6:\"height\";i:51;s:4:\"file\";s:18:\"2017/01/logo-2.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("587", "1356", "_wp_attachment_image_alt", "Clothing, Cosmopolitan Habits, Carpets,Rugs");
INSERT INTO `abchrgrp_postmeta` VALUES("561", "1349", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:480;s:6:\"height\";i:300;s:4:\"file\";s:25:\"2017/01/team5-480x300.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"team5-480x300-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"team5-480x300-300x188.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:188;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:25:\"team5-480x300-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("560", "1349", "_wp_attached_file", "2017/01/team5-480x300.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("562", "1349", "_wp_attachment_image_alt", "Description Here 3");
INSERT INTO `abchrgrp_postmeta` VALUES("592", "1358", "_wp_attachment_image_alt", "Agricultural Products Sfax Tunisia Import Export");
INSERT INTO `abchrgrp_postmeta` VALUES("591", "1358", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:480;s:6:\"height\";i:300;s:4:\"file\";s:50:\"2017/01/Agriculture_Sfax_Tunisia_Import_Export.png\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:50:\"Agriculture_Sfax_Tunisia_Import_Export-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:50:\"Agriculture_Sfax_Tunisia_Import_Export-300x188.png\";s:5:\"width\";i:300;s:6:\"height\";i:188;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:50:\"Agriculture_Sfax_Tunisia_Import_Export-300x150.png\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("590", "1358", "_wp_attached_file", "2017/01/Agriculture_Sfax_Tunisia_Import_Export.png");
INSERT INTO `abchrgrp_postmeta` VALUES("574", "1354", "_menu_item_type", "custom");
INSERT INTO `abchrgrp_postmeta` VALUES("575", "1354", "_menu_item_menu_item_parent", "0");
INSERT INTO `abchrgrp_postmeta` VALUES("576", "1354", "_menu_item_object_id", "1354");
INSERT INTO `abchrgrp_postmeta` VALUES("577", "1354", "_menu_item_object", "custom");
INSERT INTO `abchrgrp_postmeta` VALUES("578", "1354", "_menu_item_target", "");
INSERT INTO `abchrgrp_postmeta` VALUES("579", "1354", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `abchrgrp_postmeta` VALUES("580", "1354", "_menu_item_xfn", "");
INSERT INTO `abchrgrp_postmeta` VALUES("581", "1354", "_menu_item_url", "http://www.abchirgroup.com/#sectors");
INSERT INTO `abchrgrp_postmeta` VALUES("542", "1245", "_edit_last", "1");
INSERT INTO `abchrgrp_postmeta` VALUES("539", "1245", "_edit_lock", "1485829944:1");
INSERT INTO `abchrgrp_postmeta` VALUES("44", "22", "_edit_last", "1");
INSERT INTO `abchrgrp_postmeta` VALUES("45", "22", "_edit_lock", "1485090213:1");
INSERT INTO `abchrgrp_postmeta` VALUES("50", "27", "_form", "<label> Your Name (required)\n    [text* your-name] </label>\n\n<label> Your Email (required)\n    [email* your-email] </label>\n\n<label> Subject\n    [text your-subject] </label>\n\n<label> Your Message\n    [textarea your-message] </label>\n[recaptcha]\n[submit \"Send\"]");
INSERT INTO `abchrgrp_postmeta` VALUES("51", "27", "_mail", "a:8:{s:7:\"subject\";s:69:\"Abchir Group | Import - Export - Wholesale | Tunisia \"[your-subject]\"\";s:6:\"sender\";s:39:\"[your-name] <wordpress@abchirgroup.com>\";s:4:\"body\";s:216:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on Abchir Group | Import - Export - Wholesale | Tunisia (http://www.abchirgroup.com)\";s:9:\"recipient\";s:23:\"omar.jallouli@gmail.com\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `abchrgrp_postmeta` VALUES("52", "27", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:69:\"Abchir Group | Import - Export - Wholesale | Tunisia \"[your-subject]\"\";s:6:\"sender\";s:80:\"Abchir Group | Import - Export - Wholesale | Tunisia <wordpress@abchirgroup.com>\";s:4:\"body\";s:158:\"Message Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on Abchir Group | Import - Export - Wholesale | Tunisia (http://www.abchirgroup.com)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:33:\"Reply-To: omar.jallouli@gmail.com\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `abchrgrp_postmeta` VALUES("53", "27", "_messages", "a:23:{s:12:\"mail_sent_ok\";s:45:\"Thank you for your message. It has been sent.\";s:12:\"mail_sent_ng\";s:71:\"There was an error trying to send your message. Please try again later.\";s:16:\"validation_error\";s:61:\"One or more fields have an error. Please check and try again.\";s:4:\"spam\";s:71:\"There was an error trying to send your message. Please try again later.\";s:12:\"accept_terms\";s:69:\"You must accept the terms and conditions before sending your message.\";s:16:\"invalid_required\";s:22:\"The field is required.\";s:16:\"invalid_too_long\";s:22:\"The field is too long.\";s:17:\"invalid_too_short\";s:23:\"The field is too short.\";s:12:\"invalid_date\";s:29:\"The date format is incorrect.\";s:14:\"date_too_early\";s:44:\"The date is before the earliest one allowed.\";s:13:\"date_too_late\";s:41:\"The date is after the latest one allowed.\";s:13:\"upload_failed\";s:46:\"There was an unknown error uploading the file.\";s:24:\"upload_file_type_invalid\";s:49:\"You are not allowed to upload files of this type.\";s:21:\"upload_file_too_large\";s:20:\"The file is too big.\";s:23:\"upload_failed_php_error\";s:38:\"There was an error uploading the file.\";s:14:\"invalid_number\";s:29:\"The number format is invalid.\";s:16:\"number_too_small\";s:47:\"The number is smaller than the minimum allowed.\";s:16:\"number_too_large\";s:46:\"The number is larger than the maximum allowed.\";s:23:\"quiz_answer_not_correct\";s:36:\"The answer to the quiz is incorrect.\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:13:\"invalid_email\";s:38:\"The e-mail address entered is invalid.\";s:11:\"invalid_url\";s:19:\"The URL is invalid.\";s:11:\"invalid_tel\";s:32:\"The telephone number is invalid.\";}");
INSERT INTO `abchrgrp_postmeta` VALUES("54", "27", "_additional_settings", "");
INSERT INTO `abchrgrp_postmeta` VALUES("55", "27", "_locale", "en_US");
INSERT INTO `abchrgrp_postmeta` VALUES("56", "22", "_wp_page_template", "template-frontpage.php");
INSERT INTO `abchrgrp_postmeta` VALUES("435", "1283", "_wp_attached_file", "2017/01/AbchirGroup_Business_Sfax_Tunisia.png");
INSERT INTO `abchrgrp_postmeta` VALUES("436", "1283", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:683;s:4:\"file\";s:45:\"2017/01/AbchirGroup_Business_Sfax_Tunisia.png\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:45:\"AbchirGroup_Business_Sfax_Tunisia-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:45:\"AbchirGroup_Business_Sfax_Tunisia-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:45:\"AbchirGroup_Business_Sfax_Tunisia-768x512.png\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:46:\"AbchirGroup_Business_Sfax_Tunisia-1024x683.png\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:45:\"AbchirGroup_Business_Sfax_Tunisia-300x150.png\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:45:\"AbchirGroup_Business_Sfax_Tunisia-480x300.png\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:45:\"AbchirGroup_Business_Sfax_Tunisia-640x400.png\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("502", "1313", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("503", "1313", "_edit_lock", "1485098461:1");
INSERT INTO `abchrgrp_postmeta` VALUES("501", "1313", "_edit_last", "1");
INSERT INTO `abchrgrp_postmeta` VALUES("113", "35", "_wp_page_template", "template-frontpage.php");
INSERT INTO `abchrgrp_postmeta` VALUES("114", "36", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("115", "37", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("117", "38", "_thumbnail_id", "19");
INSERT INTO `abchrgrp_postmeta` VALUES("118", "38", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("120", "39", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("126", "44", "_thumbnail_id", "35");
INSERT INTO `abchrgrp_postmeta` VALUES("451", "39", "_edit_last", "1");
INSERT INTO `abchrgrp_postmeta` VALUES("128", "45", "_thumbnail_id", "34");
INSERT INTO `abchrgrp_postmeta` VALUES("130", "1177", "_wp_old_slug", "image-alignment");
INSERT INTO `abchrgrp_postmeta` VALUES("131", "1177", "_publicize_pending", "1");
INSERT INTO `abchrgrp_postmeta` VALUES("132", "1177", "standard_seo_post_level_layout", "");
INSERT INTO `abchrgrp_postmeta` VALUES("133", "1177", "standard_link_url_field", "");
INSERT INTO `abchrgrp_postmeta` VALUES("134", "1177", "standard_seo_post_meta_description", "");
INSERT INTO `abchrgrp_postmeta` VALUES("135", "1177", "original_post_id", "903");
INSERT INTO `abchrgrp_postmeta` VALUES("136", "1177", "_wp_old_slug", "903");
INSERT INTO `abchrgrp_postmeta` VALUES("137", "1177", "_thumbnail_id", "36");
INSERT INTO `abchrgrp_postmeta` VALUES("138", "1183", "_wp_page_template", "template-fullwidth.php");
INSERT INTO `abchrgrp_postmeta` VALUES("139", "1184", "_wp_page_template", "template-fullwidth.php");
INSERT INTO `abchrgrp_postmeta` VALUES("140", "1185", "_wp_page_template", "template-fullwidth.php");
INSERT INTO `abchrgrp_postmeta` VALUES("149", "1245", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("321", "1265", "_menu_item_url", "http://www.abchirgroup.com/#about");
INSERT INTO `abchrgrp_postmeta` VALUES("320", "1265", "_menu_item_xfn", "");
INSERT INTO `abchrgrp_postmeta` VALUES("158", "1247", "_form", "<p>Your Name (required)<br />\n    [text* your-name] </p>\n\n<p>Your Email (required)<br />\n    [email* your-email] </p>\n\n<p>Subject<br />\n    [text your-subject] </p>\n\n<p>Your Message<br />\n    [textarea your-message] </p>\n[recaptcha]\n<p>[submit \"Send\"]</p>");
INSERT INTO `abchrgrp_postmeta` VALUES("159", "1247", "_mail", "a:8:{s:7:\"subject\";s:31:\"[your-subject] Contact received\";s:6:\"sender\";s:29:\"omar.jallouli@abchirgroup.com\";s:4:\"body\";s:182:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on OnePress (http://demos.famethemes.com/onepress)\";s:9:\"recipient\";s:23:\"omar.jallouli@gmail.com\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `abchrgrp_postmeta` VALUES("160", "1247", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:14:\"[your-subject]\";s:6:\"sender\";s:41:\"OnePress <wordpress@demos.famethemes.com>\";s:4:\"body\";s:124:\"Message Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on OnePress (http://demos.famethemes.com/onepress)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:32:\"Reply-To: contact@famethemes.com\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `abchrgrp_postmeta` VALUES("161", "1247", "_messages", "a:23:{s:12:\"mail_sent_ok\";s:43:\"Your message was sent successfully. Thanks.\";s:12:\"mail_sent_ng\";s:93:\"Failed to send your message. Please try later or contact the administrator by another method.\";s:16:\"validation_error\";s:74:\"Validation errors occurred. Please confirm the fields and submit it again.\";s:4:\"spam\";s:93:\"Failed to send your message. Please try later or contact the administrator by another method.\";s:12:\"accept_terms\";s:35:\"Please accept the terms to proceed.\";s:16:\"invalid_required\";s:34:\"Please fill in the required field.\";s:16:\"invalid_too_long\";s:23:\"This input is too long.\";s:17:\"invalid_too_short\";s:24:\"This input is too short.\";s:12:\"invalid_date\";s:26:\"Date format seems invalid.\";s:14:\"date_too_early\";s:23:\"This date is too early.\";s:13:\"date_too_late\";s:22:\"This date is too late.\";s:13:\"upload_failed\";s:22:\"Failed to upload file.\";s:24:\"upload_file_type_invalid\";s:30:\"This file type is not allowed.\";s:21:\"upload_file_too_large\";s:23:\"This file is too large.\";s:23:\"upload_failed_php_error\";s:38:\"Failed to upload file. Error occurred.\";s:14:\"invalid_number\";s:28:\"Number format seems invalid.\";s:16:\"number_too_small\";s:25:\"This number is too small.\";s:16:\"number_too_large\";s:25:\"This number is too large.\";s:23:\"quiz_answer_not_correct\";s:27:\"Your answer is not correct.\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:13:\"invalid_email\";s:28:\"Email address seems invalid.\";s:11:\"invalid_url\";s:18:\"URL seems invalid.\";s:11:\"invalid_tel\";s:31:\"Telephone number seems invalid.\";}");
INSERT INTO `abchrgrp_postmeta` VALUES("162", "1247", "_additional_settings", "");
INSERT INTO `abchrgrp_postmeta` VALUES("163", "1247", "_locale", "en_US");
INSERT INTO `abchrgrp_postmeta` VALUES("450", "39", "_edit_lock", "1485096621:1");
INSERT INTO `abchrgrp_postmeta` VALUES("445", "37", "_edit_last", "1");
INSERT INTO `abchrgrp_postmeta` VALUES("444", "37", "_edit_lock", "1485096077:1");
INSERT INTO `abchrgrp_postmeta` VALUES("224", "1257", "_menu_item_url", "http://www.abchirgroup.com/#services");
INSERT INTO `abchrgrp_postmeta` VALUES("223", "1257", "_menu_item_xfn", "");
INSERT INTO `abchrgrp_postmeta` VALUES("222", "1257", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `abchrgrp_postmeta` VALUES("221", "1257", "_menu_item_target", "");
INSERT INTO `abchrgrp_postmeta` VALUES("220", "1257", "_menu_item_object", "custom");
INSERT INTO `abchrgrp_postmeta` VALUES("219", "1257", "_menu_item_object_id", "1257");
INSERT INTO `abchrgrp_postmeta` VALUES("218", "1257", "_menu_item_menu_item_parent", "0");
INSERT INTO `abchrgrp_postmeta` VALUES("217", "1257", "_menu_item_type", "custom");
INSERT INTO `abchrgrp_postmeta` VALUES("453", "1294", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:678;s:4:\"file\";s:56:\"2017/01/AbchirGroup_Purchasing_Sourcing_Sfax_Tunisia.png\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:56:\"AbchirGroup_Purchasing_Sourcing_Sfax_Tunisia-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:56:\"AbchirGroup_Purchasing_Sourcing_Sfax_Tunisia-300x199.png\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:56:\"AbchirGroup_Purchasing_Sourcing_Sfax_Tunisia-768x509.png\";s:5:\"width\";i:768;s:6:\"height\";i:509;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:57:\"AbchirGroup_Purchasing_Sourcing_Sfax_Tunisia-1024x678.png\";s:5:\"width\";i:1024;s:6:\"height\";i:678;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:56:\"AbchirGroup_Purchasing_Sourcing_Sfax_Tunisia-300x150.png\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:56:\"AbchirGroup_Purchasing_Sourcing_Sfax_Tunisia-480x300.png\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:56:\"AbchirGroup_Purchasing_Sourcing_Sfax_Tunisia-640x400.png\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("475", "1298", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `abchrgrp_postmeta` VALUES("474", "1298", "_menu_item_target", "");
INSERT INTO `abchrgrp_postmeta` VALUES("473", "1298", "_menu_item_object", "custom");
INSERT INTO `abchrgrp_postmeta` VALUES("472", "1298", "_menu_item_object_id", "1298");
INSERT INTO `abchrgrp_postmeta` VALUES("471", "1298", "_menu_item_menu_item_parent", "0");
INSERT INTO `abchrgrp_postmeta` VALUES("467", "1297", "_menu_item_xfn", "");
INSERT INTO `abchrgrp_postmeta` VALUES("468", "1297", "_menu_item_url", "");
INSERT INTO `abchrgrp_postmeta` VALUES("469", "1297", "_menu_item_orphaned", "1485097033");
INSERT INTO `abchrgrp_postmeta` VALUES("470", "1298", "_menu_item_type", "custom");
INSERT INTO `abchrgrp_postmeta` VALUES("249", "1261", "_menu_item_type", "custom");
INSERT INTO `abchrgrp_postmeta` VALUES("250", "1261", "_menu_item_menu_item_parent", "0");
INSERT INTO `abchrgrp_postmeta` VALUES("251", "1261", "_menu_item_object_id", "1261");
INSERT INTO `abchrgrp_postmeta` VALUES("252", "1261", "_menu_item_object", "custom");
INSERT INTO `abchrgrp_postmeta` VALUES("253", "1261", "_menu_item_target", "");
INSERT INTO `abchrgrp_postmeta` VALUES("254", "1261", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `abchrgrp_postmeta` VALUES("255", "1261", "_menu_item_xfn", "");
INSERT INTO `abchrgrp_postmeta` VALUES("256", "1261", "_menu_item_url", "http://www.abchirgroup.com/#contact");
INSERT INTO `abchrgrp_postmeta` VALUES("319", "1265", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `abchrgrp_postmeta` VALUES("318", "1265", "_menu_item_target", "");
INSERT INTO `abchrgrp_postmeta` VALUES("317", "1265", "_menu_item_object", "custom");
INSERT INTO `abchrgrp_postmeta` VALUES("316", "1265", "_menu_item_object_id", "1265");
INSERT INTO `abchrgrp_postmeta` VALUES("315", "1265", "_menu_item_menu_item_parent", "0");
INSERT INTO `abchrgrp_postmeta` VALUES("314", "1265", "_menu_item_type", "custom");
INSERT INTO `abchrgrp_postmeta` VALUES("265", "35", "_wp_page_template", "template-frontpage.php");
INSERT INTO `abchrgrp_postmeta` VALUES("266", "36", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("267", "37", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("269", "38", "_thumbnail_id", "19");
INSERT INTO `abchrgrp_postmeta` VALUES("270", "38", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("272", "39", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("277", "44", "_thumbnail_id", "35");
INSERT INTO `abchrgrp_postmeta` VALUES("278", "45", "_thumbnail_id", "34");
INSERT INTO `abchrgrp_postmeta` VALUES("279", "1177", "_wp_old_slug", "image-alignment");
INSERT INTO `abchrgrp_postmeta` VALUES("280", "1177", "_publicize_pending", "1");
INSERT INTO `abchrgrp_postmeta` VALUES("281", "1177", "standard_seo_post_level_layout", "");
INSERT INTO `abchrgrp_postmeta` VALUES("282", "1177", "standard_link_url_field", "");
INSERT INTO `abchrgrp_postmeta` VALUES("283", "1177", "standard_seo_post_meta_description", "");
INSERT INTO `abchrgrp_postmeta` VALUES("284", "1177", "original_post_id", "903");
INSERT INTO `abchrgrp_postmeta` VALUES("285", "1177", "_wp_old_slug", "903");
INSERT INTO `abchrgrp_postmeta` VALUES("286", "1177", "_thumbnail_id", "36");
INSERT INTO `abchrgrp_postmeta` VALUES("287", "1183", "_wp_page_template", "template-fullwidth.php");
INSERT INTO `abchrgrp_postmeta` VALUES("288", "1184", "_wp_page_template", "template-fullwidth.php");
INSERT INTO `abchrgrp_postmeta` VALUES("289", "1185", "_wp_page_template", "template-fullwidth.php");
INSERT INTO `abchrgrp_postmeta` VALUES("466", "1297", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `abchrgrp_postmeta` VALUES("465", "1297", "_menu_item_target", "");
INSERT INTO `abchrgrp_postmeta` VALUES("464", "1297", "_menu_item_object", "page");
INSERT INTO `abchrgrp_postmeta` VALUES("463", "1297", "_menu_item_object_id", "22");
INSERT INTO `abchrgrp_postmeta` VALUES("462", "1297", "_menu_item_menu_item_parent", "0");
INSERT INTO `abchrgrp_postmeta` VALUES("461", "1297", "_menu_item_type", "post_type");
INSERT INTO `abchrgrp_postmeta` VALUES("298", "1245", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("437", "1283", "_wp_attachment_image_alt", "AbchirGroup_Business_Sfax_Tunisia");
INSERT INTO `abchrgrp_postmeta` VALUES("307", "1247", "_form", "<p>Your Name (required)<br />\n    [text* your-name] </p>\n\n<p>Your Email (required)<br />\n    [email* your-email] </p>\n\n<p>Subject<br />\n    [text your-subject] </p>\n\n<p>Your Message<br />\n    [textarea your-message] </p>\n[recaptcha]\n<p>[submit \"Send\"]</p>");
INSERT INTO `abchrgrp_postmeta` VALUES("308", "1247", "_mail", "a:8:{s:7:\"subject\";s:31:\"[your-subject] Contact received\";s:6:\"sender\";s:29:\"omar.jallouli@abchirgroup.com\";s:4:\"body\";s:182:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on OnePress (http://demos.famethemes.com/onepress)\";s:9:\"recipient\";s:23:\"omar.jallouli@gmail.com\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `abchrgrp_postmeta` VALUES("309", "1247", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:14:\"[your-subject]\";s:6:\"sender\";s:41:\"OnePress <wordpress@demos.famethemes.com>\";s:4:\"body\";s:124:\"Message Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on OnePress (http://demos.famethemes.com/onepress)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:32:\"Reply-To: contact@famethemes.com\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `abchrgrp_postmeta` VALUES("310", "1247", "_messages", "a:23:{s:12:\"mail_sent_ok\";s:43:\"Your message was sent successfully. Thanks.\";s:12:\"mail_sent_ng\";s:93:\"Failed to send your message. Please try later or contact the administrator by another method.\";s:16:\"validation_error\";s:74:\"Validation errors occurred. Please confirm the fields and submit it again.\";s:4:\"spam\";s:93:\"Failed to send your message. Please try later or contact the administrator by another method.\";s:12:\"accept_terms\";s:35:\"Please accept the terms to proceed.\";s:16:\"invalid_required\";s:34:\"Please fill in the required field.\";s:16:\"invalid_too_long\";s:23:\"This input is too long.\";s:17:\"invalid_too_short\";s:24:\"This input is too short.\";s:12:\"invalid_date\";s:26:\"Date format seems invalid.\";s:14:\"date_too_early\";s:23:\"This date is too early.\";s:13:\"date_too_late\";s:22:\"This date is too late.\";s:13:\"upload_failed\";s:22:\"Failed to upload file.\";s:24:\"upload_file_type_invalid\";s:30:\"This file type is not allowed.\";s:21:\"upload_file_too_large\";s:23:\"This file is too large.\";s:23:\"upload_failed_php_error\";s:38:\"Failed to upload file. Error occurred.\";s:14:\"invalid_number\";s:28:\"Number format seems invalid.\";s:16:\"number_too_small\";s:25:\"This number is too small.\";s:16:\"number_too_large\";s:25:\"This number is too large.\";s:23:\"quiz_answer_not_correct\";s:27:\"Your answer is not correct.\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:13:\"invalid_email\";s:28:\"Email address seems invalid.\";s:11:\"invalid_url\";s:18:\"URL seems invalid.\";s:11:\"invalid_tel\";s:31:\"Telephone number seems invalid.\";}");
INSERT INTO `abchrgrp_postmeta` VALUES("311", "1247", "_additional_settings", "");
INSERT INTO `abchrgrp_postmeta` VALUES("312", "1247", "_locale", "en_US");
INSERT INTO `abchrgrp_postmeta` VALUES("586", "1356", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:480;s:6:\"height\";i:300;s:4:\"file\";s:54:\"2017/01/Textile_Fabrics_Sfax_Tunisia_Import_Export.png\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:54:\"Textile_Fabrics_Sfax_Tunisia_Import_Export-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:54:\"Textile_Fabrics_Sfax_Tunisia_Import_Export-300x188.png\";s:5:\"width\";i:300;s:6:\"height\";i:188;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:54:\"Textile_Fabrics_Sfax_Tunisia_Import_Export-300x150.png\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("585", "1356", "_wp_attached_file", "2017/01/Textile_Fabrics_Sfax_Tunisia_Import_Export.png");
INSERT INTO `abchrgrp_postmeta` VALUES("370", "35", "_wp_page_template", "template-frontpage.php");
INSERT INTO `abchrgrp_postmeta` VALUES("371", "36", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("372", "37", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("374", "38", "_thumbnail_id", "19");
INSERT INTO `abchrgrp_postmeta` VALUES("375", "38", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("452", "1294", "_wp_attached_file", "2017/01/AbchirGroup_Purchasing_Sourcing_Sfax_Tunisia.png");
INSERT INTO `abchrgrp_postmeta` VALUES("377", "39", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("382", "44", "_thumbnail_id", "35");
INSERT INTO `abchrgrp_postmeta` VALUES("383", "45", "_thumbnail_id", "34");
INSERT INTO `abchrgrp_postmeta` VALUES("384", "1177", "_wp_old_slug", "image-alignment");
INSERT INTO `abchrgrp_postmeta` VALUES("385", "1177", "_publicize_pending", "1");
INSERT INTO `abchrgrp_postmeta` VALUES("386", "1177", "standard_seo_post_level_layout", "");
INSERT INTO `abchrgrp_postmeta` VALUES("387", "1177", "standard_link_url_field", "");
INSERT INTO `abchrgrp_postmeta` VALUES("388", "1177", "standard_seo_post_meta_description", "");
INSERT INTO `abchrgrp_postmeta` VALUES("389", "1177", "original_post_id", "903");
INSERT INTO `abchrgrp_postmeta` VALUES("390", "1177", "_wp_old_slug", "903");
INSERT INTO `abchrgrp_postmeta` VALUES("391", "1177", "_thumbnail_id", "36");
INSERT INTO `abchrgrp_postmeta` VALUES("392", "1183", "_wp_page_template", "template-fullwidth.php");
INSERT INTO `abchrgrp_postmeta` VALUES("393", "1184", "_wp_page_template", "template-fullwidth.php");
INSERT INTO `abchrgrp_postmeta` VALUES("394", "1185", "_wp_page_template", "template-fullwidth.php");
INSERT INTO `abchrgrp_postmeta` VALUES("403", "1245", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("477", "1298", "_menu_item_url", "http://www.abchirgroup.com/#import-export-tunisia");
INSERT INTO `abchrgrp_postmeta` VALUES("476", "1298", "_menu_item_xfn", "");
INSERT INTO `abchrgrp_postmeta` VALUES("412", "1247", "_form", "<p>Your Name (required)<br />\n    [text* your-name] </p>\n\n<p>Your Email (required)<br />\n    [email* your-email] </p>\n\n<p>Subject<br />\n    [text your-subject] </p>\n\n<p>Your Message<br />\n    [textarea your-message] </p>\n[recaptcha]\n<p>[submit \"Send\"]</p>");
INSERT INTO `abchrgrp_postmeta` VALUES("413", "1247", "_mail", "a:8:{s:7:\"subject\";s:31:\"[your-subject] Contact received\";s:6:\"sender\";s:29:\"omar.jallouli@abchirgroup.com\";s:4:\"body\";s:182:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on OnePress (http://demos.famethemes.com/onepress)\";s:9:\"recipient\";s:23:\"omar.jallouli@gmail.com\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `abchrgrp_postmeta` VALUES("414", "1247", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:14:\"[your-subject]\";s:6:\"sender\";s:41:\"OnePress <wordpress@demos.famethemes.com>\";s:4:\"body\";s:124:\"Message Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on OnePress (http://demos.famethemes.com/onepress)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:32:\"Reply-To: contact@famethemes.com\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `abchrgrp_postmeta` VALUES("415", "1247", "_messages", "a:23:{s:12:\"mail_sent_ok\";s:43:\"Your message was sent successfully. Thanks.\";s:12:\"mail_sent_ng\";s:93:\"Failed to send your message. Please try later or contact the administrator by another method.\";s:16:\"validation_error\";s:74:\"Validation errors occurred. Please confirm the fields and submit it again.\";s:4:\"spam\";s:93:\"Failed to send your message. Please try later or contact the administrator by another method.\";s:12:\"accept_terms\";s:35:\"Please accept the terms to proceed.\";s:16:\"invalid_required\";s:34:\"Please fill in the required field.\";s:16:\"invalid_too_long\";s:23:\"This input is too long.\";s:17:\"invalid_too_short\";s:24:\"This input is too short.\";s:12:\"invalid_date\";s:26:\"Date format seems invalid.\";s:14:\"date_too_early\";s:23:\"This date is too early.\";s:13:\"date_too_late\";s:22:\"This date is too late.\";s:13:\"upload_failed\";s:22:\"Failed to upload file.\";s:24:\"upload_file_type_invalid\";s:30:\"This file type is not allowed.\";s:21:\"upload_file_too_large\";s:23:\"This file is too large.\";s:23:\"upload_failed_php_error\";s:38:\"Failed to upload file. Error occurred.\";s:14:\"invalid_number\";s:28:\"Number format seems invalid.\";s:16:\"number_too_small\";s:25:\"This number is too small.\";s:16:\"number_too_large\";s:25:\"This number is too large.\";s:23:\"quiz_answer_not_correct\";s:27:\"Your answer is not correct.\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:13:\"invalid_email\";s:28:\"Email address seems invalid.\";s:11:\"invalid_url\";s:18:\"URL seems invalid.\";s:11:\"invalid_tel\";s:31:\"Telephone number seems invalid.\";}");
INSERT INTO `abchrgrp_postmeta` VALUES("416", "1247", "_additional_settings", "");
INSERT INTO `abchrgrp_postmeta` VALUES("417", "1247", "_locale", "en_US");
INSERT INTO `abchrgrp_postmeta` VALUES("454", "1294", "_wp_attachment_image_alt", "AbchirGroup_Purchasing_Sourcing_Sfax_Tunisia");
INSERT INTO `abchrgrp_postmeta` VALUES("511", "1319", "_edit_last", "1");
INSERT INTO `abchrgrp_postmeta` VALUES("512", "1319", "_edit_lock", "1485101386:1");
INSERT INTO `abchrgrp_postmeta` VALUES("513", "1319", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("519", "1323", "_edit_last", "1");
INSERT INTO `abchrgrp_postmeta` VALUES("520", "1323", "_edit_lock", "1485099251:1");
INSERT INTO `abchrgrp_postmeta` VALUES("521", "1323", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("527", "1329", "_edit_last", "1");
INSERT INTO `abchrgrp_postmeta` VALUES("528", "1329", "_edit_lock", "1485099415:1");
INSERT INTO `abchrgrp_postmeta` VALUES("529", "1329", "_wp_page_template", "default");
INSERT INTO `abchrgrp_postmeta` VALUES("623", "1374", "_wp_attached_file", "2017/01/Abchir_Site_Icon.png");
INSERT INTO `abchrgrp_postmeta` VALUES("624", "1374", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:28:\"2017/01/Abchir_Site_Icon.png\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"Abchir_Site_Icon-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"Abchir_Site_Icon-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:28:\"Abchir_Site_Icon-300x150.png\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:28:\"Abchir_Site_Icon-480x300.png\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:28:\"Abchir_Site_Icon-512x400.png\";s:5:\"width\";i:512;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("618", "1372", "_wp_attached_file", "2017/01/cropped-Abchir_Site_Icon.png");
INSERT INTO `abchrgrp_postmeta` VALUES("619", "1372", "_wp_attachment_context", "site-icon");
INSERT INTO `abchrgrp_postmeta` VALUES("620", "1372", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:36:\"2017/01/cropped-Abchir_Site_Icon.png\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"cropped-Abchir_Site_Icon-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"cropped-Abchir_Site_Icon-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:36:\"cropped-Abchir_Site_Icon-300x150.png\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:36:\"cropped-Abchir_Site_Icon-480x300.png\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:36:\"cropped-Abchir_Site_Icon-512x400.png\";s:5:\"width\";i:512;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-270\";a:4:{s:4:\"file\";s:36:\"cropped-Abchir_Site_Icon-270x270.png\";s:5:\"width\";i:270;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-192\";a:4:{s:4:\"file\";s:36:\"cropped-Abchir_Site_Icon-192x192.png\";s:5:\"width\";i:192;s:6:\"height\";i:192;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-180\";a:4:{s:4:\"file\";s:36:\"cropped-Abchir_Site_Icon-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"site_icon-32\";a:4:{s:4:\"file\";s:34:\"cropped-Abchir_Site_Icon-32x32.png\";s:5:\"width\";i:32;s:6:\"height\";i:32;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("625", "1375", "_wp_attached_file", "2017/01/cropped-Abchir_Site_Icon-1.png");
INSERT INTO `abchrgrp_postmeta` VALUES("626", "1375", "_wp_attachment_context", "site-icon");
INSERT INTO `abchrgrp_postmeta` VALUES("627", "1375", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:38:\"2017/01/cropped-Abchir_Site_Icon-1.png\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"cropped-Abchir_Site_Icon-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"cropped-Abchir_Site_Icon-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:38:\"cropped-Abchir_Site_Icon-1-300x150.png\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:38:\"cropped-Abchir_Site_Icon-1-480x300.png\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:38:\"cropped-Abchir_Site_Icon-1-512x400.png\";s:5:\"width\";i:512;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-270\";a:4:{s:4:\"file\";s:38:\"cropped-Abchir_Site_Icon-1-270x270.png\";s:5:\"width\";i:270;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-192\";a:4:{s:4:\"file\";s:38:\"cropped-Abchir_Site_Icon-1-192x192.png\";s:5:\"width\";i:192;s:6:\"height\";i:192;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-180\";a:4:{s:4:\"file\";s:38:\"cropped-Abchir_Site_Icon-1-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"site_icon-32\";a:4:{s:4:\"file\";s:36:\"cropped-Abchir_Site_Icon-1-32x32.png\";s:5:\"width\";i:32;s:6:\"height\";i:32;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("634", "1379", "_wp_attached_file", "2017/01/Abchir_Group_Sfax_Tunisia_Logo.png");
INSERT INTO `abchrgrp_postmeta` VALUES("635", "1379", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:826;s:6:\"height\";i:870;s:4:\"file\";s:42:\"2017/01/Abchir_Group_Sfax_Tunisia_Logo.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:42:\"Abchir_Group_Sfax_Tunisia_Logo-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:42:\"Abchir_Group_Sfax_Tunisia_Logo-285x300.png\";s:5:\"width\";i:285;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:42:\"Abchir_Group_Sfax_Tunisia_Logo-768x809.png\";s:5:\"width\";i:768;s:6:\"height\";i:809;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:42:\"Abchir_Group_Sfax_Tunisia_Logo-300x150.png\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:42:\"Abchir_Group_Sfax_Tunisia_Logo-480x300.png\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:42:\"Abchir_Group_Sfax_Tunisia_Logo-640x400.png\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("636", "1379", "_wp_attachment_image_alt", "Abchir_Group_Sfax_Tunisia_Logo");
INSERT INTO `abchrgrp_postmeta` VALUES("639", "1380", "_wp_attached_file", "2017/01/Foods_Sfax_Tunisia_Import_Export.png");
INSERT INTO `abchrgrp_postmeta` VALUES("640", "1380", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:480;s:6:\"height\";i:300;s:4:\"file\";s:44:\"2017/01/Foods_Sfax_Tunisia_Import_Export.png\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:44:\"Foods_Sfax_Tunisia_Import_Export-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:44:\"Foods_Sfax_Tunisia_Import_Export-300x188.png\";s:5:\"width\";i:300;s:6:\"height\";i:188;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:44:\"Foods_Sfax_Tunisia_Import_Export-300x150.png\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("641", "1380", "_wp_attachment_image_alt", "Food, Cheese, Harissa, Fish, Tunisia");
INSERT INTO `abchrgrp_postmeta` VALUES("644", "1382", "_wp_attached_file", "2017/01/Handcrafts_Sfax_Tunisia_Import_Export.png");
INSERT INTO `abchrgrp_postmeta` VALUES("645", "1382", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:480;s:6:\"height\";i:300;s:4:\"file\";s:49:\"2017/01/Handcrafts_Sfax_Tunisia_Import_Export.png\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:49:\"Handcrafts_Sfax_Tunisia_Import_Export-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:49:\"Handcrafts_Sfax_Tunisia_Import_Export-300x188.png\";s:5:\"width\";i:300;s:6:\"height\";i:188;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:49:\"Handcrafts_Sfax_Tunisia_Import_Export-300x150.png\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("650", "1385", "_edit_last", "1");
INSERT INTO `abchrgrp_postmeta` VALUES("651", "1385", "_edit_lock", "1485865626:1");
INSERT INTO `abchrgrp_postmeta` VALUES("652", "1385", "_wp_page_template", "template-fullwidth.php");
INSERT INTO `abchrgrp_postmeta` VALUES("653", "1388", "_edit_last", "1");
INSERT INTO `abchrgrp_postmeta` VALUES("654", "1388", "_edit_lock", "1485865628:1");
INSERT INTO `abchrgrp_postmeta` VALUES("655", "1388", "_wp_page_template", "template-fullwidth.php");
INSERT INTO `abchrgrp_postmeta` VALUES("656", "1390", "_edit_last", "1");
INSERT INTO `abchrgrp_postmeta` VALUES("657", "1390", "_wp_page_template", "template-fullwidth.php");
INSERT INTO `abchrgrp_postmeta` VALUES("658", "1390", "_edit_lock", "1486835109:1");
INSERT INTO `abchrgrp_postmeta` VALUES("659", "1392", "_edit_last", "1");
INSERT INTO `abchrgrp_postmeta` VALUES("660", "1392", "_wp_page_template", "template-fullwidth.php");
INSERT INTO `abchrgrp_postmeta` VALUES("661", "1392", "_edit_lock", "1486834722:1");
INSERT INTO `abchrgrp_postmeta` VALUES("664", "1394", "_wp_attached_file", "2017/01/Clothing_Textile_Tunisia-1.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("665", "1394", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:636;s:4:\"file\";s:38:\"2017/01/Clothing_Textile_Tunisia-1.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-1-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-1-768x509.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:509;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-1-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-1-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-1-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("666", "1395", "_wp_attached_file", "2017/01/Clothing_Textile_Tunisia-1.png");
INSERT INTO `abchrgrp_postmeta` VALUES("667", "1395", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:448;s:6:\"height\";i:297;s:4:\"file\";s:38:\"2017/01/Clothing_Textile_Tunisia-1.png\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-1-300x199.png\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-1-300x150.png\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("668", "1396", "_wp_attached_file", "2017/01/Clothing_Textile_Tunisia-2.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("669", "1396", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:853;s:6:\"height\";i:1280;s:4:\"file\";s:38:\"2017/01/Clothing_Textile_Tunisia-2.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-2-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:39:\"Clothing_Textile_Tunisia-2-768x1152.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:39:\"Clothing_Textile_Tunisia-2-682x1024.jpg\";s:5:\"width\";i:682;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-2-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-2-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-2-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:14:\"Canon EOS 100D\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1422714470\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"20\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:17:\"0.033333333333333\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("670", "1397", "_wp_attached_file", "2017/01/Clothing_Textile_Tunisia-3.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("671", "1397", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:980;s:6:\"height\";i:450;s:4:\"file\";s:38:\"2017/01/Clothing_Textile_Tunisia-3.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-3-300x138.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:138;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-3-768x353.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:353;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-3-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-3-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-3-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("672", "1398", "_wp_attached_file", "2017/01/Clothing_Textile_Tunisia-4.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("673", "1398", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:800;s:6:\"height\";i:994;s:4:\"file\";s:38:\"2017/01/Clothing_Textile_Tunisia-4.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-4-241x300.jpg\";s:5:\"width\";i:241;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-4-768x954.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:954;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-4-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-4-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-4-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("674", "1399", "_wp_attached_file", "2017/01/Clothing_Textile_Tunisia-5.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("675", "1399", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:38:\"2017/01/Clothing_Textile_Tunisia-5.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-5-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:39:\"Clothing_Textile_Tunisia-5-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-5-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-5-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-5-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:14:\"Canon EOS 100D\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1422714431\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"50\";s:3:\"iso\";s:4:\"1000\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("676", "1400", "_wp_attached_file", "2017/01/Clothing_Textile_Tunisia-6.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("677", "1400", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:350;s:6:\"height\";i:350;s:4:\"file\";s:38:\"2017/01/Clothing_Textile_Tunisia-6.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-6-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-6-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-6-350x300.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("678", "1401", "_wp_attached_file", "2017/01/Clothing_Textile_Tunisia-7.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("679", "1401", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:737;s:4:\"file\";s:38:\"2017/01/Clothing_Textile_Tunisia-7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-7-204x300.jpg\";s:5:\"width\";i:204;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-7-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-7-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-7-500x400.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("680", "1402", "_wp_attached_file", "2017/01/Clothing_Textile_Tunisia-8.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("681", "1402", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:667;s:4:\"file\";s:38:\"2017/01/Clothing_Textile_Tunisia-8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-8-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-8-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-8-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:38:\"Clothing_Textile_Tunisia-8-500x400.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("682", "1404", "_wp_attached_file", "2017/01/Rug_Carpet_Tunisia-1.jpeg");
INSERT INTO `abchrgrp_postmeta` VALUES("683", "1404", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:460;s:6:\"height\";i:342;s:4:\"file\";s:33:\"2017/01/Rug_Carpet_Tunisia-1.jpeg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"Rug_Carpet_Tunisia-1-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"Rug_Carpet_Tunisia-1-300x223.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:223;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:33:\"Rug_Carpet_Tunisia-1-300x150.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:33:\"Rug_Carpet_Tunisia-1-460x300.jpeg\";s:5:\"width\";i:460;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("684", "1405", "_wp_attached_file", "2017/01/Rug_Carpet_Tunisia-1.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("685", "1405", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:32:\"2017/01/Rug_Carpet_Tunisia-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"Rug_Carpet_Tunisia-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"Rug_Carpet_Tunisia-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:32:\"Rug_Carpet_Tunisia-1-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:32:\"Rug_Carpet_Tunisia-1-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("686", "1406", "_wp_attached_file", "2017/01/Rug_Carpet_Tunisia-2.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("687", "1406", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:1079;s:4:\"file\";s:32:\"2017/01/Rug_Carpet_Tunisia-2.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"Rug_Carpet_Tunisia-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"Rug_Carpet_Tunisia-2-300x158.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:158;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"Rug_Carpet_Tunisia-2-768x405.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:405;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"Rug_Carpet_Tunisia-2-1024x540.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:540;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:32:\"Rug_Carpet_Tunisia-2-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:32:\"Rug_Carpet_Tunisia-2-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:32:\"Rug_Carpet_Tunisia-2-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("688", "1407", "_wp_attached_file", "2017/01/Rug_Carpet_Tunisia-3.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("689", "1407", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:791;s:6:\"height\";i:525;s:4:\"file\";s:32:\"2017/01/Rug_Carpet_Tunisia-3.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"Rug_Carpet_Tunisia-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"Rug_Carpet_Tunisia-3-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"Rug_Carpet_Tunisia-3-768x510.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:32:\"Rug_Carpet_Tunisia-3-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:32:\"Rug_Carpet_Tunisia-3-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:32:\"Rug_Carpet_Tunisia-3-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("690", "1412", "_wp_attached_file", "2017/01/agricultural_products_Tunisia-1.jpeg");
INSERT INTO `abchrgrp_postmeta` VALUES("691", "1412", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:265;s:4:\"file\";s:44:\"2017/01/agricultural_products_Tunisia-1.jpeg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-1-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-1-300x133.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:133;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-1-300x150.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-1-480x265.jpeg\";s:5:\"width\";i:480;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("692", "1413", "_wp_attached_file", "2017/01/agricultural_products_Tunisia-1.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("693", "1413", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1600;s:6:\"height\";i:1066;s:4:\"file\";s:43:\"2017/01/agricultural_products_Tunisia-1.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-1-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-1-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-1-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-1-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("694", "1414", "_wp_attached_file", "2017/01/agricultural_products_Tunisia-1.png");
INSERT INTO `abchrgrp_postmeta` VALUES("695", "1414", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:680;s:6:\"height\";i:350;s:4:\"file\";s:43:\"2017/01/agricultural_products_Tunisia-1.png\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-1-300x154.png\";s:5:\"width\";i:300;s:6:\"height\";i:154;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-1-300x150.png\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-1-480x300.png\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-1-640x350.png\";s:5:\"width\";i:640;s:6:\"height\";i:350;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("696", "1415", "_wp_attached_file", "2017/01/agricultural_products_Tunisia-2.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("697", "1415", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:520;s:6:\"height\";i:381;s:4:\"file\";s:43:\"2017/01/agricultural_products_Tunisia-2.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-2-300x220.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-2-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-2-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("698", "1416", "_wp_attached_file", "2017/01/agricultural_products_Tunisia-3.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("699", "1416", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:470;s:6:\"height\";i:353;s:4:\"file\";s:43:\"2017/01/agricultural_products_Tunisia-3.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-3-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-3-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-3-470x300.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("700", "1417", "_wp_attached_file", "2017/01/agricultural_products_Tunisia-4.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("701", "1417", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:599;s:6:\"height\";i:510;s:4:\"file\";s:43:\"2017/01/agricultural_products_Tunisia-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-4-300x255.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:255;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-4-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-4-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-4-599x400.jpg\";s:5:\"width\";i:599;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("702", "1418", "_wp_attached_file", "2017/01/agricultural_products_Tunisia-5.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("703", "1418", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:300;s:4:\"file\";s:43:\"2017/01/agricultural_products_Tunisia-5.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-5-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-5-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-5-400x300.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:3:\"jcm\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:36:\"Dattes et leur reflet dans un miroir\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:3:\"jcm\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:36:\"Dattes et leur reflet dans un miroir\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:14:{i:0;s:5:\"datte\";i:1;s:6:\"dattes\";i:2;s:6:\"reflet\";i:3;s:6:\"miroir\";i:4;s:4:\"brun\";i:5;s:5:\"blanc\";i:6;s:5:\"fruit\";i:7;s:5:\"datte\";i:8;s:6:\"dattes\";i:9;s:6:\"reflet\";i:10;s:6:\"miroir\";i:11;s:4:\"brun\";i:12;s:5:\"blanc\";i:13;s:5:\"fruit\";}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("704", "1419", "_wp_attached_file", "2017/01/agricultural_products_Tunisia-6.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("705", "1419", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:626;s:6:\"height\";i:380;s:4:\"file\";s:43:\"2017/01/agricultural_products_Tunisia-6.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-6-300x182.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-6-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-6-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("706", "1420", "_wp_attached_file", "2017/01/agricultural_products_Tunisia-7.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("707", "1420", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:377;s:4:\"file\";s:43:\"2017/01/agricultural_products_Tunisia-7.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-7-300x110.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:110;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-7-768x283.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:283;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-7-1024x377.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:377;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-7-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-7-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-7-640x377.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:377;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("708", "1421", "_wp_attached_file", "2017/01/agricultural_products_Tunisia-8.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("709", "1421", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:878;s:6:\"height\";i:535;s:4:\"file\";s:43:\"2017/01/agricultural_products_Tunisia-8.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-8-300x183.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:183;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-8-768x468.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-8-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-8-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-8-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("710", "1422", "_wp_attached_file", "2017/01/agricultural_products_Tunisia-9.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("711", "1422", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1400;s:6:\"height\";i:787;s:4:\"file\";s:43:\"2017/01/agricultural_products_Tunisia-9.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-9-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-9-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-9-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-9-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-9-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:43:\"agricultural_products_Tunisia-9-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:3:\"NPR\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:73:\"Just a spoonful of the spicy chili paste known as harissa goes a long way\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:10:\"Harissa_02\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:1:{i:0;s:19:\"|storyid=154293245|\";}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("712", "1423", "_wp_attached_file", "2017/01/agricultural_products_Tunisia-10.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("713", "1423", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:295;s:6:\"height\";i:300;s:4:\"file\";s:44:\"2017/01/agricultural_products_Tunisia-10.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-10-295x300.jpg\";s:5:\"width\";i:295;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-10-295x150.jpg\";s:5:\"width\";i:295;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-10-295x300.jpg\";s:5:\"width\";i:295;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("714", "1424", "_wp_attached_file", "2017/01/agricultural_products_Tunisia-11.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("715", "1424", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:980;s:6:\"height\";i:360;s:4:\"file\";s:44:\"2017/01/agricultural_products_Tunisia-11.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-11-300x110.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:110;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-11-768x282.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:282;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-11-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-11-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-11-640x360.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("716", "1425", "_wp_attached_file", "2017/01/agricultural_products_Tunisia-12.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("717", "1425", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:640;s:6:\"height\";i:426;s:4:\"file\";s:44:\"2017/01/agricultural_products_Tunisia-12.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-12-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-12-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-12-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-12-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-12-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:7:\"DSC-W80\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1200392197\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"8.7\";s:3:\"iso\";s:3:\"160\";s:13:\"shutter_speed\";s:8:\"0.000625\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("718", "1426", "_wp_attached_file", "2017/01/agricultural_products_Tunisia-13.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("719", "1426", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:350;s:4:\"file\";s:44:\"2017/01/agricultural_products_Tunisia-13.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-13-300x210.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-13-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-13-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("720", "1427", "_wp_attached_file", "2017/01/agricultural_products_Tunisia-14.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("721", "1427", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:680;s:6:\"height\";i:510;s:4:\"file\";s:44:\"2017/01/agricultural_products_Tunisia-14.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-14-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-14-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-14-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-14-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:44:\"agricultural_products_Tunisia-14-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("722", "1432", "_wp_attached_file", "2017/01/Leather-Bags.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("723", "1432", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:1328;s:4:\"file\";s:24:\"2017/01/Leather-Bags.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"Leather-Bags-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"Leather-Bags-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"Leather-Bags-768x510.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"Leather-Bags-1024x680.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:680;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:24:\"Leather-Bags-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:24:\"Leather-Bags-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:24:\"Leather-Bags-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"PENTAX K-x\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1334072097\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"50\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:6:\"0.0125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("724", "1433", "_wp_attached_file", "2017/01/lismore_diamond_stemware_ca_1.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("725", "1433", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:504;s:6:\"height\";i:504;s:4:\"file\";s:41:\"2017/01/lismore_diamond_stemware_ca_1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"lismore_diamond_stemware_ca_1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"lismore_diamond_stemware_ca_1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:41:\"lismore_diamond_stemware_ca_1-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:41:\"lismore_diamond_stemware_ca_1-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:41:\"lismore_diamond_stemware_ca_1-504x400.jpg\";s:5:\"width\";i:504;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("726", "1434", "_wp_attached_file", "2017/01/lismore_diamond_stemware_main_4.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("727", "1434", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2700;s:6:\"height\";i:600;s:4:\"file\";s:43:\"2017/01/lismore_diamond_stemware_main_4.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"lismore_diamond_stemware_main_4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:42:\"lismore_diamond_stemware_main_4-300x67.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:67;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:43:\"lismore_diamond_stemware_main_4-768x171.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:171;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:44:\"lismore_diamond_stemware_main_4-1024x228.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:228;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:43:\"lismore_diamond_stemware_main_4-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:43:\"lismore_diamond_stemware_main_4-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:43:\"lismore_diamond_stemware_main_4-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("728", "1435", "_wp_attached_file", "2017/01/Porcelain.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("729", "1435", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1500;s:6:\"height\";i:1500;s:4:\"file\";s:21:\"2017/01/Porcelain.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"Porcelain-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"Porcelain-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"Porcelain-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"Porcelain-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:21:\"Porcelain-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:21:\"Porcelain-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:21:\"Porcelain-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("730", "1436", "_wp_attached_file", "2017/01/Silverware_Tray.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("731", "1436", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:850;s:6:\"height\";i:565;s:4:\"file\";s:27:\"2017/01/Silverware_Tray.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"Silverware_Tray-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"Silverware_Tray-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:27:\"Silverware_Tray-768x510.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:27:\"Silverware_Tray-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:27:\"Silverware_Tray-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:27:\"Silverware_Tray-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("732", "1441", "_wp_attached_file", "2017/01/agricultural_products_Tunisia_Sfax-1.jpeg");
INSERT INTO `abchrgrp_postmeta` VALUES("733", "1441", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:265;s:4:\"file\";s:49:\"2017/01/agricultural_products_Tunisia_Sfax-1.jpeg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-1-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-1-300x133.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:133;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-1-300x150.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-1-480x265.jpeg\";s:5:\"width\";i:480;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("734", "1442", "_wp_attached_file", "2017/01/agricultural_products_Tunisia_Sfax-1.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("735", "1442", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1600;s:6:\"height\";i:1066;s:4:\"file\";s:48:\"2017/01/agricultural_products_Tunisia_Sfax-1.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-1-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-1-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-1-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-1-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("736", "1443", "_wp_attached_file", "2017/01/agricultural_products_Tunisia_Sfax-1.png");
INSERT INTO `abchrgrp_postmeta` VALUES("737", "1443", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:680;s:6:\"height\";i:350;s:4:\"file\";s:48:\"2017/01/agricultural_products_Tunisia_Sfax-1.png\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-1-300x154.png\";s:5:\"width\";i:300;s:6:\"height\";i:154;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-1-300x150.png\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-1-480x300.png\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-1-640x350.png\";s:5:\"width\";i:640;s:6:\"height\";i:350;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("738", "1444", "_wp_attached_file", "2017/01/agricultural_products_Tunisia_Sfax-2.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("739", "1444", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:520;s:6:\"height\";i:381;s:4:\"file\";s:48:\"2017/01/agricultural_products_Tunisia_Sfax-2.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-2-300x220.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-2-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-2-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("740", "1445", "_wp_attached_file", "2017/01/agricultural_products_Tunisia_Sfax-3.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("741", "1445", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:470;s:6:\"height\";i:353;s:4:\"file\";s:48:\"2017/01/agricultural_products_Tunisia_Sfax-3.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-3-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-3-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-3-470x300.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("742", "1446", "_wp_attached_file", "2017/01/agricultural_products_Tunisia_Sfax-4.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("743", "1446", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:599;s:6:\"height\";i:510;s:4:\"file\";s:48:\"2017/01/agricultural_products_Tunisia_Sfax-4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-4-300x255.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:255;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-4-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-4-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-4-599x400.jpg\";s:5:\"width\";i:599;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("744", "1447", "_wp_attached_file", "2017/01/agricultural_products_Tunisia_Sfax-5.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("745", "1447", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:300;s:4:\"file\";s:48:\"2017/01/agricultural_products_Tunisia_Sfax-5.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-5-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-5-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-5-400x300.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:3:\"jcm\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:36:\"Dattes et leur reflet dans un miroir\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:3:\"jcm\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:36:\"Dattes et leur reflet dans un miroir\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:14:{i:0;s:5:\"datte\";i:1;s:6:\"dattes\";i:2;s:6:\"reflet\";i:3;s:6:\"miroir\";i:4;s:4:\"brun\";i:5;s:5:\"blanc\";i:6;s:5:\"fruit\";i:7;s:5:\"datte\";i:8;s:6:\"dattes\";i:9;s:6:\"reflet\";i:10;s:6:\"miroir\";i:11;s:4:\"brun\";i:12;s:5:\"blanc\";i:13;s:5:\"fruit\";}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("746", "1448", "_wp_attached_file", "2017/01/agricultural_products_Tunisia_Sfax-6.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("747", "1448", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:626;s:6:\"height\";i:380;s:4:\"file\";s:48:\"2017/01/agricultural_products_Tunisia_Sfax-6.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-6-300x182.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-6-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-6-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("748", "1449", "_wp_attached_file", "2017/01/agricultural_products_Tunisia_Sfax-7.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("749", "1449", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:377;s:4:\"file\";s:48:\"2017/01/agricultural_products_Tunisia_Sfax-7.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-7-300x110.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:110;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-7-768x283.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:283;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-7-1024x377.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:377;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-7-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-7-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-7-640x377.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:377;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("750", "1450", "_wp_attached_file", "2017/01/agricultural_products_Tunisia_Sfax-8.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("751", "1450", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:878;s:6:\"height\";i:535;s:4:\"file\";s:48:\"2017/01/agricultural_products_Tunisia_Sfax-8.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-8-300x183.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:183;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-8-768x468.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-8-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-8-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-8-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("752", "1451", "_wp_attached_file", "2017/01/agricultural_products_Tunisia_Sfax-9.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("753", "1451", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1400;s:6:\"height\";i:787;s:4:\"file\";s:48:\"2017/01/agricultural_products_Tunisia_Sfax-9.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-9-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-9-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-9-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-9-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-9-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:48:\"agricultural_products_Tunisia_Sfax-9-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:3:\"NPR\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:73:\"Just a spoonful of the spicy chili paste known as harissa goes a long way\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:10:\"Harissa_02\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:1:{i:0;s:19:\"|storyid=154293245|\";}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("754", "1452", "_wp_attached_file", "2017/01/agricultural_products_Tunisia_Sfax-10.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("755", "1452", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:295;s:6:\"height\";i:300;s:4:\"file\";s:49:\"2017/01/agricultural_products_Tunisia_Sfax-10.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-10-295x300.jpg\";s:5:\"width\";i:295;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-10-295x150.jpg\";s:5:\"width\";i:295;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-10-295x300.jpg\";s:5:\"width\";i:295;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("756", "1453", "_wp_attached_file", "2017/01/agricultural_products_Tunisia_Sfax-11.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("757", "1453", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:980;s:6:\"height\";i:360;s:4:\"file\";s:49:\"2017/01/agricultural_products_Tunisia_Sfax-11.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-11-300x110.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:110;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-11-768x282.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:282;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-11-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-11-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-11-640x360.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("758", "1454", "_wp_attached_file", "2017/01/agricultural_products_Tunisia_Sfax-12.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("759", "1454", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:640;s:6:\"height\";i:426;s:4:\"file\";s:49:\"2017/01/agricultural_products_Tunisia_Sfax-12.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-12-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-12-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-12-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-12-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-12-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:7:\"DSC-W80\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1200392197\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"8.7\";s:3:\"iso\";s:3:\"160\";s:13:\"shutter_speed\";s:8:\"0.000625\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("760", "1455", "_wp_attached_file", "2017/01/agricultural_products_Tunisia_Sfax-13.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("761", "1455", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:350;s:4:\"file\";s:49:\"2017/01/agricultural_products_Tunisia_Sfax-13.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-13-300x210.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-13-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-13-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `abchrgrp_postmeta` VALUES("762", "1456", "_wp_attached_file", "2017/01/agricultural_products_Tunisia_Sfax-14.jpg");
INSERT INTO `abchrgrp_postmeta` VALUES("763", "1456", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:680;s:6:\"height\";i:510;s:4:\"file\";s:49:\"2017/01/agricultural_products_Tunisia_Sfax-14.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-14-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-14-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"onepress-blog-small\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-14-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"onepress-small\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-14-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"onepress-medium\";a:4:{s:4:\"file\";s:49:\"agricultural_products_Tunisia_Sfax-14-640x400.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");

/* INSERT TABLE DATA: abchrgrp_posts */
INSERT INTO `abchrgrp_posts` VALUES("1", "1", "2017-01-22 12:42:21", "2017-01-22 12:42:21", "Welcome to WordPress. This is your first post. Edit or delete it, then start writing!", "Hello world!", "", "publish", "open", "open", "", "hello-world", "", "", "2017-01-22 12:42:21", "2017-01-22 12:42:21", "", "0", "http://www.abchirgroup.com/?p=1", "0", "post", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("2", "1", "2017-01-22 12:42:21", "2017-01-22 12:42:21", "This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:\n\n<blockquote>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</blockquote>\n\n...or something like this:\n\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\n\nAs a new WordPress user, you should go to <a href=\"http://www.abchirgroup.com/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!", "Sample Page", "", "publish", "closed", "open", "", "sample-page", "", "", "2017-01-22 12:42:21", "2017-01-22 12:42:21", "", "0", "http://www.abchirgroup.com/?page_id=2", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1349", "1", "2017-01-30 09:41:41", "2017-01-30 09:41:41", "Description Here 4", "Description Here 1", "Description Here 2", "inherit", "open", "closed", "", "team5-480x300", "", "", "2017-01-30 09:42:03", "2017-01-30 09:42:03", "", "0", "http://www.abchirgroup.com/wp-content/uploads/2017/01/team5-480x300.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1354", "1", "2017-01-31 00:45:34", "2017-01-31 00:45:34", "", "Sectors", "", "publish", "closed", "closed", "", "sectors", "", "", "2017-01-31 00:46:50", "2017-01-31 00:46:50", "", "0", "http://www.abchirgroup.com/?p=1354", "4", "nav_menu_item", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1361", "1", "2017-01-31 01:13:22", "2017-01-31 01:13:22", "http://www.abchirgroup.com/wp-content/uploads/2017/01/cropped-logo-final.png", "cropped-logo-final.png", "", "inherit", "open", "closed", "", "cropped-logo-final-png", "", "", "2017-01-31 01:13:22", "2017-01-31 01:13:22", "", "0", "http://www.abchirgroup.com/wp-content/uploads/2017/01/cropped-logo-final.png", "0", "attachment", "image/png", "0");
INSERT INTO `abchrgrp_posts` VALUES("1368", "1", "2017-01-31 01:19:02", "2017-01-31 01:19:02", "", "logo 2", "", "inherit", "open", "closed", "", "logo-2", "", "", "2017-01-31 01:19:02", "2017-01-31 01:19:02", "", "0", "http://www.abchirgroup.com/wp-content/uploads/2017/01/logo-2.png", "0", "attachment", "image/png", "0");
INSERT INTO `abchrgrp_posts` VALUES("1372", "1", "2017-01-31 01:22:36", "2017-01-31 01:22:36", "http://www.abchirgroup.com/wp-content/uploads/2017/01/cropped-Abchir_Site_Icon.png", "cropped-Abchir_Site_Icon.png", "", "inherit", "open", "closed", "", "cropped-abchir_site_icon-png", "", "", "2017-01-31 01:22:36", "2017-01-31 01:22:36", "", "0", "http://www.abchirgroup.com/wp-content/uploads/2017/01/cropped-Abchir_Site_Icon.png", "0", "attachment", "image/png", "0");
INSERT INTO `abchrgrp_posts` VALUES("1374", "1", "2017-01-31 01:24:08", "2017-01-31 01:24:08", "", "Abchir_Site_Icon", "", "inherit", "open", "closed", "", "abchir_site_icon", "", "", "2017-01-31 01:24:08", "2017-01-31 01:24:08", "", "0", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Abchir_Site_Icon.png", "0", "attachment", "image/png", "0");
INSERT INTO `abchrgrp_posts` VALUES("1375", "1", "2017-01-31 01:24:13", "2017-01-31 01:24:13", "http://www.abchirgroup.com/wp-content/uploads/2017/01/cropped-Abchir_Site_Icon-1.png", "cropped-Abchir_Site_Icon-1.png", "", "inherit", "open", "closed", "", "cropped-abchir_site_icon-1-png", "", "", "2017-01-31 01:24:13", "2017-01-31 01:24:13", "", "0", "http://www.abchirgroup.com/wp-content/uploads/2017/01/cropped-Abchir_Site_Icon-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `abchrgrp_posts` VALUES("1379", "1", "2017-01-31 01:36:00", "2017-01-31 01:36:00", "", "Abchir_Group_Sfax_Tunisia_Logo", "Abchir_Group_Sfax_Tunisia_Logo", "inherit", "open", "closed", "", "abchir_group_sfax_tunisia_logo", "", "", "2017-01-31 01:36:18", "2017-01-31 01:36:18", "", "0", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Abchir_Group_Sfax_Tunisia_Logo.png", "0", "attachment", "image/png", "0");
INSERT INTO `abchrgrp_posts` VALUES("1380", "1", "2017-01-31 02:16:36", "2017-01-31 02:16:36", "Cheese, Harissa, Fish", "Foods", "", "inherit", "open", "closed", "", "foods_sfax_tunisia_import_export", "", "", "2017-01-31 02:20:32", "2017-01-31 02:20:32", "", "0", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Foods_Sfax_Tunisia_Import_Export.png", "0", "attachment", "image/png", "0");
INSERT INTO `abchrgrp_posts` VALUES("1382", "1", "2017-01-31 02:31:21", "2017-01-31 02:31:21", "Handcrafts, Home Silverware, Trays, Porcelaine, Glass, Leather", "Handcrafts", "", "inherit", "open", "closed", "", "handcrafts_sfax_tunisia_import_export", "", "", "2017-01-31 02:32:23", "2017-01-31 02:32:23", "", "0", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Handcrafts_Sfax_Tunisia_Import_Export.png", "0", "attachment", "image/png", "0");
INSERT INTO `abchrgrp_posts` VALUES("1385", "1", "2017-01-31 02:36:06", "2017-01-31 02:36:06", "[gallery link=\"file\" size=\"medium\" ids=\"1394,1395,1396,1397,1398,1399,1400,1401,1402\"]\r\n\r\n&nbsp;\r\n\r\n[gallery size=\"medium\" link=\"file\" ids=\"1404,1405,1406,1407\"]", "TEXTILE & FABRICS", "", "publish", "closed", "closed", "", "textile-fabrics", "", "", "2017-01-31 12:17:21", "2017-01-31 12:17:21", "", "0", "http://www.abchirgroup.com/?page_id=1385", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("22", "1", "2017-01-22 12:50:02", "2017-01-22 12:50:02", "", "Home", "", "publish", "closed", "closed", "", "home", "", "", "2017-01-22 13:05:51", "2017-01-22 13:05:51", "", "0", "http://www.abchirgroup.com/?page_id=22", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1388", "1", "2017-01-31 02:36:49", "2017-01-31 02:36:49", "[gallery link=\"file\" size=\"medium\" ids=\"1413,1415,1416,1417,1418,1419,1420,1423,1424,1425,1426,1427\"]", "AGRICULTURAL PRODUCTS", "", "publish", "closed", "closed", "", "agricultural-products", "", "", "2017-01-31 12:26:39", "2017-01-31 12:26:39", "", "0", "http://www.abchirgroup.com/?page_id=1388", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("27", "1", "2017-01-22 13:00:26", "2017-01-22 13:00:26", "<label> Your Name (required)\r\n    [text* your-name] </label>\r\n\r\n<label> Your Email (required)\r\n    [email* your-email] </label>\r\n\r\n<label> Subject\r\n    [text your-subject] </label>\r\n\r\n<label> Your Message\r\n    [textarea your-message] </label>\r\n[recaptcha]\r\n[submit \"Send\"]\nAbchir Group | Import - Export - Wholesale | Tunisia \"[your-subject]\"\n[your-name] <wordpress@abchirgroup.com>\nFrom: [your-name] <[your-email]>\r\nSubject: [your-subject]\r\n\r\nMessage Body:\r\n[your-message]\r\n\r\n--\r\nThis e-mail was sent from a contact form on Abchir Group | Import - Export - Wholesale | Tunisia (http://www.abchirgroup.com)\nomar.jallouli@gmail.com\nReply-To: [your-email]\n\n\n\n\nAbchir Group | Import - Export - Wholesale | Tunisia \"[your-subject]\"\nAbchir Group | Import - Export - Wholesale | Tunisia <wordpress@abchirgroup.com>\nMessage Body:\r\n[your-message]\r\n\r\n--\r\nThis e-mail was sent from a contact form on Abchir Group | Import - Export - Wholesale | Tunisia (http://www.abchirgroup.com)\n[your-email]\nReply-To: omar.jallouli@gmail.com\n\n\n\nThank you for your message. It has been sent.\nThere was an error trying to send your message. Please try again later.\nOne or more fields have an error. Please check and try again.\nThere was an error trying to send your message. Please try again later.\nYou must accept the terms and conditions before sending your message.\nThe field is required.\nThe field is too long.\nThe field is too short.\nThe date format is incorrect.\nThe date is before the earliest one allowed.\nThe date is after the latest one allowed.\nThere was an unknown error uploading the file.\nYou are not allowed to upload files of this type.\nThe file is too big.\nThere was an error uploading the file.\nThe number format is invalid.\nThe number is smaller than the minimum allowed.\nThe number is larger than the maximum allowed.\nThe answer to the quiz is incorrect.\nYour entered code is incorrect.\nThe e-mail address entered is invalid.\nThe URL is invalid.\nThe telephone number is invalid.", "Contact form 1", "", "publish", "closed", "closed", "", "contact-form-1", "", "", "2017-05-06 16:32:17", "2017-05-06 16:32:17", "", "0", "http://www.abchirgroup.com/?post_type=wpcf7_contact_form&#038;p=27", "0", "wpcf7_contact_form", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1356", "1", "2017-01-31 00:49:09", "2017-01-31 00:49:09", "Clothing, Cosmopolitan Habits, Carpets & Rugs", "Textile & Fabrics", "Clothing, Cosmopolitan Habits, Carpets, Rugs", "inherit", "open", "closed", "", "textile_fabrics_sfax_tunisia_import_export", "", "", "2017-01-31 00:49:49", "2017-01-31 00:49:49", "", "0", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Textile_Fabrics_Sfax_Tunisia_Import_Export.png", "0", "attachment", "image/png", "0");
INSERT INTO `abchrgrp_posts` VALUES("35", "1", "2016-02-12 07:54:41", "2016-02-12 07:54:41", "", "Home", "", "publish", "closed", "closed", "", "home-2", "", "", "2016-02-12 07:54:41", "2016-02-12 07:54:41", "", "0", "http://demos.famethemes.com/onepress/?page_id=4", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("36", "1", "2016-02-12 07:55:23", "2016-02-12 07:55:23", "", "News", "", "publish", "closed", "closed", "", "news", "", "", "2016-02-12 07:55:23", "2016-02-12 07:55:23", "", "0", "http://demos.famethemes.com/onepress/?page_id=5", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("37", "1", "2016-02-12 08:09:36", "2016-02-12 08:09:36", "Abchir Group is a well-established business consultancy company that relies on the deep experience of their consultants in the Tunisian and global markets ", "Our History", "Nullam ut tempor eros. Donec faucibus, velit et imperdiet aliquam, lacus velit luctus urna, vitae porttitor orci libero id felis.", "publish", "closed", "closed", "", "our-history", "", "", "2017-01-22 14:42:11", "2017-01-22 14:42:11", "", "0", "http://demos.famethemes.com/onepress/?page_id=17", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("38", "1", "2016-02-12 08:10:47", "2016-02-12 08:10:47", "Nullam ut tempor eros. Donec faucibus, velit et imperdiet aliquam, lacus velit luctus urna, vitae porttitor orci libero id felis.", "Our Achievements", "Nullam ut tempor eros. Donec faucibus, velit et imperdiet aliquam, lacus velit luctus urna, vitae porttitor orci libero id felis.", "publish", "closed", "closed", "", "our-achievements", "", "", "2016-02-12 08:10:47", "2016-02-12 08:10:47", "", "0", "http://demos.famethemes.com/onepress/?page_id=21", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("39", "1", "2016-02-12 08:11:05", "2016-02-12 08:11:05", "Our vision is to ensure customer satisfaction, leading to easier trade partnetships between Tunisian and Global Business partners", "Our Vision", "Nullam ut tempor eros. Donec faucibus, velit et imperdiet aliquam, lacus velit luctus urna, vitae porttitor orci libero id felis.", "publish", "closed", "closed", "", "our-vision", "", "", "2017-01-22 14:49:00", "2017-01-22 14:49:00", "", "0", "http://demos.famethemes.com/onepress/?page_id=22", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("44", "1", "2016-02-12 08:27:17", "2016-02-12 08:27:17", "<h3><img class=\"alignnone wp-image-35 size-full\" src=\"http://demos.famethemes.com/onepress/wp-content/uploads/sites/17/2016/02/blog4.jpg\" alt=\"blog4\" width=\"1280\" height=\"853\" /></h3>\n<h3>Default</h3>\nThis is a paragraph. It should not have any alignment of any kind. It should just flow like you would normally expect. Nothing fancy. Just straight up text, free flowing, with love. Completely neutral and not picking a side or sitting on the fence. It just is. It just freaking is. It likes where it is. It does not feel compelled to pick a side. Leave him be. It will just be better that way. Trust me.\n<h3>Left Align</h3>\n<p style=\"text-align: left;\">This is a paragraph. It is left aligned. Because of this, it is a bit more liberal in it\'s views. It\'s favorite color is green. Left align tends to be more eco-friendly, but it provides no concrete evidence that it really is. Even though it likes share the wealth evenly, it leaves the equal distribution up to justified alignment.</p>\n\n<h3>Center Align</h3>\n<p style=\"text-align: center;\">This is a paragraph. It is center aligned. Center is, but nature, a fence sitter. A flip flopper. It has a difficult time making up its mind. It wants to pick a side. Really, it does. It has the best intentions, but it tends to complicate matters more than help. The best you can do is try to win it over and hope for the best. I hear center align does take bribes.</p>\n\n<h3>Right Align</h3>\n<p style=\"text-align: right;\">This is a paragraph. It is right aligned. It is a bit more conservative in it\'s views. It\'s prefers to not be told what to do or how to do it. Right align totally owns a slew of guns and loves to head to the range for some practice. Which is cool and all. I mean, it\'s a pretty good shot from at least four or five football fields away. Dead on. So boss.</p>\n\n<h3>Justify Align</h3>\n<p style=\"text-align: justify;\">This is a paragraph. It is justify aligned. It gets really mad when people associate it with Justin Timberlake. Typically, justified is pretty straight laced. It likes everything to be in it\'s place and not all cattywampus like the rest of the aligns. I am not saying that makes it better than the rest of the aligns, but it does tend to put off more of an elitist attitude.</p>", "Markup: Text Alignment", "", "publish", "open", "open", "", "markup-text-alignment", "", "", "2016-02-12 08:27:17", "2016-02-12 08:27:17", "", "0", "http://demos.famethemes.com/onepress/?p=33", "0", "post", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("45", "1", "2016-02-12 08:28:47", "2016-02-12 08:28:47", "<h2>Headings</h2>\n<h1>Header one</h1>\n<h2>Header two</h2>\n<h3>Header three</h3>\n<h4>Header four</h4>\n<h5>Header five</h5>\n<h6>Header six</h6>\n<h2>Blockquotes</h2>\nSingle line blockquote:\n<blockquote>Stay hungry. Stay foolish.</blockquote>\nMulti line blockquote with a cite reference:\n<blockquote>People think focus means saying yes to the thing you\'ve got to focus on. But that\'s not what it means at all. It means saying no to the hundred other good ideas that there are. You have to pick carefully. I\'m actually as proud of the things we haven\'t done as the things I have done. Innovation is saying no to 1,000 things.</blockquote>\n<cite>Steve Jobs</cite> - Apple Worldwide Developers\' Conference, 1997\n<h2>Tables</h2>\n<table>\n<thead>\n<tr>\n<th>Employee</th>\n<th>Salary</th>\n<th></th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<th><a href=\"http://example.org/\">John Doe</a></th>\n<td>$1</td>\n<td>Because that\'s all Steve Jobs needed for a salary.</td>\n</tr>\n<tr>\n<th><a href=\"http://example.org/\">Jane Doe</a></th>\n<td>$100K</td>\n<td>For all the blogging she does.</td>\n</tr>\n<tr>\n<th><a href=\"http://example.org/\">Fred Bloggs</a></th>\n<td>$100M</td>\n<td>Pictures are worth a thousand words, right? So Jane x 1,000.</td>\n</tr>\n<tr>\n<th><a href=\"http://example.org/\">Jane Bloggs</a></th>\n<td>$100B</td>\n<td>With hair like that?! Enough said...</td>\n</tr>\n</tbody>\n</table>\n<h2>Definition Lists</h2>\n<dl><dt>Definition List Title</dt><dd>Definition list division.</dd><dt>Startup</dt><dd>A startup company or startup is a company or temporary organization designed to search for a repeatable and scalable business model.</dd><dt>#dowork</dt><dd>Coined by Rob Dyrdek and his personal body guard Christopher \"Big Black\" Boykins, \"Do Work\" works as a self motivator, to motivating your friends.</dd><dt>Do It Live</dt><dd>I\'ll let Bill O\'Reilly will <a title=\"We\'ll Do It Live\" href=\"https://www.youtube.com/watch?v=O_HyZ5aW76c\">explain</a> this one.</dd></dl>\n<h2>Unordered Lists (Nested)</h2>\n<ul>\n	<li>List item one\n<ul>\n	<li>List item one\n<ul>\n	<li>List item one</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ul>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ul>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ul>\n<h2>Ordered List (Nested)</h2>\n<ol>\n	<li>List item one\n<ol>\n	<li>List item one\n<ol>\n	<li>List item one</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ol>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ol>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ol>\n<h2>HTML Tags</h2>\nThese supported tags come from the WordPress.com code <a title=\"Code\" href=\"http://en.support.wordpress.com/code/\">FAQ</a>.\n\n<strong>Address Tag</strong>\n\n<address>1 Infinite Loop\nCupertino, CA 95014\nUnited States</address><strong>Anchor Tag (aka. Link)</strong>\n\nThis is an example of a <a title=\"Apple\" href=\"http://apple.com\">link</a>.\n\n<strong>Abbreviation Tag</strong>\n\nThe abbreviation <abbr title=\"Seriously\">srsly</abbr> stands for \"seriously\".\n\n<strong>Acronym Tag (<em>deprecated in HTML5</em>)</strong>\n\nThe acronym <acronym title=\"For The Win\">ftw</acronym> stands for \"for the win\".\n\n<strong>Big Tag <strong>(<em>deprecated in HTML5</em>)</strong></strong>\n\nThese tests are a <big>big</big> deal, but this tag is no longer supported in HTML5.\n\n<strong>Cite Tag</strong>\n\n\"Code is poetry.\" --<cite>Automattic</cite>\n\n<strong>Code Tag</strong>\n\nYou will learn later on in these tests that <code>word-wrap: break-word;</code> will be your best friend.\n\n<strong>Delete Tag</strong>\n\nThis tag will let you <del>strikeout text</del>, but this tag is no longer supported in HTML5 (use the <code>&lt;strike&gt;</code> instead).\n\n<strong>Emphasize Tag</strong>\n\nThe emphasize tag should <em>italicize</em> text.\n\n<strong>Insert Tag</strong>\n\nThis tag should denote <ins>inserted</ins> text.\n\n<strong>Keyboard Tag</strong>\n\nThis scarcely known tag emulates <kbd>keyboard text</kbd>, which is usually styled like the <code>&lt;code&gt;</code> tag.\n\n<strong>Preformatted Tag</strong>\n\nThis tag styles large blocks of code.\n<pre>.post-title {\n	margin: 0 0 5px;\n	font-weight: bold;\n	font-size: 38px;\n	line-height: 1.2;\n	and here\'s a line of some really, really, really, really long text, just to see how the PRE tag handles it and to find out how it overflows;\n}</pre>\n<strong>Quote Tag</strong>\n\n<q>Developers, developers, developers...</q> --Steve Ballmer\n\n<strong>Strike Tag <strong>(<em>deprecated in HTML5</em>)</strong></strong>\n\nThis tag shows <span style=\"text-decoration: line-through;\">strike-through text</span>\n\n<strong>Strong Tag</strong>\n\nThis tag shows <strong>bold<strong> text.</strong></strong>\n\n<strong>Subscript Tag</strong>\n\nGetting our science styling on with H<sub>2</sub>O, which should push the \"2\" down.\n\n<strong>Superscript Tag</strong>\n\nStill sticking with science and Isaac Newton\'s E = MC<sup>2</sup>, which should lift the 2 up.\n\n<strong>Teletype Tag <strong>(<em>deprecated in HTML5</em>)</strong></strong>\n\nThis rarely used tag emulates <tt>teletype text</tt>, which is usually styled like the <code>&lt;code&gt;</code> tag.\n\n<strong>Variable Tag</strong>\n\nThis allows you to denote <var>variables</var>.", "Markup: HTML Tags and Formatting", "", "publish", "open", "open", "", "markup-html-tags-and-formatting", "", "", "2016-02-12 08:28:47", "2016-02-12 08:28:47", "", "0", "http://demos.famethemes.com/onepress/?p=37", "0", "post", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1177", "1", "2013-01-10 20:15:40", "2013-01-11 03:15:40", "Welcome to image alignment! The best way to demonstrate the ebb and flow of the various image positioning options is to nestle them snuggly among an ocean of words. Grab a paddle and let\'s get started.\n\nOn the topic of alignment, it should be noted that users can choose from the options of <em>None</em>, <em>Left</em>, <em>Right, </em>and <em>Center</em>. In addition, they also get the options of <em>Thumbnail</em>, <em>Medium</em>, <em>Large</em> &amp; <em>Fullsize</em>.\n<p style=\"text-align: center;\"><img class=\"size-full wp-image-906 aligncenter\" title=\"Image Alignment 580x300\" src=\"http://demo.famethemes.com/onepress/wp-content/uploads/2013/03/image-alignment-580x300.jpg\" alt=\"Image Alignment 580x300\" width=\"580\" height=\"300\" /></p>\nThe image above happens to be <em><strong>centered</strong></em>.\n\n<strong><img class=\"size-full wp-image-904 alignleft\" title=\"Image Alignment 150x150\" src=\"http://demo.famethemes.com/onepress/wp-content/uploads/2013/03/image-alignment-150x150.jpg\" alt=\"Image Alignment 150x150\" width=\"150\" height=\"150\" /></strong>The rest of this paragraph is filler for the sake of seeing the text wrap around the 150x150 image, which is <em><strong>left aligned</strong></em>.\n\nAs you can see the should be some space above, below, and to the right of the image. The text should not be creeping on the image. Creeping is just not right. Images need breathing room too. Let them speak like you words. Let them do their jobs without any hassle from the text. In about one more sentence here, we\'ll see that the text moves from the right of the image down below the image in seamless transition. Again, letting the do it\'s thang. Mission accomplished!\n\nAnd now for a <em><strong>massively large image</strong></em>. It also has <em><strong>no alignment</strong></em>.\n\n<img class=\"alignnone wp-image-907\" title=\"Image Alignment 1200x400\" src=\"http://demo.famethemes.com/onepress/wp-content/uploads/2013/03/image-alignment-1200x4002.jpg\" alt=\"Image Alignment 1200x400\" width=\"1200\" height=\"400\" />\n\nThe image above, though 1200px wide, should not overflow the content area. It should remain contained with no visible disruption to the flow of content.\n\n<img class=\"size-full wp-image-905 alignright\" title=\"Image Alignment 300x200\" src=\"http://demo.famethemes.com/onepress/wp-content/uploads/2013/03/image-alignment-300x200.jpg\" alt=\"Image Alignment 300x200\" width=\"300\" height=\"200\" />\n\nAnd now we\'re going to shift things to the <em><strong>right align</strong></em>. Again, there should be plenty of room above, below, and to the left of the image. Just look at him there... Hey guy! Way to rock that right side. I don\'t care what the left aligned image says, you look great. Don\'t let anyone else tell you differently.\n\nIn just a bit here, you should see the text start to wrap below the right aligned image and settle in nicely. There should still be plenty of room and everything should be sitting pretty. Yeah... Just like that. It never felt so good to be right.\n\nAnd just when you thought we were done, we\'re going to do them all over again with captions!\n\n[caption id=\"attachment_906\" align=\"aligncenter\" width=\"580\"]<img class=\"size-full wp-image-906 \" title=\"Image Alignment 580x300\" src=\"http://demo.famethemes.com/onepress/wp-content/uploads/2013/03/image-alignment-580x300.jpg\" alt=\"Image Alignment 580x300\" width=\"580\" height=\"300\" /> Look at 580x300 getting some <a title=\"Image Settings\" href=\"http://en.support.wordpress.com/images/image-settings/\">caption</a> love.[/caption]\n\nThe image above happens to be <em><strong>centered</strong></em>. The caption also has a link in it, just to see if it does anything funky.\n\n[caption id=\"attachment_904\" align=\"alignleft\" width=\"150\"]<img class=\"size-full wp-image-904 \" title=\"Image Alignment 150x150\" src=\"http://demo.famethemes.com/onepress/wp-content/uploads/2013/03/image-alignment-150x150.jpg\" alt=\"Image Alignment 150x150\" width=\"150\" height=\"150\" /> Itty-bitty caption.[/caption]\n\nThe rest of this paragraph is filler for the sake of seeing the text wrap around the 150x150 image, which is <em><strong>left aligned</strong></em>.\n\nAs you can see the should be some space above, below, and to the right of the image. The text should not be creeping on the image. Creeping is just not right. Images need breathing room too. Let them speak like you words. Let them do their jobs without any hassle from the text. In about one more sentence here, we\'ll see that the text moves from the right of the image down below the image in seamless transition. Again, letting the do it\'s thang. Mission accomplished!\n\nAnd now for a <em><strong>massively large image</strong></em>. It also has <em><strong>no alignment</strong></em>.\n\n[caption id=\"attachment_907\" align=\"alignnone\" width=\"1200\"]<img class=\" wp-image-907\" title=\"Image Alignment 1200x400\" src=\"http://demo.famethemes.com/onepress/wp-content/uploads/2013/03/image-alignment-1200x4002.jpg\" alt=\"Image Alignment 1200x400\" width=\"1200\" height=\"400\" /> Massive image comment for your eyeballs.[/caption]\n\nThe image above, though 1200px wide, should not overflow the content area. It should remain contained with no visible disruption to the flow of content.\n\n[caption id=\"attachment_905\" align=\"alignright\" width=\"300\"]<img class=\"size-full wp-image-905 \" title=\"Image Alignment 300x200\" src=\"http://demo.famethemes.com/onepress/wp-content/uploads/2013/03/image-alignment-300x200.jpg\" alt=\"Image Alignment 300x200\" width=\"300\" height=\"200\" /> Feels good to be right all the time.[/caption]\n\nAnd now we\'re going to shift things to the <em><strong>right align</strong></em>. Again, there should be plenty of room above, below, and to the left of the image. Just look at him there... Hey guy! Way to rock that right side. I don\'t care what the left aligned image says, you look great. Don\'t let anyone else tell you differently.\n\nIn just a bit here, you should see the text start to wrap below the right aligned image and settle in nicely. There should still be plenty of room and everything should be sitting pretty. Yeah... Just like that. It never felt so good to be right.\n\nAnd that\'s a wrap, yo! You survived the tumultuous waters of alignment. Image alignment achievement unlocked!", "Markup: Image Alignment", "", "publish", "closed", "closed", "", "markup-image-alignment", "", "", "2013-01-10 20:15:40", "2013-01-11 03:15:40", "", "0", "http://wptest.io/demo/?p=903", "0", "post", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1182", "1", "2016-03-18 06:13:33", "2016-03-18 06:13:33", "", "Shop", "", "publish", "closed", "closed", "", "shop", "", "", "2016-03-18 06:13:33", "2016-03-18 06:13:33", "", "0", "http://demos.famethemes.com/onepress/shop/", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1183", "1", "2016-03-18 06:13:33", "2016-03-18 06:13:33", "[woocommerce_cart]", "Cart", "", "publish", "closed", "closed", "", "cart", "", "", "2016-03-18 06:13:33", "2016-03-18 06:13:33", "", "0", "http://demos.famethemes.com/onepress/cart/", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1184", "1", "2016-03-18 06:13:33", "2016-03-18 06:13:33", "[woocommerce_checkout]", "Checkout", "", "publish", "closed", "closed", "", "checkout", "", "", "2016-03-18 06:13:33", "2016-03-18 06:13:33", "", "0", "http://demos.famethemes.com/onepress/checkout/", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1185", "1", "2016-03-18 06:13:33", "2016-03-18 06:13:33", "[woocommerce_my_account]", "My Account", "", "publish", "closed", "closed", "", "my-account", "", "", "2016-03-18 06:13:33", "2016-03-18 06:13:33", "", "0", "http://demos.famethemes.com/onepress/my-account/", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1245", "1", "2016-10-05 09:12:09", "2016-10-05 09:12:09", "[gallery ids=\"1294,1283\"]\r\n\r\n[caption id=\"attachment_1294\" align=\"alignnone\" width=\"300\"]<a href=\"http://www.google.com\"><img class=\"wp-image-1294 size-medium\" src=\"http://www.abchirgroup.com/wp-content/uploads/2017/01/AbchirGroup_Purchasing_Sourcing_Sfax_Tunisia-300x199.png\" alt=\"AbchirGroup_Purchasing_Sourcing_Sfax_Tunisia\" width=\"300\" height=\"199\" /></a> pic 1 i want description here[/caption]", "Gallery", "", "publish", "closed", "closed", "", "gallery", "", "", "2017-01-30 09:29:30", "2017-01-30 09:29:30", "", "0", "http://demos.famethemes.com/onepress/?page_id=1245", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1247", "1", "2016-02-12 07:55:32", "2016-02-12 07:55:32", "<p>Your Name (required)<br />\r\n    [text* your-name] </p>\r\n\r\n<p>Your Email (required)<br />\r\n    [email* your-email] </p>\r\n\r\n<p>Subject<br />\r\n    [text your-subject] </p>\r\n\r\n<p>Your Message<br />\r\n    [textarea your-message] </p>\r\n[recaptcha]\r\n<p>[submit \"Send\"]</p>\n[your-subject] Contact received\nomar.jallouli@abchirgroup.com\nFrom: [your-name] <[your-email]>\r\nSubject: [your-subject]\r\n\r\nMessage Body:\r\n[your-message]\r\n\r\n--\r\nThis e-mail was sent from a contact form on OnePress (http://demos.famethemes.com/onepress)\nomar.jallouli@gmail.com\nReply-To: [your-email]\n\n\n\n\n[your-subject]\nOnePress <wordpress@demos.famethemes.com>\nMessage Body:\r\n[your-message]\r\n\r\n--\r\nThis e-mail was sent from a contact form on OnePress (http://demos.famethemes.com/onepress)\n[your-email]\nReply-To: contact@famethemes.com\n\n\n\nYour message was sent successfully. Thanks.\nFailed to send your message. Please try later or contact the administrator by another method.\nValidation errors occurred. Please confirm the fields and submit it again.\nFailed to send your message. Please try later or contact the administrator by another method.\nPlease accept the terms to proceed.\nPlease fill in the required field.\nThis input is too long.\nThis input is too short.\nDate format seems invalid.\nThis date is too early.\nThis date is too late.\nFailed to upload file.\nThis file type is not allowed.\nThis file is too large.\nFailed to upload file. Error occurred.\nNumber format seems invalid.\nThis number is too small.\nThis number is too large.\nYour answer is not correct.\nYour entered code is incorrect.\nEmail address seems invalid.\nURL seems invalid.\nTelephone number seems invalid.", "Frontpage contact", "", "publish", "closed", "closed", "", "contact-form-1-2", "", "", "2017-05-06 16:32:40", "2017-05-06 16:32:40", "", "0", "http://demos.famethemes.com/onepress/?post_type=wpcf7_contact_form&#038;p=6", "0", "wpcf7_contact_form", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1257", "1", "2017-01-22 13:22:04", "2017-01-22 13:22:04", "", "Services", "", "publish", "closed", "closed", "", "services-2", "", "", "2017-01-31 00:46:49", "2017-01-31 00:46:49", "", "0", "http://www.abchirgroup.com/2017/01/22/services-2/", "3", "nav_menu_item", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1261", "1", "2017-01-22 13:22:04", "2017-01-22 13:22:04", "", "Contact", "", "publish", "closed", "closed", "", "contact-2", "", "", "2017-01-31 00:46:50", "2017-01-31 00:46:50", "", "0", "http://www.abchirgroup.com/2017/01/22/contact-2/", "5", "nav_menu_item", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1265", "1", "2017-01-22 13:26:45", "2017-01-22 13:26:45", "", "About", "", "publish", "closed", "closed", "", "about", "", "", "2017-01-31 00:46:49", "2017-01-31 00:46:49", "", "0", "http://www.abchirgroup.com/2017/01/22/about/", "2", "nav_menu_item", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1297", "1", "2017-01-22 14:57:13", "0000-00-00 00:00:00", " ", "", "", "draft", "closed", "closed", "", "", "", "", "2017-01-22 14:57:13", "0000-00-00 00:00:00", "", "0", "http://www.abchirgroup.com/?p=1297", "1", "nav_menu_item", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1298", "1", "2017-01-22 14:58:12", "2017-01-22 14:58:12", "", "ABCHIR Group", "", "publish", "closed", "closed", "", "abchir-group", "", "", "2017-01-31 00:46:49", "2017-01-31 00:46:49", "", "0", "http://www.abchirgroup.com/?p=1298", "1", "nav_menu_item", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1283", "1", "2017-01-22 14:25:32", "2017-01-22 14:25:32", "", "AbchirGroup_Business_Sfax_Tunisia", "pic 2, hola hola people", "inherit", "open", "closed", "", "abchirgroup_business_sfax_tunisia", "", "", "2017-01-30 09:28:01", "2017-01-30 09:28:01", "", "0", "http://www.abchirgroup.com/wp-content/uploads/2017/01/AbchirGroup_Business_Sfax_Tunisia.png", "0", "attachment", "image/png", "0");
INSERT INTO `abchrgrp_posts` VALUES("1294", "1", "2017-01-22 14:51:17", "2017-01-22 14:51:17", "", "AbchirGroup_Purchasing_Sourcing_Sfax_Tunisia", "pic 1 i want description here", "inherit", "open", "closed", "", "abchirgroup_purchasing_sourcing_sfax_tunisia", "", "", "2017-01-30 09:29:09", "2017-01-30 09:29:09", "", "1245", "http://www.abchirgroup.com/wp-content/uploads/2017/01/AbchirGroup_Purchasing_Sourcing_Sfax_Tunisia.png", "0", "attachment", "image/png", "0");
INSERT INTO `abchrgrp_posts` VALUES("1313", "1", "2017-01-22 15:19:53", "2017-01-22 15:19:53", "Personalized Sourcing from major global suppliers, tailored to your specific needs and requests", "Sourcing", "", "publish", "closed", "closed", "", "sourcing2", "", "", "2017-01-22 15:21:01", "2017-01-22 15:21:01", "", "0", "http://www.abchirgroup.com/?page_id=1313", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1319", "1", "2017-01-22 15:25:24", "2017-01-22 15:25:24", "Regular, Clearance & Closeout Sales Oppourtunities", "Purchasing", "", "publish", "closed", "closed", "", "purchasing", "", "", "2017-01-22 15:25:24", "2017-01-22 15:25:24", "", "0", "http://www.abchirgroup.com/?page_id=1319", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1323", "1", "2017-01-22 15:30:01", "2017-01-22 15:30:01", "We help foreign companies and exporters that are looking for a distributor in Tunisia. We can take care of the logistics of shipping, transport and warehousing. ", "Distributorship", "", "publish", "closed", "closed", "", "distributorship", "", "", "2017-01-22 15:33:13", "2017-01-22 15:33:13", "", "0", "http://www.abchirgroup.com/?page_id=1323", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1358", "1", "2017-01-31 01:07:02", "2017-01-31 01:07:02", "Flowers, Olive Oil, Dates, Orange", "Agricultural Products", "Agricultural Products Sfax Tunisia Import Export", "inherit", "open", "closed", "", "agriculture_sfax_tunisia_import_export", "", "", "2017-01-31 01:09:50", "2017-01-31 01:09:50", "", "0", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Agriculture_Sfax_Tunisia_Import_Export.png", "0", "attachment", "image/png", "0");
INSERT INTO `abchrgrp_posts` VALUES("1329", "1", "2017-01-22 15:36:10", "2017-01-22 15:36:10", "We help local and foreign companies with the import & export operations", "Import / Export", "", "publish", "closed", "closed", "", "import-export", "", "", "2017-01-22 15:36:10", "2017-01-22 15:36:10", "", "0", "http://www.abchirgroup.com/?page_id=1329", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1443", "1", "2017-02-11 17:43:11", "2017-02-11 17:43:11", "", "agricultural_products_Tunisia_Sfax (1)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia_sfax-1-3", "", "", "2017-02-11 17:43:11", "2017-02-11 17:43:11", "", "1390", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia_Sfax-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `abchrgrp_posts` VALUES("1442", "1", "2017-02-11 17:43:07", "2017-02-11 17:43:07", "", "agricultural_products_Tunisia_Sfax (1)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia_sfax-1-2", "", "", "2017-02-11 17:43:07", "2017-02-11 17:43:07", "", "1390", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia_Sfax-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1441", "1", "2017-02-11 17:43:02", "2017-02-11 17:43:02", "", "agricultural_products_Tunisia_Sfax (1)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia_sfax-1", "", "", "2017-02-11 17:43:02", "2017-02-11 17:43:02", "", "1390", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia_Sfax-1.jpeg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1390", "1", "2017-01-31 02:37:16", "2017-01-31 02:37:16", "[gallery link=\"file\" size=\"medium\" ids=\"1456,1455,1454,1453,1452,1451,1450,1449,1448,1447,1446,1445,1444,1443,1442,1441\"]", "Foods", "", "publish", "closed", "closed", "", "foods", "", "", "2017-02-11 17:46:11", "2017-02-11 17:46:11", "", "0", "http://www.abchirgroup.com/?page_id=1390", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1392", "1", "2017-01-31 02:37:37", "2017-01-31 02:37:37", "&nbsp;\r\n\r\n[gallery link=\"file\" size=\"medium\" ids=\"1432,1435,1436\"]", "HANDCRAFTS", "", "publish", "closed", "closed", "", "handcrafts", "", "", "2017-02-11 17:41:02", "2017-02-11 17:41:02", "", "0", "http://www.abchirgroup.com/?page_id=1392", "0", "page", "", "0");
INSERT INTO `abchrgrp_posts` VALUES("1394", "1", "2017-01-31 12:13:50", "2017-01-31 12:13:50", "", "Clothing_Textile_Tunisia (1)", "", "inherit", "open", "closed", "", "clothing_textile_tunisia-1", "", "", "2017-01-31 12:13:50", "2017-01-31 12:13:50", "", "1385", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Clothing_Textile_Tunisia-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1395", "1", "2017-01-31 12:13:52", "2017-01-31 12:13:52", "", "Clothing_Textile_Tunisia (1)", "", "inherit", "open", "closed", "", "clothing_textile_tunisia-1-2", "", "", "2017-01-31 12:13:52", "2017-01-31 12:13:52", "", "1385", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Clothing_Textile_Tunisia-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `abchrgrp_posts` VALUES("1396", "1", "2017-01-31 12:13:56", "2017-01-31 12:13:56", "", "Clothing_Textile_Tunisia (2)", "", "inherit", "open", "closed", "", "clothing_textile_tunisia-2", "", "", "2017-01-31 12:13:56", "2017-01-31 12:13:56", "", "1385", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Clothing_Textile_Tunisia-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1397", "1", "2017-01-31 12:13:59", "2017-01-31 12:13:59", "", "Clothing_Textile_Tunisia (3)", "", "inherit", "open", "closed", "", "clothing_textile_tunisia-3", "", "", "2017-01-31 12:13:59", "2017-01-31 12:13:59", "", "1385", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Clothing_Textile_Tunisia-3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1398", "1", "2017-01-31 12:14:01", "2017-01-31 12:14:01", "", "Clothing_Textile_Tunisia (4)", "", "inherit", "open", "closed", "", "clothing_textile_tunisia-4", "", "", "2017-01-31 12:14:01", "2017-01-31 12:14:01", "", "1385", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Clothing_Textile_Tunisia-4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1399", "1", "2017-01-31 12:14:04", "2017-01-31 12:14:04", "", "Clothing_Textile_Tunisia (5)", "", "inherit", "open", "closed", "", "clothing_textile_tunisia-5", "", "", "2017-01-31 12:14:04", "2017-01-31 12:14:04", "", "1385", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Clothing_Textile_Tunisia-5.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1400", "1", "2017-01-31 12:14:06", "2017-01-31 12:14:06", "", "Clothing_Textile_Tunisia (6)", "", "inherit", "open", "closed", "", "clothing_textile_tunisia-6", "", "", "2017-01-31 12:14:06", "2017-01-31 12:14:06", "", "1385", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Clothing_Textile_Tunisia-6.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1401", "1", "2017-01-31 12:14:07", "2017-01-31 12:14:07", "", "Clothing_Textile_Tunisia (7)", "", "inherit", "open", "closed", "", "clothing_textile_tunisia-7", "", "", "2017-01-31 12:14:07", "2017-01-31 12:14:07", "", "1385", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Clothing_Textile_Tunisia-7.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1402", "1", "2017-01-31 12:14:10", "2017-01-31 12:14:10", "", "Clothing_Textile_Tunisia (8)", "", "inherit", "open", "closed", "", "clothing_textile_tunisia-8", "", "", "2017-01-31 12:14:10", "2017-01-31 12:14:10", "", "1385", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Clothing_Textile_Tunisia-8.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1404", "1", "2017-01-31 12:16:03", "2017-01-31 12:16:03", "", "Rug_Carpet_Tunisia (1)", "", "inherit", "open", "closed", "", "rug_carpet_tunisia-1", "", "", "2017-01-31 12:16:03", "2017-01-31 12:16:03", "", "1385", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Rug_Carpet_Tunisia-1.jpeg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1405", "1", "2017-01-31 12:16:06", "2017-01-31 12:16:06", "", "Rug_Carpet_Tunisia (1)", "", "inherit", "open", "closed", "", "rug_carpet_tunisia-1-2", "", "", "2017-01-31 12:16:06", "2017-01-31 12:16:06", "", "1385", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Rug_Carpet_Tunisia-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1406", "1", "2017-01-31 12:16:32", "2017-01-31 12:16:32", "", "Rug_Carpet_Tunisia (2)", "", "inherit", "open", "closed", "", "rug_carpet_tunisia-2", "", "", "2017-01-31 12:16:32", "2017-01-31 12:16:32", "", "1385", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Rug_Carpet_Tunisia-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1407", "1", "2017-01-31 12:16:37", "2017-01-31 12:16:37", "", "Rug_Carpet_Tunisia (3)", "", "inherit", "open", "closed", "", "rug_carpet_tunisia-3", "", "", "2017-01-31 12:16:37", "2017-01-31 12:16:37", "", "1385", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Rug_Carpet_Tunisia-3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1412", "1", "2017-01-31 12:19:10", "2017-01-31 12:19:10", "", "agricultural_products_Tunisia (1)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia-1", "", "", "2017-01-31 12:19:10", "2017-01-31 12:19:10", "", "1388", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia-1.jpeg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1413", "1", "2017-01-31 12:19:16", "2017-01-31 12:19:16", "", "agricultural_products_Tunisia (1)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia-1-2", "", "", "2017-01-31 12:19:16", "2017-01-31 12:19:16", "", "1388", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1414", "1", "2017-01-31 12:19:20", "2017-01-31 12:19:20", "", "agricultural_products_Tunisia (1)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia-1-3", "", "", "2017-01-31 12:19:20", "2017-01-31 12:19:20", "", "1388", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `abchrgrp_posts` VALUES("1415", "1", "2017-01-31 12:19:23", "2017-01-31 12:19:23", "", "agricultural_products_Tunisia (2)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia-2", "", "", "2017-01-31 12:19:23", "2017-01-31 12:19:23", "", "1388", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1416", "1", "2017-01-31 12:19:24", "2017-01-31 12:19:24", "", "agricultural_products_Tunisia (3)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia-3", "", "", "2017-01-31 12:19:24", "2017-01-31 12:19:24", "", "1388", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia-3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1417", "1", "2017-01-31 12:19:26", "2017-01-31 12:19:26", "", "agricultural_products_Tunisia (4)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia-4", "", "", "2017-01-31 12:19:26", "2017-01-31 12:19:26", "", "1388", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia-4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1418", "1", "2017-01-31 12:19:28", "2017-01-31 12:19:28", "", "Dattes et leur reflet dans un miroir", "", "inherit", "open", "closed", "", "dattes-et-leur-reflet-dans-un-miroir", "", "", "2017-01-31 12:22:21", "2017-01-31 12:22:21", "", "1388", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia-5.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1419", "1", "2017-01-31 12:19:30", "2017-01-31 12:19:30", "", "agricultural_products_Tunisia (6)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia-6", "", "", "2017-01-31 12:19:30", "2017-01-31 12:19:30", "", "1388", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia-6.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1420", "1", "2017-01-31 12:19:31", "2017-01-31 12:19:31", "", "agricultural_products_Tunisia (7)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia-7", "", "", "2017-01-31 12:19:31", "2017-01-31 12:19:31", "", "1388", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia-7.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1421", "1", "2017-01-31 12:19:33", "2017-01-31 12:19:33", "", "agricultural_products_Tunisia (8)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia-8", "", "", "2017-01-31 12:19:33", "2017-01-31 12:19:33", "", "1388", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia-8.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1422", "1", "2017-01-31 12:19:39", "2017-01-31 12:19:39", "", "Harissa_02", "", "inherit", "open", "closed", "", "harissa_02", "", "", "2017-01-31 12:22:27", "2017-01-31 12:22:27", "", "1388", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia-9.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1423", "1", "2017-01-31 12:19:41", "2017-01-31 12:19:41", "", "agricultural_products_Tunisia (10)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia-10", "", "", "2017-01-31 12:19:41", "2017-01-31 12:19:41", "", "1388", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia-10.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1424", "1", "2017-01-31 12:19:43", "2017-01-31 12:19:43", "", "agricultural_products_Tunisia (11)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia-11", "", "", "2017-01-31 12:19:43", "2017-01-31 12:19:43", "", "1388", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia-11.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1425", "1", "2017-01-31 12:19:48", "2017-01-31 12:19:48", "", "agricultural_products_Tunisia (12)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia-12", "", "", "2017-01-31 12:19:48", "2017-01-31 12:19:48", "", "1388", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia-12.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1426", "1", "2017-01-31 12:19:53", "2017-01-31 12:19:53", "", "agricultural_products_Tunisia (13)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia-13", "", "", "2017-01-31 12:19:53", "2017-01-31 12:19:53", "", "1388", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia-13.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1427", "1", "2017-01-31 12:19:55", "2017-01-31 12:19:55", "", "agricultural_products_Tunisia (14)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia-14", "", "", "2017-01-31 12:19:55", "2017-01-31 12:19:55", "", "1388", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia-14.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1432", "1", "2017-01-31 12:41:50", "2017-01-31 12:41:50", "", "Leather-Bags", "", "inherit", "open", "closed", "", "leather-bags", "", "", "2017-01-31 12:41:50", "2017-01-31 12:41:50", "", "1392", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Leather-Bags.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1433", "1", "2017-01-31 12:41:54", "2017-01-31 12:41:54", "", "lismore_diamond_stemware_ca_1", "", "inherit", "open", "closed", "", "lismore_diamond_stemware_ca_1", "", "", "2017-01-31 12:41:54", "2017-01-31 12:41:54", "", "1392", "http://www.abchirgroup.com/wp-content/uploads/2017/01/lismore_diamond_stemware_ca_1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1434", "1", "2017-01-31 12:42:04", "2017-01-31 12:42:04", "", "lismore_diamond_stemware_main_4", "", "inherit", "open", "closed", "", "lismore_diamond_stemware_main_4", "", "", "2017-01-31 12:42:04", "2017-01-31 12:42:04", "", "1392", "http://www.abchirgroup.com/wp-content/uploads/2017/01/lismore_diamond_stemware_main_4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1435", "1", "2017-01-31 12:42:07", "2017-01-31 12:42:07", "", "Porcelain", "", "inherit", "open", "closed", "", "porcelain", "", "", "2017-01-31 12:42:07", "2017-01-31 12:42:07", "", "1392", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Porcelain.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1436", "1", "2017-01-31 12:42:09", "2017-01-31 12:42:09", "", "Silverware_Tray", "", "inherit", "open", "closed", "", "silverware_tray", "", "", "2017-01-31 12:42:09", "2017-01-31 12:42:09", "", "1392", "http://www.abchirgroup.com/wp-content/uploads/2017/01/Silverware_Tray.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1444", "1", "2017-02-11 17:43:15", "2017-02-11 17:43:15", "", "agricultural_products_Tunisia_Sfax (2)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia_sfax-2", "", "", "2017-02-11 17:43:15", "2017-02-11 17:43:15", "", "1390", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia_Sfax-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1445", "1", "2017-02-11 17:43:16", "2017-02-11 17:43:16", "", "agricultural_products_Tunisia_Sfax (3)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia_sfax-3", "", "", "2017-02-11 17:43:16", "2017-02-11 17:43:16", "", "1390", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia_Sfax-3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1446", "1", "2017-02-11 17:43:18", "2017-02-11 17:43:18", "", "agricultural_products_Tunisia_Sfax (4)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia_sfax-4", "", "", "2017-02-11 17:43:18", "2017-02-11 17:43:18", "", "1390", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia_Sfax-4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1447", "1", "2017-02-11 17:43:20", "2017-02-11 17:43:20", "", "Dattes et leur reflet dans un miroir", "Dattes et leur reflet dans un miroir", "inherit", "open", "closed", "", "dattes-et-leur-reflet-dans-un-miroir-2", "", "", "2017-02-11 17:43:20", "2017-02-11 17:43:20", "", "1390", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia_Sfax-5.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1448", "1", "2017-02-11 17:43:21", "2017-02-11 17:43:21", "", "agricultural_products_Tunisia_Sfax (6)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia_sfax-6", "", "", "2017-02-11 17:43:21", "2017-02-11 17:43:21", "", "1390", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia_Sfax-6.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1449", "1", "2017-02-11 17:43:23", "2017-02-11 17:43:23", "", "agricultural_products_Tunisia_Sfax (7)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia_sfax-7", "", "", "2017-02-11 17:43:23", "2017-02-11 17:43:23", "", "1390", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia_Sfax-7.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1450", "1", "2017-02-11 17:43:25", "2017-02-11 17:43:25", "", "agricultural_products_Tunisia_Sfax (8)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia_sfax-8", "", "", "2017-02-11 17:43:25", "2017-02-11 17:43:25", "", "1390", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia_Sfax-8.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1451", "1", "2017-02-11 17:43:31", "2017-02-11 17:43:31", "", "Harissa_02", "Just a spoonful of the spicy chili paste known as harissa goes a long way", "inherit", "open", "closed", "", "harissa_02-2", "", "", "2017-02-11 17:43:31", "2017-02-11 17:43:31", "", "1390", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia_Sfax-9.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1452", "1", "2017-02-11 17:43:33", "2017-02-11 17:43:33", "", "agricultural_products_Tunisia_Sfax (10)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia_sfax-10", "", "", "2017-02-11 17:43:33", "2017-02-11 17:43:33", "", "1390", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia_Sfax-10.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1453", "1", "2017-02-11 17:43:36", "2017-02-11 17:43:36", "", "agricultural_products_Tunisia_Sfax (11)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia_sfax-11", "", "", "2017-02-11 17:43:36", "2017-02-11 17:43:36", "", "1390", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia_Sfax-11.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1454", "1", "2017-02-11 17:43:39", "2017-02-11 17:43:39", "", "agricultural_products_Tunisia_Sfax (12)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia_sfax-12", "", "", "2017-02-11 17:43:39", "2017-02-11 17:43:39", "", "1390", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia_Sfax-12.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1455", "1", "2017-02-11 17:43:42", "2017-02-11 17:43:42", "", "agricultural_products_Tunisia_Sfax (13)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia_sfax-13", "", "", "2017-02-11 17:43:42", "2017-02-11 17:43:42", "", "1390", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia_Sfax-13.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `abchrgrp_posts` VALUES("1456", "1", "2017-02-11 17:43:44", "2017-02-11 17:43:44", "", "agricultural_products_Tunisia_Sfax (14)", "", "inherit", "open", "closed", "", "agricultural_products_tunisia_sfax-14", "", "", "2017-02-11 17:43:44", "2017-02-11 17:43:44", "", "1390", "http://www.abchirgroup.com/wp-content/uploads/2017/01/agricultural_products_Tunisia_Sfax-14.jpg", "0", "attachment", "image/jpeg", "0");

/* INSERT TABLE DATA: abchrgrp_term_relationships */
INSERT INTO `abchrgrp_term_relationships` VALUES("1", "1", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("44", "6", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("44", "9", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("44", "11", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("44", "12", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("44", "14", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("44", "5", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("45", "2", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("45", "4", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("45", "5", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("45", "12", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("1298", "16", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("1177", "6", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("1177", "8", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("1177", "9", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("1177", "11", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("1177", "12", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("1177", "13", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("1177", "14", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("1177", "3", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("1177", "5", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("1354", "16", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("1257", "16", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("1261", "16", "0");
INSERT INTO `abchrgrp_term_relationships` VALUES("1265", "16", "0");

/* INSERT TABLE DATA: abchrgrp_term_taxonomy */
INSERT INTO `abchrgrp_term_taxonomy` VALUES("1", "1", "category", "", "0", "1");
INSERT INTO `abchrgrp_term_taxonomy` VALUES("2", "2", "category", "", "0", "1");
INSERT INTO `abchrgrp_term_taxonomy` VALUES("3", "3", "category", "", "0", "1");
INSERT INTO `abchrgrp_term_taxonomy` VALUES("4", "4", "category", "", "0", "1");
INSERT INTO `abchrgrp_term_taxonomy` VALUES("5", "5", "category", "", "0", "3");
INSERT INTO `abchrgrp_term_taxonomy` VALUES("6", "6", "post_tag", "", "0", "2");
INSERT INTO `abchrgrp_term_taxonomy` VALUES("7", "7", "post_tag", "", "0", "0");
INSERT INTO `abchrgrp_term_taxonomy` VALUES("8", "8", "post_tag", "", "0", "1");
INSERT INTO `abchrgrp_term_taxonomy` VALUES("9", "9", "post_tag", "", "0", "2");
INSERT INTO `abchrgrp_term_taxonomy` VALUES("10", "10", "post_tag", "", "0", "0");
INSERT INTO `abchrgrp_term_taxonomy` VALUES("11", "11", "post_tag", "", "0", "2");
INSERT INTO `abchrgrp_term_taxonomy` VALUES("12", "12", "post_tag", "", "0", "3");
INSERT INTO `abchrgrp_term_taxonomy` VALUES("13", "13", "post_tag", "", "0", "1");
INSERT INTO `abchrgrp_term_taxonomy` VALUES("14", "14", "post_tag", "", "0", "2");
INSERT INTO `abchrgrp_term_taxonomy` VALUES("15", "15", "post_tag", "", "0", "0");
INSERT INTO `abchrgrp_term_taxonomy` VALUES("16", "16", "nav_menu", "", "0", "5");

/* INSERT TABLE DATA: abchrgrp_terms */
INSERT INTO `abchrgrp_terms` VALUES("1", "Uncategorized", "uncategorized", "0");
INSERT INTO `abchrgrp_terms` VALUES("2", "Apps", "apps", "0");
INSERT INTO `abchrgrp_terms` VALUES("3", "Markup", "markup", "0");
INSERT INTO `abchrgrp_terms` VALUES("4", "One Page", "one-page", "0");
INSERT INTO `abchrgrp_terms` VALUES("5", "Responsive", "responsive", "0");
INSERT INTO `abchrgrp_terms` VALUES("6", "alignment", "alignment", "0");
INSERT INTO `abchrgrp_terms` VALUES("7", "alignment", "alignment-2", "0");
INSERT INTO `abchrgrp_terms` VALUES("8", "captions", "captions-2", "0");
INSERT INTO `abchrgrp_terms` VALUES("9", "content", "content", "0");
INSERT INTO `abchrgrp_terms` VALUES("10", "content", "content-2", "0");
INSERT INTO `abchrgrp_terms` VALUES("11", "css", "css", "0");
INSERT INTO `abchrgrp_terms` VALUES("12", "export", "export", "0");
INSERT INTO `abchrgrp_terms` VALUES("13", "image", "image", "0");
INSERT INTO `abchrgrp_terms` VALUES("14", "markup", "markup", "0");
INSERT INTO `abchrgrp_terms` VALUES("15", "markup", "markup-2", "0");
INSERT INTO `abchrgrp_terms` VALUES("16", "Primary", "primary", "0");

/* INSERT TABLE DATA: abchrgrp_usermeta */
INSERT INTO `abchrgrp_usermeta` VALUES("1", "1", "nickname", "AbchirGroup");
INSERT INTO `abchrgrp_usermeta` VALUES("2", "1", "first_name", "");
INSERT INTO `abchrgrp_usermeta` VALUES("3", "1", "last_name", "");
INSERT INTO `abchrgrp_usermeta` VALUES("4", "1", "description", "");
INSERT INTO `abchrgrp_usermeta` VALUES("5", "1", "rich_editing", "true");
INSERT INTO `abchrgrp_usermeta` VALUES("6", "1", "comment_shortcuts", "false");
INSERT INTO `abchrgrp_usermeta` VALUES("7", "1", "admin_color", "fresh");
INSERT INTO `abchrgrp_usermeta` VALUES("8", "1", "use_ssl", "0");
INSERT INTO `abchrgrp_usermeta` VALUES("9", "1", "show_admin_bar_front", "true");
INSERT INTO `abchrgrp_usermeta` VALUES("10", "1", "locale", "");
INSERT INTO `abchrgrp_usermeta` VALUES("11", "1", "abchrgrp_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `abchrgrp_usermeta` VALUES("12", "1", "abchrgrp_user_level", "10");
INSERT INTO `abchrgrp_usermeta` VALUES("13", "1", "dismissed_wp_pointers", "");
INSERT INTO `abchrgrp_usermeta` VALUES("14", "1", "show_welcome_panel", "1");
INSERT INTO `abchrgrp_usermeta` VALUES("22", "1", "session_tokens", "a:1:{s:64:\"f552764741e689a67f7b9586a4af95df8f044577e1d4bebcb9615d774c63f7d7\";a:4:{s:10:\"expiration\";i:1612095416;s:2:\"ip\";s:13:\"41.228.56.105\";s:2:\"ua\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4324.104 Safari/537.36\";s:5:\"login\";i:1611922616;}}");
INSERT INTO `abchrgrp_usermeta` VALUES("16", "1", "abchrgrp_dashboard_quick_press_last_post_id", "1464");
INSERT INTO `abchrgrp_usermeta` VALUES("17", "1", "nav_menu_recently_edited", "16");
INSERT INTO `abchrgrp_usermeta` VALUES("18", "1", "managenav-menuscolumnshidden", "a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}");
INSERT INTO `abchrgrp_usermeta` VALUES("19", "1", "metaboxhidden_nav-menus", "a:1:{i:0;s:12:\"add-post_tag\";}");
INSERT INTO `abchrgrp_usermeta` VALUES("20", "1", "abchrgrp_user-settings", "libraryContent=browse&editor=html&align=center&urlbutton=file&imgsize=medium");
INSERT INTO `abchrgrp_usermeta` VALUES("21", "1", "abchrgrp_user-settings-time", "1494088053");
INSERT INTO `abchrgrp_usermeta` VALUES("23", "1", "community-events-location", "a:1:{s:2:\"ip\";s:13:\"102.159.229.0\";}");
INSERT INTO `abchrgrp_usermeta` VALUES("24", "1", "meta-box-order_dashboard", "a:4:{s:6:\"normal\";s:78:\"dashboard_php_nag,dashboard_site_health,dashboard_right_now,dashboard_activity\";s:4:\"side\";s:39:\"dashboard_quick_press,dashboard_primary\";s:7:\"column3\";s:0:\"\";s:7:\"column4\";s:0:\"\";}");

/* INSERT TABLE DATA: abchrgrp_users */
INSERT INTO `abchrgrp_users` VALUES("1", "AbchirGroup", "$P$BsRH7J0cMeGS3VAOZfm4tz/Uzc0TTj1", "abchirgroup", "omar.jallouli@gmail.com", "", "2017-01-22 12:42:21", "", "0", "AbchirGroup");

/* INSERT TABLE DATA: apprenz_comments */
INSERT INTO `apprenz_comments` VALUES("1", "554", "TRX_admin", "wpspace.johndoe@gmail.com", "", "127.0.0.1", "2014-08-29 12:15:49", "2014-08-29 12:15:49", "There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don\'t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn\'t anything embarrassing hidden in the middle of text.", "0", "1", "", "", "0", "0");
INSERT INTO `apprenz_comments` VALUES("2", "816", "Miki Williams", "trex.mikiwilliams@themerex.net", "", "127.0.0.1", "2014-08-26 08:40:17", "2014-08-26 08:40:17", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.", "0", "1", "", "", "0", "0");
INSERT INTO `apprenz_comments` VALUES("3", "820", "TRX_admin", "wpspace.johndoe@gmail.com", "", "127.0.0.1", "2014-08-26 08:58:06", "2014-08-26 08:58:06", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.", "0", "1", "", "", "0", "0");
INSERT INTO `apprenz_comments` VALUES("4", "822", "TRX_admin", "wpspace.johndoe@gmail.com", "", "127.0.0.1", "2014-08-26 08:38:47", "2014-08-26 08:38:47", "Aenean a turpis quis turpis accumsan suscipit at vitae tellus. Nulla at urna congue, congue odio at, iaculis dolor. Etiam porta eleifend pulvinar. Vestibulum enim ipsum, laoreet eget mauris a, facilisis lobortis purus. Etiam ac justo facilisis, ullamcorper metus sed, aliquet dui.", "0", "1", "", "", "0", "0");
INSERT INTO `apprenz_comments` VALUES("5", "824", "Miki Williams", "trex.mikiwilliams@themerex.net", "", "127.0.0.1", "2014-08-26 08:41:53", "2014-08-26 08:41:53", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.", "0", "1", "", "", "0", "0");

/* INSERT TABLE DATA: apprenz_options */
INSERT INTO `apprenz_options` VALUES("1", "siteurl", "http://apprenz.com", "yes");
INSERT INTO `apprenz_options` VALUES("2", "blogname", "APPRENZ", "yes");
INSERT INTO `apprenz_options` VALUES("3", "blogdescription", "Votre partenaire pour le monde du web.", "yes");
INSERT INTO `apprenz_options` VALUES("4", "users_can_register", "0", "yes");
INSERT INTO `apprenz_options` VALUES("5", "admin_email", "contact@apprenz.com", "yes");
INSERT INTO `apprenz_options` VALUES("6", "start_of_week", "1", "yes");
INSERT INTO `apprenz_options` VALUES("7", "use_balanceTags", "0", "yes");
INSERT INTO `apprenz_options` VALUES("8", "use_smilies", "1", "yes");
INSERT INTO `apprenz_options` VALUES("9", "require_name_email", "1", "yes");
INSERT INTO `apprenz_options` VALUES("10", "comments_notify", "1", "yes");
INSERT INTO `apprenz_options` VALUES("11", "posts_per_rss", "10", "yes");
INSERT INTO `apprenz_options` VALUES("12", "rss_use_excerpt", "0", "yes");
INSERT INTO `apprenz_options` VALUES("13", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `apprenz_options` VALUES("14", "mailserver_login", "login@example.com", "yes");
INSERT INTO `apprenz_options` VALUES("15", "mailserver_pass", "password", "yes");
INSERT INTO `apprenz_options` VALUES("16", "mailserver_port", "110", "yes");
INSERT INTO `apprenz_options` VALUES("17", "default_category", "1", "yes");
INSERT INTO `apprenz_options` VALUES("18", "default_comment_status", "open", "yes");
INSERT INTO `apprenz_options` VALUES("19", "default_ping_status", "open", "yes");
INSERT INTO `apprenz_options` VALUES("20", "default_pingback_flag", "", "yes");
INSERT INTO `apprenz_options` VALUES("21", "posts_per_page", "10", "yes");
INSERT INTO `apprenz_options` VALUES("22", "date_format", "F j, Y", "yes");
INSERT INTO `apprenz_options` VALUES("23", "time_format", "g:i a", "yes");
INSERT INTO `apprenz_options` VALUES("24", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `apprenz_options` VALUES("28", "comment_moderation", "", "yes");
INSERT INTO `apprenz_options` VALUES("29", "moderation_notify", "1", "yes");
INSERT INTO `apprenz_options` VALUES("30", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `apprenz_options` VALUES("31", "gzipcompression", "0", "yes");
INSERT INTO `apprenz_options` VALUES("32", "hack_file", "0", "yes");
INSERT INTO `apprenz_options` VALUES("33", "blog_charset", "UTF-8", "yes");
INSERT INTO `apprenz_options` VALUES("34", "moderation_keys", "", "no");
INSERT INTO `apprenz_options` VALUES("35", "active_plugins", "a:12:{i:0;s:19:\"akismet/akismet.php\";i:1;s:16:\"gotmls/index.php\";i:2;s:27:\"js_composer/js_composer.php\";i:3;s:23:\"revslider/revslider.php\";i:4;s:38:\"simple-backup/simple-backup-loader.php\";i:5;s:43:\"the-events-calendar/the-events-calendar.php\";i:6;s:43:\"widget-manager-light/otw_widget_manager.php\";i:7;s:27:\"woocommerce/woocommerce.php\";i:8;s:24:\"wordpress-seo/wp-seo.php\";i:9;s:43:\"wp-instagram-widget/wp-instagram-widget.php\";i:10;s:27:\"wp-optimize/wp-optimize.php\";i:11;s:30:\"yith-maintenance-mode/init.php\";}", "yes");
INSERT INTO `apprenz_options` VALUES("36", "home", "http://apprenz.com", "yes");
INSERT INTO `apprenz_options` VALUES("37", "category_base", "", "yes");
INSERT INTO `apprenz_options` VALUES("38", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `apprenz_options` VALUES("39", "advanced_edit", "0", "yes");
INSERT INTO `apprenz_options` VALUES("40", "comment_max_links", "2", "yes");
INSERT INTO `apprenz_options` VALUES("41", "gmt_offset", "0", "yes");
INSERT INTO `apprenz_options` VALUES("42", "default_email_category", "1", "yes");
INSERT INTO `apprenz_options` VALUES("43", "recently_edited", "a:5:{i:0;s:77:\"/homez.507/maento/www/apprenz/wp-content/themes/carbon-wp-light/functions.php\";i:1;s:72:\"/homez.507/maento/www/apprenz/wp-content/themes/carbon-wp-light/page.php\";i:2;s:73:\"/homez.507/maento/www/apprenz/wp-content/themes/carbon-wp-light/style.css\";i:3;s:74:\"/homez.507/maento/www/apprenz/wp-content/themes/carbon-wp-light/header.php\";i:4;s:84:\"/homez.507/maento/www/apprenz/wp-content/themes/carbon-wp-light/template-contact.php\";}", "no");
INSERT INTO `apprenz_options` VALUES("44", "template", "seo", "yes");
INSERT INTO `apprenz_options` VALUES("45", "stylesheet", "seo", "yes");
INSERT INTO `apprenz_options` VALUES("46", "comment_whitelist", "1", "yes");
INSERT INTO `apprenz_options` VALUES("47", "blacklist_keys", "", "no");
INSERT INTO `apprenz_options` VALUES("48", "comment_registration", "", "yes");
INSERT INTO `apprenz_options` VALUES("49", "html_type", "text/html", "yes");
INSERT INTO `apprenz_options` VALUES("50", "use_trackback", "0", "yes");
INSERT INTO `apprenz_options` VALUES("51", "default_role", "subscriber", "yes");
INSERT INTO `apprenz_options` VALUES("52", "db_version", "33056", "yes");
INSERT INTO `apprenz_options` VALUES("53", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `apprenz_options` VALUES("54", "upload_path", "", "yes");
INSERT INTO `apprenz_options` VALUES("55", "blog_public", "1", "yes");
INSERT INTO `apprenz_options` VALUES("56", "default_link_category", "2", "yes");
INSERT INTO `apprenz_options` VALUES("57", "show_on_front", "page", "yes");
INSERT INTO `apprenz_options` VALUES("58", "tag_base", "", "yes");
INSERT INTO `apprenz_options` VALUES("59", "show_avatars", "1", "yes");
INSERT INTO `apprenz_options` VALUES("60", "avatar_rating", "G", "yes");
INSERT INTO `apprenz_options` VALUES("61", "upload_url_path", "", "yes");
INSERT INTO `apprenz_options` VALUES("62", "thumbnail_size_w", "150", "yes");
INSERT INTO `apprenz_options` VALUES("63", "thumbnail_size_h", "150", "yes");
INSERT INTO `apprenz_options` VALUES("64", "thumbnail_crop", "1", "yes");
INSERT INTO `apprenz_options` VALUES("65", "medium_size_w", "300", "yes");
INSERT INTO `apprenz_options` VALUES("66", "medium_size_h", "300", "yes");
INSERT INTO `apprenz_options` VALUES("67", "avatar_default", "mystery", "yes");
INSERT INTO `apprenz_options` VALUES("68", "large_size_w", "1024", "yes");
INSERT INTO `apprenz_options` VALUES("69", "large_size_h", "1024", "yes");
INSERT INTO `apprenz_options` VALUES("70", "image_default_link_type", "file", "yes");
INSERT INTO `apprenz_options` VALUES("71", "image_default_size", "", "yes");
INSERT INTO `apprenz_options` VALUES("72", "image_default_align", "", "yes");
INSERT INTO `apprenz_options` VALUES("73", "close_comments_for_old_posts", "1", "yes");
INSERT INTO `apprenz_options` VALUES("74", "close_comments_days_old", "1", "yes");
INSERT INTO `apprenz_options` VALUES("75", "thread_comments", "1", "yes");
INSERT INTO `apprenz_options` VALUES("76", "thread_comments_depth", "5", "yes");
INSERT INTO `apprenz_options` VALUES("77", "page_comments", "", "yes");
INSERT INTO `apprenz_options` VALUES("78", "comments_per_page", "50", "yes");
INSERT INTO `apprenz_options` VALUES("79", "default_comments_page", "newest", "yes");
INSERT INTO `apprenz_options` VALUES("80", "comment_order", "asc", "yes");
INSERT INTO `apprenz_options` VALUES("81", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `apprenz_options` VALUES("82", "widget_categories", "a:2:{i:5;a:4:{s:5:\"title\";s:10:\"Categories\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `apprenz_options` VALUES("83", "widget_text", "a:6:{i:2;a:3:{s:5:\"title\";s:10:\"Shortcodes\";s:4:\"text\";s:82:\"[trx_blogger style=\"list\" cat=\"shortcodes\" orderby=\"title\" order=\"asc\" count=\"-1\"]\";s:6:\"filter\";b:0;}i:6;a:3:{s:5:\"title\";s:11:\"Custom text\";s:4:\"text\";s:336:\"There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don\'t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn\'t anything embarrassing hidden in the middle of text.\";s:6:\"filter\";b:1;}i:7;a:3:{s:5:\"title\";s:13:\"Documentation\";s:4:\"text\";s:84:\"[trx_blogger style=\"list\" cat=\"documentation\" orderby=\"date\" order=\"asc\" count=\"-1\"]\";s:6:\"filter\";b:0;}i:8;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:245:\"[trx_section id=\"timeline_slider\" right=\"6\"]\r\n[trx_title type=\"2\" bottom=\"10\"]Timeline[/trx_title]\r\n[trx_blogger style=\"date\" cat=\"timeline-example\" count=\"-1\" dir=\"vertical\" scroll=\"yes\" controls=\"on\" loadmore=\"no\" height=\"750\"]\r\n[/trx_section]\";s:6:\"filter\";b:0;}i:9;a:3:{s:5:\"title\";s:7:\"Apprenz\";s:4:\"text\";s:120:\"Apprenz est un cabinet de consulting en Ingénierie des systèmes d\'informations\r\n\r\n[trx_social class=\"\"][/trx_social]\r\n\";s:6:\"filter\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `apprenz_options` VALUES("7738", "_transient_geoip_54.195.254.29", "IE", "no");
INSERT INTO `apprenz_options` VALUES("7739", "_transient_timeout_geoip_109.109.100.100", "1448306264", "no");
INSERT INTO `apprenz_options` VALUES("7740", "_transient_geoip_109.109.100.100", "NL", "no");
INSERT INTO `apprenz_options` VALUES("7741", "_transient_timeout_geoip_198.154.241.142", "1448306272", "no");
INSERT INTO `apprenz_options` VALUES("84", "widget_rss", "a:2:{i:4;a:8:{s:5:\"title\";s:3:\"RSS\";s:3:\"url\";s:36:\"http://feeds.reuters.com/news/wealth\";s:4:\"link\";s:23:\"http://www.reuters.com/\";s:5:\"items\";i:2;s:5:\"error\";b:0;s:12:\"show_summary\";i:1;s:11:\"show_author\";i:1;s:9:\"show_date\";i:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `apprenz_options` VALUES("85", "uninstall_plugins", "a:1:{s:38:\"simple-backup/simple-backup-loader.php\";s:23:\"simple_backup_uninstall\";}", "no");
INSERT INTO `apprenz_options` VALUES("86", "timezone_string", "", "yes");
INSERT INTO `apprenz_options` VALUES("87", "page_for_posts", "627", "yes");
INSERT INTO `apprenz_options` VALUES("88", "page_on_front", "2192", "yes");
INSERT INTO `apprenz_options` VALUES("89", "default_post_format", "0", "yes");
INSERT INTO `apprenz_options` VALUES("90", "link_manager_enabled", "0", "yes");
INSERT INTO `apprenz_options` VALUES("91", "initial_db_version", "24448", "yes");
INSERT INTO `apprenz_options` VALUES("92", "apprenz_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:172:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:9:\"add_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:16:\"edit_tribe_event\";b:1;s:16:\"read_tribe_event\";b:1;s:18:\"delete_tribe_event\";b:1;s:19:\"delete_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:25:\"read_private_tribe_events\";b:1;s:16:\"edit_tribe_venue\";b:1;s:16:\"read_tribe_venue\";b:1;s:18:\"delete_tribe_venue\";b:1;s:19:\"delete_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:20:\"edit_tribe_organizer\";b:1;s:20:\"read_tribe_organizer\";b:1;s:22:\"delete_tribe_organizer\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:74:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:16:\"edit_tribe_event\";b:1;s:16:\"read_tribe_event\";b:1;s:18:\"delete_tribe_event\";b:1;s:19:\"delete_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:25:\"read_private_tribe_events\";b:1;s:16:\"edit_tribe_venue\";b:1;s:16:\"read_tribe_venue\";b:1;s:18:\"delete_tribe_venue\";b:1;s:19:\"delete_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:20:\"edit_tribe_organizer\";b:1;s:20:\"read_tribe_organizer\";b:1;s:22:\"delete_tribe_organizer\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:29:\"read_private_tribe_organizers\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:34:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:16:\"edit_tribe_event\";b:1;s:16:\"read_tribe_event\";b:1;s:18:\"delete_tribe_event\";b:1;s:19:\"delete_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:16:\"edit_tribe_venue\";b:1;s:16:\"read_tribe_venue\";b:1;s:18:\"delete_tribe_venue\";b:1;s:19:\"delete_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"edit_tribe_organizer\";b:1;s:20:\"read_tribe_organizer\";b:1;s:22:\"delete_tribe_organizer\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:20:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:16:\"edit_tribe_event\";b:1;s:16:\"read_tribe_event\";b:1;s:18:\"delete_tribe_event\";b:1;s:19:\"delete_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:16:\"edit_tribe_venue\";b:1;s:16:\"read_tribe_venue\";b:1;s:18:\"delete_tribe_venue\";b:1;s:19:\"delete_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:20:\"edit_tribe_organizer\";b:1;s:20:\"read_tribe_organizer\";b:1;s:22:\"delete_tribe_organizer\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:5:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:16:\"read_tribe_event\";b:1;s:20:\"read_tribe_organizer\";b:1;s:16:\"read_tribe_venue\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:3:{s:4:\"read\";b:1;s:10:\"edit_posts\";b:0;s:12:\"delete_posts\";b:0;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop Manager\";s:12:\"capabilities\";a:110:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:15:\"unfiltered_html\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;}}}", "yes");
INSERT INTO `apprenz_options` VALUES("93", "widget_search", "a:2:{i:3;a:1:{s:5:\"title\";s:6:\"Search\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `apprenz_options` VALUES("94", "widget_recent-posts", "a:2:{i:3;a:3:{s:5:\"title\";s:12:\"Recent posts\";s:6:\"number\";i:5;s:9:\"show_date\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `apprenz_options` VALUES("95", "widget_recent-comments", "a:4:{i:3;a:2:{s:5:\"title\";s:15:\"Recent Comments\";s:6:\"number\";i:5;}i:4;a:2:{s:5:\"title\";s:15:\"Recent comments\";s:6:\"number\";i:5;}i:8;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `apprenz_options` VALUES("96", "widget_archives", "a:6:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}i:3;a:3:{s:5:\"title\";s:7:\"Archive\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}i:4;a:3:{s:5:\"title\";s:8:\"Archives\";s:5:\"count\";i:1;s:8:\"dropdown\";i:0;}i:6;a:3:{s:5:\"title\";s:8:\"Archives\";s:5:\"count\";i:1;s:8:\"dropdown\";i:0;}i:8;a:3:{s:5:\"title\";s:8:\"Archives\";s:5:\"count\";i:1;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `apprenz_options` VALUES("97", "widget_meta", "a:3:{i:3;a:1:{s:5:\"title\";s:4:\"Meta\";}i:4;a:1:{s:5:\"title\";s:4:\"Meta\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `apprenz_options` VALUES("98", "sidebars_widgets", "a:18:{s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"sidebar-main\";a:5:{i:0;s:31:\"themerex-subcategories-widget-2\";i:1;s:10:\"calendar-2\";i:2;s:10:\"archives-2\";i:3;s:31:\"themerex-popular-posts-widget-4\";i:4;s:30:\"themerex-recent-posts-widget-4\";}s:11:\"sidebar-top\";a:5:{i:0;s:10:\"calendar-3\";i:1;s:10:\"archives-4\";i:2;s:24:\"themerex-flickr-widget-2\";i:3;s:30:\"themerex-recent-posts-widget-5\";i:4;s:6:\"meta-3\";}s:14:\"sidebar-footer\";a:4:{i:0;s:10:\"calendar-4\";i:1;s:10:\"archives-3\";i:2;s:30:\"themerex-recent-posts-widget-2\";i:3;s:31:\"themerex-popular-posts-widget-2\";}s:13:\"sidebar-panel\";a:3:{i:0;s:10:\"archives-6\";i:1;s:7:\"pages-2\";i:2;s:17:\"recent-comments-3\";}s:12:\"sidebar-cart\";a:0:{}s:16:\"custom-sidebar-0\";a:1:{i:0;s:6:\"text-2\";}s:16:\"custom-sidebar-1\";a:11:{i:0;s:10:\"archives-8\";i:1;s:10:\"calendar-5\";i:2;s:10:\"nav_menu-2\";i:3;s:6:\"meta-4\";i:4;s:7:\"pages-3\";i:5;s:17:\"recent-comments-4\";i:6;s:14:\"recent-posts-3\";i:7;s:5:\"rss-4\";i:8;s:8:\"search-3\";i:9;s:11:\"tag_cloud-2\";i:10;s:6:\"text-6\";}s:16:\"custom-sidebar-2\";a:8:{i:0;s:24:\"themerex-advert-widget-2\";i:1;s:24:\"themerex-social-widget-2\";i:2;s:24:\"themerex-flickr-widget-4\";i:3;s:17:\"twitter2-widget-2\";i:4;s:31:\"themerex-popular-posts-widget-5\";i:5;s:30:\"themerex-recent-posts-widget-7\";i:6;s:32:\"themerex-recent-reviews-widget-2\";i:7;s:23:\"themerex-top10-widget-2\";}s:16:\"custom-sidebar-3\";a:1:{i:0;s:6:\"text-8\";}s:16:\"custom-sidebar-4\";a:1:{i:0;s:6:\"text-9\";}s:16:\"custom-sidebar-5\";a:0:{}s:16:\"custom-sidebar-6\";a:2:{i:0;s:24:\"themerex-advert-widget-5\";i:1;s:17:\"twitter2-widget-3\";}s:16:\"custom-sidebar-8\";a:3:{i:0;s:12:\"categories-5\";i:1;s:31:\"themerex-popular-posts-widget-6\";i:2;s:30:\"themerex-recent-posts-widget-6\";}s:16:\"custom-sidebar-9\";a:1:{i:0;s:6:\"text-7\";}s:17:\"custom-sidebar-10\";a:4:{i:0;s:24:\"themerex-advert-widget-4\";i:1;s:11:\"calendar-10\";i:2;s:17:\"recent-comments-8\";i:3;s:30:\"themerex-recent-posts-widget-8\";}s:17:\"custom-sidebar-11\";a:3:{i:0;s:26:\"tribe-events-list-widget-2\";i:1;s:30:\"themerex-recent-posts-widget-9\";i:2;s:19:\"rev-slider-widget-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `apprenz_options` VALUES("99", "cron", "a:8:{i:1567706785;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1567706791;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1567707425;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1567709750;a:2:{s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1567728000;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1567747168;a:1:{s:24:\"akismet_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1570147200;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2635200;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `apprenz_options` VALUES("5640", "can_compress_scripts", "0", "yes");
INSERT INTO `apprenz_options` VALUES("43980", "_transient_timeout_plugin_slugs", "1548334961", "no");
INSERT INTO `apprenz_options` VALUES("43981", "_transient_plugin_slugs", "a:16:{i:0;s:19:\"akismet/akismet.php\";i:1;s:16:\"gotmls/index.php\";i:2;s:9:\"hello.php\";i:3;s:43:\"otw-portfolio-light/otw-portfolio-light.php\";i:4;s:23:\"revslider/revslider.php\";i:5;s:38:\"simple-backup/simple-backup-loader.php\";i:6;s:43:\"the-events-calendar/the-events-calendar.php\";i:7;s:43:\"widget-manager-light/otw_widget_manager.php\";i:8;s:27:\"woocommerce/woocommerce.php\";i:9;s:23:\"wooslider/wooslider.php\";i:10;s:39:\"woothemes-updater/woothemes-updater.php\";i:11;s:27:\"wp-optimize/wp-optimize.php\";i:12;s:27:\"js_composer/js_composer.php\";i:13;s:43:\"wp-instagram-widget/wp-instagram-widget.php\";i:14;s:30:\"yith-maintenance-mode/init.php\";i:15;s:24:\"wordpress-seo/wp-seo.php\";}", "no");
INSERT INTO `apprenz_options` VALUES("151", "recently_activated", "a:0:{}", "yes");
INSERT INTO `apprenz_options` VALUES("154", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `apprenz_options` VALUES("48690", "_site_transient_timeout_theme_roots", "1567665390", "yes");
INSERT INTO `apprenz_options` VALUES("48691", "_site_transient_theme_roots", "a:3:{s:3:\"ark\";s:7:\"/themes\";s:3:\"seo\";s:7:\"/themes\";s:12:\"twentytwelve\";s:7:\"/themes\";}", "yes");
INSERT INTO `apprenz_options` VALUES("6836", "_transient_geoip_50.116.75.199", "US", "no");
INSERT INTO `apprenz_options` VALUES("6837", "_transient_timeout_geoip_2607:5300:60:6535::", "1448181821", "no");
INSERT INTO `apprenz_options` VALUES("6838", "_transient_geoip_2607:5300:60:6535::", "CA", "no");
INSERT INTO `apprenz_options` VALUES("6839", "_transient_timeout_geoip_52.0.121.49", "1448181867", "no");
INSERT INTO `apprenz_options` VALUES("6840", "_transient_geoip_52.0.121.49", "US", "no");
INSERT INTO `apprenz_options` VALUES("6841", "_transient_timeout_geoip_2601:6c1:4000:c500:219:b9ff:fece:1cba", "1448181867", "no");
INSERT INTO `apprenz_options` VALUES("6842", "_transient_geoip_2601:6c1:4000:c500:219:b9ff:fece:1cba", "US", "no");
INSERT INTO `apprenz_options` VALUES("6843", "_transient_timeout_geoip_134.249.52.218", "1448181898", "no");
INSERT INTO `apprenz_options` VALUES("6844", "_transient_geoip_134.249.52.218", "UA", "no");
INSERT INTO `apprenz_options` VALUES("6845", "_transient_timeout_geoip_52.88.210.132", "1448181904", "no");
INSERT INTO `apprenz_options` VALUES("6846", "_transient_geoip_52.88.210.132", "US", "no");
INSERT INTO `apprenz_options` VALUES("6847", "_transient_timeout_geoip_67.227.191.128", "1448181941", "no");
INSERT INTO `apprenz_options` VALUES("6848", "_transient_geoip_67.227.191.128", "US", "no");
INSERT INTO `apprenz_options` VALUES("6849", "_transient_timeout_geoip_208.115.124.12", "1448183081", "no");
INSERT INTO `apprenz_options` VALUES("6850", "_transient_geoip_208.115.124.12", "US", "no");
INSERT INTO `apprenz_options` VALUES("6851", "_transient_timeout_geoip_104.245.109.151", "1448183721", "no");
INSERT INTO `apprenz_options` VALUES("6852", "_transient_geoip_104.245.109.151", "US", "no");
INSERT INTO `apprenz_options` VALUES("6853", "_transient_timeout_geoip_192.163.227.194", "1448184068", "no");
INSERT INTO `apprenz_options` VALUES("6854", "_transient_geoip_192.163.227.194", "US", "no");
INSERT INTO `apprenz_options` VALUES("6856", "_transient_timeout_geoip_180.76.15.8", "1448185065", "no");
INSERT INTO `apprenz_options` VALUES("6857", "_transient_geoip_180.76.15.8", "CN", "no");
INSERT INTO `apprenz_options` VALUES("9161", "_transient_timeout_geoip_213.189.2.157", "1449371552", "no");
INSERT INTO `apprenz_options` VALUES("9162", "_transient_geoip_213.189.2.157", "NL", "no");
INSERT INTO `apprenz_options` VALUES("6860", "_transient_timeout_geoip_180.76.15.7", "1448185963", "no");
INSERT INTO `apprenz_options` VALUES("6861", "_transient_geoip_180.76.15.7", "CN", "no");
INSERT INTO `apprenz_options` VALUES("6862", "_transient_timeout_geoip_190.8.110.142", "1448188026", "no");
INSERT INTO `apprenz_options` VALUES("6863", "_transient_geoip_190.8.110.142", "CL", "no");
INSERT INTO `apprenz_options` VALUES("6864", "_transient_timeout_geoip_54.186.156.36", "1448188032", "no");
INSERT INTO `apprenz_options` VALUES("6865", "_transient_geoip_54.186.156.36", "US", "no");
INSERT INTO `apprenz_options` VALUES("6866", "_transient_timeout_geoip_213.21.217.214", "1448188143", "no");
INSERT INTO `apprenz_options` VALUES("6867", "_transient_geoip_213.21.217.214", "LV", "no");
INSERT INTO `apprenz_options` VALUES("6868", "_transient_timeout_geoip_84.38.65.65", "1448188368", "no");
INSERT INTO `apprenz_options` VALUES("6869", "_transient_geoip_84.38.65.65", "DE", "no");
INSERT INTO `apprenz_options` VALUES("6870", "_transient_timeout_geoip_83.223.111.230", "1448188594", "no");
INSERT INTO `apprenz_options` VALUES("6871", "_transient_geoip_83.223.111.230", "GB", "no");
INSERT INTO `apprenz_options` VALUES("6873", "_transient_timeout_geoip_178.159.253.100", "1448188653", "no");
INSERT INTO `apprenz_options` VALUES("6874", "_transient_geoip_178.159.253.100", "RU", "no");
INSERT INTO `apprenz_options` VALUES("6875", "_transient_timeout_geoip_104.238.83.233", "1448188835", "no");
INSERT INTO `apprenz_options` VALUES("6876", "_transient_geoip_104.238.83.233", "US", "no");
INSERT INTO `apprenz_options` VALUES("6877", "_transient_timeout_geoip_162.144.49.118", "1448189029", "no");
INSERT INTO `apprenz_options` VALUES("6878", "_transient_geoip_162.144.49.118", "US", "no");
INSERT INTO `apprenz_options` VALUES("6879", "_transient_timeout_geoip_74.50.0.190", "1448189227", "no");
INSERT INTO `apprenz_options` VALUES("6880", "_transient_geoip_74.50.0.190", "US", "no");
INSERT INTO `apprenz_options` VALUES("6881", "_transient_timeout_geoip_52.89.107.174", "1448189507", "no");
INSERT INTO `apprenz_options` VALUES("6882", "_transient_geoip_52.89.107.174", "US", "no");
INSERT INTO `apprenz_options` VALUES("6883", "_transient_timeout_geoip_37.59.247.21", "1448190177", "no");
INSERT INTO `apprenz_options` VALUES("6884", "_transient_geoip_37.59.247.21", "FR", "no");
INSERT INTO `apprenz_options` VALUES("6885", "_transient_timeout_geoip_79.99.0.190", "1448190402", "no");
INSERT INTO `apprenz_options` VALUES("6886", "_transient_geoip_79.99.0.190", "SE", "no");
INSERT INTO `apprenz_options` VALUES("6887", "_transient_timeout_geoip_2a01:4f8:d16:1a04::2", "1448190585", "no");
INSERT INTO `apprenz_options` VALUES("6888", "_transient_geoip_2a01:4f8:d16:1a04::2", "DE", "no");
INSERT INTO `apprenz_options` VALUES("6889", "_transient_timeout_geoip_67.227.244.194", "1448190706", "no");
INSERT INTO `apprenz_options` VALUES("6890", "_transient_geoip_67.227.244.194", "US", "no");
INSERT INTO `apprenz_options` VALUES("6891", "_transient_timeout_geoip_2a01:430:17:1::ffff:837", "1448190886", "no");
INSERT INTO `apprenz_options` VALUES("6892", "_transient_geoip_2a01:430:17:1::ffff:837", "CZ", "no");
INSERT INTO `apprenz_options` VALUES("6893", "_transient_timeout_geoip_2400:f100:2:0:20c:29ff:fe69:93da", "1448192451", "no");
INSERT INTO `apprenz_options` VALUES("6894", "_transient_geoip_2400:f100:2:0:20c:29ff:fe69:93da", "HK", "no");
INSERT INTO `apprenz_options` VALUES("8800", "_transient_timeout_geoip_92.43.22.140", "1449074893", "no");
INSERT INTO `apprenz_options` VALUES("8801", "_transient_geoip_92.43.22.140", "ES", "no");
INSERT INTO `apprenz_options` VALUES("6898", "_transient_timeout_geoip_185.51.65.226", "1448194671", "no");
INSERT INTO `apprenz_options` VALUES("6899", "_transient_geoip_185.51.65.226", "HU", "no");
INSERT INTO `apprenz_options` VALUES("6900", "_transient_timeout_geoip_2606:2e00:8000:0:216:3eff:fe03:a7f3", "1448194781", "no");
INSERT INTO `apprenz_options` VALUES("6901", "_transient_geoip_2606:2e00:8000:0:216:3eff:fe03:a7f3", "US", "no");
INSERT INTO `apprenz_options` VALUES("6902", "_transient_timeout_geoip_103.28.12.26", "1448194960", "no");
INSERT INTO `apprenz_options` VALUES("6903", "_transient_geoip_103.28.12.26", "ID", "no");
INSERT INTO `apprenz_options` VALUES("6904", "_transient_timeout_geoip_2604:7800:0:1:3cb2:ebff:fe9b:ba3e", "1448194964", "no");
INSERT INTO `apprenz_options` VALUES("6905", "_transient_geoip_2604:7800:0:1:3cb2:ebff:fe9b:ba3e", "US", "no");
INSERT INTO `apprenz_options` VALUES("6906", "_transient_timeout_geoip_2a01:7860::5054:ff:fef5:f692", "1448194972", "no");
INSERT INTO `apprenz_options` VALUES("6907", "_transient_geoip_2a01:7860::5054:ff:fef5:f692", "NL", "no");
INSERT INTO `apprenz_options` VALUES("6908", "_transient_timeout_geoip_5.101.157.36", "1448195405", "no");
INSERT INTO `apprenz_options` VALUES("6909", "_transient_geoip_5.101.157.36", "RU", "no");
INSERT INTO `apprenz_options` VALUES("6910", "_transient_timeout_geoip_128.199.254.82", "1448196213", "no");
INSERT INTO `apprenz_options` VALUES("6911", "_transient_geoip_128.199.254.82", "SG", "no");
INSERT INTO `apprenz_options` VALUES("6913", "_transient_timeout_geoip_41.71.77.105", "1448196310", "no");
INSERT INTO `apprenz_options` VALUES("6914", "_transient_geoip_41.71.77.105", "ZA", "no");
INSERT INTO `apprenz_options` VALUES("6915", "_transient_timeout_geoip_216.97.235.25", "1448196354", "no");
INSERT INTO `apprenz_options` VALUES("6916", "_transient_geoip_216.97.235.25", "US", "no");
INSERT INTO `apprenz_options` VALUES("6917", "_transient_timeout_geoip_66.117.10.154", "1448196401", "no");
INSERT INTO `apprenz_options` VALUES("6918", "_transient_geoip_66.117.10.154", "US", "no");
INSERT INTO `apprenz_options` VALUES("6919", "_transient_timeout_geoip_64.237.54.211", "1448196615", "no");
INSERT INTO `apprenz_options` VALUES("6920", "_transient_geoip_64.237.54.211", "US", "no");
INSERT INTO `apprenz_options` VALUES("6921", "_transient_timeout_geoip_192.187.110.66", "1448197519", "no");
INSERT INTO `apprenz_options` VALUES("6922", "_transient_geoip_192.187.110.66", "US", "no");
INSERT INTO `apprenz_options` VALUES("6923", "_transient_timeout_geoip_203.211.128.171", "1448197732", "no");
INSERT INTO `apprenz_options` VALUES("6924", "_transient_geoip_203.211.128.171", "SG", "no");
INSERT INTO `apprenz_options` VALUES("6925", "_transient_timeout_geoip_2001:8d8:923:2900::66:9487", "1448198387", "no");
INSERT INTO `apprenz_options` VALUES("6926", "_transient_geoip_2001:8d8:923:2900::66:9487", "DE", "no");
INSERT INTO `apprenz_options` VALUES("6927", "_transient_timeout_geoip_69.28.199.80", "1448199016", "no");
INSERT INTO `apprenz_options` VALUES("6928", "_transient_geoip_69.28.199.80", "CA", "no");
INSERT INTO `apprenz_options` VALUES("6929", "_transient_timeout_geoip_68.69.1.19", "1448200623", "no");
INSERT INTO `apprenz_options` VALUES("6930", "_transient_geoip_68.69.1.19", "US", "no");
INSERT INTO `apprenz_options` VALUES("6932", "_transient_timeout_geoip_217.147.176.240", "1448200731", "no");
INSERT INTO `apprenz_options` VALUES("6933", "_transient_geoip_217.147.176.240", "GB", "no");
INSERT INTO `apprenz_options` VALUES("6934", "_transient_timeout_geoip_72.46.139.186", "1448201099", "no");
INSERT INTO `apprenz_options` VALUES("6935", "_transient_geoip_72.46.139.186", "US", "no");
INSERT INTO `apprenz_options` VALUES("6936", "_transient_timeout_geoip_2600:3c00::f03c:91ff:fedf:915c", "1448201235", "no");
INSERT INTO `apprenz_options` VALUES("6937", "_transient_geoip_2600:3c00::f03c:91ff:fedf:915c", "US", "no");
INSERT INTO `apprenz_options` VALUES("6938", "_transient_timeout_geoip_104.254.98.56", "1448201491", "no");
INSERT INTO `apprenz_options` VALUES("6939", "_transient_geoip_104.254.98.56", "VG", "no");
INSERT INTO `apprenz_options` VALUES("6940", "_transient_timeout_geoip_50.28.61.160", "1448201618", "no");
INSERT INTO `apprenz_options` VALUES("6941", "_transient_geoip_50.28.61.160", "US", "no");
INSERT INTO `apprenz_options` VALUES("6942", "_transient_timeout_geoip_65.254.36.210", "1448202232", "no");
INSERT INTO `apprenz_options` VALUES("6943", "_transient_geoip_65.254.36.210", "US", "no");
INSERT INTO `apprenz_options` VALUES("6944", "_transient_timeout_geoip_65.18.192.214", "1448202310", "no");
INSERT INTO `apprenz_options` VALUES("6945", "_transient_geoip_65.18.192.214", "US", "no");
INSERT INTO `apprenz_options` VALUES("6946", "_transient_timeout_geoip_222.231.2.38", "1448202527", "no");
INSERT INTO `apprenz_options` VALUES("6947", "_transient_geoip_222.231.2.38", "KR", "no");
INSERT INTO `apprenz_options` VALUES("6948", "_transient_timeout_geoip_69.162.85.234", "1448202807", "no");
INSERT INTO `apprenz_options` VALUES("6949", "_transient_geoip_69.162.85.234", "US", "no");
INSERT INTO `apprenz_options` VALUES("6950", "_transient_timeout_geoip_109.233.126.154", "1448202821", "no");
INSERT INTO `apprenz_options` VALUES("6951", "_transient_geoip_109.233.126.154", "IT", "no");
INSERT INTO `apprenz_options` VALUES("6952", "_transient_timeout_geoip_162.216.113.41", "1448202847", "no");
INSERT INTO `apprenz_options` VALUES("6953", "_transient_geoip_162.216.113.41", "US", "no");
INSERT INTO `apprenz_options` VALUES("6954", "_transient_timeout_geoip_67.210.109.180", "1448203346", "no");
INSERT INTO `apprenz_options` VALUES("6955", "_transient_geoip_67.210.109.180", "US", "no");
INSERT INTO `apprenz_options` VALUES("6956", "_transient_timeout_geoip_2607:5300:60:6bb2::", "1448204257", "no");
INSERT INTO `apprenz_options` VALUES("6957", "_transient_geoip_2607:5300:60:6bb2::", "CA", "no");
INSERT INTO `apprenz_options` VALUES("6959", "_transient_timeout_geoip_66.71.242.106", "1448204845", "no");
INSERT INTO `apprenz_options` VALUES("6960", "_transient_geoip_66.71.242.106", "US", "no");
INSERT INTO `apprenz_options` VALUES("6961", "_transient_timeout_geoip_180.76.15.13", "1448205445", "no");
INSERT INTO `apprenz_options` VALUES("6962", "_transient_geoip_180.76.15.13", "CN", "no");
INSERT INTO `apprenz_options` VALUES("6963", "_transient_timeout_geoip_192.232.211.37", "1448205661", "no");
INSERT INTO `apprenz_options` VALUES("6964", "_transient_geoip_192.232.211.37", "US", "no");
INSERT INTO `apprenz_options` VALUES("6965", "_transient_timeout_geoip_209.59.164.201", "1448206146", "no");
INSERT INTO `apprenz_options` VALUES("6966", "_transient_geoip_209.59.164.201", "US", "no");
INSERT INTO `apprenz_options` VALUES("8573", "_transient_timeout_geoip_75.127.118.226", "1448881536", "no");
INSERT INTO `apprenz_options` VALUES("8574", "_transient_geoip_75.127.118.226", "US", "no");
INSERT INTO `apprenz_options` VALUES("6969", "_transient_timeout_geoip_2a00:8620:100::b", "1448206601", "no");
INSERT INTO `apprenz_options` VALUES("6970", "_transient_geoip_2a00:8620:100::b", "", "no");
INSERT INTO `apprenz_options` VALUES("6971", "_transient_timeout_external_ip_address_2a00:8620:100::b", "1448206601", "no");
INSERT INTO `apprenz_options` VALUES("6972", "_transient_external_ip_address_2a00:8620:100::b", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("6973", "_transient_timeout_geoip_166.63.125.100", "1448206775", "no");
INSERT INTO `apprenz_options` VALUES("6974", "_transient_geoip_166.63.125.100", "US", "no");
INSERT INTO `apprenz_options` VALUES("6975", "_transient_timeout_geoip_67.222.22.12", "1448207144", "no");
INSERT INTO `apprenz_options` VALUES("6976", "_transient_geoip_67.222.22.12", "US", "no");
INSERT INTO `apprenz_options` VALUES("6977", "_transient_timeout_geoip_185.40.85.36", "1448207186", "no");
INSERT INTO `apprenz_options` VALUES("6978", "_transient_geoip_185.40.85.36", "TR", "no");
INSERT INTO `apprenz_options` VALUES("6979", "_transient_timeout_geoip_69.36.181.204", "1448207285", "no");
INSERT INTO `apprenz_options` VALUES("6980", "_transient_geoip_69.36.181.204", "US", "no");
INSERT INTO `apprenz_options` VALUES("6981", "_transient_timeout_geoip_173.224.119.188", "1448207857", "no");
INSERT INTO `apprenz_options` VALUES("6982", "_transient_geoip_173.224.119.188", "US", "no");
INSERT INTO `apprenz_options` VALUES("6984", "_transient_timeout_geoip_50.115.127.4", "1448207869", "no");
INSERT INTO `apprenz_options` VALUES("6985", "_transient_geoip_50.115.127.4", "US", "no");
INSERT INTO `apprenz_options` VALUES("6986", "_transient_timeout_geoip_103.28.140.90", "1448208253", "no");
INSERT INTO `apprenz_options` VALUES("6987", "_transient_geoip_103.28.140.90", "IN", "no");
INSERT INTO `apprenz_options` VALUES("6988", "_transient_timeout_geoip_2607:5300:60:b82::1", "1448208816", "no");
INSERT INTO `apprenz_options` VALUES("6989", "_transient_geoip_2607:5300:60:b82::1", "CA", "no");
INSERT INTO `apprenz_options` VALUES("6990", "_transient_timeout_geoip_199.91.233.36", "1448208908", "no");
INSERT INTO `apprenz_options` VALUES("6991", "_transient_geoip_199.91.233.36", "US", "no");
INSERT INTO `apprenz_options` VALUES("6992", "_transient_timeout_geoip_81.5.176.26", "1448209473", "no");
INSERT INTO `apprenz_options` VALUES("6993", "_transient_geoip_81.5.176.26", "GB", "no");
INSERT INTO `apprenz_options` VALUES("6994", "_transient_timeout_geoip_66.135.38.151", "1448210036", "no");
INSERT INTO `apprenz_options` VALUES("6995", "_transient_geoip_66.135.38.151", "US", "no");
INSERT INTO `apprenz_options` VALUES("6996", "_transient_timeout_geoip_178.249.187.215", "1448210609", "no");
INSERT INTO `apprenz_options` VALUES("6997", "_transient_geoip_178.249.187.215", "IT", "no");
INSERT INTO `apprenz_options` VALUES("6998", "_transient_timeout_geoip_83.145.194.160", "1448212172", "no");
INSERT INTO `apprenz_options` VALUES("6999", "_transient_geoip_83.145.194.160", "FI", "no");
INSERT INTO `apprenz_options` VALUES("7001", "_transient_timeout_geoip_78.220.114.32", "1448212234", "no");
INSERT INTO `apprenz_options` VALUES("7002", "_transient_geoip_78.220.114.32", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7003", "_transient_timeout_geoip_155.94.237.184", "1448212408", "no");
INSERT INTO `apprenz_options` VALUES("7004", "_transient_geoip_155.94.237.184", "US", "no");
INSERT INTO `apprenz_options` VALUES("7005", "_transient_timeout_geoip_54.154.229.137", "1448212425", "no");
INSERT INTO `apprenz_options` VALUES("7006", "_transient_geoip_54.154.229.137", "IE", "no");
INSERT INTO `apprenz_options` VALUES("7007", "_transient_timeout_geoip_188.126.110.15", "1448212509", "no");
INSERT INTO `apprenz_options` VALUES("7008", "_transient_geoip_188.126.110.15", "NL", "no");
INSERT INTO `apprenz_options` VALUES("7009", "_transient_timeout_geoip_216.244.83.146", "1448212573", "no");
INSERT INTO `apprenz_options` VALUES("7010", "_transient_geoip_216.244.83.146", "US", "no");
INSERT INTO `apprenz_options` VALUES("7011", "_transient_timeout_geoip_162.243.202.68", "1448213098", "no");
INSERT INTO `apprenz_options` VALUES("7012", "_transient_geoip_162.243.202.68", "US", "no");
INSERT INTO `apprenz_options` VALUES("7013", "_transient_timeout_geoip_88.208.229.134", "1448213168", "no");
INSERT INTO `apprenz_options` VALUES("7014", "_transient_geoip_88.208.229.134", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7015", "_transient_timeout_geoip_205.186.136.216", "1448213168", "no");
INSERT INTO `apprenz_options` VALUES("7016", "_transient_geoip_205.186.136.216", "US", "no");
INSERT INTO `apprenz_options` VALUES("7017", "_transient_timeout_geoip_52.6.201.146", "1448213244", "no");
INSERT INTO `apprenz_options` VALUES("7018", "_transient_geoip_52.6.201.146", "US", "no");
INSERT INTO `apprenz_options` VALUES("7019", "_transient_timeout_geoip_85.95.246.69", "1448213335", "no");
INSERT INTO `apprenz_options` VALUES("7020", "_transient_geoip_85.95.246.69", "TR", "no");
INSERT INTO `apprenz_options` VALUES("7021", "_transient_timeout_geoip_128.199.52.153", "1448213400", "no");
INSERT INTO `apprenz_options` VALUES("7022", "_transient_geoip_128.199.52.153", "NL", "no");
INSERT INTO `apprenz_options` VALUES("7023", "_transient_timeout_geoip_199.116.252.165", "1448214054", "no");
INSERT INTO `apprenz_options` VALUES("7024", "_transient_geoip_199.116.252.165", "US", "no");
INSERT INTO `apprenz_options` VALUES("7025", "_transient_timeout_geoip_64.50.185.21", "1448214083", "no");
INSERT INTO `apprenz_options` VALUES("7026", "_transient_geoip_64.50.185.21", "US", "no");
INSERT INTO `apprenz_options` VALUES("7027", "_transient_timeout_geoip_2602:ffd6:d0d:dead:beef:f00d:17c9:92b3", "1448214107", "no");
INSERT INTO `apprenz_options` VALUES("7028", "_transient_geoip_2602:ffd6:d0d:dead:beef:f00d:17c9:92b3", "US", "no");
INSERT INTO `apprenz_options` VALUES("7029", "_transient_timeout_geoip_207.210.220.203", "1448214110", "no");
INSERT INTO `apprenz_options` VALUES("7030", "_transient_geoip_207.210.220.203", "CA", "no");
INSERT INTO `apprenz_options` VALUES("7031", "_transient_timeout_geoip_213.133.98.245", "1448214278", "no");
INSERT INTO `apprenz_options` VALUES("7032", "_transient_geoip_213.133.98.245", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7033", "_transient_timeout_geoip_216.97.231.190", "1448216074", "no");
INSERT INTO `apprenz_options` VALUES("7034", "_transient_geoip_216.97.231.190", "US", "no");
INSERT INTO `apprenz_options` VALUES("7040", "_transient_timeout_geoip_85.158.203.62", "1448216410", "no");
INSERT INTO `apprenz_options` VALUES("7041", "_transient_geoip_85.158.203.62", "NL", "no");
INSERT INTO `apprenz_options` VALUES("7043", "_transient_timeout_geoip_52.11.234.78", "1448216413", "no");
INSERT INTO `apprenz_options` VALUES("7044", "_transient_geoip_52.11.234.78", "US", "no");
INSERT INTO `apprenz_options` VALUES("7045", "_transient_timeout_geoip_2607:5300:60:3d34::1", "1448216955", "no");
INSERT INTO `apprenz_options` VALUES("7046", "_transient_geoip_2607:5300:60:3d34::1", "CA", "no");
INSERT INTO `apprenz_options` VALUES("7047", "_transient_timeout_geoip_184.172.237.162", "1448217889", "no");
INSERT INTO `apprenz_options` VALUES("7048", "_transient_geoip_184.172.237.162", "US", "no");
INSERT INTO `apprenz_options` VALUES("8607", "_transient_timeout_geoip_65.99.206.154", "1448915969", "no");
INSERT INTO `apprenz_options` VALUES("8608", "_transient_geoip_65.99.206.154", "US", "no");
INSERT INTO `apprenz_options` VALUES("7051", "_transient_timeout_geoip_199.195.146.177", "1448218355", "no");
INSERT INTO `apprenz_options` VALUES("7052", "_transient_geoip_199.195.146.177", "US", "no");
INSERT INTO `apprenz_options` VALUES("7053", "_transient_timeout_geoip_216.177.0.77", "1448218547", "no");
INSERT INTO `apprenz_options` VALUES("7054", "_transient_geoip_216.177.0.77", "US", "no");
INSERT INTO `apprenz_options` VALUES("7055", "_transient_timeout_geoip_52.3.215.113", "1448218659", "no");
INSERT INTO `apprenz_options` VALUES("7056", "_transient_geoip_52.3.215.113", "US", "no");
INSERT INTO `apprenz_options` VALUES("7058", "_transient_timeout_geoip_188.210.216.129", "1448219305", "no");
INSERT INTO `apprenz_options` VALUES("7059", "_transient_geoip_188.210.216.129", "ES", "no");
INSERT INTO `apprenz_options` VALUES("7060", "_transient_timeout_geoip_109.70.1.181", "1448219964", "no");
INSERT INTO `apprenz_options` VALUES("7061", "_transient_geoip_109.70.1.181", "NL", "no");
INSERT INTO `apprenz_options` VALUES("7063", "_transient_timeout_geoip_210.173.154.83", "1448220314", "no");
INSERT INTO `apprenz_options` VALUES("7064", "_transient_geoip_210.173.154.83", "JP", "no");
INSERT INTO `apprenz_options` VALUES("7065", "_transient_timeout_geoip_93.92.161.186", "1448220615", "no");
INSERT INTO `apprenz_options` VALUES("7066", "_transient_geoip_93.92.161.186", "AT", "no");
INSERT INTO `apprenz_options` VALUES("7067", "_transient_timeout_geoip_91.212.213.12", "1448221148", "no");
INSERT INTO `apprenz_options` VALUES("7068", "_transient_geoip_91.212.213.12", "GE", "no");
INSERT INTO `apprenz_options` VALUES("7074", "_transient_timeout_geoip_184.164.154.66", "1448221530", "no");
INSERT INTO `apprenz_options` VALUES("7075", "_transient_geoip_184.164.154.66", "US", "no");
INSERT INTO `apprenz_options` VALUES("7076", "_transient_timeout_geoip_2a01:238:4228:3c00:d00d:577c:4b63:889d", "1448221760", "no");
INSERT INTO `apprenz_options` VALUES("7077", "_transient_geoip_2a01:238:4228:3c00:d00d:577c:4b63:889d", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7078", "_transient_timeout_geoip_104.227.190.48", "1448222233", "no");
INSERT INTO `apprenz_options` VALUES("7079", "_transient_geoip_104.227.190.48", "US", "no");
INSERT INTO `apprenz_options` VALUES("7080", "_transient_timeout_geoip_2a02:c200:0:10:3:2:2525:1", "1448222324", "no");
INSERT INTO `apprenz_options` VALUES("7081", "_transient_geoip_2a02:c200:0:10:3:2:2525:1", "DE", "no");
INSERT INTO `apprenz_options` VALUES("9170", "_transient_timeout_geoip_178.33.36.130", "1449377292", "no");
INSERT INTO `apprenz_options` VALUES("9171", "_transient_geoip_178.33.36.130", "DE", "no");
INSERT INTO `apprenz_options` VALUES("9275", "_transient_timeout_geoip_66.23.227.10", "1449457315", "no");
INSERT INTO `apprenz_options` VALUES("9276", "_transient_geoip_66.23.227.10", "US", "no");
INSERT INTO `apprenz_options` VALUES("7086", "_transient_timeout_geoip_203.222.113.159", "1448223402", "no");
INSERT INTO `apprenz_options` VALUES("7087", "_transient_geoip_203.222.113.159", "AU", "no");
INSERT INTO `apprenz_options` VALUES("7088", "_transient_timeout_geoip_2606:2e00:0:1:225:90ff:fe76:2db2", "1448223618", "no");
INSERT INTO `apprenz_options` VALUES("7089", "_transient_geoip_2606:2e00:0:1:225:90ff:fe76:2db2", "US", "no");
INSERT INTO `apprenz_options` VALUES("7091", "_transient_timeout_geoip_2607:f208:50a:2500::10", "1448223798", "no");
INSERT INTO `apprenz_options` VALUES("7092", "_transient_geoip_2607:f208:50a:2500::10", "US", "no");
INSERT INTO `apprenz_options` VALUES("7093", "_transient_timeout_geoip_182.48.16.68", "1448223929", "no");
INSERT INTO `apprenz_options` VALUES("7094", "_transient_geoip_182.48.16.68", "JP", "no");
INSERT INTO `apprenz_options` VALUES("7095", "_transient_timeout_geoip_95.173.177.82", "1448223965", "no");
INSERT INTO `apprenz_options` VALUES("7096", "_transient_geoip_95.173.177.82", "TR", "no");
INSERT INTO `apprenz_options` VALUES("7097", "_transient_timeout_geoip_77.243.190.133", "1448224113", "no");
INSERT INTO `apprenz_options` VALUES("7098", "_transient_geoip_77.243.190.133", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7099", "_transient_timeout_geoip_103.20.91.41", "1448224191", "no");
INSERT INTO `apprenz_options` VALUES("7100", "_transient_geoip_103.20.91.41", "ID", "no");
INSERT INTO `apprenz_options` VALUES("7101", "_transient_timeout_geoip_216.70.88.130", "1448224300", "no");
INSERT INTO `apprenz_options` VALUES("7102", "_transient_geoip_216.70.88.130", "US", "no");
INSERT INTO `apprenz_options` VALUES("7103", "_transient_timeout_geoip_94.198.100.19", "1448224371", "no");
INSERT INTO `apprenz_options` VALUES("7104", "_transient_geoip_94.198.100.19", "IT", "no");
INSERT INTO `apprenz_options` VALUES("7105", "_transient_timeout_geoip_91.228.197.30", "1448224639", "no");
INSERT INTO `apprenz_options` VALUES("7106", "_transient_geoip_91.228.197.30", "PL", "no");
INSERT INTO `apprenz_options` VALUES("7107", "_transient_timeout_geoip_142.4.14.225", "1448224671", "no");
INSERT INTO `apprenz_options` VALUES("7108", "_transient_geoip_142.4.14.225", "US", "no");
INSERT INTO `apprenz_options` VALUES("7109", "_transient_timeout_geoip_5.135.240.46", "1448224794", "no");
INSERT INTO `apprenz_options` VALUES("7110", "_transient_geoip_5.135.240.46", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7111", "_transient_timeout_geoip_112.196.35.15", "1448225334", "no");
INSERT INTO `apprenz_options` VALUES("7112", "_transient_geoip_112.196.35.15", "IN", "no");
INSERT INTO `apprenz_options` VALUES("7113", "_transient_timeout_geoip_87.98.140.132", "1448225755", "no");
INSERT INTO `apprenz_options` VALUES("7114", "_transient_geoip_87.98.140.132", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7115", "_transient_timeout_geoip_199.119.123.228", "1448226117", "no");
INSERT INTO `apprenz_options` VALUES("7116", "_transient_geoip_199.119.123.228", "US", "no");
INSERT INTO `apprenz_options` VALUES("7117", "_transient_timeout_geoip_69.43.203.183", "1448226282", "no");
INSERT INTO `apprenz_options` VALUES("7118", "_transient_geoip_69.43.203.183", "US", "no");
INSERT INTO `apprenz_options` VALUES("7119", "_transient_timeout_geoip_64.50.161.45", "1448227412", "no");
INSERT INTO `apprenz_options` VALUES("7120", "_transient_geoip_64.50.161.45", "US", "no");
INSERT INTO `apprenz_options` VALUES("7122", "_transient_timeout_geoip_75.102.24.71", "1448228029", "no");
INSERT INTO `apprenz_options` VALUES("7123", "_transient_geoip_75.102.24.71", "US", "no");
INSERT INTO `apprenz_options` VALUES("7124", "_transient_timeout_geoip_184.170.149.127", "1448228528", "no");
INSERT INTO `apprenz_options` VALUES("7125", "_transient_geoip_184.170.149.127", "US", "no");
INSERT INTO `apprenz_options` VALUES("7126", "_transient_timeout_geoip_50.93.206.232", "1448229243", "no");
INSERT INTO `apprenz_options` VALUES("7127", "_transient_geoip_50.93.206.232", "US", "no");
INSERT INTO `apprenz_options` VALUES("7128", "_transient_timeout_geoip_2a00:1d70:c01c::69:119", "1448229447", "no");
INSERT INTO `apprenz_options` VALUES("7129", "_transient_geoip_2a00:1d70:c01c::69:119", "ES", "no");
INSERT INTO `apprenz_options` VALUES("7130", "_transient_timeout_geoip_2604:7c00:18:30:226:b9ff:fe58:d90e", "1448229753", "no");
INSERT INTO `apprenz_options` VALUES("7131", "_transient_geoip_2604:7c00:18:30:226:b9ff:fe58:d90e", "US", "no");
INSERT INTO `apprenz_options` VALUES("7132", "_transient_timeout_geoip_64.5.53.92", "1448229827", "no");
INSERT INTO `apprenz_options` VALUES("7133", "_transient_geoip_64.5.53.92", "US", "no");
INSERT INTO `apprenz_options` VALUES("7134", "_transient_timeout_geoip_2a01:4f8:192:616d::2", "1448229974", "no");
INSERT INTO `apprenz_options` VALUES("7135", "_transient_geoip_2a01:4f8:192:616d::2", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7136", "_transient_timeout_geoip_78.47.255.166", "1448229982", "no");
INSERT INTO `apprenz_options` VALUES("7137", "_transient_geoip_78.47.255.166", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7138", "_transient_timeout_geoip_195.154.126.70", "1448230400", "no");
INSERT INTO `apprenz_options` VALUES("7139", "_transient_geoip_195.154.126.70", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7140", "_transient_timeout_geoip_91.142.214.157", "1448230946", "no");
INSERT INTO `apprenz_options` VALUES("7141", "_transient_geoip_91.142.214.157", "ES", "no");
INSERT INTO `apprenz_options` VALUES("7142", "_transient_timeout_geoip_2001:4800:7818:104:be76:4eff:fe05:50a4", "1448231197", "no");
INSERT INTO `apprenz_options` VALUES("7143", "_transient_geoip_2001:4800:7818:104:be76:4eff:fe05:50a4", "US", "no");
INSERT INTO `apprenz_options` VALUES("7145", "_transient_timeout_geoip_62.181.233.39", "1448231627", "no");
INSERT INTO `apprenz_options` VALUES("7146", "_transient_geoip_62.181.233.39", "SE", "no");
INSERT INTO `apprenz_options` VALUES("7147", "_transient_timeout_geoip_173.45.89.240", "1448232243", "no");
INSERT INTO `apprenz_options` VALUES("7148", "_transient_geoip_173.45.89.240", "US", "no");
INSERT INTO `apprenz_options` VALUES("7149", "_transient_timeout_geoip_101.50.2.96", "1448232313", "no");
INSERT INTO `apprenz_options` VALUES("7150", "_transient_geoip_101.50.2.96", "ID", "no");
INSERT INTO `apprenz_options` VALUES("7151", "_transient_timeout_geoip_198.207.151.51", "1448232406", "no");
INSERT INTO `apprenz_options` VALUES("7152", "_transient_geoip_198.207.151.51", "US", "no");
INSERT INTO `apprenz_options` VALUES("7153", "_transient_timeout_geoip_52.11.178.97", "1448232476", "no");
INSERT INTO `apprenz_options` VALUES("7154", "_transient_geoip_52.11.178.97", "US", "no");
INSERT INTO `apprenz_options` VALUES("7155", "_transient_timeout_geoip_66.135.60.160", "1448233046", "no");
INSERT INTO `apprenz_options` VALUES("7156", "_transient_geoip_66.135.60.160", "US", "no");
INSERT INTO `apprenz_options` VALUES("7157", "_transient_timeout_geoip_65.61.122.20", "1448233128", "no");
INSERT INTO `apprenz_options` VALUES("7158", "_transient_geoip_65.61.122.20", "US", "no");
INSERT INTO `apprenz_options` VALUES("7159", "_transient_timeout_geoip_2001:41d0:a:3d99::1", "1448233689", "no");
INSERT INTO `apprenz_options` VALUES("7160", "_transient_geoip_2001:41d0:a:3d99::1", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7161", "_transient_timeout_geoip_198.57.157.140", "1448233878", "no");
INSERT INTO `apprenz_options` VALUES("7162", "_transient_geoip_198.57.157.140", "US", "no");
INSERT INTO `apprenz_options` VALUES("7163", "_transient_timeout_geoip_203.78.109.61", "1448233990", "no");
INSERT INTO `apprenz_options` VALUES("7164", "_transient_geoip_203.78.109.61", "TH", "no");
INSERT INTO `apprenz_options` VALUES("7165", "_transient_timeout_geoip_79.170.44.155", "1448234139", "no");
INSERT INTO `apprenz_options` VALUES("7166", "_transient_geoip_79.170.44.155", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7167", "_transient_timeout_geoip_192.169.231.4", "1448234249", "no");
INSERT INTO `apprenz_options` VALUES("7168", "_transient_geoip_192.169.231.4", "US", "no");
INSERT INTO `apprenz_options` VALUES("7169", "_transient_timeout_geoip_66.84.10.2", "1448234336", "no");
INSERT INTO `apprenz_options` VALUES("7170", "_transient_geoip_66.84.10.2", "US", "no");
INSERT INTO `apprenz_options` VALUES("7171", "_transient_timeout_geoip_81.30.150.115", "1448234624", "no");
INSERT INTO `apprenz_options` VALUES("7172", "_transient_geoip_81.30.150.115", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7173", "_transient_timeout_geoip_104.238.74.47", "1448234638", "no");
INSERT INTO `apprenz_options` VALUES("7174", "_transient_geoip_104.238.74.47", "US", "no");
INSERT INTO `apprenz_options` VALUES("7175", "_transient_timeout_geoip_103.247.98.218", "1448234889", "no");
INSERT INTO `apprenz_options` VALUES("7176", "_transient_geoip_103.247.98.218", "IN", "no");
INSERT INTO `apprenz_options` VALUES("7178", "_transient_timeout_geoip_2a01:7c8:aaaa:1b1:5054:ff:fe28:c10", "1448235071", "no");
INSERT INTO `apprenz_options` VALUES("7179", "_transient_geoip_2a01:7c8:aaaa:1b1:5054:ff:fe28:c10", "NL", "no");
INSERT INTO `apprenz_options` VALUES("7180", "_transient_timeout_geoip_195.242.93.89", "1448235079", "no");
INSERT INTO `apprenz_options` VALUES("7181", "_transient_geoip_195.242.93.89", "PL", "no");
INSERT INTO `apprenz_options` VALUES("7182", "_transient_timeout_geoip_95.110.224.133", "1448235296", "no");
INSERT INTO `apprenz_options` VALUES("7183", "_transient_geoip_95.110.224.133", "IT", "no");
INSERT INTO `apprenz_options` VALUES("7184", "_transient_timeout_geoip_178.32.253.68", "1448235407", "no");
INSERT INTO `apprenz_options` VALUES("7185", "_transient_geoip_178.32.253.68", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7186", "_transient_timeout_geoip_120.138.27.81", "1448235437", "no");
INSERT INTO `apprenz_options` VALUES("7187", "_transient_geoip_120.138.27.81", "NZ", "no");
INSERT INTO `apprenz_options` VALUES("7188", "_transient_timeout_geoip_74.50.28.195", "1448237102", "no");
INSERT INTO `apprenz_options` VALUES("7189", "_transient_geoip_74.50.28.195", "US", "no");
INSERT INTO `apprenz_options` VALUES("7191", "_transient_timeout_geoip_2a01:4f8:121:142b::2", "1448237256", "no");
INSERT INTO `apprenz_options` VALUES("7192", "_transient_geoip_2a01:4f8:121:142b::2", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7193", "_transient_timeout_geoip_207.210.77.213", "1448237404", "no");
INSERT INTO `apprenz_options` VALUES("7194", "_transient_geoip_207.210.77.213", "US", "no");
INSERT INTO `apprenz_options` VALUES("7195", "_transient_timeout_geoip_2001:41d0:8:9b81::1", "1448237813", "no");
INSERT INTO `apprenz_options` VALUES("7196", "_transient_geoip_2001:41d0:8:9b81::1", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7197", "_transient_timeout_geoip_184.154.47.66", "1448238996", "no");
INSERT INTO `apprenz_options` VALUES("7198", "_transient_geoip_184.154.47.66", "US", "no");
INSERT INTO `apprenz_options` VALUES("7200", "_transient_timeout_geoip_210.253.105.184", "1448239219", "no");
INSERT INTO `apprenz_options` VALUES("7201", "_transient_geoip_210.253.105.184", "JP", "no");
INSERT INTO `apprenz_options` VALUES("7202", "_transient_timeout_geoip_23.226.70.146", "1448239288", "no");
INSERT INTO `apprenz_options` VALUES("7203", "_transient_geoip_23.226.70.146", "US", "no");
INSERT INTO `apprenz_options` VALUES("7204", "_transient_timeout_geoip_93.191.155.16", "1448239291", "no");
INSERT INTO `apprenz_options` VALUES("7205", "_transient_geoip_93.191.155.16", "DK", "no");
INSERT INTO `apprenz_options` VALUES("7206", "_transient_timeout_geoip_77.89.19.149", "1448239546", "no");
INSERT INTO `apprenz_options` VALUES("7207", "_transient_geoip_77.89.19.149", "IT", "no");
INSERT INTO `apprenz_options` VALUES("7208", "_transient_timeout_geoip_46.235.47.98", "1448239769", "no");
INSERT INTO `apprenz_options` VALUES("7209", "_transient_geoip_46.235.47.98", "NL", "no");
INSERT INTO `apprenz_options` VALUES("7210", "_transient_timeout_geoip_77.174.129.46", "1448239791", "no");
INSERT INTO `apprenz_options` VALUES("7211", "_transient_geoip_77.174.129.46", "NL", "no");
INSERT INTO `apprenz_options` VALUES("7212", "_transient_timeout_geoip_72.52.226.93", "1448239895", "no");
INSERT INTO `apprenz_options` VALUES("7213", "_transient_geoip_72.52.226.93", "US", "no");
INSERT INTO `apprenz_options` VALUES("8788", "_transient_timeout_geoip_198.57.139.196", "1449068170", "no");
INSERT INTO `apprenz_options` VALUES("8789", "_transient_geoip_198.57.139.196", "US", "no");
INSERT INTO `apprenz_options` VALUES("7216", "_transient_timeout_geoip_5.39.82.43", "1448240590", "no");
INSERT INTO `apprenz_options` VALUES("7217", "_transient_geoip_5.39.82.43", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7218", "_transient_timeout_geoip_69.160.61.220", "1448241411", "no");
INSERT INTO `apprenz_options` VALUES("7219", "_transient_geoip_69.160.61.220", "US", "no");
INSERT INTO `apprenz_options` VALUES("7220", "_transient_timeout_geoip_2600:3c01::f03c:91ff:fe26:64b", "1448242172", "no");
INSERT INTO `apprenz_options` VALUES("7221", "_transient_geoip_2600:3c01::f03c:91ff:fe26:64b", "US", "no");
INSERT INTO `apprenz_options` VALUES("7222", "_transient_timeout_geoip_184.154.152.98", "1448243269", "no");
INSERT INTO `apprenz_options` VALUES("7223", "_transient_geoip_184.154.152.98", "US", "no");
INSERT INTO `apprenz_options` VALUES("7225", "_transient_timeout_geoip_216.120.237.3", "1448243281", "no");
INSERT INTO `apprenz_options` VALUES("7226", "_transient_geoip_216.120.237.3", "US", "no");
INSERT INTO `apprenz_options` VALUES("7227", "_transient_timeout_geoip_52.7.172.60", "1448243502", "no");
INSERT INTO `apprenz_options` VALUES("7228", "_transient_geoip_52.7.172.60", "US", "no");
INSERT INTO `apprenz_options` VALUES("7229", "_transient_timeout_geoip_91.195.183.106", "1448243584", "no");
INSERT INTO `apprenz_options` VALUES("7230", "_transient_geoip_91.195.183.106", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7231", "_transient_timeout_geoip_192.186.155.4", "1448243727", "no");
INSERT INTO `apprenz_options` VALUES("7232", "_transient_geoip_192.186.155.4", "US", "no");
INSERT INTO `apprenz_options` VALUES("7233", "_transient_timeout_geoip_178.62.69.249", "1448243811", "no");
INSERT INTO `apprenz_options` VALUES("7234", "_transient_geoip_178.62.69.249", "US", "no");
INSERT INTO `apprenz_options` VALUES("7235", "_transient_timeout_geoip_107.22.172.144", "1448243950", "no");
INSERT INTO `apprenz_options` VALUES("7236", "_transient_geoip_107.22.172.144", "US", "no");
INSERT INTO `apprenz_options` VALUES("7237", "_transient_timeout_geoip_50.28.29.39", "1448243952", "no");
INSERT INTO `apprenz_options` VALUES("7238", "_transient_geoip_50.28.29.39", "US", "no");
INSERT INTO `apprenz_options` VALUES("7239", "_transient_timeout_geoip_178.79.0.3", "1448243960", "no");
INSERT INTO `apprenz_options` VALUES("7240", "_transient_geoip_178.79.0.3", "RS", "no");
INSERT INTO `apprenz_options` VALUES("7241", "_transient_timeout_geoip_74.63.251.114", "1448244103", "no");
INSERT INTO `apprenz_options` VALUES("7242", "_transient_geoip_74.63.251.114", "US", "no");
INSERT INTO `apprenz_options` VALUES("7243", "_transient_timeout_geoip_188.173.1.45", "1448244352", "no");
INSERT INTO `apprenz_options` VALUES("7244", "_transient_geoip_188.173.1.45", "RO", "no");
INSERT INTO `apprenz_options` VALUES("7245", "_transient_timeout_geoip_184.106.149.192", "1448244666", "no");
INSERT INTO `apprenz_options` VALUES("7246", "_transient_geoip_184.106.149.192", "US", "no");
INSERT INTO `apprenz_options` VALUES("7247", "_transient_timeout_geoip_54.72.175.28", "1448244953", "no");
INSERT INTO `apprenz_options` VALUES("7248", "_transient_geoip_54.72.175.28", "IE", "no");
INSERT INTO `apprenz_options` VALUES("7249", "_transient_timeout_geoip_81.25.224.74", "1448245234", "no");
INSERT INTO `apprenz_options` VALUES("7250", "_transient_geoip_81.25.224.74", "UA", "no");
INSERT INTO `apprenz_options` VALUES("7251", "_transient_timeout_geoip_2a03:2a00:1100:2::ac10:2726", "1448246269", "no");
INSERT INTO `apprenz_options` VALUES("7252", "_transient_geoip_2a03:2a00:1100:2::ac10:2726", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7253", "_transient_timeout_geoip_84.240.9.6:8338", "1448247795", "no");
INSERT INTO `apprenz_options` VALUES("7254", "_transient_geoip_84.240.9.6:8338", "", "no");
INSERT INTO `apprenz_options` VALUES("7255", "_transient_timeout_external_ip_address_84.240.9.6:8338", "1448247796", "no");
INSERT INTO `apprenz_options` VALUES("7256", "_transient_external_ip_address_84.240.9.6:8338", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("7258", "_transient_timeout_geoip_84.240.9.6:10477", "1448247799", "no");
INSERT INTO `apprenz_options` VALUES("7259", "_transient_geoip_84.240.9.6:10477", "", "no");
INSERT INTO `apprenz_options` VALUES("7260", "_transient_timeout_external_ip_address_84.240.9.6:10477", "1448247800", "no");
INSERT INTO `apprenz_options` VALUES("7261", "_transient_external_ip_address_84.240.9.6:10477", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("7262", "_transient_timeout_geoip_2a01:488:66:1000:b01c:112b:0:1", "1448247896", "no");
INSERT INTO `apprenz_options` VALUES("7263", "_transient_geoip_2a01:488:66:1000:b01c:112b:0:1", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7264", "_transient_timeout_geoip_52.8.37.176", "1448247896", "no");
INSERT INTO `apprenz_options` VALUES("7265", "_transient_geoip_52.8.37.176", "US", "no");
INSERT INTO `apprenz_options` VALUES("7266", "_transient_timeout_geoip_198.50.155.115", "1448248030", "no");
INSERT INTO `apprenz_options` VALUES("7267", "_transient_geoip_198.50.155.115", "US", "no");
INSERT INTO `apprenz_options` VALUES("7268", "_transient_timeout_geoip_94.107.192.116", "1448248036", "no");
INSERT INTO `apprenz_options` VALUES("7269", "_transient_geoip_94.107.192.116", "BE", "no");
INSERT INTO `apprenz_options` VALUES("7270", "_transient_timeout_geoip_107.161.31.208", "1448248241", "no");
INSERT INTO `apprenz_options` VALUES("7271", "_transient_geoip_107.161.31.208", "US", "no");
INSERT INTO `apprenz_options` VALUES("7272", "_transient_timeout_geoip_193.107.36.33", "1448248612", "no");
INSERT INTO `apprenz_options` VALUES("7273", "_transient_geoip_193.107.36.33", "BG", "no");
INSERT INTO `apprenz_options` VALUES("7274", "_transient_timeout_geoip_205.209.123.35", "1448248734", "no");
INSERT INTO `apprenz_options` VALUES("7275", "_transient_geoip_205.209.123.35", "US", "no");
INSERT INTO `apprenz_options` VALUES("7276", "_transient_timeout_geoip_216.18.231.57", "1448248759", "no");
INSERT INTO `apprenz_options` VALUES("7277", "_transient_geoip_216.18.231.57", "US", "no");
INSERT INTO `apprenz_options` VALUES("7278", "_transient_timeout_geoip_85.92.69.194", "1448248822", "no");
INSERT INTO `apprenz_options` VALUES("7279", "_transient_geoip_85.92.69.194", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7280", "_transient_timeout_geoip_2001:41d0:2:c11e::", "1448249682", "no");
INSERT INTO `apprenz_options` VALUES("7281", "_transient_geoip_2001:41d0:2:c11e::", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7282", "_transient_timeout_geoip_5.101.222.146", "1448249893", "no");
INSERT INTO `apprenz_options` VALUES("7283", "_transient_geoip_5.101.222.146", "RU", "no");
INSERT INTO `apprenz_options` VALUES("7284", "_transient_timeout_geoip_91.99.103.178", "1448250352", "no");
INSERT INTO `apprenz_options` VALUES("7285", "_transient_geoip_91.99.103.178", "IR", "no");
INSERT INTO `apprenz_options` VALUES("7286", "_transient_timeout_geoip_2607:fc98:0:45:216:3eff:fed6:226e", "1448250852", "no");
INSERT INTO `apprenz_options` VALUES("7287", "_transient_geoip_2607:fc98:0:45:216:3eff:fed6:226e", "US", "no");
INSERT INTO `apprenz_options` VALUES("7288", "_transient_timeout_geoip_93.89.232.21", "1448252067", "no");
INSERT INTO `apprenz_options` VALUES("7289", "_transient_geoip_93.89.232.21", "CY", "no");
INSERT INTO `apprenz_options` VALUES("7291", "_transient_timeout_geoip_54.76.233.69", "1448252707", "no");
INSERT INTO `apprenz_options` VALUES("7292", "_transient_geoip_54.76.233.69", "IE", "no");
INSERT INTO `apprenz_options` VALUES("7293", "_transient_timeout_geoip_31.172.113.143", "1448252886", "no");
INSERT INTO `apprenz_options` VALUES("7294", "_transient_geoip_31.172.113.143", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7295", "_transient_timeout_geoip_2001:1680:101:10::2", "1448252932", "no");
INSERT INTO `apprenz_options` VALUES("7296", "_transient_geoip_2001:1680:101:10::2", "CH", "no");
INSERT INTO `apprenz_options` VALUES("7297", "_transient_timeout_geoip_185.11.240.199", "1448253010", "no");
INSERT INTO `apprenz_options` VALUES("7298", "_transient_geoip_185.11.240.199", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7299", "_transient_timeout_geoip_46.20.225.49", "1448253087", "no");
INSERT INTO `apprenz_options` VALUES("7300", "_transient_geoip_46.20.225.49", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7301", "_transient_timeout_geoip_94.23.236.78", "1448253376", "no");
INSERT INTO `apprenz_options` VALUES("7302", "_transient_geoip_94.23.236.78", "FR", "no");
INSERT INTO `apprenz_options` VALUES("8548", "_transient_timeout_geoip_69.175.77.242", "1448867683", "no");
INSERT INTO `apprenz_options` VALUES("8549", "_transient_geoip_69.175.77.242", "US", "no");
INSERT INTO `apprenz_options` VALUES("7305", "_transient_timeout_geoip_72.52.134.255", "1448253490", "no");
INSERT INTO `apprenz_options` VALUES("7306", "_transient_geoip_72.52.134.255", "US", "no");
INSERT INTO `apprenz_options` VALUES("7307", "_transient_timeout_geoip_43.225.54.85", "1448253814", "no");
INSERT INTO `apprenz_options` VALUES("7308", "_transient_geoip_43.225.54.85", "IN", "no");
INSERT INTO `apprenz_options` VALUES("7309", "_transient_timeout_geoip_153.19.250.20", "1448253944", "no");
INSERT INTO `apprenz_options` VALUES("7310", "_transient_geoip_153.19.250.20", "PL", "no");
INSERT INTO `apprenz_options` VALUES("7311", "_transient_timeout_geoip_108.179.199.241", "1448253974", "no");
INSERT INTO `apprenz_options` VALUES("7312", "_transient_geoip_108.179.199.241", "US", "no");
INSERT INTO `apprenz_options` VALUES("7313", "_transient_timeout_geoip_2a01:4f8:190:71d3::2", "1448254111", "no");
INSERT INTO `apprenz_options` VALUES("7314", "_transient_geoip_2a01:4f8:190:71d3::2", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7315", "_transient_timeout_geoip_67.210.124.65", "1448254181", "no");
INSERT INTO `apprenz_options` VALUES("7316", "_transient_geoip_67.210.124.65", "US", "no");
INSERT INTO `apprenz_options` VALUES("7317", "_transient_timeout_geoip_69.175.41.2", "1448254540", "no");
INSERT INTO `apprenz_options` VALUES("7318", "_transient_geoip_69.175.41.2", "US", "no");
INSERT INTO `apprenz_options` VALUES("7319", "_transient_timeout_geoip_130.60.130.9", "1448254873", "no");
INSERT INTO `apprenz_options` VALUES("7320", "_transient_geoip_130.60.130.9", "CH", "no");
INSERT INTO `apprenz_options` VALUES("7321", "_transient_timeout_geoip_111.68.119.26", "1448254886", "no");
INSERT INTO `apprenz_options` VALUES("7322", "_transient_geoip_111.68.119.26", "ID", "no");
INSERT INTO `apprenz_options` VALUES("7323", "_transient_timeout_geoip_2001:c38:2000:166:be30:5bff:fecf:1fc2", "1448255074", "no");
INSERT INTO `apprenz_options` VALUES("7324", "_transient_geoip_2001:c38:2000:166:be30:5bff:fecf:1fc2", "TH", "no");
INSERT INTO `apprenz_options` VALUES("7325", "_transient_timeout_geoip_89.238.229.106", "1448255403", "no");
INSERT INTO `apprenz_options` VALUES("7326", "_transient_geoip_89.238.229.106", "RO", "no");
INSERT INTO `apprenz_options` VALUES("7327", "_transient_timeout_geoip_2a01:4f8:190:72ec::2", "1448255705", "no");
INSERT INTO `apprenz_options` VALUES("7328", "_transient_geoip_2a01:4f8:190:72ec::2", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7330", "_transient_timeout_geoip_200.73.116.213", "1448255734", "no");
INSERT INTO `apprenz_options` VALUES("7331", "_transient_geoip_200.73.116.213", "CL", "no");
INSERT INTO `apprenz_options` VALUES("7332", "_transient_timeout_geoip_176.193.97.137", "1448256401", "no");
INSERT INTO `apprenz_options` VALUES("7333", "_transient_geoip_176.193.97.137", "RU", "no");
INSERT INTO `apprenz_options` VALUES("7335", "_transient_timeout_geoip_173.205.127.98", "1448257580", "no");
INSERT INTO `apprenz_options` VALUES("7336", "_transient_geoip_173.205.127.98", "US", "no");
INSERT INTO `apprenz_options` VALUES("7337", "_transient_timeout_geoip_96.44.142.66", "1448257592", "no");
INSERT INTO `apprenz_options` VALUES("7338", "_transient_geoip_96.44.142.66", "US", "no");
INSERT INTO `apprenz_options` VALUES("7339", "_transient_timeout_geoip_23.23.80.149", "1448257628", "no");
INSERT INTO `apprenz_options` VALUES("7340", "_transient_geoip_23.23.80.149", "US", "no");
INSERT INTO `apprenz_options` VALUES("7341", "_transient_timeout_geoip_2a01:4f8:191:73e6::2", "1448258008", "no");
INSERT INTO `apprenz_options` VALUES("7342", "_transient_geoip_2a01:4f8:191:73e6::2", "DE", "no");
INSERT INTO `apprenz_options` VALUES("8689", "_transient_timeout_geoip_198.20.104.157", "1449004506", "no");
INSERT INTO `apprenz_options` VALUES("8690", "_transient_geoip_198.20.104.157", "NL", "no");
INSERT INTO `apprenz_options` VALUES("7345", "_transient_timeout_geoip_41.185.8.152", "1448258136", "no");
INSERT INTO `apprenz_options` VALUES("7346", "_transient_geoip_41.185.8.152", "ZA", "no");
INSERT INTO `apprenz_options` VALUES("7347", "_transient_timeout_geoip_79.124.76.238", "1448258526", "no");
INSERT INTO `apprenz_options` VALUES("7348", "_transient_geoip_79.124.76.238", "BG", "no");
INSERT INTO `apprenz_options` VALUES("7349", "_transient_timeout_geoip_84.201.3.72", "1448258902", "no");
INSERT INTO `apprenz_options` VALUES("7350", "_transient_geoip_84.201.3.72", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7356", "_transient_timeout_geoip_180.76.15.150", "1448258984", "no");
INSERT INTO `apprenz_options` VALUES("7357", "_transient_geoip_180.76.15.150", "CN", "no");
INSERT INTO `apprenz_options` VALUES("7358", "_transient_timeout_geoip_94.23.6.88", "1448259124", "no");
INSERT INTO `apprenz_options` VALUES("7359", "_transient_geoip_94.23.6.88", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7360", "_transient_timeout_geoip_5.150.201.191", "1448259140", "no");
INSERT INTO `apprenz_options` VALUES("7361", "_transient_geoip_5.150.201.191", "SE", "no");
INSERT INTO `apprenz_options` VALUES("7362", "_transient_timeout_geoip_184.164.158.242", "1448259212", "no");
INSERT INTO `apprenz_options` VALUES("7363", "_transient_geoip_184.164.158.242", "US", "no");
INSERT INTO `apprenz_options` VALUES("7364", "_transient_timeout_geoip_87.238.248.24", "1448259281", "no");
INSERT INTO `apprenz_options` VALUES("7365", "_transient_geoip_87.238.248.24", "DK", "no");
INSERT INTO `apprenz_options` VALUES("7366", "_transient_timeout_geoip_209.160.58.9", "1448259283", "no");
INSERT INTO `apprenz_options` VALUES("7367", "_transient_geoip_209.160.58.9", "US", "no");
INSERT INTO `apprenz_options` VALUES("7368", "_transient_timeout_geoip_167.114.157.131", "1448259343", "no");
INSERT INTO `apprenz_options` VALUES("7369", "_transient_geoip_167.114.157.131", "CA", "no");
INSERT INTO `apprenz_options` VALUES("7371", "_transient_timeout_geoip_2001:41d0:a:4315::", "1448259446", "no");
INSERT INTO `apprenz_options` VALUES("7372", "_transient_geoip_2001:41d0:a:4315::", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7373", "_transient_timeout_geoip_2001:4801:7817:72:be76:4eff:fe10:f152", "1448259845", "no");
INSERT INTO `apprenz_options` VALUES("7374", "_transient_geoip_2001:4801:7817:72:be76:4eff:fe10:f152", "US", "no");
INSERT INTO `apprenz_options` VALUES("7375", "_transient_timeout_geoip_218.161.65.163", "1448260909", "no");
INSERT INTO `apprenz_options` VALUES("7376", "_transient_geoip_218.161.65.163", "TW", "no");
INSERT INTO `apprenz_options` VALUES("7377", "_transient_timeout_geoip_158.199.141.145", "1448261625", "no");
INSERT INTO `apprenz_options` VALUES("7378", "_transient_geoip_158.199.141.145", "JP", "no");
INSERT INTO `apprenz_options` VALUES("7379", "_transient_timeout_geoip_216.97.239.65", "1448261902", "no");
INSERT INTO `apprenz_options` VALUES("7380", "_transient_geoip_216.97.239.65", "US", "no");
INSERT INTO `apprenz_options` VALUES("7382", "_transient_timeout_geoip_2607:f208:501:2a00::10", "1448261914", "no");
INSERT INTO `apprenz_options` VALUES("7383", "_transient_geoip_2607:f208:501:2a00::10", "US", "no");
INSERT INTO `apprenz_options` VALUES("7384", "_transient_timeout_geoip_185.81.155.175", "1448262511", "no");
INSERT INTO `apprenz_options` VALUES("7385", "_transient_geoip_185.81.155.175", "TR", "no");
INSERT INTO `apprenz_options` VALUES("7386", "_transient_timeout_geoip_2001:41d0:a:5595::", "1448262533", "no");
INSERT INTO `apprenz_options` VALUES("7387", "_transient_geoip_2001:41d0:a:5595::", "FR", "no");
INSERT INTO `apprenz_options` VALUES("9316", "_transient_timeout_geoip_199.116.252.177", "1449483266", "no");
INSERT INTO `apprenz_options` VALUES("9317", "_transient_geoip_199.116.252.177", "US", "no");
INSERT INTO `apprenz_options` VALUES("7390", "_transient_timeout_geoip_205.234.184.137", "1448262629", "no");
INSERT INTO `apprenz_options` VALUES("7391", "_transient_geoip_205.234.184.137", "US", "no");
INSERT INTO `apprenz_options` VALUES("7392", "_transient_timeout_geoip_72.9.153.165", "1448262894", "no");
INSERT INTO `apprenz_options` VALUES("7393", "_transient_geoip_72.9.153.165", "US", "no");
INSERT INTO `apprenz_options` VALUES("7394", "_transient_timeout_geoip_92.60.114.204", "1448262955", "no");
INSERT INTO `apprenz_options` VALUES("7395", "_transient_geoip_92.60.114.204", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7397", "_transient_timeout_geoip_50.97.154.166", "1448263014", "no");
INSERT INTO `apprenz_options` VALUES("7398", "_transient_geoip_50.97.154.166", "US", "no");
INSERT INTO `apprenz_options` VALUES("7399", "_transient_timeout_geoip_188.163.109.40", "1448263116", "no");
INSERT INTO `apprenz_options` VALUES("7400", "_transient_geoip_188.163.109.40", "UA", "no");
INSERT INTO `apprenz_options` VALUES("7401", "_transient_timeout_geoip_75.98.175.106", "1448263202", "no");
INSERT INTO `apprenz_options` VALUES("7402", "_transient_geoip_75.98.175.106", "US", "no");
INSERT INTO `apprenz_options` VALUES("7403", "_transient_timeout_geoip_189.113.170.1", "1448263238", "no");
INSERT INTO `apprenz_options` VALUES("7404", "_transient_geoip_189.113.170.1", "BR", "no");
INSERT INTO `apprenz_options` VALUES("7405", "_transient_timeout_geoip_200.63.102.89", "1448263442", "no");
INSERT INTO `apprenz_options` VALUES("7406", "_transient_geoip_200.63.102.89", "CL", "no");
INSERT INTO `apprenz_options` VALUES("7407", "_transient_timeout_geoip_91.221.118.94", "1448263626", "no");
INSERT INTO `apprenz_options` VALUES("7408", "_transient_geoip_91.221.118.94", "CH", "no");
INSERT INTO `apprenz_options` VALUES("7409", "_transient_timeout_geoip_37.188.115.10", "1448264538", "no");
INSERT INTO `apprenz_options` VALUES("7410", "_transient_geoip_37.188.115.10", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7416", "_transient_timeout_geoip_210.172.145.252", "1448264578", "no");
INSERT INTO `apprenz_options` VALUES("7417", "_transient_geoip_210.172.145.252", "JP", "no");
INSERT INTO `apprenz_options` VALUES("7418", "_transient_timeout_geoip_195.142.113.210", "1448264632", "no");
INSERT INTO `apprenz_options` VALUES("7419", "_transient_geoip_195.142.113.210", "TR", "no");
INSERT INTO `apprenz_options` VALUES("7420", "_transient_timeout_geoip_202.174.114.78", "1448265598", "no");
INSERT INTO `apprenz_options` VALUES("7421", "_transient_geoip_202.174.114.78", "NZ", "no");
INSERT INTO `apprenz_options` VALUES("7422", "_transient_timeout_geoip_81.29.212.5", "1448267406", "no");
INSERT INTO `apprenz_options` VALUES("7423", "_transient_geoip_81.29.212.5", "IT", "no");
INSERT INTO `apprenz_options` VALUES("7425", "_transient_timeout_geoip_212.67.219.74", "1448267741", "no");
INSERT INTO `apprenz_options` VALUES("7426", "_transient_geoip_212.67.219.74", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7427", "_transient_timeout_geoip_67.222.103.159", "1448267942", "no");
INSERT INTO `apprenz_options` VALUES("7428", "_transient_geoip_67.222.103.159", "US", "no");
INSERT INTO `apprenz_options` VALUES("7429", "_transient_timeout_geoip_216.97.233.44", "1448267964", "no");
INSERT INTO `apprenz_options` VALUES("7430", "_transient_geoip_216.97.233.44", "US", "no");
INSERT INTO `apprenz_options` VALUES("7431", "_transient_timeout_geoip_192.232.212.233", "1448268005", "no");
INSERT INTO `apprenz_options` VALUES("7432", "_transient_geoip_192.232.212.233", "US", "no");
INSERT INTO `apprenz_options` VALUES("9207", "_transient_timeout_geoip_179.43.162.66", "1449402846", "no");
INSERT INTO `apprenz_options` VALUES("9208", "_transient_geoip_179.43.162.66", "CH", "no");
INSERT INTO `apprenz_options` VALUES("7435", "_transient_timeout_geoip_212.143.212.40", "1448268568", "no");
INSERT INTO `apprenz_options` VALUES("7436", "_transient_geoip_212.143.212.40", "IL", "no");
INSERT INTO `apprenz_options` VALUES("7437", "_transient_timeout_geoip_91.106.199.134", "1448268573", "no");
INSERT INTO `apprenz_options` VALUES("7438", "_transient_geoip_91.106.199.134", "SE", "no");
INSERT INTO `apprenz_options` VALUES("7439", "_transient_timeout_geoip_213.128.74.234", "1448268595", "no");
INSERT INTO `apprenz_options` VALUES("7440", "_transient_geoip_213.128.74.234", "TR", "no");
INSERT INTO `apprenz_options` VALUES("7441", "_transient_timeout_geoip_172.245.213.190", "1448269011", "no");
INSERT INTO `apprenz_options` VALUES("7442", "_transient_geoip_172.245.213.190", "US", "no");
INSERT INTO `apprenz_options` VALUES("7443", "_transient_timeout_geoip_157.55.39.191", "1448269124", "no");
INSERT INTO `apprenz_options` VALUES("7444", "_transient_geoip_157.55.39.191", "US", "no");
INSERT INTO `apprenz_options` VALUES("7445", "_transient_timeout_geoip_108.174.147.157", "1448269838", "no");
INSERT INTO `apprenz_options` VALUES("7446", "_transient_geoip_108.174.147.157", "US", "no");
INSERT INTO `apprenz_options` VALUES("7447", "_transient_timeout_geoip_203.82.55.22", "1448270273", "no");
INSERT INTO `apprenz_options` VALUES("7448", "_transient_geoip_203.82.55.22", "PK", "no");
INSERT INTO `apprenz_options` VALUES("7449", "_transient_timeout_geoip_189.38.80.233", "1448270288", "no");
INSERT INTO `apprenz_options` VALUES("7450", "_transient_geoip_189.38.80.233", "BR", "no");
INSERT INTO `apprenz_options` VALUES("7451", "_transient_timeout_geoip_217.160.90.42", "1448270329", "no");
INSERT INTO `apprenz_options` VALUES("7452", "_transient_geoip_217.160.90.42", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7453", "_transient_timeout_geoip_178.32.231.56", "1448270605", "no");
INSERT INTO `apprenz_options` VALUES("7454", "_transient_geoip_178.32.231.56", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7455", "_transient_timeout_geoip_2001:41d0:a:5691::", "1448271708", "no");
INSERT INTO `apprenz_options` VALUES("7456", "_transient_geoip_2001:41d0:a:5691::", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7458", "_transient_timeout_geoip_69.162.72.179", "1448271758", "no");
INSERT INTO `apprenz_options` VALUES("7459", "_transient_geoip_69.162.72.179", "US", "no");
INSERT INTO `apprenz_options` VALUES("7460", "_transient_timeout_geoip_2a01:4f8:211:39f::2", "1448271786", "no");
INSERT INTO `apprenz_options` VALUES("7461", "_transient_geoip_2a01:4f8:211:39f::2", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7462", "_transient_timeout_geoip_74.115.231.42", "1448271786", "no");
INSERT INTO `apprenz_options` VALUES("7463", "_transient_geoip_74.115.231.42", "US", "no");
INSERT INTO `apprenz_options` VALUES("7464", "_transient_timeout_geoip_195.244.34.137", "1448271949", "no");
INSERT INTO `apprenz_options` VALUES("7465", "_transient_geoip_195.244.34.137", "TR", "no");
INSERT INTO `apprenz_options` VALUES("7466", "_transient_timeout_geoip_2001:1680:101:9::2", "1448272282", "no");
INSERT INTO `apprenz_options` VALUES("7467", "_transient_geoip_2001:1680:101:9::2", "CH", "no");
INSERT INTO `apprenz_options` VALUES("7468", "_transient_timeout_geoip_213.108.106.219", "1448272303", "no");
INSERT INTO `apprenz_options` VALUES("7469", "_transient_geoip_213.108.106.219", "NL", "no");
INSERT INTO `apprenz_options` VALUES("7470", "_transient_timeout_geoip_199.167.128.194", "1448272492", "no");
INSERT INTO `apprenz_options` VALUES("7471", "_transient_geoip_199.167.128.194", "CA", "no");
INSERT INTO `apprenz_options` VALUES("7472", "_transient_timeout_geoip_119.82.226.23", "1448273791", "no");
INSERT INTO `apprenz_options` VALUES("7473", "_transient_geoip_119.82.226.23", "ID", "no");
INSERT INTO `apprenz_options` VALUES("7474", "_transient_timeout_geoip_205.186.142.225", "1448273970", "no");
INSERT INTO `apprenz_options` VALUES("7475", "_transient_geoip_205.186.142.225", "US", "no");
INSERT INTO `apprenz_options` VALUES("7476", "_transient_timeout_geoip_2001:41d0:52:a00::1323", "1448273974", "no");
INSERT INTO `apprenz_options` VALUES("7477", "_transient_geoip_2001:41d0:52:a00::1323", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7478", "_transient_timeout_geoip_24.21.211.222", "1448274273", "no");
INSERT INTO `apprenz_options` VALUES("7479", "_transient_geoip_24.21.211.222", "US", "no");
INSERT INTO `apprenz_options` VALUES("7480", "_transient_timeout_geoip_200.225.192.145", "1448274318", "no");
INSERT INTO `apprenz_options` VALUES("7481", "_transient_geoip_200.225.192.145", "BR", "no");
INSERT INTO `apprenz_options` VALUES("7482", "_transient_timeout_geoip_149.154.154.33", "1448274591", "no");
INSERT INTO `apprenz_options` VALUES("7483", "_transient_geoip_149.154.154.33", "AT", "no");
INSERT INTO `apprenz_options` VALUES("7484", "_transient_timeout_geoip_2001:41d0:52:a00::7c6", "1448275341", "no");
INSERT INTO `apprenz_options` VALUES("7485", "_transient_geoip_2001:41d0:52:a00::7c6", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7487", "_transient_timeout_geoip_2a00:f10:114:12::248", "1448276098", "no");
INSERT INTO `apprenz_options` VALUES("7488", "_transient_geoip_2a00:f10:114:12::248", "NL", "no");
INSERT INTO `apprenz_options` VALUES("7489", "_transient_timeout_geoip_46.249.35.148", "1448276417", "no");
INSERT INTO `apprenz_options` VALUES("7490", "_transient_geoip_46.249.35.148", "NL", "no");
INSERT INTO `apprenz_options` VALUES("7491", "_transient_timeout_geoip_213.192.241.32", "1448276458", "no");
INSERT INTO `apprenz_options` VALUES("7492", "_transient_geoip_213.192.241.32", "ES", "no");
INSERT INTO `apprenz_options` VALUES("7493", "_transient_timeout_geoip_166.62.35.1", "1448276461", "no");
INSERT INTO `apprenz_options` VALUES("7494", "_transient_geoip_166.62.35.1", "US", "no");
INSERT INTO `apprenz_options` VALUES("7495", "_transient_timeout_geoip_208.187.16.130", "1448276545", "no");
INSERT INTO `apprenz_options` VALUES("7496", "_transient_geoip_208.187.16.130", "US", "no");
INSERT INTO `apprenz_options` VALUES("7497", "_transient_timeout_geoip_184.70.129.182", "1448276587", "no");
INSERT INTO `apprenz_options` VALUES("7498", "_transient_geoip_184.70.129.182", "CA", "no");
INSERT INTO `apprenz_options` VALUES("7499", "_transient_timeout_geoip_52.8.121.98", "1448276731", "no");
INSERT INTO `apprenz_options` VALUES("7500", "_transient_geoip_52.8.121.98", "US", "no");
INSERT INTO `apprenz_options` VALUES("7501", "_transient_timeout_geoip_97.74.4.182", "1448276802", "no");
INSERT INTO `apprenz_options` VALUES("7502", "_transient_geoip_97.74.4.182", "US", "no");
INSERT INTO `apprenz_options` VALUES("7503", "_transient_timeout_geoip_64.64.26.34", "1448276866", "no");
INSERT INTO `apprenz_options` VALUES("7504", "_transient_geoip_64.64.26.34", "US", "no");
INSERT INTO `apprenz_options` VALUES("7505", "_transient_timeout_geoip_69.175.105.170", "1448276903", "no");
INSERT INTO `apprenz_options` VALUES("7506", "_transient_geoip_69.175.105.170", "US", "no");
INSERT INTO `apprenz_options` VALUES("7507", "_transient_timeout_geoip_125.253.124.92", "1448276987", "no");
INSERT INTO `apprenz_options` VALUES("7508", "_transient_geoip_125.253.124.92", "VN", "no");
INSERT INTO `apprenz_options` VALUES("7509", "_transient_timeout_geoip_68.181.153.24", "1448277047", "no");
INSERT INTO `apprenz_options` VALUES("7510", "_transient_geoip_68.181.153.24", "US", "no");
INSERT INTO `apprenz_options` VALUES("7511", "_transient_timeout_geoip_2607:fb50:1800:0:230:48ff:fedb:b316", "1448277104", "no");
INSERT INTO `apprenz_options` VALUES("7512", "_transient_geoip_2607:fb50:1800:0:230:48ff:fedb:b316", "US", "no");
INSERT INTO `apprenz_options` VALUES("7513", "_transient_timeout_geoip_67.210.119.150", "1448277255", "no");
INSERT INTO `apprenz_options` VALUES("7514", "_transient_geoip_67.210.119.150", "US", "no");
INSERT INTO `apprenz_options` VALUES("7515", "_transient_timeout_geoip_198.23.143.231", "1448277628", "no");
INSERT INTO `apprenz_options` VALUES("7516", "_transient_geoip_198.23.143.231", "US", "no");
INSERT INTO `apprenz_options` VALUES("7517", "_transient_timeout_geoip_219.84.97.20", "1448277783", "no");
INSERT INTO `apprenz_options` VALUES("7518", "_transient_geoip_219.84.97.20", "TW", "no");
INSERT INTO `apprenz_options` VALUES("7519", "_transient_timeout_geoip_91.121.55.115", "1448278544", "no");
INSERT INTO `apprenz_options` VALUES("7520", "_transient_geoip_91.121.55.115", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7521", "_transient_timeout_geoip_2001:e42:102:1535:160:16:118:163", "1448279086", "no");
INSERT INTO `apprenz_options` VALUES("7522", "_transient_geoip_2001:e42:102:1535:160:16:118:163", "JP", "no");
INSERT INTO `apprenz_options` VALUES("7524", "_transient_timeout_geoip_173.199.137.144", "1448279777", "no");
INSERT INTO `apprenz_options` VALUES("7525", "_transient_geoip_173.199.137.144", "US", "no");
INSERT INTO `apprenz_options` VALUES("7526", "_transient_timeout_geoip_62.210.142.61", "1448280185", "no");
INSERT INTO `apprenz_options` VALUES("7527", "_transient_geoip_62.210.142.61", "FR", "no");
INSERT INTO `apprenz_options` VALUES("8802", "_transient_timeout_geoip_2607:5500:2000:2c::75a6", "1449075813", "no");
INSERT INTO `apprenz_options` VALUES("8803", "_transient_geoip_2607:5500:2000:2c::75a6", "US", "no");
INSERT INTO `apprenz_options` VALUES("7530", "_transient_timeout_geoip_103.43.94.55", "1448280789", "no");
INSERT INTO `apprenz_options` VALUES("7531", "_transient_geoip_103.43.94.55", "IN", "no");
INSERT INTO `apprenz_options` VALUES("7532", "_transient_timeout_geoip_209.236.112.86", "1448280800", "no");
INSERT INTO `apprenz_options` VALUES("7533", "_transient_geoip_209.236.112.86", "US", "no");
INSERT INTO `apprenz_options` VALUES("7534", "_transient_timeout_geoip_199.115.125.10", "1448281307", "no");
INSERT INTO `apprenz_options` VALUES("7535", "_transient_geoip_199.115.125.10", "CA", "no");
INSERT INTO `apprenz_options` VALUES("7536", "_transient_timeout_geoip_209.200.250.80", "1448281318", "no");
INSERT INTO `apprenz_options` VALUES("7537", "_transient_geoip_209.200.250.80", "US", "no");
INSERT INTO `apprenz_options` VALUES("7538", "_transient_timeout_geoip_73.141.47.215", "1448281321", "no");
INSERT INTO `apprenz_options` VALUES("7539", "_transient_geoip_73.141.47.215", "US", "no");
INSERT INTO `apprenz_options` VALUES("7540", "_transient_timeout_geoip_2400:f100:2:0:ca0a:a9ff:fef1:3bfc", "1448281754", "no");
INSERT INTO `apprenz_options` VALUES("7541", "_transient_geoip_2400:f100:2:0:ca0a:a9ff:fef1:3bfc", "HK", "no");
INSERT INTO `apprenz_options` VALUES("7542", "_transient_timeout_geoip_174.122.24.210", "1448281805", "no");
INSERT INTO `apprenz_options` VALUES("7543", "_transient_geoip_174.122.24.210", "US", "no");
INSERT INTO `apprenz_options` VALUES("7544", "_transient_timeout_geoip_136.243.18.223", "1448281812", "no");
INSERT INTO `apprenz_options` VALUES("7545", "_transient_geoip_136.243.18.223", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7546", "_transient_timeout_geoip_59.106.183.176", "1448281845", "no");
INSERT INTO `apprenz_options` VALUES("7547", "_transient_geoip_59.106.183.176", "JP", "no");
INSERT INTO `apprenz_options` VALUES("7548", "_transient_timeout_geoip_104.238.126.122", "1448282126", "no");
INSERT INTO `apprenz_options` VALUES("7549", "_transient_geoip_104.238.126.122", "US", "no");
INSERT INTO `apprenz_options` VALUES("7550", "_transient_timeout_geoip_198.1.72.88", "1448282256", "no");
INSERT INTO `apprenz_options` VALUES("7551", "_transient_geoip_198.1.72.88", "US", "no");
INSERT INTO `apprenz_options` VALUES("7552", "_transient_timeout_geoip_198.20.231.157", "1448282695", "no");
INSERT INTO `apprenz_options` VALUES("7553", "_transient_geoip_198.20.231.157", "US", "no");
INSERT INTO `apprenz_options` VALUES("7555", "_transient_timeout_geoip_46.17.63.246", "1448283350", "no");
INSERT INTO `apprenz_options` VALUES("7556", "_transient_geoip_46.17.63.246", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7557", "_transient_timeout_geoip_176.74.192.217", "1448283824", "no");
INSERT INTO `apprenz_options` VALUES("7558", "_transient_geoip_176.74.192.217", "SE", "no");
INSERT INTO `apprenz_options` VALUES("7559", "_transient_timeout_geoip_216.113.193.55", "1448284126", "no");
INSERT INTO `apprenz_options` VALUES("7560", "_transient_geoip_216.113.193.55", "CA", "no");
INSERT INTO `apprenz_options` VALUES("7561", "_transient_timeout_geoip_41.72.154.153", "1448284180", "no");
INSERT INTO `apprenz_options` VALUES("7562", "_transient_geoip_41.72.154.153", "ZA", "no");
INSERT INTO `apprenz_options` VALUES("7563", "_transient_timeout_geoip_128.69.168.182", "1448284643", "no");
INSERT INTO `apprenz_options` VALUES("7564", "_transient_geoip_128.69.168.182", "RU", "no");
INSERT INTO `apprenz_options` VALUES("7565", "_transient_timeout_geoip_95.172.239.20", "1448285019", "no");
INSERT INTO `apprenz_options` VALUES("7566", "_transient_geoip_95.172.239.20", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7567", "_transient_timeout_geoip_69.50.210.69", "1448285254", "no");
INSERT INTO `apprenz_options` VALUES("7568", "_transient_geoip_69.50.210.69", "US", "no");
INSERT INTO `apprenz_options` VALUES("7569", "_transient_timeout_geoip_213.80.101.97", "1448285585", "no");
INSERT INTO `apprenz_options` VALUES("7570", "_transient_geoip_213.80.101.97", "SE", "no");
INSERT INTO `apprenz_options` VALUES("7571", "_transient_timeout_geoip_2405:5000:2:ffb:250:56ff:fe9a:194", "1448285826", "no");
INSERT INTO `apprenz_options` VALUES("7572", "_transient_geoip_2405:5000:2:ffb:250:56ff:fe9a:194", "AU", "no");
INSERT INTO `apprenz_options` VALUES("7573", "_transient_timeout_geoip_192.217.124.224", "1448285890", "no");
INSERT INTO `apprenz_options` VALUES("7574", "_transient_geoip_192.217.124.224", "US", "no");
INSERT INTO `apprenz_options` VALUES("7575", "_transient_timeout_geoip_67.210.126.40", "1448285935", "no");
INSERT INTO `apprenz_options` VALUES("7576", "_transient_geoip_67.210.126.40", "US", "no");
INSERT INTO `apprenz_options` VALUES("7577", "_transient_timeout_geoip_2607:5300:60:46dc::", "1448286006", "no");
INSERT INTO `apprenz_options` VALUES("7578", "_transient_geoip_2607:5300:60:46dc::", "CA", "no");
INSERT INTO `apprenz_options` VALUES("7579", "_transient_timeout_geoip_82.152.48.169", "1448286009", "no");
INSERT INTO `apprenz_options` VALUES("7580", "_transient_geoip_82.152.48.169", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7581", "_transient_timeout_geoip_176.9.73.16", "1448286080", "no");
INSERT INTO `apprenz_options` VALUES("7582", "_transient_geoip_176.9.73.16", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7583", "_transient_timeout_geoip_104.238.97.158", "1448286141", "no");
INSERT INTO `apprenz_options` VALUES("7584", "_transient_geoip_104.238.97.158", "US", "no");
INSERT INTO `apprenz_options` VALUES("7585", "_transient_timeout_geoip_85.92.82.172", "1448286395", "no");
INSERT INTO `apprenz_options` VALUES("7586", "_transient_geoip_85.92.82.172", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7588", "_transient_timeout_geoip_103.23.20.229", "1448286505", "no");
INSERT INTO `apprenz_options` VALUES("7589", "_transient_geoip_103.23.20.229", "ID", "no");
INSERT INTO `apprenz_options` VALUES("8791", "_transient_timeout_geoip_199.19.214.198", "1449069188", "no");
INSERT INTO `apprenz_options` VALUES("8792", "_transient_geoip_199.19.214.198", "CA", "no");
INSERT INTO `apprenz_options` VALUES("7592", "_transient_timeout_geoip_2607:5300:60:5778::", "1448286916", "no");
INSERT INTO `apprenz_options` VALUES("7593", "_transient_geoip_2607:5300:60:5778::", "CA", "no");
INSERT INTO `apprenz_options` VALUES("7594", "_transient_timeout_geoip_87.118.66.4", "1448286930", "no");
INSERT INTO `apprenz_options` VALUES("7595", "_transient_geoip_87.118.66.4", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7596", "_transient_timeout_geoip_103.15.232.24", "1448288638", "no");
INSERT INTO `apprenz_options` VALUES("7597", "_transient_geoip_103.15.232.24", "SG", "no");
INSERT INTO `apprenz_options` VALUES("8658", "_transient_timeout_geoip_37.221.142.42", "1448988692", "no");
INSERT INTO `apprenz_options` VALUES("8659", "_transient_geoip_37.221.142.42", "UA", "no");
INSERT INTO `apprenz_options` VALUES("7600", "_transient_timeout_geoip_2401:1800:7800:102:be76:4eff:fe1c:1686", "1448288931", "no");
INSERT INTO `apprenz_options` VALUES("7601", "_transient_geoip_2401:1800:7800:102:be76:4eff:fe1c:1686", "HK", "no");
INSERT INTO `apprenz_options` VALUES("7602", "_transient_timeout_geoip_122.129.219.242", "1448289192", "no");
INSERT INTO `apprenz_options` VALUES("7603", "_transient_geoip_122.129.219.242", "AU", "no");
INSERT INTO `apprenz_options` VALUES("7604", "_transient_timeout_geoip_69.64.55.100", "1448289595", "no");
INSERT INTO `apprenz_options` VALUES("7605", "_transient_geoip_69.64.55.100", "US", "no");
INSERT INTO `apprenz_options` VALUES("7606", "_transient_timeout_geoip_209.164.17.210", "1448289824", "no");
INSERT INTO `apprenz_options` VALUES("7607", "_transient_geoip_209.164.17.210", "US", "no");
INSERT INTO `apprenz_options` VALUES("7608", "_transient_timeout_geoip_46.16.63.9", "1448289873", "no");
INSERT INTO `apprenz_options` VALUES("108", "dashboard_widget_options", "a:4:{s:25:\"dashboard_recent_comments\";a:1:{s:5:\"items\";i:5;}s:24:\"dashboard_incoming_links\";a:5:{s:4:\"home\";s:18:\"http://apprenz.com\";s:4:\"link\";s:94:\"http://blogsearch.google.com/blogsearch?scoring=d&partner=wordpress&q=link:http://apprenz.com/\";s:3:\"url\";s:127:\"http://blogsearch.google.com/blogsearch_feeds?scoring=d&ie=utf-8&num=10&output=rss&partner=wordpress&q=link:http://apprenz.com/\";s:5:\"items\";i:10;s:9:\"show_date\";b:0;}s:17:\"dashboard_primary\";a:7:{s:4:\"link\";s:26:\"http://wordpress.org/news/\";s:3:\"url\";s:31:\"http://wordpress.org/news/feed/\";s:5:\"title\";s:14:\"WordPress Blog\";s:5:\"items\";i:2;s:12:\"show_summary\";i:1;s:11:\"show_author\";i:0;s:9:\"show_date\";i:1;}s:19:\"dashboard_secondary\";a:7:{s:4:\"link\";s:28:\"http://planet.wordpress.org/\";s:3:\"url\";s:33:\"http://planet.wordpress.org/feed/\";s:5:\"title\";s:20:\"Other WordPress News\";s:5:\"items\";i:5;s:12:\"show_summary\";i:0;s:11:\"show_author\";i:0;s:9:\"show_date\";i:0;}}", "yes");
INSERT INTO `apprenz_options` VALUES("5978", "_site_transient_timeout_browser_71e9d81c5317fe08cbeebb649a300dff", "1447864186", "yes");
INSERT INTO `apprenz_options` VALUES("3134", "theme_mods_onetone", "a:6:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:9:\"home_menu\";i:2;s:7:\"primary\";i:2;}s:16:\"background_image\";s:0:\"\";s:22:\"background_image_thumb\";s:0:\"\";s:16:\"background_color\";s:6:\"4186e0\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1415481034;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:18:\"orphaned_widgets_1\";a:1:{i:0;s:6:\"text-2\";}}}}", "yes");
INSERT INTO `apprenz_options` VALUES("6207", "_transient_timeout_GOTMLS_mt=75cef277538da7be8b7ef1c99d39a286", "1447610817", "no");
INSERT INTO `apprenz_options` VALUES("6208", "_transient_GOTMLS_mt=75cef277538da7be8b7ef1c99d39a286", "1447524416.9337", "no");
INSERT INTO `apprenz_options` VALUES("6199", "_transient_timeout_GOTMLS_mt=cc3d89905f7da285231b56632c8cc513", "1447610805", "no");
INSERT INTO `apprenz_options` VALUES("6200", "_transient_GOTMLS_mt=cc3d89905f7da285231b56632c8cc513", "1447524404.2232", "no");
INSERT INTO `apprenz_options` VALUES("48696", "_transient_timeout_wpseo_sitemap_cache_1_1", "1567765215", "no");
INSERT INTO `apprenz_options` VALUES("48697", "_transient_wpseo_sitemap_cache_1_1", "<sitemapindex xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n<sitemap>\n<loc>http://apprenz.com/post-sitemap.xml</loc>\n<lastmod>2014-09-01T08:43:03+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://apprenz.com/page-sitemap.xml</loc>\n<lastmod>2018-10-01T11:14:35+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://apprenz.com/tribe_events-sitemap.xml</loc>\n<lastmod>2015-04-30T10:22:18+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://apprenz.com/category-sitemap.xml</loc>\n<lastmod>2014-09-01T08:43:03+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://apprenz.com/post_tag-sitemap.xml</loc>\n<lastmod>2015-04-30T10:22:18+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://apprenz.com/tribe_events_cat-sitemap.xml</loc>\n<lastmod>2015-04-30T10:22:18+00:00</lastmod>\n</sitemap>\n</sitemapindex>", "no");
INSERT INTO `apprenz_options` VALUES("40205", "_transient_external_ip_address_193.169.252.184", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("28523", "_transient_timeout_external_ip_address_160.226.226.94", "1499532652", "no");
INSERT INTO `apprenz_options` VALUES("28524", "_transient_external_ip_address_160.226.226.94", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("13860", "_transient_timeout_external_ip_address_10.3.27.214", "1461665436", "no");
INSERT INTO `apprenz_options` VALUES("13861", "_transient_external_ip_address_10.3.27.214", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("13863", "_transient_timeout_external_ip_address_10.3.143.165", "1461674037", "no");
INSERT INTO `apprenz_options` VALUES("13864", "_transient_external_ip_address_10.3.143.165", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("48609", "_transient_timeout_wpseo_sitemap_cache_tribe_events_cat_1", "1567425681", "no");
INSERT INTO `apprenz_options` VALUES("48610", "_transient_wpseo_sitemap_cache_tribe_events_cat_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>https://apprenz.com/events/category/marketing/</loc>\n		<lastmod>2015-04-30T10:22:18+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/events/category/seo/</loc>\n		<lastmod>2015-04-30T10:15:17+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `apprenz_options` VALUES("48601", "_transient_timeout_wpseo_sitemap_cache_page_1", "1567425674", "no");
INSERT INTO `apprenz_options` VALUES("48602", "_transient_wpseo_sitemap_cache_page_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>https://apprenz.com/cart/</loc>\n		<lastmod>2014-07-11T12:17:33+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/checkout/</loc>\n		<lastmod>2014-07-11T12:17:33+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/my-account/</loc>\n		<lastmod>2014-07-11T12:17:33+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/about-us/</loc>\n		<lastmod>2014-07-11T13:10:47+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/blog-streampage/</loc>\n		<lastmod>2014-08-22T09:29:21+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/typography/</loc>\n		<lastmod>2014-08-25T11:40:16+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/portfolio-hover-styles-circle/</loc>\n		<lastmod>2014-08-29T13:51:50+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/portfolio-hover-styles-square/</loc>\n		<lastmod>2014-08-29T14:03:06+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/faq/</loc>\n		<lastmod>2014-09-01T09:21:03+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/pricing-tables/</loc>\n		<lastmod>2014-09-01T09:27:27+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/page-404/</loc>\n		<lastmod>2014-09-01T09:34:27+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/search-results/</loc>\n		<lastmod>2014-09-01T09:40:31+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/under-constraction/</loc>\n		<lastmod>2014-09-01T09:54:56+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/posts-slider/</loc>\n		<lastmod>2014-09-01T10:52:14+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/posts-slider-fullscreen/</loc>\n		<lastmod>2014-09-01T11:07:44+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/tribe-events-template/</loc>\n		<lastmod>2014-09-25T08:02:34+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/contact/</loc>\n		<lastmod>2018-10-01T11:14:35+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/donation/</loc>\n		<lastmod>2014-10-13T08:04:18+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/</loc>\n		<lastmod>2015-11-15T02:38:58+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>1</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/pricing/</loc>\n		<lastmod>2015-01-14T09:41:21+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/tools/</loc>\n		<lastmod>2015-01-14T09:41:21+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/homepage-seo2/</loc>\n		<lastmod>2015-05-18T08:29:58+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://apprenz.com/shop/</loc>\n		<lastmod>2015-11-14T18:56:06+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `apprenz_options` VALUES("48658", "_transient_timeout_wpseo_sitemap_cache_post_tag_1", "1567655851", "no");
INSERT INTO `apprenz_options` VALUES("48659", "_transient_wpseo_sitemap_cache_post_tag_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://apprenz.com/tag/adwords/</loc>\n		<lastmod>2014-08-29T11:04:26+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/aside-post/</loc>\n		<lastmod>2014-07-12T08:26:37+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/audio-post/</loc>\n		<lastmod>2014-07-19T07:42:35+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/business-2/</loc>\n		<lastmod>2015-04-30T10:15:17+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.4</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/chat-post/</loc>\n		<lastmod>2014-07-11T08:28:15+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/conversion/</loc>\n		<lastmod>2014-08-29T11:13:23+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.4</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/creative/</loc>\n		<lastmod>2014-08-29T11:15:07+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.4</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/design/</loc>\n		<lastmod>2014-08-29T11:15:07+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/events/</loc>\n		<lastmod>2015-04-30T10:15:17+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/keywords/</loc>\n		<lastmod>2014-08-29T11:04:26+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/link-post/</loc>\n		<lastmod>2014-07-14T08:15:51+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/marketing/</loc>\n		<lastmod>2014-09-25T11:07:16+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/post-formats-2/</loc>\n		<lastmod>2014-07-20T07:40:10+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.4</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/posts-slider-2/</loc>\n		<lastmod>2014-05-01T10:56:07+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/print/</loc>\n		<lastmod>2014-08-29T10:58:36+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/quote-post/</loc>\n		<lastmod>2014-07-15T08:12:43+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/seo/</loc>\n		<lastmod>2014-08-29T11:07:10+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/shortcodes-2/</loc>\n		<lastmod>2014-06-25T11:33:17+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/status-post/</loc>\n		<lastmod>2014-07-13T08:14:49+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/typography/</loc>\n		<lastmod>2014-08-29T10:58:36+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/video-post/</loc>\n		<lastmod>2014-07-20T07:40:10+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tag/wp-gallery/</loc>\n		<lastmod>2014-07-18T07:46:25+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `apprenz_options` VALUES("48682", "_transient_timeout_feed_e9203ae66c43bb23cbb925831ef2893e", "1567681883", "no");
INSERT INTO `apprenz_options` VALUES("48683", "_transient_feed_e9203ae66c43bb23cbb925831ef2893e", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:2:\"\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:28:\"\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Reuters: Wealth\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://www.reuters.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:294:\"Reuters.com is your source for breaking news, business, financial and investing news, including personal finance and stocks.  Reuters is the leading global provider of news, financial information and technology solutions to the world\'s media, financial institutions, businesses and individuals.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Reuters News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"120\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"35\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://www.reuters.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://www.reuters.com/resources_v2/images/reuters125.png\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-us\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Sep 2019 18:56:26 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"copyright\";a:1:{i:0;a:5:{s:4:\"data\";s:444:\"All rights reserved. Users may download and print extracts of content from this website for their own personal and non-commercial use only. Republication or redistribution of Reuters content, including by framing or similar means, is expressly prohibited without the prior written consent of Reuters. Reuters and the Reuters sphere logo are registered trademarks or trademarks of the Reuters group of companies around the world. © Reuters 2019\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:20:{i:0;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"Activist investor Driver Management presses anew for First United Bank to sell itself\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:154:\"http://feeds.reuters.com/~r/news/wealth/~3/tq0c6jgFgBI/activist-investor-driver-management-presses-anew-for-first-united-bank-to-sell-itself-idUSKCN1VP31Q\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:202:\"https://www.reuters.com/article/us-first-united-drivermanagement/activist-investor-driver-management-presses-anew-for-first-united-bank-to-sell-itself-idUSKCN1VP31Q?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Sep 2019 18:36:25 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:504:\"Driver Management Company LLC, an activist investor focused on U.S. banks, renewed calls on Wednesday for First United Corp , the holding company for Maryland community bank First United Bank &...<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=tq0c6jgFgBI:VDnchujl_vw:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/tq0c6jgFgBI\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:202:\"https://www.reuters.com/article/us-first-united-drivermanagement/activist-investor-driver-management-presses-anew-for-first-united-bank-to-sell-itself-idUSKCN1VP31Q?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"VanEck SolidX bitcoin trust to sell shares to institutional buyers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:135:\"http://feeds.reuters.com/~r/news/wealth/~3/R700XPsdBkA/vaneck-solidx-bitcoin-trust-to-sell-shares-to-institutional-buyers-idUSKCN1VO2HT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:175:\"https://www.reuters.com/article/us-crypto-currencies-etf/vaneck-solidx-bitcoin-trust-to-sell-shares-to-institutional-buyers-idUSKCN1VO2HT?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Sep 2019 17:55:38 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:506:\"Investment firm VanEck and financial technology company SolidX Management LLC will sell shares in their bitcoin trust to \"qualified institutional buyers,\" the companies said on Tuesday, in a move...<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=R700XPsdBkA:_H6bo_TmMhA:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/R700XPsdBkA\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:175:\"https://www.reuters.com/article/us-crypto-currencies-etf/vaneck-solidx-bitcoin-trust-to-sell-shares-to-institutional-buyers-idUSKCN1VO2HT?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"Catastrophes set to drive 2020 reinsurance rates higher\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"http://feeds.reuters.com/~r/news/wealth/~3/SG6PePyYCD4/catastrophes-set-to-drive-2020-reinsurance-rates-higher-idUSKCN1VO19B\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:165:\"https://www.reuters.com/article/us-reinsurance-prices-s-p/catastrophes-set-to-drive-2020-reinsurance-rates-higher-idUSKCN1VO19B?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Sep 2019 10:01:02 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:491:\"Big insurance losses from hurricanes, wildfires and other natural disasters over the past two years are set to push reinsurance renewal rates higher in January, ratings agencies said.<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=SG6PePyYCD4:f6VxJdlwYAc:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/SG6PePyYCD4\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:165:\"https://www.reuters.com/article/us-reinsurance-prices-s-p/catastrophes-set-to-drive-2020-reinsurance-rates-higher-idUSKCN1VO19B?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"Swiss bank Pictet boosts assets under management, first half profit slips\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:141:\"http://feeds.reuters.com/~r/news/wealth/~3/mBLQbMPWK_U/swiss-bank-pictet-boosts-assets-under-management-first-half-profit-slips-idUSKCN1VO08G\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:174:\"https://www.reuters.com/article/us-pictet-results/swiss-bank-pictet-boosts-assets-under-management-first-half-profit-slips-idUSKCN1VO08G?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Sep 2019 23:28:07 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:472:\"Group assets under custody or management at Swiss private bank and asset manager Pictet rose nearly 10% in the first half versus the end of 2018, it said on Monday.<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=mBLQbMPWK_U:3JSZHYWQrH4:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/mBLQbMPWK_U\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:174:\"https://www.reuters.com/article/us-pictet-results/swiss-bank-pictet-boosts-assets-under-management-first-half-profit-slips-idUSKCN1VO08G?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"Hedge fund-backed reinsurance duo poised for performance uptick: Barron&#039;s\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:140:\"http://feeds.reuters.com/~r/news/wealth/~3/j-RBLQGHqzw/hedge-fund-backed-reinsurance-duo-poised-for-performance-uptick-barrons-idUSKCN1VM1NG\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:179:\"https://www.reuters.com/article/us-greenlight-re-stocks/hedge-fund-backed-reinsurance-duo-poised-for-performance-uptick-barrons-idUSKCN1VM1NG?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 01 Sep 2019 18:16:18 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:505:\"Two reinsurance firms backed by prominent hedge funds are considered good investments as their share price performance has yet to benefit from the sector\'s improved pricing outlook, according to...<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=j-RBLQGHqzw:8FfEg6zK9_I:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/j-RBLQGHqzw\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:179:\"https://www.reuters.com/article/us-greenlight-re-stocks/hedge-fund-backed-reinsurance-duo-poised-for-performance-uptick-barrons-idUSKCN1VM1NG?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"Activist Jana to push again for changes at Outback owner Bloomin&#039; Brands\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:140:\"http://feeds.reuters.com/~r/news/wealth/~3/CXY81gxgxWw/activist-jana-to-push-again-for-changes-at-outback-owner-bloomin-brands-idUSKCN1VK2F1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:172:\"https://www.reuters.com/article/us-blmn-brd-jana/activist-jana-to-push-again-for-changes-at-outback-owner-bloomin-brands-idUSKCN1VK2F1?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Aug 2019 16:15:35 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:508:\"Activist hedge fund Jana Partners on Friday disclosed a large new stake in Outback Steakhouse owner Bloomin\' Brands Inc , returning for the second time in nearly two years to push for fresh changes...<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=CXY81gxgxWw:Srb3d3VmgJI:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/CXY81gxgxWw\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:172:\"https://www.reuters.com/article/us-blmn-brd-jana/activist-jana-to-push-again-for-changes-at-outback-owner-bloomin-brands-idUSKCN1VK2F1?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"BAML: Buy risky assets as sentiment gets extremely bearish\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"http://feeds.reuters.com/~r/news/wealth/~3/M4xahF9DUdU/baml-buy-risky-assets-as-sentiment-gets-extremely-bearish-idUSKCN1VK171\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:162:\"https://www.reuters.com/article/us-market-funds-baml/baml-buy-risky-assets-as-sentiment-gets-extremely-bearish-idUSKCN1VK171?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Aug 2019 06:39:56 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:504:\"Bank of America Merrill Lynch said on Friday its market sentiment indicator has fallen to a level so bearish it has triggered a \"contrarian\" buy signal for assets considered more risky, such as...<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=M4xahF9DUdU:aU-FXdyylrE:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/M4xahF9DUdU\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:162:\"https://www.reuters.com/article/us-market-funds-baml/baml-buy-risky-assets-as-sentiment-gets-extremely-bearish-idUSKCN1VK171?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"U.S. charges reverse mortgage lender Live Well&#039;s ex-CEO in $140 million fraud\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:143:\"http://feeds.reuters.com/~r/news/wealth/~3/GTb36Nub_ls/u-s-charges-reverse-mortgage-lender-live-wells-ex-ceo-in-140-million-fraud-idUSKCN1VJ2DI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:181:\"https://www.reuters.com/article/us-usa-crime-live-well/u-s-charges-reverse-mortgage-lender-live-wells-ex-ceo-in-140-million-fraud-idUSKCN1VJ2DI?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Aug 2019 22:09:29 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:510:\"The U.S. government on Thursday charged the founder of reverse mortgage provider Live Well Financial Inc with engineering a $140 million fraud by inflating the value of its bonds, in what he called a...<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=GTb36Nub_ls:XhHO2Se1Bp8:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/GTb36Nub_ls\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:181:\"https://www.reuters.com/article/us-usa-crime-live-well/u-s-charges-reverse-mortgage-lender-live-wells-ex-ceo-in-140-million-fraud-idUSKCN1VJ2DI?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"UBS hires former Credit Suisse star Khan as part of broader shakeup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:136:\"http://feeds.reuters.com/~r/news/wealth/~3/_mUVRBF05Sk/ubs-hires-former-credit-suisse-star-khan-as-part-of-broader-shakeup-idUSKCN1VJ0EG\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:170:\"https://www.reuters.com/article/us-ubs-group-moves/ubs-hires-former-credit-suisse-star-khan-as-part-of-broader-shakeup-idUSKCN1VJ0EG?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Aug 2019 09:28:30 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:506:\"Switzerland\'s biggest bank UBS on Thursday appointed former Credit Suisse manager Iqbal Khan to co-lead its flagship wealth management business, as part of a broader shake-up of its executive board.<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=_mUVRBF05Sk:V0kd4D-KMdQ:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/_mUVRBF05Sk\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:170:\"https://www.reuters.com/article/us-ubs-group-moves/ubs-hires-former-credit-suisse-star-khan-as-part-of-broader-shakeup-idUSKCN1VJ0EG?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"UBS&#039;s Ermotti says Swiss bank&#039;s CEO bench at least three deep: NZZ\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"http://feeds.reuters.com/~r/news/wealth/~3/97uSrOg6gyY/ubss-ermotti-says-swiss-banks-ceo-bench-at-least-three-deep-nzz-idUSKCN1VJ1NQ\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:174:\"https://www.reuters.com/article/us-ubs-group-moves-ermotti/ubss-ermotti-says-swiss-banks-ceo-bench-at-least-three-deep-nzz-idUSKCN1VJ1NQ?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Aug 2019 09:28:17 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:510:\"UBS has least three candidates from inside the biggest Swiss bank who could eventually step into the CEO role, Chief Executive Sergio Ermotti said in a newspaper interview on Thursday on the heels of...<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=97uSrOg6gyY:9s85RSa2VCk:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/97uSrOg6gyY\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:174:\"https://www.reuters.com/article/us-ubs-group-moves-ermotti/ubss-ermotti-says-swiss-banks-ceo-bench-at-least-three-deep-nzz-idUSKCN1VJ1NQ?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"Former CS banker Iqbal Khan to head UBS wealth management: TagesAnzeiger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:140:\"http://feeds.reuters.com/~r/news/wealth/~3/Ck-GcVJF23M/former-cs-banker-iqbal-khan-to-head-ubs-wealth-management-tagesanzeiger-idUSKCN1VI2CV\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:180:\"https://www.reuters.com/article/us-ubs-wealth-management/former-cs-banker-iqbal-khan-to-head-ubs-wealth-management-tagesanzeiger-idUSKCN1VI2CV?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Aug 2019 15:06:11 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:498:\"Swiss bank UBS will appoint former Credit Suisse banker Iqbal Khan as head of its wealth management business, Swiss newspaper TagesAnzeiger reported on Wednesday, citing unnamed UBS sources.<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=Ck-GcVJF23M:wB_D1LGq-YA:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/Ck-GcVJF23M\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:180:\"https://www.reuters.com/article/us-ubs-wealth-management/former-cs-banker-iqbal-khan-to-head-ubs-wealth-management-tagesanzeiger-idUSKCN1VI2CV?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"U.S. money fund assets fall from highest since October 2009: iMoneyNet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"http://feeds.reuters.com/~r/news/wealth/~3/qXe3ZgdKgmA/u-s-money-fund-assets-fall-from-highest-since-october-2009-imoneynet-idUSKCN1VI2BY\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:171:\"https://www.reuters.com/article/us-funds-imoneynet/u-s-money-fund-assets-fall-from-highest-since-october-2009-imoneynet-idUSKCN1VI2BY?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Aug 2019 14:49:00 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:504:\"U.S. money market fund assets fell this week, retreating from their highest level since October 2009, suggesting a pause in investors piling into these low-risk products amid trade and economic...<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=qXe3ZgdKgmA:qly4Qo5yNDY:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/qXe3ZgdKgmA\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:171:\"https://www.reuters.com/article/us-funds-imoneynet/u-s-money-fund-assets-fall-from-highest-since-october-2009-imoneynet-idUSKCN1VI2BY?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Three U.S. bond kings wield same strategy, get same result: lag their peers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:141:\"http://feeds.reuters.com/~r/news/wealth/~3/ogg2lnl3nDY/three-u-s-bond-kings-wield-same-strategy-get-same-result-lag-their-peers-idUSKCN1VH0D8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:191:\"https://www.reuters.com/article/us-usa-funds-biginvestors-analysis/three-u-s-bond-kings-wield-same-strategy-get-same-result-lag-their-peers-idUSKCN1VH0D8?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 Aug 2019 08:09:50 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:500:\"Three names dominate the U.S. world of bond investing - Jeffrey Gundlach, Dan Ivascyn and Scott Minerd. But funds run by these star investors are lagging their respective benchmarks this year.<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=ogg2lnl3nDY:7hB39cOCVTE:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/ogg2lnl3nDY\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:191:\"https://www.reuters.com/article/us-usa-funds-biginvestors-analysis/three-u-s-bond-kings-wield-same-strategy-get-same-result-lag-their-peers-idUSKCN1VH0D8?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"Credit Suisse to shift focus from branches to digital banking\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:130:\"http://feeds.reuters.com/~r/news/wealth/~3/AbtJYwp7Au0/credit-suisse-to-shift-focus-from-branches-to-digital-banking-idUSKCN1VG0CD\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:177:\"https://www.reuters.com/article/us-credit-suisse-direct-banking/credit-suisse-to-shift-focus-from-branches-to-digital-banking-idUSKCN1VG0CD?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 26 Aug 2019 03:18:00 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:509:\"Credit Suisse  said on Monday it would invest hundreds of millions of francs in digital services and other parts of its Swiss division by the end of 2021 and said it no longer needed a bigger branch...<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=AbtJYwp7Au0:joeqsJfD1J4:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/AbtJYwp7Au0\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:177:\"https://www.reuters.com/article/us-credit-suisse-direct-banking/credit-suisse-to-shift-focus-from-branches-to-digital-banking-idUSKCN1VG0CD?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Powell&#039;s speech support U.S. rate-cut bets\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"http://feeds.reuters.com/~r/news/wealth/~3/Zf0rmeqKwPI/powells-speech-support-u-s-rate-cut-bets-idUSKCN1VD1AD\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"https://www.reuters.com/article/us-usa-moneymarkets/powells-speech-support-u-s-rate-cut-bets-idUSKCN1VD1AD?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 Aug 2019 12:05:49 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:509:\"U.S. interest rates futures rose on Friday as Federal Reserve Chair Jerome Powell said the central bank will do what it can to preserve the longest U.S. economic expansion on record, supporting bets...<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=Zf0rmeqKwPI:SyII7qSZKs8:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/Zf0rmeqKwPI\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"https://www.reuters.com/article/us-usa-moneymarkets/powells-speech-support-u-s-rate-cut-bets-idUSKCN1VD1AD?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"Rising trade tensions revive bets on deep U.S. rate cut\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:123:\"http://feeds.reuters.com/~r/news/wealth/~3/SHxFURB-n54/rising-trade-tensions-revive-bets-on-deep-u-s-rate-cut-idUSKCN1VD1W9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:164:\"https://www.reuters.com/article/us-usa-moneymarkets-trade/rising-trade-tensions-revive-bets-on-deep-u-s-rate-cut-idUSKCN1VD1W9?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 Aug 2019 12:05:27 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:506:\"U.S. interest rates futures rallied on Friday as rising trade tensions between China and the United States revived bets the Federal Reserve may lower key borrowing costs by a bold half-point next...<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=SHxFURB-n54:VKMXSFBc9u4:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/SHxFURB-n54\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:164:\"https://www.reuters.com/article/us-usa-moneymarkets-trade/rising-trade-tensions-revive-bets-on-deep-u-s-rate-cut-idUSKCN1VD1W9?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"U.S. rates futures gain on China&#039;s tariff, Fed&#039;s Bullard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"http://feeds.reuters.com/~r/news/wealth/~3/E-EEmsxXOwg/u-s-rates-futures-gain-on-chinas-tariff-feds-bullard-idUSKCN1VD1CI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:162:\"https://www.reuters.com/article/us-usa-moneymarkets-china/u-s-rates-futures-gain-on-chinas-tariff-feds-bullard-idUSKCN1VD1CI?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 Aug 2019 08:40:54 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:505:\"U.S. interest rates futures rose on Friday, erasing their earlier losses after China announced retaliatory tariffs on about $75 billion of U.S. imports, rekindling bets the trade war between the...<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=E-EEmsxXOwg:IQtMToMC0Fk:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/E-EEmsxXOwg\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:162:\"https://www.reuters.com/article/us-usa-moneymarkets-china/u-s-rates-futures-gain-on-chinas-tariff-feds-bullard-idUSKCN1VD1CI?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"As bond e-trading takes off, debt sales business may be ripe for automation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:143:\"http://feeds.reuters.com/~r/news/wealth/~3/CV8SXB68iFA/as-bond-e-trading-takes-off-debt-sales-business-may-be-ripe-for-automation-idUSKCN1VD136\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:183:\"https://www.reuters.com/article/us-debt-bonds-automation/as-bond-e-trading-takes-off-debt-sales-business-may-be-ripe-for-automation-idUSKCN1VD136?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 Aug 2019 08:12:47 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:505:\"With banks\' bond trading desks increasingly going electronic, another of the last bastions of old-school banking - the business of helping companies and countries raise capital - may be about to...<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=CV8SXB68iFA:Laiyvlp8nQw:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/CV8SXB68iFA\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:183:\"https://www.reuters.com/article/us-debt-bonds-automation/as-bond-e-trading-takes-off-debt-sales-business-may-be-ripe-for-automation-idUSKCN1VD136?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"Guggenheim&#039;s Scott Minerd warns world bond markets are in a &#039;bubble&#039;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"http://feeds.reuters.com/~r/news/wealth/~3/mMnpJMDFAgQ/guggenheims-scott-minerd-warns-world-bond-markets-are-in-a-bubble-idUSKCN1VC2IS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:176:\"https://www.reuters.com/article/us-funds-guggenheim-minerd/guggenheims-scott-minerd-warns-world-bond-markets-are-in-a-bubble-idUSKCN1VC2IS?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Aug 2019 16:39:50 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:509:\"The bond market is in a \"bubble,\" particularly sovereign debt, Guggenheim Partners global chief investment officer Scott Minerd warned on Thursday, and he said that efforts by the Federal Reserve to...<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=mMnpJMDFAgQ:spi3dD7EoEM:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/mMnpJMDFAgQ\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:176:\"https://www.reuters.com/article/us-funds-guggenheim-minerd/guggenheims-scott-minerd-warns-world-bond-markets-are-in-a-bubble-idUSKCN1VC2IS?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:35:\"\n		\n\n		\n\n		\n        \n        \n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"Column: U.S. Medicare readies new plan-shopping website, but timing prompts concerns\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"http://feeds.reuters.com/~r/news/wealth/~3/HupDLP8yKjE/column-u-s-medicare-readies-new-plan-shopping-website-but-timing-prompts-concerns-idUSKCN1VC2GQ\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:198:\"https://www.reuters.com/article/us-column-miller-medicare-column/column-u-s-medicare-readies-new-plan-shopping-website-but-timing-prompts-concerns-idUSKCN1VC2GQ?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Aug 2019 16:13:29 -0400\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:387:\"(The opinions expressed here are those of the author, a columnist for Reuters.)<div class=\"feedflare\">\n<a href=\"http://feeds.reuters.com/~ff/news/wealth?a=HupDLP8yKjE:ydj6YVNwmd0:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/news/wealth?d=yIl2AUoC8zA\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/news/wealth/~4/HupDLP8yKjE\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:198:\"https://www.reuters.com/article/us-column-miller-medicare-column/column-u-s-medicare-readies-new-plan-shopping-website-but-timing-prompts-concerns-idUSKCN1VC2GQ?feedType=RSS&feedName=PersonalFinance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";s:4:\"href\";s:36:\"http://feeds.reuters.com/news/wealth\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:3:\"hub\";s:4:\"href\";s:32:\"http://pubsubhubbub.appspot.com/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:4:{s:4:\"info\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:11:\"news/wealth\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:14:\"emailServiceId\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"news/wealth\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:18:\"feedburnerHostname\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://feedburner.google.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"feedFlare\";a:16:{i:0;a:5:{s:4:\"data\";s:24:\"Subscribe with My Yahoo!\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:79:\"https://add.my.yahoo.com/rss?url=http%3A%2F%2Ffeeds.reuters.com%2Fnews%2Fwealth\";s:3:\"src\";s:59:\"http://us.i1.yimg.com/us.yimg.com/i/us/my/addtomyyahoo4.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:24:\"Subscribe with NewsGator\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:102:\"http://www.newsgator.com/ngs/subscriber/subext.aspx?url=http%3A%2F%2Ffeeds.reuters.com%2Fnews%2Fwealth\";s:3:\"src\";s:42:\"http://www.newsgator.com/images/ngsub1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:21:\"Subscribe with My AOL\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:82:\"http://feeds.my.aol.com/add.jsp?url=http%3A%2F%2Ffeeds.reuters.com%2Fnews%2Fwealth\";s:3:\"src\";s:108:\"http://o.aolcdn.com/favorites.my.aol.com/webmaster/ffclient/webroot/locale/en-US/images/myAOLButtonSmall.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:24:\"Subscribe with Bloglines\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:65:\"http://www.bloglines.com/sub/http://feeds.reuters.com/news/wealth\";s:3:\"src\";s:48:\"http://www.bloglines.com/images/sub_modern11.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:23:\"Subscribe with Netvibes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:88:\"http://www.netvibes.com/subscribe.php?url=http%3A%2F%2Ffeeds.reuters.com%2Fnews%2Fwealth\";s:3:\"src\";s:39:\"//www.netvibes.com/img/add2netvibes.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:21:\"Subscribe with Google\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:83:\"http://fusion.google.com/add?feedurl=http%3A%2F%2Ffeeds.reuters.com%2Fnews%2Fwealth\";s:3:\"src\";s:51:\"http://buttons.googlesyndication.com/fusion/add.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:25:\"Subscribe with Pageflakes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:91:\"http://www.pageflakes.com/subscribe.aspx?url=http%3A%2F%2Ffeeds.reuters.com%2Fnews%2Fwealth\";s:3:\"src\";s:87:\"http://www.pageflakes.com/ImageFile.ashx?instanceId=Static_4&fileName=ATP_blu_91x17.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:21:\"Subscribe with Plusmo\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:76:\"http://www.plusmo.com/add?url=http%3A%2F%2Ffeeds.reuters.com%2Fnews%2Fwealth\";s:3:\"src\";s:43:\"http://plusmo.com/res/graphics/fbplusmo.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:34:\"Subscribe with The Free Dictionary\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:96:\"http://www.thefreedictionary.com/_/hp/AddRSS.aspx?http%3A%2F%2Ffeeds.reuters.com%2Fnews%2Fwealth\";s:3:\"src\";s:48:\"http://img.tfd.com/hp/addToTheFreeDictionary.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:9;a:5:{s:4:\"data\";s:28:\"Subscribe with Bitty Browser\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:108:\"http://www.bitty.com/manual/?contenttype=rssfeed&contentvalue=http%3A%2F%2Ffeeds.reuters.com%2Fnews%2Fwealth\";s:3:\"src\";s:48:\"http://www.bitty.com/img/bittychicklet_91x17.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:10;a:5:{s:4:\"data\";s:23:\"Subscribe with Live.com\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:71:\"http://www.live.com/?add=http%3A%2F%2Ffeeds.reuters.com%2Fnews%2Fwealth\";s:3:\"src\";s:141:\"http://tkfiles.storage.msn.com/x1piYkpqHC_35nIp1gLE68-wvzLZO8iXl_JMledmJQXP-XTBOLfmQv4zhj4MhcWEJh_GtoBIiAl1Mjh-ndp9k47If7hTaFno0mxW9_i3p_5qQw\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:11;a:5:{s:4:\"data\";s:25:\"Subscribe with Excite MIX\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:79:\"http://mix.excite.eu/add?feedurl=http%3A%2F%2Ffeeds.reuters.com%2Fnews%2Fwealth\";s:3:\"src\";s:42:\"http://image.excite.co.uk/mix/addtomix.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:12;a:5:{s:4:\"data\";s:21:\"Subscribe with Webwag\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:84:\"http://www.webwag.com/wwgthis.php?url=http%3A%2F%2Ffeeds.reuters.com%2Fnews%2Fwealth\";s:3:\"src\";s:40:\"http://www.webwag.com/images/wwgthis.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:13;a:5:{s:4:\"data\";s:28:\"Subscribe with Podcast Ready\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:100:\"http://www.podcastready.com/oneclick_bookmark.php?url=http%3A%2F%2Ffeeds.reuters.com%2Fnews%2Fwealth\";s:3:\"src\";s:58:\"http://www.podcastready.com/images/podcastready_button.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:14;a:5:{s:4:\"data\";s:20:\"Subscribe with Wikio\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:81:\"http://www.wikio.com/subscribe?url=http%3A%2F%2Ffeeds.reuters.com%2Fnews%2Fwealth\";s:3:\"src\";s:45:\"http://www.wikio.com/shared/img/add2wikio.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:15;a:5:{s:4:\"data\";s:29:\"Subscribe with Daily Rotation\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:90:\"http://www.dailyrotation.com/index.php?feed=http%3A%2F%2Ffeeds.reuters.com%2Fnews%2Fwealth\";s:3:\"src\";s:40:\"http://www.dailyrotation.com/rss-dr2.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"etag\";s:27:\"IDAeVjkBs37Sfqy5p34PCvsb+W8\";s:13:\"last-modified\";s:29:\"Wed, 04 Sep 2019 23:08:40 GMT\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"date\";s:29:\"Wed, 04 Sep 2019 23:11:23 GMT\";s:7:\"expires\";s:29:\"Wed, 04 Sep 2019 23:11:23 GMT\";s:13:\"cache-control\";s:18:\"private, max-age=0\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:6:\"server\";s:3:\"GSE\";}s:5:\"build\";s:14:\"20151104113011\";}", "no");
INSERT INTO `apprenz_options` VALUES("48172", "_transient_timeout_wc_uf_pid_7c21ac93b00914e5b3242634c1e4c6ab", "1568317970", "no");
INSERT INTO `apprenz_options` VALUES("48173", "_transient_wc_uf_pid_7c21ac93b00914e5b3242634c1e4c6ab", "a:0:{}", "no");
INSERT INTO `apprenz_options` VALUES("24235", "_transient_timeout_external_ip_address_103.84.186.121", "1488441106", "no");
INSERT INTO `apprenz_options` VALUES("24236", "_transient_external_ip_address_103.84.186.121", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("16609", "_transient_timeout_external_ip_address_10.3.206.212", "1468003029", "no");
INSERT INTO `apprenz_options` VALUES("16610", "_transient_external_ip_address_10.3.206.212", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("16696", "akismet_spam_count", "24", "yes");
INSERT INTO `apprenz_options` VALUES("16806", "_transient_timeout_wc_uf_pid_2a5e0ae76157a2bb73745b5c4d8a1c45_s", "1470425396", "no");
INSERT INTO `apprenz_options` VALUES("16807", "_transient_wc_uf_pid_2a5e0ae76157a2bb73745b5c4d8a1c45_s", "a:0:{}", "no");
INSERT INTO `apprenz_options` VALUES("34865", "_transient_timeout_external_ip_address_151.217.68.28", "1515033099", "no");
INSERT INTO `apprenz_options` VALUES("34866", "_transient_external_ip_address_151.217.68.28", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("15813", "_transient_timeout_external_ip_address_10.3.169.135", "1465980581", "no");
INSERT INTO `apprenz_options` VALUES("18257", "_transient_external_ip_address_unknown", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("15814", "_transient_external_ip_address_10.3.169.135", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("30614", "_transient_timeout_external_ip_address_102.169.11.82", "1504304376", "no");
INSERT INTO `apprenz_options` VALUES("14518", "_transient_timeout_external_ip_address_10.1.2.92", "1463055409", "no");
INSERT INTO `apprenz_options` VALUES("14519", "_transient_external_ip_address_10.1.2.92", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("14290", "_transient_timeout_external_ip_address_192.168.0.101", "1462598429", "no");
INSERT INTO `apprenz_options` VALUES("14291", "_transient_external_ip_address_192.168.0.101", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("15506", "_transient_timeout_external_ip_address_172.29.59.225", "1465207498", "no");
INSERT INTO `apprenz_options` VALUES("15507", "_transient_external_ip_address_172.29.59.225", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("14022", "_transient_timeout_external_ip_address_10.3.74.73", "1462091429", "no");
INSERT INTO `apprenz_options` VALUES("14023", "_transient_external_ip_address_10.3.74.73", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("14042", "_transient_timeout_external_ip_address_10.3.13.44", "1462153923", "no");
INSERT INTO `apprenz_options` VALUES("14043", "_transient_external_ip_address_10.3.13.44", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("15112", "_transient_timeout_external_ip_address_192.168.6.56", "1464319666", "no");
INSERT INTO `apprenz_options` VALUES("14075", "_transient_timeout_external_ip_address_192.168.111.248", "1462217804", "no");
INSERT INTO `apprenz_options` VALUES("14076", "_transient_external_ip_address_192.168.111.248", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("14079", "_transient_timeout_external_ip_address_}__test|O:21:\\\"JDatabaseD", "1462225609", "no");
INSERT INTO `apprenz_options` VALUES("14080", "_transient_external_ip_address_}__test|O:21:\\\"JDatabaseDriverMys", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("14154", "_transient_timeout_external_ip_address_192.168.58.104", "1462335722", "no");
INSERT INTO `apprenz_options` VALUES("14155", "_transient_external_ip_address_192.168.58.104", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("14166", "_transient_timeout_external_ip_address_10.206.132.230", "1462347241", "no");
INSERT INTO `apprenz_options` VALUES("14167", "_transient_external_ip_address_10.206.132.230", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("14175", "_transient_timeout_external_ip_address_192.168.1.247", "1462374614", "no");
INSERT INTO `apprenz_options` VALUES("14176", "_transient_external_ip_address_192.168.1.247", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("7649", "_transient_geoip_2a01:4f8:c17:868::2", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7650", "_transient_timeout_geoip_104.219.248.197", "1448295666", "no");
INSERT INTO `apprenz_options` VALUES("7651", "_transient_geoip_104.219.248.197", "US", "no");
INSERT INTO `apprenz_options` VALUES("7652", "_transient_timeout_geoip_91.189.180.17", "1448295728", "no");
INSERT INTO `apprenz_options` VALUES("7653", "_transient_geoip_91.189.180.17", "NO", "no");
INSERT INTO `apprenz_options` VALUES("7654", "_transient_timeout_geoip_205.134.224.235", "1448295909", "no");
INSERT INTO `apprenz_options` VALUES("7655", "_transient_geoip_205.134.224.235", "US", "no");
INSERT INTO `apprenz_options` VALUES("7656", "_transient_timeout_geoip_172.245.227.187", "1448295940", "no");
INSERT INTO `apprenz_options` VALUES("7657", "_transient_geoip_172.245.227.187", "US", "no");
INSERT INTO `apprenz_options` VALUES("7658", "_transient_timeout_geoip_117.55.227.108", "1448296021", "no");
INSERT INTO `apprenz_options` VALUES("7659", "_transient_geoip_117.55.227.108", "AU", "no");
INSERT INTO `apprenz_options` VALUES("7660", "_transient_timeout_geoip_108.178.4.90", "1448296192", "no");
INSERT INTO `apprenz_options` VALUES("7661", "_transient_geoip_108.178.4.90", "US", "no");
INSERT INTO `apprenz_options` VALUES("7662", "_transient_timeout_geoip_206.130.103.6", "1448296231", "no");
INSERT INTO `apprenz_options` VALUES("7663", "_transient_geoip_206.130.103.6", "US", "no");
INSERT INTO `apprenz_options` VALUES("7664", "_transient_timeout_geoip_187.108.194.152", "1448296384", "no");
INSERT INTO `apprenz_options` VALUES("7665", "_transient_geoip_187.108.194.152", "BR", "no");
INSERT INTO `apprenz_options` VALUES("7666", "_transient_timeout_geoip_114.142.158.51", "1448296724", "no");
INSERT INTO `apprenz_options` VALUES("7667", "_transient_geoip_114.142.158.51", "HK", "no");
INSERT INTO `apprenz_options` VALUES("8615", "_transient_timeout_geoip_2607:5300:60:61b0::", "1448922995", "no");
INSERT INTO `apprenz_options` VALUES("8616", "_transient_geoip_2607:5300:60:61b0::", "CA", "no");
INSERT INTO `apprenz_options` VALUES("7670", "_transient_timeout_geoip_192.3.20.250", "1448297054", "no");
INSERT INTO `apprenz_options` VALUES("7671", "_transient_geoip_192.3.20.250", "US", "no");
INSERT INTO `apprenz_options` VALUES("7672", "_transient_timeout_geoip_31.216.48.16", "1448297557", "no");
INSERT INTO `apprenz_options` VALUES("7673", "_transient_geoip_31.216.48.16", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7674", "_transient_timeout_geoip_209.43.126.3", "1448298601", "no");
INSERT INTO `apprenz_options` VALUES("7675", "_transient_geoip_209.43.126.3", "US", "no");
INSERT INTO `apprenz_options` VALUES("7677", "_transient_timeout_geoip_119.148.73.202", "1448298736", "no");
INSERT INTO `apprenz_options` VALUES("7678", "_transient_geoip_119.148.73.202", "AU", "no");
INSERT INTO `apprenz_options` VALUES("7679", "_transient_timeout_geoip_85.25.200.186", "1448299005", "no");
INSERT INTO `apprenz_options` VALUES("7680", "_transient_geoip_85.25.200.186", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7681", "_transient_timeout_geoip_202.221.31.129", "1448299064", "no");
INSERT INTO `apprenz_options` VALUES("7682", "_transient_geoip_202.221.31.129", "JP", "no");
INSERT INTO `apprenz_options` VALUES("7683", "_transient_timeout_geoip_72.52.229.133", "1448299521", "no");
INSERT INTO `apprenz_options` VALUES("7684", "_transient_geoip_72.52.229.133", "US", "no");
INSERT INTO `apprenz_options` VALUES("7685", "_transient_timeout_geoip_66.99.13.81", "1448299556", "no");
INSERT INTO `apprenz_options` VALUES("7686", "_transient_geoip_66.99.13.81", "US", "no");
INSERT INTO `apprenz_options` VALUES("7687", "_transient_timeout_geoip_173.199.143.37", "1448299693", "no");
INSERT INTO `apprenz_options` VALUES("7688", "_transient_geoip_173.199.143.37", "US", "no");
INSERT INTO `apprenz_options` VALUES("7689", "_transient_timeout_geoip_188.210.216.126", "1448299697", "no");
INSERT INTO `apprenz_options` VALUES("7690", "_transient_geoip_188.210.216.126", "ES", "no");
INSERT INTO `apprenz_options` VALUES("7691", "_transient_timeout_geoip_162.144.59.33", "1448299851", "no");
INSERT INTO `apprenz_options` VALUES("7692", "_transient_geoip_162.144.59.33", "US", "no");
INSERT INTO `apprenz_options` VALUES("8603", "_transient_timeout_geoip_67.222.146.236", "1448913917", "no");
INSERT INTO `apprenz_options` VALUES("8604", "_transient_geoip_67.222.146.236", "US", "no");
INSERT INTO `apprenz_options` VALUES("7695", "_transient_timeout_geoip_2001:4802:7801:102:a5f4:73a1:ff20:19af", "1448300063", "no");
INSERT INTO `apprenz_options` VALUES("7696", "_transient_geoip_2001:4802:7801:102:a5f4:73a1:ff20:19af", "US", "no");
INSERT INTO `apprenz_options` VALUES("7697", "_transient_timeout_geoip_50.19.96.112", "1448300424", "no");
INSERT INTO `apprenz_options` VALUES("7698", "_transient_geoip_50.19.96.112", "US", "no");
INSERT INTO `apprenz_options` VALUES("7699", "_transient_timeout_geoip_103.20.91.188", "1448300441", "no");
INSERT INTO `apprenz_options` VALUES("7700", "_transient_geoip_103.20.91.188", "ID", "no");
INSERT INTO `apprenz_options` VALUES("7701", "_transient_timeout_geoip_118.139.162.99", "1448300819", "no");
INSERT INTO `apprenz_options` VALUES("7702", "_transient_geoip_118.139.162.99", "SG", "no");
INSERT INTO `apprenz_options` VALUES("7703", "_transient_timeout_geoip_209.238.2.94", "1448300824", "no");
INSERT INTO `apprenz_options` VALUES("7704", "_transient_geoip_209.238.2.94", "US", "no");
INSERT INTO `apprenz_options` VALUES("7705", "_transient_timeout_geoip_62.146.189.142", "1448300924", "no");
INSERT INTO `apprenz_options` VALUES("7706", "_transient_geoip_62.146.189.142", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7707", "_transient_timeout_geoip_62.20.1.216", "1448303914", "no");
INSERT INTO `apprenz_options` VALUES("7708", "_transient_geoip_62.20.1.216", "SE", "no");
INSERT INTO `apprenz_options` VALUES("7714", "_transient_timeout_geoip_207.55.98.4", "1448304030", "no");
INSERT INTO `apprenz_options` VALUES("6219", "wp-optimize-schedule", "false", "no");
INSERT INTO `apprenz_options` VALUES("6220", "wp-optimize-last-optimized", "Never", "no");
INSERT INTO `apprenz_options` VALUES("6221", "wp-optimize-schedule-type", "wpo_weekly", "no");
INSERT INTO `apprenz_options` VALUES("6222", "wp-optimize-retention-enabled", "false", "no");
INSERT INTO `apprenz_options` VALUES("6223", "wp-optimize-retention-period", "2", "no");
INSERT INTO `apprenz_options` VALUES("6224", "wp-optimize-enable-admin-menu", "false", "no");
INSERT INTO `apprenz_options` VALUES("6225", "wp-optimize-email", "true", "no");
INSERT INTO `apprenz_options` VALUES("6226", "wp-optimize-total-cleaned", "27924", "no");
INSERT INTO `apprenz_options` VALUES("6227", "wp-optimize-auto", "a:8:{s:9:\"revisions\";s:4:\"true\";s:6:\"drafts\";s:4:\"true\";s:5:\"spams\";s:4:\"true\";s:10:\"unapproved\";s:5:\"false\";s:9:\"transient\";s:5:\"false\";s:8:\"postmeta\";s:5:\"false\";s:4:\"tags\";s:5:\"false\";s:8:\"optimize\";s:4:\"true\";}", "yes");
INSERT INTO `apprenz_options` VALUES("6228", "wp-optimize-settings", "a:5:{s:14:\"user-revisions\";b:0;s:11:\"user-drafts\";b:0;s:10:\"user-spams\";b:0;s:15:\"user-unapproved\";b:0;s:13:\"user-optimize\";b:1;}", "yes");
INSERT INTO `apprenz_options` VALUES("7873", "_transient_geoip_176.10.114.135", "CH", "no");
INSERT INTO `apprenz_options` VALUES("7874", "_transient_timeout_geoip_184.107.229.18", "1448402542", "no");
INSERT INTO `apprenz_options` VALUES("7875", "_transient_geoip_184.107.229.18", "CA", "no");
INSERT INTO `apprenz_options` VALUES("7876", "_transient_timeout_geoip_120.138.17.237", "1448402550", "no");
INSERT INTO `apprenz_options` VALUES("7877", "_transient_geoip_120.138.17.237", "NZ", "no");
INSERT INTO `apprenz_options` VALUES("8709", "_transient_timeout_geoip_2607:5300:60:1695::", "1449026697", "no");
INSERT INTO `apprenz_options` VALUES("8710", "_transient_geoip_2607:5300:60:1695::", "CA", "no");
INSERT INTO `apprenz_options` VALUES("7880", "_transient_timeout_geoip_209.217.234.154", "1448402626", "no");
INSERT INTO `apprenz_options` VALUES("7881", "_transient_geoip_209.217.234.154", "US", "no");
INSERT INTO `apprenz_options` VALUES("9044", "_transient_timeout_geoip_72.9.145.216", "1449262817", "no");
INSERT INTO `apprenz_options` VALUES("9045", "_transient_geoip_72.9.145.216", "US", "no");
INSERT INTO `apprenz_options` VALUES("7884", "_transient_timeout_geoip_192.30.164.201", "1448402874", "no");
INSERT INTO `apprenz_options` VALUES("7885", "_transient_geoip_192.30.164.201", "US", "no");
INSERT INTO `apprenz_options` VALUES("7886", "_transient_timeout_geoip_173.247.244.100", "1448403217", "no");
INSERT INTO `apprenz_options` VALUES("7887", "_transient_geoip_173.247.244.100", "US", "no");
INSERT INTO `apprenz_options` VALUES("7888", "_transient_timeout_geoip_200.165.65.210", "1448404002", "no");
INSERT INTO `apprenz_options` VALUES("7889", "_transient_geoip_200.165.65.210", "BR", "no");
INSERT INTO `apprenz_options` VALUES("8701", "_transient_timeout_geoip_199.201.110.60", "1449019892", "no");
INSERT INTO `apprenz_options` VALUES("8702", "_transient_geoip_199.201.110.60", "US", "no");
INSERT INTO `apprenz_options` VALUES("7893", "_transient_geoip_64.119.182.90", "US", "no");
INSERT INTO `apprenz_options` VALUES("9211", "_transient_timeout_geoip_212.113.144.11", "1449403969", "no");
INSERT INTO `apprenz_options` VALUES("9212", "_transient_geoip_212.113.144.11", "GB", "no");
INSERT INTO `apprenz_options` VALUES("8906", "_transient_timeout_geoip_81.21.67.66", "1449144664", "no");
INSERT INTO `apprenz_options` VALUES("8907", "_transient_geoip_81.21.67.66", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7898", "_transient_timeout_geoip_184.154.49.74", "1448404993", "no");
INSERT INTO `apprenz_options` VALUES("7899", "_transient_geoip_184.154.49.74", "US", "no");
INSERT INTO `apprenz_options` VALUES("9139", "_transient_timeout_geoip_185.2.129.165", "1449350994", "no");
INSERT INTO `apprenz_options` VALUES("9140", "_transient_geoip_185.2.129.165", "ES", "no");
INSERT INTO `apprenz_options` VALUES("7902", "_transient_timeout_geoip_5.178.68.237", "1448406603", "no");
INSERT INTO `apprenz_options` VALUES("7903", "_transient_geoip_5.178.68.237", "NL", "no");
INSERT INTO `apprenz_options` VALUES("7905", "_transient_timeout_geoip_2a00:1a48:7808:102:be76:4eff:fe08:c623", "1448413195", "no");
INSERT INTO `apprenz_options` VALUES("7906", "_transient_geoip_2a00:1a48:7808:102:be76:4eff:fe08:c623", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7907", "_transient_timeout_geoip_69.174.241.77", "1448416202", "no");
INSERT INTO `apprenz_options` VALUES("7908", "_transient_geoip_69.174.241.77", "US", "no");
INSERT INTO `apprenz_options` VALUES("8860", "_transient_timeout_geoip_91.121.67.205", "1449107649", "no");
INSERT INTO `apprenz_options` VALUES("8861", "_transient_geoip_91.121.67.205", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7912", "_transient_timeout_geoip_69.73.146.14", "1448423838", "no");
INSERT INTO `apprenz_options` VALUES("7913", "_transient_geoip_69.73.146.14", "US", "no");
INSERT INTO `apprenz_options` VALUES("9314", "_transient_timeout_geoip_109.169.39.245", "1449482233", "no");
INSERT INTO `apprenz_options` VALUES("9315", "_transient_geoip_109.169.39.245", "GB", "no");
INSERT INTO `apprenz_options` VALUES("8882", "_transient_timeout_geoip_192.64.33.186", "1449128008", "no");
INSERT INTO `apprenz_options` VALUES("8883", "_transient_geoip_192.64.33.186", "US", "no");
INSERT INTO `apprenz_options` VALUES("9312", "_transient_timeout_geoip_50.97.118.114", "1449481810", "no");
INSERT INTO `apprenz_options` VALUES("9313", "_transient_geoip_50.97.118.114", "US", "no");
INSERT INTO `apprenz_options` VALUES("7921", "_transient_timeout_geoip_80.172.225.230", "1448424917", "no");
INSERT INTO `apprenz_options` VALUES("7922", "_transient_geoip_80.172.225.230", "PT", "no");
INSERT INTO `apprenz_options` VALUES("7923", "_transient_timeout_geoip_85.17.187.29", "1448425621", "no");
INSERT INTO `apprenz_options` VALUES("7924", "_transient_geoip_85.17.187.29", "NL", "no");
INSERT INTO `apprenz_options` VALUES("7925", "_transient_timeout_geoip_2600:3c00::f03c:91ff:fe67:e90f", "1448425808", "no");
INSERT INTO `apprenz_options` VALUES("7926", "_transient_geoip_2600:3c00::f03c:91ff:fe67:e90f", "US", "no");
INSERT INTO `apprenz_options` VALUES("9368", "_transient_timeout_geoip_2607:f208:50f:3600::10", "1449529030", "no");
INSERT INTO `apprenz_options` VALUES("9369", "_transient_geoip_2607:f208:50f:3600::10", "US", "no");
INSERT INTO `apprenz_options` VALUES("7930", "_transient_timeout_geoip_204.93.183.79", "1448428423", "no");
INSERT INTO `apprenz_options` VALUES("7931", "_transient_geoip_204.93.183.79", "US", "no");
INSERT INTO `apprenz_options` VALUES("7932", "_transient_timeout_geoip_184.154.53.91", "1448429058", "no");
INSERT INTO `apprenz_options` VALUES("7933", "_transient_geoip_184.154.53.91", "US", "no");
INSERT INTO `apprenz_options` VALUES("7935", "_transient_timeout_geoip_108.168.128.187", "1448429339", "no");
INSERT INTO `apprenz_options` VALUES("7936", "_transient_geoip_108.168.128.187", "US", "no");
INSERT INTO `apprenz_options` VALUES("7937", "_transient_timeout_geoip_95.173.188.243", "1448429383", "no");
INSERT INTO `apprenz_options` VALUES("7938", "_transient_geoip_95.173.188.243", "TR", "no");
INSERT INTO `apprenz_options` VALUES("7939", "_transient_timeout_geoip_66.117.3.31", "1448429542", "no");
INSERT INTO `apprenz_options` VALUES("7940", "_transient_geoip_66.117.3.31", "US", "no");
INSERT INTO `apprenz_options` VALUES("7941", "_transient_timeout_geoip_185.71.216.26", "1448430395", "no");
INSERT INTO `apprenz_options` VALUES("7942", "_transient_geoip_185.71.216.26", "CY", "no");
INSERT INTO `apprenz_options` VALUES("7943", "_transient_timeout_geoip_103.15.156.4", "1448431358", "no");
INSERT INTO `apprenz_options` VALUES("7944", "_transient_geoip_103.15.156.4", "AU", "no");
INSERT INTO `apprenz_options` VALUES("7950", "_transient_timeout_geoip_37.115.101.177", "1448438775", "no");
INSERT INTO `apprenz_options` VALUES("7951", "_transient_geoip_37.115.101.177", "UA", "no");
INSERT INTO `apprenz_options` VALUES("7957", "_transient_timeout_geoip_92.241.245.126", "1448439752", "no");
INSERT INTO `apprenz_options` VALUES("7958", "_transient_geoip_92.241.245.126", "RU", "no");
INSERT INTO `apprenz_options` VALUES("7959", "_transient_timeout_geoip_184.154.61.250", "1448446670", "no");
INSERT INTO `apprenz_options` VALUES("7960", "_transient_geoip_184.154.61.250", "US", "no");
INSERT INTO `apprenz_options` VALUES("8858", "_transient_timeout_geoip_75.103.66.14", "1449106452", "no");
INSERT INTO `apprenz_options` VALUES("8859", "_transient_geoip_75.103.66.14", "US", "no");
INSERT INTO `apprenz_options` VALUES("8948", "_transient_timeout_geoip_142.4.4.201", "1449180796", "no");
INSERT INTO `apprenz_options` VALUES("8949", "_transient_geoip_142.4.4.201", "US", "no");
INSERT INTO `apprenz_options` VALUES("8865", "_transient_timeout_geoip_74.81.66.56", "1449110321", "no");
INSERT INTO `apprenz_options` VALUES("8866", "_transient_geoip_74.81.66.56", "US", "no");
INSERT INTO `apprenz_options` VALUES("7968", "_transient_timeout_geoip_72.34.62.48", "1448447774", "no");
INSERT INTO `apprenz_options` VALUES("7969", "_transient_geoip_72.34.62.48", "US", "no");
INSERT INTO `apprenz_options` VALUES("7970", "_transient_timeout_geoip_216.245.197.138", "1448447832", "no");
INSERT INTO `apprenz_options` VALUES("7971", "_transient_geoip_216.245.197.138", "US", "no");
INSERT INTO `apprenz_options` VALUES("7972", "_transient_timeout_geoip_46.32.229.102", "1448447949", "no");
INSERT INTO `apprenz_options` VALUES("7973", "_transient_geoip_46.32.229.102", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7974", "_transient_timeout_geoip_85.234.159.166", "1448447971", "no");
INSERT INTO `apprenz_options` VALUES("7975", "_transient_geoip_85.234.159.166", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7976", "_transient_timeout_geoip_83.223.124.8", "1448448620", "no");
INSERT INTO `apprenz_options` VALUES("7977", "_transient_geoip_83.223.124.8", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7978", "_transient_timeout_geoip_96.30.47.232", "1448449804", "no");
INSERT INTO `apprenz_options` VALUES("7979", "_transient_geoip_96.30.47.232", "US", "no");
INSERT INTO `apprenz_options` VALUES("8796", "_transient_timeout_geoip_184.154.158.122", "1449073088", "no");
INSERT INTO `apprenz_options` VALUES("8797", "_transient_geoip_184.154.158.122", "US", "no");
INSERT INTO `apprenz_options` VALUES("7982", "_transient_timeout_geoip_91.220.196.133", "1448450251", "no");
INSERT INTO `apprenz_options` VALUES("7983", "_transient_geoip_91.220.196.133", "NO", "no");
INSERT INTO `apprenz_options` VALUES("7985", "_transient_timeout_geoip_83.223.124.13", "1448451498", "no");
INSERT INTO `apprenz_options` VALUES("7986", "_transient_geoip_83.223.124.13", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7987", "_transient_timeout_geoip_192.64.118.206", "1448451901", "no");
INSERT INTO `apprenz_options` VALUES("7988", "_transient_geoip_192.64.118.206", "US", "no");
INSERT INTO `apprenz_options` VALUES("9102", "_transient_timeout_geoip_184.154.42.98", "1449312368", "no");
INSERT INTO `apprenz_options` VALUES("9103", "_transient_geoip_184.154.42.98", "US", "no");
INSERT INTO `apprenz_options` VALUES("7991", "_transient_timeout_geoip_180.76.15.14", "1448455534", "no");
INSERT INTO `apprenz_options` VALUES("7992", "_transient_geoip_180.76.15.14", "CN", "no");
INSERT INTO `apprenz_options` VALUES("7995", "_transient_timeout_geoip_80.244.182.56", "1448460633", "no");
INSERT INTO `apprenz_options` VALUES("7996", "_transient_geoip_80.244.182.56", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7997", "_transient_timeout_geoip_212.7.220.161", "1448467290", "no");
INSERT INTO `apprenz_options` VALUES("7998", "_transient_geoip_212.7.220.161", "PL", "no");
INSERT INTO `apprenz_options` VALUES("9197", "_transient_timeout_geoip_192.185.221.42", "1449397870", "no");
INSERT INTO `apprenz_options` VALUES("9198", "_transient_geoip_192.185.221.42", "US", "no");
INSERT INTO `apprenz_options` VALUES("8002", "_transient_timeout_geoip_41.185.22.74", "1448471276", "no");
INSERT INTO `apprenz_options` VALUES("8003", "_transient_geoip_41.185.22.74", "ZA", "no");
INSERT INTO `apprenz_options` VALUES("8005", "_transient_timeout_geoip_2606:2e00:0:12:225:90ff:fe78:76d6", "1448471520", "no");
INSERT INTO `apprenz_options` VALUES("8006", "_transient_geoip_2606:2e00:0:12:225:90ff:fe78:76d6", "US", "no");
INSERT INTO `apprenz_options` VALUES("8007", "_transient_timeout_geoip_109.75.161.249", "1448471821", "no");
INSERT INTO `apprenz_options` VALUES("8008", "_transient_geoip_109.75.161.249", "GB", "no");
INSERT INTO `apprenz_options` VALUES("8009", "_transient_timeout_geoip_67.207.143.235", "1448472540", "no");
INSERT INTO `apprenz_options` VALUES("8010", "_transient_geoip_67.207.143.235", "US", "no");
INSERT INTO `apprenz_options` VALUES("8011", "_transient_timeout_geoip_198.57.164.33", "1448472694", "no");
INSERT INTO `apprenz_options` VALUES("8012", "_transient_geoip_198.57.164.33", "US", "no");
INSERT INTO `apprenz_options` VALUES("9093", "_transient_timeout_geoip_198.1.76.21", "1449306459", "no");
INSERT INTO `apprenz_options` VALUES("9094", "_transient_geoip_198.1.76.21", "US", "no");
INSERT INTO `apprenz_options` VALUES("8950", "_transient_timeout_geoip_198.57.168.151", "1449180805", "no");
INSERT INTO `apprenz_options` VALUES("8951", "_transient_geoip_198.57.168.151", "US", "no");
INSERT INTO `apprenz_options` VALUES("9248", "_transient_timeout_geoip_188.226.171.142", "1449432586", "no");
INSERT INTO `apprenz_options` VALUES("9249", "_transient_geoip_188.226.171.142", "NL", "no");
INSERT INTO `apprenz_options` VALUES("8026", "_transient_timeout_geoip_67.228.183.136", "1448476418", "no");
INSERT INTO `apprenz_options` VALUES("8027", "_transient_geoip_67.228.183.136", "US", "no");
INSERT INTO `apprenz_options` VALUES("9146", "_transient_timeout_geoip_66.7.202.98", "1449356210", "no");
INSERT INTO `apprenz_options` VALUES("9147", "_transient_geoip_66.7.202.98", "US", "no");
INSERT INTO `apprenz_options` VALUES("8032", "_transient_timeout_geoip_176.9.48.251", "1448480109", "no");
INSERT INTO `apprenz_options` VALUES("8033", "_transient_geoip_176.9.48.251", "DE", "no");
INSERT INTO `apprenz_options` VALUES("9267", "_transient_timeout_geoip_192.168.0.6", "1449455976", "no");
INSERT INTO `apprenz_options` VALUES("9268", "_transient_geoip_192.168.0.6", "", "no");
INSERT INTO `apprenz_options` VALUES("9867", "_transient_timeout_external_ip_address_192.168.0.6", "1450660113", "no");
INSERT INTO `apprenz_options` VALUES("9868", "_transient_external_ip_address_192.168.0.6", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("8910", "_transient_timeout_geoip_142.4.31.248", "1449146789", "no");
INSERT INTO `apprenz_options` VALUES("8911", "_transient_geoip_142.4.31.248", "US", "no");
INSERT INTO `apprenz_options` VALUES("8046", "_transient_timeout_geoip_70.38.37.218", "1448488393", "no");
INSERT INTO `apprenz_options` VALUES("8047", "_transient_geoip_70.38.37.218", "CA", "no");
INSERT INTO `apprenz_options` VALUES("9251", "_transient_timeout_geoip_212.113.132.182", "1449433784", "no");
INSERT INTO `apprenz_options` VALUES("9252", "_transient_geoip_212.113.132.182", "GB", "no");
INSERT INTO `apprenz_options` VALUES("9226", "_transient_timeout_geoip_173.214.189.213", "1449425242", "no");
INSERT INTO `apprenz_options` VALUES("9227", "_transient_geoip_173.214.189.213", "US", "no");
INSERT INTO `apprenz_options` VALUES("8052", "_transient_timeout_geoip_95.154.250.15", "1448488764", "no");
INSERT INTO `apprenz_options` VALUES("8053", "_transient_geoip_95.154.250.15", "GB", "no");
INSERT INTO `apprenz_options` VALUES("9342", "_transient_timeout_geoip_119.81.221.68", "1449509233", "no");
INSERT INTO `apprenz_options` VALUES("9343", "_transient_geoip_119.81.221.68", "SG", "no");
INSERT INTO `apprenz_options` VALUES("8056", "_transient_timeout_geoip_208.64.36.164", "1448489751", "no");
INSERT INTO `apprenz_options` VALUES("8057", "_transient_geoip_208.64.36.164", "US", "no");
INSERT INTO `apprenz_options` VALUES("8058", "_transient_timeout_geoip_146.83.180.9", "1448491982", "no");
INSERT INTO `apprenz_options` VALUES("8059", "_transient_geoip_146.83.180.9", "CL", "no");
INSERT INTO `apprenz_options` VALUES("8061", "_transient_timeout_geoip_108.166.167.90", "1448492934", "no");
INSERT INTO `apprenz_options` VALUES("8062", "_transient_geoip_108.166.167.90", "US", "no");
INSERT INTO `apprenz_options` VALUES("8063", "_transient_timeout_geoip_64.92.125.34", "1448492956", "no");
INSERT INTO `apprenz_options` VALUES("8064", "_transient_geoip_64.92.125.34", "US", "no");
INSERT INTO `apprenz_options` VALUES("8839", "_transient_timeout_geoip_81.21.67.244", "1449099649", "no");
INSERT INTO `apprenz_options` VALUES("8840", "_transient_geoip_81.21.67.244", "GB", "no");
INSERT INTO `apprenz_options` VALUES("8067", "_transient_timeout_geoip_2607:5500:2000:34::e438", "1448493313", "no");
INSERT INTO `apprenz_options` VALUES("8068", "_transient_geoip_2607:5500:2000:34::e438", "US", "no");
INSERT INTO `apprenz_options` VALUES("8069", "_transient_timeout_geoip_199.116.248.171", "1448493573", "no");
INSERT INTO `apprenz_options` VALUES("8070", "_transient_geoip_199.116.248.171", "US", "no");
INSERT INTO `apprenz_options` VALUES("8071", "_transient_timeout_geoip_104.219.251.2", "1448494306", "no");
INSERT INTO `apprenz_options` VALUES("8072", "_transient_geoip_104.219.251.2", "US", "no");
INSERT INTO `apprenz_options` VALUES("9214", "_transient_timeout_geoip_95.154.242.79", "1449406784", "no");
INSERT INTO `apprenz_options` VALUES("9215", "_transient_geoip_95.154.242.79", "GB", "no");
INSERT INTO `apprenz_options` VALUES("8077", "_transient_timeout_geoip_184.170.252.34", "1448502112", "no");
INSERT INTO `apprenz_options` VALUES("8078", "_transient_geoip_184.170.252.34", "US", "no");
INSERT INTO `apprenz_options` VALUES("9277", "_transient_timeout_geoip_96.127.153.90", "1449457897", "no");
INSERT INTO `apprenz_options` VALUES("9278", "_transient_geoip_96.127.153.90", "US", "no");
INSERT INTO `apprenz_options` VALUES("8081", "_transient_timeout_geoip_212.7.205.182", "1448502916", "no");
INSERT INTO `apprenz_options` VALUES("8082", "_transient_geoip_212.7.205.182", "NL", "no");
INSERT INTO `apprenz_options` VALUES("9052", "_transient_timeout_geoip_64.22.100.83", "1449271585", "no");
INSERT INTO `apprenz_options` VALUES("9053", "_transient_geoip_64.22.100.83", "US", "no");
INSERT INTO `apprenz_options` VALUES("8085", "_transient_timeout_geoip_69.39.239.170", "1448503041", "no");
INSERT INTO `apprenz_options` VALUES("8086", "_transient_geoip_69.39.239.170", "US", "no");
INSERT INTO `apprenz_options` VALUES("8989", "_transient_timeout_geoip_184.154.167.98", "1449219750", "no");
INSERT INTO `apprenz_options` VALUES("8990", "_transient_geoip_184.154.167.98", "US", "no");
INSERT INTO `apprenz_options` VALUES("8963", "_transient_timeout_geoip_173.199.143.96", "1449204293", "no");
INSERT INTO `apprenz_options` VALUES("8964", "_transient_geoip_173.199.143.96", "US", "no");
INSERT INTO `apprenz_options` VALUES("8091", "_transient_timeout_geoip_75.101.158.177", "1448504301", "no");
INSERT INTO `apprenz_options` VALUES("8092", "_transient_geoip_75.101.158.177", "US", "no");
INSERT INTO `apprenz_options` VALUES("8093", "_transient_timeout_geoip_185.14.194.159", "1448505584", "no");
INSERT INTO `apprenz_options` VALUES("8094", "_transient_geoip_185.14.194.159", "UA", "no");
INSERT INTO `apprenz_options` VALUES("9100", "_transient_timeout_geoip_212.7.205.190", "1449311309", "no");
INSERT INTO `apprenz_options` VALUES("9101", "_transient_geoip_212.7.205.190", "NL", "no");
INSERT INTO `apprenz_options` VALUES("8098", "_transient_timeout_geoip_192.155.245.154", "1448509258", "no");
INSERT INTO `apprenz_options` VALUES("8099", "_transient_geoip_192.155.245.154", "US", "no");
INSERT INTO `apprenz_options` VALUES("8903", "_transient_timeout_geoip_198.154.218.73", "1449143282", "no");
INSERT INTO `apprenz_options` VALUES("8904", "_transient_geoip_198.154.218.73", "US", "no");
INSERT INTO `apprenz_options` VALUES("9221", "_transient_timeout_geoip_192.99.10.173", "1449410724", "no");
INSERT INTO `apprenz_options` VALUES("9222", "_transient_geoip_192.99.10.173", "CA", "no");
INSERT INTO `apprenz_options` VALUES("8105", "_transient_timeout_geoip_67.55.84.212", "1448515235", "no");
INSERT INTO `apprenz_options` VALUES("8106", "_transient_geoip_67.55.84.212", "US", "no");
INSERT INTO `apprenz_options` VALUES("8942", "_transient_timeout_geoip_207.20.232.240", "1449172759", "no");
INSERT INTO `apprenz_options` VALUES("8943", "_transient_geoip_207.20.232.240", "US", "no");
INSERT INTO `apprenz_options` VALUES("9156", "_transient_timeout_geoip_198.24.130.99", "1449370279", "no");
INSERT INTO `apprenz_options` VALUES("9157", "_transient_geoip_198.24.130.99", "US", "no");
INSERT INTO `apprenz_options` VALUES("8118", "_transient_timeout_geoip_182.236.127.20", "1448518804", "no");
INSERT INTO `apprenz_options` VALUES("8119", "_transient_geoip_182.236.127.20", "NZ", "no");
INSERT INTO `apprenz_options` VALUES("9133", "_transient_timeout_geoip_69.36.175.246", "1449348675", "no");
INSERT INTO `apprenz_options` VALUES("9134", "_transient_geoip_69.36.175.246", "US", "no");
INSERT INTO `apprenz_options` VALUES("8123", "_transient_timeout_geoip_62.160.49.169", "1448519315", "no");
INSERT INTO `apprenz_options` VALUES("8124", "_transient_geoip_62.160.49.169", "FR", "no");
INSERT INTO `apprenz_options` VALUES("9025", "_transient_timeout_geoip_185.17.150.73", "1449256342", "no");
INSERT INTO `apprenz_options` VALUES("9026", "_transient_geoip_185.17.150.73", "GB", "no");
INSERT INTO `apprenz_options` VALUES("8915", "_transient_timeout_geoip_2a02:af8:2:200::1:2799", "1449149092", "no");
INSERT INTO `apprenz_options` VALUES("8916", "_transient_geoip_2a02:af8:2:200::1:2799", "GB", "no");
INSERT INTO `apprenz_options` VALUES("9365", "_transient_timeout_geoip_198.12.152.170", "1449526099", "no");
INSERT INTO `apprenz_options` VALUES("9366", "_transient_geoip_198.12.152.170", "US", "no");
INSERT INTO `apprenz_options` VALUES("8133", "_transient_timeout_geoip_52.30.45.254", "1448523428", "no");
INSERT INTO `apprenz_options` VALUES("8134", "_transient_geoip_52.30.45.254", "US", "no");
INSERT INTO `apprenz_options` VALUES("8969", "_transient_timeout_geoip_185.2.131.75", "1449211869", "no");
INSERT INTO `apprenz_options` VALUES("8970", "_transient_geoip_185.2.131.75", "ES", "no");
INSERT INTO `apprenz_options` VALUES("8143", "_transient_timeout_geoip_78.85.5.175", "1448525100", "no");
INSERT INTO `apprenz_options` VALUES("8144", "_transient_geoip_78.85.5.175", "RU", "no");
INSERT INTO `apprenz_options` VALUES("9039", "_transient_timeout_geoip_162.144.85.112", "1449259224", "no");
INSERT INTO `apprenz_options` VALUES("9040", "_transient_geoip_162.144.85.112", "US", "no");
INSERT INTO `apprenz_options` VALUES("8934", "_transient_timeout_geoip_93.174.141.54", "1449171694", "no");
INSERT INTO `apprenz_options` VALUES("8935", "_transient_geoip_93.174.141.54", "GB", "no");
INSERT INTO `apprenz_options` VALUES("8151", "_transient_timeout_geoip_186.3.92.196", "1448535296", "no");
INSERT INTO `apprenz_options` VALUES("8152", "_transient_geoip_186.3.92.196", "EC", "no");
INSERT INTO `apprenz_options` VALUES("8154", "_transient_timeout_geoip_104.236.59.81", "1448535298", "no");
INSERT INTO `apprenz_options` VALUES("8155", "_transient_geoip_104.236.59.81", "US", "no");
INSERT INTO `apprenz_options` VALUES("8926", "_transient_timeout_geoip_185.2.131.210", "1449167544", "no");
INSERT INTO `apprenz_options` VALUES("8927", "_transient_geoip_185.2.131.210", "ES", "no");
INSERT INTO `apprenz_options` VALUES("8978", "_transient_timeout_geoip_96.127.132.58", "1449214413", "no");
INSERT INTO `apprenz_options` VALUES("8979", "_transient_geoip_96.127.132.58", "US", "no");
INSERT INTO `apprenz_options` VALUES("8160", "_transient_timeout_geoip_66.35.94.120", "1448536560", "no");
INSERT INTO `apprenz_options` VALUES("8161", "_transient_geoip_66.35.94.120", "US", "no");
INSERT INTO `apprenz_options` VALUES("8162", "_transient_timeout_geoip_2001:1528:123:72::97", "1448536602", "no");
INSERT INTO `apprenz_options` VALUES("8163", "_transient_geoip_2001:1528:123:72::97", "CZ", "no");
INSERT INTO `apprenz_options` VALUES("8164", "_transient_timeout_geoip_212.48.80.148", "1448537190", "no");
INSERT INTO `apprenz_options` VALUES("8165", "_transient_geoip_212.48.80.148", "GB", "no");
INSERT INTO `apprenz_options` VALUES("8166", "_transient_timeout_geoip_5.9.213.43", "1448539083", "no");
INSERT INTO `apprenz_options` VALUES("8167", "_transient_geoip_5.9.213.43", "DE", "no");
INSERT INTO `apprenz_options` VALUES("9168", "_transient_timeout_geoip_173.236.54.162", "1449374576", "no");
INSERT INTO `apprenz_options` VALUES("9169", "_transient_geoip_173.236.54.162", "US", "no");
INSERT INTO `apprenz_options` VALUES("8171", "_transient_timeout_geoip_74.109.213.194", "1448543423", "no");
INSERT INTO `apprenz_options` VALUES("8172", "_transient_geoip_74.109.213.194", "US", "no");
INSERT INTO `apprenz_options` VALUES("8174", "_transient_timeout_geoip_111.118.165.194", "1448545901", "no");
INSERT INTO `apprenz_options` VALUES("8175", "_transient_geoip_111.118.165.194", "AU", "no");
INSERT INTO `apprenz_options` VALUES("8176", "_transient_timeout_geoip_52.28.24.100", "1448547142", "no");
INSERT INTO `apprenz_options` VALUES("8177", "_transient_geoip_52.28.24.100", "US", "no");
INSERT INTO `apprenz_options` VALUES("9086", "_transient_timeout_geoip_188.165.118.117", "1449304302", "no");
INSERT INTO `apprenz_options` VALUES("9087", "_transient_geoip_188.165.118.117", "FR", "no");
INSERT INTO `apprenz_options` VALUES("8987", "_transient_timeout_geoip_184.170.151.20", "1449218839", "no");
INSERT INTO `apprenz_options` VALUES("8988", "_transient_geoip_184.170.151.20", "US", "no");
INSERT INTO `apprenz_options` VALUES("9042", "_transient_timeout_geoip_142.4.14.128", "1449259245", "no");
INSERT INTO `apprenz_options` VALUES("9043", "_transient_geoip_142.4.14.128", "US", "no");
INSERT INTO `apprenz_options` VALUES("8186", "_transient_timeout_geoip_78.129.211.205", "1448558214", "no");
INSERT INTO `apprenz_options` VALUES("8187", "_transient_geoip_78.129.211.205", "GB", "no");
INSERT INTO `apprenz_options` VALUES("9027", "_transient_timeout_geoip_91.217.232.65", "1449256651", "no");
INSERT INTO `apprenz_options` VALUES("9028", "_transient_geoip_91.217.232.65", "DE", "no");
INSERT INTO `apprenz_options` VALUES("8191", "_transient_timeout_geoip_198.55.115.130", "1448559672", "no");
INSERT INTO `apprenz_options` VALUES("8192", "_transient_geoip_198.55.115.130", "US", "no");
INSERT INTO `apprenz_options` VALUES("8193", "_transient_timeout_geoip_69.162.115.178", "1448559979", "no");
INSERT INTO `apprenz_options` VALUES("8194", "_transient_geoip_69.162.115.178", "US", "no");
INSERT INTO `apprenz_options` VALUES("8208", "_transient_timeout_geoip_66.249.75.19", "1448572561", "no");
INSERT INTO `apprenz_options` VALUES("8209", "_transient_geoip_66.249.75.19", "US", "no");
INSERT INTO `apprenz_options` VALUES("8210", "_transient_timeout_geoip_75.127.114.162", "1448574577", "no");
INSERT INTO `apprenz_options` VALUES("8211", "_transient_geoip_75.127.114.162", "US", "no");
INSERT INTO `apprenz_options` VALUES("9331", "_transient_timeout_geoip_179.61.12.103", "1449503721", "no");
INSERT INTO `apprenz_options` VALUES("9332", "_transient_geoip_179.61.12.103", "CL", "no");
INSERT INTO `apprenz_options` VALUES("8214", "_transient_timeout_geoip_65.99.201.29", "1448575301", "no");
INSERT INTO `apprenz_options` VALUES("8215", "_transient_geoip_65.99.201.29", "US", "no");
INSERT INTO `apprenz_options` VALUES("8217", "_transient_timeout_geoip_93.174.141.51", "1448576992", "no");
INSERT INTO `apprenz_options` VALUES("8218", "_transient_geoip_93.174.141.51", "GB", "no");
INSERT INTO `apprenz_options` VALUES("8960", "_transient_timeout_geoip_74.124.214.251", "1449203897", "no");
INSERT INTO `apprenz_options` VALUES("8961", "_transient_geoip_74.124.214.251", "US", "no");
INSERT INTO `apprenz_options` VALUES("8221", "_transient_timeout_geoip_83.223.124.24", "1448578650", "no");
INSERT INTO `apprenz_options` VALUES("8222", "_transient_geoip_83.223.124.24", "GB", "no");
INSERT INTO `apprenz_options` VALUES("8223", "_transient_timeout_geoip_81.21.70.227", "1448579597", "no");
INSERT INTO `apprenz_options` VALUES("8224", "_transient_geoip_81.21.70.227", "GB", "no");
INSERT INTO `apprenz_options` VALUES("9001", "_transient_timeout_geoip_103.244.44.76", "1449223748", "no");
INSERT INTO `apprenz_options` VALUES("9002", "_transient_geoip_103.244.44.76", "HK", "no");
INSERT INTO `apprenz_options` VALUES("8227", "_transient_timeout_geoip_66.249.75.27", "1448579767", "no");
INSERT INTO `apprenz_options` VALUES("8228", "_transient_geoip_66.249.75.27", "US", "no");
INSERT INTO `apprenz_options` VALUES("9305", "_transient_timeout_geoip_192.254.140.9", "1449477373", "no");
INSERT INTO `apprenz_options` VALUES("9306", "_transient_geoip_192.254.140.9", "US", "no");
INSERT INTO `apprenz_options` VALUES("9205", "_transient_timeout_geoip_213.184.113.29", "1449402711", "no");
INSERT INTO `apprenz_options` VALUES("8232", "_transient_timeout_geoip_192.40.114.82", "1448581247", "no");
INSERT INTO `apprenz_options` VALUES("8233", "_transient_geoip_192.40.114.82", "US", "no");
INSERT INTO `apprenz_options` VALUES("9206", "_transient_geoip_213.184.113.29", "IL", "no");
INSERT INTO `apprenz_options` VALUES("8236", "_transient_timeout_geoip_94.229.164.68", "1448584299", "no");
INSERT INTO `apprenz_options` VALUES("8237", "_transient_geoip_94.229.164.68", "GB", "no");
INSERT INTO `apprenz_options` VALUES("8240", "_transient_timeout_geoip_31.184.197.106", "1448585297", "no");
INSERT INTO `apprenz_options` VALUES("8241", "_transient_geoip_31.184.197.106", "RU", "no");
INSERT INTO `apprenz_options` VALUES("8242", "_transient_timeout_geoip_23.97.233.197", "1448585488", "no");
INSERT INTO `apprenz_options` VALUES("8243", "_transient_geoip_23.97.233.197", "US", "no");
INSERT INTO `apprenz_options` VALUES("8244", "_transient_timeout_geoip_93.179.91.189", "1448589062", "no");
INSERT INTO `apprenz_options` VALUES("8245", "_transient_geoip_93.179.91.189", "RU", "no");
INSERT INTO `apprenz_options` VALUES("8247", "_transient_timeout_geoip_192.198.87.42", "1448589749", "no");
INSERT INTO `apprenz_options` VALUES("8248", "_transient_geoip_192.198.87.42", "US", "no");
INSERT INTO `apprenz_options` VALUES("8250", "_transient_timeout_geoip_192.168.2.10", "1448600477", "no");
INSERT INTO `apprenz_options` VALUES("8251", "_transient_geoip_192.168.2.10", "", "no");
INSERT INTO `apprenz_options` VALUES("8252", "_transient_timeout_external_ip_address_192.168.2.10", "1448600478", "no");
INSERT INTO `apprenz_options` VALUES("8253", "_transient_external_ip_address_192.168.2.10", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("9046", "_transient_timeout_geoip_92.43.23.151", "1449264132", "no");
INSERT INTO `apprenz_options` VALUES("9047", "_transient_geoip_92.43.23.151", "ES", "no");
INSERT INTO `apprenz_options` VALUES("8258", "_transient_timeout_geoip_180.76.15.137", "1448601884", "no");
INSERT INTO `apprenz_options` VALUES("8259", "_transient_geoip_180.76.15.137", "CN", "no");
INSERT INTO `apprenz_options` VALUES("8260", "_transient_timeout_geoip_180.76.15.23", "1448601991", "no");
INSERT INTO `apprenz_options` VALUES("8261", "_transient_geoip_180.76.15.23", "CN", "no");
INSERT INTO `apprenz_options` VALUES("9120", "_transient_timeout_geoip_211.9.64.2", "1449344528", "no");
INSERT INTO `apprenz_options` VALUES("9121", "_transient_geoip_211.9.64.2", "JP", "no");
INSERT INTO `apprenz_options` VALUES("8270", "_transient_timeout_geoip_96.127.172.98", "1448605534", "no");
INSERT INTO `apprenz_options` VALUES("8271", "_transient_geoip_96.127.172.98", "US", "no");
INSERT INTO `apprenz_options` VALUES("8272", "_transient_timeout_geoip_188.163.110.32", "1448611562", "no");
INSERT INTO `apprenz_options` VALUES("30615", "_transient_external_ip_address_102.169.11.82", "503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.", "no");
INSERT INTO `apprenz_options` VALUES("14525", "_transient_timeout_external_ip_address_192.168.28.168", "1463077859", "no");
INSERT INTO `apprenz_options` VALUES("14526", "_transient_external_ip_address_192.168.28.168", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("14661", "_transient_timeout_external_ip_address_192.168.0.41", "1463274318", "no");
INSERT INTO `apprenz_options` VALUES("14662", "_transient_external_ip_address_192.168.0.41", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("14713", "_transient_timeout_external_ip_address_10.128.129.139", "1463377022", "no");
INSERT INTO `apprenz_options` VALUES("14714", "_transient_external_ip_address_10.128.129.139", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("14731", "_transient_timeout_external_ip_address_192.168.253.58", "1463416309", "no");
INSERT INTO `apprenz_options` VALUES("14732", "_transient_external_ip_address_192.168.253.58", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("14734", "_transient_timeout_external_ip_address_10.130.6.24", "1463418520", "no");
INSERT INTO `apprenz_options` VALUES("14735", "_transient_external_ip_address_10.130.6.24", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("14736", "_transient_timeout_external_ip_address_10.195.31.11", "1463420374", "no");
INSERT INTO `apprenz_options` VALUES("10703", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:19:\"contact@apprenz.com\";s:7:\"version\";s:6:\"4.3.20\";s:9:\"timestamp\";i:1567663595;}", "yes");
INSERT INTO `apprenz_options` VALUES("11173", "_transient_external_ip_address_10.100.100.9", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("11211", "_transient_timeout_external_ip_address_192.168.64.245", "1454513183", "no");
INSERT INTO `apprenz_options` VALUES("11212", "_transient_external_ip_address_192.168.64.245", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("8273", "_transient_geoip_188.163.110.32", "UA", "no");
INSERT INTO `apprenz_options` VALUES("8280", "_transient_timeout_geoip_38.100.21.63", "1448618230", "no");
INSERT INTO `apprenz_options` VALUES("8281", "_transient_geoip_38.100.21.63", "US", "no");
INSERT INTO `apprenz_options` VALUES("9344", "_transient_timeout_geoip_89.201.175.24", "1449509334", "no");
INSERT INTO `apprenz_options` VALUES("9345", "_transient_geoip_89.201.175.24", "HR", "no");
INSERT INTO `apprenz_options` VALUES("8285", "_transient_timeout_geoip_198.96.155.3", "1448620285", "no");
INSERT INTO `apprenz_options` VALUES("8286", "_transient_geoip_198.96.155.3", "CA", "no");
INSERT INTO `apprenz_options` VALUES("8287", "_transient_timeout_geoip_212.47.234.38", "1448620288", "no");
INSERT INTO `apprenz_options` VALUES("8288", "_transient_geoip_212.47.234.38", "FR", "no");
INSERT INTO `apprenz_options` VALUES("8289", "_transient_timeout_geoip_193.111.136.162", "1448620291", "no");
INSERT INTO `apprenz_options` VALUES("8290", "_transient_geoip_193.111.136.162", "DE", "no");
INSERT INTO `apprenz_options` VALUES("8291", "_transient_timeout_geoip_194.150.168.95", "1448620301", "no");
INSERT INTO `apprenz_options` VALUES("8292", "_transient_geoip_194.150.168.95", "DE", "no");
INSERT INTO `apprenz_options` VALUES("8293", "_transient_timeout_geoip_129.123.7.6", "1448620314", "no");
INSERT INTO `apprenz_options` VALUES("8294", "_transient_geoip_129.123.7.6", "US", "no");
INSERT INTO `apprenz_options` VALUES("9163", "_transient_timeout_geoip_2607:fb50:131:95:230:48ff:fe95:3f68", "1449373417", "no");
INSERT INTO `apprenz_options` VALUES("9164", "_transient_geoip_2607:fb50:131:95:230:48ff:fe95:3f68", "US", "no");
INSERT INTO `apprenz_options` VALUES("9088", "_transient_timeout_geoip_2a02:af8:9:700::1:2884", "1449304824", "no");
INSERT INTO `apprenz_options` VALUES("9089", "_transient_geoip_2a02:af8:9:700::1:2884", "GB", "no");
INSERT INTO `apprenz_options` VALUES("8301", "_transient_timeout_geoip_2a02:2498:1:227:225:90ff:feaa:a912", "1448626684", "no");
INSERT INTO `apprenz_options` VALUES("8302", "_transient_geoip_2a02:2498:1:227:225:90ff:feaa:a912", "GB", "no");
INSERT INTO `apprenz_options` VALUES("9255", "_transient_timeout_geoip_141.0.227.19", "1449445839", "no");
INSERT INTO `apprenz_options` VALUES("9256", "_transient_geoip_141.0.227.19", "NO", "no");
INSERT INTO `apprenz_options` VALUES("9209", "_transient_timeout_geoip_91.121.179.219", "1449402954", "no");
INSERT INTO `apprenz_options` VALUES("9210", "_transient_geoip_91.121.179.219", "FR", "no");
INSERT INTO `apprenz_options` VALUES("8308", "_transient_timeout_geoip_190.42.178.159", "1448631643", "no");
INSERT INTO `apprenz_options` VALUES("8309", "_transient_geoip_190.42.178.159", "PE", "no");
INSERT INTO `apprenz_options` VALUES("8310", "_transient_timeout_geoip_200.29.169.242", "1448634318", "no");
INSERT INTO `apprenz_options` VALUES("8311", "_transient_geoip_200.29.169.242", "CL", "no");
INSERT INTO `apprenz_options` VALUES("8313", "_transient_timeout_geoip_107.181.162.129", "1448634485", "no");
INSERT INTO `apprenz_options` VALUES("8314", "_transient_geoip_107.181.162.129", "US", "no");
INSERT INTO `apprenz_options` VALUES("9107", "_transient_timeout_geoip_108.168.167.130", "1449324963", "no");
INSERT INTO `apprenz_options` VALUES("9108", "_transient_geoip_108.168.167.130", "US", "no");
INSERT INTO `apprenz_options` VALUES("8318", "_transient_timeout_geoip_184.170.240.130", "1448644070", "no");
INSERT INTO `apprenz_options` VALUES("8319", "_transient_geoip_184.170.240.130", "US", "no");
INSERT INTO `apprenz_options` VALUES("9128", "_transient_timeout_geoip_97.79.237.63", "1449346051", "no");
INSERT INTO `apprenz_options` VALUES("9129", "_transient_geoip_97.79.237.63", "US", "no");
INSERT INTO `apprenz_options` VALUES("8323", "_transient_timeout_geoip_184.154.52.30", "1448647696", "no");
INSERT INTO `apprenz_options` VALUES("8324", "_transient_geoip_184.154.52.30", "US", "no");
INSERT INTO `apprenz_options` VALUES("8331", "_transient_timeout_geoip_216.185.52.32", "1448648174", "no");
INSERT INTO `apprenz_options` VALUES("8332", "_transient_geoip_216.185.52.32", "US", "no");
INSERT INTO `apprenz_options` VALUES("8334", "_transient_timeout_geoip_66.45.228.80", "1448648613", "no");
INSERT INTO `apprenz_options` VALUES("8335", "_transient_geoip_66.45.228.80", "US", "no");
INSERT INTO `apprenz_options` VALUES("9084", "_transient_timeout_geoip_198.154.250.247", "1449302952", "no");
INSERT INTO `apprenz_options` VALUES("9085", "_transient_geoip_198.154.250.247", "US", "no");
INSERT INTO `apprenz_options` VALUES("8346", "_transient_timeout_geoip_66.249.64.189", "1448654131", "no");
INSERT INTO `apprenz_options` VALUES("8347", "_transient_geoip_66.249.64.189", "US", "no");
INSERT INTO `apprenz_options` VALUES("8348", "_transient_timeout_geoip_204.77.2.185", "1448654994", "no");
INSERT INTO `apprenz_options` VALUES("8349", "_transient_geoip_204.77.2.185", "US", "no");
INSERT INTO `apprenz_options` VALUES("8350", "_transient_timeout_geoip_52.31.117.155", "1448662668", "no");
INSERT INTO `apprenz_options` VALUES("8351", "_transient_geoip_52.31.117.155", "US", "no");
INSERT INTO `apprenz_options` VALUES("8353", "_transient_timeout_geoip_216.244.85.148", "1448665035", "no");
INSERT INTO `apprenz_options` VALUES("8354", "_transient_geoip_216.244.85.148", "US", "no");
INSERT INTO `apprenz_options` VALUES("8355", "_transient_timeout_geoip_103.231.43.233", "1448668536", "no");
INSERT INTO `apprenz_options` VALUES("8356", "_transient_geoip_103.231.43.233", "IN", "no");
INSERT INTO `apprenz_options` VALUES("8358", "_transient_timeout_geoip_180.76.15.28", "1448672041", "no");
INSERT INTO `apprenz_options` VALUES("8359", "_transient_geoip_180.76.15.28", "CN", "no");
INSERT INTO `apprenz_options` VALUES("9090", "_transient_timeout_geoip_205.251.134.99", "1449305801", "no");
INSERT INTO `apprenz_options` VALUES("9091", "_transient_geoip_205.251.134.99", "US", "no");
INSERT INTO `apprenz_options` VALUES("8363", "_transient_timeout_geoip_37.61.233.89", "1448677716", "no");
INSERT INTO `apprenz_options` VALUES("8364", "_transient_geoip_37.61.233.89", "GB", "no");
INSERT INTO `apprenz_options` VALUES("8365", "_transient_timeout_geoip_198.24.160.250", "1448677934", "no");
INSERT INTO `apprenz_options` VALUES("8366", "_transient_geoip_198.24.160.250", "US", "no");
INSERT INTO `apprenz_options` VALUES("9236", "_transient_timeout_geoip_192.199.240.34", "1449429826", "no");
INSERT INTO `apprenz_options` VALUES("9237", "_transient_geoip_192.199.240.34", "US", "no");
INSERT INTO `apprenz_options` VALUES("8370", "_transient_timeout_geoip_192.228.111.158", "1448683312", "no");
INSERT INTO `apprenz_options` VALUES("8371", "_transient_geoip_192.228.111.158", "US", "no");
INSERT INTO `apprenz_options` VALUES("9137", "_transient_timeout_geoip_63.145.169.11", "1449350736", "no");
INSERT INTO `apprenz_options` VALUES("9138", "_transient_geoip_63.145.169.11", "US", "no");
INSERT INTO `apprenz_options` VALUES("8375", "_transient_timeout_geoip_194.50.116.225", "1448685682", "no");
INSERT INTO `apprenz_options` VALUES("8376", "_transient_geoip_194.50.116.225", "RU", "no");
INSERT INTO `apprenz_options` VALUES("8385", "_transient_timeout_geoip_216.244.83.149", "1448701795", "no");
INSERT INTO `apprenz_options` VALUES("8386", "_transient_geoip_216.244.83.149", "US", "no");
INSERT INTO `apprenz_options` VALUES("9200", "_transient_timeout_geoip_176.31.103.124", "1449400375", "no");
INSERT INTO `apprenz_options` VALUES("9201", "_transient_geoip_176.31.103.124", "FR", "no");
INSERT INTO `apprenz_options` VALUES("8396", "_transient_timeout_geoip_200.238.102.235", "1448711043", "no");
INSERT INTO `apprenz_options` VALUES("8397", "_transient_geoip_200.238.102.235", "BR", "no");
INSERT INTO `apprenz_options` VALUES("8399", "_transient_timeout_geoip_188.163.109.35", "1448712271", "no");
INSERT INTO `apprenz_options` VALUES("8400", "_transient_geoip_188.163.109.35", "UA", "no");
INSERT INTO `apprenz_options` VALUES("8401", "_transient_timeout_geoip_176.97.116.136", "1448712412", "no");
INSERT INTO `apprenz_options` VALUES("8402", "_transient_geoip_176.97.116.136", "UA", "no");
INSERT INTO `apprenz_options` VALUES("8403", "_transient_timeout_geoip_182.50.129.155", "1448712577", "no");
INSERT INTO `apprenz_options` VALUES("8404", "_transient_geoip_182.50.129.155", "SG", "no");
INSERT INTO `apprenz_options` VALUES("8405", "_transient_timeout_geoip_198.1.127.114", "1448713164", "no");
INSERT INTO `apprenz_options` VALUES("8406", "_transient_geoip_198.1.127.114", "US", "no");
INSERT INTO `apprenz_options` VALUES("8407", "_transient_timeout_geoip_173.199.176.200", "1448715785", "no");
INSERT INTO `apprenz_options` VALUES("8408", "_transient_geoip_173.199.176.200", "US", "no");
INSERT INTO `apprenz_options` VALUES("9309", "_transient_timeout_geoip_140.125.80.4", "1449479145", "no");
INSERT INTO `apprenz_options` VALUES("9310", "_transient_geoip_140.125.80.4", "TW", "no");
INSERT INTO `apprenz_options` VALUES("8413", "_transient_timeout_geoip_157.55.39.231", "1448722576", "no");
INSERT INTO `apprenz_options` VALUES("8414", "_transient_geoip_157.55.39.231", "US", "no");
INSERT INTO `apprenz_options` VALUES("8416", "_transient_timeout_geoip_155.94.221.26", "1448727837", "no");
INSERT INTO `apprenz_options` VALUES("8417", "_transient_geoip_155.94.221.26", "US", "no");
INSERT INTO `apprenz_options` VALUES("8419", "_transient_timeout_geoip_104.143.27.223", "1448728513", "no");
INSERT INTO `apprenz_options` VALUES("8420", "_transient_geoip_104.143.27.223", "BW", "no");
INSERT INTO `apprenz_options` VALUES("8428", "_transient_timeout_geoip_46.148.18.226", "1448738912", "no");
INSERT INTO `apprenz_options` VALUES("8429", "_transient_geoip_46.148.18.226", "LT", "no");
INSERT INTO `apprenz_options` VALUES("8430", "_transient_timeout_geoip_37.72.188.202", "1448742742", "no");
INSERT INTO `apprenz_options` VALUES("8431", "_transient_geoip_37.72.188.202", "SE", "no");
INSERT INTO `apprenz_options` VALUES("8439", "_transient_timeout_geoip_208.115.124.13", "1448747973", "no");
INSERT INTO `apprenz_options` VALUES("8440", "_transient_geoip_208.115.124.13", "US", "no");
INSERT INTO `apprenz_options` VALUES("9195", "_transient_timeout_geoip_198.1.71.253", "1449394649", "no");
INSERT INTO `apprenz_options` VALUES("9196", "_transient_geoip_198.1.71.253", "US", "no");
INSERT INTO `apprenz_options` VALUES("9372", "_transient_timeout_geoip_2001:41d0:2:5cc9::", "1449531042", "no");
INSERT INTO `apprenz_options` VALUES("9373", "_transient_geoip_2001:41d0:2:5cc9::", "FR", "no");
INSERT INTO `apprenz_options` VALUES("8447", "_transient_timeout_geoip_108.163.234.98", "1448755662", "no");
INSERT INTO `apprenz_options` VALUES("8448", "_transient_geoip_108.163.234.98", "US", "no");
INSERT INTO `apprenz_options` VALUES("8450", "_transient_timeout_geoip_88.198.49.91", "1448756768", "no");
INSERT INTO `apprenz_options` VALUES("8451", "_transient_geoip_88.198.49.91", "DE", "no");
INSERT INTO `apprenz_options` VALUES("8452", "_transient_timeout_geoip_62.210.250.66", "1448759487", "no");
INSERT INTO `apprenz_options` VALUES("8453", "_transient_geoip_62.210.250.66", "FR", "no");
INSERT INTO `apprenz_options` VALUES("8455", "_transient_timeout_geoip_66.249.64.194", "1448761216", "no");
INSERT INTO `apprenz_options` VALUES("8456", "_transient_geoip_66.249.64.194", "US", "no");
INSERT INTO `apprenz_options` VALUES("8457", "_transient_timeout_geoip_208.115.111.69", "1448767972", "no");
INSERT INTO `apprenz_options` VALUES("8458", "_transient_geoip_208.115.111.69", "US", "no");
INSERT INTO `apprenz_options` VALUES("8460", "_transient_timeout_geoip_166.62.103.61", "1448772733", "no");
INSERT INTO `apprenz_options` VALUES("8461", "_transient_geoip_166.62.103.61", "US", "no");
INSERT INTO `apprenz_options` VALUES("8463", "_transient_timeout_geoip_91.121.162.191", "1448776943", "no");
INSERT INTO `apprenz_options` VALUES("8464", "_transient_geoip_91.121.162.191", "FR", "no");
INSERT INTO `apprenz_options` VALUES("8475", "_transient_timeout_geoip_209.212.145.104", "1448786568", "no");
INSERT INTO `apprenz_options` VALUES("8476", "_transient_geoip_209.212.145.104", "US", "no");
INSERT INTO `apprenz_options` VALUES("9318", "_transient_timeout_geoip_46.4.76.113", "1449483460", "no");
INSERT INTO `apprenz_options` VALUES("9319", "_transient_geoip_46.4.76.113", "DE", "no");
INSERT INTO `apprenz_options` VALUES("9202", "_transient_timeout_geoip_199.116.253.18", "1449402366", "no");
INSERT INTO `apprenz_options` VALUES("9203", "_transient_geoip_199.116.253.18", "US", "no");
INSERT INTO `apprenz_options` VALUES("8482", "_transient_timeout_geoip_184.170.242.10", "1448795377", "no");
INSERT INTO `apprenz_options` VALUES("8483", "_transient_geoip_184.170.242.10", "US", "no");
INSERT INTO `apprenz_options` VALUES("9282", "_transient_timeout_geoip_41.169.28.22", "1449466323", "no");
INSERT INTO `apprenz_options` VALUES("9283", "_transient_geoip_41.169.28.22", "ZA", "no");
INSERT INTO `apprenz_options` VALUES("8487", "_transient_timeout_geoip_107.6.46.36", "1448796298", "no");
INSERT INTO `apprenz_options` VALUES("8488", "_transient_geoip_107.6.46.36", "US", "no");
INSERT INTO `apprenz_options` VALUES("8489", "_transient_timeout_geoip_54.146.131.213", "1448800484", "no");
INSERT INTO `apprenz_options` VALUES("8490", "_transient_geoip_54.146.131.213", "US", "no");
INSERT INTO `apprenz_options` VALUES("8492", "_transient_timeout_geoip_41.231.232.241", "1448803199", "no");
INSERT INTO `apprenz_options` VALUES("8493", "_transient_geoip_41.231.232.241", "TN", "no");
INSERT INTO `apprenz_options` VALUES("8494", "_transient_timeout_geoip_5.189.200.116", "1448805372", "no");
INSERT INTO `apprenz_options` VALUES("8495", "_transient_geoip_5.189.200.116", "ZA", "no");
INSERT INTO `apprenz_options` VALUES("8497", "_transient_timeout_geoip_217.78.29.57", "1448806276", "no");
INSERT INTO `apprenz_options` VALUES("8498", "_transient_geoip_217.78.29.57", "SE", "no");
INSERT INTO `apprenz_options` VALUES("8499", "_transient_timeout_geoip_107.190.163.9", "1448813081", "no");
INSERT INTO `apprenz_options` VALUES("8500", "_transient_geoip_107.190.163.9", "IE", "no");
INSERT INTO `apprenz_options` VALUES("8502", "_transient_timeout_geoip_107.21.1.8", "1448816991", "no");
INSERT INTO `apprenz_options` VALUES("8503", "_transient_geoip_107.21.1.8", "US", "no");
INSERT INTO `apprenz_options` VALUES("8505", "_transient_timeout_geoip_195.154.227.118", "1448821284", "no");
INSERT INTO `apprenz_options` VALUES("8506", "_transient_geoip_195.154.227.118", "FR", "no");
INSERT INTO `apprenz_options` VALUES("9375", "_transient_timeout_geoip_78.40.120.230", "1449531911", "no");
INSERT INTO `apprenz_options` VALUES("9376", "_transient_geoip_78.40.120.230", "FR", "no");
INSERT INTO `apprenz_options` VALUES("9334", "_transient_timeout_geoip_192.99.166.236", "1449508061", "no");
INSERT INTO `apprenz_options` VALUES("9335", "_transient_geoip_192.99.166.236", "CA", "no");
INSERT INTO `apprenz_options` VALUES("8524", "_transient_timeout_geoip_104.140.71.152", "1448832467", "no");
INSERT INTO `apprenz_options` VALUES("8525", "_transient_geoip_104.140.71.152", "US", "no");
INSERT INTO `apprenz_options` VALUES("8526", "_transient_timeout_geoip_66.71.249.41", "1448833999", "no");
INSERT INTO `apprenz_options` VALUES("8527", "_transient_geoip_66.71.249.41", "US", "no");
INSERT INTO `apprenz_options` VALUES("8529", "_transient_timeout_geoip_182.18.170.67", "1448837830", "no");
INSERT INTO `apprenz_options` VALUES("8530", "_transient_geoip_182.18.170.67", "IN", "no");
INSERT INTO `apprenz_options` VALUES("9327", "_transient_timeout_geoip_154.50.0.75", "1449497574", "no");
INSERT INTO `apprenz_options` VALUES("9328", "_transient_geoip_154.50.0.75", "US", "no");
INSERT INTO `apprenz_options` VALUES("8535", "_transient_timeout_geoip_213.61.149.100", "1448846247", "no");
INSERT INTO `apprenz_options` VALUES("8536", "_transient_geoip_213.61.149.100", "DE", "no");
INSERT INTO `apprenz_options` VALUES("8537", "_transient_timeout_geoip_185.24.98.84", "1448850186", "no");
INSERT INTO `apprenz_options` VALUES("8538", "_transient_geoip_185.24.98.84", "GB", "no");
INSERT INTO `apprenz_options` VALUES("8559", "_transient_timeout_geoip_157.55.39.78", "1448873303", "no");
INSERT INTO `apprenz_options` VALUES("8560", "_transient_geoip_157.55.39.78", "US", "no");
INSERT INTO `apprenz_options` VALUES("8561", "_transient_timeout_geoip_188.163.109.46", "1448874110", "no");
INSERT INTO `apprenz_options` VALUES("8562", "_transient_geoip_188.163.109.46", "UA", "no");
INSERT INTO `apprenz_options` VALUES("8563", "_transient_timeout_geoip_62.210.37.113", "1448875202", "no");
INSERT INTO `apprenz_options` VALUES("8564", "_transient_geoip_62.210.37.113", "FR", "no");
INSERT INTO `apprenz_options` VALUES("8566", "_transient_timeout_geoip_31.187.76.99", "1448878004", "no");
INSERT INTO `apprenz_options` VALUES("8567", "_transient_geoip_31.187.76.99", "NL", "no");
INSERT INTO `apprenz_options` VALUES("8568", "_transient_timeout_geoip_212.19.118.245", "1448879945", "no");
INSERT INTO `apprenz_options` VALUES("8569", "_transient_geoip_212.19.118.245", "IT", "no");
INSERT INTO `apprenz_options` VALUES("8575", "_transient_timeout_geoip_198.154.238.249", "1448885705", "no");
INSERT INTO `apprenz_options` VALUES("8571", "_transient_timeout_geoip_72.249.26.23", "1448880523", "no");
INSERT INTO `apprenz_options` VALUES("8572", "_transient_geoip_72.249.26.23", "US", "no");
INSERT INTO `apprenz_options` VALUES("8576", "_transient_geoip_198.154.238.249", "US", "no");
INSERT INTO `apprenz_options` VALUES("8580", "_transient_timeout_geoip_206.72.207.76", "1448888149", "no");
INSERT INTO `apprenz_options` VALUES("8581", "_transient_geoip_206.72.207.76", "US", "no");
INSERT INTO `apprenz_options` VALUES("8583", "_transient_timeout_geoip_131.156.157.53", "1448899766", "no");
INSERT INTO `apprenz_options` VALUES("8584", "_transient_geoip_131.156.157.53", "US", "no");
INSERT INTO `apprenz_options` VALUES("8585", "_transient_timeout_geoip_216.158.202.202", "1448903100", "no");
INSERT INTO `apprenz_options` VALUES("8586", "_transient_geoip_216.158.202.202", "US", "no");
INSERT INTO `apprenz_options` VALUES("8594", "_transient_timeout_geoip_185.75.58.9", "1448910074", "no");
INSERT INTO `apprenz_options` VALUES("8595", "_transient_geoip_185.75.58.9", "RS", "no");
INSERT INTO `apprenz_options` VALUES("8605", "_transient_timeout_geoip_118.139.177.72", "1448915873", "no");
INSERT INTO `apprenz_options` VALUES("8606", "_transient_geoip_118.139.177.72", "SG", "no");
INSERT INTO `apprenz_options` VALUES("8609", "_transient_timeout_geoip_216.158.218.116", "1448916151", "no");
INSERT INTO `apprenz_options` VALUES("8610", "_transient_geoip_216.158.218.116", "US", "no");
INSERT INTO `apprenz_options` VALUES("9370", "_transient_timeout_geoip_162.144.85.203", "1449530192", "no");
INSERT INTO `apprenz_options` VALUES("9371", "_transient_geoip_162.144.85.203", "US", "no");
INSERT INTO `apprenz_options` VALUES("8617", "_transient_timeout_geoip_185.93.185.200", "1448923529", "no");
INSERT INTO `apprenz_options` VALUES("8618", "_transient_geoip_185.93.185.200", "", "no");
INSERT INTO `apprenz_options` VALUES("8619", "_transient_timeout_external_ip_address_185.93.185.200", "1448923530", "no");
INSERT INTO `apprenz_options` VALUES("8620", "_transient_external_ip_address_185.93.185.200", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("8624", "_transient_timeout_geoip_64.79.100.19", "1448930337", "no");
INSERT INTO `apprenz_options` VALUES("8625", "_transient_geoip_64.79.100.19", "US", "no");
INSERT INTO `apprenz_options` VALUES("8627", "_transient_timeout_geoip_142.4.19.92", "1448933259", "no");
INSERT INTO `apprenz_options` VALUES("8628", "_transient_geoip_142.4.19.92", "US", "no");
INSERT INTO `apprenz_options` VALUES("8629", "_transient_timeout_geoip_185.44.79.87", "1448934989", "no");
INSERT INTO `apprenz_options` VALUES("8630", "_transient_geoip_185.44.79.87", "GB", "no");
INSERT INTO `apprenz_options` VALUES("8632", "_transient_timeout_geoip_66.249.64.199", "1448944505", "no");
INSERT INTO `apprenz_options` VALUES("8633", "_transient_geoip_66.249.64.199", "US", "no");
INSERT INTO `apprenz_options` VALUES("8635", "_transient_timeout_geoip_91.250.15.107", "1448947140", "no");
INSERT INTO `apprenz_options` VALUES("8636", "_transient_geoip_91.250.15.107", "UA", "no");
INSERT INTO `apprenz_options` VALUES("8650", "_transient_timeout_geoip_66.249.64.102", "1448959600", "no");
INSERT INTO `apprenz_options` VALUES("8651", "_transient_geoip_66.249.64.102", "US", "no");
INSERT INTO `apprenz_options` VALUES("8661", "_transient_timeout_geoip_5.61.36.67", "1448992081", "no");
INSERT INTO `apprenz_options` VALUES("8662", "_transient_geoip_5.61.36.67", "DE", "no");
INSERT INTO `apprenz_options` VALUES("8671", "_transient_timeout_geoip_40.124.9.65", "1448995478", "no");
INSERT INTO `apprenz_options` VALUES("8672", "_transient_geoip_40.124.9.65", "US", "no");
INSERT INTO `apprenz_options` VALUES("8673", "_transient_timeout_geoip_169.55.34.228", "1448995669", "no");
INSERT INTO `apprenz_options` VALUES("8674", "_transient_geoip_169.55.34.228", "US", "no");
INSERT INTO `apprenz_options` VALUES("8677", "_transient_timeout_geoip_159.203.139.30", "1448997140", "no");
INSERT INTO `apprenz_options` VALUES("8678", "_transient_geoip_159.203.139.30", "US", "no");
INSERT INTO `apprenz_options` VALUES("8686", "_transient_timeout_geoip_54.251.55.201", "1449003434", "no");
INSERT INTO `apprenz_options` VALUES("8687", "_transient_geoip_54.251.55.201", "SG", "no");
INSERT INTO `apprenz_options` VALUES("8691", "_transient_timeout_geoip_37.187.77.154", "1449004859", "no");
INSERT INTO `apprenz_options` VALUES("8692", "_transient_geoip_37.187.77.154", "FR", "no");
INSERT INTO `apprenz_options` VALUES("8693", "_transient_timeout_geoip_2001:df0:bc:b::6:1", "1449005065", "no");
INSERT INTO `apprenz_options` VALUES("8694", "_transient_geoip_2001:df0:bc:b::6:1", "ID", "no");
INSERT INTO `apprenz_options` VALUES("8698", "_transient_timeout_geoip_109.205.136.225", "1449017464", "no");
INSERT INTO `apprenz_options` VALUES("8699", "_transient_geoip_109.205.136.225", "ES", "no");
INSERT INTO `apprenz_options` VALUES("8704", "_transient_timeout_geoip_95.154.250.29", "1449024181", "no");
INSERT INTO `apprenz_options` VALUES("8705", "_transient_geoip_95.154.250.29", "GB", "no");
INSERT INTO `apprenz_options` VALUES("8706", "_transient_timeout_geoip_146.185.202.4", "1449025348", "no");
INSERT INTO `apprenz_options` VALUES("8707", "_transient_geoip_146.185.202.4", "RU", "no");
INSERT INTO `apprenz_options` VALUES("8711", "_transient_timeout_geoip_190.109.204.206", "1449027617", "no");
INSERT INTO `apprenz_options` VALUES("8712", "_transient_geoip_190.109.204.206", "HN", "no");
INSERT INTO `apprenz_options` VALUES("8713", "_transient_timeout_geoip_91.212.124.19", "1449027789", "no");
INSERT INTO `apprenz_options` VALUES("8714", "_transient_geoip_91.212.124.19", "UA", "no");
INSERT INTO `apprenz_options` VALUES("8715", "_transient_timeout_geoip_189.113.170.101", "1449028263", "no");
INSERT INTO `apprenz_options` VALUES("8716", "_transient_geoip_189.113.170.101", "BR", "no");
INSERT INTO `apprenz_options` VALUES("8718", "_transient_timeout_geoip_52.21.253.1", "1449034636", "no");
INSERT INTO `apprenz_options` VALUES("8719", "_transient_geoip_52.21.253.1", "US", "no");
INSERT INTO `apprenz_options` VALUES("8727", "_transient_timeout_geoip_188.163.109.76", "1449039787", "no");
INSERT INTO `apprenz_options` VALUES("8728", "_transient_geoip_188.163.109.76", "UA", "no");
INSERT INTO `apprenz_options` VALUES("8736", "_transient_timeout_geoip_194.69.248.115", "1449046696", "no");
INSERT INTO `apprenz_options` VALUES("8737", "_transient_geoip_194.69.248.115", "ES", "no");
INSERT INTO `apprenz_options` VALUES("8739", "_transient_timeout_geoip_66.249.75.11", "1449047926", "no");
INSERT INTO `apprenz_options` VALUES("8740", "_transient_geoip_66.249.75.11", "US", "no");
INSERT INTO `apprenz_options` VALUES("8741", "_transient_timeout_geoip_108.178.51.138", "1449049023", "no");
INSERT INTO `apprenz_options` VALUES("8742", "_transient_geoip_108.178.51.138", "US", "no");
INSERT INTO `apprenz_options` VALUES("8744", "_transient_timeout_geoip_188.143.232.224", "1449051826", "no");
INSERT INTO `apprenz_options` VALUES("8745", "_transient_geoip_188.143.232.224", "RU", "no");
INSERT INTO `apprenz_options` VALUES("8746", "_transient_timeout_geoip_200.72.159.9", "1449052493", "no");
INSERT INTO `apprenz_options` VALUES("8747", "_transient_geoip_200.72.159.9", "CL", "no");
INSERT INTO `apprenz_options` VALUES("8748", "_transient_timeout_geoip_209.23.242.12", "1449054549", "no");
INSERT INTO `apprenz_options` VALUES("8749", "_transient_geoip_209.23.242.12", "US", "no");
INSERT INTO `apprenz_options` VALUES("8751", "_transient_timeout_geoip_2a00:1ed0:1:500::a020", "1449057025", "no");
INSERT INTO `apprenz_options` VALUES("8752", "_transient_geoip_2a00:1ed0:1:500::a020", "CZ", "no");
INSERT INTO `apprenz_options` VALUES("8753", "_transient_timeout_geoip_69.175.97.146", "1449060904", "no");
INSERT INTO `apprenz_options` VALUES("8754", "_transient_geoip_69.175.97.146", "US", "no");
INSERT INTO `apprenz_options` VALUES("8756", "_transient_timeout_geoip_185.46.122.132", "1449064063", "no");
INSERT INTO `apprenz_options` VALUES("8757", "_transient_geoip_185.46.122.132", "US", "no");
INSERT INTO `apprenz_options` VALUES("7853", "_transient_geoip_200.49.242.3", "EC", "no");
INSERT INTO `apprenz_options` VALUES("7855", "_transient_timeout_geoip_37.187.97.36", "1448388827", "no");
INSERT INTO `apprenz_options` VALUES("7856", "_transient_geoip_37.187.97.36", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7868", "_transient_timeout_geoip_198.1.69.231", "1448400886", "no");
INSERT INTO `apprenz_options` VALUES("7869", "_transient_geoip_198.1.69.231", "US", "no");
INSERT INTO `apprenz_options` VALUES("7892", "_transient_timeout_geoip_64.119.182.90", "1448404513", "no");
INSERT INTO `apprenz_options` VALUES("7872", "_transient_timeout_geoip_176.10.114.135", "1448402260", "no");
INSERT INTO `apprenz_options` VALUES("7837", "_transient_geoip_37.1.218.125", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7839", "_transient_timeout_geoip_195.3.144.98", "1448370943", "no");
INSERT INTO `apprenz_options` VALUES("7840", "_transient_geoip_195.3.144.98", "LV", "no");
INSERT INTO `apprenz_options` VALUES("7842", "_transient_timeout_geoip_66.249.65.51", "1448371506", "no");
INSERT INTO `apprenz_options` VALUES("7843", "_transient_geoip_66.249.65.51", "US", "no");
INSERT INTO `apprenz_options` VALUES("7844", "_transient_timeout_geoip_212.7.220.180", "1448373528", "no");
INSERT INTO `apprenz_options` VALUES("7845", "_transient_geoip_212.7.220.180", "PL", "no");
INSERT INTO `apprenz_options` VALUES("7846", "_transient_timeout_geoip_188.143.233.136", "1448377371", "no");
INSERT INTO `apprenz_options` VALUES("7847", "_transient_geoip_188.143.233.136", "RU", "no");
INSERT INTO `apprenz_options` VALUES("7849", "_transient_timeout_geoip_66.249.73.217", "1448378482", "no");
INSERT INTO `apprenz_options` VALUES("7850", "_transient_geoip_66.249.73.217", "US", "no");
INSERT INTO `apprenz_options` VALUES("7852", "_transient_timeout_geoip_200.49.242.3", "1448385245", "no");
INSERT INTO `apprenz_options` VALUES("7836", "_transient_timeout_geoip_37.1.218.125", "1448356759", "no");
INSERT INTO `apprenz_options` VALUES("7828", "_transient_geoip_204.44.83.228", "US", "no");
INSERT INTO `apprenz_options` VALUES("5665", "theme_mods_seo", "a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:8:\"mainmenu\";i:24;s:9:\"panelmenu\";s:3:\"105\";}}", "yes");
INSERT INTO `apprenz_options` VALUES("5668", "revslider_checktables", "1", "yes");
INSERT INTO `apprenz_options` VALUES("5669", "revslider-static-css", ".tp-caption a {\ncolor:#ff7302;\ntext-shadow:none;\n-webkit-transition:all 0.2s ease-out;\n-moz-transition:all 0.2s ease-out;\n-o-transition:all 0.2s ease-out;\n-ms-transition:all 0.2s ease-out;\n}\n\n.tp-caption a:hover {\ncolor:#ffa902;\n}\n\n.tp-button.order {\n  font-weight: 700;\n  font-size: 16px;\n      letter-spacing:1px;\n      display:inline-block;\n      padding:10px 20px;\n  line-height:24px !important;\n  height:24px;\n}\n.babbysitter-slider-bg {\n  background-color: #86d9d2;\n}\n.healthcare-slider-bg {\n  background-color: #6fd3d7;\n}", "yes");
INSERT INTO `apprenz_options` VALUES("5670", "revslider-update-check-short", "1567608499", "yes");
INSERT INTO `apprenz_options` VALUES("5674", "tribe_events_calendar_options", "a:12:{s:27:\"recurring_events_are_hidden\";s:6:\"hidden\";s:19:\"tribeEventsTemplate\";s:0:\"\";s:21:\"tribeEventsBeforeHTML\";s:0:\"\";s:20:\"tribeEventsAfterHTML\";s:0:\"\";s:21:\"previous_ecp_versions\";a:3:{i:0;s:1:\"0\";i:1;s:3:\"3.8\";i:2;s:6:\"3.12.5\";}s:18:\"latest_ecp_version\";s:6:\"3.12.6\";s:14:\"welcome_notice\";b:1;s:19:\"last-update-message\";s:3:\"3.8\";s:13:\"earliest_date\";s:19:\"2015-05-14 08:00:00\";s:11:\"latest_date\";s:19:\"2015-10-31 17:00:00\";s:16:\"tribeEnableViews\";a:3:{i:0;s:4:\"list\";i:1;s:5:\"month\";i:2;s:3:\"day\";}s:14:\"schema-version\";s:6:\"3.12.6\";}", "yes");
INSERT INTO `apprenz_options` VALUES("5675", "tribe_events_db_version", "3.0.0", "yes");
INSERT INTO `apprenz_options` VALUES("5673", "vc_version", "4.5.3", "yes");
INSERT INTO `apprenz_options` VALUES("5677", "tribe_events_suite_versions", "a:1:{s:19:\"TribeEventsCalendar\";s:3:\"3.8\";}", "yes");
INSERT INTO `apprenz_options` VALUES("7826", "_transient_geoip_107.153.8.135", "US", "no");
INSERT INTO `apprenz_options` VALUES("5680", "tribe_last_save_post", "1567666952", "yes");
INSERT INTO `apprenz_options` VALUES("5688", "tribe_events_cat_children", "a:0:{}", "yes");
INSERT INTO `apprenz_options` VALUES("5689", "media_folder_children", "a:0:{}", "yes");
INSERT INTO `apprenz_options` VALUES("5690", "woocommerce_cart_page_id", "5", "yes");
INSERT INTO `apprenz_options` VALUES("5691", "woocommerce_checkout_page_id", "7", "yes");
INSERT INTO `apprenz_options` VALUES("5692", "woocommerce_myaccount_page_id", "9", "yes");
INSERT INTO `apprenz_options` VALUES("5693", "themerex_seo__(shared_on_themelot.net)_options_reset", "1", "yes");
INSERT INTO `apprenz_options` VALUES("5694", "themerex_options", "a:254:{s:10:\"theme_skin\";s:7:\"general\";s:11:\"theme_color\";s:0:\"\";s:12:\"theme_color2\";s:0:\"\";s:12:\"theme_color3\";s:0:\"\";s:21:\"show_theme_customizer\";s:2:\"no\";s:26:\"remember_visitors_settings\";s:2:\"no\";s:18:\"responsive_layouts\";s:3:\"yes\";s:7:\"favicon\";s:0:\"\";s:10:\"custom_css\";s:0:\"\";s:11:\"custom_code\";s:0:\"\";s:10:\"body_style\";s:4:\"wide\";s:13:\"load_bg_image\";s:6:\"always\";s:8:\"bg_color\";s:0:\"\";s:10:\"bg_pattern\";s:1:\"0\";s:17:\"bg_custom_pattern\";s:0:\"\";s:8:\"bg_image\";s:1:\"0\";s:15:\"bg_custom_image\";s:0:\"\";s:24:\"bg_custom_image_position\";s:8:\"left_top\";s:13:\"show_video_bg\";s:2:\"no\";s:21:\"video_bg_youtube_code\";s:0:\"\";s:12:\"video_bg_url\";s:0:\"\";s:16:\"video_bg_overlay\";s:2:\"no\";s:10:\"logo_image\";s:69:\"http://apprenz.com/wp-content/uploads/2015/11/APPRENZ_LOGO_FINALE.png\";s:8:\"logo_top\";s:0:\"\";s:10:\"logo_fixed\";s:0:\"\";s:9:\"logo_side\";s:0:\"\";s:9:\"logo_text\";s:0:\"\";s:11:\"logo_slogan\";s:1:\" \";s:11:\"logo_height\";s:0:\"\";s:11:\"logo_offset\";s:0:\"\";s:10:\"logo_align\";s:4:\"left\";s:17:\"logo_image_footer\";s:0:\"\";s:24:\"logo_image_footer_height\";s:0:\"\";s:14:\"show_top_panel\";s:5:\"above\";s:17:\"top_panel_opacity\";s:5:\"solid\";s:9:\"menu_main\";s:9:\"main-menu\";s:10:\"menu_style\";s:4:\"line\";s:13:\"menu_position\";s:5:\"fixed\";s:10:\"menu_align\";s:5:\"right\";s:15:\"menu_responsive\";s:4:\"1024\";s:20:\"menu_responsive_open\";s:5:\"click\";s:10:\"menu_width\";s:3:\"260\";s:16:\"menu_description\";s:5:\"below\";s:14:\"show_user_menu\";s:2:\"no\";s:9:\"menu_user\";s:7:\"default\";s:17:\"show_contact_info\";s:3:\"yes\";s:13:\"show_currency\";s:2:\"no\";s:9:\"show_cart\";s:4:\"shop\";s:14:\"show_languages\";s:3:\"yes\";s:10:\"show_login\";s:2:\"no\";s:16:\"right_panel_demo\";s:4:\"4000\";s:15:\"show_left_panel\";s:2:\"no\";s:9:\"menu_side\";s:7:\"default\";s:9:\"logo_icon\";s:0:\"\";s:16:\"show_right_panel\";s:3:\"yes\";s:10:\"menu_panel\";s:7:\"default\";s:18:\"right_panel_button\";s:5:\"float\";s:15:\"right_panel_tab\";s:0:\"\";s:8:\"menu_toc\";s:2:\"no\";s:13:\"menu_toc_home\";s:3:\"yes\";s:12:\"menu_toc_top\";s:3:\"yes\";s:15:\"custom_sidebars\";a:11:{i:0;s:15:\"Shortcodes list\";i:1;s:19:\"Standard WP widgets\";i:2;s:16:\"ThemeREX widgets\";i:3;s:8:\"Timeline\";i:4;s:11:\"Footer dark\";i:5;s:11:\"WooCommerce\";i:6;s:18:\"WooCommerce Footer\";i:8;s:13:\"Short sidebar\";i:9;s:13:\"Documentation\";i:10;s:16:\"Skin SEO sidebar\";i:11;s:19:\"Tribe Events footer\";}s:16:\"show_sidebar_top\";s:2:\"no\";s:11:\"sidebar_top\";s:11:\"sidebar-top\";s:17:\"show_sidebar_main\";s:5:\"right\";s:12:\"sidebar_main\";s:12:\"sidebar-main\";s:19:\"show_sidebar_footer\";s:3:\"yes\";s:20:\"sidebar_footer_style\";s:4:\"dark\";s:14:\"sidebar_footer\";s:16:\"custom-sidebar-4\";s:18:\"show_sidebar_panel\";s:2:\"no\";s:13:\"sidebar_panel\";s:13:\"sidebar-panel\";s:11:\"slider_show\";s:2:\"no\";s:14:\"slider_display\";s:4:\"none\";s:13:\"slider_height\";s:3:\"670\";s:13:\"slider_engine\";s:6:\"swiper\";s:12:\"slider_alias\";s:2:\"15\";s:15:\"slider_category\";s:1:\"5\";s:12:\"slider_posts\";s:1:\"5\";s:14:\"slider_orderby\";s:6:\"random\";s:12:\"slider_order\";s:4:\"desc\";s:15:\"slider_interval\";s:4:\"7000\";s:17:\"slider_pagination\";s:2:\"no\";s:15:\"slider_info_box\";s:3:\"yes\";s:17:\"slider_info_fixed\";s:2:\"no\";s:20:\"slider_info_category\";s:3:\"yes\";s:14:\"slider_reviews\";s:3:\"yes\";s:19:\"slider_descriptions\";s:2:\"no\";s:16:\"show_user_header\";s:4:\"none\";s:19:\"user_header_content\";s:1800:\"<p>[trx_content class=\"animated\" top=\"75px\"][trx_columns count=\"3\"][trx_column_item align=\"center\"][trx_block bg_tint=\"none\" dedicated=\"\" align=\"none\" columns=\"none\" scroll=\"\" dir=\"horizontal\" bottom=\"6em\"][trx_title type=\"3\" style=\"iconed\" align=\"none\" weight=\"700\" icon=\"inherit\" image=\"none\" size=\"huge\" position=\"top\" background=\"none\" picture=\"2563\" link=\"yes\" top=\"35px\"]Years of Expertise[/trx_title][trx_highlight type=\"0\" size=\"14px\" line_height=\"24px\"]We have been on web marketing for 12 years helping you compete on Internet and converting your visitors into your clients.[/trx_highlight][/trx_block][/trx_column_item][trx_column_item align=\"center\"][trx_block bg_tint=\"none\" dedicated=\"\" align=\"none\" columns=\"none\" scroll=\"\" dir=\"horizontal\" bottom=\"6em\"][trx_title type=\"3\" style=\"iconed\" align=\"none\" weight=\"700\" icon=\"inherit\" image=\"none\" size=\"huge\" position=\"top\" background=\"none\" picture=\"2564\" link=\"yes\" top=\"35px\"]Over 2000 Clients[/trx_title][trx_highlight type=\"0\" size=\"14px\" line_height=\"24px\"]We strive to ensure that our customers are satisfied and we work continuously to develop your projects and surpass your expectations.[/trx_highlight][/trx_block][/trx_column_item][trx_column_item align=\"center\"][trx_block bg_tint=\"none\" dedicated=\"\" align=\"none\" columns=\"none\" scroll=\"\" dir=\"horizontal\" bottom=\"6em\"][trx_title type=\"3\" style=\"iconed\" align=\"none\" weight=\"700\" icon=\"inherit\" image=\"none\" size=\"huge\" position=\"top\" background=\"none\" picture=\"2565\" link=\"yes\" top=\"35px\"]Real Results[/trx_title][trx_highlight type=\"0\" size=\"14px\" line_height=\"24px\"]Rankings, links, brand, content, traffic – all you need is right here! Simply drop us a line, and you will get your conversions![/trx_highlight][/trx_block][/trx_column_item][/trx_columns][/trx_content]</p>\";s:13:\"show_top_page\";s:3:\"yes\";s:15:\"show_page_title\";s:3:\"yes\";s:16:\"show_breadcrumbs\";s:3:\"yes\";s:21:\"breadcrumbs_max_level\";s:1:\"3\";s:16:\"show_user_footer\";s:4:\"none\";s:19:\"user_footer_content\";s:0:\"\";s:23:\"show_contacts_in_footer\";s:2:\"no\";s:22:\"show_twitter_in_footer\";s:2:\"no\";s:29:\"show_copyright_area_in_footer\";s:2:\"no\";s:16:\"footer_copyright\";s:102:\"<a href=\"http://themeforest.net/user/axiomthemes/portfolio\">Axiom</a> &copy; 2015 All Rights Reserved \";s:17:\"footer_terms_text\";s:12:\"Terms of Use\";s:17:\"footer_terms_link\";s:1:\"#\";s:18:\"footer_policy_text\";s:14:\"Privacy Policy\";s:18:\"footer_policy_link\";s:1:\"#\";s:14:\"googlemap_show\";s:2:\"no\";s:16:\"googlemap_height\";s:3:\"400\";s:17:\"googlemap_address\";s:27:\"San Francisco, CA 94102, US\";s:16:\"googlemap_latlng\";s:0:\"\";s:14:\"googlemap_zoom\";s:2:\"13\";s:15:\"googlemap_style\";s:6:\"style1\";s:16:\"googlemap_marker\";s:0:\"\";s:12:\"retina_ready\";s:1:\"1\";s:18:\"substitute_gallery\";s:3:\"yes\";s:24:\"substitute_slider_engine\";s:6:\"swiper\";s:21:\"gallery_instead_image\";s:3:\"yes\";s:18:\"gallery_max_slides\";s:1:\"5\";s:12:\"popup_engine\";s:6:\"pretty\";s:13:\"popup_gallery\";s:3:\"yes\";s:25:\"substitute_gallery_layout\";s:3:\"yes\";s:16:\"substitute_audio\";s:3:\"yes\";s:16:\"substitute_video\";s:3:\"yes\";s:16:\"use_mediaelement\";s:3:\"yes\";s:12:\"sound_enable\";s:2:\"no\";s:14:\"sound_mainmenu\";s:65:\"http://kidscare.axiomthemes.com/wp-content/uploads/2014/09/l9.mp3\";s:21:\"sound_mainmenu_enable\";s:2:\"no\";s:15:\"sound_othermenu\";s:65:\"http://kidscare.axiomthemes.com/wp-content/uploads/2014/09/l2.mp3\";s:22:\"sound_othermenu_enable\";s:2:\"no\";s:13:\"sound_buttons\";s:73:\"http://kidscare.axiomthemes.com/wp-content/uploads/2014/09/mouseover3.mp3\";s:20:\"sound_buttons_enable\";s:3:\"yes\";s:11:\"sound_links\";s:65:\"http://kidscare.axiomthemes.com/wp-content/uploads/2014/09/l6.mp3\";s:18:\"sound_links_enable\";s:2:\"no\";s:17:\"typography_custom\";s:2:\"no\";s:18:\"typography_h1_font\";s:23:\"Amadeus (uploaded font)\";s:18:\"typography_h1_size\";s:2:\"48\";s:24:\"typography_h1_lineheight\";s:2:\"60\";s:20:\"typography_h1_weight\";s:3:\"100\";s:19:\"typography_h1_style\";s:0:\"\";s:19:\"typography_h1_color\";s:7:\"#222222\";s:18:\"typography_h2_font\";s:7:\"Signika\";s:18:\"typography_h2_size\";s:2:\"36\";s:24:\"typography_h2_lineheight\";s:2:\"43\";s:20:\"typography_h2_weight\";s:3:\"100\";s:19:\"typography_h2_style\";s:0:\"\";s:19:\"typography_h2_color\";s:7:\"#222222\";s:18:\"typography_h3_font\";s:7:\"Signika\";s:18:\"typography_h3_size\";s:2:\"24\";s:24:\"typography_h3_lineheight\";s:2:\"28\";s:20:\"typography_h3_weight\";s:3:\"100\";s:19:\"typography_h3_style\";s:0:\"\";s:19:\"typography_h3_color\";s:7:\"#222222\";s:18:\"typography_h4_font\";s:7:\"Signika\";s:18:\"typography_h4_size\";s:2:\"20\";s:24:\"typography_h4_lineheight\";s:2:\"24\";s:20:\"typography_h4_weight\";s:3:\"300\";s:19:\"typography_h4_style\";s:0:\"\";s:19:\"typography_h4_color\";s:7:\"#222222\";s:18:\"typography_h5_font\";s:7:\"Signika\";s:18:\"typography_h5_size\";s:2:\"18\";s:24:\"typography_h5_lineheight\";s:2:\"20\";s:20:\"typography_h5_weight\";s:3:\"300\";s:19:\"typography_h5_style\";s:0:\"\";s:19:\"typography_h5_color\";s:7:\"#222222\";s:18:\"typography_h6_font\";s:7:\"Signika\";s:18:\"typography_h6_size\";s:2:\"16\";s:24:\"typography_h6_lineheight\";s:2:\"18\";s:20:\"typography_h6_weight\";s:3:\"300\";s:19:\"typography_h6_style\";s:0:\"\";s:19:\"typography_h6_color\";s:7:\"#222222\";s:17:\"typography_p_font\";s:15:\"Source Sans Pro\";s:17:\"typography_p_size\";s:2:\"14\";s:23:\"typography_p_lineheight\";s:2:\"21\";s:19:\"typography_p_weight\";s:3:\"300\";s:18:\"typography_p_style\";s:0:\"\";s:18:\"typography_p_color\";s:7:\"#898989\";s:10:\"blog_style\";s:7:\"excerpt\";s:11:\"hover_style\";s:3:\"dir\";s:9:\"hover_dir\";s:3:\"dir\";s:18:\"dedicated_location\";s:5:\"alter\";s:12:\"show_filters\";s:2:\"no\";s:15:\"filter_taxonomy\";s:4:\"tags\";s:9:\"blog_sort\";s:4:\"date\";s:10:\"blog_order\";s:4:\"desc\";s:14:\"posts_per_page\";s:2:\"12\";s:22:\"post_excerpt_maxlength\";s:3:\"200\";s:30:\"post_excerpt_maxlength_masonry\";s:3:\"150\";s:12:\"single_style\";s:15:\"single-standard\";s:12:\"allow_editor\";s:2:\"no\";s:19:\"show_featured_image\";s:3:\"yes\";s:15:\"show_post_title\";s:3:\"yes\";s:25:\"show_post_title_on_quotes\";s:2:\"no\";s:14:\"show_post_info\";s:3:\"yes\";s:25:\"show_text_before_readmore\";s:3:\"yes\";s:16:\"show_post_author\";s:3:\"yes\";s:14:\"show_post_tags\";s:3:\"yes\";s:18:\"show_post_counters\";s:3:\"yes\";s:17:\"show_post_related\";s:3:\"yes\";s:18:\"post_related_count\";s:1:\"3\";s:17:\"post_related_sort\";s:6:\"random\";s:18:\"post_related_order\";s:4:\"desc\";s:18:\"show_post_comments\";s:3:\"yes\";s:12:\"exclude_cats\";s:5:\"94,40\";s:15:\"blog_pagination\";s:0:\"\";s:21:\"blog_pagination_style\";s:6:\"slider\";s:13:\"blog_counters\";s:5:\"views\";s:14:\"close_category\";s:8:\"parental\";s:15:\"show_date_after\";s:2:\"30\";s:12:\"show_reviews\";s:3:\"yes\";s:17:\"reviews_max_level\";s:3:\"100\";s:13:\"reviews_style\";s:5:\"stars\";s:24:\"reviews_criterias_levels\";s:26:\"bad,poor,normal,good,great\";s:13:\"reviews_first\";s:6:\"author\";s:14:\"reviews_second\";s:4:\"show\";s:16:\"reviews_can_vote\";s:3:\"all\";s:17:\"reviews_criterias\";a:4:{i:0;s:18:\"Reviews criteria 1\";i:1;s:18:\"Reviews criteria 2\";i:2;s:18:\"Reviews criteria 3\";i:3;s:18:\"Reviews criteria 4\";}s:9:\"shop_mode\";s:6:\"thumbs\";s:18:\"crop_product_thumb\";s:2:\"no\";s:16:\"show_category_bg\";s:3:\"yes\";s:17:\"contact_text_line\";s:56:\"Share this page with friends who need help in 2015, too.\";s:13:\"contact_email\";s:0:\"\";s:17:\"contact_address_1\";s:15:\"1234, Some Str.\";s:17:\"contact_address_2\";s:27:\"San Francisco, CA 94102, US\";s:13:\"contact_phone\";s:14:\"1.800.123.4567\";s:11:\"contact_fax\";s:14:\"1.800.123.4566\";s:12:\"contact_info\";s:119:\"<span class=\"icon-phone\"></span> (+216) 25 270 669 <span class=\"icon-email\"></span> <a href=\"#\">contact@apprenz.com</a>\";s:26:\"message_maxlength_contacts\";s:4:\"1000\";s:26:\"message_maxlength_comments\";s:4:\"1000\";s:13:\"mail_function\";s:7:\"wp_mail\";s:12:\"social_icons\";a:1:{i:0;a:2:{s:3:\"url\";s:47:\"https://www.facebook.com/Apprenz.IT.Consulting/\";s:4:\"icon\";s:86:\"http://kidscare.axiomthemes.com/wp-content/themes/kidscare/images/socials/facebook.png\";}}s:10:\"show_share\";s:3:\"yes\";s:13:\"share_buttons\";a:3:{i:0;a:2:{s:3:\"url\";s:0:\"\";s:4:\"icon\";s:93:\"http://kidscare.axiomthemes.com/wp-content/themes/kidscare/images/socials/pinterest_color.png\";}i:1;a:2:{s:3:\"url\";s:0:\"\";s:4:\"icon\";s:91:\"http://kidscare.axiomthemes.com/wp-content/themes/kidscare/images/socials/twitter_color.png\";}i:2;a:2:{s:3:\"url\";s:0:\"\";s:4:\"icon\";s:92:\"http://kidscare.axiomthemes.com/wp-content/themes/kidscare/images/socials/facebook_color.png\";}}s:16:\"twitter_username\";s:0:\"\";s:20:\"twitter_consumer_key\";s:0:\"\";s:23:\"twitter_consumer_secret\";s:0:\"\";s:17:\"twitter_token_key\";s:0:\"\";s:20:\"twitter_token_secret\";s:0:\"\";s:13:\"twitter_count\";s:1:\"5\";s:11:\"show_search\";s:3:\"yes\";s:15:\"use_ajax_search\";s:3:\"yes\";s:22:\"ajax_search_min_length\";s:1:\"4\";s:17:\"ajax_search_delay\";s:3:\"500\";s:17:\"ajax_search_types\";s:4:\"post\";s:23:\"ajax_search_posts_count\";s:1:\"4\";s:23:\"ajax_search_posts_image\";s:3:\"yes\";s:22:\"ajax_search_posts_date\";s:3:\"yes\";s:24:\"ajax_search_posts_author\";s:3:\"yes\";s:26:\"ajax_search_posts_counters\";s:3:\"yes\";s:29:\"notify_about_new_registration\";s:2:\"no\";s:22:\"use_ajax_views_counter\";s:3:\"yes\";s:16:\"admin_dummy_data\";s:3:\"yes\";s:17:\"admin_add_filters\";s:3:\"yes\";s:21:\"admin_update_notifier\";s:3:\"yes\";s:11:\"custom_menu\";s:3:\"yes\";s:13:\"admin_emailer\";s:3:\"yes\";s:17:\"admin_po_composer\";s:3:\"yes\";s:16:\"clear_shortcodes\";s:3:\"yes\";}", "yes");
INSERT INTO `apprenz_options` VALUES("7715", "_transient_geoip_207.55.98.4", "US", "no");
INSERT INTO `apprenz_options` VALUES("7716", "_transient_timeout_geoip_74.221.221.14", "1448304369", "no");
INSERT INTO `apprenz_options` VALUES("7717", "_transient_geoip_74.221.221.14", "US", "no");
INSERT INTO `apprenz_options` VALUES("7718", "_transient_timeout_geoip_213.193.193.91", "1448304693", "no");
INSERT INTO `apprenz_options` VALUES("7719", "_transient_geoip_213.193.193.91", "NL", "no");
INSERT INTO `apprenz_options` VALUES("7720", "_transient_timeout_geoip_37.230.104.242", "1448304765", "no");
INSERT INTO `apprenz_options` VALUES("7721", "_transient_geoip_37.230.104.242", "TR", "no");
INSERT INTO `apprenz_options` VALUES("7722", "_transient_timeout_geoip_91.189.180.21", "1448305194", "no");
INSERT INTO `apprenz_options` VALUES("7723", "_transient_geoip_91.189.180.21", "NO", "no");
INSERT INTO `apprenz_options` VALUES("3137", "redux-framework-tracking", "a:2:{s:8:\"dev_mode\";b:0;s:4:\"hash\";s:32:\"d04226ffa5921b4c7f8ad0a69861ccd2\";}", "yes");
INSERT INTO `apprenz_options` VALUES("3140", "oneengine_options", "a:54:{s:11:\"custom_logo\";s:0:\"\";s:7:\"favicon\";a:1:{s:3:\"url\";s:71:\"http://apprenz.com/wp-content/themes/oneengine/images/icons/favicon.png\";}s:10:\"logo_width\";s:3:\"220\";s:8:\"logo_top\";s:1:\"0\";s:9:\"logo_left\";s:2:\"30\";s:10:\"touch_icon\";a:1:{s:3:\"url\";s:86:\"http://apprenz.com/wp-content/themes/oneengine/images/icons/apple-touch-icon-16x16.png\";}s:13:\"touch_icon_72\";a:1:{s:3:\"url\";s:86:\"http://apprenz.com/wp-content/themes/oneengine/images/icons/apple-touch-icon-72x72.png\";}s:14:\"touch_icon_144\";a:1:{s:3:\"url\";s:88:\"http://apprenz.com/wp-content/themes/oneengine/images/icons/apple-touch-icon-144x144.png\";}s:9:\"body_font\";a:4:{s:11:\"font-family\";s:4:\"Lato\";s:9:\"font-size\";s:4:\"14px\";s:5:\"color\";s:7:\"#5f6f81\";s:11:\"font-weight\";s:3:\"300\";}s:9:\"menu_font\";a:4:{s:11:\"font-family\";s:4:\"Lato\";s:9:\"font-size\";s:4:\"14px\";s:11:\"font-weight\";s:3:\"700\";s:5:\"color\";s:7:\"#000000\";}s:13:\"headings_font\";a:3:{s:11:\"font-family\";s:4:\"Lato\";s:11:\"font-weight\";s:3:\"700\";s:5:\"color\";s:7:\"#000000\";}s:10:\"main_color\";s:7:\"#e8432e\";s:10:\"link_color\";s:7:\"#e8432e\";s:17:\"header_blog_title\";s:4:\"Blog\";s:23:\"header_blog_title_color\";s:7:\"#000000\";s:20:\"header_blog_subtitle\";s:142:\"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo. \";s:26:\"header_blog_subtitle_color\";s:7:\"#ffffff\";s:17:\"header_blog_color\";s:7:\"#cccccc\";s:15:\"header_blog_img\";s:0:\"\";s:18:\"header_blog_repeat\";s:1:\"1\";s:20:\"header_blog_parallax\";s:1:\"1\";s:17:\"header_blog_cover\";s:1:\"1\";s:17:\"social_share_blog\";a:3:{s:7:\"twitter\";s:1:\"1\";s:8:\"facebook\";s:1:\"1\";s:11:\"google_plus\";s:1:\"1\";}s:19:\"btn_port_getintouch\";s:1:\"1\";s:24:\"btn_port_getintouch_link\";s:0:\"\";s:17:\"social_share_port\";a:3:{s:7:\"twitter\";s:1:\"1\";s:8:\"facebook\";s:1:\"1\";s:11:\"google_plus\";s:1:\"1\";}s:12:\"contact_form\";s:0:\"\";s:9:\"copyright\";s:34:\"2014 OneEngine. All right reserve.\";s:14:\"address_footer\";s:37:\"173A Nguyen Van Troi, Phu Nhuan, HCMC\";s:12:\"phone_footer\";s:13:\"0988 11 22 33\";s:12:\"email_footer\";s:21:\"info@enginethemes.com\";s:17:\"footer_blog_title\";s:10:\"Contact Us\";s:23:\"footer_blog_title_color\";s:7:\"#ffffff\";s:20:\"footer_blog_subtitle\";s:142:\"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo. \";s:26:\"footer_blog_subtitle_color\";s:7:\"#ffffff\";s:17:\"footer_blog_color\";s:7:\"#cccccc\";s:15:\"footer_blog_img\";s:0:\"\";s:18:\"footer_blog_repeat\";s:1:\"1\";s:20:\"footer_blog_parallax\";s:1:\"1\";s:17:\"footer_blog_cover\";s:1:\"1\";s:10:\"custom_css\";s:24:\"#test{\nmargin: 0 auto;\n}\";s:11:\"meta_author\";s:0:\"\";s:16:\"meta_description\";s:0:\"\";s:12:\"meta_keyword\";s:0:\"\";s:16:\"google_analytics\";s:0:\"\";s:8:\"facebook\";s:37:\"https://www.facebook.com/EngineThemes\";s:7:\"twitter\";s:34:\"https://twitter.com/enginewpthemes\";s:8:\"dribbble\";s:33:\"https://dribbble.com/enginethemes\";s:11:\"google_plus\";s:0:\"\";s:9:\"pinterest\";s:0:\"\";s:6:\"flickr\";s:0:\"\";s:8:\"linkedin\";s:0:\"\";s:16:\"REDUX_last_saved\";i:1415479159;s:14:\"REDUX_imported\";b:0;}", "yes");
INSERT INTO `apprenz_options` VALUES("3142", "theme_mods_minimable", "a:2:{i:0;b:0;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1415479467;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"orphaned_widgets_1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:18:\"orphaned_widgets_2\";a:1:{i:0;s:6:\"text-2\";}}}}", "yes");
INSERT INTO `apprenz_options` VALUES("3136", "theme_mods_oneengine", "a:2:{i:0;b:0;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1431509361;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"orphaned_widgets_1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:18:\"orphaned_widgets_2\";a:1:{i:0;s:6:\"text-2\";}}}}", "yes");
INSERT INTO `apprenz_options` VALUES("3080", "of_options", "a:0:{}", "yes");
INSERT INTO `apprenz_options` VALUES("3143", "contempo-notifier-cache", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<notifier>\n	<latest>1.6.1</latest>\n	<changelog>\n		<![CDATA[\n			<h4><strong>v1.6.1</strong> 05 Sep / 2014</h4>\n			<ol>\n				<li>Fixed: flickering of staff members on the last version of Google Chrome</li>\n			</ol>\n			<h4><strong>v1.6</strong> 01 Jul / 2014</h4>\n			<ol>\n				<li>A new premium version is coming this week with new features!</li>\n				<li>Added: demo content to start using the theme in the best way</li>\n				<li>Added: text area field in the contact section</li>\n				<li>Updated: you can set the scroll speed in the Theme Options</li>\n				<li>Updated: the documentation with the instructions for using the demo content</li>\n				<li>Fixed: CSS padding in the home section</li>\n			</ol>\n			<h4><strong>v1.5.5</strong> 19 May / 2014</h4>\n			<ol>\n				<li>There are new updates and fixes on the premium version. Take a look at the <a href=\"http://minimable.fedeweb.net/changelog/\" target=\"_blank\">changelog</a>!</li>\n				<li>Added: tumblr and vk social icons</li>\n				<li>Updated: you can open social links in a new window</li>\n			</ol>\n			<h4><strong>v1.5.4</strong> 15 Jan / 2014</h4>\n			<ol>\n				<li>There is a new premium version with a lot of new features. Take a look at the <a href=\"http://minimable.fedeweb.net/demo/\" target=\"_blank\">demo</a>!</li>\n				<li>Download the 1.5.4 version from <a href=\"http://minimable.fedeweb.net/wp-content/plugins/download-monitor/download.php?id=14\">here</a> without the pay per tweet.</li>\n				<li>Added: instagram social icon to the contact page and staff member</li>\n				<li>Updated: you can add a description in the gallery page</li>\n				<li>Updated: removed the limit of 10 pages in General options and updated to 20</li>\n			</ol>\n			<h4><strong>v1.5.3</strong> 19 Dec / 2013</h4>\n			<ol>\n				<li>Download the 1.5.3 version from <a href=\"http://minimable.fedeweb.net/wp-content/plugins/download-monitor/download.php?id=13\">here</a> without the pay per tweet.</li>\n				<li>Fixed: updated the style in the Minimable Options due to the WordPress 3.8 new colors</li>\n			</ol>\n			<h4><strong>v1.5.2</strong> 09 Dec / 2013</h4>\n			<ol>\n				<li>Download the 1.5.2 version from <a href=\"http://minimable.fedeweb.net/wp-content/plugins/download-monitor/download.php?id=12\">here</a> without the pay per tweet.</li>\n				<li>Added: now you can add social links for each staff member!</li>\n				<li>Fixed: when you click the mini logo the site scrolls up</li>\n				<li>Fixed: custom page link works for all pages</li>\n			</ol>\n			<h4><strong>v1.5.1</strong> 03 Dec / 2013</h4>\n			<ol>\n				<li>Download the 1.5.1 version from <a href=\"http://minimable.fedeweb.net/wp-content/plugins/download-monitor/download.php?id=11\">here</a> without the pay per tweet.</li>\n				<li>Fixed: fix the page link problem with special chars</li>\n			</ol>\n			<h4><strong>v1.5</strong> 02 Dec / 2013</h4>\n			<ol>\n				<li>Minimable Premium - Is ready!</li>\n				<li>Added: smooth fade animation on hover</li>\n				<li>Added: you can insert from 3 to 6 bubbles in home!</li>\n				<li>Updated: the documentation. Please read it because many things have changed</li>\n				<li>Updated: if the member in the staff is only one, the filter disappear</li>\n				<li>Updated: the menu on mobile navigation disappear when you tap a link </li>\n				<li>Updated: changed the icons in the contact template</li>\n			</ol>\n			<h4><strong>v1.4</strong> 30 Oct / 2013</h4>\n			<ol>\n				<li>Minimable Premium - In the first half of November the premium version will be ready!</li>\n				<li>Added: full width template page!</li>\n				<li>Updated: improved the jQuery code</li>\n				<li>Updated: remove the limit of the items in the staff and portfolio section</li>\n				<li>Updated: added the necessary information for the general page template</li>\n				<li>Fixed: icons in the Gallery now appears in Google Chrome too.</li>\n			</ol>\n			<h4><strong>v1.3.1</strong> 21 Aug / 2013</h4>\n			<ol>\n				<li>Minimable Premium - In the first half of September the premium version will be ready!</li>\n				<li>Updated: improved the documentation by adding a screenshot in the menu section</li>\n				<li>Fixed: the favicon option now works</li>\n			</ol>\n			<h4><strong>v1.3</strong> 30 Jul / 2013</h4>\n			<ol>\n				<li>Updated: improved the documentation and added a FAQ section</li>\n				<li>Updated: the \"Go to work\" links, in Portfolio section, now appears only when you fill in the URL link field in the dashboard</li>\n				<li>Updated: now, in Minimable Option you can set the \"Go to work\" label</li>\n				<li>Updated: when you activate Minimable for the first time, appears a message in the live site that told you which will be the next step</li>\n				<li>Updated: enabled external custom links in the menu</li>\n				<li>Updated: \"Find us\" and \"Contact us\" labels now are editable.</li>\n				<li>Fixed: iOS input aspect. Now it\'s the same of the desktop site version</li>\n				<li>Fixed: the contact informations on the left appears only when you put the label (email, fax, etc)</li>\n				<li>Fixed: the staff section issue, when the screen resolution has a width of 2500px</li>\n				<li>Fixed: the margin of the input fields in the Wordpress dashboard</li>\n			</ol>\n			<h4><strong>v1.2</strong> 01 Jul / 2013</h4>\n			<ol>\n				<li>Updated:iImproved typography design</li>\n				<li>Added: documentation option in Minimable Settings</li>\n				<li>Added: more details in Minimable documentation</li>\n				<li>Fixed: Changed position of lightbox image controller</li>\n				<li>Fixed: footer cut when is on two row</li>\n				<li>Fixed: scrollorama is now applied to all page galleries you create</li>\n				<li>Removed: minimoll.css file from css folder</li>\n			</ol>\n			<h4><strong>v1.1</strong> 26 Jun / 2013</h4>\n			<ol>\n				<li>Added: changelog file</li>\n				<li>Added: created a docs folder</li>\n				<li>Fixed: footer cutted on smartphones</li>\n				<li>Fixed: scrolling on the last section with big resolutions</li>\n				<li>Fixed: bug when you hover on the rounded thumbs in the gallery section, in Firefox (Windows)</li>\n				<li>Fixed: menu overlay on the circle link in the home section</li>\n				<li>Fixed: focus state on the email field in the contact section</li>\n				<li>Fixed: width of the input fields in Appereance - Menu</li>\n			</ol>\n			<h4><strong>v1.0</strong> 25 Jun / 2013</h4>\n			<ol>\n				<li>First release</li>\n			</ol>\n		]]>\n	</changelog>\n</notifier>", "yes");
INSERT INTO `apprenz_options` VALUES("36519", "_site_transient_timeout_wporg_theme_feature_list", "1518544624", "yes");
INSERT INTO `apprenz_options` VALUES("36520", "_site_transient_wporg_theme_feature_list", "a:4:{s:6:\"Colors\";a:15:{i:0;s:5:\"black\";i:1;s:4:\"blue\";i:2;s:5:\"brown\";i:3;s:4:\"gray\";i:4;s:5:\"green\";i:5;s:6:\"orange\";i:6;s:4:\"pink\";i:7;s:6:\"purple\";i:8;s:3:\"red\";i:9;s:6:\"silver\";i:10;s:3:\"tan\";i:11;s:5:\"white\";i:12;s:6:\"yellow\";i:13;s:4:\"dark\";i:14;s:5:\"light\";}s:6:\"Layout\";a:9:{i:0;s:12:\"fixed-layout\";i:1;s:12:\"fluid-layout\";i:2;s:17:\"responsive-layout\";i:3;s:10:\"one-column\";i:4;s:11:\"two-columns\";i:5;s:13:\"three-columns\";i:6;s:12:\"four-columns\";i:7;s:12:\"left-sidebar\";i:8;s:13:\"right-sidebar\";}s:8:\"Features\";a:20:{i:0;s:19:\"accessibility-ready\";i:1;s:8:\"blavatar\";i:2;s:10:\"buddypress\";i:3;s:17:\"custom-background\";i:4;s:13:\"custom-colors\";i:5;s:13:\"custom-header\";i:6;s:11:\"custom-menu\";i:7;s:12:\"editor-style\";i:8;s:21:\"featured-image-header\";i:9;s:15:\"featured-images\";i:10;s:15:\"flexible-header\";i:11;s:20:\"front-page-post-form\";i:12;s:19:\"full-width-template\";i:13;s:12:\"microformats\";i:14;s:12:\"post-formats\";i:15;s:20:\"rtl-language-support\";i:16;s:11:\"sticky-post\";i:17;s:13:\"theme-options\";i:18;s:17:\"threaded-comments\";i:19;s:17:\"translation-ready\";}s:7:\"Subject\";a:3:{i:0;s:7:\"holiday\";i:1;s:13:\"photoblogging\";i:2;s:8:\"seasonal\";}}", "yes");
INSERT INTO `apprenz_options` VALUES("5634", "db_upgraded", "", "yes");
INSERT INTO `apprenz_options` VALUES("143", "current_theme", "SEO  (shared on themelot.net)", "yes");
INSERT INTO `apprenz_options` VALUES("144", "theme_mods_twentytwelve", "a:2:{i:0;b:0;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1446640238;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:6:\"text-2\";}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";N;}}}", "yes");
INSERT INTO `apprenz_options` VALUES("145", "theme_switched", "", "yes");
INSERT INTO `apprenz_options` VALUES("148", "theme_mods_carbon-wp-light", "a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:2;s:9:\"secondary\";i:5;}s:12:\"header_image\";s:84:\"http://apprenz.com/wp-content/uploads/2013/09/cropped-APPRENZ_LOGO_FINALE_site11.png\";s:17:\"header_image_data\";O:8:\"stdClass\":5:{s:13:\"attachment_id\";i:38;s:3:\"url\";s:84:\"http://apprenz.com/wp-content/uploads/2013/09/cropped-APPRENZ_LOGO_FINALE_site11.png\";s:13:\"thumbnail_url\";s:84:\"http://apprenz.com/wp-content/uploads/2013/09/cropped-APPRENZ_LOGO_FINALE_site11.png\";s:6:\"height\";i:34;s:5:\"width\";i:151;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1446636514;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:19:\"sidebar-widget-area\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:18:\"footer-widget-area\";a:1:{i:0;s:6:\"text-2\";}}}}", "yes");
INSERT INTO `apprenz_options` VALUES("147", "theme_mods_twentythirteen", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1377367747;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}}}}", "yes");
INSERT INTO `apprenz_options` VALUES("153", "wooslider-version", "1.0.9", "yes");
INSERT INTO `apprenz_options` VALUES("156", "woothemes-updater-version", "1.1.3", "yes");
INSERT INTO `apprenz_options` VALUES("5656", "wpseo_internallinks", "a:10:{s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:23:\"breadcrumbs-blog-remove\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:23:\"post_types-post-maintax\";i:0;}", "yes");
INSERT INTO `apprenz_options` VALUES("165", "slide-page_children", "a:0:{}", "yes");
INSERT INTO `apprenz_options` VALUES("171", "otw_widget_settings", "a:1:{s:18:\"footer-widget-area\";a:13:{s:4:\"page\";a:5:{s:7:\"_otw_wc\";a:1:{s:6:\"text-2\";s:3:\"vis\";}i:16;a:2:{s:2:\"id\";s:2:\"16\";s:15:\"exclude_widgets\";a:0:{}}i:8;a:2:{s:2:\"id\";i:8;s:15:\"exclude_widgets\";a:1:{s:6:\"text-2\";s:6:\"text-2\";}}i:2;a:2:{s:2:\"id\";i:2;s:15:\"exclude_widgets\";a:1:{s:6:\"text-2\";s:6:\"text-2\";}}i:11;a:2:{s:2:\"id\";i:11;s:15:\"exclude_widgets\";a:0:{}}}s:4:\"post\";a:1:{s:7:\"_otw_wc\";a:1:{s:6:\"text-2\";s:3:\"vis\";}}s:8:\"category\";a:1:{s:7:\"_otw_wc\";a:1:{s:6:\"text-2\";s:3:\"vis\";}}s:7:\"posttag\";a:1:{s:7:\"_otw_wc\";a:1:{s:6:\"text-2\";s:5:\"invis\";}}s:14:\"author_archive\";a:1:{s:7:\"_otw_wc\";a:1:{s:6:\"text-2\";s:3:\"vis\";}}s:17:\"templatehierarchy\";a:14:{s:7:\"_otw_wc\";a:1:{s:6:\"text-2\";s:3:\"vis\";}s:4:\"home\";a:2:{s:2:\"id\";s:4:\"home\";s:15:\"exclude_widgets\";a:0:{}}s:5:\"front\";a:2:{s:2:\"id\";s:5:\"front\";s:15:\"exclude_widgets\";a:1:{s:6:\"text-2\";s:6:\"text-2\";}}i:404;a:2:{s:2:\"id\";i:404;s:15:\"exclude_widgets\";a:1:{s:6:\"text-2\";s:6:\"text-2\";}}s:6:\"search\";a:2:{s:2:\"id\";s:6:\"search\";s:15:\"exclude_widgets\";a:1:{s:6:\"text-2\";s:6:\"text-2\";}}s:4:\"date\";a:2:{s:2:\"id\";s:4:\"date\";s:15:\"exclude_widgets\";a:1:{s:6:\"text-2\";s:6:\"text-2\";}}s:6:\"author\";a:2:{s:2:\"id\";s:6:\"author\";s:15:\"exclude_widgets\";a:1:{s:6:\"text-2\";s:6:\"text-2\";}}s:8:\"category\";a:2:{s:2:\"id\";s:8:\"category\";s:15:\"exclude_widgets\";a:1:{s:6:\"text-2\";s:6:\"text-2\";}}s:3:\"tag\";a:2:{s:2:\"id\";s:3:\"tag\";s:15:\"exclude_widgets\";a:1:{s:6:\"text-2\";s:6:\"text-2\";}}s:8:\"taxonomy\";a:2:{s:2:\"id\";s:8:\"taxonomy\";s:15:\"exclude_widgets\";a:1:{s:6:\"text-2\";s:6:\"text-2\";}}s:7:\"archive\";a:2:{s:2:\"id\";s:7:\"archive\";s:15:\"exclude_widgets\";a:1:{s:6:\"text-2\";s:6:\"text-2\";}}s:6:\"single\";a:2:{s:2:\"id\";s:6:\"single\";s:15:\"exclude_widgets\";a:0:{}}s:10:\"attachment\";a:2:{s:2:\"id\";s:10:\"attachment\";s:15:\"exclude_widgets\";a:1:{s:6:\"text-2\";s:6:\"text-2\";}}s:4:\"page\";a:2:{s:2:\"id\";s:4:\"page\";s:15:\"exclude_widgets\";a:0:{}}}s:12:\"pagetemplate\";a:1:{s:7:\"_otw_wc\";a:1:{s:6:\"text-2\";s:3:\"vis\";}}s:7:\"archive\";a:1:{s:7:\"_otw_wc\";a:1:{s:6:\"text-2\";s:3:\"vis\";}}s:9:\"userroles\";a:1:{s:7:\"_otw_wc\";a:1:{s:6:\"text-2\";s:3:\"vis\";}}s:17:\"cpt_otw-portfolio\";a:1:{s:7:\"_otw_wc\";a:1:{s:6:\"text-2\";s:5:\"invis\";}}s:23:\"slide_in_ctx_slide-page\";a:1:{s:7:\"_otw_wc\";a:1:{s:6:\"text-2\";s:3:\"vis\";}}s:14:\"ctx_slide-page\";a:1:{s:7:\"_otw_wc\";a:1:{s:6:\"text-2\";s:3:\"vis\";}}s:15:\"postsincategory\";a:1:{s:7:\"_otw_wc\";a:1:{s:6:\"text-2\";s:3:\"vis\";}}}}", "yes");
INSERT INTO `apprenz_options` VALUES("172", "widget_tag_cloud", "a:2:{i:2;a:2:{s:5:\"title\";s:4:\"Tags\";s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `apprenz_options` VALUES("173", "otw_plugin_options", "a:1:{s:19:\"activate_appearence\";b:1;}", "yes");
INSERT INTO `apprenz_options` VALUES("5687", "category_children", "a:21:{i:19;a:1:{i:0;i:42;}i:20;a:3:{i:0;i:59;i:1;i:76;i:2;i:82;}i:59;a:1:{i:0;i:72;}i:72;a:1:{i:0;i:73;}i:73;a:1:{i:0;i:74;}i:74;a:1:{i:0;i:75;}i:76;a:1:{i:0;i:77;}i:77;a:1:{i:0;i:78;}i:78;a:1:{i:0;i:79;}i:79;a:1:{i:0;i:80;}i:80;a:1:{i:0;i:81;}i:82;a:1:{i:0;i:83;}i:83;a:1:{i:0;i:84;}i:84;a:1:{i:0;i:85;}i:85;a:1:{i:0;i:86;}i:87;a:1:{i:0;i:88;}i:88;a:1:{i:0;i:89;}i:89;a:1:{i:0;i:90;}i:90;a:1:{i:0;i:91;}i:91;a:1:{i:0;i:92;}i:92;a:1:{i:0;i:93;}}", "yes");
INSERT INTO `apprenz_options` VALUES("719", "_transient_random_seed", "8fba74448c50b6aa6e8141a99fe114ea", "yes");
INSERT INTO `apprenz_options` VALUES("3082", "theme_mods_canoe", "a:2:{i:0;b:0;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1415423267;s:4:\"data\";a:5:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:11:\"footer-left\";a:1:{i:0;s:6:\"text-2\";}s:13:\"footer-center\";N;s:12:\"footer-right\";N;}}}", "yes");
INSERT INTO `apprenz_options` VALUES("3084", "optionsframework", "a:1:{s:2:\"id\";s:10:\"alexandria\";}", "yes");
INSERT INTO `apprenz_options` VALUES("3085", "theme_mods_alexandria", "a:10:{i:0;b:0;s:16:\"background_image\";s:0:\"\";s:17:\"background_repeat\";s:9:\"no-repeat\";s:21:\"background_position_x\";s:6:\"center\";s:21:\"background_attachment\";s:6:\"scroll\";s:16:\"background_color\";s:6:\"0c87d3\";s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}s:12:\"header_image\";s:71:\"http://apprenz.com/wp-content/uploads/2014/11/cropped-logo-Apprenz1.png\";s:17:\"header_image_data\";a:5:{s:13:\"attachment_id\";i:54;s:3:\"url\";s:71:\"http://apprenz.com/wp-content/uploads/2014/11/cropped-logo-Apprenz1.png\";s:13:\"thumbnail_url\";s:71:\"http://apprenz.com/wp-content/uploads/2014/11/cropped-logo-Apprenz1.png\";s:5:\"width\";i:267;s:6:\"height\";i:99;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1415483556;s:4:\"data\";a:5:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:11:\"footer-left\";a:1:{i:0;s:6:\"text-2\";}s:13:\"footer-center\";N;s:12:\"footer-right\";N;}}}", "yes");
INSERT INTO `apprenz_options` VALUES("3144", "contempo-notifier-last-updated", "1415479390", "yes");
INSERT INTO `apprenz_options` VALUES("3149", "alexandria", "a:75:{s:10:\"skin_style\";s:10:\"alexandria\";s:26:\"show_featured_image_single\";s:4:\"true\";s:18:\"show_rat_on_single\";s:4:\"true\";s:17:\"show_pd_on_single\";s:4:\"true\";s:19:\"show_cats_on_single\";s:4:\"true\";s:11:\"show_np_box\";s:4:\"true\";s:10:\"twitter_id\";s:0:\"\";s:8:\"redit_id\";s:0:\"\";s:11:\"facebook_id\";s:0:\"\";s:10:\"stumble_id\";s:0:\"\";s:9:\"flickr_id\";s:0:\"\";s:11:\"linkedin_id\";s:0:\"\";s:9:\"google_id\";s:0:\"\";s:17:\"logo_layout_style\";s:4:\"sbys\";s:13:\"header_slider\";s:7:\"cheader\";s:27:\"show_alexandria_slider_home\";s:4:\"true\";s:29:\"show_alexandria_slider_single\";s:5:\"false\";s:27:\"show_alexandria_slider_page\";s:5:\"false\";s:30:\"show_alexandria_slider_archive\";s:5:\"false\";s:16:\"slider_one_image\";s:96:\"http://apprenz.com/wp-content/uploads/2014/11/10-things-every-small-business-website-needs-3.jpg\";s:19:\"slider_one_headline\";s:7:\"APPRENZ\";s:15:\"slider_one_text\";s:29:\"Le site le plus beau du monde\";s:14:\"slider_one_cta\";s:15:\"Suivez le guide\";s:19:\"slider_one_cta_link\";s:0:\"\";s:15:\"homepage_layout\";s:4:\"bone\";s:16:\"welcome_headline\";s:0:\"\";s:12:\"welcome_text\";s:0:\"\";s:18:\"left_section_image\";s:0:\"\";s:21:\"left_section_headline\";s:0:\"\";s:17:\"left_section_text\";s:0:\"\";s:17:\"left_section_link\";s:0:\"\";s:20:\"center_section_image\";s:0:\"\";s:23:\"center_section_headline\";s:0:\"\";s:19:\"center_section_text\";s:0:\"\";s:19:\"center_section_link\";s:0:\"\";s:19:\"right_section_image\";s:0:\"\";s:22:\"right_section_headline\";s:0:\"\";s:18:\"right_section_text\";s:0:\"\";s:18:\"right_section_link\";s:0:\"\";s:28:\"show_alexandria_quote_bizone\";s:4:\"true\";s:18:\"quote_section_text\";s:0:\"\";s:18:\"quote_section_name\";s:0:\"\";s:17:\"show_bizone_posts\";s:4:\"true\";s:23:\"biztwo_welcome_headline\";s:0:\"\";s:19:\"biztwo_welcome_text\";s:0:\"\";s:25:\"biztwo_left_section_image\";s:0:\"\";s:28:\"biztwo_left_section_headline\";s:0:\"\";s:24:\"biztwo_left_section_text\";s:0:\"\";s:24:\"biztwo_left_section_link\";s:0:\"\";s:27:\"biztwo_center_section_image\";s:0:\"\";s:30:\"biztwo_center_section_headline\";s:0:\"\";s:26:\"biztwo_center_section_text\";s:0:\"\";s:26:\"biztwo_center_section_link\";s:0:\"\";s:26:\"biztwo_right_section_image\";s:0:\"\";s:29:\"biztwo_right_section_headline\";s:0:\"\";s:25:\"biztwo_right_section_text\";s:0:\"\";s:25:\"biztwo_right_section_link\";s:0:\"\";s:28:\"show_alexandria_quote_biztwo\";s:4:\"true\";s:25:\"biztwo_quote_section_text\";s:0:\"\";s:25:\"biztwo_quote_section_name\";s:0:\"\";s:21:\"biztwo_port_one_image\";s:0:\"\";s:20:\"biztwo_port_one_name\";s:0:\"\";s:20:\"biztwo_port_one_link\";s:0:\"\";s:21:\"biztwo_port_two_image\";s:0:\"\";s:20:\"biztwo_port_two_name\";s:0:\"\";s:20:\"biztwo_port_two_link\";s:0:\"\";s:23:\"biztwo_port_three_image\";s:0:\"\";s:22:\"biztwo_port_three_name\";s:0:\"\";s:22:\"biztwo_port_three_link\";s:0:\"\";s:22:\"biztwo_port_four_image\";s:0:\"\";s:21:\"biztwo_port_four_name\";s:0:\"\";s:21:\"biztwo_port_four_link\";s:0:\"\";s:17:\"show_biztwo_posts\";s:4:\"true\";s:19:\"show_comments_spage\";s:4:\"true\";s:13:\"footer_layout\";s:3:\"one\";}", "yes");
INSERT INTO `apprenz_options` VALUES("3161", "_transient_aq_template_68", "a:1:{s:10:\"aq_block_1\";a:17:{s:11:\"padding_top\";s:1:\"0\";s:14:\"padding_bottom\";s:1:\"0\";s:10:\"text_color\";s:6:\"normal\";s:5:\"image\";s:58:\"http://apprenz.com/wp-content/uploads/2014/11/websites.png\";s:8:\"bg_color\";s:7:\"#fafafa\";s:8:\"position\";s:8:\"top left\";s:6:\"repeat\";s:9:\"no-repeat\";s:8:\"parallax\";s:1:\"1\";s:8:\"show_row\";s:4:\"true\";s:7:\"menu_id\";s:0:\"\";s:7:\"id_base\";s:23:\"oe_open_container_block\";s:4:\"name\";s:16:\"Container (open)\";s:5:\"order\";s:1:\"1\";s:4:\"size\";s:6:\"span12\";s:6:\"parent\";s:1:\"0\";s:6:\"number\";s:1:\"1\";s:11:\"template_id\";s:2:\"68\";}}", "yes");
INSERT INTO `apprenz_options` VALUES("7815", "_transient_timeout_geoip_54.251.57.249", "1448324173", "no");
INSERT INTO `apprenz_options` VALUES("6380", "_transient_timeout_geoip_66.249.78.89", "1448132566", "no");
INSERT INTO `apprenz_options` VALUES("6381", "_transient_geoip_66.249.78.89", "US", "no");
INSERT INTO `apprenz_options` VALUES("6382", "_transient_timeout_geoip_66.249.65.87", "1448132567", "no");
INSERT INTO `apprenz_options` VALUES("6383", "_transient_geoip_66.249.65.87", "US", "no");
INSERT INTO `apprenz_options` VALUES("6370", "woocommerce_allow_tracking", "no", "yes");
INSERT INTO `apprenz_options` VALUES("7812", "_transient_geoip_199.116.255.251", "US", "no");
INSERT INTO `apprenz_options` VALUES("7813", "_transient_timeout_geoip_192.163.221.231", "1448321954", "no");
INSERT INTO `apprenz_options` VALUES("7814", "_transient_geoip_192.163.221.231", "US", "no");
INSERT INTO `apprenz_options` VALUES("7806", "_transient_geoip_96.126.120.68", "US", "no");
INSERT INTO `apprenz_options` VALUES("7807", "_transient_timeout_geoip_173.205.127.243", "1448321072", "no");
INSERT INTO `apprenz_options` VALUES("7808", "_transient_geoip_173.205.127.243", "US", "no");
INSERT INTO `apprenz_options` VALUES("7809", "_transient_timeout_geoip_97.79.236.99", "1448321075", "no");
INSERT INTO `apprenz_options` VALUES("7810", "_transient_geoip_97.79.236.99", "US", "no");
INSERT INTO `apprenz_options` VALUES("7805", "_transient_timeout_geoip_96.126.120.68", "1448320497", "no");
INSERT INTO `apprenz_options` VALUES("6364", "woocommerce_cod_settings", "a:1:{s:7:\"enabled\";s:2:\"no\";}", "yes");
INSERT INTO `apprenz_options` VALUES("6365", "woocommerce_bacs_settings", "a:1:{s:7:\"enabled\";s:2:\"no\";}", "yes");
INSERT INTO `apprenz_options` VALUES("7794", "_transient_geoip_162.17.49.3", "US", "no");
INSERT INTO `apprenz_options` VALUES("7796", "_transient_timeout_geoip_192.64.54.121", "1448316512", "no");
INSERT INTO `apprenz_options` VALUES("7797", "_transient_geoip_192.64.54.121", "US", "no");
INSERT INTO `apprenz_options` VALUES("7798", "_transient_timeout_geoip_62.109.6.34", "1448316748", "no");
INSERT INTO `apprenz_options` VALUES("7799", "_transient_geoip_62.109.6.34", "RU", "no");
INSERT INTO `apprenz_options` VALUES("7800", "_transient_timeout_geoip_209.11.159.26", "1448320452", "no");
INSERT INTO `apprenz_options` VALUES("7801", "_transient_geoip_209.11.159.26", "US", "no");
INSERT INTO `apprenz_options` VALUES("7803", "_transient_timeout_geoip_180.210.201.21", "1448320472", "no");
INSERT INTO `apprenz_options` VALUES("7804", "_transient_geoip_180.210.201.21", "SG", "no");
INSERT INTO `apprenz_options` VALUES("7789", "_transient_timeout_geoip_52.3.180.197", "1448314660", "no");
INSERT INTO `apprenz_options` VALUES("7790", "_transient_geoip_52.3.180.197", "US", "no");
INSERT INTO `apprenz_options` VALUES("7791", "_transient_timeout_geoip_217.115.192.120", "1448315386", "no");
INSERT INTO `apprenz_options` VALUES("7792", "_transient_geoip_217.115.192.120", "NL", "no");
INSERT INTO `apprenz_options` VALUES("7793", "_transient_timeout_geoip_162.17.49.3", "1448315582", "no");
INSERT INTO `apprenz_options` VALUES("7783", "_transient_timeout_geoip_37.59.145.190", "1448312108", "no");
INSERT INTO `apprenz_options` VALUES("7784", "_transient_geoip_37.59.145.190", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7785", "_transient_timeout_geoip_69.28.199.130", "1448313678", "no");
INSERT INTO `apprenz_options` VALUES("7786", "_transient_geoip_69.28.199.130", "CA", "no");
INSERT INTO `apprenz_options` VALUES("7787", "_transient_timeout_geoip_207.46.13.155", "1448313841", "no");
INSERT INTO `apprenz_options` VALUES("7788", "_transient_geoip_207.46.13.155", "US", "no");
INSERT INTO `apprenz_options` VALUES("7781", "_transient_geoip_162.144.135.55", "US", "no");
INSERT INTO `apprenz_options` VALUES("6374", "_transient_product_query-transient-version", "1447527479", "yes");
INSERT INTO `apprenz_options` VALUES("48400", "_transient_timeout_wc_uf_pid_7c4a4fb28903d52484ec4dab64dba121", "1569094253", "no");
INSERT INTO `apprenz_options` VALUES("48401", "_transient_wc_uf_pid_7c4a4fb28903d52484ec4dab64dba121", "a:0:{}", "no");
INSERT INTO `apprenz_options` VALUES("7728", "_transient_geoip_216.154.218.122", "US", "no");
INSERT INTO `apprenz_options` VALUES("7729", "_transient_timeout_geoip_78.133.122.186", "1448305523", "no");
INSERT INTO `apprenz_options` VALUES("7730", "_transient_geoip_78.133.122.186", "MT", "no");
INSERT INTO `apprenz_options` VALUES("7731", "_transient_timeout_geoip_107.155.108.197", "1448305594", "no");
INSERT INTO `apprenz_options` VALUES("7732", "_transient_geoip_107.155.108.197", "US", "no");
INSERT INTO `apprenz_options` VALUES("8809", "_transient_timeout_geoip_88.157.198.204", "1449078069", "no");
INSERT INTO `apprenz_options` VALUES("8810", "_transient_geoip_88.157.198.204", "PT", "no");
INSERT INTO `apprenz_options` VALUES("7735", "_transient_timeout_geoip_210.245.85.175", "1448306075", "no");
INSERT INTO `apprenz_options` VALUES("7727", "_transient_timeout_geoip_216.154.218.122", "1448305477", "no");
INSERT INTO `apprenz_options` VALUES("6386", "_transient_timeout_geoip_62.210.151.191", "1448133519", "no");
INSERT INTO `apprenz_options` VALUES("6387", "_transient_geoip_62.210.151.191", "FR", "no");
INSERT INTO `apprenz_options` VALUES("6388", "_transient_timeout_geoip_23.94.75.18", "1448134141", "no");
INSERT INTO `apprenz_options` VALUES("6389", "_transient_geoip_23.94.75.18", "US", "no");
INSERT INTO `apprenz_options` VALUES("6390", "_transient_timeout_geoip_115.146.120.179", "1448134174", "no");
INSERT INTO `apprenz_options` VALUES("6391", "_transient_geoip_115.146.120.179", "VN", "no");
INSERT INTO `apprenz_options` VALUES("6392", "_transient_timeout_geoip_216.99.158.132", "1448135238", "no");
INSERT INTO `apprenz_options` VALUES("6393", "_transient_geoip_216.99.158.132", "US", "no");
INSERT INTO `apprenz_options` VALUES("6399", "_transient_timeout_geoip_188.165.216.96", "1448136492", "no");
INSERT INTO `apprenz_options` VALUES("6400", "_transient_geoip_188.165.216.96", "FR", "no");
INSERT INTO `apprenz_options` VALUES("6402", "_transient_timeout_geoip_67.214.182.202", "1448138199", "no");
INSERT INTO `apprenz_options` VALUES("6403", "_transient_geoip_67.214.182.202", "US", "no");
INSERT INTO `apprenz_options` VALUES("6404", "_transient_timeout_geoip_2605:b000:1:1:115::1", "1448138253", "no");
INSERT INTO `apprenz_options` VALUES("6405", "_transient_geoip_2605:b000:1:1:115::1", "CA", "no");
INSERT INTO `apprenz_options` VALUES("6406", "_transient_timeout_geoip_216.97.237.45", "1448138399", "no");
INSERT INTO `apprenz_options` VALUES("6407", "_transient_geoip_216.97.237.45", "US", "no");
INSERT INTO `apprenz_options` VALUES("43966", "_transient_timeout_wc_low_stock_count", "1550840547", "no");
INSERT INTO `apprenz_options` VALUES("43967", "_transient_wc_low_stock_count", "0", "no");
INSERT INTO `apprenz_options` VALUES("43968", "_transient_timeout_wc_outofstock_count", "1550840547", "no");
INSERT INTO `apprenz_options` VALUES("43969", "_transient_wc_outofstock_count", "0", "no");
INSERT INTO `apprenz_options` VALUES("43970", "_transient_timeout_wc_admin_report", "1548334947", "no");
INSERT INTO `apprenz_options` VALUES("43971", "_transient_wc_admin_report", "a:1:{s:32:\"5ff1eb54f66825cc43b3f9dae81b9687\";a:0:{}}", "no");
INSERT INTO `apprenz_options` VALUES("6416", "_transient_timeout_geoip_66.249.78.82", "1448138572", "no");
INSERT INTO `apprenz_options` VALUES("6417", "_transient_geoip_66.249.78.82", "US", "no");
INSERT INTO `apprenz_options` VALUES("6418", "_transient_timeout_geoip_185.103.119.1", "1448138727", "no");
INSERT INTO `apprenz_options` VALUES("6419", "_transient_geoip_185.103.119.1", "GB", "no");
INSERT INTO `apprenz_options` VALUES("6420", "_transient_timeout_geoip_82.100.220.66", "1448139050", "no");
INSERT INTO `apprenz_options` VALUES("6421", "_transient_geoip_82.100.220.66", "DE", "no");
INSERT INTO `apprenz_options` VALUES("6422", "_transient_timeout_geoip_185.71.216.204", "1448139102", "no");
INSERT INTO `apprenz_options` VALUES("6423", "_transient_geoip_185.71.216.204", "CY", "no");
INSERT INTO `apprenz_options` VALUES("6424", "_transient_timeout_geoip_87.229.101.10", "1448139326", "no");
INSERT INTO `apprenz_options` VALUES("6425", "_transient_geoip_87.229.101.10", "HU", "no");
INSERT INTO `apprenz_options` VALUES("6426", "_transient_timeout_geoip_84.240.9.6", "1448141404", "no");
INSERT INTO `apprenz_options` VALUES("6427", "_transient_geoip_84.240.9.6", "LT", "no");
INSERT INTO `apprenz_options` VALUES("9279", "_transient_timeout_geoip_2001:41d0:2:bf4a::", "1449458820", "no");
INSERT INTO `apprenz_options` VALUES("9280", "_transient_geoip_2001:41d0:2:bf4a::", "FR", "no");
INSERT INTO `apprenz_options` VALUES("6431", "_transient_timeout_geoip_187.45.193.167", "1448142640", "no");
INSERT INTO `apprenz_options` VALUES("6432", "_transient_geoip_187.45.193.167", "BR", "no");
INSERT INTO `apprenz_options` VALUES("6433", "_transient_timeout_geoip_199.168.141.142", "1448142976", "no");
INSERT INTO `apprenz_options` VALUES("6434", "_transient_geoip_199.168.141.142", "US", "no");
INSERT INTO `apprenz_options` VALUES("6435", "_transient_timeout_geoip_50.16.194.62", "1448142992", "no");
INSERT INTO `apprenz_options` VALUES("6436", "_transient_geoip_50.16.194.62", "US", "no");
INSERT INTO `apprenz_options` VALUES("6437", "_transient_timeout_geoip_193.190.127.195", "1448143443", "no");
INSERT INTO `apprenz_options` VALUES("6438", "_transient_geoip_193.190.127.195", "BE", "no");
INSERT INTO `apprenz_options` VALUES("6439", "_transient_timeout_geoip_54.67.53.113", "1448144004", "no");
INSERT INTO `apprenz_options` VALUES("6440", "_transient_geoip_54.67.53.113", "US", "no");
INSERT INTO `apprenz_options` VALUES("6441", "_transient_timeout_geoip_23.23.85.3", "1448144052", "no");
INSERT INTO `apprenz_options` VALUES("6442", "_transient_geoip_23.23.85.3", "US", "no");
INSERT INTO `apprenz_options` VALUES("6443", "_transient_timeout_geoip_91.213.206.66", "1448144303", "no");
INSERT INTO `apprenz_options` VALUES("6444", "_transient_geoip_91.213.206.66", "PL", "no");
INSERT INTO `apprenz_options` VALUES("6445", "_transient_timeout_geoip_91.120.37.66", "1448145626", "no");
INSERT INTO `apprenz_options` VALUES("6446", "_transient_geoip_91.120.37.66", "HU", "no");
INSERT INTO `apprenz_options` VALUES("6448", "_transient_timeout_geoip_162.144.59.20", "1448145938", "no");
INSERT INTO `apprenz_options` VALUES("6449", "_transient_geoip_162.144.59.20", "US", "no");
INSERT INTO `apprenz_options` VALUES("6450", "_transient_timeout_geoip_185.7.61.241", "1448146962", "no");
INSERT INTO `apprenz_options` VALUES("6451", "_transient_geoip_185.7.61.241", "NO", "no");
INSERT INTO `apprenz_options` VALUES("6452", "_transient_timeout_geoip_66.249.78.96", "1448148141", "no");
INSERT INTO `apprenz_options` VALUES("6453", "_transient_geoip_66.249.78.96", "US", "no");
INSERT INTO `apprenz_options` VALUES("6454", "_transient_timeout_geoip_108.167.189.78", "1448148773", "no");
INSERT INTO `apprenz_options` VALUES("6455", "_transient_geoip_108.167.189.78", "US", "no");
INSERT INTO `apprenz_options` VALUES("6456", "_transient_timeout_geoip_191.238.230.242", "1448148775", "no");
INSERT INTO `apprenz_options` VALUES("6457", "_transient_geoip_191.238.230.242", "US", "no");
INSERT INTO `apprenz_options` VALUES("6458", "_transient_timeout_geoip_66.84.10.205", "1448149017", "no");
INSERT INTO `apprenz_options` VALUES("6459", "_transient_geoip_66.84.10.205", "US", "no");
INSERT INTO `apprenz_options` VALUES("6460", "_transient_timeout_geoip_31.222.170.190", "1448149075", "no");
INSERT INTO `apprenz_options` VALUES("6461", "_transient_geoip_31.222.170.190", "GB", "no");
INSERT INTO `apprenz_options` VALUES("6462", "_transient_timeout_geoip_5.135.58.165", "1448149077", "no");
INSERT INTO `apprenz_options` VALUES("6463", "_transient_geoip_5.135.58.165", "FR", "no");
INSERT INTO `apprenz_options` VALUES("6464", "_transient_timeout_geoip_84.244.165.178", "1448149232", "no");
INSERT INTO `apprenz_options` VALUES("6465", "_transient_geoip_84.244.165.178", "NL", "no");
INSERT INTO `apprenz_options` VALUES("6467", "_transient_timeout_geoip_54.83.19.254", "1448149339", "no");
INSERT INTO `apprenz_options` VALUES("6468", "_transient_geoip_54.83.19.254", "US", "no");
INSERT INTO `apprenz_options` VALUES("6469", "_transient_timeout_geoip_180.76.15.152", "1448151209", "no");
INSERT INTO `apprenz_options` VALUES("6470", "_transient_geoip_180.76.15.152", "CN", "no");
INSERT INTO `apprenz_options` VALUES("6505", "_transient_timeout_geoip_5.149.250.47", "1448154386", "no");
INSERT INTO `apprenz_options` VALUES("6506", "_transient_geoip_5.149.250.47", "NL", "no");
INSERT INTO `apprenz_options` VALUES("8556", "_transient_timeout_geoip_37.1.202.50", "1448871025", "no");
INSERT INTO `apprenz_options` VALUES("8557", "_transient_geoip_37.1.202.50", "NL", "no");
INSERT INTO `apprenz_options` VALUES("8901", "_transient_timeout_geoip_184.154.116.26", "1449142488", "no");
INSERT INTO `apprenz_options` VALUES("8902", "_transient_geoip_184.154.116.26", "US", "no");
INSERT INTO `apprenz_options` VALUES("6511", "_transient_timeout_geoip_173.214.178.99", "1448154724", "no");
INSERT INTO `apprenz_options` VALUES("6512", "_transient_geoip_173.214.178.99", "US", "no");
INSERT INTO `apprenz_options` VALUES("6513", "_transient_timeout_geoip_193.107.88.70", "1448154801", "no");
INSERT INTO `apprenz_options` VALUES("6514", "_transient_geoip_193.107.88.70", "PL", "no");
INSERT INTO `apprenz_options` VALUES("6515", "_transient_timeout_geoip_74.50.6.191", "1448155207", "no");
INSERT INTO `apprenz_options` VALUES("6516", "_transient_geoip_74.50.6.191", "US", "no");
INSERT INTO `apprenz_options` VALUES("7776", "_transient_timeout_geoip_162.246.19.62", "1448311183", "no");
INSERT INTO `apprenz_options` VALUES("7777", "_transient_geoip_162.246.19.62", "US", "no");
INSERT INTO `apprenz_options` VALUES("7778", "_transient_timeout_geoip_205.134.224.208", "1448311475", "no");
INSERT INTO `apprenz_options` VALUES("7779", "_transient_geoip_205.134.224.208", "US", "no");
INSERT INTO `apprenz_options` VALUES("7780", "_transient_timeout_geoip_162.144.135.55", "1448311827", "no");
INSERT INTO `apprenz_options` VALUES("7768", "_transient_timeout_geoip_80.68.178.28", "1448310296", "no");
INSERT INTO `apprenz_options` VALUES("7769", "_transient_geoip_80.68.178.28", "IT", "no");
INSERT INTO `apprenz_options` VALUES("7770", "_transient_timeout_geoip_202.66.30.195", "1448310496", "no");
INSERT INTO `apprenz_options` VALUES("7771", "_transient_geoip_202.66.30.195", "HK", "no");
INSERT INTO `apprenz_options` VALUES("7772", "_transient_timeout_geoip_206.130.104.157", "1448310643", "no");
INSERT INTO `apprenz_options` VALUES("7773", "_transient_geoip_206.130.104.157", "US", "no");
INSERT INTO `apprenz_options` VALUES("7774", "_transient_timeout_geoip_216.197.229.134", "1448311085", "no");
INSERT INTO `apprenz_options` VALUES("7775", "_transient_geoip_216.197.229.134", "CA", "no");
INSERT INTO `apprenz_options` VALUES("7759", "_transient_geoip_2600:3c03::f03c:91ff:fe26:a97b", "US", "no");
INSERT INTO `apprenz_options` VALUES("7760", "_transient_timeout_geoip_72.34.34.33", "1448310000", "no");
INSERT INTO `apprenz_options` VALUES("7761", "_transient_geoip_72.34.34.33", "US", "no");
INSERT INTO `apprenz_options` VALUES("7762", "_transient_timeout_geoip_64.209.141.34", "1448310009", "no");
INSERT INTO `apprenz_options` VALUES("7763", "_transient_geoip_64.209.141.34", "US", "no");
INSERT INTO `apprenz_options` VALUES("7764", "_transient_timeout_geoip_198.154.251.159", "1448310047", "no");
INSERT INTO `apprenz_options` VALUES("7765", "_transient_geoip_198.154.251.159", "US", "no");
INSERT INTO `apprenz_options` VALUES("7766", "_transient_timeout_geoip_144.76.105.213", "1448310277", "no");
INSERT INTO `apprenz_options` VALUES("7767", "_transient_geoip_144.76.105.213", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7746", "_transient_geoip_192.232.238.223", "US", "no");
INSERT INTO `apprenz_options` VALUES("7752", "_transient_timeout_geoip_174.141.228.133", "1448309288", "no");
INSERT INTO `apprenz_options` VALUES("7753", "_transient_geoip_174.141.228.133", "US", "no");
INSERT INTO `apprenz_options` VALUES("8654", "_transient_timeout_geoip_72.9.155.235", "1448967820", "no");
INSERT INTO `apprenz_options` VALUES("8655", "_transient_geoip_72.9.155.235", "US", "no");
INSERT INTO `apprenz_options` VALUES("7756", "_transient_timeout_geoip_151.1.208.9", "1448309766", "no");
INSERT INTO `apprenz_options` VALUES("7757", "_transient_geoip_151.1.208.9", "IT", "no");
INSERT INTO `apprenz_options` VALUES("7758", "_transient_timeout_geoip_2600:3c03::f03c:91ff:fe26:a97b", "1448309996", "no");
INSERT INTO `apprenz_options` VALUES("6531", "_transient_timeout_geoip_129.121.239.133", "1448155546", "no");
INSERT INTO `apprenz_options` VALUES("6532", "_transient_geoip_129.121.239.133", "US", "no");
INSERT INTO `apprenz_options` VALUES("6534", "_transient_timeout_geoip_193.198.213.8", "1448155666", "no");
INSERT INTO `apprenz_options` VALUES("6535", "_transient_geoip_193.198.213.8", "HR", "no");
INSERT INTO `apprenz_options` VALUES("6536", "_transient_timeout_geoip_104.131.167.54", "1448155759", "no");
INSERT INTO `apprenz_options` VALUES("6537", "_transient_geoip_104.131.167.54", "US", "no");
INSERT INTO `apprenz_options` VALUES("7745", "_transient_timeout_geoip_192.232.238.223", "1448307302", "no");
INSERT INTO `apprenz_options` VALUES("7743", "_transient_timeout_geoip_77.223.129.58", "1448306865", "no");
INSERT INTO `apprenz_options` VALUES("7744", "_transient_geoip_77.223.129.58", "TR", "no");
INSERT INTO `apprenz_options` VALUES("6543", "_transient_timeout_geoip_5.189.206.168", "1448156099", "no");
INSERT INTO `apprenz_options` VALUES("6544", "_transient_geoip_5.189.206.168", "RU", "no");
INSERT INTO `apprenz_options` VALUES("6556", "_transient_timeout_geoip_188.65.115.226", "1448157564", "no");
INSERT INTO `apprenz_options` VALUES("6557", "_transient_geoip_188.65.115.226", "GB", "no");
INSERT INTO `apprenz_options` VALUES("6583", "_transient_timeout_geoip_2a02:c200:1:10:2:2:3108:1", "1448157752", "no");
INSERT INTO `apprenz_options` VALUES("6584", "_transient_geoip_2a02:c200:1:10:2:2:3108:1", "DE", "no");
INSERT INTO `apprenz_options` VALUES("6587", "_transient_timeout_geoip_64.182.225.60", "1448158009", "no");
INSERT INTO `apprenz_options` VALUES("6588", "_transient_geoip_64.182.225.60", "US", "no");
INSERT INTO `apprenz_options` VALUES("7736", "_transient_geoip_210.245.85.175", "VN", "no");
INSERT INTO `apprenz_options` VALUES("7737", "_transient_timeout_geoip_54.195.254.29", "1448306092", "no");
INSERT INTO `apprenz_options` VALUES("6591", "_transient_timeout_geoip_208.94.238.210", "1448158131", "no");
INSERT INTO `apprenz_options` VALUES("6592", "_transient_geoip_208.94.238.210", "US", "no");
INSERT INTO `apprenz_options` VALUES("6598", "_transient_timeout_geoip_198.100.152.227", "1448158396", "no");
INSERT INTO `apprenz_options` VALUES("6599", "_transient_geoip_198.100.152.227", "US", "no");
INSERT INTO `apprenz_options` VALUES("7725", "_transient_timeout_geoip_144.76.155.11", "1448305447", "no");
INSERT INTO `apprenz_options` VALUES("7726", "_transient_geoip_144.76.155.11", "DE", "no");
INSERT INTO `apprenz_options` VALUES("6602", "_transient_timeout_geoip_66.249.65.93", "1448158420", "no");
INSERT INTO `apprenz_options` VALUES("6603", "_transient_geoip_66.249.65.93", "US", "no");
INSERT INTO `apprenz_options` VALUES("6609", "_transient_timeout_geoip_46.235.44.172", "1448158724", "no");
INSERT INTO `apprenz_options` VALUES("6610", "_transient_geoip_46.235.44.172", "NL", "no");
INSERT INTO `apprenz_options` VALUES("6614", "_transient_timeout_geoip_2a03:7940:ff20::195", "1448159031", "no");
INSERT INTO `apprenz_options` VALUES("6615", "_transient_geoip_2a03:7940:ff20::195", "PL", "no");
INSERT INTO `apprenz_options` VALUES("7630", "_transient_geoip_2400:8900::f03c:91ff:fedb:e9a8", "SG", "no");
INSERT INTO `apprenz_options` VALUES("7631", "_transient_timeout_geoip_2001:41d0:c:4ca::", "1448292666", "no");
INSERT INTO `apprenz_options` VALUES("36526", "GOTMLS_scan_log/41.227.65.103/1518536436.0708", "a:2:{s:8:\"settings\";a:13:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:5:\"check\";a:5:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";}s:15:\"skip_quarantine\";i:0;}s:4:\"scan\";a:7:{s:3:\"dir\";s:24:\"/home/maento/www/apprenz\";s:5:\"start\";i:1518536439;s:4:\"type\";s:10:\"Quick Scan\";s:9:\"microtime\";d:7;s:7:\"percent\";i:100;s:11:\"last_threat\";d:1518536446.019769;s:6:\"finish\";i:1518536446;}}", "yes");
INSERT INTO `apprenz_options` VALUES("7609", "_transient_geoip_46.16.63.9", "ES", "no");
INSERT INTO `apprenz_options` VALUES("7610", "_transient_timeout_geoip_180.149.243.25", "1448290033", "no");
INSERT INTO `apprenz_options` VALUES("7611", "_transient_geoip_180.149.243.25", "IN", "no");
INSERT INTO `apprenz_options` VALUES("7613", "_transient_timeout_geoip_2604:7c00:1a:7::1", "1448290220", "no");
INSERT INTO `apprenz_options` VALUES("7614", "_transient_geoip_2604:7c00:1a:7::1", "US", "no");
INSERT INTO `apprenz_options` VALUES("7615", "_transient_timeout_geoip_46.32.255.141", "1448290378", "no");
INSERT INTO `apprenz_options` VALUES("7616", "_transient_geoip_46.32.255.141", "GB", "no");
INSERT INTO `apprenz_options` VALUES("7617", "_transient_timeout_geoip_89.200.172.177", "1448290465", "no");
INSERT INTO `apprenz_options` VALUES("7618", "_transient_geoip_89.200.172.177", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7619", "_transient_timeout_geoip_65.185.37.222", "1448290702", "no");
INSERT INTO `apprenz_options` VALUES("7620", "_transient_geoip_65.185.37.222", "US", "no");
INSERT INTO `apprenz_options` VALUES("7621", "_transient_timeout_geoip_2605:f700:42:3438:225:90ff:fee0:a4ac", "1448290703", "no");
INSERT INTO `apprenz_options` VALUES("7622", "_transient_geoip_2605:f700:42:3438:225:90ff:fee0:a4ac", "US", "no");
INSERT INTO `apprenz_options` VALUES("7640", "_transient_timeout_geoip_89.26.240.160", "1448294583", "no");
INSERT INTO `apprenz_options` VALUES("7641", "_transient_geoip_89.26.240.160", "PT", "no");
INSERT INTO `apprenz_options` VALUES("7642", "_transient_timeout_geoip_104.156.246.186", "1448294597", "no");
INSERT INTO `apprenz_options` VALUES("7643", "_transient_geoip_104.156.246.186", "US", "no");
INSERT INTO `apprenz_options` VALUES("7644", "_transient_timeout_geoip_89.99.12.235", "1448294772", "no");
INSERT INTO `apprenz_options` VALUES("7645", "_transient_geoip_89.99.12.235", "NL", "no");
INSERT INTO `apprenz_options` VALUES("7646", "_transient_timeout_geoip_67.225.209.26", "1448295464", "no");
INSERT INTO `apprenz_options` VALUES("7647", "_transient_geoip_67.225.209.26", "US", "no");
INSERT INTO `apprenz_options` VALUES("6626", "simple-backup-settings", "a:3:{s:15:\"backup_settings\";a:6:{s:18:\"enable_file_backup\";s:4:\"true\";s:16:\"file_compression\";s:7:\".tar.gz\";s:16:\"enable_db_backup\";s:4:\"true\";s:14:\"db_compression\";s:8:\".sql.zip\";s:24:\"enable_ftp_backup_system\";s:5:\"false\";s:29:\"enable_htaccess_auto_security\";s:4:\"true\";}s:21:\"wp_optimizer_settings\";a:5:{s:20:\"delete_spam_comments\";s:5:\"false\";s:26:\"delete_unapproved_comments\";s:5:\"false\";s:16:\"delete_revisions\";s:5:\"false\";s:18:\"delete_auto_drafts\";s:5:\"false\";s:24:\"delete_transient_options\";s:5:\"false\";}s:21:\"db_optimizer_settings\";a:3:{s:17:\"optimize_database\";s:5:\"false\";s:14:\"check_database\";s:5:\"false\";s:15:\"repair_database\";s:5:\"false\";}}", "yes");
INSERT INTO `apprenz_options` VALUES("7632", "_transient_geoip_2001:41d0:c:4ca::", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7633", "_transient_timeout_geoip_114.130.11.223", "1448293089", "no");
INSERT INTO `apprenz_options` VALUES("7634", "_transient_geoip_114.130.11.223", "BD", "no");
INSERT INTO `apprenz_options` VALUES("7635", "_transient_timeout_geoip_75.103.66.3", "1448293097", "no");
INSERT INTO `apprenz_options` VALUES("7636", "_transient_geoip_75.103.66.3", "US", "no");
INSERT INTO `apprenz_options` VALUES("7637", "_transient_timeout_geoip_144.76.24.66", "1448294563", "no");
INSERT INTO `apprenz_options` VALUES("7638", "_transient_geoip_144.76.24.66", "DE", "no");
INSERT INTO `apprenz_options` VALUES("7648", "_transient_timeout_geoip_2a01:4f8:c17:868::2", "1448295586", "no");
INSERT INTO `apprenz_options` VALUES("6639", "simple-backup-background-processing", "false", "yes");
INSERT INTO `apprenz_options` VALUES("6653", "_transient_timeout_geoip_2400:8900::f03c:91ff:fec8:f9d4", "1448159755", "no");
INSERT INTO `apprenz_options` VALUES("6654", "_transient_geoip_2400:8900::f03c:91ff:fec8:f9d4", "SG", "no");
INSERT INTO `apprenz_options` VALUES("7623", "_transient_timeout_geoip_2001:41d0:2:ae65:aaaa::2", "1448291190", "no");
INSERT INTO `apprenz_options` VALUES("7624", "_transient_geoip_2001:41d0:2:ae65:aaaa::2", "FR", "no");
INSERT INTO `apprenz_options` VALUES("7625", "_transient_timeout_geoip_128.163.119.189", "1448291519", "no");
INSERT INTO `apprenz_options` VALUES("7626", "_transient_geoip_128.163.119.189", "US", "no");
INSERT INTO `apprenz_options` VALUES("7627", "_transient_timeout_geoip_183.81.165.81", "1448291544", "no");
INSERT INTO `apprenz_options` VALUES("6662", "_transient_timeout_geoip_2a03:2880:3010:9fe7:face:b00c:0:8000", "1448160030", "no");
INSERT INTO `apprenz_options` VALUES("6663", "_transient_geoip_2a03:2880:3010:9fe7:face:b00c:0:8000", "IE", "no");
INSERT INTO `apprenz_options` VALUES("6664", "_transient_timeout_geoip_2a03:2880:3010:dff4:face:b00c:0:8000", "1448160041", "no");
INSERT INTO `apprenz_options` VALUES("6665", "_transient_geoip_2a03:2880:3010:dff4:face:b00c:0:8000", "IE", "no");
INSERT INTO `apprenz_options` VALUES("6666", "_transient_timeout_geoip_41.227.163.183", "1448160043", "no");
INSERT INTO `apprenz_options` VALUES("6667", "_transient_geoip_41.227.163.183", "TN", "no");
INSERT INTO `apprenz_options` VALUES("6668", "_transient_timeout_geoip_2a03:2880:3010:7ff7:face:b00c:0:1", "1448160046", "no");
INSERT INTO `apprenz_options` VALUES("6669", "_transient_geoip_2a03:2880:3010:7ff7:face:b00c:0:1", "IE", "no");
INSERT INTO `apprenz_options` VALUES("6670", "_transient_timeout_geoip_66.249.65.90", "1448160047", "no");
INSERT INTO `apprenz_options` VALUES("6671", "_transient_geoip_66.249.65.90", "US", "no");
INSERT INTO `apprenz_options` VALUES("7628", "_transient_geoip_183.81.165.81", "MY", "no");
INSERT INTO `apprenz_options` VALUES("7629", "_transient_timeout_geoip_2400:8900::f03c:91ff:fedb:e9a8", "1448291769", "no");
INSERT INTO `apprenz_options` VALUES("6708", "_transient_timeout_geoip_124.158.4.72", "1448160912", "no");
INSERT INTO `apprenz_options` VALUES("6709", "_transient_geoip_124.158.4.72", "VN", "no");
INSERT INTO `apprenz_options` VALUES("6714", "_transient_timeout_geoip_192.145.236.134", "1448162029", "no");
INSERT INTO `apprenz_options` VALUES("6715", "_transient_geoip_192.145.236.134", "US", "no");
INSERT INTO `apprenz_options` VALUES("6716", "_transient_timeout_geoip_205.134.241.74", "1448162029", "no");
INSERT INTO `apprenz_options` VALUES("6717", "_transient_geoip_205.134.241.74", "US", "no");
INSERT INTO `apprenz_options` VALUES("6718", "_transient_timeout_geoip_66.117.0.129", "1448162054", "no");
INSERT INTO `apprenz_options` VALUES("6719", "_transient_geoip_66.117.0.129", "US", "no");
INSERT INTO `apprenz_options` VALUES("6720", "_transient_timeout_geoip_123.63.124.186", "1448162392", "no");
INSERT INTO `apprenz_options` VALUES("6721", "_transient_geoip_123.63.124.186", "IN", "no");
INSERT INTO `apprenz_options` VALUES("6722", "_transient_timeout_geoip_185.85.191.11", "1448162465", "no");
INSERT INTO `apprenz_options` VALUES("6723", "_transient_geoip_185.85.191.11", "TR", "no");
INSERT INTO `apprenz_options` VALUES("6724", "_transient_timeout_geoip_2a04:2180:0:1::81b7:fc7f", "1448162935", "no");
INSERT INTO `apprenz_options` VALUES("6725", "_transient_geoip_2a04:2180:0:1::81b7:fc7f", "LT", "no");
INSERT INTO `apprenz_options` VALUES("8675", "_transient_timeout_geoip_2a00:1a48:7806:117:be76:4eff:fe08:a759", "1448995950", "no");
INSERT INTO `apprenz_options` VALUES("8676", "_transient_geoip_2a00:1a48:7806:117:be76:4eff:fe08:a759", "GB", "no");
INSERT INTO `apprenz_options` VALUES("6729", "_transient_timeout_geoip_52.24.22.162", "1448165333", "no");
INSERT INTO `apprenz_options` VALUES("6730", "_transient_geoip_52.24.22.162", "US", "no");
INSERT INTO `apprenz_options` VALUES("6731", "_transient_timeout_geoip_198.154.202.180", "1448165514", "no");
INSERT INTO `apprenz_options` VALUES("6732", "_transient_geoip_198.154.202.180", "US", "no");
INSERT INTO `apprenz_options` VALUES("6733", "_transient_timeout_geoip_185.71.216.232", "1448166067", "no");
INSERT INTO `apprenz_options` VALUES("6734", "_transient_geoip_185.71.216.232", "CY", "no");
INSERT INTO `apprenz_options` VALUES("6735", "_transient_timeout_geoip_70.32.85.171", "1448166255", "no");
INSERT INTO `apprenz_options` VALUES("6736", "_transient_geoip_70.32.85.171", "US", "no");
INSERT INTO `apprenz_options` VALUES("6737", "_transient_timeout_geoip_73.153.248.59", "1448166260", "no");
INSERT INTO `apprenz_options` VALUES("6738", "_transient_geoip_73.153.248.59", "US", "no");
INSERT INTO `apprenz_options` VALUES("6739", "_transient_timeout_geoip_104.236.186.245", "1448166324", "no");
INSERT INTO `apprenz_options` VALUES("6740", "_transient_geoip_104.236.186.245", "US", "no");
INSERT INTO `apprenz_options` VALUES("6741", "_transient_timeout_geoip_5.172.218.38", "1448166431", "no");
INSERT INTO `apprenz_options` VALUES("6742", "_transient_geoip_5.172.218.38", "NL", "no");
INSERT INTO `apprenz_options` VALUES("6743", "_transient_timeout_geoip_67.210.119.235", "1448166494", "no");
INSERT INTO `apprenz_options` VALUES("6744", "_transient_geoip_67.210.119.235", "US", "no");
INSERT INTO `apprenz_options` VALUES("6745", "_transient_timeout_geoip_88.87.41.138", "1448166948", "no");
INSERT INTO `apprenz_options` VALUES("6746", "_transient_geoip_88.87.41.138", "NO", "no");
INSERT INTO `apprenz_options` VALUES("6747", "_transient_timeout_geoip_46.4.79.201", "1448168110", "no");
INSERT INTO `apprenz_options` VALUES("6748", "_transient_geoip_46.4.79.201", "DE", "no");
INSERT INTO `apprenz_options` VALUES("6750", "_transient_timeout_geoip_64.79.100.52", "1448168993", "no");
INSERT INTO `apprenz_options` VALUES("6751", "_transient_geoip_64.79.100.52", "US", "no");
INSERT INTO `apprenz_options` VALUES("6752", "_transient_timeout_geoip_198.23.223.210", "1448169561", "no");
INSERT INTO `apprenz_options` VALUES("6753", "_transient_geoip_198.23.223.210", "US", "no");
INSERT INTO `apprenz_options` VALUES("9363", "_transient_geoip_222.255.237.25", "VN", "no");
INSERT INTO `apprenz_options` VALUES("9322", "_transient_geoip_37.204.68.19", "RU", "no");
INSERT INTO `apprenz_options` VALUES("6759", "_transient_timeout_geoip_193.201.227.139", "1448173632", "no");
INSERT INTO `apprenz_options` VALUES("6760", "_transient_geoip_193.201.227.139", "UA", "no");
INSERT INTO `apprenz_options` VALUES("6761", "_transient_timeout_geoip_151.1.182.241", "1448173787", "no");
INSERT INTO `apprenz_options` VALUES("6762", "_transient_geoip_151.1.182.241", "IT", "no");
INSERT INTO `apprenz_options` VALUES("6763", "_transient_timeout_geoip_194.8.254.250", "1448173798", "no");
INSERT INTO `apprenz_options` VALUES("6764", "_transient_geoip_194.8.254.250", "GB", "no");
INSERT INTO `apprenz_options` VALUES("6765", "_transient_timeout_geoip_104.207.143.130", "1448173932", "no");
INSERT INTO `apprenz_options` VALUES("6766", "_transient_geoip_104.207.143.130", "US", "no");
INSERT INTO `apprenz_options` VALUES("6767", "_transient_timeout_geoip_67.203.15.146", "1448173968", "no");
INSERT INTO `apprenz_options` VALUES("6768", "_transient_geoip_67.203.15.146", "US", "no");
INSERT INTO `apprenz_options` VALUES("6769", "_transient_timeout_geoip_50.63.178.54", "1448174020", "no");
INSERT INTO `apprenz_options` VALUES("6770", "_transient_geoip_50.63.178.54", "US", "no");
INSERT INTO `apprenz_options` VALUES("6771", "_transient_timeout_geoip_174.37.231.104", "1448174121", "no");
INSERT INTO `apprenz_options` VALUES("6772", "_transient_geoip_174.37.231.104", "US", "no");
INSERT INTO `apprenz_options` VALUES("6773", "_transient_timeout_geoip_204.17.57.68", "1448174185", "no");
INSERT INTO `apprenz_options` VALUES("6774", "_transient_geoip_204.17.57.68", "US", "no");
INSERT INTO `apprenz_options` VALUES("6775", "_transient_timeout_geoip_198.52.103.196", "1448174192", "no");
INSERT INTO `apprenz_options` VALUES("6776", "_transient_geoip_198.52.103.196", "US", "no");
INSERT INTO `apprenz_options` VALUES("6777", "_transient_timeout_geoip_2604:180:2:114::65ad", "1448174319", "no");
INSERT INTO `apprenz_options` VALUES("6778", "_transient_geoip_2604:180:2:114::65ad", "US", "no");
INSERT INTO `apprenz_options` VALUES("6779", "_transient_timeout_geoip_2600:3c02::f03c:91ff:fe89:a0f7", "1448174366", "no");
INSERT INTO `apprenz_options` VALUES("6780", "_transient_geoip_2600:3c02::f03c:91ff:fe89:a0f7", "US", "no");
INSERT INTO `apprenz_options` VALUES("6781", "_transient_timeout_geoip_72.3.229.125", "1448174478", "no");
INSERT INTO `apprenz_options` VALUES("6782", "_transient_geoip_72.3.229.125", "US", "no");
INSERT INTO `apprenz_options` VALUES("6783", "_transient_timeout_geoip_103.8.25.172", "1448174653", "no");
INSERT INTO `apprenz_options` VALUES("6784", "_transient_geoip_103.8.25.172", "MY", "no");
INSERT INTO `apprenz_options` VALUES("6785", "_transient_timeout_geoip_178.16.24.78", "1448174676", "no");
INSERT INTO `apprenz_options` VALUES("6786", "_transient_geoip_178.16.24.78", "LV", "no");
INSERT INTO `apprenz_options` VALUES("6787", "_transient_timeout_geoip_91.241.27.45", "1448174811", "no");
INSERT INTO `apprenz_options` VALUES("6788", "_transient_geoip_91.241.27.45", "PL", "no");
INSERT INTO `apprenz_options` VALUES("6789", "_transient_timeout_geoip_198.57.180.113", "1448174972", "no");
INSERT INTO `apprenz_options` VALUES("6790", "_transient_geoip_198.57.180.113", "US", "no");
INSERT INTO `apprenz_options` VALUES("6791", "_transient_timeout_geoip_202.239.239.36", "1448175018", "no");
INSERT INTO `apprenz_options` VALUES("6792", "_transient_geoip_202.239.239.36", "JP", "no");
INSERT INTO `apprenz_options` VALUES("6793", "_transient_timeout_geoip_193.239.44.212", "1448175479", "no");
INSERT INTO `apprenz_options` VALUES("6794", "_transient_geoip_193.239.44.212", "PL", "no");
INSERT INTO `apprenz_options` VALUES("8851", "_transient_timeout_geoip_185.92.73.125", "1449103416", "no");
INSERT INTO `apprenz_options` VALUES("8852", "_transient_geoip_185.92.73.125", "", "no");
INSERT INTO `apprenz_options` VALUES("8853", "_transient_timeout_external_ip_address_185.92.73.125", "1449103416", "no");
INSERT INTO `apprenz_options` VALUES("8854", "_transient_external_ip_address_185.92.73.125", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("8621", "_transient_timeout_geoip_213.251.182.106", "1448923530", "no");
INSERT INTO `apprenz_options` VALUES("8622", "_transient_geoip_213.251.182.106", "FR", "no");
INSERT INTO `apprenz_options` VALUES("6802", "_transient_timeout_geoip_203.124.121.21", "1448176452", "no");
INSERT INTO `apprenz_options` VALUES("6803", "_transient_geoip_203.124.121.21", "SG", "no");
INSERT INTO `apprenz_options` VALUES("6804", "_transient_timeout_geoip_202.47.72.203", "1448176454", "no");
INSERT INTO `apprenz_options` VALUES("6805", "_transient_geoip_202.47.72.203", "ID", "no");
INSERT INTO `apprenz_options` VALUES("6807", "_transient_timeout_geoip_124.217.254.200", "1448177853", "no");
INSERT INTO `apprenz_options` VALUES("6808", "_transient_geoip_124.217.254.200", "MY", "no");
INSERT INTO `apprenz_options` VALUES("6809", "_transient_timeout_geoip_50.63.26.13", "1448177854", "no");
INSERT INTO `apprenz_options` VALUES("6810", "_transient_geoip_50.63.26.13", "US", "no");
INSERT INTO `apprenz_options` VALUES("6816", "_transient_timeout_geoip_46.165.242.197", "1448179231", "no");
INSERT INTO `apprenz_options` VALUES("6817", "_transient_geoip_46.165.242.197", "DE", "no");
INSERT INTO `apprenz_options` VALUES("6818", "_transient_timeout_geoip_157.55.39.155", "1448179438", "no");
INSERT INTO `apprenz_options` VALUES("6819", "_transient_geoip_157.55.39.155", "US", "no");
INSERT INTO `apprenz_options` VALUES("8578", "_transient_timeout_geoip_195.154.185.57", "1448886313", "no");
INSERT INTO `apprenz_options` VALUES("8579", "_transient_geoip_195.154.185.57", "FR", "no");
INSERT INTO `apprenz_options` VALUES("6822", "_transient_timeout_geoip_96.0.255.155", "1448180647", "no");
INSERT INTO `apprenz_options` VALUES("6823", "_transient_geoip_96.0.255.155", "US", "no");
INSERT INTO `apprenz_options` VALUES("6825", "_transient_timeout_geoip_64.91.232.87", "1448181313", "no");
INSERT INTO `apprenz_options` VALUES("6826", "_transient_geoip_64.91.232.87", "US", "no");
INSERT INTO `apprenz_options` VALUES("8663", "_transient_timeout_geoip_184.154.124.2", "1448995063", "no");
INSERT INTO `apprenz_options` VALUES("8664", "_transient_geoip_184.154.124.2", "US", "no");
INSERT INTO `apprenz_options` VALUES("6829", "_transient_timeout_geoip_77.103.243.159", "1448181644", "no");
INSERT INTO `apprenz_options` VALUES("6830", "_transient_geoip_77.103.243.159", "GB", "no");
INSERT INTO `apprenz_options` VALUES("6831", "_transient_timeout_geoip_2a02:2498:53aa:6e80:216:3eff:fe38:b20d", "1448181807", "no");
INSERT INTO `apprenz_options` VALUES("6832", "_transient_geoip_2a02:2498:53aa:6e80:216:3eff:fe38:b20d", "GB", "no");
INSERT INTO `apprenz_options` VALUES("6833", "_transient_timeout_geoip_71.184.239.57", "1448181808", "no");
INSERT INTO `apprenz_options` VALUES("6834", "_transient_geoip_71.184.239.57", "US", "no");
INSERT INTO `apprenz_options` VALUES("6835", "_transient_timeout_geoip_50.116.75.199", "1448181811", "no");
INSERT INTO `apprenz_options` VALUES("6339", "_transient_woocommerce_cache_excluded_uris", "a:6:{i:0;s:3:\"p=5\";i:1;s:6:\"/cart/\";i:2;s:3:\"p=7\";i:3;s:10:\"/checkout/\";i:4;s:3:\"p=9\";i:5;s:12:\"/my-account/\";}", "yes");
INSERT INTO `apprenz_options` VALUES("6340", "_transient_woocommerce_webhook_ids", "a:0:{}", "yes");
INSERT INTO `apprenz_options` VALUES("6341", "_transient_wc_attribute_taxonomies", "a:0:{}", "yes");
INSERT INTO `apprenz_options` VALUES("11391", "_transient_timeout_external_ip_address_192.168.0.208", "1454903281", "no");
INSERT INTO `apprenz_options` VALUES("5979", "_site_transient_browser_71e9d81c5317fe08cbeebb649a300dff", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"46.0.2490.80\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `apprenz_options` VALUES("3078", "theme_mods_woodberry", "a:2:{i:0;b:0;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1415423186;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:19:\"primary-widget-area\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:21:\"secondary-widget-area\";a:1:{i:0;s:6:\"text-2\";}s:24:\"first-footer-widget-area\";N;s:25:\"second-footer-widget-area\";N;s:24:\"third-footer-widget-area\";N;s:25:\"fourth-footer-widget-area\";N;}}}", "yes");
INSERT INTO `apprenz_options` VALUES("3079", "woodberry_options", "a:14:{s:11:\"of_template\";a:12:{i:0;a:2:{s:4:\"name\";s:16:\"General Settings\";s:4:\"type\";s:7:\"heading\";}i:1;a:4:{s:4:\"name\";s:11:\"Custom Logo\";s:4:\"desc\";s:62:\"Choose your own logo. Optimal Size: 300px Wide by 90px Height.\";s:2:\"id\";s:14:\"woodberry_logo\";s:4:\"type\";s:6:\"upload\";}i:2;a:4:{s:4:\"name\";s:14:\"Custom Favicon\";s:4:\"desc\";s:71:\"Specify a 16px x 16px image that will represent your website\'s favicon.\";s:2:\"id\";s:17:\"woodberry_favicon\";s:4:\"type\";s:6:\"upload\";}i:3;a:2:{s:4:\"name\";s:18:\"Front Page Setting\";s:4:\"type\";s:7:\"heading\";}i:4;a:5:{s:4:\"name\";s:13:\"Feature Image\";s:4:\"desc\";s:71:\"Choose your image or video. Optimal size is 445px wide and height 296px\";s:2:\"id\";s:16:\"woodberry_image1\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"upload\";}i:5;a:5:{s:4:\"name\";s:15:\"Feature Heading\";s:4:\"desc\";s:36:\"Enter your text heading for feature.\";s:2:\"id\";s:25:\"woodberry_slider_heading1\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"textarea\";}i:6;a:5:{s:4:\"name\";s:19:\"Feature Description\";s:4:\"desc\";s:40:\"Enter your text description for feature.\";s:2:\"id\";s:21:\"woodberry_slider_des1\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"textarea\";}i:7;a:5:{s:4:\"name\";s:19:\"Feature Button Text\";s:4:\"desc\";s:47:\"Enter your text description for feature button.\";s:2:\"id\";s:22:\"woodberry_slider_btnt1\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";}i:8;a:5:{s:4:\"name\";s:15:\"Button Link URL\";s:4:\"desc\";s:39:\"Enter your link url for feature button.\";s:2:\"id\";s:25:\"woodberry_slider_btnlink1\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";}i:9;a:5:{s:4:\"name\";s:20:\"Main Feature Heading\";s:4:\"desc\";s:33:\"Enter your text for Page Heading.\";s:2:\"id\";s:19:\"woodberry_page_head\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"textarea\";}i:10;a:2:{s:4:\"name\";s:15:\"Styling Options\";s:4:\"type\";s:7:\"heading\";}i:11;a:5:{s:4:\"name\";s:10:\"Custom CSS\";s:4:\"desc\";s:62:\"Quickly add some CSS to your theme by adding it to this block.\";s:2:\"id\";s:19:\"woodberry_customcss\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"textarea\";}}s:12:\"of_themename\";s:9:\"WoodBerry\";s:12:\"of_shortname\";s:2:\"of\";s:20:\"woodberry_post_front\";b:1;s:14:\"woodberry_logo\";s:0:\"\";s:17:\"woodberry_favicon\";s:0:\"\";s:16:\"woodberry_image1\";s:0:\"\";s:25:\"woodberry_slider_heading1\";s:0:\"\";s:21:\"woodberry_slider_des1\";s:0:\"\";s:22:\"woodberry_slider_btnt1\";s:0:\"\";s:25:\"woodberry_slider_btnlink1\";s:0:\"\";s:19:\"woodberry_page_head\";s:0:\"\";s:19:\"woodberry_customcss\";s:0:\"\";s:10:\"of_options\";a:9:{s:14:\"woodberry_logo\";s:0:\"\";s:17:\"woodberry_favicon\";s:0:\"\";s:16:\"woodberry_image1\";s:0:\"\";s:25:\"woodberry_slider_heading1\";s:0:\"\";s:21:\"woodberry_slider_des1\";s:0:\"\";s:22:\"woodberry_slider_btnt1\";s:0:\"\";s:25:\"woodberry_slider_btnlink1\";s:0:\"\";s:19:\"woodberry_page_head\";s:0:\"\";s:19:\"woodberry_customcss\";s:0:\"\";}}", "yes");
INSERT INTO `apprenz_options` VALUES("5695", "themerex_options_category_114", "a:127:{s:10:\"theme_skin\";s:7:\"inherit\";s:11:\"theme_color\";s:7:\"inherit\";s:10:\"menu_color\";s:7:\"inherit\";s:15:\"user_menu_color\";s:7:\"inherit\";s:21:\"show_theme_customizer\";s:7:\"inherit\";s:10:\"custom_css\";s:7:\"inherit\";s:11:\"custom_code\";s:7:\"inherit\";s:10:\"body_style\";s:7:\"inherit\";s:13:\"load_bg_image\";s:7:\"inherit\";s:8:\"bg_color\";s:7:\"inherit\";s:10:\"bg_pattern\";s:7:\"inherit\";s:17:\"bg_custom_pattern\";s:7:\"inherit\";s:8:\"bg_image\";s:7:\"inherit\";s:15:\"bg_custom_image\";s:7:\"inherit\";s:24:\"bg_custom_image_position\";s:7:\"inherit\";s:13:\"show_video_bg\";s:7:\"inherit\";s:21:\"video_bg_youtube_code\";s:7:\"inherit\";s:12:\"video_bg_url\";s:7:\"inherit\";s:16:\"video_bg_overlay\";s:7:\"inherit\";s:10:\"logo_image\";s:7:\"inherit\";s:8:\"logo_top\";s:7:\"inherit\";s:10:\"logo_fixed\";s:7:\"inherit\";s:9:\"logo_side\";s:7:\"inherit\";s:9:\"logo_text\";s:7:\"inherit\";s:11:\"logo_slogan\";s:7:\"inherit\";s:11:\"logo_height\";s:7:\"inherit\";s:11:\"logo_offset\";s:7:\"inherit\";s:10:\"logo_align\";s:7:\"inherit\";s:17:\"logo_image_footer\";s:7:\"inherit\";s:24:\"logo_image_footer_height\";s:7:\"inherit\";s:14:\"show_top_panel\";s:7:\"inherit\";s:9:\"menu_main\";s:7:\"inherit\";s:10:\"menu_style\";s:7:\"inherit\";s:13:\"menu_position\";s:7:\"inherit\";s:10:\"menu_align\";s:7:\"inherit\";s:10:\"menu_width\";s:7:\"inherit\";s:14:\"show_user_menu\";s:7:\"inherit\";s:9:\"menu_user\";s:7:\"inherit\";s:17:\"show_contact_info\";s:7:\"inherit\";s:13:\"show_currency\";s:7:\"inherit\";s:9:\"show_cart\";s:7:\"inherit\";s:14:\"show_languages\";s:7:\"inherit\";s:10:\"show_login\";s:7:\"inherit\";s:15:\"show_left_panel\";s:7:\"inherit\";s:9:\"menu_side\";s:7:\"inherit\";s:9:\"logo_icon\";s:7:\"inherit\";s:16:\"show_right_panel\";s:7:\"inherit\";s:10:\"menu_panel\";s:7:\"inherit\";s:18:\"right_panel_button\";s:7:\"inherit\";s:15:\"right_panel_tab\";s:7:\"inherit\";s:8:\"menu_toc\";s:7:\"inherit\";s:13:\"menu_toc_home\";s:7:\"inherit\";s:12:\"menu_toc_top\";s:7:\"inherit\";s:16:\"show_sidebar_top\";s:7:\"inherit\";s:11:\"sidebar_top\";s:7:\"inherit\";s:17:\"show_sidebar_main\";s:7:\"inherit\";s:12:\"sidebar_main\";s:7:\"inherit\";s:19:\"show_sidebar_footer\";s:7:\"inherit\";s:20:\"sidebar_footer_style\";s:7:\"inherit\";s:14:\"sidebar_footer\";s:7:\"inherit\";s:18:\"show_sidebar_panel\";s:7:\"inherit\";s:13:\"sidebar_panel\";s:7:\"inherit\";s:11:\"slider_show\";s:7:\"inherit\";s:14:\"slider_display\";s:7:\"inherit\";s:13:\"slider_height\";s:7:\"inherit\";s:13:\"slider_engine\";s:7:\"inherit\";s:12:\"slider_alias\";s:7:\"inherit\";s:15:\"slider_category\";s:7:\"inherit\";s:12:\"slider_posts\";s:7:\"inherit\";s:14:\"slider_orderby\";s:7:\"inherit\";s:12:\"slider_order\";s:7:\"inherit\";s:15:\"slider_interval\";s:7:\"inherit\";s:15:\"slider_info_box\";s:7:\"inherit\";s:17:\"slider_info_fixed\";s:7:\"inherit\";s:20:\"slider_info_category\";s:7:\"inherit\";s:14:\"slider_reviews\";s:7:\"inherit\";s:19:\"slider_descriptions\";s:7:\"inherit\";s:16:\"show_user_header\";s:7:\"inherit\";s:19:\"user_header_content\";s:7:\"inherit\";s:13:\"show_top_page\";s:7:\"inherit\";s:15:\"show_page_title\";s:7:\"inherit\";s:16:\"show_breadcrumbs\";s:7:\"inherit\";s:16:\"show_user_footer\";s:7:\"inherit\";s:19:\"user_footer_content\";s:7:\"inherit\";s:23:\"show_contacts_in_footer\";s:7:\"inherit\";s:22:\"show_twitter_in_footer\";s:7:\"inherit\";s:29:\"show_copyright_area_in_footer\";s:7:\"inherit\";s:14:\"googlemap_show\";s:7:\"inherit\";s:16:\"googlemap_height\";s:7:\"inherit\";s:17:\"googlemap_address\";s:7:\"inherit\";s:16:\"googlemap_latlng\";s:7:\"inherit\";s:14:\"googlemap_zoom\";s:7:\"inherit\";s:15:\"googlemap_style\";s:7:\"inherit\";s:18:\"substitute_gallery\";s:7:\"inherit\";s:24:\"substitute_slider_engine\";s:7:\"inherit\";s:21:\"gallery_instead_image\";s:7:\"inherit\";s:18:\"gallery_max_slides\";s:7:\"inherit\";s:25:\"substitute_gallery_layout\";s:7:\"inherit\";s:16:\"substitute_audio\";s:7:\"inherit\";s:16:\"substitute_video\";s:7:\"inherit\";s:10:\"blog_style\";s:7:\"inherit\";s:11:\"hover_style\";s:7:\"inherit\";s:9:\"hover_dir\";s:7:\"inherit\";s:18:\"dedicated_location\";s:5:\"alter\";s:12:\"show_filters\";s:7:\"inherit\";s:15:\"filter_taxonomy\";s:7:\"inherit\";s:9:\"blog_sort\";s:7:\"inherit\";s:10:\"blog_order\";s:7:\"inherit\";s:14:\"posts_per_page\";s:7:\"inherit\";s:12:\"single_style\";s:7:\"inherit\";s:19:\"show_featured_image\";s:7:\"inherit\";s:15:\"show_post_title\";s:7:\"inherit\";s:25:\"show_post_title_on_quotes\";s:7:\"inherit\";s:14:\"show_post_info\";s:7:\"inherit\";s:16:\"show_post_author\";s:7:\"inherit\";s:14:\"show_post_tags\";s:7:\"inherit\";s:18:\"show_post_counters\";s:7:\"inherit\";s:17:\"show_post_related\";s:7:\"inherit\";s:18:\"post_related_count\";s:7:\"inherit\";s:18:\"show_post_comments\";s:7:\"inherit\";s:15:\"blog_pagination\";s:7:\"inherit\";s:21:\"blog_pagination_style\";s:7:\"inherit\";s:13:\"blog_counters\";s:7:\"inherit\";s:14:\"close_category\";s:7:\"inherit\";s:15:\"show_date_after\";s:7:\"inherit\";s:12:\"show_reviews\";s:7:\"inherit\";s:17:\"reviews_criterias\";s:7:\"inherit\";}", "yes");
INSERT INTO `apprenz_options` VALUES("1276", "wpseo", "a:20:{s:14:\"blocking_files\";a:0:{}s:26:\"ignore_blog_public_warning\";b:0;s:31:\"ignore_meta_description_warning\";b:0;s:20:\"ignore_page_comments\";b:0;s:16:\"ignore_permalink\";b:0;s:15:\"ms_defaults_set\";b:0;s:23:\"theme_description_found\";s:0:\"\";s:21:\"theme_has_description\";b:0;s:7:\"version\";s:5:\"2.3.5\";s:11:\"alexaverify\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:0:\"\";s:20:\"disableadvanced_meta\";b:0;s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:12:\"website_name\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";}", "yes");
INSERT INTO `apprenz_options` VALUES("1277", "wpseo_titles", "a:63:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:5:\"noodp\";b:0;s:6:\"noydir\";b:0;s:15:\"usemetakeywords\";b:0;s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page Not Found %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:18:\"metakey-home-wpseo\";s:0:\"\";s:20:\"metakey-author-wpseo\";s:0:\"\";s:22:\"noindex-subpages-wpseo\";b:1;s:20:\"noindex-author-wpseo\";b:0;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"metakey-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:16:\"hideeditbox-post\";b:0;s:10:\"title-page\";s:18:\"%%title%% %%page%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"metakey-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:16:\"hideeditbox-page\";b:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"metakey-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:22:\"hideeditbox-attachment\";b:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:20:\"metakey-tax-category\";s:0:\"\";s:24:\"hideeditbox-tax-category\";b:0;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:20:\"metakey-tax-post_tag\";s:0:\"\";s:24:\"hideeditbox-tax-post_tag\";b:0;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:23:\"metakey-tax-post_format\";s:0:\"\";s:27:\"hideeditbox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:0;s:19:\"title-otw-portfolio\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:22:\"metadesc-otw-portfolio\";s:0:\"\";s:29:\"title-ptarchive-otw-portfolio\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:32:\"metadesc-ptarchive-otw-portfolio\";s:0:\"\";s:19:\"noindex-post_format\";b:1;s:28:\"title-otw-portfolio-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-otw-portfolio-category\";s:0:\"\";s:16:\"title-slide-page\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-slide-page\";s:0:\"\";}", "yes");
INSERT INTO `apprenz_options` VALUES("1278", "wpseo_xml", "a:16:{s:22:\"disable_author_sitemap\";b:1;s:22:\"disable_author_noposts\";b:0;s:16:\"enablexmlsitemap\";b:1;s:16:\"entries-per-page\";i:1000;s:14:\"excluded-posts\";s:0:\"\";s:38:\"user_role-administrator-not_in_sitemap\";b:0;s:31:\"user_role-editor-not_in_sitemap\";b:0;s:31:\"user_role-author-not_in_sitemap\";b:0;s:36:\"user_role-contributor-not_in_sitemap\";b:0;s:35:\"user_role-subscriber-not_in_sitemap\";b:0;s:30:\"post_types-post-not_in_sitemap\";b:0;s:30:\"post_types-page-not_in_sitemap\";b:0;s:36:\"post_types-attachment-not_in_sitemap\";b:1;s:34:\"taxonomies-category-not_in_sitemap\";b:0;s:34:\"taxonomies-post_tag-not_in_sitemap\";b:0;s:37:\"taxonomies-post_format-not_in_sitemap\";b:0;}", "yes");
INSERT INTO `apprenz_options` VALUES("1279", "wpseo_social", "a:21:{s:9:\"fb_admins\";a:0:{}s:12:\"fbconnectkey\";s:32:\"1d738fb4591ed70a21abb31602cb8dcf\";s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:9:\"opengraph\";b:1;s:10:\"googleplus\";b:0;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:14:\"plus-publisher\";s:0:\"\";s:7:\"twitter\";b:0;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:7:\"summary\";s:11:\"youtube_url\";s:0:\"\";s:15:\"google_plus_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}", "yes");
INSERT INTO `apprenz_options` VALUES("1280", "wpseo_rss", "a:1:{s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";}", "yes");
INSERT INTO `apprenz_options` VALUES("1281", "wpseo_permalinks", "a:13:{s:15:\"cleanpermalinks\";b:0;s:24:\"cleanpermalink-extravars\";s:0:\"\";s:29:\"cleanpermalink-googlecampaign\";b:0;s:31:\"cleanpermalink-googlesitesearch\";b:0;s:15:\"cleanreplytocom\";b:0;s:10:\"cleanslugs\";b:1;s:14:\"hide-feedlinks\";b:0;s:12:\"hide-rsdlink\";b:0;s:14:\"hide-shortlink\";b:0;s:16:\"hide-wlwmanifest\";b:0;s:18:\"redirectattachment\";b:0;s:17:\"stripcategorybase\";b:0;s:13:\"trailingslash\";b:0;}", "yes");
INSERT INTO `apprenz_options` VALUES("5632", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `apprenz_options` VALUES("5536", "yith_maintenance_enable", "", "yes");
INSERT INTO `apprenz_options` VALUES("5537", "yith_maintenance_roles", "a:1:{i:0;s:13:\"administrator\";}", "yes");
INSERT INTO `apprenz_options` VALUES("5538", "yith_maintenance_http_status", "200", "yes");
INSERT INTO `apprenz_options` VALUES("5539", "yith_maintenance_skin", "skin1", "yes");
INSERT INTO `apprenz_options` VALUES("5540", "yith_maintenance_message", "<h3>Scheduled Maintenance</h3>\r\n<p>Please come back later! Meanwhile, you can contact us on contact@apprenz.com</p>", "yes");
INSERT INTO `apprenz_options` VALUES("5541", "yith_maintenance_custom_style", "", "yes");
INSERT INTO `apprenz_options` VALUES("5542", "yith_maintenance_mascotte", "http://apprenz.com/wp-content/plugins/yith-maintenance-mode/assets/images/mascotte.png", "yes");
INSERT INTO `apprenz_options` VALUES("5543", "yith_maintenance_title_font", "a:5:{s:4:\"size\";s:2:\"18\";s:4:\"unit\";s:2:\"px\";s:6:\"family\";s:9:\"Open Sans\";s:5:\"style\";s:4:\"bold\";s:5:\"color\";s:7:\"#666666\";}", "yes");
INSERT INTO `apprenz_options` VALUES("5544", "yith_maintenance_paragraph_font", "a:5:{s:4:\"size\";s:2:\"13\";s:4:\"unit\";s:2:\"px\";s:6:\"family\";s:9:\"Open Sans\";s:5:\"style\";s:7:\"regular\";s:5:\"color\";s:7:\"#666666\";}", "yes");
INSERT INTO `apprenz_options` VALUES("5545", "yith_maintenance_border_top", "#fcd358", "yes");
INSERT INTO `apprenz_options` VALUES("5546", "yith_maintenance_background_image", "http://apprenz.com/wp-content/plugins/yith-maintenance-mode/assets/images/bg-pattern.png", "yes");
INSERT INTO `apprenz_options` VALUES("5547", "yith_maintenance_background_color", "", "yes");
INSERT INTO `apprenz_options` VALUES("5548", "yith_maintenance_background_repeat", "repeat", "yes");
INSERT INTO `apprenz_options` VALUES("5549", "yith_maintenance_background_position", "top left", "yes");
INSERT INTO `apprenz_options` VALUES("5550", "yith_maintenance_background_attachment", "scroll", "yes");
INSERT INTO `apprenz_options` VALUES("5551", "yith_maintenance_logo_image", "http://apprenz.com/wp-content/uploads/2014/11/logo-Apprenz.png", "yes");
INSERT INTO `apprenz_options` VALUES("5552", "yith_maintenance_logo_tagline", "", "yes");
INSERT INTO `apprenz_options` VALUES("5553", "yith_maintenance_logo_tagline_font", "a:5:{s:4:\"size\";s:2:\"15\";s:4:\"unit\";s:2:\"px\";s:6:\"family\";s:9:\"Open Sans\";s:5:\"style\";s:7:\"regular\";s:5:\"color\";s:7:\"#999999\";}", "yes");
INSERT INTO `apprenz_options` VALUES("5554", "yith_maintenance_enable_newsletter_form", "", "yes");
INSERT INTO `apprenz_options` VALUES("5555", "yith_maintenance_newsletter_email_font", "a:5:{s:4:\"size\";s:2:\"12\";s:4:\"unit\";s:2:\"px\";s:6:\"family\";s:9:\"Open Sans\";s:5:\"style\";s:4:\"bold\";s:5:\"color\";s:7:\"#a3a3a3\";}", "yes");
INSERT INTO `apprenz_options` VALUES("5556", "yith_maintenance_newsletter_submit_font", "a:5:{s:4:\"size\";s:2:\"16\";s:4:\"unit\";s:2:\"px\";s:6:\"family\";s:9:\"Open Sans\";s:5:\"style\";s:10:\"extra-bold\";s:5:\"color\";s:4:\"#fff\";}", "yes");
INSERT INTO `apprenz_options` VALUES("5557", "yith_maintenance_newsletter_submit_background", "#617291", "yes");
INSERT INTO `apprenz_options` VALUES("5558", "yith_maintenance_newsletter_submit_background_hover", "#3c5072", "yes");
INSERT INTO `apprenz_options` VALUES("5559", "yith_maintenance_newsletter_title", "", "yes");
INSERT INTO `apprenz_options` VALUES("5560", "yith_maintenance_newsletter_action", "", "yes");
INSERT INTO `apprenz_options` VALUES("5561", "yith_maintenance_newsletter_method", "POST", "yes");
INSERT INTO `apprenz_options` VALUES("5562", "yith_maintenance_newsletter_email_label", "Enter your email address", "yes");
INSERT INTO `apprenz_options` VALUES("5563", "yith_maintenance_newsletter_email_name", "email", "yes");
INSERT INTO `apprenz_options` VALUES("5564", "yith_maintenance_newsletter_submit_label", "NOTIFY ME", "yes");
INSERT INTO `apprenz_options` VALUES("5565", "yith_maintenance_newsletter_hidden_fields", "", "yes");
INSERT INTO `apprenz_options` VALUES("5566", "yith_maintenance_socials_facebook", "", "yes");
INSERT INTO `apprenz_options` VALUES("5567", "yith_maintenance_socials_twitter", "", "yes");
INSERT INTO `apprenz_options` VALUES("5568", "yith_maintenance_socials_gplus", "", "yes");
INSERT INTO `apprenz_options` VALUES("5569", "yith_maintenance_socials_youtube", "", "yes");
INSERT INTO `apprenz_options` VALUES("5570", "yith_maintenance_socials_rss", "", "yes");
INSERT INTO `apprenz_options` VALUES("5571", "yith_maintenance_socials_skype", "", "yes");
INSERT INTO `apprenz_options` VALUES("5572", "yith_maintenance_socials_email", "", "yes");
INSERT INTO `apprenz_options` VALUES("5573", "yith_maintenance_socials_behance", "", "yes");
INSERT INTO `apprenz_options` VALUES("5574", "yith_maintenance_socials_dribble", "", "yes");
INSERT INTO `apprenz_options` VALUES("5575", "yith_maintenance_socials_flickr", "", "yes");
INSERT INTO `apprenz_options` VALUES("5576", "yith_maintenance_socials_instagram", "", "yes");
INSERT INTO `apprenz_options` VALUES("5577", "yith_maintenance_socials_pinterest", "", "yes");
INSERT INTO `apprenz_options` VALUES("5578", "yith_maintenance_socials_tumblr", "", "yes");
INSERT INTO `apprenz_options` VALUES("5579", "yith_maintenance_socials_linkedin", "", "yes");
INSERT INTO `apprenz_options` VALUES("36516", "_site_transient_otw_upd_plug", "O:8:\"stdClass\":2:{s:12:\"last_updated\";i:1567578456;s:4:\"data\";a:1:{s:32:\"255856f4328a7deda224ad6e5147a2e2\";a:11:{s:7:\"version\";s:4:\"1.15\";s:3:\"key\";b:0;s:4:\"mode\";s:0:\"\";s:4:\"slug\";s:20:\"widget-manager-light\";s:8:\"settings\";a:3:{s:11:\"menu_parent\";s:7:\"otw-wml\";s:7:\"lc_name\";s:15:\"License Manager\";s:8:\"menu_key\";s:7:\"otw-wml\";}s:6:\"domain\";s:11:\"apprenz.com\";s:4:\"path\";s:43:\"widget-manager-light/otw_widget_manager.php\";s:2:\"ip\";s:12:\"51.75.119.84\";s:2:\"id\";s:32:\"255856f4328a7deda224ad6e5147a2e2\";s:4:\"dnms\";b:0;s:4:\"info\";a:10:{s:5:\"valid\";s:3:\"yes\";s:8:\"messages\";a:1:{i:0;a:5:{s:5:\"title\";s:29:\"Buy Pro, Activate 7day trial \";s:4:\"type\";s:7:\"message\";s:5:\"stype\";s:2:\"pp\";s:4:\"text\";s:1084:\"<i class=\"otw-factory-icon fa fa-arrow-circle-o-up\"></i><br />\r\n<div class=\"otw-factory-rcol\"><h3 class=\"otw_factory_head\">#plugin_name# - Online Documentation</h3><div class=\"otw_factory_body\">Check online documentation for the Lite version.<br />\r\n<a href=\"#lite_doc_url#\"  target=\"_blank\">Lite Documentation</a></div><br />\r\n<h3 class=\"otw_factory_head\">Upgrade to the Pro version</h3><div class=\"otw_factory_body\">Upgrade to Pro version to get premium support and the full list of features.</div><div class=\"otw_factory_action\"><a href=\"#pro_plugin_url#\" class=\"otw_factory_button_action button button-primary\" target=\"_blank\">Buy Pro license</a></div><br />\r\n<h3 class=\"otw_factory_head\">Activate the Pro version for 7 days for free!</h3><div class=\"otw_factory_body\">Get access to the full list of features for 7 days for free. No additional info needed. <br />You can return to the Lite version any time.</div><div class=\"otw_factory_action\"><a href=\"#adminurl_actvate_7pt#\" class=\"otw_factory_button_action button\">Activate Pro version 7-day free trial</a></div><br />\r\n</div>\";s:4:\"vars\";a:4:{s:11:\"plugin_name\";s:20:\"Widget Manager Light\";s:12:\"lite_doc_url\";s:132:\"http://otwthemes.com/online-documentation-widget-manager-light/?utm_source=wp.org&utm_medium=admin&utm_content=docs&utm_campaign=wml\";s:14:\"pro_plugin_url\";s:158:\"https://codecanyon.net/item/sidebar-widget-manager-for-wordpress/2287447?ref=OTWthemes&utm_source=wp.org&utm_medium=admin&utm_content=upgrade&utm_campaign=sbm\";s:20:\"adminurl_actvate_7pt\";s:61:\"?page=otwfcr&otwa=a7pt&otwpc=255856f4328a7deda224ad6e5147a2e2\";}}}s:7:\"actions\";a:0:{}s:4:\"keys\";a:0:{}s:12:\"row_messages\";a:0:{}s:16:\"license_messages\";a:1:{i:0;a:5:{s:5:\"title\";s:12:\"License type\";s:4:\"type\";s:7:\"message\";s:5:\"stype\";s:2:\"lm\";s:4:\"text\";s:677:\"You have a Lite version license activated.<br />\r\n<br />\r\nCheck online documentation for the Lite version.<br />\r\n<a href=\"#lite_doc_url#\"  target=\"_blank\">Lite Documentation</a> <br />\r\n<br />\r\nUpgrade to Pro version to get premium support and the full list of features.<br />\r\n<a href=\"#pro_plugin_url#\" class=\"otw_factory_button_action button button-primary\" target=\"_blank\">Buy Pro license</a> <br />\r\n<br />\r\nGet access to the full list of features for 7 days for free. No additional info needed.<br />\r\nYou can return to the Lite version any time.<br />\r\n<a href=\"#adminurl_actvate_7pt#\" class=\"otw_factory_button_action button\">Activate Pro version 7-day free trial</a> \";s:4:\"vars\";a:3:{s:12:\"lite_doc_url\";s:132:\"http://otwthemes.com/online-documentation-widget-manager-light/?utm_source=wp.org&utm_medium=admin&utm_content=docs&utm_campaign=wml\";s:14:\"pro_plugin_url\";s:158:\"https://codecanyon.net/item/sidebar-widget-manager-for-wordpress/2287447?ref=OTWthemes&utm_source=wp.org&utm_medium=admin&utm_content=upgrade&utm_campaign=sbm\";s:20:\"adminurl_actvate_7pt\";s:61:\"?page=otwfcr&otwa=a7pt&otwpc=255856f4328a7deda224ad6e5147a2e2\";}}}s:5:\"state\";b:0;s:8:\"homepage\";s:51:\"https://wordpress.org/plugins/widget-manager-light/\";s:4:\"name\";s:20:\"Widget Manager Light\";s:11:\"new_version\";a:0:{}}}}}", "yes");
INSERT INTO `apprenz_options` VALUES("46119", "_transient_timeout_wc_uf_pid_4266c1ddcdb41a8e0dad4e240f73c5f0", "1560090268", "no");
INSERT INTO `apprenz_options` VALUES("46120", "_transient_wc_uf_pid_4266c1ddcdb41a8e0dad4e240f73c5f0", "a:0:{}", "no");
INSERT INTO `apprenz_options` VALUES("40204", "_transient_timeout_external_ip_address_193.169.252.184", "1532068262", "no");
INSERT INTO `apprenz_options` VALUES("40934", "_transient_external_ip_address_91.207.175.103", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("48684", "_transient_timeout_feed_mod_e9203ae66c43bb23cbb925831ef2893e", "1567681883", "no");
INSERT INTO `apprenz_options` VALUES("48685", "_transient_feed_mod_e9203ae66c43bb23cbb925831ef2893e", "1567638683", "no");
INSERT INTO `apprenz_options` VALUES("39908", "_transient_timeout_external_ip_address_2002:c1a9:fc51::c1a9:fc51", "1531102798", "no");
INSERT INTO `apprenz_options` VALUES("39909", "_transient_external_ip_address_2002:c1a9:fc51::c1a9:fc51", "503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.", "no");
INSERT INTO `apprenz_options` VALUES("39690", "_transient_timeout_external_ip_address_2002:c1a9:fc4d::c1a9:fc4d", "1529996156", "no");
INSERT INTO `apprenz_options` VALUES("39691", "_transient_external_ip_address_2002:c1a9:fc4d::c1a9:fc4d", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("40933", "_transient_timeout_external_ip_address_91.207.175.103", "1535842215", "no");
INSERT INTO `apprenz_options` VALUES("37018", "_transient_timeout_external_ip_address_185.235.0.6", "1520533823", "no");
INSERT INTO `apprenz_options` VALUES("37019", "_transient_external_ip_address_185.235.0.6", "213.251.182.106", "no");
INSERT INTO `apprenz_options` VALUES("43959", "_site_transient_timeout_browser_0ac1f9240df96b3586c220faef490724", "1548853341", "yes");
INSERT INTO `apprenz_options` VALUES("43960", "_site_transient_browser_0ac1f9240df96b3586c220faef490724", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"71.0.3578.98\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO `apprenz_options` VALUES("48584", "_transient_timeout_wpseo_sitemap_cache_post_1", "1567377429", "no");
INSERT INTO `apprenz_options` VALUES("48585", "_transient_wpseo_sitemap_cache_post_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://apprenz.com/blog-streampage/</loc>\n		<changefreq>daily</changefreq>\n		<priority>1</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/basic-forms-of-business-ownership/</loc>\n		<lastmod>2014-08-21T12:36:09+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/8.jpg</image:loc>\n			<image:caption><![CDATA[Optimizing your Website for Mobile Search]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/organization-and-government-regulation/</loc>\n		<lastmod>2014-08-20T12:37:33+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/11.jpg</image:loc>\n			<image:caption><![CDATA[Advanced Guide to Google Penalty Removal]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/origins-and-vernacular-architecture/</loc>\n		<lastmod>2014-08-19T12:37:55+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/13.jpg</image:loc>\n			<image:caption><![CDATA[Website Speed and Search Rankings]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/multi-card-hybrid-phones/</loc>\n		<lastmod>2014-08-17T12:38:52+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/7.jpg</image:loc>\n			<image:caption><![CDATA[Improving SEO Rankings with Google Plus]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/perfect-theme-perfect-support/</loc>\n		<lastmod>2014-08-16T08:50:37+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/10.jpg</image:loc>\n			<image:caption><![CDATA[Importance of Using Google Webmaster Tools]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/great-support-with-fast-and-competent-responses/</loc>\n		<lastmod>2014-08-16T08:40:23+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/16.jpg</image:loc>\n			<image:caption><![CDATA[Top Paying Adsense Keywords List 2014]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/video/</loc>\n		<lastmod>2014-06-25T08:23:07+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tooltip/</loc>\n		<lastmod>2014-06-25T08:27:03+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/toggles/</loc>\n		<lastmod>2014-06-25T08:31:31+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/testimonials/</loc>\n		<lastmod>2014-06-25T08:35:55+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/team/</loc>\n		<lastmod>2014-06-25T08:40:11+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/tabs/</loc>\n		<lastmod>2014-06-25T09:21:54+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/table/</loc>\n		<lastmod>2014-06-25T09:24:18+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/banner/</loc>\n		<lastmod>2014-06-25T09:25:15+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/contact-form/</loc>\n		<lastmod>2014-06-25T09:28:17+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/slider/</loc>\n		<lastmod>2014-06-25T09:29:15+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/skills-arc-counter/</loc>\n		<lastmod>2014-06-25T09:30:53+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/skills-pie/</loc>\n		<lastmod>2014-06-25T09:34:03+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/skills-bar/</loc>\n		<lastmod>2014-06-25T09:35:21+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/section-block/</loc>\n		<lastmod>2014-06-25T09:36:59+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/quote/</loc>\n		<lastmod>2014-06-25T09:38:16+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/list/</loc>\n		<lastmod>2014-06-25T09:39:39+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/line/</loc>\n		<lastmod>2014-06-25T09:43:21+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/infobox/</loc>\n		<lastmod>2014-06-25T09:44:12+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/title/</loc>\n		<lastmod>2014-06-25T09:45:08+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/image/</loc>\n		<lastmod>2014-06-25T09:51:52+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/highlight/</loc>\n		<lastmod>2014-06-25T09:54:39+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/google-map/</loc>\n		<lastmod>2014-06-25T09:55:54+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/dropcaps/</loc>\n		<lastmod>2014-06-25T10:58:27+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/columns/</loc>\n		<lastmod>2014-06-25T11:01:36+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/button/</loc>\n		<lastmod>2014-06-25T11:02:50+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/blogger-part-2/</loc>\n		<lastmod>2014-06-25T11:04:55+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/blogger-part-1/</loc>\n		<lastmod>2014-06-25T11:09:31+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/zoom/</loc>\n		<lastmod>2014-06-25T11:11:09+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/audio/</loc>\n		<lastmod>2014-06-25T11:25:32+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/accordion/</loc>\n		<lastmod>2014-06-25T11:33:17+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/video-post-example/</loc>\n		<lastmod>2014-07-20T07:40:10+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/audio-post-example-with-cover-image/</loc>\n		<lastmod>2014-07-19T07:42:35+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/wp-standard-gallery/</loc>\n		<lastmod>2014-07-18T07:46:25+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/theme-styled-wp-gallery/</loc>\n		<lastmod>2014-07-17T07:55:36+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/theme-slider-instead-wp-gallery/</loc>\n		<lastmod>2014-07-16T07:57:45+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/quote-post/</loc>\n		<lastmod>2014-07-15T08:12:43+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/status-post/</loc>\n		<lastmod>2014-07-13T08:14:49+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/link-post/</loc>\n		<lastmod>2014-07-14T08:15:51+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/aside-post/</loc>\n		<lastmod>2014-07-12T08:26:37+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/chat-post/</loc>\n		<lastmod>2014-07-11T08:28:15+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/vivamus-pharetra-justo/</loc>\n		<lastmod>2014-08-29T10:58:36+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/32.jpg</image:loc>\n			<image:caption><![CDATA[Advertising Website]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/ut-vitae-lacus-pretium/</loc>\n		<lastmod>2014-08-29T11:04:26+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/41.jpg</image:loc>\n			<image:caption><![CDATA[Home Repair Website]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/proin-vel-odio-eu-velit/</loc>\n		<lastmod>2014-08-29T11:06:07+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/10.jpg</image:loc>\n			<image:caption><![CDATA[Pet Care Services Website]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/ut-a-neque-tellus/</loc>\n		<lastmod>2014-08-29T11:07:10+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/81.jpg</image:loc>\n			<image:caption><![CDATA[Online Cinema Website]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/vestibulum-ut-lacus-et-magna/</loc>\n		<lastmod>2014-08-29T11:09:10+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/101.jpg</image:loc>\n			<image:caption><![CDATA[Political Party Website]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/curabitur-auctor-adipiscing/</loc>\n		<lastmod>2014-08-29T11:09:55+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/71.jpg</image:loc>\n			<image:caption><![CDATA[Photography Website]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/donec-lacinia-elementum/</loc>\n		<lastmod>2014-08-29T11:10:49+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/51.jpg</image:loc>\n			<image:caption><![CDATA[Online Blog]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/pellentesque-ullamcorper-dolor/</loc>\n		<lastmod>2014-08-29T11:11:30+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/13.jpg</image:loc>\n			<image:caption><![CDATA[SEO Website]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/aliquam-ultrices-ante-a-facilisis-consequat/</loc>\n		<lastmod>2014-08-29T11:12:07+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/61.jpg</image:loc>\n			<image:caption><![CDATA[Online Clothing Shop]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/donec-vitae-lectus-vel-augue/</loc>\n		<lastmod>2014-08-29T11:12:47+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/111.jpg</image:loc>\n			<image:caption><![CDATA[Beauty Salon Website]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/curabitur-sollicitudin-fringilla-cursus/</loc>\n		<lastmod>2014-08-29T11:13:23+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/91.jpg</image:loc>\n			<image:caption><![CDATA[Legal Help Website]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/pellentesque-felis-purus-vehicula-eu-condimentum/</loc>\n		<lastmod>2014-08-29T11:14:26+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/17.jpg</image:loc>\n			<image:caption><![CDATA[Online Education Website]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/nulla-sollicitudin-id-erat-eu-elementum/</loc>\n		<lastmod>2014-08-29T11:15:07+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/21.jpg</image:loc>\n			<image:caption><![CDATA[Interior Design Website]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/buy-with-confidence-this-theme-is-top-quality/</loc>\n		<lastmod>2014-08-15T06:51:13+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/4.jpg</image:loc>\n			<image:caption><![CDATA[How to Make Money with Google Adsense]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/firstly-thank-you-so-much-for-the-great-template/</loc>\n		<lastmod>2014-08-12T06:59:25+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/2.jpg</image:loc>\n			<image:caption><![CDATA[SEO Musts for Local Business]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/thanks-for-looking-out-for-us-themerex-money-well-spent/</loc>\n		<lastmod>2014-07-31T07:01:15+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/1.jpg</image:loc>\n			<image:caption><![CDATA[How To Get Traffic From Twitter]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/vivamus-maximus-velit-in-lectus-eleifend-efficitur/</loc>\n		<lastmod>2014-07-30T08:03:55+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/14.jpg</image:loc>\n			<image:caption><![CDATA[Search Engine Friendly Redirects]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/vestibulum-ante-ipsum-primis-in-faucibus/</loc>\n		<lastmod>2014-06-25T08:05:57+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/5.jpg</image:loc>\n			<image:caption><![CDATA[Usability &amp; Search Engine Optimization]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/in-sodales-purus-in-interdum-feugiat/</loc>\n		<lastmod>2014-06-10T08:09:48+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/12.jpg</image:loc>\n			<image:caption><![CDATA[Online Business &amp; Internet Marketing]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/curabitur-a-venenatis-elit/</loc>\n		<lastmod>2014-06-06T08:10:44+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2014/08/6.jpg</image:loc>\n			<image:caption><![CDATA[Search Engine Marketing Strategies]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/installation/</loc>\n		<lastmod>2014-09-01T08:43:03+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/vivamus-maximus-velit/</loc>\n		<lastmod>2014-05-01T10:56:07+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2015/04/post-3.jpg</image:loc>\n			<image:caption><![CDATA[10 Marketing Blogs You Should be Reading]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/what-seo-trends-did-not-make-it-to-the-new-year/</loc>\n		<lastmod>2014-04-23T07:35:58+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2015/04/post-2.jpg</image:loc>\n			<image:caption><![CDATA[How to Create Contents That Get Traffic]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/how-to-read-an-seo-report/</loc>\n		<lastmod>2014-04-20T07:36:34+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://apprenz.com/wp-content/uploads/2015/04/post-1.jpg</image:loc>\n			<image:caption><![CDATA[Make Users Fall in Love With Your Website]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://apprenz.com/parallax/</loc>\n		<lastmod>2014-06-24T11:33:13+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://apprenz.com/twitter/</loc>\n		<lastmod>2014-06-23T09:36:07+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `apprenz_options` VALUES("7816", "_transient_geoip_54.251.57.249", "SG", "no");
INSERT INTO `apprenz_options` VALUES("7818", "_transient_timeout_geoip_50.28.39.196", "1448325978", "no");
INSERT INTO `apprenz_options` VALUES("7819", "_transient_geoip_50.28.39.196", "US", "no");
INSERT INTO `apprenz_options` VALUES("7820", "_transient_timeout_geoip_180.76.15.163", "1448327356", "no");
INSERT INTO `apprenz_options` VALUES("7821", "_transient_geoip_180.76.15.163", "CN", "no");
INSERT INTO `apprenz_options` VALUES("7822", "_transient_timeout_geoip_216.145.17.190", "1448327541", "no");
INSERT INTO `apprenz_options` VALUES("7823", "_transient_geoip_216.145.17.190", "US", "no");
INSERT INTO `apprenz_options` VALUES("7827", "_transient_timeout_geoip_204.44.83.228", "1448355229", "no");
INSERT INTO `apprenz_options` VALUES("7825", "_transient_timeout_geoip_107.153.8.135", "1448339657", "no");
INSERT INTO `apprenz_options` VALUES("8759", "_site_transient_timeout_browser_4910e34ab899e1f04ce17d9586e216ff", "1449064720", "yes");
INSERT INTO `apprenz_options` VALUES("8760", "_site_transient_browser_4910e34ab899e1f04ce17d9586e216ff", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"46.0.2490.86\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `apprenz_options` VALUES("5644", "akismet_strictness", "1", "yes");
INSERT INTO `apprenz_options` VALUES("5645", "akismet_show_user_comments_approved", "0", "yes");
INSERT INTO `apprenz_options` VALUES("5646", "wordpress_api_key", "ba0c99bcb5a5", "yes");
INSERT INTO `apprenz_options` VALUES("6621", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1447565188", "yes");
INSERT INTO `apprenz_options` VALUES("6622", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "a:100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";s:4:\"5550\";}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"Post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";s:4:\"3478\";}s:6:\"plugin\";a:3:{s:4:\"name\";s:6:\"plugin\";s:4:\"slug\";s:6:\"plugin\";s:5:\"count\";s:4:\"3435\";}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";s:4:\"2930\";}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";s:4:\"2674\";}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";s:4:\"2131\";}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";s:4:\"2122\";}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";s:4:\"1951\";}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";s:4:\"1918\";}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";s:4:\"1901\";}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";s:4:\"1896\";}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";s:4:\"1842\";}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";s:4:\"1751\";}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"Facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";s:4:\"1552\";}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";s:4:\"1474\";}s:9:\"wordpress\";a:3:{s:4:\"name\";s:9:\"wordpress\";s:4:\"slug\";s:9:\"wordpress\";s:5:\"count\";s:4:\"1434\";}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";s:4:\"1286\";}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";s:4:\"1264\";}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";s:4:\"1249\";}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";s:4:\"1213\";}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";s:4:\"1105\";}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";s:4:\"1044\";}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";s:4:\"1009\";}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";s:3:\"959\";}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";s:3:\"926\";}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";s:3:\"893\";}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"AJAX\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";s:3:\"861\";}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";s:3:\"852\";}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";s:3:\"844\";}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";s:3:\"841\";}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";s:3:\"821\";}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";s:3:\"786\";}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";s:3:\"752\";}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";s:3:\"719\";}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";s:3:\"713\";}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";s:3:\"712\";}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";s:3:\"710\";}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";s:3:\"709\";}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";s:3:\"692\";}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";s:3:\"689\";}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"Share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";s:3:\"687\";}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";s:3:\"667\";}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";s:3:\"665\";}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";s:3:\"660\";}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";s:3:\"636\";}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";s:3:\"624\";}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"CSS\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";s:3:\"618\";}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";s:3:\"617\";}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";s:3:\"611\";}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";s:3:\"609\";}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";s:3:\"589\";}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";s:3:\"587\";}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";s:3:\"572\";}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";s:3:\"572\";}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";s:3:\"563\";}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";s:3:\"562\";}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";s:3:\"560\";}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";s:3:\"558\";}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";s:3:\"551\";}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";s:3:\"545\";}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";s:3:\"535\";}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";s:3:\"514\";}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";s:3:\"513\";}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";s:3:\"509\";}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";s:3:\"507\";}s:7:\"picture\";a:3:{s:4:\"name\";s:7:\"picture\";s:4:\"slug\";s:7:\"picture\";s:5:\"count\";s:3:\"498\";}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";s:3:\"495\";}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";s:3:\"491\";}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";s:3:\"488\";}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";s:3:\"485\";}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";s:3:\"466\";}s:6:\"simple\";a:3:{s:4:\"name\";s:6:\"simple\";s:4:\"slug\";s:6:\"simple\";s:5:\"count\";s:3:\"462\";}s:8:\"pictures\";a:3:{s:4:\"name\";s:8:\"pictures\";s:4:\"slug\";s:8:\"pictures\";s:5:\"count\";s:3:\"449\";}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";s:3:\"443\";}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";s:3:\"438\";}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";s:3:\"437\";}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";s:3:\"425\";}s:5:\"flash\";a:3:{s:4:\"name\";s:5:\"flash\";s:4:\"slug\";s:5:\"flash\";s:5:\"count\";s:3:\"419\";}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";s:3:\"415\";}s:4:\"html\";a:3:{s:4:\"name\";s:4:\"html\";s:4:\"slug\";s:4:\"html\";s:5:\"count\";s:3:\"411\";}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";s:3:\"400\";}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";s:3:\"397\";}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"News\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";s:3:\"394\";}s:4:\"shop\";a:3:{s:4:\"name\";s:4:\"shop\";s:4:\"slug\";s:4:\"shop\";s:5:\"count\";s:3:\"393\";}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";s:3:\"391\";}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";s:3:\"387\";}s:3:\"tag\";a:3:{s:4:\"name\";s:3:\"tag\";s:4:\"slug\";s:3:\"tag\";s:5:\"count\";s:3:\"386\";}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";s:3:\"382\";}s:9:\"thumbnail\";a:3:{s:4:\"name\";s:9:\"thumbnail\";s:4:\"slug\";s:9:\"thumbnail\";s:5:\"count\";s:3:\"379\";}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";s:3:\"375\";}s:4:\"text\";a:3:{s:4:\"name\";s:4:\"text\";s:4:\"slug\";s:4:\"text\";s:5:\"count\";s:3:\"375\";}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";s:3:\"373\";}s:11:\"advertising\";a:3:{s:4:\"name\";s:11:\"advertising\";s:4:\"slug\";s:11:\"advertising\";s:5:\"count\";s:3:\"372\";}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";s:3:\"372\";}s:6:\"upload\";a:3:{s:4:\"name\";s:6:\"upload\";s:4:\"slug\";s:6:\"upload\";s:5:\"count\";s:3:\"366\";}s:9:\"automatic\";a:3:{s:4:\"name\";s:9:\"automatic\";s:4:\"slug\";s:9:\"automatic\";s:5:\"count\";s:3:\"364\";}s:7:\"sharing\";a:3:{s:4:\"name\";s:7:\"sharing\";s:4:\"slug\";s:7:\"sharing\";s:5:\"count\";s:3:\"363\";}s:8:\"lightbox\";a:3:{s:4:\"name\";s:8:\"lightbox\";s:4:\"slug\";s:8:\"lightbox\";s:5:\"count\";s:3:\"363\";}s:7:\"profile\";a:3:{s:4:\"name\";s:7:\"profile\";s:4:\"slug\";s:7:\"profile\";s:5:\"count\";s:3:\"362\";}s:14:\"administration\";a:3:{s:4:\"name\";s:14:\"administration\";s:4:\"slug\";s:14:\"administration\";s:5:\"count\";s:3:\"360\";}}", "yes");
INSERT INTO `apprenz_options` VALUES("5650", "GOTMLS_settings_array", "a:13:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:5:\"check\";a:4:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";}s:15:\"skip_quarantine\";i:0;}", "yes");
INSERT INTO `apprenz_options` VALUES("36525", "GOTMLS_scan_log/41.227.65.103/1518535051.2368", "a:2:{s:8:\"settings\";a:13:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:5:\"check\";a:7:{i:0;s:8:\"wp_login\";i:1;s:9:\"whitelist\";i:2;s:8:\"timthumb\";i:3;s:8:\"htaccess\";i:4;s:5:\"known\";i:5;s:8:\"backdoor\";i:6;s:8:\"firewall\";}s:15:\"skip_quarantine\";i:0;}s:4:\"scan\";a:7:{s:3:\"dir\";s:24:\"/home/maento/www/apprenz\";s:5:\"start\";i:1518535052;s:4:\"type\";s:13:\"Complete Scan\";s:9:\"microtime\";d:1360;s:7:\"percent\";i:-1;s:11:\"last_threat\";d:1518536412.8771379;s:6:\"finish\";i:1518536412;}}", "yes");
INSERT INTO `apprenz_options` VALUES("36527", "GOTMLS_scan_log/41.227.65.103/1518536602.2624", "a:2:{s:8:\"settings\";a:13:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:5:\"check\";a:5:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";}s:15:\"skip_quarantine\";i:0;}s:4:\"scan\";a:7:{s:3:\"dir\";s:24:\"/home/maento/www/apprenz\";s:5:\"start\";i:1518536605;s:4:\"type\";s:10:\"Quick Scan\";s:9:\"microtime\";d:14;s:7:\"percent\";i:100;s:11:\"last_threat\";d:1518536619.1774549;s:6:\"finish\";i:1518536619;}}", "yes");
INSERT INTO `apprenz_options` VALUES("36528", "GOTMLS_scan_log/41.227.65.103/1518536604.3406", "a:2:{s:8:\"settings\";a:13:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:5:\"check\";a:5:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";}s:15:\"skip_quarantine\";i:0;}s:4:\"scan\";a:7:{s:3:\"dir\";s:24:\"/home/maento/www/apprenz\";s:5:\"start\";i:1518536605;s:4:\"type\";s:10:\"Quick Scan\";s:9:\"microtime\";d:43;s:7:\"percent\";i:100;s:11:\"last_threat\";d:1518536648.7433021;s:6:\"finish\";i:1518536648;}}", "yes");
INSERT INTO `apprenz_options` VALUES("36529", "GOTMLS_scan_log/41.227.65.103/1518536605.5006", "a:2:{s:8:\"settings\";a:13:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:5:\"check\";a:5:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";}s:15:\"skip_quarantine\";i:0;}s:4:\"scan\";a:6:{s:3:\"dir\";s:24:\"/home/maento/www/apprenz\";s:5:\"start\";i:1518536606;s:4:\"type\";s:10:\"Quick Scan\";s:9:\"microtime\";d:56;s:7:\"percent\";d:22;s:11:\"last_threat\";d:1518536662.305249;}}", "yes");
INSERT INTO `apprenz_options` VALUES("36530", "GOTMLS_scan_log/41.227.65.103/1518536606.0919", "a:2:{s:8:\"settings\";a:13:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:5:\"check\";a:5:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";}s:15:\"skip_quarantine\";i:0;}s:4:\"scan\";a:7:{s:3:\"dir\";s:24:\"/home/maento/www/apprenz\";s:5:\"start\";i:1518536607;s:4:\"type\";s:10:\"Quick Scan\";s:9:\"microtime\";d:21;s:7:\"percent\";i:100;s:11:\"last_threat\";d:1518536628.883534;s:6:\"finish\";i:1518536628;}}", "yes");
INSERT INTO `apprenz_options` VALUES("36531", "GOTMLS_scan_log/41.227.65.103/1518536610.2222", "a:2:{s:8:\"settings\";a:13:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:5:\"check\";a:5:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";}s:15:\"skip_quarantine\";i:0;}s:4:\"scan\";a:6:{s:3:\"dir\";s:24:\"/home/maento/www/apprenz\";s:5:\"start\";i:1518536612;s:4:\"type\";s:10:\"Quick Scan\";s:9:\"microtime\";d:50;s:7:\"percent\";d:22;s:11:\"last_threat\";d:1518536662.161082;}}", "yes");
INSERT INTO `apprenz_options` VALUES("36532", "GOTMLS_scan_log/41.227.65.103/1518536610.8338", "a:2:{s:8:\"settings\";a:13:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:5:\"check\";a:5:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";}s:15:\"skip_quarantine\";i:0;}s:4:\"scan\";a:6:{s:3:\"dir\";s:24:\"/home/maento/www/apprenz\";s:5:\"start\";i:1518536612;s:4:\"type\";s:10:\"Quick Scan\";s:9:\"microtime\";d:54;s:7:\"percent\";d:22;s:11:\"last_threat\";d:1518536666.4468219;}}", "yes");
INSERT INTO `apprenz_options` VALUES("36533", "GOTMLS_scan_log/41.227.65.103/1518536631.4526", "a:2:{s:8:\"settings\";a:13:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:5:\"check\";a:5:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";}s:15:\"skip_quarantine\";i:0;}s:4:\"scan\";a:7:{s:3:\"dir\";s:24:\"/home/maento/www/apprenz\";s:5:\"start\";i:1518536635;s:4:\"type\";s:10:\"Quick Scan\";s:9:\"microtime\";d:19;s:7:\"percent\";i:100;s:11:\"last_threat\";d:1518536654.5281839;s:6:\"finish\";i:1518536654;}}", "yes");
INSERT INTO `apprenz_options` VALUES("36544", "GOTMLS_scan_log/41.228.57.179/1518550647.2142", "a:2:{s:8:\"settings\";a:13:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:5:\"check\";a:5:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";}s:15:\"skip_quarantine\";i:0;}s:4:\"scan\";a:7:{s:3:\"dir\";s:24:\"/home/maento/www/apprenz\";s:5:\"start\";i:1518550650;s:4:\"type\";s:10:\"Quick Scan\";s:9:\"microtime\";d:9;s:7:\"percent\";i:100;s:11:\"last_threat\";d:1518550659.1856101;s:6:\"finish\";i:1518550659;}}", "yes");
INSERT INTO `apprenz_options` VALUES("41515", "_site_transient_timeout_browser_8651940b33fd1e958c905441aa40a03d", "1538997130", "yes");
INSERT INTO `apprenz_options` VALUES("41516", "_site_transient_browser_8651940b33fd1e958c905441aa40a03d", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"69.0.3497.100\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO `apprenz_options` VALUES("48692", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:10:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.2.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.2.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.2.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.2.3-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.2.3\";s:7:\"version\";s:5:\"5.2.3\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.0\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.2.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.2.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.2.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.2.3-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.2.3\";s:7:\"version\";s:5:\"5.2.3\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.0\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:2;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.1.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.1.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.1.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.1.2-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.1.2\";s:7:\"version\";s:5:\"5.1.2\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.0\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:3;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.0.6.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.0.6.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.0.6-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.0.6-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.0.6\";s:7:\"version\";s:5:\"5.0.6\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.0\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:4;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.9.11.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.9.11.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.9.11-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-4.9.11-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"4.9.11\";s:7:\"version\";s:6:\"4.9.11\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.0\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:5;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.8.10.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.8.10.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.8.10-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-4.8.10-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"4.8.10\";s:7:\"version\";s:6:\"4.8.10\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.0\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:6;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.7.14.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.7.14.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.7.14-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-4.7.14-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"4.7.14\";s:7:\"version\";s:6:\"4.7.14\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.0\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:7;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.6.15.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.6.15.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.6.15-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-4.6.15-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"4.6.15\";s:7:\"version\";s:6:\"4.6.15\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.0\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:8;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.5.18.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.5.18.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.5.18-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-4.5.18-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"4.5.18\";s:7:\"version\";s:6:\"4.5.18\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.0\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:9;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.4.19.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.4.19.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.4.19-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-4.4.19-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"4.4.19\";s:7:\"version\";s:6:\"4.4.19\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.0\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}}s:12:\"last_checked\";i:1567663594;s:15:\"version_checked\";s:6:\"4.3.20\";s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `apprenz_options` VALUES("48693", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1567663596;s:7:\"checked\";a:3:{s:3:\"ark\";s:6:\"1.27.1\";s:3:\"seo\";s:3:\"1.2\";s:12:\"twentytwelve\";s:3:\"1.2\";}s:8:\"response\";a:2:{s:3:\"seo\";a:6:{s:5:\"theme\";s:3:\"seo\";s:11:\"new_version\";s:5:\"1.3.2\";s:3:\"url\";s:33:\"https://wordpress.org/themes/seo/\";s:7:\"package\";s:51:\"https://downloads.wordpress.org/theme/seo.1.3.2.zip\";s:8:\"requires\";s:3:\"5.2\";s:12:\"requires_php\";b:0;}s:12:\"twentytwelve\";a:6:{s:5:\"theme\";s:12:\"twentytwelve\";s:11:\"new_version\";s:3:\"3.0\";s:3:\"url\";s:42:\"https://wordpress.org/themes/twentytwelve/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/twentytwelve.3.0.zip\";s:8:\"requires\";s:3:\"3.5\";s:12:\"requires_php\";s:5:\"5.2.4\";}}s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `apprenz_options` VALUES("48694", "_site_transient_update_plugins", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1567663595;s:8:\"response\";a:4:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"4.1.2\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.4.1.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.2.3\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";a:0:{}}s:16:\"gotmls/index.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:20:\"w.org/plugins/gotmls\";s:4:\"slug\";s:6:\"gotmls\";s:6:\"plugin\";s:16:\"gotmls/index.php\";s:11:\"new_version\";s:7:\"4.18.76\";s:3:\"url\";s:37:\"https://wordpress.org/plugins/gotmls/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/gotmls.4.18.76.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/gotmls/assets/icon-256x256.png?rev=1001824\";s:2:\"1x\";s:59:\"https://ps.w.org/gotmls/assets/icon-128x128.png?rev=1001824\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/gotmls/assets/banner-772x250.jpg?rev=1043954\";}s:11:\"banners_rtl\";a:0:{}s:14:\"upgrade_notice\";s:148:\"<p>Cleaned up the Nonce Token code and Quarantine page, fixed recovery link, and added debugging for login errors plus WP head and footer Hooks.</p>\";s:6:\"tested\";s:5:\"5.2.3\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";a:0:{}}s:27:\"wp-optimize/wp-optimize.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:25:\"w.org/plugins/wp-optimize\";s:4:\"slug\";s:11:\"wp-optimize\";s:6:\"plugin\";s:27:\"wp-optimize/wp-optimize.php\";s:11:\"new_version\";s:6:\"3.0.11\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/wp-optimize/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wp-optimize.3.0.11.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/wp-optimize/assets/icon-256x256.png?rev=1552899\";s:2:\"1x\";s:64:\"https://ps.w.org/wp-optimize/assets/icon-128x128.png?rev=1552899\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/wp-optimize/assets/banner-1544x500.png?rev=2125385\";s:2:\"1x\";s:66:\"https://ps.w.org/wp-optimize/assets/banner-772x250.png?rev=2125385\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.2.3\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";a:0:{}}s:30:\"yith-maintenance-mode/init.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:35:\"w.org/plugins/yith-maintenance-mode\";s:4:\"slug\";s:21:\"yith-maintenance-mode\";s:6:\"plugin\";s:30:\"yith-maintenance-mode/init.php\";s:11:\"new_version\";s:5:\"1.3.3\";s:3:\"url\";s:52:\"https://wordpress.org/plugins/yith-maintenance-mode/\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/plugin/yith-maintenance-mode.1.3.3.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:74:\"https://ps.w.org/yith-maintenance-mode/assets/icon-128x128.jpg?rev=1068429\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:77:\"https://ps.w.org/yith-maintenance-mode/assets/banner-1544x500.jpg?rev=1068429\";s:2:\"1x\";s:76:\"https://ps.w.org/yith-maintenance-mode/assets/banner-772x250.jpg?rev=1068429\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.2.3\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";a:0:{}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:6:{s:9:\"hello.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:5:\"1.7.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/hello-dolly.1.7.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855\";s:2:\"1x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:66:\"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.2.3\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";a:0:{}}s:43:\"otw-portfolio-light/otw-portfolio-light.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:33:\"w.org/plugins/otw-portfolio-light\";s:4:\"slug\";s:19:\"otw-portfolio-light\";s:6:\"plugin\";s:43:\"otw-portfolio-light/otw-portfolio-light.php\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/otw-portfolio-light/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/otw-portfolio-light.1.4.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:70:\"https://s.w.org/plugins/geopattern-icon/otw-portfolio-light_959699.svg\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:73:\"https://ps.w.org/otw-portfolio-light/assets/banner-772x250.png?rev=744301\";}s:11:\"banners_rtl\";a:0:{}}s:43:\"the-events-calendar/the-events-calendar.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:33:\"w.org/plugins/the-events-calendar\";s:4:\"slug\";s:19:\"the-events-calendar\";s:6:\"plugin\";s:43:\"the-events-calendar/the-events-calendar.php\";s:11:\"new_version\";s:5:\"4.9.8\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/the-events-calendar/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.8.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/the-events-calendar/assets/icon-256x256.png?rev=2071468\";s:2:\"1x\";s:72:\"https://ps.w.org/the-events-calendar/assets/icon-128x128.png?rev=2071468\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:75:\"https://ps.w.org/the-events-calendar/assets/banner-1544x500.png?rev=2048291\";s:2:\"1x\";s:74:\"https://ps.w.org/the-events-calendar/assets/banner-772x250.png?rev=2048291\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.2.3\";s:12:\"requires_php\";s:3:\"5.6\";s:13:\"compatibility\";a:0:{}}s:43:\"widget-manager-light/otw_widget_manager.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:34:\"w.org/plugins/widget-manager-light\";s:4:\"slug\";s:20:\"widget-manager-light\";s:6:\"plugin\";s:43:\"widget-manager-light/otw_widget_manager.php\";s:11:\"new_version\";s:4:\"1.15\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/widget-manager-light/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/widget-manager-light.1.15.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:71:\"https://s.w.org/plugins/geopattern-icon/widget-manager-light_3babe9.svg\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:74:\"https://ps.w.org/widget-manager-light/assets/banner-772x250.png?rev=921131\";}s:11:\"banners_rtl\";a:0:{}}s:27:\"woocommerce/woocommerce.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:25:\"w.org/plugins/woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:6:\"plugin\";s:27:\"woocommerce/woocommerce.php\";s:11:\"new_version\";s:5:\"3.7.0\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/woocommerce/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/woocommerce/assets/icon-256x256.png?rev=2075035\";s:2:\"1x\";s:64:\"https://ps.w.org/woocommerce/assets/icon-128x128.png?rev=2075035\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/woocommerce/assets/banner-1544x500.png?rev=2075035\";s:2:\"1x\";s:66:\"https://ps.w.org/woocommerce/assets/banner-772x250.png?rev=2075035\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.2.3\";s:12:\"requires_php\";s:3:\"5.6\";s:13:\"compatibility\";a:0:{}}s:24:\"wordpress-seo/wp-seo.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:4:\"12.0\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.12.0.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-256x256.png?rev=1834347\";s:2:\"1x\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=1946641\";s:3:\"svg\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=1946641\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=1843435\";s:2:\"1x\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=1843435\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=1843435\";s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=1843435\";}s:6:\"tested\";s:5:\"5.2.3\";s:12:\"requires_php\";s:5:\"5.2.4\";s:13:\"compatibility\";a:0:{}}}}", "yes");
INSERT INTO `apprenz_options` VALUES("43972", "_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1548291751", "no");
INSERT INTO `apprenz_options` VALUES("43973", "_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1548291751", "no");
INSERT INTO `apprenz_options` VALUES("43974", "_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1548248551", "no");
INSERT INTO `apprenz_options` VALUES("43986", "_transient_is_multi_author", "0", "yes");
INSERT INTO `apprenz_options` VALUES("5633", "WPLANG", "", "yes");
INSERT INTO `apprenz_options` VALUES("5696", "themerex_options_category_19", "a:134:{s:10:\"theme_skin\";s:7:\"inherit\";s:14:\"show_top_panel\";s:7:\"inherit\";s:15:\"show_left_panel\";s:7:\"inherit\";s:16:\"show_right_panel\";s:7:\"inherit\";s:18:\"right_panel_button\";s:7:\"inherit\";s:15:\"right_panel_tab\";s:7:\"inherit\";s:11:\"theme_color\";s:7:\"inherit\";s:10:\"custom_css\";s:7:\"inherit\";s:11:\"custom_code\";s:7:\"inherit\";s:10:\"menu_style\";s:7:\"inherit\";s:13:\"menu_position\";s:7:\"inherit\";s:10:\"menu_align\";s:7:\"inherit\";s:10:\"menu_color\";s:7:\"inherit\";s:10:\"menu_width\";s:7:\"inherit\";s:9:\"logo_icon\";s:7:\"inherit\";s:9:\"logo_text\";s:7:\"inherit\";s:10:\"logo_image\";s:7:\"inherit\";s:11:\"logo_height\";s:7:\"inherit\";s:10:\"logo_align\";s:7:\"inherit\";s:17:\"logo_image_footer\";s:7:\"inherit\";s:24:\"logo_image_footer_height\";s:7:\"inherit\";s:14:\"show_user_menu\";s:7:\"inherit\";s:17:\"show_contact_info\";s:7:\"inherit\";s:13:\"show_currency\";s:7:\"inherit\";s:9:\"show_cart\";s:7:\"inherit\";s:14:\"show_languages\";s:7:\"inherit\";s:10:\"show_login\";s:7:\"inherit\";s:15:\"user_menu_color\";s:7:\"inherit\";s:16:\"show_user_header\";s:7:\"inherit\";s:19:\"user_header_content\";s:7:\"inherit\";s:16:\"show_user_footer\";s:7:\"inherit\";s:19:\"user_footer_content\";s:7:\"inherit\";s:22:\"show_twitter_in_footer\";s:7:\"inherit\";s:23:\"show_contacts_in_footer\";s:7:\"inherit\";s:29:\"show_copyright_area_in_footer\";s:7:\"inherit\";s:18:\"substitute_gallery\";s:7:\"inherit\";s:24:\"substitute_slider_engine\";s:7:\"inherit\";s:21:\"gallery_instead_image\";s:7:\"inherit\";s:18:\"gallery_max_slides\";s:7:\"inherit\";s:25:\"substitute_gallery_layout\";s:7:\"inherit\";s:16:\"substitute_audio\";s:7:\"inherit\";s:16:\"substitute_video\";s:7:\"inherit\";s:10:\"body_style\";s:7:\"inherit\";s:8:\"bg_color\";s:7:\"inherit\";s:10:\"bg_pattern\";s:7:\"inherit\";s:17:\"bg_custom_pattern\";s:7:\"inherit\";s:8:\"bg_image\";s:7:\"inherit\";s:15:\"bg_custom_image\";s:7:\"inherit\";s:24:\"bg_custom_image_position\";s:7:\"inherit\";s:13:\"show_video_bg\";s:7:\"inherit\";s:21:\"video_bg_youtube_code\";s:7:\"inherit\";s:12:\"video_bg_url\";s:7:\"inherit\";s:10:\"blog_style\";s:7:\"inherit\";s:11:\"hover_style\";s:7:\"inherit\";s:9:\"hover_dir\";s:7:\"inherit\";s:18:\"dedicated_location\";s:4:\"left\";s:12:\"show_filters\";s:7:\"inherit\";s:9:\"blog_sort\";s:7:\"inherit\";s:10:\"blog_order\";s:7:\"inherit\";s:14:\"posts_per_page\";s:7:\"inherit\";s:13:\"show_top_page\";s:7:\"inherit\";s:15:\"show_page_title\";s:7:\"inherit\";s:16:\"show_breadcrumbs\";s:7:\"inherit\";s:16:\"show_sidebar_top\";s:7:\"inherit\";s:11:\"sidebar_top\";s:7:\"inherit\";s:17:\"show_sidebar_main\";s:5:\"right\";s:12:\"sidebar_main\";s:16:\"custom-sidebar-1\";s:19:\"show_sidebar_footer\";s:3:\"yes\";s:20:\"sidebar_footer_style\";s:4:\"dark\";s:14:\"sidebar_footer\";s:16:\"custom-sidebar-2\";s:18:\"show_sidebar_panel\";s:7:\"inherit\";s:13:\"sidebar_panel\";s:7:\"inherit\";s:12:\"single_style\";s:7:\"inherit\";s:19:\"show_featured_image\";s:7:\"inherit\";s:15:\"show_post_title\";s:7:\"inherit\";s:25:\"show_post_title_on_quotes\";s:7:\"inherit\";s:14:\"show_post_info\";s:7:\"inherit\";s:16:\"show_post_author\";s:7:\"inherit\";s:14:\"show_post_tags\";s:7:\"inherit\";s:18:\"show_post_counters\";s:7:\"inherit\";s:17:\"show_post_related\";s:7:\"inherit\";s:18:\"post_related_count\";s:7:\"inherit\";s:18:\"show_post_comments\";s:7:\"inherit\";s:11:\"slider_show\";s:7:\"inherit\";s:14:\"slider_display\";s:7:\"inherit\";s:13:\"slider_engine\";s:7:\"inherit\";s:12:\"slider_alias\";s:7:\"inherit\";s:13:\"slider_height\";s:7:\"inherit\";s:15:\"slider_category\";s:7:\"inherit\";s:12:\"slider_posts\";s:7:\"inherit\";s:14:\"slider_orderby\";s:7:\"inherit\";s:12:\"slider_order\";s:7:\"inherit\";s:15:\"slider_info_box\";s:7:\"inherit\";s:17:\"slider_info_fixed\";s:7:\"inherit\";s:20:\"slider_info_category\";s:7:\"inherit\";s:14:\"slider_reviews\";s:7:\"inherit\";s:19:\"slider_descriptions\";s:7:\"inherit\";s:14:\"googlemap_show\";s:7:\"inherit\";s:16:\"googlemap_height\";s:7:\"inherit\";s:17:\"googlemap_address\";s:7:\"inherit\";s:16:\"googlemap_latlng\";s:7:\"inherit\";s:14:\"googlemap_zoom\";s:7:\"inherit\";s:15:\"googlemap_style\";s:7:\"inherit\";s:12:\"show_reviews\";s:7:\"inherit\";s:17:\"reviews_criterias\";s:7:\"inherit\";s:11:\"logo_slogan\";s:7:\"inherit\";s:11:\"logo_offset\";s:7:\"inherit\";s:15:\"filter_taxonomy\";s:7:\"inherit\";s:13:\"load_bg_image\";s:7:\"inherit\";s:16:\"video_bg_overlay\";s:7:\"inherit\";s:8:\"logo_top\";s:7:\"inherit\";s:10:\"logo_fixed\";s:7:\"inherit\";s:9:\"logo_side\";s:7:\"inherit\";s:9:\"menu_main\";s:7:\"inherit\";s:9:\"menu_user\";s:7:\"inherit\";s:9:\"menu_side\";s:7:\"inherit\";s:10:\"menu_panel\";s:7:\"inherit\";s:8:\"menu_toc\";s:7:\"inherit\";s:13:\"menu_toc_home\";s:7:\"inherit\";s:15:\"slider_interval\";s:7:\"inherit\";s:15:\"blog_pagination\";s:7:\"inherit\";s:21:\"blog_pagination_style\";s:7:\"inherit\";s:13:\"blog_counters\";s:7:\"inherit\";s:14:\"close_category\";s:7:\"inherit\";s:15:\"show_date_after\";s:7:\"inherit\";s:12:\"theme_color2\";s:7:\"inherit\";s:12:\"theme_color3\";s:7:\"inherit\";s:21:\"show_theme_customizer\";s:7:\"inherit\";s:17:\"top_panel_opacity\";s:7:\"inherit\";s:16:\"menu_description\";s:7:\"inherit\";s:12:\"menu_toc_top\";s:7:\"inherit\";s:17:\"slider_pagination\";s:7:\"inherit\";s:22:\"post_excerpt_maxlength\";s:7:\"inherit\";s:30:\"post_excerpt_maxlength_masonry\";s:7:\"inherit\";}", "yes");
INSERT INTO `apprenz_options` VALUES("5697", "themerex_options_category_20", "a:128:{s:10:\"theme_skin\";s:7:\"inherit\";s:14:\"show_top_panel\";s:7:\"inherit\";s:15:\"show_left_panel\";s:7:\"inherit\";s:16:\"show_right_panel\";s:7:\"inherit\";s:18:\"right_panel_button\";s:7:\"inherit\";s:15:\"right_panel_tab\";s:7:\"inherit\";s:11:\"theme_color\";s:7:\"inherit\";s:10:\"custom_css\";s:7:\"inherit\";s:11:\"custom_code\";s:7:\"inherit\";s:10:\"menu_style\";s:7:\"inherit\";s:13:\"menu_position\";s:7:\"inherit\";s:10:\"menu_align\";s:7:\"inherit\";s:10:\"menu_color\";s:7:\"inherit\";s:10:\"menu_width\";s:7:\"inherit\";s:9:\"logo_icon\";s:7:\"inherit\";s:9:\"logo_text\";s:7:\"inherit\";s:10:\"logo_image\";s:7:\"inherit\";s:11:\"logo_height\";s:7:\"inherit\";s:10:\"logo_align\";s:7:\"inherit\";s:17:\"logo_image_footer\";s:7:\"inherit\";s:24:\"logo_image_footer_height\";s:7:\"inherit\";s:14:\"show_user_menu\";s:7:\"inherit\";s:17:\"show_contact_info\";s:7:\"inherit\";s:13:\"show_currency\";s:7:\"inherit\";s:9:\"show_cart\";s:7:\"inherit\";s:14:\"show_languages\";s:7:\"inherit\";s:10:\"show_login\";s:7:\"inherit\";s:15:\"user_menu_color\";s:7:\"inherit\";s:16:\"show_user_header\";s:7:\"inherit\";s:19:\"user_header_content\";s:7:\"inherit\";s:16:\"show_user_footer\";s:7:\"inherit\";s:19:\"user_footer_content\";s:7:\"inherit\";s:22:\"show_twitter_in_footer\";s:7:\"inherit\";s:23:\"show_contacts_in_footer\";s:7:\"inherit\";s:29:\"show_copyright_area_in_footer\";s:7:\"inherit\";s:18:\"substitute_gallery\";s:7:\"inherit\";s:24:\"substitute_slider_engine\";s:7:\"inherit\";s:21:\"gallery_instead_image\";s:7:\"inherit\";s:18:\"gallery_max_slides\";s:7:\"inherit\";s:25:\"substitute_gallery_layout\";s:7:\"inherit\";s:16:\"substitute_audio\";s:7:\"inherit\";s:16:\"substitute_video\";s:7:\"inherit\";s:10:\"body_style\";s:7:\"inherit\";s:8:\"bg_color\";s:7:\"inherit\";s:10:\"bg_pattern\";s:7:\"inherit\";s:17:\"bg_custom_pattern\";s:7:\"inherit\";s:8:\"bg_image\";s:7:\"inherit\";s:15:\"bg_custom_image\";s:7:\"inherit\";s:24:\"bg_custom_image_position\";s:7:\"inherit\";s:13:\"show_video_bg\";s:7:\"inherit\";s:21:\"video_bg_youtube_code\";s:7:\"inherit\";s:12:\"video_bg_url\";s:7:\"inherit\";s:10:\"blog_style\";s:10:\"portfolio4\";s:11:\"hover_style\";s:3:\"dir\";s:9:\"hover_dir\";s:7:\"inherit\";s:18:\"dedicated_location\";s:5:\"alter\";s:12:\"show_filters\";s:3:\"yes\";s:9:\"blog_sort\";s:7:\"inherit\";s:10:\"blog_order\";s:7:\"inherit\";s:14:\"posts_per_page\";s:2:\"12\";s:13:\"show_top_page\";s:7:\"inherit\";s:15:\"show_page_title\";s:7:\"inherit\";s:16:\"show_breadcrumbs\";s:7:\"inherit\";s:16:\"show_sidebar_top\";s:7:\"inherit\";s:11:\"sidebar_top\";s:7:\"inherit\";s:17:\"show_sidebar_main\";s:9:\"fullwidth\";s:12:\"sidebar_main\";s:7:\"inherit\";s:19:\"show_sidebar_footer\";s:7:\"inherit\";s:20:\"sidebar_footer_style\";s:7:\"inherit\";s:14:\"sidebar_footer\";s:7:\"inherit\";s:18:\"show_sidebar_panel\";s:7:\"inherit\";s:13:\"sidebar_panel\";s:7:\"inherit\";s:12:\"single_style\";s:27:\"single-portfolio-fullscreen\";s:19:\"show_featured_image\";s:7:\"inherit\";s:15:\"show_post_title\";s:7:\"inherit\";s:25:\"show_post_title_on_quotes\";s:7:\"inherit\";s:14:\"show_post_info\";s:7:\"inherit\";s:16:\"show_post_author\";s:7:\"inherit\";s:14:\"show_post_tags\";s:7:\"inherit\";s:18:\"show_post_counters\";s:7:\"inherit\";s:17:\"show_post_related\";s:7:\"inherit\";s:18:\"post_related_count\";s:7:\"inherit\";s:18:\"show_post_comments\";s:7:\"inherit\";s:11:\"slider_show\";s:7:\"inherit\";s:14:\"slider_display\";s:7:\"inherit\";s:13:\"slider_engine\";s:7:\"inherit\";s:12:\"slider_alias\";s:7:\"inherit\";s:13:\"slider_height\";s:7:\"inherit\";s:15:\"slider_category\";s:7:\"inherit\";s:12:\"slider_posts\";s:7:\"inherit\";s:14:\"slider_orderby\";s:7:\"inherit\";s:12:\"slider_order\";s:7:\"inherit\";s:15:\"slider_info_box\";s:7:\"inherit\";s:17:\"slider_info_fixed\";s:7:\"inherit\";s:20:\"slider_info_category\";s:7:\"inherit\";s:14:\"slider_reviews\";s:7:\"inherit\";s:19:\"slider_descriptions\";s:7:\"inherit\";s:14:\"googlemap_show\";s:7:\"inherit\";s:16:\"googlemap_height\";s:7:\"inherit\";s:17:\"googlemap_address\";s:7:\"inherit\";s:16:\"googlemap_latlng\";s:7:\"inherit\";s:14:\"googlemap_zoom\";s:7:\"inherit\";s:15:\"googlemap_style\";s:7:\"inherit\";s:12:\"show_reviews\";s:7:\"inherit\";s:17:\"reviews_criterias\";s:7:\"inherit\";s:11:\"logo_slogan\";s:7:\"inherit\";s:11:\"logo_offset\";s:7:\"inherit\";s:15:\"filter_taxonomy\";s:4:\"tags\";s:16:\"video_bg_overlay\";s:7:\"inherit\";s:8:\"logo_top\";s:7:\"inherit\";s:10:\"logo_fixed\";s:7:\"inherit\";s:9:\"logo_side\";s:7:\"inherit\";s:15:\"slider_interval\";s:7:\"inherit\";s:15:\"blog_pagination\";s:7:\"inherit\";s:21:\"blog_pagination_style\";s:7:\"inherit\";s:13:\"blog_counters\";s:7:\"inherit\";s:14:\"close_category\";s:7:\"inherit\";s:15:\"show_date_after\";s:7:\"inherit\";s:21:\"show_theme_customizer\";s:7:\"inherit\";s:13:\"load_bg_image\";s:7:\"inherit\";s:9:\"menu_main\";s:7:\"inherit\";s:9:\"menu_user\";s:7:\"inherit\";s:9:\"menu_side\";s:7:\"inherit\";s:10:\"menu_panel\";s:7:\"inherit\";s:8:\"menu_toc\";s:7:\"inherit\";s:13:\"menu_toc_home\";s:7:\"inherit\";s:12:\"menu_toc_top\";s:7:\"inherit\";s:17:\"slider_pagination\";s:7:\"inherit\";}", "yes");
INSERT INTO `apprenz_options` VALUES("5698", "themerex_options_category_207", "a:132:{s:10:\"theme_skin\";s:7:\"inherit\";s:11:\"theme_color\";s:7:\"inherit\";s:12:\"theme_color2\";s:7:\"inherit\";s:12:\"theme_color3\";s:7:\"inherit\";s:21:\"show_theme_customizer\";s:7:\"inherit\";s:10:\"custom_css\";s:7:\"inherit\";s:11:\"custom_code\";s:7:\"inherit\";s:10:\"body_style\";s:7:\"inherit\";s:13:\"load_bg_image\";s:7:\"inherit\";s:8:\"bg_color\";s:7:\"inherit\";s:10:\"bg_pattern\";s:7:\"inherit\";s:17:\"bg_custom_pattern\";s:7:\"inherit\";s:8:\"bg_image\";s:7:\"inherit\";s:15:\"bg_custom_image\";s:7:\"inherit\";s:24:\"bg_custom_image_position\";s:7:\"inherit\";s:13:\"show_video_bg\";s:7:\"inherit\";s:21:\"video_bg_youtube_code\";s:7:\"inherit\";s:12:\"video_bg_url\";s:7:\"inherit\";s:16:\"video_bg_overlay\";s:7:\"inherit\";s:10:\"logo_image\";s:7:\"inherit\";s:8:\"logo_top\";s:7:\"inherit\";s:10:\"logo_fixed\";s:7:\"inherit\";s:9:\"logo_side\";s:7:\"inherit\";s:9:\"logo_text\";s:7:\"inherit\";s:11:\"logo_slogan\";s:7:\"inherit\";s:11:\"logo_height\";s:7:\"inherit\";s:11:\"logo_offset\";s:7:\"inherit\";s:10:\"logo_align\";s:7:\"inherit\";s:17:\"logo_image_footer\";s:7:\"inherit\";s:24:\"logo_image_footer_height\";s:7:\"inherit\";s:14:\"show_top_panel\";s:7:\"inherit\";s:17:\"top_panel_opacity\";s:7:\"inherit\";s:9:\"menu_main\";s:7:\"inherit\";s:10:\"menu_style\";s:7:\"inherit\";s:13:\"menu_position\";s:7:\"inherit\";s:10:\"menu_align\";s:7:\"inherit\";s:10:\"menu_width\";s:7:\"inherit\";s:16:\"menu_description\";s:7:\"inherit\";s:14:\"show_user_menu\";s:7:\"inherit\";s:9:\"menu_user\";s:7:\"inherit\";s:17:\"show_contact_info\";s:7:\"inherit\";s:13:\"show_currency\";s:7:\"inherit\";s:9:\"show_cart\";s:7:\"inherit\";s:14:\"show_languages\";s:7:\"inherit\";s:10:\"show_login\";s:7:\"inherit\";s:15:\"show_left_panel\";s:7:\"inherit\";s:9:\"menu_side\";s:7:\"inherit\";s:9:\"logo_icon\";s:7:\"inherit\";s:16:\"show_right_panel\";s:7:\"inherit\";s:10:\"menu_panel\";s:7:\"inherit\";s:18:\"right_panel_button\";s:7:\"inherit\";s:15:\"right_panel_tab\";s:7:\"inherit\";s:8:\"menu_toc\";s:7:\"inherit\";s:13:\"menu_toc_home\";s:7:\"inherit\";s:12:\"menu_toc_top\";s:7:\"inherit\";s:16:\"show_sidebar_top\";s:7:\"inherit\";s:11:\"sidebar_top\";s:7:\"inherit\";s:17:\"show_sidebar_main\";s:7:\"inherit\";s:12:\"sidebar_main\";s:7:\"inherit\";s:19:\"show_sidebar_footer\";s:7:\"inherit\";s:20:\"sidebar_footer_style\";s:7:\"inherit\";s:14:\"sidebar_footer\";s:7:\"inherit\";s:18:\"show_sidebar_panel\";s:7:\"inherit\";s:13:\"sidebar_panel\";s:7:\"inherit\";s:11:\"slider_show\";s:7:\"inherit\";s:14:\"slider_display\";s:7:\"inherit\";s:13:\"slider_height\";s:7:\"inherit\";s:13:\"slider_engine\";s:7:\"inherit\";s:12:\"slider_alias\";s:7:\"inherit\";s:15:\"slider_category\";s:7:\"inherit\";s:12:\"slider_posts\";s:7:\"inherit\";s:14:\"slider_orderby\";s:7:\"inherit\";s:12:\"slider_order\";s:7:\"inherit\";s:15:\"slider_interval\";s:7:\"inherit\";s:17:\"slider_pagination\";s:7:\"inherit\";s:15:\"slider_info_box\";s:7:\"inherit\";s:17:\"slider_info_fixed\";s:7:\"inherit\";s:20:\"slider_info_category\";s:7:\"inherit\";s:14:\"slider_reviews\";s:7:\"inherit\";s:19:\"slider_descriptions\";s:7:\"inherit\";s:16:\"show_user_header\";s:7:\"inherit\";s:19:\"user_header_content\";s:7:\"inherit\";s:13:\"show_top_page\";s:7:\"inherit\";s:15:\"show_page_title\";s:7:\"inherit\";s:16:\"show_breadcrumbs\";s:7:\"inherit\";s:16:\"show_user_footer\";s:7:\"inherit\";s:19:\"user_footer_content\";s:7:\"inherit\";s:23:\"show_contacts_in_footer\";s:7:\"inherit\";s:22:\"show_twitter_in_footer\";s:7:\"inherit\";s:29:\"show_copyright_area_in_footer\";s:7:\"inherit\";s:14:\"googlemap_show\";s:7:\"inherit\";s:16:\"googlemap_height\";s:7:\"inherit\";s:17:\"googlemap_address\";s:7:\"inherit\";s:16:\"googlemap_latlng\";s:7:\"inherit\";s:14:\"googlemap_zoom\";s:7:\"inherit\";s:15:\"googlemap_style\";s:7:\"inherit\";s:18:\"substitute_gallery\";s:7:\"inherit\";s:24:\"substitute_slider_engine\";s:7:\"inherit\";s:21:\"gallery_instead_image\";s:7:\"inherit\";s:18:\"gallery_max_slides\";s:7:\"inherit\";s:25:\"substitute_gallery_layout\";s:7:\"inherit\";s:16:\"substitute_audio\";s:7:\"inherit\";s:16:\"substitute_video\";s:7:\"inherit\";s:10:\"blog_style\";s:7:\"inherit\";s:11:\"hover_style\";s:7:\"inherit\";s:9:\"hover_dir\";s:7:\"inherit\";s:18:\"dedicated_location\";s:7:\"inherit\";s:12:\"show_filters\";s:7:\"inherit\";s:15:\"filter_taxonomy\";s:7:\"inherit\";s:9:\"blog_sort\";s:7:\"inherit\";s:10:\"blog_order\";s:7:\"inherit\";s:14:\"posts_per_page\";s:7:\"inherit\";s:22:\"post_excerpt_maxlength\";s:7:\"inherit\";s:30:\"post_excerpt_maxlength_masonry\";s:7:\"inherit\";s:12:\"single_style\";s:7:\"inherit\";s:19:\"show_featured_image\";s:7:\"inherit\";s:15:\"show_post_title\";s:7:\"inherit\";s:25:\"show_post_title_on_quotes\";s:7:\"inherit\";s:14:\"show_post_info\";s:7:\"inherit\";s:16:\"show_post_author\";s:7:\"inherit\";s:14:\"show_post_tags\";s:7:\"inherit\";s:18:\"show_post_counters\";s:7:\"inherit\";s:17:\"show_post_related\";s:7:\"inherit\";s:18:\"post_related_count\";s:7:\"inherit\";s:18:\"show_post_comments\";s:7:\"inherit\";s:15:\"blog_pagination\";s:7:\"inherit\";s:21:\"blog_pagination_style\";s:7:\"inherit\";s:13:\"blog_counters\";s:7:\"inherit\";s:14:\"close_category\";s:7:\"inherit\";s:15:\"show_date_after\";s:7:\"inherit\";s:12:\"show_reviews\";s:7:\"inherit\";s:17:\"reviews_criterias\";s:7:\"inherit\";}", "yes");
INSERT INTO `apprenz_options` VALUES("5699", "themerex_options_category_208", "a:132:{s:10:\"theme_skin\";s:7:\"inherit\";s:11:\"theme_color\";s:7:\"inherit\";s:12:\"theme_color2\";s:7:\"inherit\";s:12:\"theme_color3\";s:7:\"inherit\";s:21:\"show_theme_customizer\";s:7:\"inherit\";s:10:\"custom_css\";s:7:\"inherit\";s:11:\"custom_code\";s:7:\"inherit\";s:10:\"body_style\";s:7:\"inherit\";s:13:\"load_bg_image\";s:7:\"inherit\";s:8:\"bg_color\";s:7:\"inherit\";s:10:\"bg_pattern\";s:7:\"inherit\";s:17:\"bg_custom_pattern\";s:7:\"inherit\";s:8:\"bg_image\";s:7:\"inherit\";s:15:\"bg_custom_image\";s:7:\"inherit\";s:24:\"bg_custom_image_position\";s:7:\"inherit\";s:13:\"show_video_bg\";s:7:\"inherit\";s:21:\"video_bg_youtube_code\";s:7:\"inherit\";s:12:\"video_bg_url\";s:7:\"inherit\";s:16:\"video_bg_overlay\";s:7:\"inherit\";s:10:\"logo_image\";s:7:\"inherit\";s:8:\"logo_top\";s:7:\"inherit\";s:10:\"logo_fixed\";s:7:\"inherit\";s:9:\"logo_side\";s:7:\"inherit\";s:9:\"logo_text\";s:7:\"inherit\";s:11:\"logo_slogan\";s:7:\"inherit\";s:11:\"logo_height\";s:7:\"inherit\";s:11:\"logo_offset\";s:7:\"inherit\";s:10:\"logo_align\";s:7:\"inherit\";s:17:\"logo_image_footer\";s:7:\"inherit\";s:24:\"logo_image_footer_height\";s:7:\"inherit\";s:14:\"show_top_panel\";s:7:\"inherit\";s:17:\"top_panel_opacity\";s:7:\"inherit\";s:9:\"menu_main\";s:7:\"inherit\";s:10:\"menu_style\";s:7:\"inherit\";s:13:\"menu_position\";s:7:\"inherit\";s:10:\"menu_align\";s:7:\"inherit\";s:10:\"menu_width\";s:7:\"inherit\";s:16:\"menu_description\";s:7:\"inherit\";s:14:\"show_user_menu\";s:7:\"inherit\";s:9:\"menu_user\";s:7:\"inherit\";s:17:\"show_contact_info\";s:7:\"inherit\";s:13:\"show_currency\";s:7:\"inherit\";s:9:\"show_cart\";s:7:\"inherit\";s:14:\"show_languages\";s:7:\"inherit\";s:10:\"show_login\";s:7:\"inherit\";s:15:\"show_left_panel\";s:7:\"inherit\";s:9:\"menu_side\";s:7:\"inherit\";s:9:\"logo_icon\";s:7:\"inherit\";s:16:\"show_right_panel\";s:7:\"inherit\";s:10:\"menu_panel\";s:7:\"inherit\";s:18:\"right_panel_button\";s:7:\"inherit\";s:15:\"right_panel_tab\";s:7:\"inherit\";s:8:\"menu_toc\";s:7:\"inherit\";s:13:\"menu_toc_home\";s:7:\"inherit\";s:12:\"menu_toc_top\";s:7:\"inherit\";s:16:\"show_sidebar_top\";s:7:\"inherit\";s:11:\"sidebar_top\";s:7:\"inherit\";s:17:\"show_sidebar_main\";s:9:\"fullwidth\";s:12:\"sidebar_main\";s:7:\"inherit\";s:19:\"show_sidebar_footer\";s:7:\"inherit\";s:20:\"sidebar_footer_style\";s:7:\"inherit\";s:14:\"sidebar_footer\";s:7:\"inherit\";s:18:\"show_sidebar_panel\";s:7:\"inherit\";s:13:\"sidebar_panel\";s:7:\"inherit\";s:11:\"slider_show\";s:7:\"inherit\";s:14:\"slider_display\";s:7:\"inherit\";s:13:\"slider_height\";s:7:\"inherit\";s:13:\"slider_engine\";s:7:\"inherit\";s:12:\"slider_alias\";s:7:\"inherit\";s:15:\"slider_category\";s:7:\"inherit\";s:12:\"slider_posts\";s:7:\"inherit\";s:14:\"slider_orderby\";s:7:\"inherit\";s:12:\"slider_order\";s:7:\"inherit\";s:15:\"slider_interval\";s:7:\"inherit\";s:17:\"slider_pagination\";s:7:\"inherit\";s:15:\"slider_info_box\";s:7:\"inherit\";s:17:\"slider_info_fixed\";s:7:\"inherit\";s:20:\"slider_info_category\";s:7:\"inherit\";s:14:\"slider_reviews\";s:7:\"inherit\";s:19:\"slider_descriptions\";s:7:\"inherit\";s:16:\"show_user_header\";s:7:\"inherit\";s:19:\"user_header_content\";s:7:\"inherit\";s:13:\"show_top_page\";s:7:\"inherit\";s:15:\"show_page_title\";s:7:\"inherit\";s:16:\"show_breadcrumbs\";s:7:\"inherit\";s:16:\"show_user_footer\";s:7:\"inherit\";s:19:\"user_footer_content\";s:7:\"inherit\";s:23:\"show_contacts_in_footer\";s:7:\"inherit\";s:22:\"show_twitter_in_footer\";s:7:\"inherit\";s:29:\"show_copyright_area_in_footer\";s:7:\"inherit\";s:14:\"googlemap_show\";s:7:\"inherit\";s:16:\"googlemap_height\";s:7:\"inherit\";s:17:\"googlemap_address\";s:7:\"inherit\";s:16:\"googlemap_latlng\";s:7:\"inherit\";s:14:\"googlemap_zoom\";s:7:\"inherit\";s:15:\"googlemap_style\";s:7:\"inherit\";s:18:\"substitute_gallery\";s:7:\"inherit\";s:24:\"substitute_slider_engine\";s:7:\"inherit\";s:21:\"gallery_instead_image\";s:7:\"inherit\";s:18:\"gallery_max_slides\";s:7:\"inherit\";s:25:\"substitute_gallery_layout\";s:7:\"inherit\";s:16:\"substitute_audio\";s:7:\"inherit\";s:16:\"substitute_video\";s:7:\"inherit\";s:10:\"blog_style\";s:7:\"inherit\";s:11:\"hover_style\";s:7:\"inherit\";s:9:\"hover_dir\";s:7:\"inherit\";s:18:\"dedicated_location\";s:7:\"inherit\";s:12:\"show_filters\";s:7:\"inherit\";s:15:\"filter_taxonomy\";s:7:\"inherit\";s:9:\"blog_sort\";s:7:\"inherit\";s:10:\"blog_order\";s:7:\"inherit\";s:14:\"posts_per_page\";s:7:\"inherit\";s:22:\"post_excerpt_maxlength\";s:7:\"inherit\";s:30:\"post_excerpt_maxlength_masonry\";s:7:\"inherit\";s:12:\"single_style\";s:7:\"inherit\";s:19:\"show_featured_image\";s:7:\"inherit\";s:15:\"show_post_title\";s:7:\"inherit\";s:25:\"show_post_title_on_quotes\";s:7:\"inherit\";s:14:\"show_post_info\";s:7:\"inherit\";s:16:\"show_post_author\";s:7:\"inherit\";s:14:\"show_post_tags\";s:7:\"inherit\";s:18:\"show_post_counters\";s:7:\"inherit\";s:17:\"show_post_related\";s:7:\"inherit\";s:18:\"post_related_count\";s:7:\"inherit\";s:18:\"show_post_comments\";s:7:\"inherit\";s:15:\"blog_pagination\";s:7:\"inherit\";s:21:\"blog_pagination_style\";s:7:\"inherit\";s:13:\"blog_counters\";s:7:\"inherit\";s:14:\"close_category\";s:7:\"inherit\";s:15:\"show_date_after\";s:7:\"inherit\";s:12:\"show_reviews\";s:7:\"inherit\";s:17:\"reviews_criterias\";s:7:\"inherit\";}", "yes");
INSERT INTO `apprenz_options` VALUES("5700", "themerex_options_category_209", "a:132:{s:10:\"theme_skin\";s:7:\"inherit\";s:11:\"theme_color\";s:7:\"inherit\";s:12:\"theme_color2\";s:7:\"inherit\";s:12:\"theme_color3\";s:7:\"inherit\";s:21:\"show_theme_customizer\";s:7:\"inherit\";s:10:\"custom_css\";s:7:\"inherit\";s:11:\"custom_code\";s:7:\"inherit\";s:10:\"body_style\";s:7:\"inherit\";s:13:\"load_bg_image\";s:7:\"inherit\";s:8:\"bg_color\";s:7:\"inherit\";s:10:\"bg_pattern\";s:7:\"inherit\";s:17:\"bg_custom_pattern\";s:7:\"inherit\";s:8:\"bg_image\";s:7:\"inherit\";s:15:\"bg_custom_image\";s:7:\"inherit\";s:24:\"bg_custom_image_position\";s:7:\"inherit\";s:13:\"show_video_bg\";s:7:\"inherit\";s:21:\"video_bg_youtube_code\";s:7:\"inherit\";s:12:\"video_bg_url\";s:7:\"inherit\";s:16:\"video_bg_overlay\";s:7:\"inherit\";s:10:\"logo_image\";s:7:\"inherit\";s:8:\"logo_top\";s:7:\"inherit\";s:10:\"logo_fixed\";s:7:\"inherit\";s:9:\"logo_side\";s:7:\"inherit\";s:9:\"logo_text\";s:7:\"inherit\";s:11:\"logo_slogan\";s:7:\"inherit\";s:11:\"logo_height\";s:7:\"inherit\";s:11:\"logo_offset\";s:7:\"inherit\";s:10:\"logo_align\";s:7:\"inherit\";s:17:\"logo_image_footer\";s:7:\"inherit\";s:24:\"logo_image_footer_height\";s:7:\"inherit\";s:14:\"show_top_panel\";s:7:\"inherit\";s:17:\"top_panel_opacity\";s:7:\"inherit\";s:9:\"menu_main\";s:7:\"inherit\";s:10:\"menu_style\";s:7:\"inherit\";s:13:\"menu_position\";s:7:\"inherit\";s:10:\"menu_align\";s:7:\"inherit\";s:10:\"menu_width\";s:7:\"inherit\";s:16:\"menu_description\";s:7:\"inherit\";s:14:\"show_user_menu\";s:7:\"inherit\";s:9:\"menu_user\";s:7:\"inherit\";s:17:\"show_contact_info\";s:7:\"inherit\";s:13:\"show_currency\";s:7:\"inherit\";s:9:\"show_cart\";s:7:\"inherit\";s:14:\"show_languages\";s:7:\"inherit\";s:10:\"show_login\";s:7:\"inherit\";s:15:\"show_left_panel\";s:7:\"inherit\";s:9:\"menu_side\";s:7:\"inherit\";s:9:\"logo_icon\";s:7:\"inherit\";s:16:\"show_right_panel\";s:7:\"inherit\";s:10:\"menu_panel\";s:7:\"inherit\";s:18:\"right_panel_button\";s:7:\"inherit\";s:15:\"right_panel_tab\";s:7:\"inherit\";s:8:\"menu_toc\";s:7:\"inherit\";s:13:\"menu_toc_home\";s:7:\"inherit\";s:12:\"menu_toc_top\";s:7:\"inherit\";s:16:\"show_sidebar_top\";s:7:\"inherit\";s:11:\"sidebar_top\";s:7:\"inherit\";s:17:\"show_sidebar_main\";s:7:\"inherit\";s:12:\"sidebar_main\";s:7:\"inherit\";s:19:\"show_sidebar_footer\";s:7:\"inherit\";s:20:\"sidebar_footer_style\";s:7:\"inherit\";s:14:\"sidebar_footer\";s:7:\"inherit\";s:18:\"show_sidebar_panel\";s:7:\"inherit\";s:13:\"sidebar_panel\";s:7:\"inherit\";s:11:\"slider_show\";s:7:\"inherit\";s:14:\"slider_display\";s:7:\"inherit\";s:13:\"slider_height\";s:7:\"inherit\";s:13:\"slider_engine\";s:7:\"inherit\";s:12:\"slider_alias\";s:7:\"inherit\";s:15:\"slider_category\";s:7:\"inherit\";s:12:\"slider_posts\";s:7:\"inherit\";s:14:\"slider_orderby\";s:7:\"inherit\";s:12:\"slider_order\";s:7:\"inherit\";s:15:\"slider_interval\";s:7:\"inherit\";s:17:\"slider_pagination\";s:7:\"inherit\";s:15:\"slider_info_box\";s:7:\"inherit\";s:17:\"slider_info_fixed\";s:7:\"inherit\";s:20:\"slider_info_category\";s:7:\"inherit\";s:14:\"slider_reviews\";s:7:\"inherit\";s:19:\"slider_descriptions\";s:7:\"inherit\";s:16:\"show_user_header\";s:7:\"inherit\";s:19:\"user_header_content\";s:7:\"inherit\";s:13:\"show_top_page\";s:7:\"inherit\";s:15:\"show_page_title\";s:7:\"inherit\";s:16:\"show_breadcrumbs\";s:7:\"inherit\";s:16:\"show_user_footer\";s:7:\"inherit\";s:19:\"user_footer_content\";s:7:\"inherit\";s:23:\"show_contacts_in_footer\";s:7:\"inherit\";s:22:\"show_twitter_in_footer\";s:7:\"inherit\";s:29:\"show_copyright_area_in_footer\";s:7:\"inherit\";s:14:\"googlemap_show\";s:7:\"inherit\";s:16:\"googlemap_height\";s:7:\"inherit\";s:17:\"googlemap_address\";s:7:\"inherit\";s:16:\"googlemap_latlng\";s:7:\"inherit\";s:14:\"googlemap_zoom\";s:7:\"inherit\";s:15:\"googlemap_style\";s:7:\"inherit\";s:18:\"substitute_gallery\";s:7:\"inherit\";s:24:\"substitute_slider_engine\";s:7:\"inherit\";s:21:\"gallery_instead_image\";s:7:\"inherit\";s:18:\"gallery_max_slides\";s:7:\"inherit\";s:25:\"substitute_gallery_layout\";s:7:\"inherit\";s:16:\"substitute_audio\";s:7:\"inherit\";s:16:\"substitute_video\";s:7:\"inherit\";s:10:\"blog_style\";s:7:\"inherit\";s:11:\"hover_style\";s:7:\"inherit\";s:9:\"hover_dir\";s:7:\"inherit\";s:18:\"dedicated_location\";s:7:\"inherit\";s:12:\"show_filters\";s:7:\"inherit\";s:15:\"filter_taxonomy\";s:7:\"inherit\";s:9:\"blog_sort\";s:7:\"inherit\";s:10:\"blog_order\";s:7:\"inherit\";s:14:\"posts_per_page\";s:7:\"inherit\";s:22:\"post_excerpt_maxlength\";s:7:\"inherit\";s:30:\"post_excerpt_maxlength_masonry\";s:7:\"inherit\";s:12:\"single_style\";s:7:\"inherit\";s:19:\"show_featured_image\";s:7:\"inherit\";s:15:\"show_post_title\";s:7:\"inherit\";s:25:\"show_post_title_on_quotes\";s:7:\"inherit\";s:14:\"show_post_info\";s:7:\"inherit\";s:16:\"show_post_author\";s:7:\"inherit\";s:14:\"show_post_tags\";s:7:\"inherit\";s:18:\"show_post_counters\";s:7:\"inherit\";s:17:\"show_post_related\";s:7:\"inherit\";s:18:\"post_related_count\";s:7:\"inherit\";s:18:\"show_post_comments\";s:7:\"inherit\";s:15:\"blog_pagination\";s:7:\"inherit\";s:21:\"blog_pagination_style\";s:7:\"inherit\";s:13:\"blog_counters\";s:7:\"inherit\";s:14:\"close_category\";s:7:\"inherit\";s:15:\"show_date_after\";s:7:\"inherit\";s:12:\"show_reviews\";s:7:\"inherit\";s:17:\"reviews_criterias\";s:7:\"inherit\";}", "yes");
INSERT INTO `apprenz_options` VALUES("5701", "themerex_options_category_21", "a:106:{s:10:\"theme_skin\";s:7:\"general\";s:14:\"show_top_panel\";s:7:\"inherit\";s:15:\"show_left_panel\";s:7:\"inherit\";s:16:\"show_right_panel\";s:7:\"inherit\";s:18:\"right_panel_button\";s:7:\"inherit\";s:15:\"right_panel_tab\";s:7:\"inherit\";s:11:\"theme_color\";s:7:\"inherit\";s:10:\"custom_css\";s:7:\"inherit\";s:11:\"custom_code\";s:7:\"inherit\";s:10:\"menu_style\";s:7:\"inherit\";s:13:\"menu_position\";s:7:\"inherit\";s:10:\"menu_align\";s:7:\"inherit\";s:10:\"menu_color\";s:7:\"inherit\";s:10:\"menu_width\";s:7:\"inherit\";s:9:\"logo_icon\";s:7:\"inherit\";s:9:\"logo_text\";s:7:\"inherit\";s:10:\"logo_image\";s:7:\"inherit\";s:11:\"logo_height\";s:7:\"inherit\";s:11:\"logo_offset\";s:7:\"inherit\";s:10:\"logo_align\";s:7:\"inherit\";s:17:\"logo_image_footer\";s:7:\"inherit\";s:24:\"logo_image_footer_height\";s:7:\"inherit\";s:14:\"show_user_menu\";s:7:\"inherit\";s:17:\"show_contact_info\";s:7:\"inherit\";s:13:\"show_currency\";s:7:\"inherit\";s:9:\"show_cart\";s:7:\"inherit\";s:14:\"show_languages\";s:7:\"inherit\";s:10:\"show_login\";s:7:\"inherit\";s:15:\"user_menu_color\";s:7:\"inherit\";s:16:\"show_user_header\";s:7:\"inherit\";s:19:\"user_header_content\";s:7:\"inherit\";s:16:\"show_user_footer\";s:7:\"inherit\";s:19:\"user_footer_content\";s:7:\"inherit\";s:22:\"show_twitter_in_footer\";s:7:\"inherit\";s:23:\"show_contacts_in_footer\";s:7:\"inherit\";s:29:\"show_copyright_area_in_footer\";s:7:\"inherit\";s:18:\"substitute_gallery\";s:7:\"inherit\";s:24:\"substitute_slider_engine\";s:7:\"inherit\";s:21:\"gallery_instead_image\";s:7:\"inherit\";s:18:\"gallery_max_slides\";s:7:\"inherit\";s:25:\"substitute_gallery_layout\";s:7:\"inherit\";s:16:\"substitute_audio\";s:7:\"inherit\";s:16:\"substitute_video\";s:7:\"inherit\";s:10:\"body_style\";s:7:\"inherit\";s:8:\"bg_color\";s:7:\"inherit\";s:10:\"bg_pattern\";s:7:\"inherit\";s:17:\"bg_custom_pattern\";s:7:\"inherit\";s:8:\"bg_image\";s:7:\"inherit\";s:15:\"bg_custom_image\";s:7:\"inherit\";s:24:\"bg_custom_image_position\";s:7:\"inherit\";s:13:\"show_video_bg\";s:7:\"inherit\";s:21:\"video_bg_youtube_code\";s:7:\"inherit\";s:12:\"video_bg_url\";s:7:\"inherit\";s:10:\"blog_style\";s:7:\"inherit\";s:11:\"hover_style\";s:7:\"inherit\";s:9:\"hover_dir\";s:7:\"inherit\";s:18:\"dedicated_location\";s:7:\"inherit\";s:12:\"show_filters\";s:7:\"inherit\";s:9:\"blog_sort\";s:7:\"inherit\";s:10:\"blog_order\";s:7:\"inherit\";s:14:\"posts_per_page\";s:7:\"inherit\";s:13:\"show_top_page\";s:7:\"inherit\";s:15:\"show_page_title\";s:7:\"inherit\";s:16:\"show_breadcrumbs\";s:7:\"inherit\";s:16:\"show_sidebar_top\";s:7:\"inherit\";s:11:\"sidebar_top\";s:7:\"inherit\";s:17:\"show_sidebar_main\";s:7:\"inherit\";s:12:\"sidebar_main\";s:7:\"inherit\";s:19:\"show_sidebar_footer\";s:7:\"inherit\";s:20:\"sidebar_footer_style\";s:7:\"inherit\";s:14:\"sidebar_footer\";s:7:\"inherit\";s:18:\"show_sidebar_panel\";s:7:\"inherit\";s:13:\"sidebar_panel\";s:7:\"inherit\";s:12:\"single_style\";s:7:\"inherit\";s:19:\"show_featured_image\";s:7:\"inherit\";s:15:\"show_post_title\";s:7:\"inherit\";s:25:\"show_post_title_on_quotes\";s:7:\"inherit\";s:14:\"show_post_info\";s:7:\"inherit\";s:16:\"show_post_author\";s:7:\"inherit\";s:14:\"show_post_tags\";s:7:\"inherit\";s:18:\"show_post_counters\";s:7:\"inherit\";s:17:\"show_post_related\";s:7:\"inherit\";s:18:\"post_related_count\";s:7:\"inherit\";s:18:\"show_post_comments\";s:7:\"inherit\";s:11:\"slider_show\";s:7:\"inherit\";s:14:\"slider_display\";s:7:\"inherit\";s:13:\"slider_engine\";s:7:\"inherit\";s:12:\"slider_alias\";s:7:\"inherit\";s:13:\"slider_height\";s:7:\"inherit\";s:15:\"slider_category\";s:7:\"inherit\";s:12:\"slider_posts\";s:7:\"inherit\";s:14:\"slider_orderby\";s:7:\"inherit\";s:12:\"slider_order\";s:7:\"inherit\";s:15:\"slider_info_box\";s:7:\"inherit\";s:17:\"slider_info_fixed\";s:7:\"inherit\";s:20:\"slider_info_category\";s:7:\"inherit\";s:14:\"slider_reviews\";s:7:\"inherit\";s:19:\"slider_descriptions\";s:7:\"inherit\";s:14:\"googlemap_show\";s:7:\"inherit\";s:16:\"googlemap_height\";s:7:\"inherit\";s:17:\"googlemap_address\";s:7:\"inherit\";s:16:\"googlemap_latlng\";s:7:\"inherit\";s:14:\"googlemap_zoom\";s:7:\"inherit\";s:15:\"googlemap_style\";s:7:\"inherit\";s:12:\"show_reviews\";s:7:\"inherit\";s:17:\"reviews_criterias\";s:7:\"inherit\";}", "yes");
INSERT INTO `apprenz_options` VALUES("5702", "themerex_options_category_29", "a:106:{s:10:\"theme_skin\";s:3:\"car\";s:14:\"show_top_panel\";s:7:\"inherit\";s:15:\"show_left_panel\";s:7:\"inherit\";s:16:\"show_right_panel\";s:7:\"inherit\";s:18:\"right_panel_button\";s:7:\"inherit\";s:15:\"right_panel_tab\";s:7:\"inherit\";s:11:\"theme_color\";s:7:\"inherit\";s:10:\"custom_css\";s:7:\"inherit\";s:11:\"custom_code\";s:7:\"inherit\";s:10:\"menu_style\";s:7:\"inherit\";s:13:\"menu_position\";s:7:\"inherit\";s:10:\"menu_align\";s:7:\"inherit\";s:10:\"menu_color\";s:7:\"inherit\";s:10:\"menu_width\";s:7:\"inherit\";s:9:\"logo_icon\";s:7:\"inherit\";s:9:\"logo_text\";s:7:\"inherit\";s:10:\"logo_image\";s:7:\"inherit\";s:11:\"logo_height\";s:7:\"inherit\";s:11:\"logo_offset\";s:7:\"inherit\";s:10:\"logo_align\";s:7:\"in