<?php

class ffItemPartCollection extends ffCollectionAdvanced {

	protected $_itemPartName = null;


	public function setItemPartName( $itemPartName ) {
		$this->_itemPartName = $itemPartName;
	}

	public function loadAllItems() {
		$WPOptions = $this->_getWPOptions();

		$allItemNames = $WPOptions->getAllOptionsForNamespace();
		$allItemNames = $this->_makeSureDefaultItemExists( $allItemNames );

		foreach( $allItemNames as $oneItemName ) {

			$oneItemContent = $WPOptions->getOptionCodedJson($oneItemName, null );
			$this->addItem( $oneItemContent, $oneItemName );
		}
	}

	public function setDataForItem( $itemId, $name = null, $options = null, $builder = null ) {
		$item = $this->getItemFromDb( $itemId );

		if( $item == null ) {
			$item = array();
		}

		if( $name != null ) { $item['name'] = $name;}
		if( $options != null ) { $item['options'] = $options;}
		if( $builder != null ) { $item['builder'] = $builder;}


		$this->_getWPOptions()->setOptionCodedJson( $itemId, $item );
	}

	public function getItemById($id) {
		if( $this->offsetExists( $id )  ){
			return parent::getItemById($id); // TODO: Change the autogenerated stub
		} else {
			$item = $this->getItemFromDb( $id );
			$this->addItem( $item, $id );
			return parent::getItemById( $id );
		}
	}

	public function getItemName( $id ) {
		return $this->getItemParam( $id, 'name');
	}

	public function getItemOptions( $id ) {
		return $this->getItemParam( $id, 'options');
	}

	public function getItemBuilder( $id ) {
		return $this->getItemParam( $id, 'builder');
	}

	public function setItemName( $id, $name ) {
		$this->setDataForItem( $id, $name );
	}

	public function setItemOptions( $id, $options ) {
		$this->setDataForItem( $id, null, $options );
	}

	public function setItemBuilder( $id, $builder ) {
		$this->setDataForItem( $id, null, null, $builder );
	}

	public function getItemParam( $id, $param ) {
		$item = $this->getItemById( $id );
		if( isset( $item[ $param ] ) ) {
			return $item[ $param ];
		} else {
			return null;
		}
	}

	public function getItemFromDb( $itemId ) {
		return $this->_getWPOptions()->getOptionCodedJson( $itemId, null );
	}

	/**
	 * @return ffDataStorage_WPOptions_NamespaceFacede
	 */
	private function _getWPOptions() {
		$WPOptions = ffContainer()->getDataStorageFactory()->createDataStorageWPOptionsNamespace();
		$WPOptions->setNamespace( $this->_itemPartName );

		return $WPOptions;
	}

	private function _insertDefaultItem() {
		$defaultItem = $this->_getDefaultItem();

		$this->_getWPOptions()->setOptionCodedJson( $this->_itemPartName .'_default', $defaultItem );
	}

	private function _makeSureDefaultItemExists( $allItems ) {
		$defaultItemExists = false;
		foreach( $allItems as $oneItem ) {
			if( $this->_itIsDefaultItem( $oneItem ) ) {
				$defaultItemExists = true;
				break;
			}
		}

		if( $defaultItemExists == false)  {
			$this->_insertDefaultItem();
			array_unshift( $allItems, $this->_itemPartName .'_default');


		}

		return $allItems;
	}

	private function _itIsDefaultItem($oneItemName) {
		if( $oneItemName == $this->_itemPartName. '_default' ) {
			return true;
		} else {
			return false;
		}

	}

	protected function _getDefaultItem() {
		$defaultItem = array();

		$defaultItem['name'] = $this->_itemPartName . ' Default';
		$defaultItem['options'] = array();
		$defaultItem['builder'] = '[ffb_section_0][/ffb_section_0]';

		return $defaultItem;
	}

}